#import <Foundation/NSXMLNode.h>

@interface NSXMLDocument : NSXMLNode 
/*initWithData:options:error:

Initializes and returns an NSXMLDocument object created from an NSData object.

- (id)initWithData:(NSData *)data options:(unsigned int)mask error:(NSError **)error
Parameters
data

A data object with XML content.
mask

A bit mask for input options. You can specifying multiple options by bit-OR'ing them. See “Constants” for a list of valid input options.
error

An error object that, on return, identifies any parsing errors and warnings or connection problems. 
Return Value

An initialized NSXMLDocument object, or nil if initialization fails because of parsing errors or other reasons. 
Discussion

This method is the designated initializer for the NSXMLDocument class.

If you specify NSXMLDocumentTidyXML as one of the options, NSXMLDocument performs several clean-up operations on the document XML (such as removing leading tabs). It does however, respect the xmlns:space="preserve" attribute when it attempts to tidy the XML.
Availability
Available in Mac OS X v10.4 and later.
See Also
– initWithContentsOfURL:options:error:
– initWithRootElement:
– initWithXMLString:options:error:*/
- (id)initWithData:(NSData *)data options:(unsigned int)mask error:(NSError **)error;

/*XMLData

Returns the XML string representation of the receiver—that is, the entire document—encapsulated in a data object. 

- (NSData *)XMLData
Discussion

This method invokes XMLDataWithOptions: with an option of NSXMLNodeOptionsNone. The encoding used is based on the value returned from characterEncoding or UTF-8 if no valid encoding is returned by that method. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– XMLDataWithOptions:*/
- (NSData *)XMLData;

/*initWithXMLString:options:error:

Initializes and returns an NSXMLDocument object created from a string containing XML markup text.

- (id)initWithXMLString:(NSString *)string options:(unsigned int)mask error:(NSError **)error
Parameters
string

A string object containing XML markup text.
mask

A bit mask for input options. You can specifying multiple options by bit-OR'ing them. See “Constants” for a list of valid input options.
error

An error object that, on return, identifies any parsing errors and warnings or connection problems. 
Return Value

An initialized NSXMLDocument object, or nil if initialization fails because of parsing errors or other reasons. 
Discussion

The encoding of the document is set to UTF-8. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– initWithContentsOfURL:options:error:
– initWithData:options:error:
– initWithRootElement:*/
- (id)initWithXMLString:(NSString *)string options:(unsigned int)mask error:(NSError **)error;
@end
