#ifndef MACWINDOW_H
#define MACWINDOWS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef APPEARANCE_H
#include <HIToolbox/Appearance.h>
#endif

#ifndef DRAG_H
#include <HIToolbox/Drag.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif

#ifndef HITOOLBAR_H
#include <HIToolbox/HIToolbar.h>
#endif

#ifndef HIGEOMETRY_H
#include <HIToolbox/HIGeometry.h>
#endif

#include <HYS/HIToolbox/MacWindows.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*System 7 Window Positioning Constants

Define window positioning constants used in 'WIND', 'DLOG', or 'ALRT' resources, as well as the StandardAlert function. 

enum {
   kWindowNoPosition = 0x0000,
   kWindowDefaultPosition = 0x0000,
   kWindowCenterMainScreen = 0x280A,
   kWindowAlertPositionMainScreen = 0x300A,
   kWindowStaggerMainScreen = 0x380A,
   kWindowCenterParentWindow = 0xA80A,
   kWindowAlertPositionParentWindow = 0xB00A,
   kWindowStaggerParentWindow = 0xB80A,
   kWindowCenterParentWindowScreen = 0x680A,
   kWindowAlertPositionParentWindowScreen = 0x700A,
   kWindowStaggerParentWindowScreen = 0x780A
};
Constants
kWindowNoPosition

No position.

Available in Mac OS X v10.0 and later.
kWindowDefaultPosition

Use the initial location.

Available in Mac OS X v10.0 and later.
kWindowCenterMainScreen

Center the window on the main screen.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionMainScreen

Place the window in the alert position on the main screen.

Available in Mac OS X v10.0 and later.
kWindowStaggerMainScreen

Stagger the window on the main screen.

Available in Mac OS X v10.0 and later.
kWindowCenterParentWindow

Center the window on the parent window.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionParentWindow

Place the window in the alert position on the parent window.

Available in Mac OS X v10.0 and later.
kWindowStaggerParentWindow

Stagger the window relative to the parent window.

Available in Mac OS X v10.0 and later.
kWindowCenterParentWindowScreen

Center the window on the parent window screen.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionParentWindowScreen

Place the window in the alert position on the parent window screen.

Available in Mac OS X v10.0 and later.
kWindowStaggerParentWindowScreen

Stagger the window on the parent window screen.

Available in Mac OS X v10.0 and later.
Discussion

You can use these constants in the optional positioning specification field of the window resource and in the dialog resource to override the window position established by the rectangle specified for the window or dialog. These positioning constants are convenient when the user is creating new documents or when you are handling your own dialog boxes and alert boxes. 

These constants are passed into the StandardAlert function and are used in' WIND', 'DLOG’, and 'ALRT' templates. StandardAlert uses zero to specify the default position. Other calls use zero to specify “no position”. 

Do not pass these constants to theRepositionWindow function or store these constants in the BasicWindowDescription structure of a 'WIND' resource. 

The meaning of the terms used in the window positioning constant descriptions are as follows:
center

Centered both horizontally and vertically, relative either to a screen or to another window (if a window to be centered relative to another window is wider than the window that preceded it, it is pinned to the left edge; a narrower window is centered) 
stagger

Located 20 pixels to the right and 20 pixels below the upper-left corner of the last window (in the case of staggering relative to a screen, the first window is placed just below the menu bar at the left edge of the screen, and subsequent windows are placed on that screen relative to the first window)
alert position

Centered horizontally and placed in the “alert position” vertically, that is, with about one-fifth of the window or screen above the new window and the rest below 
parent window

Place in the position of the window in which the user was last working based on the frontmost window before the new window comes up.*/
enum {
   kWindowNoPosition = 0x0000,
   kWindowDefaultPosition = 0x0000,
   kWindowCenterMainScreen = 0x280A,
   kWindowAlertPositionMainScreen = 0x300A,
   kWindowStaggerMainScreen = 0x380A,
   kWindowCenterParentWindow = 0xA80A,
   kWindowAlertPositionParentWindow = 0xB00A,
   kWindowStaggerParentWindow = 0xB80A,
   kWindowCenterParentWindowScreen = 0x680A,
   kWindowAlertPositionParentWindowScreen = 0x700A,
   kWindowStaggerParentWindowScreen = 0x780A
};

/*WindowRef

Represents a window. 

typedef WindowPtr WindowRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef WindowPtr WindowRef;

/*Window Position Constants

Define where to place a window.

typedef UInt32 WindowPositionMethod;
enum {
   kWindowCenterOnMainScreen = 1,
   kWindowCenterOnParentWindow = 2,
   kWindowCenterOnParentWindowScreen = 3,
   kWindowCascadeOnMainScreen = 4,
   kWindowCascadeOnParentWindow = 5,
   kWindowCascadeOnParentWindowScreen = 6,
   kWindowCascadeStartAtParentWindowScreen = 10,
   kWindowAlertPositionOnMainScreen = 7,
   kWindowAlertPositionOnParentWindow = 8,
   kWindowAlertPositionOnParentWindowScreen = 9
};
Constants
kWindowCenterOnMainScreen

Center the window, both horizontally and vertically, on the screen that contains the menu bar.

Available in Mac OS X v10.0 and later.
kWindowCenterOnParentWindow

Center the window, both horizontally and vertically, on the parent window. If the window to be centered is wider than the parent window, its left edge is aligned with the parent window’s left edge. 

Available in Mac OS X v10.0 and later.
kWindowCenterOnParentWindowScreen

Center the window, both horizontally and vertically, on the screen containing the parent window. On Mac OS X v10.3 and later, the parent window may be the same as the positioned window. On CarbonLib and earlier versions of Mac OS X, the parent window must be different from the positioned window.

Available in Mac OS X v10.0 and later.
kWindowCascadeOnMainScreen

Place the window just below the menu bar at the left edge of the main screen. Subsequent windows are placed on the screen relative to the first window, such that the frame of the preceding window remains visible behind the current window. The exact amount by which windows are offset depends upon the dimensions of the window frame under a given appearance.

Available in Mac OS X v10.0 and later.
kWindowCascadeOnParentWindow

Place the window a distance below and to the right of the upper-left corner of the parent window such that the frame of the parent window remains visible behind the current window. The exact amount by which windows are offset depends upon the dimensions of the window frame under a given appearance.

Available in Mac OS X v10.0 and later.
kWindowCascadeOnParentWindowScreen

Place the window just below the menu bar at the left edge of the screen containing the parent window. Subsequent windows are placed on the screen relative to the first window, such that the frame of the preceding window remains visible behind the current window. The exact amount by which windows are offset depends upon the dimensions of the window frame under a given appearance. On Mac OS X v10.3 and later, the parent window may be the same as the positioned window. On CarbonLib and earlier versions of Mac OS X, the parent window must be different from the positioned window.

Available in Mac OS X v10.0 and later.
kWindowCascadeStartAtParentWindowScreen

Cascade the window on the screen containing the largest portion of its parent window, starting below and to the right of its parent window. The parent window must be different from the positioned window. (Available in Mac OS X v10.2 and CarbonLib 1.6 and later.)

Available in Mac OS X v10.2 and later.
kWindowAlertPositionOnMainScreen

Center the window horizontally and position it vertically on the screen that contains the menu bar, such that about one-fifth of the screen is above it. On Mac OS X v10.3 and later, the parent window may be the same as the positioned window. On CarbonLib and earlier versions of Mac OS X, the parent window must be different from the positioned window.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionOnParentWindow

Center the window horizontally and position it vertically such that about one-fifth of the parent window is above it.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionOnParentWindowScreen

Center the window horizontally and position it vertically such that about one-fifth of the screen containing the parent window is above it.

Available in Mac OS X v10.0 and later.
Discussion

To specify the factors that determine how a window should be positioned, you supply one of these WindowPositionMethod constants to the function RepositionWindow or in the BasicWindowDescription structure of a resource of type ‘wind’. Do not confuse the WindowPositionMethod constants with the pre–Mac OS 8.5 Window Manager window positioning constants or use the WindowPositionMethod constants where the older constants are required (such as in the StandardAlert function or in 'WIND', 'DLOG', or 'ALRT' resources).*/

typedef UInt32 WindowPositionMethod;
enum {
   kWindowCenterOnMainScreen = 1,
   kWindowCenterOnParentWindow = 2,
   kWindowCenterOnParentWindowScreen = 3,
   kWindowCascadeOnMainScreen = 4,
   kWindowCascadeOnParentWindow = 5,
   kWindowCascadeOnParentWindowScreen = 6,
   kWindowCascadeStartAtParentWindowScreen = 10,
   kWindowAlertPositionOnMainScreen = 7,
   kWindowAlertPositionOnParentWindow = 8,
   kWindowAlertPositionOnParentWindowScreen = 9
};

/*CGrafPtr

Defines a CGrafPtr. 

typedef GrafPtr CGrafPtr;
Availability
Available in Mac OS X v10.0 and later*/
typedef GrafPtr CGrafPtr;

/*GWorldPtr

Defines a pointer to a structure that your application can use to refer to the offscreen graphics world. 

typedef CGrafPtr GWorldPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef CGrafPtr GWorldPtr;

/*Window Attributes

Define standard window attributes. 

typedef UInt32 WindowAttributes;
enum {
   kWindowNoAttributes = 0,
   kWindowCloseBoxAttribute = (1L << 0),
   kWindowHorizontalZoomAttribute = (1L << 1),
   kWindowVerticalZoomAttribute = (1L << 2),
   kWindowFullZoomAttribute = (kWindowVerticalZoomAttribute | kWindowHorizontalZoomAttribute),
   kWindowCollapseBoxAttribute = (1L << 3),
   kWindowResizableAttribute = (1L << 4),
   kWindowSideTitlebarAttribute = (1L << 5),
   kWindowToolbarButtonAttribute = (1L << 6),
   kWindowMetalAttribute = (1L << 8),
   kWindowNoTitleBarAttribute = (1L << 9),
   kWindowMetalNoContentSeparatorAttribute = (1L << 11),
   kWindowDoesNotCycleAttribute = (1L << 15),
   kWindowNoUpdatesAttribute = (1L << 16),
   kWindowNoActivatesAttribute = (1L << 17),
   kWindowOpaqueForEventsAttribute = (1L << 18),
   kWindowCompositingAttribute = (1L << 19),
   kWindowFrameworkScaledAttribute = (1L << 20),
   kWindowNoShadowAttribute = (1L << 21),
   kWindowAsyncDragAttribute = (1L << 23),
   kWindowHideOnSuspendAttribute = (1L << 24),
   kWindowStandardHandlerAttribute = (1L << 25),
   kWindowHideOnFullScreenAttribute = (1L << 26),
   kWindowInWindowMenuAttribute = (1L << 27),
   kWindowLiveResizeAttribute = (1L << 28),
   kWindowIgnoreClicksAttribute = (1L << 29),
   kWindowApplicationScaledAttribute = (1L << 30),
   kWindowNoConstrainAttribute = (unsigned long)(1L << 31),
   kWindowStandardDocumentAttributes = (kWindowCloseBoxAttribute | kWindowFullZoomAttribute
| kWindowCollapseBoxAttribute | kWindowResizableAttribute),
   kWindowStandardFloatingAttributes = (kWindowCloseBoxAttribute | kWindowCollapseBoxAttribute)
};
Constants
kWindowNoAttributes

If no bits are set, the window has none of the following attributes.

Available in Mac OS X v10.0 and later.
kWindowCloseBoxAttribute

If the bit specified by this mask is set, the window has a close box. This attribute is available for windows of the kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowHorizontalZoomAttribute

If the bit specified by this mask is set, the window changes width when zooming. This attribute is available for windows of the kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowVerticalZoomAttribute

If the bit specified by this mask is set, the window changes height when zooming. This attribute is available for windows of kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowFullZoomAttribute

If the bits specified by this mask are set, the window changes both width and height when zooming. This attribute is available for windows of the kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowCollapseBoxAttribute

If the bit specified by this mask is set, the window has a collapse box. This attribute is available for windows of the kDocumentWindowClass class and, on Mac OS 9, the kFloatingWindowClass and kUtilityWindowClass class. On Mac OS X, this attribute is not available for windows of the kFloatingWindowClass and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowResizableAttribute

If the bit specified by this mask is set, the window has a resize tab or box and is resizable. This attribute is available for windows of the kDocumentWindowClass, kMovableModalWindowClass, kFloatingWindowClass, kUtilityWindowClass, and kSheetWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowSideTitlebarAttribute

If the bit specified by this mask is set, the window has a side title bar. This attribute is available for windows of the kFloatingWindowClass and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowToolbarButtonAttribute

If the bit specified by this mask is set, the window has a toolbar button. This oblong clear button shows and hides the toolbar. This attribute is available for windows of the kDocumentWindowClass class on Mac OS X. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.1 and later.
kWindowMetalAttribute

If the bit specified by this mask is set, the window has a brushed-metal appearance. This attribute is available for document windows on Mac OS X v10.2 and later, and for floating windows on Mac OS X v10.3 and later. Drawers can also be metal, but dynamically adjust their appearance based on their parent window’s appearance; it is not necessary to specify this attribute for a metal drawer.

Available in Mac OS X v10.2 and later.
kWindowNoTitleBarAttribute

If the bit specified by this mask is set, the window’s title bar can be hidden. This attribute is available for windows of the kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class on Mac OS X v10.4 and later. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.4 and later.
kWindowMetalNoContentSeparatorAttribute

If the bit specified by this mask is set, no border is drawn between the toolbar and window content. This attribute is available in Mac OS X v10.4 and later and is relevant only in metal windows; it is ignored in non-metal windows.

Available in Mac OS X v10.4 and later.
kWindowDoesNotCycleAttribute

If the bit specified by this mask is set, the window does not participate in window cycling invoked by Command-~ or the “Focus on Window” hot key defined in the Keyboards preference pane. This attribute is available for all windows on Mac OS X v10.2 and later.

Available in Mac OS X v10.3 and later.
kWindowNoUpdatesAttribute

If the bit specified by this mask is set, the window does not receive update events. This attribute is available for all windows.

Available in Mac OS X v10.0 and later.
kWindowNoActivatesAttribute

If the bit specified by this mask is set, the window does not receive activate events. This attribute is available for all windows.

Available in Mac OS X v10.0 and later.
kWindowOpaqueForEventsAttribute

If the bit specified by this mask is set, the window receives mouse events even for areas of the window that are transparent (that is, have an alpha channel component of zero). This attribute is available for windows of kOverlayWindowClass on Mac OS X v10.0 and v10.1, and available for all windows on Mac OS X v10.2 and later. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.0 and later.
kWindowCompositingAttribute

If the bit specified by this mask is set, the window uses HIView-based compositing, which means that the entire window is comprised of HIViews, and can be treated thusly. This attribute must be specified at window creation; the ChangeWindowAttributes function cannot be used to add this attribute after the window has been created. This attribute is available on Mac OS X v10.2 and later.

Available in Mac OS X v10.2 and later.
kWindowFrameworkScaledAttribute

If the bit specified by this mask is set, this window’s content is scaled to match the display scale factor. This attribute can only be used when kWindowCompositingAttribute is also enabled. When this attribute is enabled, you may not draw with QuickDraw in the window. If this attribute is enabled and if the scale factor is something other than 1.0, the window’s scale mode is kHIWindowScaleModeFrameworkScaled. If you specify this attribute and kWindowApplicationScaledAttribute, the kWindowApplicationScaledAttribute is ignored. You may only specify this attribute at window creation time. This attribute is available for all windows in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kWindowNoShadowAttribute

If the bit specified by this mask is set, the window has no shadow. This attribute is available for all windows on Mac OS X and is given automatically to windows of the kOverlayWindowClass class. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.0 and later.
kWindowHideOnSuspendAttribute

If the bit specified by this mask is set, the window is hidden automatically on suspend and shown on resume. This attribute available for all windows and is given automatically to windows of class kFloatingWindowClass, kHelpWindowClass, and kToolbarWindowClass. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowAsyncDragAttribute

If the bit specified by this mask is set, the window server drags the window automatically. Your application should not call DragWindow for this window because DragWindow would fight with the Window Server for control. This attribute is ignored if the window is grouped with other windows in a window group that has the kWindowGroupAttrMoveTogether attribute. (Available for all windows on Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kWindowStandardHandlerAttribute

If the bit specified by this mask is set, the window supports the standard window event handler. The standard event handler provides standard actions for common window events. See Carbon Event Manager Programming Guide for more details. This attribute is available for all windows.

Available in Mac OS X v10.0 and later.
kWindowHideOnFullScreenAttribute

If the bit specified by this mask is set, the window is automatically hidden during fullscreen mode (when the menubar is invisible) and shown afterwards. Available for all windows. This attribute is automatically given to windows of the kUtilityWindowClass class. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.0 and later.
kWindowInWindowMenuAttribute

If the bit specified by this mask is set, the window title appears in the system-generated Window menu. This attribute is only available for windows of the kDocumentWindowClass class and is automatically given to windows of that class. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.0 and later.
kWindowLiveResizeAttribute

If the bit specified by this mask is set, the window supports live resizing. This attribute is available to all windows on Mac OS X.

Available in Mac OS X v10.0 and later.
kWindowIgnoreClicksAttribute

If the bit specified by this mask is set, the window never receives mouse events, even in areas that are opaque. Instead, clicks on the window are passed through to windows beneath it. This attribute is available for all windows on Mac OS X v10.2 and later.

Available in Mac OS X v10.2 and later.
kWindowApplicationScaledAttribute

If the bit specified by this mask is set, the details of resolution-independent scaling will be taken care of primarily by the application. This attribute is valid for compositing and non-compositing windows. Resolution-independent windows that draw with QuickDraw must use this attribute. If this attribute is enabled and if the scale factor is something other than 1.0, the window’s scale mode is kHIWindowScaleModeApplicationScaled. If you specify this attribute and kWindowFrameworkScaledAttribute, this attribute is ignored. You may only specify this attribute at window creation time. This attribute is available for all windows in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kWindowNoConstrainAttribute

If the bit specified by this mask is set, the window is not repositioned by the default kEventWindowConstrain handler in response to changes in monitor size, Dock position, and so on. This attribute is available for all windows on Mac OS X v10.1 and later, and CarbonLib v1.6 and later.

Available in Mac OS X v10.1 and later.
kWindowStandardDocumentAttributes

If the bits specified by this mask are set, the window has the attributes of a standard document window—that is, a close box, full zoom box, collapse box, and size box.

Available in Mac OS X v10.0 and later.
kWindowStandardFloatingAttributes

If the bits specified by this mask are set, the window has the attributes of a standard floating window—that is, a close box and collapse box.

Available in Mac OS X v10.0 and later.
Discussion

The WindowAttributes enumeration defines masks your application can use to set or test window feature bits. You can use these masks with the function CreateNewWindow to set window feature bits, thereby defining a window’s attributes, and with the function ChangeWindowAttributes to change a window’s attributes. You can also use these masks to test the window feature bits produced by the function GetWindowAttributes, thereby obtaining a window’s attributes.*/
typedef UInt32 WindowAttributes;
enum {
   kWindowNoAttributes = 0,
   kWindowCloseBoxAttribute = (1L << 0),
   kWindowHorizontalZoomAttribute = (1L << 1),
   kWindowVerticalZoomAttribute = (1L << 2),
   kWindowFullZoomAttribute = (kWindowVerticalZoomAttribute | kWindowHorizontalZoomAttribute),
   kWindowCollapseBoxAttribute = (1L << 3),
   kWindowResizableAttribute = (1L << 4),
   kWindowSideTitlebarAttribute = (1L << 5),
   kWindowToolbarButtonAttribute = (1L << 6),
   kWindowMetalAttribute = (1L << 8),
   kWindowNoTitleBarAttribute = (1L << 9),
   kWindowMetalNoContentSeparatorAttribute = (1L << 11),
   kWindowDoesNotCycleAttribute = (1L << 15),
   kWindowNoUpdatesAttribute = (1L << 16),
   kWindowNoActivatesAttribute = (1L << 17),
   kWindowOpaqueForEventsAttribute = (1L << 18),
   kWindowCompositingAttribute = (1L << 19),
   kWindowFrameworkScaledAttribute = (1L << 20),
   kWindowNoShadowAttribute = (1L << 21),
   kWindowAsyncDragAttribute = (1L << 23),
   kWindowHideOnSuspendAttribute = (1L << 24),
   kWindowStandardHandlerAttribute = (1L << 25),
   kWindowHideOnFullScreenAttribute = (1L << 26),
   kWindowInWindowMenuAttribute = (1L << 27),
   kWindowLiveResizeAttribute = (1L << 28),
   kWindowIgnoreClicksAttribute = (1L << 29),
   kWindowApplicationScaledAttribute = (1L << 30),
   kWindowNoConstrainAttribute = (unsigned long)(1L << 31),
   kWindowStandardDocumentAttributes = (kWindowCloseBoxAttribute | kWindowFullZoomAttribute
| kWindowCollapseBoxAttribute | kWindowResizableAttribute),
   kWindowStandardFloatingAttributes = (kWindowCloseBoxAttribute | kWindowCollapseBoxAttribute)
};

/*Window Region Constants

Define various window regions. 

typedef UInt16 WindowRegionCode;
enum {
   kWindowTitleBarRgn = 0,
   kWindowTitleTextRgn = 1,
   kWindowCloseBoxRgn = 2,
   kWindowZoomBoxRgn = 3,
   kWindowDragRgn = 5,
   kWindowGrowRgn = 6,
   kWindowCollapseBoxRgn = 7,
   kWindowTitleProxyIconRgn = 8,
   kWindowStructureRgn = 32,
   kWindowContentRgn = 33,
   kWindowUpdateRgn = 34,
   kWindowOpaqueRgn = 35,
   kWindowGlobalPortRgn = 40,
   kWindowToolbarButtonRgn = 41
};
Constants
kWindowTitleBarRgn

The entire area occupied by a window’s title bar, including the title text region.

Available in Mac OS X v10.0 and later.
kWindowTitleTextRgn

That portion of a window’s title bar that is occupied by the name of the window.

Available in Mac OS X v10.0 and later.
kWindowCloseBoxRgn

The area occupied by a window’s close box.

Available in Mac OS X v10.0 and later.
kWindowZoomBoxRgn

The area occupied by a window’s zoom box.

Available in Mac OS X v10.0 and later.
kWindowDragRgn

The draggable area of the window frame; this area includes the title bar and window outline and excludes the size box, close box, zoom box, and collapse box.

Available in Mac OS X v10.0 and later.
kWindowGrowRgn

The area occupied by a window’s size box.

Available in Mac OS X v10.0 and later.
kWindowCollapseBoxRgn

The area occupied by a window’s collapse box. 

Available in Mac OS X v10.0 and later.
kWindowTitleProxyIconRgn

Specifies the region in the window’s title area that contains the proxy icon. The proxy icon region is always located within the window’s title text region.

Available in Mac OS X v10.0 and later.
kWindowStructureRgn

The entire area occupied by a window, including the frame and content region; the window may be partially off-screen but its structure region does not change.

Available in Mac OS X v10.0 and later.
kWindowContentRgn

The window’s content region—the part of a window in which your application displays the contents of the window or dialog, including the size box and any controls. 

Available in Mac OS X v10.0 and later.
kWindowUpdateRgn

The window’s update region––the part of the window that needs to be redrawn. 

Available in Mac OS X v10.0 and later.
kWindowOpaqueRgn

Area of window considered to be opaque. Only valid for windows with alpha channels. (Mac OS X only)

Available in Mac OS X v10.0 and later.
kWindowGlobalPortRgn

Bounds of the window’s port in global coordinates; not affected by CollapseWindow.

Available in Mac OS X v10.0 and later.
kWindowToolbarButtonRgn

Bounds of the toolbar button area. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
Discussion

You can pass constants of type WindowRegionCode in the inRegionCode parameter of GetWindowRegion to obtain a handle to a specific window region. The WindowRegionCode constants are available with Appearance Manager 1.0 and later. 
Version Notes

With the Window Manager in Mac OS 8.5 and later, you may pass the kWindowTitleProxyIconRgn, kWindowStructureRgn, and kWindowContentRgn constants to the function GetWindowRegion.*/
typedef UInt16 WindowRegionCode;
enum {
   kWindowTitleBarRgn = 0,
   kWindowTitleTextRgn = 1,
   kWindowCloseBoxRgn = 2,
   kWindowZoomBoxRgn = 3,
   kWindowDragRgn = 5,
   kWindowGrowRgn = 6,
   kWindowCollapseBoxRgn = 7,
   kWindowTitleProxyIconRgn = 8,
   kWindowStructureRgn = 32,
   kWindowContentRgn = 33,
   kWindowUpdateRgn = 34,
   kWindowOpaqueRgn = 35,
   kWindowGlobalPortRgn = 40,
   kWindowToolbarButtonRgn = 41
};

/*Window Modality Options

Specify the modality of a window. 

typedef UInt32 WindowModality;
enum {
   kWindowModalityNone = 0,
   kWindowModalitySystemModal = 1,
   kWindowModalityAppModal = 2,
   kWindowModalityWindowModal = 3
};
Constants
kWindowModalityNone

A window does not prevent interaction with any other window in the system. 

Available in Mac OS X v10.0 and later.
kWindowModalitySystemModal

The window is system-modal. On Mac OS 9 and earlier, the user cannot perform any other action until the window is dismissed. On Mac OS X, this constant produces the same behavior as kWindowModalityAppModal, so there is no way to prevent the user from interacting with windows from other applications.

Available in Mac OS X v10.0 and later.
kWindowModalityAppModal

The window is application-modal; that is the user cannot perform any other action within the application until the window is dismissed. The user can switch to other applications, however. 

Available in Mac OS X v10.0 and later.
kWindowModalityWindowModal

The window is document-modal; the user cannot perform any other action within the current document window until the modal window associated with it is dismissed. The user can switch to other windows or applications, however. Sheets are document-modal. 

Available in Mac OS X v10.0 and later.*/
typedef UInt32 WindowModality;
enum {
   kWindowModalityNone = 0,
   kWindowModalitySystemModal = 1,
   kWindowModalityAppModal = 2,
   kWindowModalityWindowModal = 3
};

/*Window Class Constants

Indicates the class of a window. 

typedef UInt32 WindowClass;
enum {
   kAlertWindowClass = 1,
   kMovableAlertWindowClass = 2,
   kModalWindowClass = 3,
   kMovableModalWindowClass = 4,
   kFloatingWindowClass = 5,
   kDocumentWindowClass = 6,
   kUtilityWindowClass = 8,
   kHelpWindowClass = 10,
   kSheetWindowClass = 11,
   kToolbarWindowClass = 12,
   kPlainWindowClass = 13,
   kOverlayWindowClass = 14,
   kSheetAlertWindowClass = 15,
   kAltPlainWindowClass = 16,
   kDrawerWindowClass = 20,
   kAllWindowClasses = 0xFFFFFFFF
};
Constants
kAlertWindowClass

Identifies an alert box window. An alert window is used when the application needs the user's attention immediately. On Mac OS 9 and earlier, a visible alert window will prevent the user from switching to any other application. Use kThemeBrushAlertBackgroundActive to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kMovableAlertWindowClass

Identifies a movable alert box window. Generally, you should use this window class rather than kAlertWindowClass. Use kThemeBrushAlertBackgroundActive to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kModalWindowClass

Identifies a modal dialog box window. Use kThemeBrushDialogBackgroundActive to draw the background of modal dialog windows. Modal dialog windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kMovableModalWindowClass

Identifies a movable modal dialog box window. On Mac OS X and CarbonLib 1.3 and later, use kThemeBrushMovableModalBackground to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kFloatingWindowClass

Identifies a window that floats above all document windows. If your application assigns this constant to a window, the Window Manager ensures that the window has the proper floating behavior. Use kThemeBrushUtilityWindowBackgroundActive or kThemeBrushDocumentWindowBackground to draw the background of floating windows. Floating windows are initially placed in the floating window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeIndependent. Supported with Mac OS 8.6 and later.

Available in Mac OS X v10.0 and later.
kDocumentWindowClass

Identifies a document window or modeless dialog box window. Use kThemeBrushDocumentWindowBackground or your own custom drawing to draw the background of a document window. Document windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll.The Window Manager assigns this class to pre–Mac OS 8.5 Window Manager windows.

Available in Mac OS X v10.0 and later.
kUtilityWindowClass

Identifies a utility window. A utility window is similar to a floating window, but it floats above the windows of all applications rather than just above the windows of the application that creates it. Use kThemeBrushUtilityWindowBackgroundActive or kThemeBrushDocumentWindowBackground to draw the background of utility windows. Utility windows are initially placed in the utility window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeIndependent.

Available in CarbonLib 1.1 and later, and in Mac OS X.
kHelpWindowClass

Identifies a window used for help tags. It has no window frame. Typically you should use the Help Manager to display help tags, rather than creating a help tag window yourself. Help windows are initially placed in the help window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone.

Available in CarbonLib 1.1 and later, and in Mac OS X.
kSheetWindowClass

Identifies a sheet. (Mac OS X only.) Use kThemeBrushSheetBackgroundOpaque to draw an opaque background for sheet windows, or kThemeBrushSheetBackgroundTransparent to draw a transparent background (the transparent brush is only available in Mac OS X 10.1 and later). Sheet windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kToolbarWindowClass

Identifies a toolbar window, which is used to display a palette of controls. A toolbar window is similar to a floating window, and like a floating window, is layered above all application windows except for alert and modal windows, but is layered beneath floating windows. Toolbar windows are initially placed in the toolbar window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone. (Available in CarbonLib 1.1 and later, and Mac OS X.)

Available in Mac OS X v10.0 and later.
kPlainWindowClass

Identifies a plain window, which has a single-pixel window frame. Plain windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Available in CarbonLib 1.2.5 and later, and Mac OS X.)

Available in Mac OS X v10.0 and later.
kOverlayWindowClass

Identifies an overlay window, which is a completely transparent window positioned above all other windows. Overlay windows are intended as a replacement for the pre-Carbon practice of drawing directly into the Window Manager port. By creating a full-screen overlay window and drawing into it, you can draw over any window in any application without disturbing the contents of the windows beneath your drawing. Overlay windows have a default handler for kEventWindowPaint that uses CGContextClearRect to clear the overlay window's alpha channel to zero. This ensures the initial transparency of the window. You can install your own kEventWindowPaint handler to do your own drawing; typically, you would call through to the default handler with CallNextEventHandler first, and then use QDBeginCGContext tocreate your own context for drawing. You can use either QuickDraw or Core Graphics to draw into an overlay window, but you must use Core Graphics to draw if you need any of your drawing to be non-opaque, since QuickDraw always sets the alpha channel of any pixels that it touches to 1.0. (QuickDraw is also deprecated in Mac OS X v10.4 and later.) You can also use the standard window event handler together with regular controls in an overlay window. When using the standard window event handler, you will probably want your kEventWindowPaint handler to return eventNotHandledErr (after calling the default handler with CallNextEventHandler first) so that after the Paint handler returns, the Window Manager will send a kEventWindowDrawContent event which the standard window event handler can respond to by drawing the controls in the window. Overlay windows are initially placed in the overlay window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone. (

Available in Mac OS X.)
kSheetAlertWindowClass

Identifies an alert sheet. Use kThemeBrushSheetBackgroundOpaque to draw an opaque background for sheet alert windows, or kThemeBrushSheetBackgroundTransparent to draw a transparent background (the transparent brush is only available in Mac OS X 10.1 and later). Sheet alert windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Mac OS X only.)

Available in Mac OS X v10.1 and later.
kAltPlainWindowClass

Identifies an alternate plain window, which is similar to a plain window but has a solid black shadow on its right and bottom sides. It is rarely used in modern Mac OS applications. Alternate plain windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Available in CarbonLib 1.3 and later and Mac OS X v10.1 and later.)

Available in Mac OS X v10.1 and later.
kDrawerWindowClass

Identifies a drawer. Use kThemeBrushDrawerBackground or kThemeBrushDocumentWindowBackground to draw the background of drawer windows. Drawer windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. Drawer windows should always be created using the compositing window attribute.(Mac OS X v10.2 and later)

Available in Mac OS X v10.2 and later.
kAllWindowClasses

Specifier used to designate all window classes. Used with GetFrontWindowOfClass, FindWindowOfClass, and GetNextWindowOfClass to indicate that there should be no restriction on the class of the returned window. Also used with GetWindowGroupOfClass to get the root window group.

Available in Mac OS X v10.0 and later.
Discussion

The WindowClass constants categorize windows into groups of like types. The grouping of windows facilitates the appropriate display (that is, both the look and the front-to-back ordering) and tracking of windows.

You can define a window’s class using the function CreateNewWindow and obtain a window’s class using the function GetWindowClass. You can change the class of certain windows by calling HIWindowChangeClass.*/
typedef UInt32 WindowClass;
enum {
   kAlertWindowClass = 1,
   kMovableAlertWindowClass = 2,
   kModalWindowClass = 3,
   kMovableModalWindowClass = 4,
   kFloatingWindowClass = 5,
   kDocumentWindowClass = 6,
   kUtilityWindowClass = 8,
   kHelpWindowClass = 10,
   kSheetWindowClass = 11,
   kToolbarWindowClass = 12,
   kPlainWindowClass = 13,
   kOverlayWindowClass = 14,
   kSheetAlertWindowClass = 15,
   kAltPlainWindowClass = 16,
   kDrawerWindowClass = 20,
   kAllWindowClasses = 0xFFFFFFFF
};

/*GetFrontWindowOfClass

Obtains the frontmost window of a given class. 

WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindowClass

The class of the window you want to obtain. If you pass kAllWindowClasses, the function returns the frontmost window in the window list. 
mustBeVisible

If set to true, the function returns the frontmost visible window. If set to false, the function returns the frontmost window of the specified class, regardless of whether the window is visible.
Return Value

A reference to the frontmost window of the class specified by inWindowClass.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes
Declared In
MacWindows.h*/
WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);

/*ShowWindow

Makes an invisible window visible.

void ShowWindow (
   WindowRef window
);
Parameters
window

The window that is to be made visible.
Discussion

The ShowWindow function makes an invisible window visible. If the specified window is already visible, ShowWindow has no effect. Your application typically creates a new window in an invisible state, performs any necessary setup of the content region, and then calls ShowWindow to make the window visible.

When you call ShowWindow to display a window that is invisible, the Window Manager draws the window frame and sends an event to request the application to draw the content region before the window becomes visible. For compositing windows, the Window Manager sends a kEventControlDraw event to each HIView in the window. For non-compositing windows, the Window Manager sends a kEventWindowDrawContent event. If a non-compositing window does not handle the kEventWindowDrawContent, the Window Manager shows the window and generates an update event to request your application to draw the content region.

If the newly visible window is the frontmost window, ShowWindow highlights it if it’s not already highlighted and generates an activate event to make it active. The ShowWindow function does not activate a window that is not frontmost on the desktop.

Because ShowWindow does not change the front-to-back ordering of windows, it is not the inverse of HideWindow. If you make the frontmost window invisible with HideWindow, andHideWindow has activated another window, you must call both ShowWindow and SelectWindow to bring the original window back to the front.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ShowWindow (
   WindowRef window
);

/*SetWindowModified

Sets the modification state of the specified window.

OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);
Parameters
window

The window whose modification state is to be set.
modified

Pass true if the content of the window has been modified; otherwise, pass false.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application can use the functions SetWindowModified and IsWindowModified instead of maintaining its own separate record of the modification state of the content of a window. The modification state of a window is visually represented by a dot in the window’s close box. If the dot is present, the window is modified; if the dot is absent, the window is not modified.

Your application should distinguish between the modification state of the window and the modification state of the window’s contents, typically a document. The modification state of the window contents are what should affect SetWindowModified. For example, in the case of a word processing document, you call SetWindowModified (passing true in the modified parameter) whenever the user types new characters into the document. However, you do not call SetWindowModified when the user moves the window, because that change does not affect the document contents. If you need to track whether the window position has changed, you need to do this with your own flag. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);

/*SetWindowTitleWithCFString

Sets the window title to the contents of a Core Foundation string. 

OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
Parameters
inWindow

The window whose title is to be set.
inString

The title to set. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);

/*DisposeWindow

Removes a window.

void DisposeWindow (
   WindowRef window
);
Parameters
window

On input, the window to be closed.
Discussion

The DisposeWindow function reduces a window’s reference count by one. If the resulting reference count is zero, then DisposeWindow removes the window from the screen and deletes it from the window list, then releases the memory occupied by all structures associated with the window, including the window structure. 

Note that DisposeWindow assumes that any picture pointed to by the window structure field windowPic is data, not a resource, and it calls the QuickDraw function KillPicture to delete it. If your application uses a picture stored as a resource, you must release the resource or release the memory it occupies with the ReleaseResource function and set the windowPic field to NULL before closing the window.

Any pending update events for the window are discarded. If the window being removed is the frontmost window, the window behind it, if any, becomes the active window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DisposeWindow (
   WindowRef window
);

/*SetWindowProxyFSSpec

Associates a file with a window.

Not recommended

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile
);
Parameters
window

A pointer to the window with which the specified file is to be associated. 
inFile

Set the file system specification structure to contain the data for the file to associate with the specified window. You can obtain an FSSpec structure by calling the function GetWindowProxyFSSpec. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application should call the SetWindowProxyFSSpec function to establish a proxy icon for a given window. The creator code and file type of the file associated with a window determine the proxy icon that is displayed for the window.

Because the SetWindowProxyFSSpec function won’t work without a saved file, you must establish the initial proxy icon for a new, untitled window with the function SetWindowProxyCreatorAndType , which requires that you know the file type and creator code for the file, but does not require that the file have been saved.

See also the function SetWindowProxyAlias. 
Special Considerations

With Mac OS 8.5, you must save and restore the current graphics port—by calling the QuickDraw functions GetPort and SetPort—around each call to the SetWindowProxyFSSpec function.
Version Notes

This function is available with Mac OS 8.5 and later.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use of file specifications is no longer recommended. An alternate API that uses FSRef types is preferred.
Declared In
MacWindows.h*/

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile
);

/*SetWindowBounds

Sets a window’s size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the window’s size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The SetWindowBounds function sets a window’s size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the window’s content region or its structure region is more important in determining the window’s ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window—and, therefore, its spatial relationship to the rest of the screen—may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your application’s content is of greatest concern, then it is important to note that with some appearances some part of the window’s structure region or “frame” may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);

/*HideWindow

Makes a window invisible.

void HideWindow (
   WindowRef window
);
Parameters
window

The window that is to be made invisible.
Discussion

The HideWindow function make a visible window invisible. If you hide the frontmost window, HideWindow removes the highlighting, brings the window behind it to the front, highlights the new frontmost window, and generates the appropriate activate events.

To reverse the actions of HideWindow, you must call both ShowWindow, to make the window visible, and SelectWindow, to select it. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void HideWindow (
   WindowRef window
);



/*GetWindowBounds

Obtains the size and position of the bounding rectangle of the specified window region.

OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);
Parameters
window

The window whose bounds you want to obtain.
regionCode

A constant identifying the window region whose bounds you want to obtain. See “Window Region Constants” for a list of possible values.
globalBounds

A pointer to a structure of type Rect. On return, the rectangle contains the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Use the GetWindowBounds function to obtain the bounding rectangle for the specified window region for the specified window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);

/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);

/*CopyWindowTitleAsCFString

Copies the window title into a Core Foundation string.

OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString
);
Parameters
inWindow

The window whose title is to be copied.
outString

On output, the window’s title. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString
);

/*CreateNewWindow

Creates a window from parameter data.

OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
windowClass

A constant that categorizes the class of window to be created. For certain classes, the window class can be altered after the window is created by calling HIWindowChangeClass. See “Window Class Constants” for a description of possible values for this parameter.
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes.
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region.
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateNewWindow function creates a window based on the attributes and class you specify in the attributes and windowClass parameters. CreateNewWindow sets the new window’s content region to the size and location specified by the rectangle passed in the bounds parameter, which in turn determines the dimensions of the entire window. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateNewWindow, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);

/*RepositionWindow

Positions a window relative to another window or a display screen.

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method
);
Parameters
window

The window whose position you want to set.
parentWindow

A pointer to the “parent” window, as defined by your application. In cases where the window positioning method does not require a parent window, you should set the parentWindow parameter to NULL.
method

A constant specifying the window positioning method to be used; see “Window Position Constants” for descriptions of possible values. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application may call the RepositionWindow function to position any window, relative to another window or to a display screen. After positioning the window, RepositionWindow displays the window in its new position.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method
);

/*GetNextWindowOfClass

Obtains the next window in a given window group. 

WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindow

The window at which to start.
inWindowClass

The class of window to obtain. If you pass kAllWindowClasses, the function returns the window directly behind the input window. If no windows exist behind the front window, the function returns NULL. 
mustBeVisible

If set to true, this function returns the next visible window of the specified window class. If set to false, this function returns the next window of the specified window class, regardless of whether it is visible.
Return Value

A reference for the next window of the specified class after the window specified by inWindow.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible
);

/*GetWRefCon

Returns the reference constant from a window.

long GetWRefCon (
   WindowRef window
);
Parameters
window

The window whose reference constant is to be returned.
Return Value

The long integer data stored in the refCon field of the window structure specified in the window parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
long GetWRefCon (
   WindowRef window
);

/*SetWRefCon

Sets the refCon field of a window.

void SetWRefCon (
   WindowRef window,
   long data
);
Parameters
window

The window whose refCon field is to be set.
data

On input, the data to be placed in the refCon field. 
Discussion

The SetWRefCon function places the specified data in the refCon field of the specified window structure. The refCon field is available to your application for any window-related data it needs to store. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWRefCon (
   WindowRef window,
   long data
);

/*HIWindowSetProxyFSRef

Sets the proxy icon for a window using an FSRef to a file system object.

OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);
Parameters
inWindow

The window whose proxy icon is to be set.
inRef

The file system object the window represents.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function determines the window’s proxy icon by asking Icon Services for the icon for the object specified by inRef.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);


#ifdef __cplusplus
}
#endif

#endif