#ifndef CGLTYPES_H
#define CGLTYPES_H
#include <HYS/OpenGL/CGLTypes.h>

#ifdef __cplusplus
extern "C" {
#endif

/*Buffer and Renderer Attributes

Specify attributes used to choose pixel formats and virtual screens.

typedef enum _CGLPixelFormatAttribute {
   kCGLPFAAllRenderers       =   1,
   kCGLPFADoubleBuffer       =   5,
   kCGLPFAStereo             =   6,
   kCGLPFAAuxBuffers         =   7,
   kCGLPFAColorSize          =   8,
   kCGLPFAAlphaSize          =  11,
   kCGLPFADepthSize          =  12,
   kCGLPFAStencilSize        =  13,
   kCGLPFAAccumSize          =  14,
   kCGLPFAMinimumPolicy      =  51,
   kCGLPFAMaximumPolicy      =  52,
   kCGLPFAOffScreen          =  53,
   kCGLPFAFullScreen         =  54,
   kCGLPFASampleBuffers      =  55,
   kCGLPFASamples            =  56,
   kCGLPFAAuxDepthStencil    =  57,
   kCGLPFAColorFloat         =  58,
   kCGLPFAMultisample        =  59,
   kCGLPFASupersample        =  60,
   kCGLPFASampleAlpha        =  61,
   kCGLPFARendererID         =  70,
   kCGLPFASingleRenderer     =  71,
   kCGLPFANoRecovery         =  72,
   kCGLPFAAccelerated        =  73,
   kCGLPFAClosestPolicy      =  74,
   kCGLPFARobust             =  75,
   kCGLPFABackingStore       =  76,
   kCGLPFAMPSafe             =  78,
   kCGLPFAWindow             =  80,
   kCGLPFAMultiScreen        =  81,
   kCGLPFACompliant          =  83,
   kCGLPFADisplayMask        =  84,
   kCGLPFAPBuffer            =  90,
   kCGLPFARemotePBuffer      =  91,
   kCGLPFAVirtualScreenCount = 128,
} CGLPixelFormatAttribute;
Constants
kCGLPFAAllRenderers

If true, pixel format selection is open to all available renderers, including debug and special-purpose renderers that are not OpenGL compliant.

Available in Mac OS X v10.0 and later.
kCGLPFADoubleBuffer

If true, only double-buffered pixel formats are considered. Otherwise, only single-buffered pixel formats are considered.

Available in Mac OS X v10.0 and later.
kCGLPFAStereo

If true, only stereo pixel formats are considered. Otherwise, only monoscopic pixel formats are considered.

Available in Mac OS X v10.0 and later.
kCGLPFAAuxBuffers

The associated value is a nonnegative integer that indicates the desired number of auxiliary buffers. Pixel formats with the smallest number of auxiliary buffers that meet or exceeds the specified number are preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAColorSize

The associated value is a nonnegative buffer size specification. A color buffer that most closely matches the specified size is preferred. If unspecified, OpenGL chooses a color size that matches the screen.

Available in Mac OS X v10.0 and later.
kCGLPFAAlphaSize

The associated value is a nonnegative buffer size specification. An alpha buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFADepthSize

The associated value is a nonnegative depth buffer size specification. A depth buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAStencilSize

The associated value is a nonnegative integer that indicates the desired number of stencil bitplanes. The smallest stencil buffer of at least the specified size is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAAccumSize

The associated value is a nonnegative buffer size specification. An accumulation buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAMinimumPolicy

If true, the pixel format choosing policy is altered for the color, depth, and accumulation buffers such that only buffers of size greater than or equal to the desired size are considered.

Available in Mac OS X v10.0 and later.
kCGLPFAMaximumPolicy

If true, the pixel format choosing policy is altered for the color, depth, and accumulation buffers such that, if a nonzero buffer size is requested, the largest available buffer is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAOffScreen

If true, only renderers that are capable of rendering to an off-screen memory area and have buffer depth exactly equal to the desired buffer depth are considered. The kCGLPFAClosestPolicy attribute is implied.

Available in Mac OS X v10.0 and later.
kCGLPFAFullScreen

If true, only renderers that are capable of rendering to a full-screen drawable object are considered. The kCGLPFASingleRenderer attribute is implied.

Available in Mac OS X v10.0 and later.
kCGLPFAAuxDepthStencil

If true, each auxiliary buffer has its own depth stencil.

Available in Mac OS X v10.2 and later.
kCGLPFAColorFloat

If true, color buffers store floating-point pixels.

Available in Mac OS X v10.3 and later.
kCGLPFAMultisample

If true, choose multisampling.

Available in Mac OS X v10.3 and later.
kCGLPFASupersample

If true, choose supersampling.

Available in Mac OS X v10.3 and later.
kCGLPFASampleAlpha

If true, request alpha filtering.

Available in Mac OS X v10.3 and later.
kCGLPFASampleBuffers

The number of multisample buffers. The associated value is a nonnegative integer that indicates the number of existing independent sample buffers. Typically, the value is 0 if no multi-sample buffer exists or 1. This attribute is not useful in the attribute array.

Available in Mac OS X v10.1 and later.
kCGLPFASamples

The number of samples per multisample buffer. The associated value is a nonnegative integer that indicates the desired number of samples that can be taken within a single pixel. The smallest sample buffer with at least the specified number of samples is preferred.

Available in Mac OS X v10.1 and later.
kCGLPFARendererID

The associated value is a nonnegative renderer ID number and can be any of the constants defined in Renderer IDs. OpenGL renderers that match the specified ID are preferred. Of note is kCGLRendererGenericID which selects the Apple software renderer. The other constants select renderers for specific hardware vendors.

Available in Mac OS X v10.0 and later.
kCGLPFASingleRenderer

If true, a single rendering engine is chosen. On systems with multiple screens, this disables ability of OpenGL to drive different monitors through different graphics accelerator cards with a single context. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFANoRecovery

If true, the OpenGL failure recovery mechanisms are disabled. Normally, if an accelerated renderer fails due to lack of resources, OpenGL automatically switches to another renderer. This attribute disables these features so that rendering is always performed by the chosen renderer. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFAAccelerated

If true, only hardware accelerated renderers are considered. If false, accelerated renderers are still preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAClosestPolicy

If true, the pixel format choosing policy is altered for the color buffer such that the buffer closest to the requested size is preferred, regardless of the actual color buffer depth of the supported graphics device.

Available in Mac OS X v10.0 and later.
kCGLPFARobust

If true, only renderers that do not have any failure modes associated with a lack of video card resources are considered. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFABackingStore

If true, OpenGL only considers renderers that have a back color buffer the full size of the drawable object and that guarantee the back buffer contents to be valid after a call to CGLFlushDrawable.

Available in Mac OS X v10.0 and later.
kCGLPFAMPSafe

If true, OpenGL only considers renderers that are thread-safe. Because all renderers are thread-safe, this attribute is not useful.

Available in Mac OS X v10.0 and later.
kCGLPFAWindow

If true, only renderers that are capable of rendering to a window are considered. This attribute is implied if neither kCGLPFAFullScreen nor kCGLPFAOffScreen is specified. Because CGL only supports full-screen of off-screen drawable objects, this attribute is not useful.

Available in Mac OS X v10.0 and later.
kCGLPFAMultiScreen

If true, only renderers capable of driving multiple screens are considered. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFACompliant

If true, pixel format selection is only open to OpenGL compliant renderers. This attribute is implied unless kCGLPFAAllRenderers is specified. This attribute is not useful in the attribute array.

Available in Mac OS X v10.0 and later.
kCGLPFADisplayMask

The associated value is a bit mask of supported physical screens. All screens specified in the bit mask are guaranteed to be supported by the pixel format. Screens not specified in the bit mask may still be supported. The bit mask is managed by the Quartz Display Services, available in the CGDirectDisplay.h header of the Application Services umbrella framework. A CGDirectDisplayID must be converted to an OpenGL display mask using the function CGDisplayIDToOpenGLDisplayMask. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFAPBuffer

If true, format can be used to render to a Pbuffer.

Available in Mac OS X v10.3 and later.
kCGLPFARemotePBuffer

If true, format can be used to render offline to a Pbuffer.

Available in Mac OS X v10.3 and later.
kCGLPFAVirtualScreenCount

This attribute may be used to obtain the number of virtual screens specified by an existing pixel format object. To retrieve the value, call the function CGLDescribePixelFormat, passing the pixel format object, the virtual screen number 0, and this attribute. This attribute is not useful in the attribute array that's used to create a pixel format object.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used by CGLChoosePixelFormat and CGLDescribePixelFormat. The existence of a Boolean attribute in the attribute array of CGLChoosePixelFormat implies a true value. Other attribute constants must be followed by a value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef enum _CGLPixelFormatAttribute {
   kCGLPFAAllRenderers       =   1,
   kCGLPFADoubleBuffer       =   5,
   kCGLPFAStereo             =   6,
   kCGLPFAAuxBuffers         =   7,
   kCGLPFAColorSize          =   8,
   kCGLPFAAlphaSize          =  11,
   kCGLPFADepthSize          =  12,
   kCGLPFAStencilSize        =  13,
   kCGLPFAAccumSize          =  14,
   kCGLPFAMinimumPolicy      =  51,
   kCGLPFAMaximumPolicy      =  52,
   kCGLPFAOffScreen          =  53,
   kCGLPFAFullScreen         =  54,
   kCGLPFASampleBuffers      =  55,
   kCGLPFASamples            =  56,
   kCGLPFAAuxDepthStencil    =  57,
   kCGLPFAColorFloat         =  58,
   kCGLPFAMultisample        =  59,
   kCGLPFASupersample        =  60,
   kCGLPFASampleAlpha        =  61,
   kCGLPFARendererID         =  70,
   kCGLPFASingleRenderer     =  71,
   kCGLPFANoRecovery         =  72,
   kCGLPFAAccelerated        =  73,
   kCGLPFAClosestPolicy      =  74,
   kCGLPFARobust             =  75,
   kCGLPFABackingStore       =  76,
   kCGLPFAMPSafe             =  78,
   kCGLPFAWindow             =  80,
   kCGLPFAMultiScreen        =  81,
   kCGLPFACompliant          =  83,
   kCGLPFADisplayMask        =  84,
   kCGLPFAPBuffer            =  90,
   kCGLPFARemotePBuffer      =  91,
   kCGLPFAVirtualScreenCount = 128,
} CGLPixelFormatAttribute;

/*CGLPixelFormatObj

Represents a pointer to an opaque pixel format object.

typedef struct _CGLPixelFormatObject *CGLPixelFormatObj;
Discussion

This data type points to a structure that CGL uses to maintain pixel format and virtual screen information for a given set of renderer and buffer options. Use the functions described in “Managing Pixel Format Objects” to create, manage, access, and free a pixel format object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef struct _CGLPixelFormatObject *CGLPixelFormatObj;

/*CGLContextObj

Represents a pointer to an opaque CGL context object.

typedef struct _CGLContextObject *CGLContextObj;
Discussion

This data type points to a structure that CGL uses to maintain state and other information associated with an OpenGL rendering context. Use the functions described in “Managing Contexts” and “Getting and Setting Context Options” to create, manage, access, and free a CGL context object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef struct _CGLContextObject *CGLContextObj;

#ifdef __cplusplus
}
#endif

#endif