#ifndef QUICKDRAW_H
#define QUICKDRAW_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef COREGRAPHICS_H
#include <CoreGraphics/CoreGraphics.h>
#endif

#ifndef QUICKDRAWTEXT_H
#include <QD/QuickdrawText.h>
#endif

#ifndef CMTYPES_H
#include <ColorSync/CMTypes.h>
#endif

#include <HYS/QD/Quickdraw.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*k1MonochromePixelFormat

enum {
   k1MonochromePixelFormat = 0x00000001,
   k2IndexedPixelFormat = 0x00000002,
   k4IndexedPixelFormat = 0x00000004,
   k8IndexedPixelFormat = 0x00000008,
   k16BE555PixelFormat = 0x00000010,
   k24RGBPixelFormat = 0x00000018,
   k32ARGBPixelFormat = 0x00000020,
   k1IndexedGrayPixelFormat = 0x00000021,
   k2IndexedGrayPixelFormat = 0x00000022,
   k4IndexedGrayPixelFormat = 0x00000024,
   k8IndexedGrayPixelFormat = 0x00000028
};*/
enum {
   k1MonochromePixelFormat = 0x00000001,
   k2IndexedPixelFormat = 0x00000002,
   k4IndexedPixelFormat = 0x00000004,
   k8IndexedPixelFormat = 0x00000008,
   k16BE555PixelFormat = 0x00000010,
   k24RGBPixelFormat = 0x00000018,
   k32ARGBPixelFormat = 0x00000020,
   k1IndexedGrayPixelFormat = 0x00000021,
   k2IndexedGrayPixelFormat = 0x00000022,
   k4IndexedGrayPixelFormat = 0x00000024,
   k8IndexedGrayPixelFormat = 0x00000028
};

/*Source, Pattern, and Arithmetic Transfer Mode Constants

enum {
   srcCopy = 0,
   srcOr = 1,
   srcXor = 2,
   srcBic = 3,
   notSrcCopy = 4,
   notSrcOr = 5,
   notSrcXor = 6,
   notSrcBic = 7,
   patCopy = 8,
   patOr = 9,
   patXor = 10,
   patBic = 11,
   notPatCopy = 12,
   notPatOr = 13,
   notPatXor = 14,
   notPatBic = 15,
   grayishTextOr = 49,
   hilitetransfermode = 50,
   hilite = 50,
   blend = 32,
   addPin = 33,
   addOver = 34,
   subPin = 35,
   addMax = 37,
   adMax = 37,
   subOver = 38,
   adMin = 39,
   ditherCopy = 64,
   transparent = 36
};
Constants
srcCopy

For basic graphics ports, force the destination pixel black where the source pixel is black; where the source pixel is white, force the destination pixel white.

For color graphics ports, determines how close the color of the source pixel is to black, and assigns this relative amount of foreground color to the destination pixel. Determines how close the color of the source pixel is to white, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
srcOr

For basic graphics ports, forces the destination pixel black if the source pixel is black; where the source pixel is white, leaves the destination pixel unaltered.

For color graphics ports, determines how close the color of the source pixel is to black, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
srcXor

For basic and color graphics ports, inverts destination pixel where the source pixel is black. For a basic graphics port, where the source pixel is white, leaves the destination pixel unaltered. 

For a color graphics port, for a colored destination pixel, uses the complement of its color if the pixel is direct, or inverts its index if the pixel is indexed.

Available in Mac OS X v10.0 and later.
srcBic

For a basic graphics port, forces destination pixel white where source pixel is black; where source pixel is white, leaves the destination pixel unaltered.

For a color graphics port, determines how close the color of the source pixel is to black, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcCopy

For a basic graphics port, forces the destination pixel white where the source pixel is black; where the source pixel is white, forces the destination pixel black.

For a color graphics port, determines how close the color of the source pixel is to black, and assigns this relative amount of background color to the destination pixel. Determines how close the color of the source pixel is to white, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcOr

For a basic graphics port, leaves the destination pixel unaltered where the source pixel is black; where the source pixel is white, forces the destination pixel black.

For a color graphics port, determines how close the color of the source pixel is to white, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcXor

For basic and color graphics ports, where the source pixel is white, inverts the destination pixel. For a basic graphics port, where the source pixel is black, leaves the destination pixel unaltered.

For a color graphics port, for a colored destination pixel, uses the complement of its color if the pixel is direct, or inverts its index if the pixel is indexed.

Available in Mac OS X v10.0 and later.
notSrcBic

For a basic graphics port, where the source pixel is black, leaves the destination pixel unaltered; where the source pixel is white, forces the destination pixel white.

For a color graphics port, determines how close the color of the source pixel is to white, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
patCopy

Where the pattern pixel is black, applies foreground color to the destination pixel; where the pattern pixel is white, applies background color to the destination pixel.

Available in Mac OS X v10.0 and later.
patOr

Where the pattern pixel is black, inverts the destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
patXor

Where the pattern pixel is black, inverts the destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
patBic

Where the pattern pixel is black, applies the background color to destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
notPatCopy

Where the pattern pixel is black, applies background color to destination pixel; where the pattern pixel is white, applies foreground color to the destination pixel

Available in Mac OS X v10.0 and later.
notPatOr

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, applies foreground color to the destination pixel

Available in Mac OS X v10.0 and later.
notPatXor

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, inverts the destination pixel

Available in Mac OS X v10.0 and later.
notPatBic

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, applies background color to the destination pixel.

Available in Mac OS X v10.0 and later.
grayishTextOr

Draws dimmed text on the screen. You can use it for black-and-white or color graphics ports. The grayishTextOr transfer mode is not considered a standard transfer mode because currently it is not stored in pictures, and printing with it is undefined. (It does not pass through the QuickDraw bottleneck functions.)

Available in Mac OS X v10.0 and later.
hilite

Adds highlighting to the source or pattern mode. With highlighting, QuickDraw replaces the background color with the highlight color when your application copies images between graphics ports. This has the visual effect of using a highlighting pen to select the object. (The global variable HiliteRGB is read from parameter RAM when the machine starts. Basic graphics ports use the color stored in the HiliteRGB global variable as the highlight color. Color graphics ports default to the HiliteRGB global variable, but can be overridden by the HiliteColor function.)

For text, specifies that the caret position should be determined according to the primary line direction, based on the value of SysDirection.

Available in Mac OS X v10.0 and later.
blend

Replaces the destination pixel with a blend of the source and destination pixel colors. If the destination is a bitmap or 1-bit pixel map, reverts to srcCopy mode.

Available in Mac OS X v10.0 and later.
addPin

Replaces the destination pixel with the sum of the source and destination pixel colors-- up to a maximum allowable values. If the destination is a bitmap or 1-bit pixel map, reverts to srcBic mode.

Available in Mac OS X v10.0 and later.
addOver

Replaces the destination pixel with the sum of the source and destination pixel colors, except if the value of the red, green, or blue component exceeds 65,536, then addOver subtracts 65,536 from that value. If the destination is a bitmap or 1-bit pixel map, reverts to srcXor mode.

Available in Mac OS X v10.0 and later.
subPin

Replaces the destination pixel with the difference of the source and destination pixel colors, but not less than a minimum allowable value. If the destination is a bitmap or 1-bit pixel map, reverts to srcOr mode.

Available in Mac OS X v10.0 and later.
addMax

Compares the source and destination pixels, and replaces the destination pixel with the color containing the greater saturation of each of the RGB components. If the destination is a bitmap or 1-bit pixel map, reverts to srcBic mode.

Available in Mac OS X v10.0 and later.
subOver

Replaces the destination pixel with the difference of the source and destination pixel colors, except if the value of the red, green, or blue component is less than 0, then it adds the negative result to 65,536. if the destination is a bitmap or 1-bit pixel map, revert to srcXor mode.

Available in Mac OS X v10.0 and later.
adMin

Compares the source and destination pixels, and replaces the destination pixel with the color containing the lesser saturation of each of the RGB components. If the destination is a bitmap or 1-bit pixel map, reverts to srcOr mode.

Available in Mac OS X v10.0 and later.
ditherCopy

On computers running System 7, you can add dithering to any source mode by adding this constant or the value it represents to the source mode.

Dithering is a technique that mixes existing colors to create the effect of additional colors. It also improves images that you shrink or that you copy from a direct pixel device to an indexed device.

Available in Mac OS X v10.0 and later.
transparent

Replaces the destination pixel with the source pixel if the source pixel is not equal to the background color. The transparent mode replaces the destination pixel with the source pixel if the source pixel isn’t equal to the background color. This mode is most useful in 8-bit, 4-bit, or 2-bit color modes.

Available in Mac OS X v10.0 and later.
Discussion

CopyBits uses the source and arithmetic transfer mode constants in the mode parameter to specify the manner in which pixels are transferred from a source pixel map to a destination pixel map.

PenMode uses the pattern mode constants in the mode parameter to specify source modes for transferring the bits from a source bitmap to a destination bitmap.

The TextMode function uses these constants to set the transfer mode in the graphics port txMode field. 

The transfer mode determines the interplay between what an application is drawing (the source) and what already exists on the display device (the destination), resulting in the text display.

There are two basic kinds of modes: pattern ( pat) and source ( src). 

The pattern mode constants are patCopy, patOr, patXor, patBic, notPatCopy, notPatOr, notPatXor, and notPatBic.

Source is the kind that you use for drawing text. There are four basic Boolean operations: Copy, Or, Xor, and Bic (bit clear), each of which has an inverse variant in which the source is inverted before the transfer, yielding eight operations in all. Basic QuickDraw supports these eight transfer modes. Color QuickDraw interprets the source mode constants differently than basic QuickDraw does. Color QuickDraw enables your application to achieve color effects within those basic transfer modes, and offers an additional set of transfer modes that perform arithmetic operations on the RGB values of the source and destination pixels. Other transfer modes are grayishTextOr, transparent mode, and text mask mode.

The arithmetic transfer modes are addOver, addPin, subOver, subPin, addMax, adMax, adMin, and blend. For color, the arithmetic modes change the destination pixels by performing arithmetic operations on the source and destination pixels. Arithmetic transfer modes calculate pixel values by adding, subtracting, or averaging the RGB components of the source and destination pixels. They are most useful for 8-bit color, but they work on 4-bit and 2-bit color also. When the destination bitmap is one bit deep, the mode reverts to the basic transfer mode that best approximates the arithmetic mode requested.*/
enum {
   srcCopy = 0,
   srcOr = 1,
   srcXor = 2,
   srcBic = 3,
   notSrcCopy = 4,
   notSrcOr = 5,
   notSrcXor = 6,
   notSrcBic = 7,
   patCopy = 8,
   patOr = 9,
   patXor = 10,
   patBic = 11,
   notPatCopy = 12,
   notPatOr = 13,
   notPatXor = 14,
   notPatBic = 15,
   grayishTextOr = 49,
   hilitetransfermode = 50,
   hilite = 50,
   blend = 32,
   addPin = 33,
   addOver = 34,
   subPin = 35,
   addMax = 37,
   adMax = 37,
   subOver = 38,
   adMin = 39,
   ditherCopy = 64,
   transparent = 36
};


/*RgnHandle

typedef struct OpaqueRgnHandle * RgnHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueRgnHandle * RgnHandle;

/*BitMap

struct BitMap {
   Ptr baseAddr;
   short rowBytes;
   Rect bounds;
};
typedef struct BitMap BitMap;
typedef BitMap * BitMapPtr;
Fields
baseAddr

A pointer to the beginning of the bit image.
rowBytes

The offset in bytes from one row of the image to the next. The value of the rowBytes field must be less than $4000.
bounds

The bitmap’s boundary rectangle by default, the entire main screen.
Discussion

A bitmap, which is a data structure of type BitMap, defines a bit image in terms of the QuickDraw coordinate plane. (A bit image is a collection of bits in memory that form a grid.)

A bitmap has three parts: a pointer to a bit image, the row width of that image, and a boundary rectangle that links the local coordinate system of a graphics port to QuickDraw’s global coordinate system and defines the area of the bit image into which QuickDraw can draw.

The width of the boundary rectangle determines how many bits of one row are logically owned by the bitmap. This width must not exceed the number of bits in each row of the bit image. The height of the boundary rectangle determines how many rows of the image are logically owned by the bitmap. The number of rows enclosed by the boundary rectangle must not exceed the number of rows in the bit image.

The boundary rectangle defines the local coordinate system used by the port rectangle for a graphics port (described next). The upper-left corner (which for a window is called the window origin) of the port rectangle usually has a vertical coordinate of 0 and a horizontal coordinate of 0, although you can use the function SetOrigin to change the coordinates of the window origin. 
Availability
Available in Mac OS X v10.0 and later.*/
struct BitMap {
   Ptr baseAddr;
   short rowBytes;
   Rect bounds;
};
typedef struct BitMap BitMap;
typedef BitMap * BitMapPtr;

/*GrafPtr

typedef struct OpaqueGrafPtr * GrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueGrafPtr * GrafPtr;

/*CGrafPtr

typedef GrafPtr CGrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef GrafPtr CGrafPtr;

/*ITab

struct ITab {
   long iTabSeed;
   short iTabRes;
   Byte iTTable[1];
};
typedef struct ITab ITab;
typedef ITab * ITabPtr;
typedef ITabPtr * ITabHandle;
Fields
iTabSeed

The iTabSeed value, initially set from the corresponding CLUT’s ctSeed field. If at any time these do not match, then the color table was changed, and the inverse table needs to be rebuilt.
iTabRes

The resolution of this inverse table.
iTTable

An array of index values. The size of the iTabTable field in bytes is 23*iTabRes.
Discussion

The ITab data structure contains the inverse table information that the Color Manager uses for fast mapping of RGB color values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ITab {
   long iTabSeed;
   short iTabRes;
   Byte iTTable[1];
};
typedef struct ITab ITab;
typedef ITab * ITabPtr;
typedef ITabPtr * ITabHandle;



/*RGBColor

struct RGBColor {
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};
typedef struct RGBColor RGBColor;
typedef RGBColor * RGBColorPtr;
Fields
red

An unsigned integer specifying the red value of the color.
green

An unsigned integer specifying the green value of the color.
blue

An unsigned integer specifying the blue value of the color.
Discussion

You usually specify a color to QuickDraw by creating an RGBColor structure in which you assign the red, green, and blue values of the foreground color. For example, when you want to set the foreground color for drawing, you create an RGBColor structure that defines the foreground color you desire; then you pass that structure as a parameter to the RGBForeColor function. 

In an RGBColor structure, three 16-bit unsigned integers give the intensity values for the three additive primary colors. 
Availability
Available in Mac OS X v10.0 and later.*/
struct RGBColor {
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};
typedef struct RGBColor RGBColor;
typedef RGBColor * RGBColorPtr;


/*ColorSpec

struct ColorSpec {
   short value;
   RGBColor rgb;
};
typedef struct ColorSpec ColorSpec;
typedef ColorSpec * ColorSpecPtr;
Fields
value

The pixel value assigned by QuickDraw for the color specified in the rgb field of this structure. QuickDraw assigns a pixel value based on the capabilities of the user’s screen. For indexed devices, the pixel value is an index number assigned by QuickDraw to the closest color available on the indexed device for direct devices, this value expresses the best available red, green, and blue values for the color on the direct device.
rgb

An RGBColor structure that fully specifies the color whose approximation QuickDraw specifies in the value field. 
Discussion

When creating a PixMap structure for an indexed device, QuickDraw creates a ColorTable structure that defines the best colors available for the pixel image on that graphics device. QuickDraw also stores a ColorTable structure for the currently available colors in the graphics device’s CLUT. 

One of the fields in a ColorTable structure requires a value of type cSpecArray, which is defined as an array of ColorSpec structures. Typically, your application never needs to create ColorTable structures or ColorSpec structures. For completeness, the data structure of type ColorSpec is shown here. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorSpec {
   short value;
   RGBColor rgb;
};
typedef struct ColorSpec ColorSpec;
typedef ColorSpec * ColorSpecPtr;

/*CSpecArray

typedef ColorSpec CSpecArray[1];
Availability
Available in Mac OS X v10.0 and later.*/
typedef ColorSpec CSpecArray[1];


/*ColorTable

struct ColorTable {
   long ctSeed;
   short ctFlags;
   short ctSize;
   CSpecArray ctTable;
};
typedef struct ColorTable ColorTable;
typedef ColorTable * CTabPtr;
typedef CTabPtr * CTabHandle;
Fields
ctSeed

Identifies a particular instance of a color table. QuickDraw uses the ctSeed value to compare an indexed device’s color table with its associated inverse table (a table it uses for fast color lookup).When the color table for a graphics device has been changed, QuickDraw needs to rebuild the inverse table.
ctFlags

Flags that distinguish pixel map color tables from color tables in GDevice structures.
ctSize

One less than the number of entries in the table.
ctTable

An array of ColorSpec entries, each containing a pixel value and a color specified by an RGBColor structure. 
Discussion

When creating a PixMap structure for a particular graphics device, QuickDraw creates a ColorTable structure that defines the best colors available for the pixel image on that particular graphics device. QuickDraw also creates a ColorTable structure of all available colors for use by the CLUT on indexed devices.

Typically, your application needs to create ColorTable structures only if it uses the Palette Manager. 

Your application should never need to directly change the fields of a ColorTable structure. If you find it absolutely necessary for your application to do so, immediately use the CTabChanged function to notify QuickDraw that your application has changed the ColorTable structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorTable {
   long ctSeed;
   short ctFlags;
   short ctSize;
   CSpecArray ctTable;
};
typedef struct ColorTable ColorTable;
typedef ColorTable * CTabPtr;
typedef CTabPtr * CTabHandle;



/*CTabPtr

Abst_CTabPtr

typedef ColorTable * CTabPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ColorTable * CTabPtr;

/*CTabHandle

Abst_CTabHandle

typedef CTabPtr * CTabHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef CTabPtr * CTabHandle;



/*PixMap

Contains information about the dimensions and contents of a pixel image, as well as its storage format, depth, resolution, and color usage.

struct PixMap {
   Ptr           baseAddr;
   short         rowBytes;
   Rect          bounds;
   short         pmVersion;
   short         packType;
   long          packSize;
   Fixed         hRes;
   Fixed         vRes;
   short         pixelType;
   short         pixelSize;
   short         cmpCount;
   short         cmpSize;
   OSType        pixelFormat;
   CTabHandle    pmTable;
   void *        pmExt;
};
Fields
baseAddr
Discussion

For an onscreen pixel image, a pointer to the first byte of the image. For optimal performance, this should be a multiple of 4. The baseAddr field of the PixMap record for an offscreen graphics world contains a handle instead of a pointer. Your application should never directly access the baseAddr field of the PixMap record for an offscreen graphics world.
rowBytes
Discussion

The offset in bytes from one row of the image to the next. The value must be even, less than 0x4000, and for best performance it should be a multiple of 4. The high 2 bits of rowBytes are used as flags. If bit 15 =1, the data structure pointed to is a PixMap structure; otherwise it is a BitMap structure.
bounds
Discussion

The boundary rectangle, which links the local coordinate system of a graphics port to QuickDraw's global coordinate system and defines the area of the bit image into which QuickDraw can draw. By default, the boundary rectangle is the entire main screen. Do not use the value of this field to determine the size of the screen; instead use the value of the gdRect field of the GDevice structure for the screen.
pmVersion
Discussion

The version number of Color QuickDraw that created this PixMap structure. The value of pmVersion is normally 0. If pmVersion is 4, Color QuickDraw treats the PixMap record's baseAddr field as 32-bit clean. All other flags are private. Most applications never need to set this field
packType
Discussion

The packing algorithm used to compress image data. Color QuickDraw currently supports a packType of 0, which means no packing, and values of 1 to 4 for packing direct pixels.
packSize
Discussion

The size of the packed image in bytes. When the packType field contains the value 0, this field is always set to 0.
hRes
Discussion

The horizontal resolution of the pixel image in pixels per inch. By default, this value is 0x00480000 (for 72 pixels per inch).
vRes
Discussion

The vertical resolution of the pixel image in pixels per inch. By default, this value is 0x00480000 (for 72 pixels per inch).
pixelType
Discussion

The storage format for a pixel image. Indexed pixels are indicated by a value of 0. Direct pixels are specified by a value of RGBDirect, or 16. In the PixMap record of the GDevice structure for a direct device, this field is set to RGBDirect when the screen depth is set.
pixelSize
Discussion

The number of bits used to represent a pixel. Indexed pixels can have sizes of 1, 2, 4, and 8 bits; direct pixel sizes are 16 and 32 bits.
cmpCount
Discussion

The number of components used to represent a color for a pixel. With indexed pixels, each pixel is a single value representing an index in a color table, and therefore this field contains the value 1; the index is the single component. With direct pixels, each pixel contains three components (one integer each for the intensities of red, green, and blue) so this field contains the value 3.
cmpSize
Discussion

The size in bits of each component for a pixel. Color QuickDraw expects that the sizes of all components are the same, and that the value of the cmpCount field multiplied by the value of the cmpSize field is less than or equal to the value in the pixelSize field.

For an indexed pixel value, which has only one component, the value of the cmpSize field is the same as the value of the pixelSize field; that is, 1, 2, 4, or 8. For direct pixels there are two additional possibilities. A 16-bit pixel, which has three components, has a cmpSize value of 5; this leaves an unused high-order bit, which Color QuickDraw sets to 0. A 32-bit pixel, which has three components (red, green, and blue), has a cmpSize value of 8; this leaves an unused high-order byte, which Color QuickDraw sets to 0.

If presented with a 32-bit image (for example, in the CopyBits procedure) Color QuickDraw passes whatever bits are there, and it does not set the high byte to 0. Generally, therefore, your application should clear the memory for the image to 0 before creating a 16-bit or 32-bit image.
planeBytes
Discussion

The offset in bytes from one drawing plane to the next. This field is set to 0.
pmTable
Discussion

A handle to a ColorTable structure for the colors in this pixel map.
pmReserved
Discussion

Reserved. This field must be set to 0 for future compatibility.
pixelFormat
Discussion

The way the pixels are arranged; see Pixel Formats.
pmTable
Discussion

Color map for this structure.
pmExt
Discussion

Handle to a PixMapExtension structure. Set to NIL if there is no extension.
Discussion

The pixel map for a window's color graphics port always consists of the pixel depth, color table, and boundary rectangle of the main screen, even if the window is created on or moved to an entirely different screen.
Version Notes

Earlier versions of this structure were different in the last three fields; see the C interface file for details.
Programming Info
C interface file: Quickdraw.h*/
struct PixMap {
   Ptr           baseAddr;
   short         rowBytes;
   Rect          bounds;
   short         pmVersion;
   short         packType;
   long          packSize;
   Fixed         hRes;
   Fixed         vRes;
   short         pixelType;
   short         pixelSize;
   short         cmpCount;
   short         cmpSize;
   OSType        pixelFormat;
   CTabHandle    pmTable;
   void *        pmExt;
};
typedef  struct PixMap PixMap;



/*PixMapPtr

Abst_PixMapPtr

typedef PixMap * PixMapPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PixMap * PixMapPtr;

/*PixMapHandle

Abst_PixMapHandle

typedef PixMapPtr * PixMapHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PixMapPtr * PixMapHandle;


/*GDevice

struct GDevice {
   short gdRefNum;
   short gdID;
   short gdType;
   ITabHandle gdITable;
   short gdResPref;
   SProcHndl gdSearchProc;
   CProcHndl gdCompProc;
   short gdFlags;
   PixMapHandle gdPMap;
   long gdRefCon;
   GDHandle gdNextGD;
   Rect gdRect;
   long gdMode;
   short gdCCBytes;
   short gdCCDepth;
   Handle gdCCXData;
   Handle gdCCXMask;
   long gdReserved;
};
typedef struct GDevice GDevice;
typedef GDevice * GDPtr;
typedef GDPtr * GDHandle;
Fields
gdRefNum

The reference number of the driver for the screen associated with the video device. For most video devices, this information is set at system startup time.
gdID

Reserved. If you create your own GDevice structure, set this field to 0.
gdType

The general type of graphics device. See Graphics Device Type Constants for a description of the values which you can use in this field.
gdITable

A handle to the inverse table for color mapping. 
gdResPref

The preferred resolution for inverse tables.
gdSearchProc

A handle to the list of search functions. Its value is NULL for the default function. 
gdCompProc

A handle to a list of complement functions. Its value is NULL for the default function. 
gdFlags

The GDevice structure’s attributes. To set the attribute bits in the gdFlags field, use the SetDeviceAttribute function. Do not set gdFlags directly in the GDevice structure.
gdPMap

A handle to a PixMap structure giving the dimension of the image buffer, along with the characteristics of the graphics device (resolution, storage format, color depth, and color table). For GDevice structures, the high bit of the global variable 

(((**TheGDevice).**gdPMap).**pmTable).ctFlags

is always set.

gdRefCon

A value used by system software to pass device-related parameters. Since a graphics device is shared, do not store data here.
gdNextGD

A handle to the next graphics device in the device list. If this is the last graphics device in the device list, the field contains 0. 
gdRect

The boundary rectangle of the graphics device represented by the GDevice structure. The main screen has the upper-left corner of the rectangle set to (0,0). All other graphics devices are relative to this point.
gdMode

The current setting for the graphics device mode. This value is passed to the video driver to set its pixel depth and to specify color or black and white; applications do not need this information.
gdCCBytes

The rowBytes value of the expanded cursor. Your application should not change this field.
gdCCDepth

The depth of the expanded cursor. Your application should not change this field.
gdCCXData

A handle to the cursor’s expanded data. Your application should not change this field.
gdCCXMask

A handle to the cursor’s expanded mask. Your application should not change this field.
gdReserved

Reserved for future expansion; it must be set to 0 for future compatibility.
Discussion

Color QuickDraw stores state information for video devices and offscreen graphics worlds in GDevice structures. When the system starts up, it allocates and initializes one handle to a GDevice structure for each video device it finds. When you use the Offscreen Graphics Devices function, NewGWorld, Color QuickDraw automatically creates a GDevice structure for the new offscreen graphics world. The system links these GDevice structures in a list, called the device list. (You can find a handle to the first element in the device list in the global variable DeviceList.) By default, the GDevice structure corresponding to the first video device found is marked as the current device. All other graphics devices in the list are initially marked as inactive. 

When the user moves a window or creates a window on another screen, and your application draws into that window, Color QuickDraw automatically makes the video device for that screen the current device. Color QuickDraw stores that information in the global variable TheGDevice. 

GDevice structures that correspond to video devices have drivers associated with them. These drivers can be used to change the mode of the video device from black and white to color and to change the pixel depth. Application-created GDevice structures usually don’t require drivers. 

Your application should never need to directly change the fields of a GDevice structure. If you find it absolutely necessary for your application to so, immediately use the GDeviceChanged function to notify QuickDraw that your application has changed the GDevice structure. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct GDevice GDevice;
typedef GDevice * GDPtr;
typedef GDPtr * GDHandle;

struct GDevice {
   short gdRefNum;
   short gdID;
   short gdType;
   ITabHandle gdITable;
   short gdResPref;
   SProcHndl gdSearchProc;
   CProcHndl gdCompProc;
   short gdFlags;
   PixMapHandle gdPMap;
   long gdRefCon;
   GDHandle gdNextGD;
   //int  gdNextGD; //hys
   Rect gdRect;
   long gdMode;
   short gdCCBytes;
   short gdCCDepth;
   Handle gdCCXData;
   Handle gdCCXMask;
   long gdReserved;
};





/*Picture

struct Picture {
   short picSize;
   Rect picFrame;
};
typedef struct Picture Picture;
typedef Picture * PicPtr;
typedef PicPtr * PicHandle;
Fields
picSize

The size of the rest of this structure for a version 1 picture. To maintain compatibility with the version 1 picture format, the picSize field was not changed for the version 2 picture or extended version 2 formats. The information in this field is used only for version 1 pictures, which cannot exceed 32 KB in size. Because version 2 and extended version 2 pictures can be much larger than the 32 KB limit imposed by the 2-byte picSize field, you should use the Memory Manager function GetHandleSize to determine the size of a picture in memory; you should use the File Manager function PBGetFInfo to determine the size of a picture in a 'PICT' file; and you should use the Resource Manager function GetMaxResourceSize to determine the size of a 'PICT' resource.
picFrame

The bounding rectangle for the picture defined in the rest of this structure. The DrawPicture function uses this rectangle to scale the picture if you draw it into a destination rectangle of a different size.
Discussion

When you use the OpenCPicture or OpenPicture function, QuickDraw begins collecting your subsequent drawing commands in a Picture structure. (You use the ClosePicture function to complete a picture definition.) When you use the GetPicture function to retrieve a picture stored in a resource, GetPicture reads the resource into memory as a Picture structure. By using the DrawPicture procedure, you can draw onscreen the picture defined by the commands stored in the Picture structure.

A picture opcode is a number that the DrawPicture function uses to determine what object to draw or what mode to change for subsequent drawing. Generally, donot read or write this picture data directly. Instead, use the OpenCPicture (or OpenPicture), ClosePicture, and DrawPicture functions to process these opcodes.

The Picture structure can also contain picture comments. Created by applications using the PicComment function, picture comments contain data or commands for special processing by output devices, such as PostScript printers. 

You can use File Manager functions to save the picture in a file of type 'PICT', you can use Resource Manager functions to save the picture in a resource of type 'PICT', and you can use the Scrap Manager function PutScrap to store the picture in 'PICT' scrap format. 
Availability
Available in Mac OS X v10.0 and later.*/
struct Picture {
   short picSize;
   Rect picFrame;
};
typedef struct Picture Picture;
typedef Picture * PicPtr;
typedef PicPtr * PicHandle;

/*PicPtr

Abst_PicPtr

typedef Picture * PicPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Picture * PicPtr;

/*PicHandle

Abst_PicHandle

typedef PicPtr * PicHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PicPtr * PicHandle;

/*GrafPtr

typedef struct OpaqueGrafPtr * GrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueGrafPtr * GrafPtr;

/*WindowPtr

Defines a window pointer. 

typedef struct OpaqueWindowPtr * WindowPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueWindowPtr * WindowPtr;

/*WindowRef

Represents a window. 

typedef WindowPtr WindowRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef WindowPtr WindowRef;

/*DialogPtr

typedef struct OpaqueDialogPtr * DialogPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueDialogPtr * DialogPtr;

/*SetRect

Assigns coordinates to a rectangle. 

void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);
Parameters
r

A pointer to the rectangle to set.
left

The horizontal coordinate of the new upper-left corner of the rectangle.
top

The vertical coordinate of the new upper-left corner of the rectangle.
right

The horizontal coordinate of the new lower-right corner of the rectangle.
bottom

The vertical coordinate of the new lower-right corner of the rectangle.
Discussion

The SetRect function assigns the coordinates you specify in the left, top, right, and bottom parameters to the rectangle that you specify in the r parameter. This function is provided to help you shorten your program text. If you want a more readable text, at the expense of source text length, you can instead assign integers (or points) directly into the fields of a Rect structure.

You can use a rectangle to specify locations and sizes for various graphics operations.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);

/*GetPortBounds

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);

/*EraseRect

Erases a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRect (
   const Rect * r
);
Parameters
r

The rectangle to erase.
Discussion

Using the patCopy pattern mode, the EraseRect function draws the interior of the rectangle that you specify in the r parameter with the background pattern for the current graphics port. This effectively erases the rectangle, making the shape blend into the background pattern of the graphics port. For example, use EraseRect to erase the port rectangle for a window before redrawing into the window.

This function leaves the location of the graphics pen unchanged. 
Special Considerations

The EraseRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void EraseRect (
   const Rect * r
);

/*CopyBits

Copies a portion of a bitmap or a pixel map from one graphics port or offscreen graphics world into another graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);
Parameters
srcBits

The source BitMap structure. 
dstBits

The destination BitMap structure.
srcRect

The source rectangle.
dstRect

The destination rectangle.
mode

One of the eight source modes in which the copy is to be performed. See Source, Pattern, and Arithmetic Transfer Mode Constants. The CopyBits function always dithers images when shrinking them between pixel maps on direct devices. 

When transferring pixels from a source pixel map to a destination pixel map, color QuickDraw interprets the source mode constants differently than basic QuickDraw does.

When you use CopyBits on a computer running color QuickDraw, you can also specify one of the transfer modes in the mode parameter.
maskRgn

A region to use as a clipping mask. You can pass a region handle to specify a mask region the resulting image is always clipped to this mask region and to the boundary rectangle of the destination bitmap. If the destination bitmap is the current graphics port’s bitmap, it is also clipped to the intersection of the graphics port’s clipping region and visible region. If you do not want to clip to a masking region, just pass NULL for this parameter. 
Discussion

The CopyBits function transfers any portion of a bitmap between two basic graphics ports, or any portion of a pixel map between two color graphics ports. Use CopyBits to move offscreen graphic images into an onscreen window, to blend colors for the image in a pixel map, and to shrink and expand images.

Specify a source bitmap in the srcBits parameter and a destination bitmap in the dstBits parameter. When copying images between color graphics ports, you must coerce each CGrafPort structure to a GrafPort structure, dereference the portBits fields of each, and then pass these “bitmaps” in the srcBits and dstBits parameters. If your application copies a pixel image from a color graphics port called MyColorPort, for example, you could specify (* GrafPtr(MyColorPort)).portBits in the srcBits parameter. In a CGrafPort structure, the high 2 bits of the portVersion field are set. This field, which shares the same position in a CGrafPort structure as the portBits.rowBytes field in a GrafPort structure, indicates to CopyBits that you have passed it a handle to a pixel map rather than a bitmap.

Using the srcRect and dstRect parameters, you can specify identically or differently sized source and destination rectangles; for differently sized rectangles, CopyBits scales the source image to fit the destination. If the bit image is a circle in a square source rectangle, and the destination rectangle is not square, the bit image appears as an oval in the destination. When you specify rectangles in the srcRect and dstRect parameters, use the local coordinate systems of, respectively, the source and destination graphics ports.

The CopyDeepMask function combines the functions of the CopyBits and CopyMask functions. 
Special Considerations

When you use the CopyBits function to transfer an image between pixel maps, the source and destination images may be of different pixel depths, of different sizes, and they may have different color tables. However, CopyBits assumes that the destination pixel map uses the same color table as the color table for the current GDevice structure. (This is because the Color Manager requires an inverse table for translating the color table from the source pixel map to the destination pixel map.) 

The CopyBits function applies the foreground and background colors of the current graphics port to the image in the destination pixel map (or bitmap), even if the source image is a bitmap. This causes the foreground color to replace all black pixels in the destination and the background color to replace all white pixels. To avoid unwanted coloring of the image, use the RGBForeColor function to set the foreground to black and use the RGBBackColor function to set the background to white before calling CopyBits.

The source bitmap or pixel map must not occupy more memory than half the available stack space. The stack space required by CopyBits is roughly five times the value of the rowBytes field of the source pixel map: one rowBytes value for the pixel map (or bitmap), an additional rowBytes value for dithering, another rowBytes value when stretching or shrinking the source pixel map into the destination, another rowBytes value for any color map changing, and a fifth additional rowBytes value for any color aliasing. If there is insufficient memory to complete a CopyBits operation in Color QuickDraw, the QDError function returns the result code –143.

If you use CopyBits to copy between two graphics ports that overlap, you must first use the LocalToGlobal function to convert to global coordinates, and then specify the global variable screenBits for both the srcBits and dstBits parameters.

The CopyBits function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

If you are reading directly from a NuBus video card with a base address of Fs00000 and there is not a card in the slot (s–1) below it, CopyBits reads addresses less than the base address of the pixel map. This causes a bus error. To work around the problem, remap the baseAddr field of the pixel map in your video card to at least 20 bytes above the NuBus boundary; an address link of Fs000020 precludes the problem.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);

/*QDFlushPortBuffer

Calls the Quartz compositor to flush all new drawing in a Carbon window to the display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);
Parameters
port

A window port. If the port has no back buffer, or if the port is an offscreen or printing port, this function does nothing.
region

An update region. Under normal conditions, you should pass NULL to avoid the overhead of additional region operations.
Discussion

In Mac OS X, drawing in a window port updates a back buffer associated with the window. Updates to this buffer are accumulated in a list called the dirty region. 

The back buffer is automatically flushed to the display each time through the event loop. When the event loop does not get control soon enough—for example, during an animation sequence—you can call this function to flush the port buffer to the device immediately. 

When you call this function, there are several different execution paths:
If the region parameter is NULL, the dirty region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the dirty region is set to empty.
If the region parameter specifies an update region, the intersection of the dirty region and the update region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the flushed region is subtracted from the dirty region.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);

/*SetPort

Changes the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPort (
   GrafPtr port
);
Parameters
port

A pointer to a GrafPort structure. Typically, you pass a pointer to a GrafPort structure that you previously saved with the GetPort function. The SetPort function sets this structure to be the current graphics port. 
Discussion

All QuickDraw drawing functions affect the bitmap of, and use the local coordinate system of, the current graphics port. Each graphics port has its own graphics pen and text characteristics, which remain unchanged when the graphics port isn’t selected as the current graphics port.

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the SetGWorld function instead of SetPort. The SetGWorld function restores the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void SetPort (
   GrafPtr port
);


#ifdef __cplusplus
}
#endif

#endif