//inc
#ifndef IMAGECOMPRESSION_H
#define IMAGECOMPRESSION_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif


#include <OpenGL/OpenGL.h>
#include <QuartzCore/CoreVideo.h>

#include <HYS/QuickTime/ImageCompression.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Constants

The following constants are used to specify graphics exporter characteristics:
enum {
    GraphicsExporterComponentType = FOUR_CHAR_CODE('grex'),
    kBaseGraphicsExporterSubType = FOUR_CHAR_CODE('base')
};
 
enum {
    graphicsExporterIsBaseExporter = 1L << 0,
    graphicsExporterCanTranscode = 1L << 1,
    graphicsExporterUsesImageCompressor = 1L << 2
};*/

enum {
    GraphicsExporterComponentType = FOUR_CHAR_CODE('grex'),
    kBaseGraphicsExporterSubType = FOUR_CHAR_CODE('base')
};
 
enum {
    graphicsExporterIsBaseExporter = 1L << 0,
    graphicsExporterCanTranscode = 1L << 1,
    graphicsExporterUsesImageCompressor = 1L << 2
};


/*GraphicsExportComponent

Represents a type used by the Graphics Import and Export API.

typedef ComponentInstance GraphicsExportComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef ComponentInstance GraphicsExportComponent;

/*ICMProgressProc

Reports on the progress of a compressor or decompressor.

typedef OSErr (*ICMProgressProcPtr) (short message, Fixed completeness, long refcon);

If you name your function MyICMProgressProc, you would declare it this way:

OSErr MyICMProgressProc (
   short    message,
   Fixed    completeness,
   long     refcon );
Parameters
message

Indicates why the Image Compression Manager called your function. There are three valid messages, listed below. See these constants: 
codecProgressOpen
codecProgressUpdatePercent
codecProgressClose
completeness

Contains a fixed-point value indicating how far the operation has progressed. Its value is always between 0.0 and 1.0. This parameter is valid only when the message field is set to codecProgressUpdatePercent.
refcon

Contains a reference constant value for use by your progress function. Your application specifies the value of this reference constant in the progress function structure you pass to the Image Compression Manager.
Return Value

See Error Codes. Your callback should return noErr if there is no error. When a component calls your progress function, it supplies you with a number that indicates the completion percentage. Your program can cause the component to terminate the current operation by returning a result code of codecAbortErr.
Discussion

The Image Compression Manager calls your progress function only during long operations, and it does not call your function more than 30 times per second.
Declared In
ImageCompression.h*/
typedef OSErr (*ICMProgressProcPtr) (short message, Fixed completeness, long refcon);

/*ICMProgressUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMProgressProcPtr) ICMProgressUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMProgressProcPtr) ICMProgressUPP;

/*ICMProgressProcRecord

Specifies an image compression progress callback.

struct ICMProgressProcRecord {
   ICMProgressUPP    progressProc;
   long              progressRefCon;
};
Fields
progressProc
Discussion

Contains a pointer to your progress function.
progressRefCon
Discussion

Contains a reference constant for use by your progress function.
Discussion

During a compression operation, your compressor may occasionally call a function that the application provides in order to report your progress. This field contains a structure that identifies the progress function. If the progressProc field in this structure is set to NIL, the application has not supplied a progress function
Related Functions
DrawPictureFile
DrawTrimmedPicture
DrawTrimmedPictureFile
FCompressImage
FCompressPicture
FCompressPictureFile
FDecompressImage
GetCompressedPixMapInfo
GraphicsExportGetProgressProc
GraphicsExportSetProgressProc
GraphicsImportGetProgressProc
GraphicsImportSetProgressProc
ImageCodecTrimImage
MakeFilePreview
MakeThumbnailFromPicture
MakeThumbnailFromPictureFile
MakeThumbnailFromPixMap
PreviewMakePreview
SetCompressedPixMapInfo
SetSequenceProgressProc
TrimImage 
Programming Info
C interface file: ImageCompression.h*/

struct ICMProgressProcRecord {
   ICMProgressUPP    progressProc;
   long              progressRefCon;
};
typedef  struct ICMProgressProcRecord ICMProgressProcRecord;

/*ICMProgressProcRecordPtr

Abst_ICMProgressProcRecordPtr

typedef ICMProgressProcRecord * ICMProgressProcRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ICMProgressProcRecord * ICMProgressProcRecordPtr;

/*GraphicsImportComponent

Represents a type used by the Graphics Import and Export API.

typedef ComponentInstance GraphicsImportComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef ComponentInstance GraphicsImportComponent;

/*ICM Preferences and Flags

Constants that represent the flags and preferences for ICM sessions.

enum {
   icmFrameTimeHasVirtualStartTimeAndDuration = 1 << 0,
   icmFrameAlreadyDecoded        = 1 << 1,
   icmFrameTimeIsNonScheduledDisplayTime = 1 << 2,
   icmFrameTimeHasDecodeTime     = 1 << 3,
   icmFrameTimeDecodeImmediately = 1 << 4,
   icmFrameTimeDoNotDisplay      = 1 << 5
};
enum {
   kICMGetChainUltimateParent    = 0,
   kICMGetChainParent            = 1,
   kICMGetChainChild             = 2,
   kICMGetChainUltimateChild     = 3
};
enum {
   kICMImageBufferNoPreference   = 0,
   kICMImageBufferPreferMainMemory = 1,
   kICMImageBufferPreferVideoMemory = 2
};
enum {
   kICMNoDeinterlacing           = 0,
   kICMDeinterlaceFields         = 1
};
enum {
   kICMPixelFormatIsPlanarMask   = 0x0F,
   // these bits in formatFlags indicate how many planes there are; they're 0 if chunky
   kICMPixelFormatIsIndexed      = (1L << 4),
   kICMPixelFormatIsSupportedByQD = (1L << 5),
   kICMPixelFormatIsMonochrome   = (1L << 6),
   kICMPixelFormatHasAlphaChannel = (1L << 7)
};
enum {
   kICMSequenceTaskWeight        = 'twei',
   // data is pointer to UInt32
   kICMSequenceTaskName          = 'tnam',
   //data is pointer to OSType
   kICMSequenceUserPreferredCodecs = 'punt' // data is pointer to CodecComponentHandle
};
enum {
   kICMTempThenAppMemory         = 1L << 12,
   kICMAppThenTempMemory         = 1L << 13
};
Constants
icmFrameTimeHasVirtualStartTimeAndDuration

Indicates that virtualStartTime and virtualDuration are valid. 

Available in Mac OS X v10.0 and later.
icmFrameTimeHasDecodeTime

Indicates that decodeTime is valid. 

Available in Mac OS X v10.3 and later.
kICMPixelFormatIsPlanarMask

If this flag is 1, the pixel format is a planar mask and bitsPerPixel[] represents the bits for each pixel component. If this flag is 0, the pixel format is chunky (not planar) and bitsPerPixel[0] represents the bits per pixel. Chunky pixel formats pack the different components together. For example, 3 pixels of 32-bit ARGB is represented in memory as ARGBARGBARGB. Planar formats pack the different components separately. If the pixel format is planar, then (formatFlags & kICMPixelFormatIsPlanarMask) is equal to the number of components. 

Available in Mac OS X v10.0 and later.
kICMPixelFormatIsIndexed

If the pixel format is indexed (which, by definition, means that there are no individual components) then this flag is 1. Generally, color modes of 8 bit per pixel or less are indexed. 

Available in Mac OS X v10.0 and later.
kICMPixelFormatIsSupportedByQD

If this flag is 1, you can call QuickDraw on PixMap structures that store this kind of pixel data. With Macintosh, the classic QD pixel formats will have this set, but not any of the YUV pixel formats. With Windows, more formats will have this set, because the Windows implementation of QuickDraw needs to support more pixel formats. 

Available in Mac OS X v10.0 and later.
kICMSequenceUserPreferredCodecs

Data is pointer to CodecComponentHandle. 

Available in Mac OS X v10.0 and later.*/
enum {
   icmFrameTimeHasVirtualStartTimeAndDuration = 1 << 0,
   icmFrameAlreadyDecoded        = 1 << 1,
   icmFrameTimeIsNonScheduledDisplayTime = 1 << 2,
   icmFrameTimeHasDecodeTime     = 1 << 3,
   icmFrameTimeDecodeImmediately = 1 << 4,
   icmFrameTimeDoNotDisplay      = 1 << 5
};
enum {
   kICMGetChainUltimateParent    = 0,
   kICMGetChainParent            = 1,
   kICMGetChainChild             = 2,
   kICMGetChainUltimateChild     = 3
};
enum {
   kICMImageBufferNoPreference   = 0,
   kICMImageBufferPreferMainMemory = 1,
   kICMImageBufferPreferVideoMemory = 2
};
enum {
   kICMNoDeinterlacing           = 0,
   kICMDeinterlaceFields         = 1
};
enum {
   kICMPixelFormatIsPlanarMask   = 0x0F,
   /* these bits in formatFlags indicate how many planes there are; they're 0 if chunky*/
   kICMPixelFormatIsIndexed      = (1L << 4),
   kICMPixelFormatIsSupportedByQD = (1L << 5),
   kICMPixelFormatIsMonochrome   = (1L << 6),
   kICMPixelFormatHasAlphaChannel = (1L << 7)
};
enum {
   kICMSequenceTaskWeight        = 'twei',
   /* data is pointer to UInt32*/
   kICMSequenceTaskName          = 'tnam',
   /* data is pointer to OSType*/
   kICMSequenceUserPreferredCodecs = 'punt' /* data is pointer to CodecComponentHandle*/
};
enum {
   kICMTempThenAppMemory         = 1L << 12,
   kICMAppThenTempMemory         = 1L << 13
};

/*decompressionTrackingFlags

One or more flags describing the a frame's state transitions:
kICMDecompressionTracking_LastCall = 1L<<0

This is the last call for this sourceFrameRefCon.
kICMDecompressionTracking_ReleaseSourceData = 1L<<1

The session no longer needs the source data pointer.
kICMDecompressionTracking_EmittingFrame = 1L<<2

A frame is being emitted. The pixelBuffer parameter contains the decompressed frame. If the decompression session is targetting a visual context, the frame has not yet been sent to the visual context but will be sent after the callback returns.
kICMDecompressionTracking_FrameDecoded = 1L<<3

This frame was decoded.
kICMDecompressionTracking_FrameDropped = 1L<<4

The codec decided to drop this frame.
kICMDecompressionTracking_FrameNeedsRequeueing = 1L<<5

This frame will not be able to be displayed unless it is queued for redecode ( this constant is also known as FrameNotDisplayable).*/
enum {
kICMDecompressionTracking_LastCall = 1L<<0,
kICMDecompressionTracking_ReleaseSourceData = 1L<<1,
kICMDecompressionTracking_EmittingFrame = 1L<<2,
kICMDecompressionTracking_FrameDecoded = 1L<<3,
kICMDecompressionTracking_FrameDropped = 1L<<4,
kICMDecompressionTracking_FrameNeedsRequeueing = 1L<<5
};

/*ICM Property IDs

Constants that contain the IDs of ICM properties.

enum {
      //Both fields should be decompressed.
   
   kICMFieldMode_BothFields      = 0,
   
   // Only the top field should be decompressed,
   //producing a half-height
   // image.
   //
   kICMFieldMode_TopFieldOnly    = 1,
   
   //Only the bottom field should be decompressed,
   //producing a
   //half-height image.
   
   /ICMFieldMode_BottomFieldOnly = 2,
   //
   //Both fields should be decompressed,
   //and then filtered to reduce
   /interlacing artifacts.
   //
   kICMFieldMode_DeinterlaceFields = 3
};
enum {
   /*
   * Class identifier for compression frame options object properties.
   */
   //kQTPropertyClass_ICMCompressionFrameOptions = 'icfo',
   /*
   * Forces frames to be compressed as key frames.
   * The compressor must obey the "force key frame" flag if set. By
   * default this property is false.
   */
 //  kICMCompressionFrameOptionsPropertyID_ForceKeyFrame = 'keyf',
   /* Boolean,
   Read/Write */
   /*
   * Requests a frame be compressed as a particular frame type.
   *  The frame type setting may be ignored by the compressor if not
   * appropriate.
   * By default this is set to kICMFrameType_Unknown.
   * Do not assume that kICMFrameType_I means a key frame; if you need
   * a key frame,
   set the "force key frame" property.
   */
   //kICMCompressionFrameOptionsPropertyID_FrameType = 'frty' /* ICMFrameType,
  // Read/Write */
//};
//enum {
   /*
   * Class identifier for compression session options object properties.
   */
   //kQTPropertyClass_ICMCompressionSessionOptions = 'icso',
   /*
   * Enables temporal compression. By default,
   temporal compression is
   * disabled.
   * IMPORTANT: If you want temporal compression (P frames and/or B
   * frames) you must set this to true.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression = 'p ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables frame reordering.
   * In order to encode B frames,
   a compressor must reorder frames,
   * which means that the order in which they will be emitted and
   * stored (the decode order) is different from the order in which
   * they were presented to the compressor (the display order).
   * By default,
   frame reordering is disabled.
   * IMPORTANT: In order to encode using B frames,
   you must enable
   * frame reordering.
   */
  // kICMCompressionSessionOptionsPropertyID_AllowFrameReordering = 'b ok',
   /* Boolean,
   Read/Write */
   /*
   * Indicates that durations of emitted frames are needed.
   * If this flag is set and source frames are provided with times but
   * not durations,
   then frames will be delayed so that durations can
   * be calculated as the difference between one frame's time stamp and
   * the next frame's time stamp.
   * By default,
   this flag is clear,
   so frames will not be delayed in
   * order to calculate durations.
   * IMPORTANT: If you will be passing encoded frames to
   * AddMediaSampleFromEncodedFrame,
   you must set this flag to true.
   */
  // kICMCompressionSessionOptionsPropertyID_DurationsNeeded = 'need',
   /* Boolean,
   Read/Write */
   /*
   * The maximum interval between key frames,
   also known as the key
   * frame rate.
   * Key frames,
   also known as sync frames,
   reset inter-frame
   * dependencies; decoding a key frame is sufficient to prepare a
   * decompressor for correctly decoding the difference frames that
   * follow.
   * Compressors are allowed to generate key frames more frequently if
   * this would result in more efficient compression.
   * The default key frame interval is 0,
   which indicates that the
   * compressor should choose where to place all key frames. A key
   * frame interval of 1 indicates that every frame must be a key
   * frame,
   2 indicates that at least every other frame must be a key
   * frame,
   etc.
   */
   //kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval = 'kyfr',
   /* SInt32,
   Read/Write */
   /*
   * The requested maximum interval between partial sync frames. If the
   * interval is n,
   any sequence of n successive frames must include at
   * least one key or partial sync frame.
   * Where supported,
   partial sync frames perform a partial reset of
   * inter-frame dependencies; decoding two partial sync frames and the
   * non-droppable difference frames between them is sufficient to
   * prepare a decompressor for correctly decoding the difference
   * frames that follow.
   * Compressors are allowed to generate partial sync frames more
   * frequently if this would result in more efficient compression.
   *
   * The default partial sync frame interval is 0,
   which indicates that
   * the compressor should choose where to place partial sync frames. A
   * partial sync frame interval of 1 means there can be no difference
   * frames,
   so it is equivalent to a key frame interval of 1. A
   * partial sync frame interval of 2 means that every other frame must
   * be a key frame or a partial sync frame.
   * Compressors that do not support partial sync frames will ignore
   * this setting.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval = 'psfr',
   /* SInt32,
   Read/Write */
   /*
   * Enables the compressor to modify frame times.
   * Some compressors are able to identify and coalesce runs of
   * identical frames and output single frames with longer duration,
   or
   * output frames at a different frame rate from the original. This
   * feature is controlled by the "allow frame time changes" flag. By
   * default,
   this flag is set to false,
   which forces compressors to
   * emit one encoded frame for every source frame,
   and to preserve
   * frame display times.
   * (Note: this feature replaces the practice of having compressors
   * return special high similarity values to indicate that frames
   * could be dropped.)
   * If you want to allow the compressor to modify frame times in order
   * to improve compression performance,
   enable frame time changes.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges = '+ ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables the compressor to call the encoded-frame callback from a
   * different thread.
   * By default,
   the flag is false,
   which means that the compressor
   * must call the encoded-frame callback from the same thread that
   * ICMCompressionSessionEncodeFrame and
   * ICMCompressionSessionCompleteFrames were called on.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion = 'asok',
   /* Boolean,
   Read/Write */
   /*
   * The maximum frame delay count is the maximum number of frames that
   * a compressor is allowed to hold before it must output a compressed
   * frame. It limits the number of frames that may be held in the
   * "compression window". If the maximum frame delay count is M,
   then
   * before the call to encode frame N returns,
   frame N-M must have
   * been emitted.
   * The default is kICMUnlimitedFrameDelayCount,
   which sets no limit
   * on the compression window.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount = 'cwin',
   /* SInt32,
   Read/Write */
   /*
   * The maximum frame delay time is the maximum difference between a
   * source frame's display time and the corresponding encoded frame's
   * decode time. It limits the span of display time that may be held
   * in the "compression window". If the maximum frame delay time is
   * TM,
   then before the call to encode a frame with display time TN
   * returns,
   all frames with display times up to and including TN-TM
   * must have been emitted.
   * The default is kICMUnlimitedFrameDelayTime,
   which sets no time
   * limit on the compression window.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime = 'cwit',
   /* TimeValue64,
   Read/Write */
   /*
   * Sets a specific compressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * Use this API to force the Image Compression Manager to use a
   * specific compressor component or compressor component instance.
   * (If you pass in a component instance that you opened,
   the ICM will
   * not close that instance; you must do so after the compression
   * session is released.) To allow the Image Compression Manager to
   * choose the compressor component,
   set the compressorComponent to
   * anyCodec (the default),
   bestSpeedCodec,
   bestFidelityCodec or
   * bestCompressionCodec.
   */
 //  kICMCompressionSessionOptionsPropertyID_CompressorComponent = 'imco',
   /* CompressorComponent,
   Read/Write */
   /*
   * A handle containing compressor settings. The compressor will be
   * configured with these settings (by a call to
   * ImageCodecSetSettings) during ICMCompressionSessionCreate.
   */
  // kICMCompressionSessionOptionsPropertyID_CompressorSettings = 'cost',
   /* Handle,
   Read/Write */
   /*
   * The depth for compression.
   * If a compressor does not support a specific depth,
   the closest
   * supported depth will be used (preferring deeper depths to
   * shallower depths). The default depth is k24RGBPixelFormat.
   */
 //  kICMCompressionSessionOptionsPropertyID_Depth = 'deep',
   /* UInt32,
   Read/Write */
   /*
   * The color table for compression.  Used with indexed-color depths.
   *
   * Clients who get this property are responsible for disposing the
   * returned CTabHandle.
   */
  // kICMCompressionSessionOptionsPropertyID_ColorTable = 'clut',
   /* CTabHandle,
   Read/Write*/
   /*
   * The compression quality.
   * This value is always used to set the spatialQuality; if temporal
   * compression is enabled,
   it is also used to set temporalQuality.
   * <BR> The default quality is codecNormalQuality.
   */
   //kICMCompressionSessionOptionsPropertyID_Quality = 'qual',
   /* CodecQ,
   Read/Write */
   /*
   * The long-term desired average data rate in bytes per second.
   *  This is not a hard limit.
   * The default data rate is zero,
   which indicates that the quality
   * setting should determine the size of compressed data.
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
  // kICMCompressionSessionOptionsPropertyID_AverageDataRate = 'aver',
   /* SInt32,
   Read/Write */
   /*
   * Zero,
   one or two hard limits on data rate.
   * Each hard limit is described by a data size in bytes and a
   * duration in seconds,
   and requires that the total size of
   * compressed data for any contiguous segment of that duration (in
   * decode time) must not exceed the data size.
   * By default,
   no data rate limits are set.
   * When setting this property,
   the inPropValueSize parameter should
   * be the number of data rate limits multiplied by
   * sizeof(ICMDataRateLimit).
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
  // kICMCompressionSessionOptionsPropertyID_DataRateLimits = 'hard',
   /* C array of ICMDataRateLimit struct,
   Read/Write */
   /*
   * The current number of data rate limits.
   */
  // kICMCompressionSessionOptionsPropertyID_DataRateLimitCount = 'har#',
   /* UInt32,
   Read */
   /*
   * The maximum allowed number of data rate limits.  (Currently 2.)
   */
  // kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits = 'mhar',
   /* UInt32,
   Read */
   /*
   * Indicates that the source was previously compressed.
   * This property is purely an optional,
   informational hint to the
   * compressor; by default it is false.
   */
  // kICMCompressionSessionOptionsPropertyID_WasCompressed = 'wasc',
   /* Boolean,
   Read/Write */
   /*
   * Recommends a CPU time budget for the compressor in microseconds
   * per frame.
   * Zero means to go as fast as possible.
   * By default,
   this is set to kICMUnlimitedCPUTimeBudget,
   which sets
   * no limit.
   * This is an advisory hint to the compressor,
   and some compressors
   * may ignore it. Multithreaded compressors may use this amount of
   * CPU time on each processor.
   * Compressors should not feel compelled to use the full time budget
   * if they complete ahead of time!
   */
  // kICMCompressionSessionOptionsPropertyID_CPUTimeBudget = 'cput',
   /* UInt32,
   Read/Write */
   /*
   * Storage for multi-pass compression.
   * To enable multipass compression,
   the client must provide a storage
   * location for multipass data.  Use
   * ICMMultiPassStorageCreateWithTemporaryFile to have the ICM store
   * it in a temporary file.  Use
   * ICMMultiPassStorageCreateWithCallbacks to manage the storage
   * yourself.
   * Note that the amount of multipass data to be stored can be
   * substantial; it could be greater than the size of the output movie
   * file.
   * If this property is not NULL,
   the client must call
   * ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass
   * around groups of calls to ICMCompressionSessionEncodeFrame.
   *  By default,
   this property is NULL and multipass compression is
   * not enabled. The compression session options object retains the
   * multipass storage object,
   when one is set.
   */
   //kICMCompressionSessionOptionsPropertyID_MultiPassStorage = 'imps',
   /* ICMMultiPassStorageRef,
   Read/Write */
   /*
   * Indicates the number of source frames,
   if known. If nonzero,
   this
   * should be the exact number of times that the client calls
   * ICMCompressionSessionEncodeFrame in each pass.
   * The default is 0,
   which indicates that the number of source frames
   * is not known.
   */
 //  kICMCompressionSessionOptionsPropertyID_SourceFrameCount = 'frco',
   /* UInt64,
   Read/Write */
   /*
   * Indicates the expected frame rate,
   if known. The frame rate is
   * measured in frames per second. This is not used to control the
   * frame rate; it is provided as a hint to the compressor so that it
   * can set up internal configuration before compression begins. The
   * actual frame rate will depend on frame durations and may vary. By
   * default,
   this is zero,
   indicating "unknown".
   */
  // kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate = 'fran',
   /* Fixed,
   Read/Write */
   /*
   * Indicates how source frames to a compression session should be
   * scaled if the dimensions and/or display aspect ratio do not match.
   */
  // kICMCompressionSessionOptionsPropertyID_ScalingMode = 'scam',
   /* OSType,
   Read/Write */
   /*
   * Describes the clean aperture for compressed frames. Note that if
   * the compressor enforces a clean aperture,
   it will override this
   * setting. The clean aperture will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
 //  kICMCompressionSessionOptionsPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio for compressed frames. Note that
   * if the compressor enforces a pixel aspect ratio,
   it will override
   * this setting. The pixel aspect ratio will be set on the output
   * image description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
  // kICMCompressionSessionOptionsPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the number and order of fields for compressed frames.
   * Note that if the compressor enforces field info,
   it will override
   * this setting. The field info will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
  // kICMCompressionSessionOptionsPropertyID_FieldInfo = 'fiel' /* FieldInfoImageDescriptionExtension2,
   //Read/Write */
//};
//enum {
   /*
   * Class identifier for compression session properties.
   */
  // kQTPropertyClass_ICMCompressionSession = 'icse',
   /*
   * The time scale for the compression session.
   */
 //  kICMCompressionSessionPropertyID_TimeScale = 'tscl',
   /* TimeScale,
   Read */
   /*
   * The compressor's pixel buffer attributes for the compression
   * session. You can use these to create a pixel buffer pool for
   * source pixel buffers. Note that this is not the same as the
   * sourcePixelBufferAttributes passed in to
   * ICMCompressionSessionCreate. Getting this property does not change
   * its retain count.
   */
  // kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes = 'batt',
   /* CFDictionaryRef,
   Read */
   /*
   * A pool that can provide ideal source pixel buffers for a
   * compression session. The compression session creates this pixel
   * buffer pool based on the compressor's pixel buffer attributes and
   * any pixel buffer attributes passed in to
   * ICMCompressionSessionCreate. If the source pixel buffer attributes
   * and the compressor pixel buffer attributes can not be reconciled,
   * the pool is based on the source pixel buffer attributes and the
   * ICM converts each CVPixelBuffer internally.
   */
  // kICMCompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * The image description for the compression session. For some
   * codecs,
   the image description may not be available before the
   * first frame is compressed. Multiple calls to retrieve this
   * property will return the same handle. The ICM will dispose this
   * handle when the compression session is disposed.
   * IMPORTANT: The caller must NOT dispose this handle.
   */
  // kICMCompressionSessionPropertyID_ImageDescription = 'idsc' /* ImageDescriptionHandle,
  // Read */
//};
//enum {
   /*
   * Class identifier for decompression frame options object properties.
   */
  // kQTPropertyClass_ICMDecompressionFrameOptions = 'idfo',
   /*
   * A specific pixel buffer that the frame should be decompressed
   * into. Setting this circumvents the pixel buffer pool mechanism. If
   * this buffer is not compatible with the codec's pixel buffer
   * requirements,
   decompression will fail.
   */
  // kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer = 'cvpb' /* CVPixelBufferRef,
 //  Read/Write */
//};
//enum {
   /*
   * Class identifier for decompression session options object
   * properties.
   */
  // kQTPropertyClass_ICMDecompressionSessionOptions = 'idso',
   /*
   * By default,
   this is true,
   meaning that frames must be output in
   * display order. Set this to false to allow frames to be output in
   * decode order rather than in display order.
   */
  // kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired = 'dorq',
   /* Boolean,
   Read/Write */
   /*
   * A specific decompressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * By default,
   this is anyCodec.
   */
   //kICMDecompressionSessionOptionsPropertyID_DecompressorComponent = 'imdc',
   /* DecompressorComponent,
   Read/Write */
   /*
   * The decompression accuracy.
   * The default accuracy is codecNormalQuality.
   */
//   kICMDecompressionSessionOptionsPropertyID_Accuracy = 'acur',
   /* CodecQ,
   Read/Write */
   /*
   * Requests special handling of fields. Not all codecs will obey this
   * request; some codecs will only handle it at certain accuracy
   * levels. Ignored for non-interlaced content.
   */
   //kICMDecompressionSessionOptionsPropertyID_FieldMode = 'fiel',
   /* ICMFieldMode,
   Read/Write */
   /*
   * The maximum number of buffers ahead of the current time that
   * should be decompressed. Used in sessions that target visual
   * contexts. By default,
   the number of buffers will be determined
   * from the visual context.
   */
  // kICMDecompressionSessionOptionsPropertyID_MaxBufferCount = 'm#bf',
   /* UInt32,
   Read/Write */
   /*
   * The minimum time ahead of the current time that frames should be
   * decompressed. Used in sessions that target visual contexts. By
   * default,
   the output-ahead time will be determined from the visual
   * context.
   */
  // kICMDecompressionSessionOptionsPropertyID_OutputAheadTime = 'futu' /* TimeRecord,
  // Read/Write */
////};
//enum {
   /*
   * Class identifier for decompression session properties.
   */
  // kQTPropertyClass_ICMDecompressionSession = 'icds',
   /*
   * The non-scheduled display time for a decompression session.
   * Setting this requests display of the non-scheduled queued frame at
   * that display time,
   if there is one.
   * See ICMDecompressionSessionSetNonScheduledDisplayTime.
   */
  // kICMDecompressionSessionPropertyID_NonScheduledDisplayTime = 'nsti',
   /* ICMNonScheduledDisplayTime,
   Read/Write */
   /*
   * The direction for non-scheduled display time.
   * See ICMDecompressionSessionSetNonScheduledDisplayDirection.
   */
  // kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection = 'nsdu',
   /* Fixed,
   Read/Write */
   /*
   * The pixel buffer pool from which emitted pixel buffers are
   * allocated. Getting this does not change the retain count of the
   * pool.
   */
 //  kICMDecompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * Indicates whether the a common pixel buffer pool is shared between
   * the decompressor and the session client. This is false if separate
   * pools are used because the decompressor's and the client's pixel
   * buffer attributes were incompatible.
   */
//   kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared = 'plsh' /* Boolean,
//   Read */
//};
//enum {
   /*
   * Class identifier for image description properties.
   */
  // kQTPropertyClass_ImageDescription = 'idsc',
   /*
   * The width of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's width field.
 //  */
//   kICMImageDescriptionPropertyID_EncodedWidth = 'encw',
   /* SInt32,
   Read/Write */
   /*
   * The height of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's height field.
   */
//   kICMImageDescriptionPropertyID_EncodedHeight = 'ench',
   /* SInt32,
   Read/Write */
   /*
   * Describes the clean aperture of the buffer. If not specified
   * explicitly in the image description,
   the default clean aperture
   * (full encoded width and height) will be returned.
   */
  // kICMImageDescriptionPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio. If not specified explicitly in
   * the image description,
   a square (1:1) pixel aspect ratio will be
   * returned.
   */
  // kICMImageDescriptionPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * A width at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
 //  kICMImageDescriptionPropertyID_DisplayWidth = 'disw',
   /* SInt32,
   Read */
   /*
   * A height at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
 //  kICMImageDescriptionPropertyID_DisplayHeight = 'dish',
   /* SInt32,
   Read */
   /*
   * A width at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayWidth instead.
   */
  // kICMImageDescriptionPropertyID_ProductionDisplayWidth = 'pdsw',
   /* SInt32,
   Read */
   /*
   * A height at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayHeight instead.
   */
 //  kICMImageDescriptionPropertyID_ProductionDisplayHeight = 'pdsh',
   /* SInt32,
   Read */
   /*
   * Color information,
   if available in the
   * NCLCColorInfoImageDescriptionExtension format.
   */
 //  kICMImageDescriptionPropertyID_NCLCColorInfo = 'nclc',
   /* Native-endian NCLCColorInfoImageDescriptionExtension,
   Read/Write */
   /*
   * The gamma level described by the image description.
   */
//   kICMImageDescriptionPropertyID_GammaLevel = 'gama',
   /* Fixed,
   Read/Write */
   /*
   * Information about the number and order of fields,
   if available.
   */
//   kICMImageDescriptionPropertyID_FieldInfo = 'fiel',
   /* FieldInfoImageDescriptionExtension2,
   Read/Write */
   /*
   * The offset in bytes from the start of one row to the next. Only
   * valid if the codec type is a chunky pixel format.
   */
 //  kICMImageDescriptionPropertyID_RowBytes = 'rowb',
   /* SInt32,
   Read/Write */
   /*
   * A track width suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
  // kICMImageDescriptionPropertyID_ClassicTrackWidth = 'claw',
   /* Fixed,
   Read */
   /*
   * A track height suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
  // kICMImageDescriptionPropertyID_ClassicTrackHeight = 'clah' /* Fixed,
 //  Read */
//};
//enum {
   /*
   * In this pass the compressor shall output encoded frames.
   */
  // kICMCompressionPassMode_OutputEncodedFrames = 1L << 0,
   /*
   * In this pass the client need not provide source frame buffers.
   */
   //kICMCompressionPassMode_NoSourceFrames = 1L << 1,
   /*
   * In this pass the compressor may write private data to multipass
   * storage.
   */
 //  kICMCompressionPassMode_WriteToMultiPassStorage = 1L << 2,
   /*
   * In this pass the compressor may read private data from multipass
   * storage.
   */
  // kICMCompressionPassMode_ReadFromMultiPassStorage = 1L << 3,
   /*
   * The compressor will set this flag to indicate that it will not be
   * able to output encoded frames in the coming pass. If this flag is
   * not set,
   then the client is allowed to set the
   * kICMCompressionPassMode_OutputEncodedFrames flag before calling
   * ICMCompressionSessionBeginPass.
   */
  // kICMCompressionPassMode_NotReadyToOutputEncodedFrames = 1L << 4
//};
//enum {
   /*
   * Indicates that this is the last call for this sourceFrameRefCon.
   */
  // kICMSourceTracking_LastCall   = 1L << 0,
   /*
   * Indicates that the session is done with the source pixel buffer
   * and has released any reference to it that it had.
   */
  // kICMSourceTracking_ReleasedPixelBuffer = 1L << 1,
   /*
   * Indicates that this frame was encoded.
   */
  // kICMSourceTracking_FrameWasEncoded = 1L << 2,
   /*
   * Indicates that this frame was dropped.
   */
   //kICMSourceTracking_FrameWasDropped = 1L << 3,
   /*
   * Indicates that this frame was merged into other frames.
   */
  // kICMSourceTracking_FrameWasMerged = 1L << 4,
   /*
   * Indicates that the time stamp of this frame was modified.
   */
 //  kICMSourceTracking_FrameTimeWasChanged = 1L << 5,
   /*
   * Indicates that the ICM has copied the image from the source pixel
   * buffer into another pixel buffer because the source pixel buffer
   * was not compatible with the compressor's required pixel buffer
   * attributes.
   */
 //  kICMSourceTracking_CopiedPixelBuffer = 1L << 6
//};
//enum {
   /*
   * The full width and height of source frames shall be scaled to the
   * full width and height of the destination. This is the default if
   * no other scaling mode is specified.
   */
//   kICMScalingMode_StretchProductionAperture = 'sp2p',
   /*
   * The clean aperture of the source frames shall be scaled to the
   * clean aperture of the destination.
   */
//   kICMScalingMode_StretchCleanAperture = 'sc2c',
   /*
   * The clean aperture of the source frames shall be scaled to fit
   * inside the clean aperture of the destination,
   preserving the
   * original display aspect ratio. If the display aspect ratios are
   * different,
   the source frames will be centered with black bars
   * above and below,
   or to the left and right.
   */
 //  kICMScalingMode_Letterbox     = 'lett',
   /*
   * The clean aperture of the source frames shall be scaled to cover
   * the clean aperture of the destination,
   preserving the original
   * display aspect ratio. If the display aspect ratios are different,
   * the source frames will be centered and cropped.
   */
  // kICMScalingMode_Trim          = 'trim'
/*};
Constants
kICMCompressionFrameOptionsPropertyID_ForceKeyFrame

Boolean, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionFrameOptionsPropertyID_FrameType

ICMFrameType, ReadWrite. 

Available in Mac OS X v10.3 and later.
kQTPropertyClass_ICMCompressionSessionOptions

Class identifier for compression session option object properties. Also 'icso'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression

Enables temporal compression of P-frames and B-frames. By default, temporal compression is disabled. Also 'p ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowFrameReordering

Enables frame reordering. To encode B-frames a compressor must reorder frames, which may mean that the order in which they are emitted and stored (the decode order) may be different from the order in which they are presented to the compressor (the display order). By default, frame reordering is disabled. To encode using B-frames, you must enable frame reordering by passing TRUE in this property. Also 'b ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DurationsNeeded

Indicates that durations of emitted frames are needed. If this option is set and source frames are provided with times but not durations, then frames will be delayed so that durations can be calculated as the difference between one frame's time stamp and the next frame's time stamp. By default, this flag is FALSE, so frames will not be delayed in order to calculate durations. If you pass encoded frames to AddMediaSampleFromEncodedFrame, you must set this flag to TRUE. Also 'need'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval

The maximum interval between key frames, also known as the key frame rate. Compressors are allowed to generate key frames more frequently if this would result in more efficient compression. The default key frame interval is 0, which indicates that the compressor should choose where to place all key frames. This differs from previous practice, in which a key frame rate of zero disabled temporal compression. Also 'kyfr'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges

Enables the compressor to modify frame times, improving its performance. Some compressors are able to identify and coalesce runs of identical frames and emit single frames with longer duration, or emit frames at a different frame rate from the original. By default, this flag is set to FALSE, which forces the compressor to emit one encoded frame for every source frame and to preserve frame display times. This option replaces the practice of having compressors return special high similarity values to indicate that frames can be dropped. Also '+ ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion

Enables the compressor to call the encoded-frame callback from a different thread. By default this option is FALSE, which means that the compressor must call the encoded-frame callback from the same thread as ICMCompressionSessionEncodeFrame and ICMCompressionSessionCompleteFrames. Also 'asok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount

The maximum frame delay count is the maximum number of frames that a compressor is allowed to hold before it must output a compressed frame. This value limits the number of frames that may be held in the compression window. If the maximum frame delay count is M, then before the call to encode frame N returns, frame N-M must have been emitted. The default value is kICMUnlimitedFrameDelayCount, which sets no limit on the compression window. Also 'cwin'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime

TimeValue64, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CompressorComponent

Sets a specific compressor component or component instance to be used, or passes one of the wildcards anyCodec, bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. Pass this option to force the Image Compression Manager to use a specific compressor component or compressor component instance. To allow the Image Compression Manager to choose the compressor component, set the compressorComponent to anyCodec (the default), bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. If you pass in a component instance that you opened, the ICM will not close that instance; you must do so after the compression session is released. Also 'imco'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CompressorSettings

A handle containing compressor settings. The compressor will be configured with these settings (by a call to ImageCodecSetSettings) during the ICMCompressionSessionCreate process. Also 'cost'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_Depth

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ColorTable

The color table for compression, used with indexed-color depths. Clients who are passed this property are responsible for disposing the returned CTabHandle. Also 'clut'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_Quality

The compression quality. This value is always used to set the spatial quality; if temporal compression is enabled, it is also used to set temporal quality. The default quality is codecNormalQuality. Also 'qual'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AverageDataRate

The long-term desired average data rate in bytes per second. This is not an absolute limit. The default data rate is zero, indicating that the setting of kICMCompressionSessionOptionsPropertyID_Quality should determine the size of compressed data. Data rate settings have effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'aver'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DataRateLimits

Zero, one, or two hard limits on data rate. Each hard limit is described by a data size in bytes and a duration in seconds. It requires that the total size of compressed data for any contiguous segment of that duration (in decode time) must not exceed the data size. By default, no data rate limits are set. When setting this property, the inPropValueSize parameter should be the number of data rate limits multiplied by sizeof(ICMDataRateLimit). Data rate settings have an effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'hard'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DataRateLimitCount

UInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits

UInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_WasCompressed

Indicates that the source was previously compressed. This property is an optional information hint to the compressor; by default it is FALSE. Also 'wasc'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CPUTimeBudget

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MultiPassStorage

A multipass compression client must provide a storage location for multipass data. Pass ICMMultiPassStorageCreateWithTemporaryFile to make the ICM store multipass data in a temporary file. Pass ICMMultiPassStorageCreateWithCallbacks to manage the storage yourself. Note that the amount of multipass data to be stored can be substantial; it could be greater than the size of the output movie file. If this property is not NULL, the client must call ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass around groups of calls to ICMCompressionSessionEncodeFrame. By default, this property is NULL and multipass compression is not enabled. The compression session options object retains the multipass storage object when one is set. Also 'imps'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_SourceFrameCount

UInt64, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ScalingMode

OSType, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CleanAperture

Native-endian CleanApertureImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_PixelAspectRatio

Native-endian PixelAspectRatioImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_FieldInfo

FieldInfoImageDescriptionExtension2, ReadWrite. 

Available in Mac OS X v10.3 and later.
kQTPropertyClass_ICMCompressionSession

Class identifier for compression session properties. Also 'icse'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_TimeScale

The time scale for the compression session. Also 'tscl'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes

The compressor's pixel buffer attributes for the compression session. You can use these to create a pixel buffer pool for source pixel buffers. This is not the same as the sourcePixelBufferAttributes property passed to ICMCompressionSessionCreate. Getting this property does not change its retain count. Also 'batt'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_PixelBufferPool

A pool that can provide ideal source pixel buffers for a compression session. The compression session creates this pixel buffer pool based on the compressor's pixel buffer attributes and any pixel buffer attributes passed in to ICMCompressionSessionCreate. If the source pixel buffer attributes and the compressor pixel buffer attributes can not be reconciled, the pool is based on the source pixel buffer attributes and the ICM converts each CVPixelBuffer internally. Also 'pool'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_ImageDescription

The image description for a compression session. For some codecs, the image description may not be available before the first frame is compressed. Multiple calls to retrieve this property will return the same handle. The ICM will dispose of this handle when the compression session is disposed; the caller must not dispose of it. Also 'idsc'.

Available in Mac OS X v10.3 and later.
kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer

CVPixelBufferRef, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired

Boolean, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_DecompressorComponent

DecompressorComponent, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_Accuracy

CodecQ, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_FieldMode

ICMFieldMode, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_MaxBufferCount

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_OutputAheadTime

TimeRecord, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_NonScheduledDisplayTime

ICMNonScheduledDisplayTime, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_PixelBufferPool

CVPixelBufferPoolRef, Read. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared

Boolean, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_EncodedWidth

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_EncodedHeight

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_CleanAperture

Native-endian CleanApertureImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_PixelAspectRatio

Native-endian PixelAspectRatioImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_DisplayWidth

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_DisplayHeight

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ProductionDisplayWidth

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ProductionDisplayHeight

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_NCLCColorInfo

Native-endian NCLCColorInfoImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_GammaLevel

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_FieldInfo

FieldInfoImageDescriptionExtension2, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_RowBytes

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ClassicTrackWidth

Fixed, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ClassicTrackHeight

Fixed, Read. 

Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

enum {
   /*
   * Both fields should be decompressed.
   */
   kICMFieldMode_BothFields      = 0,
   /*
   * Only the top field should be decompressed,
   producing a half-height
   * image.
   */
   kICMFieldMode_TopFieldOnly    = 1,
   /*
   * Only the bottom field should be decompressed,
   producing a
   * half-height image.
   */
   kICMFieldMode_BottomFieldOnly = 2,
   /*
   * Both fields should be decompressed,
   and then filtered to reduce
   * interlacing artifacts.
   */
   kICMFieldMode_DeinterlaceFields = 3
};
enum {
   /*
   * Class identifier for compression frame options object properties.
   */
   kQTPropertyClass_ICMCompressionFrameOptions = 'icfo',
   /*
   * Forces frames to be compressed as key frames.
   * The compressor must obey the "force key frame" flag if set. By
   * default this property is false.
   */
   kICMCompressionFrameOptionsPropertyID_ForceKeyFrame = 'keyf',
   /* Boolean,
   Read/Write */
   /*
   * Requests a frame be compressed as a particular frame type.
   *  The frame type setting may be ignored by the compressor if not
   * appropriate.
   * By default this is set to kICMFrameType_Unknown.
   * Do not assume that kICMFrameType_I means a key frame; if you need
   * a key frame,
   set the "force key frame" property.
   */
   kICMCompressionFrameOptionsPropertyID_FrameType = 'frty' /* ICMFrameType,
   Read/Write */
};
enum {
   /*
   * Class identifier for compression session options object properties.
   */
   kQTPropertyClass_ICMCompressionSessionOptions = 'icso',
   /*
   * Enables temporal compression. By default,
   temporal compression is
   * disabled.
   * IMPORTANT: If you want temporal compression (P frames and/or B
   * frames) you must set this to true.
   */
   kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression = 'p ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables frame reordering.
   * In order to encode B frames,
   a compressor must reorder frames,
   * which means that the order in which they will be emitted and
   * stored (the decode order) is different from the order in which
   * they were presented to the compressor (the display order).
   * By default,
   frame reordering is disabled.
   * IMPORTANT: In order to encode using B frames,
   you must enable
   * frame reordering.
   */
   kICMCompressionSessionOptionsPropertyID_AllowFrameReordering = 'b ok',
   /* Boolean,
   Read/Write */
   /*
   * Indicates that durations of emitted frames are needed.
   * If this flag is set and source frames are provided with times but
   * not durations,
   then frames will be delayed so that durations can
   * be calculated as the difference between one frame's time stamp and
   * the next frame's time stamp.
   * By default,
   this flag is clear,
   so frames will not be delayed in
   * order to calculate durations.
   * IMPORTANT: If you will be passing encoded frames to
   * AddMediaSampleFromEncodedFrame,
   you must set this flag to true.
   */
   kICMCompressionSessionOptionsPropertyID_DurationsNeeded = 'need',
   /* Boolean,
   Read/Write */
   /*
   * The maximum interval between key frames,
   also known as the key
   * frame rate.
   * Key frames,
   also known as sync frames,
   reset inter-frame
   * dependencies; decoding a key frame is sufficient to prepare a
   * decompressor for correctly decoding the difference frames that
   * follow.
   * Compressors are allowed to generate key frames more frequently if
   * this would result in more efficient compression.
   * The default key frame interval is 0,
   which indicates that the
   * compressor should choose where to place all key frames. A key
   * frame interval of 1 indicates that every frame must be a key
   * frame,
   2 indicates that at least every other frame must be a key
   * frame,
   etc.
   */
   kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval = 'kyfr',
   /* SInt32,
   Read/Write */
   /*
   * The requested maximum interval between partial sync frames. If the
   * interval is n,
   any sequence of n successive frames must include at
   * least one key or partial sync frame.
   * Where supported,
   partial sync frames perform a partial reset of
   * inter-frame dependencies; decoding two partial sync frames and the
   * non-droppable difference frames between them is sufficient to
   * prepare a decompressor for correctly decoding the difference
   * frames that follow.
   * Compressors are allowed to generate partial sync frames more
   * frequently if this would result in more efficient compression.
   *
   * The default partial sync frame interval is 0,
   which indicates that
   * the compressor should choose where to place partial sync frames. A
   * partial sync frame interval of 1 means there can be no difference
   * frames,
   so it is equivalent to a key frame interval of 1. A
   * partial sync frame interval of 2 means that every other frame must
   * be a key frame or a partial sync frame.
   * Compressors that do not support partial sync frames will ignore
   * this setting.
   */
   kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval = 'psfr',
   /* SInt32,
   Read/Write */
   /*
   * Enables the compressor to modify frame times.
   * Some compressors are able to identify and coalesce runs of
   * identical frames and output single frames with longer duration,
   or
   * output frames at a different frame rate from the original. This
   * feature is controlled by the "allow frame time changes" flag. By
   * default,
   this flag is set to false,
   which forces compressors to
   * emit one encoded frame for every source frame,
   and to preserve
   * frame display times.
   * (Note: this feature replaces the practice of having compressors
   * return special high similarity values to indicate that frames
   * could be dropped.)
   * If you want to allow the compressor to modify frame times in order
   * to improve compression performance,
   enable frame time changes.
   */
   kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges = '+ ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables the compressor to call the encoded-frame callback from a
   * different thread.
   * By default,
   the flag is false,
   which means that the compressor
   * must call the encoded-frame callback from the same thread that
   * ICMCompressionSessionEncodeFrame and
   * ICMCompressionSessionCompleteFrames were called on.
   */
   kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion = 'asok',
   /* Boolean,
   Read/Write */
   /*
   * The maximum frame delay count is the maximum number of frames that
   * a compressor is allowed to hold before it must output a compressed
   * frame. It limits the number of frames that may be held in the
   * "compression window". If the maximum frame delay count is M,
   then
   * before the call to encode frame N returns,
   frame N-M must have
   * been emitted.
   * The default is kICMUnlimitedFrameDelayCount,
   which sets no limit
   * on the compression window.
   */
   kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount = 'cwin',
   /* SInt32,
   Read/Write */
   /*
   * The maximum frame delay time is the maximum difference between a
   * source frame's display time and the corresponding encoded frame's
   * decode time. It limits the span of display time that may be held
   * in the "compression window". If the maximum frame delay time is
   * TM,
   then before the call to encode a frame with display time TN
   * returns,
   all frames with display times up to and including TN-TM
   * must have been emitted.
   * The default is kICMUnlimitedFrameDelayTime,
   which sets no time
   * limit on the compression window.
   */
   kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime = 'cwit',
   /* TimeValue64,
   Read/Write */
   /*
   * Sets a specific compressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * Use this API to force the Image Compression Manager to use a
   * specific compressor component or compressor component instance.
   * (If you pass in a component instance that you opened,
   the ICM will
   * not close that instance; you must do so after the compression
   * session is released.) To allow the Image Compression Manager to
   * choose the compressor component,
   set the compressorComponent to
   * anyCodec (the default),
   bestSpeedCodec,
   bestFidelityCodec or
   * bestCompressionCodec.
   */
   kICMCompressionSessionOptionsPropertyID_CompressorComponent = 'imco',
   /* CompressorComponent,
   Read/Write */
   /*
   * A handle containing compressor settings. The compressor will be
   * configured with these settings (by a call to
   * ImageCodecSetSettings) during ICMCompressionSessionCreate.
   */
   kICMCompressionSessionOptionsPropertyID_CompressorSettings = 'cost',
   /* Handle,
   Read/Write */
   /*
   * The depth for compression.
   * If a compressor does not support a specific depth,
   the closest
   * supported depth will be used (preferring deeper depths to
   * shallower depths). The default depth is k24RGBPixelFormat.
   */
   kICMCompressionSessionOptionsPropertyID_Depth = 'deep',
   /* UInt32,
   Read/Write */
   /*
   * The color table for compression.  Used with indexed-color depths.
   *
   * Clients who get this property are responsible for disposing the
   * returned CTabHandle.
   */
   kICMCompressionSessionOptionsPropertyID_ColorTable = 'clut',
   /* CTabHandle,
   Read/Write*/
   /*
   * The compression quality.
   * This value is always used to set the spatialQuality; if temporal
   * compression is enabled,
   it is also used to set temporalQuality.
   * <BR> The default quality is codecNormalQuality.
   */
   kICMCompressionSessionOptionsPropertyID_Quality = 'qual',
   /* CodecQ,
   Read/Write */
   /*
   * The long-term desired average data rate in bytes per second.
   *  This is not a hard limit.
   * The default data rate is zero,
   which indicates that the quality
   * setting should determine the size of compressed data.
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
   kICMCompressionSessionOptionsPropertyID_AverageDataRate = 'aver',
   /* SInt32,
   Read/Write */
   /*
   * Zero,
   one or two hard limits on data rate.
   * Each hard limit is described by a data size in bytes and a
   * duration in seconds,
   and requires that the total size of
   * compressed data for any contiguous segment of that duration (in
   * decode time) must not exceed the data size.
   * By default,
   no data rate limits are set.
   * When setting this property,
   the inPropValueSize parameter should
   * be the number of data rate limits multiplied by
   * sizeof(ICMDataRateLimit).
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
   kICMCompressionSessionOptionsPropertyID_DataRateLimits = 'hard',
   /* C array of ICMDataRateLimit struct,
   Read/Write */
   /*
   * The current number of data rate limits.
   */
   kICMCompressionSessionOptionsPropertyID_DataRateLimitCount = 'har#',
   /* UInt32,
   Read */
   /*
   * The maximum allowed number of data rate limits.  (Currently 2.)
   */
   kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits = 'mhar',
   /* UInt32,
   Read */
   /*
   * Indicates that the source was previously compressed.
   * This property is purely an optional,
   informational hint to the
   * compressor; by default it is false.
   */
   kICMCompressionSessionOptionsPropertyID_WasCompressed = 'wasc',
   /* Boolean,
   Read/Write */
   /*
   * Recommends a CPU time budget for the compressor in microseconds
   * per frame.
   * Zero means to go as fast as possible.
   * By default,
   this is set to kICMUnlimitedCPUTimeBudget,
   which sets
   * no limit.
   * This is an advisory hint to the compressor,
   and some compressors
   * may ignore it. Multithreaded compressors may use this amount of
   * CPU time on each processor.
   * Compressors should not feel compelled to use the full time budget
   * if they complete ahead of time!
   */
   kICMCompressionSessionOptionsPropertyID_CPUTimeBudget = 'cput',
   /* UInt32,
   Read/Write */
   /*
   * Storage for multi-pass compression.
   * To enable multipass compression,
   the client must provide a storage
   * location for multipass data.  Use
   * ICMMultiPassStorageCreateWithTemporaryFile to have the ICM store
   * it in a temporary file.  Use
   * ICMMultiPassStorageCreateWithCallbacks to manage the storage
   * yourself.
   * Note that the amount of multipass data to be stored can be
   * substantial; it could be greater than the size of the output movie
   * file.
   * If this property is not NULL,
   the client must call
   * ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass
   * around groups of calls to ICMCompressionSessionEncodeFrame.
   *  By default,
   this property is NULL and multipass compression is
   * not enabled. The compression session options object retains the
   * multipass storage object,
   when one is set.
   */
   kICMCompressionSessionOptionsPropertyID_MultiPassStorage = 'imps',
   /* ICMMultiPassStorageRef,
   Read/Write */
   /*
   * Indicates the number of source frames,
   if known. If nonzero,
   this
   * should be the exact number of times that the client calls
   * ICMCompressionSessionEncodeFrame in each pass.
   * The default is 0,
   which indicates that the number of source frames
   * is not known.
   */
   kICMCompressionSessionOptionsPropertyID_SourceFrameCount = 'frco',
   /* UInt64,
   Read/Write */
   /*
   * Indicates the expected frame rate,
   if known. The frame rate is
   * measured in frames per second. This is not used to control the
   * frame rate; it is provided as a hint to the compressor so that it
   * can set up internal configuration before compression begins. The
   * actual frame rate will depend on frame durations and may vary. By
   * default,
   this is zero,
   indicating "unknown".
   */
   kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate = 'fran',
   /* Fixed,
   Read/Write */
   /*
   * Indicates how source frames to a compression session should be
   * scaled if the dimensions and/or display aspect ratio do not match.
   */
   kICMCompressionSessionOptionsPropertyID_ScalingMode = 'scam',
   /* OSType,
   Read/Write */
   /*
   * Describes the clean aperture for compressed frames. Note that if
   * the compressor enforces a clean aperture,
   it will override this
   * setting. The clean aperture will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio for compressed frames. Note that
   * if the compressor enforces a pixel aspect ratio,
   it will override
   * this setting. The pixel aspect ratio will be set on the output
   * image description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the number and order of fields for compressed frames.
   * Note that if the compressor enforces field info,
   it will override
   * this setting. The field info will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_FieldInfo = 'fiel' /* FieldInfoImageDescriptionExtension2,
   Read/Write */
};
enum {
   /*
   * Class identifier for compression session properties.
   */
   kQTPropertyClass_ICMCompressionSession = 'icse',
   /*
   * The time scale for the compression session.
   */
   kICMCompressionSessionPropertyID_TimeScale = 'tscl',
   /* TimeScale,
   Read */
   /*
   * The compressor's pixel buffer attributes for the compression
   * session. You can use these to create a pixel buffer pool for
   * source pixel buffers. Note that this is not the same as the
   * sourcePixelBufferAttributes passed in to
   * ICMCompressionSessionCreate. Getting this property does not change
   * its retain count.
   */
   kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes = 'batt',
   /* CFDictionaryRef,
   Read */
   /*
   * A pool that can provide ideal source pixel buffers for a
   * compression session. The compression session creates this pixel
   * buffer pool based on the compressor's pixel buffer attributes and
   * any pixel buffer attributes passed in to
   * ICMCompressionSessionCreate. If the source pixel buffer attributes
   * and the compressor pixel buffer attributes can not be reconciled,
   * the pool is based on the source pixel buffer attributes and the
   * ICM converts each CVPixelBuffer internally.
   */
   kICMCompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * The image description for the compression session. For some
   * codecs,
   the image description may not be available before the
   * first frame is compressed. Multiple calls to retrieve this
   * property will return the same handle. The ICM will dispose this
   * handle when the compression session is disposed.
   * IMPORTANT: The caller must NOT dispose this handle.
   */
   kICMCompressionSessionPropertyID_ImageDescription = 'idsc' /* ImageDescriptionHandle,
   Read */
};
enum {
   /*
   * Class identifier for decompression frame options object properties.
   */
   kQTPropertyClass_ICMDecompressionFrameOptions = 'idfo',
   /*
   * A specific pixel buffer that the frame should be decompressed
   * into. Setting this circumvents the pixel buffer pool mechanism. If
   * this buffer is not compatible with the codec's pixel buffer
   * requirements,
   decompression will fail.
   */
   kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer = 'cvpb' /* CVPixelBufferRef,
   Read/Write */
};
enum {
   /*
   * Class identifier for decompression session options object
   * properties.
   */
   kQTPropertyClass_ICMDecompressionSessionOptions = 'idso',
   /*
   * By default,
   this is true,
   meaning that frames must be output in
   * display order. Set this to false to allow frames to be output in
   * decode order rather than in display order.
   */
   kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired = 'dorq',
   /* Boolean,
   Read/Write */
   /*
   * A specific decompressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * By default,
   this is anyCodec.
   */
   kICMDecompressionSessionOptionsPropertyID_DecompressorComponent = 'imdc',
   /* DecompressorComponent,
   Read/Write */
   /*
   * The decompression accuracy.
   * The default accuracy is codecNormalQuality.
   */
   kICMDecompressionSessionOptionsPropertyID_Accuracy = 'acur',
   /* CodecQ,
   Read/Write */
   /*
   * Requests special handling of fields. Not all codecs will obey this
   * request; some codecs will only handle it at certain accuracy
   * levels. Ignored for non-interlaced content.
   */
   kICMDecompressionSessionOptionsPropertyID_FieldMode = 'fiel',
   /* ICMFieldMode,
   Read/Write */
   /*
   * The maximum number of buffers ahead of the current time that
   * should be decompressed. Used in sessions that target visual
   * contexts. By default,
   the number of buffers will be determined
   * from the visual context.
   */
   kICMDecompressionSessionOptionsPropertyID_MaxBufferCount = 'm#bf',
   /* UInt32,
   Read/Write */
   /*
   * The minimum time ahead of the current time that frames should be
   * decompressed. Used in sessions that target visual contexts. By
   * default,
   the output-ahead time will be determined from the visual
   * context.
   */
   kICMDecompressionSessionOptionsPropertyID_OutputAheadTime = 'futu' /* TimeRecord,
   Read/Write */
};
enum {
   /*
   * Class identifier for decompression session properties.
   */
   kQTPropertyClass_ICMDecompressionSession = 'icds',
   /*
   * The non-scheduled display time for a decompression session.
   * Setting this requests display of the non-scheduled queued frame at
   * that display time,
   if there is one.
   * See ICMDecompressionSessionSetNonScheduledDisplayTime.
   */
   kICMDecompressionSessionPropertyID_NonScheduledDisplayTime = 'nsti',
   /* ICMNonScheduledDisplayTime,
   Read/Write */
   /*
   * The direction for non-scheduled display time.
   * See ICMDecompressionSessionSetNonScheduledDisplayDirection.
   */
   kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection = 'nsdu',
   /* Fixed,
   Read/Write */
   /*
   * The pixel buffer pool from which emitted pixel buffers are
   * allocated. Getting this does not change the retain count of the
   * pool.
   */
   kICMDecompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * Indicates whether the a common pixel buffer pool is shared between
   * the decompressor and the session client. This is false if separate
   * pools are used because the decompressor's and the client's pixel
   * buffer attributes were incompatible.
   */
   kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared = 'plsh' /* Boolean,
   Read */
};
enum {
   /*
   * Class identifier for image description properties.
   */
   kQTPropertyClass_ImageDescription = 'idsc',
   /*
   * The width of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's width field.
   */
   kICMImageDescriptionPropertyID_EncodedWidth = 'encw',
   /* SInt32,
   Read/Write */
   /*
   * The height of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's height field.
   */
   kICMImageDescriptionPropertyID_EncodedHeight = 'ench',
   /* SInt32,
   Read/Write */
   /*
   * Describes the clean aperture of the buffer. If not specified
   * explicitly in the image description,
   the default clean aperture
   * (full encoded width and height) will be returned.
   */
   kICMImageDescriptionPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio. If not specified explicitly in
   * the image description,
   a square (1:1) pixel aspect ratio will be
   * returned.
   */
   kICMImageDescriptionPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * A width at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
   kICMImageDescriptionPropertyID_DisplayWidth = 'disw',
   /* SInt32,
   Read */
   /*
   * A height at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
   kICMImageDescriptionPropertyID_DisplayHeight = 'dish',
   /* SInt32,
   Read */
   /*
   * A width at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayWidth instead.
   */
   kICMImageDescriptionPropertyID_ProductionDisplayWidth = 'pdsw',
   /* SInt32,
   Read */
   /*
   * A height at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayHeight instead.
   */
   kICMImageDescriptionPropertyID_ProductionDisplayHeight = 'pdsh',
   /* SInt32,
   Read */
   /*
   * Color information,
   if available in the
   * NCLCColorInfoImageDescriptionExtension format.
   */
   kICMImageDescriptionPropertyID_NCLCColorInfo = 'nclc',
   /* Native-endian NCLCColorInfoImageDescriptionExtension,
   Read/Write */
   /*
   * The gamma level described by the image description.
   */
   kICMImageDescriptionPropertyID_GammaLevel = 'gama',
   /* Fixed,
   Read/Write */
   /*
   * Information about the number and order of fields,
   if available.
   */
   kICMImageDescriptionPropertyID_FieldInfo = 'fiel',
   /* FieldInfoImageDescriptionExtension2,
   Read/Write */
   /*
   * The offset in bytes from the start of one row to the next. Only
   * valid if the codec type is a chunky pixel format.
   */
   kICMImageDescriptionPropertyID_RowBytes = 'rowb',
   /* SInt32,
   Read/Write */
   /*
   * A track width suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
   kICMImageDescriptionPropertyID_ClassicTrackWidth = 'claw',
   /* Fixed,
   Read */
   /*
   * A track height suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
   kICMImageDescriptionPropertyID_ClassicTrackHeight = 'clah' /* Fixed,
   Read */
};
enum {
   /*
   * In this pass the compressor shall output encoded frames.
   */
   kICMCompressionPassMode_OutputEncodedFrames = 1L << 0,
   /*
   * In this pass the client need not provide source frame buffers.
   */
   kICMCompressionPassMode_NoSourceFrames = 1L << 1,
   /*
   * In this pass the compressor may write private data to multipass
   * storage.
   */
   kICMCompressionPassMode_WriteToMultiPassStorage = 1L << 2,
   /*
   * In this pass the compressor may read private data from multipass
   * storage.
   */
   kICMCompressionPassMode_ReadFromMultiPassStorage = 1L << 3,
   /*
   * The compressor will set this flag to indicate that it will not be
   * able to output encoded frames in the coming pass. If this flag is
   * not set,
   then the client is allowed to set the
   * kICMCompressionPassMode_OutputEncodedFrames flag before calling
   * ICMCompressionSessionBeginPass.
   */
   kICMCompressionPassMode_NotReadyToOutputEncodedFrames = 1L << 4
};
enum {
   /*
   * Indicates that this is the last call for this sourceFrameRefCon.
   */
   kICMSourceTracking_LastCall   = 1L << 0,
   /*
   * Indicates that the session is done with the source pixel buffer
   * and has released any reference to it that it had.
   */
   kICMSourceTracking_ReleasedPixelBuffer = 1L << 1,
   /*
   * Indicates that this frame was encoded.
   */
   kICMSourceTracking_FrameWasEncoded = 1L << 2,
   /*
   * Indicates that this frame was dropped.
   */
   kICMSourceTracking_FrameWasDropped = 1L << 3,
   /*
   * Indicates that this frame was merged into other frames.
   */
   kICMSourceTracking_FrameWasMerged = 1L << 4,
   /*
   * Indicates that the time stamp of this frame was modified.
   */
   kICMSourceTracking_FrameTimeWasChanged = 1L << 5,
   /*
   * Indicates that the ICM has copied the image from the source pixel
   * buffer into another pixel buffer because the source pixel buffer
   * was not compatible with the compressor's required pixel buffer
   * attributes.
   */
   kICMSourceTracking_CopiedPixelBuffer = 1L << 6
};
enum {
   /*
   * The full width and height of source frames shall be scaled to the
   * full width and height of the destination. This is the default if
   * no other scaling mode is specified.
   */
   kICMScalingMode_StretchProductionAperture = 'sp2p',
   /*
   * The clean aperture of the source frames shall be scaled to the
   * clean aperture of the destination.
   */
   kICMScalingMode_StretchCleanAperture = 'sc2c',
   /*
   * The clean aperture of the source frames shall be scaled to fit
   * inside the clean aperture of the destination,
   preserving the
   * original display aspect ratio. If the display aspect ratios are
   * different,
   the source frames will be centered with black bars
   * above and below,
   or to the left and right.
   */
   kICMScalingMode_Letterbox     = 'lett',
   /*
   * The clean aperture of the source frames shall be scaled to cover
   * the clean aperture of the destination,
   preserving the original
   * display aspect ratio. If the display aspect ratios are different,
   * the source frames will be centered and cropped.
   */
   kICMScalingMode_Trim          = 'trim'
};

/*ICMDecompressionTrackingCallbackRecord

Designates a tracking callback for an ICM decompression session.

struct ICMDecompressionTrackingCallbackRecord {
   ICMDecompressionTrackingCallback    decompressionTrackingCallback;
   void                                *decompressionTrackingRefCon;
};
Fields
decompressionTrackingCallback
Discussion

The callback function pointer. See ICMDecompressionTrackingCallbackProc.
decompressionTrackingRefCon
Discussion

The callback's reference value.
Declared In
ImageCompression.h*/
struct ICMDecompressionTrackingCallbackRecord {
   ICMDecompressionTrackingCallback    decompressionTrackingCallback;
   void                                *decompressionTrackingRefCon;
};
typedef  struct ICMDecompressionTrackingCallbackRecord ICMDecompressionTrackingCallbackRecord;
/*ImageDescriptionPtr

Abst_ImageDescriptionPtr

typedef ImageDescription * ImageDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ImageDescription * ImageDescriptionPtr;

/*ImageDescriptionHandle

Abst_ImageDescriptionHandle

typedef ImageDescriptionPtr * ImageDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ImageDescriptionPtr * ImageDescriptionHandle;

/*ICMFrameTimeRecord

Contains a frame's time information for scheduled asynchronous decompression operations.

struct ICMFrameTimeRecord {
   wide           value;
   long           scale;
   void *         base;
   long           duration;
   Fixed          rate;
   long           recordSize;
   long           frameNumber;
   long           flags;
   wide           virtualStartTime;
   long           virtualDuration;
   TimeValue64    decodeTime;
};
Fields
value
Discussion

Specifies the time at which the frame is to be displayed.
scale
Discussion

Indicates the units for the frame's display time.
base
Discussion

Refers to the time base.
duration
Discussion

Specifies the duration for which the frame is to be displayed. This must be in the same units as specified by the scale field. It is 0 if the duration is unknown.
rate
Discussion

Indicates the time base's effective rate.
recordSize
Discussion

Total number of bytes in this structure.
frameNumber
Discussion

Number of frame; 0 if the frame number is not known.
flags
Discussion

Flag (see below) to indicate if virtualStartTime and virtualDuration are valid. See these constants: 
icmFrameTimeHasVirtualStartTimeAndDuration
icmFrameTimeHasDecodeTime
virtualStartTime
Discussion

Conceptual start time.
virtualDuration
Discussion

Conceptual duration.
decodeTime
Discussion

Suggested decode time. Valid only if icmFrameTimeHasDecodeTime is set in the flags parameter.
Programming Info
C interface file: ImageCompression.h*/
struct ICMFrameTimeRecord {
   wide           value;
   long           scale;
   void *         base;
   long           duration;
   Fixed          rate;
   long           recordSize;
   long           frameNumber;
   long           flags;
   wide           virtualStartTime;
   long           virtualDuration;
   TimeValue64    decodeTime;
};
typedef  struct ICMFrameTimeRecord ICMFrameTimeRecord;

/*Component Property IDs and Flags

Constants that contain the flags and IDs of component properties.

uppCallComponentGetComponentPropertyInfoProcInfo = 0x0003FFF0
uppCallComponentGetComponentPropertyProcInfo = 0x0003FFF0
uppCallComponentSetComponentPropertyProcInfo = 0x0000FFF0
uppCallComponentAddComponentPropertyListenerProcInfo = 0x0000FFF0
uppCallComponentRemoveComponentPropertyListenerProcInfo = 0x0000FFF0
kCallComponentExecuteWiredActionSelect     = -9
kComponentPropertyFlagCanSetLater = (1L << 0)
kComponentPropertyFlagCanSetNow = (1L << 1)
kComponentPropertyFlagCanGetNow = (1L << 3)
kComponentPropertyFlagHasExtendedInfo = (1L << 4)
kComponentPropertyFlagValueMustBeReleased = (1L << 5)
kComponentPropertyFlagValueIsCFTypeRef = (1L << 6)
kComponentPropertyFlagGetBufferMustBeInitialized = (1L << 7)
kQTComponentPropertyListenerCollectionContextVersion = 1
kQTGetComponentPropertyInfoSelect          = -11
kQTGetComponentPropertySelect              = -12
kQTSetComponentPropertySelect              = -13
kQTAddComponentPropertyListenerSelect      = -14
kQTRemoveComponentPropertyListenerSelect   = -15*/
enum {
uppCallComponentGetComponentPropertyInfoProcInfo = 0x0003FFF0,
uppCallComponentGetComponentPropertyProcInfo = 0x0003FFF0,
uppCallComponentSetComponentPropertyProcInfo = 0x0000FFF0,
uppCallComponentAddComponentPropertyListenerProcInfo = 0x0000FFF0,
uppCallComponentRemoveComponentPropertyListenerProcInfo = 0x0000FFF0,
kCallComponentExecuteWiredActionSelect     = -9,
kComponentPropertyFlagCanSetLater = (1L << 0),
kComponentPropertyFlagCanSetNow = (1L << 1),
kComponentPropertyFlagCanGetNow = (1L << 3),
kComponentPropertyFlagHasExtendedInfo = (1L << 4),
kComponentPropertyFlagValueMustBeReleased = (1L << 5),
kComponentPropertyFlagValueIsCFTypeRef = (1L << 6),
kComponentPropertyFlagGetBufferMustBeInitialized = (1L << 7),
kQTComponentPropertyListenerCollectionContextVersion = 1,
kQTGetComponentPropertyInfoSelect          = -11,
kQTGetComponentPropertySelect              = -12,
kQTSetComponentPropertySelect              = -13,
kQTAddComponentPropertyListenerSelect      = -14,
kQTRemoveComponentPropertyListenerSelect   = -15,
};

/*QTSetComponentProperty Values

Constants passed to QTSetComponentProperty.

enum {
   kComponentPropertyCacheFlagNotPersistent = (1L << 0),
   // property metadata should not be saved in persistent cache
   kComponentPropertyCacheFlagIsDynamic = (1L << 1) //property metadata should not cached at all
};
enum {
   kComponentPropertyClassPropertyInfo = 'pnfo',
   // property info class 
   // property info property IDs 
   kComponentPropertyInfoList    = 'list',
   //array of ComponentPropertyInfo (CFData),
   //one for each property 
   kComponentPropertyCacheSeed   = 'seed',
   // property cache seed value 
   kComponentPropertyCacheFlags  = 'flgs',
   // see kComponentPropertyCache flags 
   kComponentPropertyExtendedInfo = 'meta' // CFDictionary with extended property information
};
Constants
kComponentPropertyCacheFlagNotPersistent

Property metadata should not be saved in persistent cache. 

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheFlagIsDynamic

Property metadata should not be cached at all. 

Available in Mac OS X v10.3 and later.
kComponentPropertyClassPropertyInfo

A QTComponentPropertyInfo structure that defines a property information class. Also 'pnfo'.

Available in Mac OS X v10.3 and later.
kComponentPropertyInfoList

An array of QTComponentPropertyInfo structures, one for each property. Also 'list'.

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheSeed

A component property cache seed value. Also 'seed'.

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheFlags

One of the following two flags: Also 'flgs'.

Available in Mac OS X v10.3 and later.*/
enum {
   kComponentPropertyCacheFlagNotPersistent = (1L << 0),
   // property metadata should not be saved in persistent cache
   kComponentPropertyCacheFlagIsDynamic = (1L << 1) //property metadata should not cached at all
};
enum {
   kComponentPropertyClassPropertyInfo = 'pnfo',
   // property info class 
   // property info property IDs 
   kComponentPropertyInfoList    = 'list',
   //array of ComponentPropertyInfo (CFData),
   //one for each property 
   kComponentPropertyCacheSeed   = 'seed',
   // property cache seed value 
   kComponentPropertyCacheFlags  = 'flgs',
   // see kComponentPropertyCache flags 
   kComponentPropertyExtendedInfo = 'meta' // CFDictionary with extended property information
};

/*VDSetCompression Values

Constants passed to VDSetCompression.

enum {
   codecLosslessQuality          = 0x00000400,
   codecMaxQuality               = 0x000003FF,
   codecMinQuality               = 0x00000000,
   codecLowQuality               = 0x00000100,
   codecNormalQuality            = 0x00000200,
   codecHighQuality              = 0x00000300
};
Constants
codecLosslessQuality

Lossless compression or decompression. This special value is valid only for components that can support lossless compression or decompression. 

Available in Mac OS X v10.0 and later.
codecMaxQuality

The maximum standard value. 

Available in Mac OS X v10.0 and later.
codecMinQuality

The minimum valid value. 

Available in Mac OS X v10.0 and later.
codecLowQuality

Low-quality image reproduction. This value should correspond to the lowest image quality that still results in acceptable display characteristics. 

Available in Mac OS X v10.0 and later.
codecNormalQuality

Image reproduction of normal quality. 

Available in Mac OS X v10.0 and later.*/
enum {
   codecLosslessQuality          = 0x00000400,
   codecMaxQuality               = 0x000003FF,
   codecMinQuality               = 0x00000000,
   codecLowQuality               = 0x00000100,
   codecNormalQuality            = 0x00000200,
   codecHighQuality              = 0x00000300
};

/*CodecQ

Abst_CodecQ

typedef unsigned long CodecQ;
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long CodecQ;

/*QTGetComponentProperty

Returns the value of a specific component property.

ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );

/*QTGetComponentPropertyInfo

Returns information about the properties of a component.

ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
outPropType

A pointer to memory allocated to hold the property type on return. This pointer may be NULL.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. This pointer may be NULL.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );

/*QTSetComponentProperty

Sets the value of a specific component property.

ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );

/*QTOpenGLTextureContextCreate
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Creates a new OpenGL texture context for a specified OpenGL context and pixel format.

OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Parameters
allocator

The allocator used to create the texture context.
cglContext

A pointer to an opaque CGLPContextObj structure representing the OpenGL context used to create textures. You can create this structure using CGLCreateContext.
cglPixelFormat

The pixel format object that specifies buffer types and other attributes of the new context.
attributes

A dictionary of attributes.
newTextureContext

A pointer to a variable to receive the new OpenGL texture context.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );

/*QTVisualContextSetAttribute

Sets a visual context attribute.

OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );
Parameters
visualContext

The visual context.
attributeKey

Identifier of attribute to set
attributeValue

The value of the attribute to set, or NULL to remove a value. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );

/*QTVisualContextRelease

Releases a visual context object.

void QTVisualContextRelease (
   QTVisualContextRef visualContext
);
Parameters
visualContext

A reference to a visual context object. If you pass NULL, nothing happens.
Discussion

When the retain count decreases to zero, the visual context is disposed.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
void QTVisualContextRelease (
   QTVisualContextRef visualContext
);

/*QTVisualContextCopyImageForTime

Retrieves an image buffer from the visual context, indexed by the provided time.

OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);
Parameters
visualContext

The visual context.
allocator

Allocator used to create new CVImageBufferRef.
timeStamp

Time in question. Pass NULL to request the image at the current time.
newImage

Points to variable to receive the new image.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You should not request image buffers further ahead of the current time than the read-ahead time specified with the kQTVisualContextExpectedReadAheadKey attribute. You may skip images by passing later times, but you may not pass an earlier time than passed to a previous call to this function.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);

/*QTVisualContextTask

Enables the visual context to release internally held resources for later use.

void QTVisualContextTask (
   QTVisualContextRef visualContext
);
Parameters
visualContext

The visual context.
Discussion

For optimal resource management, this function should be called in every rendering pass. It should be called after old images have been released, new images have been used and all rendering has been flushed to the screen. The call is not mandatory.
Version Notes

Introduced in QuickTime 7
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

void QTVisualContextTask (
   QTVisualContextRef visualContext
);

/*QTVisualContextIsNewImageAvailable

Queries whether a new image is available for a given time.

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);
Parameters
visualContext

The visual context.
timeStamp

Time in question.
Return Value

A Boolean.
Discussion

This function returns TRUE if there is a image available for the specified time that is different from the last image retrieved from QTVisualContextCopyImageForTime.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);

/*QTAddComponentPropertyListener

Installs a callback to monitor a component property.

ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inDispatchProc

A Universal Procedure Pointer to a QTComponentPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. You may pass NULL in this parameter.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );

/*ICMDecompressionSessionRelease

Decrements the retain count of a decompression session.

void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session );

/*ICMDecompressionSessionSetNonScheduledDisplayTime

Sets the display time for a decompression session, and requests display of the non-scheduled queued frame at that display time, if there is one.

OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
displayTime

A display time. Usually this is the display time of a non-scheduled queued frame. 
displayTimeScale

The timescale according to which displayTime should be interpreted. 
flags

Reserved; set to 0. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags );

/*ICMDecompressionSessionDecodeFrame

Queues a frame for decompression.

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
data

A pointer to the compressed data for this frame. The data must remain in this location until ICMDecompressionTrackingCallbackProc is called with the kICMDecompressionTracking_ReleaseSourceData flag set in decompressionTrackingFlags.
dataSize

The number of bytes of compressed data. You may not pass 0 in this parameter. 
frameOptions

A reference to a frame decompression options object containing options for this frame. You can create this object by calling ICMDecompressionFrameOptionsCreate.
frameTime

A pointer to a structure describing the frame's timing information. 
sourceFrameRefCon

Your reference value for the frame. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon );

/*ICMDecompressionSessionOptionsRelease

Decrements the retain count of a decompression session options object.

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options );
Parameters
options

A reference to a decompression session options object. This reference is returned by ICMDecompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options );

/*ICMDecompressionSessionCreate

Creates a session for decompressing video frames.

OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut );
Parameters
allocator

An allocator for the session. Pass NULL to use the default allocator. 
desc

An image description for the source frames. 
decompressionOptions

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate. The session will retain the object. You may change some options during the session by modifying the object. You may also pass NULL.
destinationPixelBufferAttributes

Requirements for emitted pixel buffers. You may pass NULL.
trackingCallback

A pointer to a structure that designates a callback to be called for information about queued frames and pixel buffers containing decompressed frames. See ICMDecompressionTrackingCallbackRecord and ICMDecompressionTrackingCallbackProc.
decompressionSessionOut

A pointer to a variable to receive a reference to the new decompression session. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

Frames are returned through calls to the callback pointed to by trackingCallback.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut );

/*ICMDecompressionSessionOptionsCreate

Creates a decompression session options object.

OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options );
Parameters
allocator

An allocator. Pass NULL to use the default allocator.
options

On return, a reference to a decompression session options object.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options );

/*ICMImageDescriptionGetProperty

Returns a particular property of a image description handle.

OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );
Parameters
inDesc

The image description handle being interrogated.
inPropClass

The class of property being requested.
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

Points to the buffer to receive the property value.
outPropValueSizeUsed

Points to a variable to receive the actual size of returned property value. (This can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns a particular property of a image description handle.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );

/*ICMDecompressionSessionOptionsSetProperty

Sets the value of a specific property of a decompression session options object.

OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress );
Parameters
options

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
inPropValueSize

The size of the property value to be set.
inPropValueAddress

A pointer to the value of the property to be set.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress );

/*QTNewGWorld

Creates an offscreen graphics world that may have a non-Macintosh pixel format.

OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags );
Parameters
offscreenGWorld

On return, a pointer to the offscreen graphics world created by this routine.
PixelFormat

The new graphics world's pixel format; see Pixel Formats. This function won't work with planar pixel formats; use QTNewGWorldFromPtr instead. See the ICMPixelFormatInfo structure for a discussion of planar and chunky formats.
boundsRect

A pointer to the boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if this function creates one. If you specify 0 in the PixelFormat parameter, the function interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. It then uses the pixel format, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NIL in this parameter, the function uses the default color table for the pixel format that you specify in the PixelFormat parameter. If you set the PixelFormat parameter to 0, the function ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use this function on a computer that supports only basic QuickDraw, you may specify only NIL in this parameter.
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case the function attaches this structure to the new offscreen graphics world. If you set the PixelFormat parameter to 0, or if you do not set the noNewDevice flag, the function ignores this parameter, so you should set it to NIL. If you set the PixelFormat parameter to 0, the function uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NIL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds.
flags

Constants (see below) that identify options available to your application. You can set a combination of these flags. If you don't wish to use any of them, pass 0 in this parameter. In this case the default behavior is to create an offscreen graphics world where the base address for the offscreen pixel image is unpurgeable, the graphics world uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure, it uses memory in your application heap, and it allows graphics accelerators to cache the offscreen pixel image. See these constants: 
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags );

/*ICMImageDescriptionSetProperty

Sets a particular property of a image description handle.

OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress );
Parameters
inDesc

The image description handle being modified.
inPropClass

The class of property being set.
inPropID

The ID of the property being set.
inPropValueSize

The size of property value.
inPropValueAddress

Points to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress );

/*GraphicsImportDraw

Draws an imported image.

ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function draws the image currently in use by the graphics import component to the graphics port and device specified by GraphicsImportSetGWorld. GraphicsImportDraw takes into account all settings previously specified for the image, such as the source rectangle, transformation matrix, clipping region, graphics mode, and image quality.
Special Considerations

The base graphics importer's drawing function uses the results of GraphicsImportGetImageDescription and GraphicsImportGetDataOffsetAndSize to create a decompression sequence, which it uses to draw the image. Subsequent draw operations with the same connection may reuse the decompression sequence. Other graphics importers may override this behavior.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci );

/*GraphicsImportSetProgressProc

Installs a progress procedure to call while drawing an imported image.

ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets a progress function that will be installed in the image decompression sequence used to draw the image.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );


/*GraphicsImportSetGWorld

Sets the graphics port and device for drawing an imported image.

ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
port

A pointer to the CGrafPort structure that defines the destination graphics port or graphics world. Set to NIL to use the current port.
gd

A handled to the GDevice structure that defines the destination graphics device. Set to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's device.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The graphics world is initialized to the current port and device when the graphics importer component is opened. Use this function to select another port or device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd );

/*GraphicsImportSetBoundsRect

Defines the rectangle in which to draw an imported image.

ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure that describes the bounding rectangle into which the image will be drawn.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You use this function to define the rectangle into which the graphics image should be drawn. The function creates a transformation matrix to map the image's natural bounds to the specified bounds and then calls GraphicsImportSetMatrix.
Special Considerations

Because this function affects the transformation matrix, you should use GraphicsImportSetMatrix instead of this function if you also need to specify more complex transformations of the matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds );

/*GraphicsImportGetNaturalBounds

Returns the bounding rectangle of an imported image.

ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
naturalBounds

A pointer to a Rect structure that describes the size of the bounding rectangle for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to determine the native size of the image associated with a graphics importer component. The natural bounds are always zero-based. This is a convenience function that simply calls GraphicsImportGetImageDescription and extracts the width and height fields.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds );


/*NewICMProgressUPP

Allocates a Universal Procedure Pointer for the ICMProgressProc callback.

ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMProgressProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine );

/*GetGraphicsImporterForDataRef

Locates and opens a graphics importer component that can be used to draw the image from specified data reference.

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi );
Parameters
dataRef

The data reference to be drawn using a graphics importer component.
dataRefType

The type of data reference pointed to by the dataRef parameter; see Data References. For alias-based data references, the dataRef handle contains an AliasRecord and dataRefType is set to rAliasType.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found, this parameter will be set to NIL. If GetGraphicsImporterForDataRef is able to locate a graphics importer for the data reference, the returned graphics importer ComponentInstance will already be set up to draw from the specified data reference to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function tries to locate a graphics importer component for the specified data reference by checking the file extension (such as .GIF or .JPG), the Macintosh file type, and the MIME type of the file. The file extension is retrieved from the data reference by using DataHGetFileName to call the data handler associated with the data reference. If a graphics importer cannot be found using the file's type, file extension, or MIME type, GetGraphicsImporterForDataRef asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming; to bypass it, call GetGraphicsImporterForDataRefWithFlags instead.
Special Considerations

The caller of GetGraphicsImporterForDataRef is responsible for closing the returned ComponentInstance using CloseComponent. You must call CloseComponent when you are finished with the importer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi );

/*GraphicsImportSetQuality

Sets the image quality value for an imported image.

ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
quality

Contains a constant (see below) that defines the desired image quality for decompression. Values for this parameter are on the same scale as compression quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The quality parameter controls how precisely the decompressor decompresses the image data. Some decompressors may choose to ignore some image data to improve decompression speed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality );

/*GraphicsExportDoExport

Performs a graphics export operation.

ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
actualSizeWritten

Points to a variable to receive the number of bytes written. If you are not interested in this information, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before calling this function , you must specify an input image, using one of the GraphicsExportSetInput... functions, and a destination for the output image file, using one of the GraphicsExportSetOutput... functions.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten );

/*GraphicsExportSetProgressProc

Installs a progress function in a graphics export operation.

ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is always implemented by the base graphics exporter.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );

/*GraphicsExportSetCompressionQuality

Defines the compression quality for a graphics export operation.

ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
spatialQuality

A constant (see below) that defines the currently specified quality value. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This setting is only supported by lossy compression methods.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality );

/*GraphicsExportSetOutputFile

Defines the output file for a graphics export operation.

ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
theFile

an FSSpec structure that identifies the file.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile );

/*GraphicsExportSetInputGraphicsImporter

Specifies that the source image for a graphics export operation is to be drawn by a graphics importer instance.

ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
grip

The source graphics importer component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to specify a source before you call GraphicsExportDoExport. The source can be a QuickTime graphics importer component instance, a QuickDraw Picture, a graphics world, a PixMap structure, or a piece of compressed data described by an ImageDescription structure. Compressed data can be in a file, handle, pointer, or other data reference. The application must make sure that the source is not disposed of before the graphics exporter instance is closed or given a new source. All of the get and set functions for these sources are implemented by the base graphics exporter; format-specific importers should delegate all of them.
Special Considerations

It is the caller's responsibility to dispose of the graphics importer.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip );

/*GraphicsExportGetMIMETypeList

Returns MIME types and other information about the graphics format in a graphics export operation.

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Receives a newly-created QuickTime atom container that contains information about the graphics format.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a QuickTime atom container that contains the format's name, as a string in an atom of type 'desc' (kMimeInfoDescriptionTag), and optionally the MIME type as a string in an atom of type 'mime'[atom] (kMimeInfoMimeTypeTag).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );

/*GraphicsExportGetDefaultFileNameExtension

Returns the suggested file name extension for a graphics export operation.

ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
fileNameExtension

Points to a location to receive the file name extension.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

File name extensions are returned as upper-case big-endian four-character codes. For example, the extension .png would be returned as 'PNG ' (0x504E4720).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension );


#ifdef __cplusplus
}
#endif

#endif 
