

#ifndef AE_H
#include <AE/AE.h>
#endif



/*AEDisposeDesc

Deallocates the memory used by a descriptor.

OSErr AEDisposeDesc (
   AEDesc * theAEDesc
);
Parameters
theAEDesc

A pointer to the descriptor to deallocate. On return, a null descriptor. If you pass a null descriptor in this parameter, AEDisposeDesc returns noErr. See AEDesc.
Return Value

A result code. See Apple Event Manager Result Codes. As currently implemented, AEDisposeDesc always returns noErr.
Discussion

The AEDisposeDesc function deallocates the memory used by a descriptor. After calling this method, the descriptor becomes an empty descriptor with a type of typeNULL. Because all Apple event structures (except for keyword-specified descriptors) are descriptors, you can use AEDisposeDesc for any of them.

Do not call AEDisposeDesc on a descriptor obtained from another Apple Event Manager function (such as the reply event from a call to AESend) unless that function returns successfully.
Special Considerations

If the AEDesc might contain an OSL token, dispose of it with AEDisposeToken.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEDisposeDesc (AEDesc * theAEDesc){
//TODO
};


/*AEGetParamDesc

Gets a copy of the descriptor for a keyword-specified Apple event parameter from an Apple event or an Apple event record (type AERecord); typically used when your application needs to pass the extracted data to another function as a descriptor. 

OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
);
Parameters
theAppleEvent

A pointer to the Apple event to get the parameter descriptor from. See AppleEvent.
theAEKeyword

A keyword that specifies the desired Apple event parameter. Some keyword constants are described in “Keyword Parameter Constants”. See AEKeyword.
desiredType

The descriptor type for the desired Apple event parameter. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the requested Apple event parameter is not of the desired type, the Apple Event Manager attempts to coerce it to the desired type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the returned descriptor is the same as the descriptor type of the Apple event parameter.

See DescType.
result

A pointer to a descriptor. On successful return, a copy of the descriptor for the specified Apple event parameter, coerced, if necessary, to the descriptor type specified by the desiredType parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

To get Apple event parameter data for your application to use directly, call AEGetParamPtr. To get a descriptor for an Apple event parameter to pass on to another Apple Event Manager routine, call AEGetParamDesc.

If the actual parameter you are getting with AEGetParamDesc is a record, AEGetParamDesc will only allow you to request it as a typeAERecord, typeAEList, or typeWildcard. For any other type, it will return errAECoercionFail.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result){
//TODO
};


/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an events attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see Building an Apple Event in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in Getting Data or Descriptors From Apple Events, Adding Parameters and Attributes to an Apple Event, Creating an Apple Event, and Sending an Apple Event. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef AERecord AppleEvent;

/*AEInstallEventHandler

Adds an entry for an event handler to an Apple event dispatch table.

OSErr AEInstallEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   long handlerRefcon,
   Boolean isSysHandler
);
Parameters
theAEEventClass

The event class for the Apple event or events to dispatch to this event handler. The Discussion section describes interactions between this parameter and the theAEEventID parameter. See AEEventClass.
theAEEventID

The event ID for the Apple event or events to dispatch to this event handler. The Discussion section describes interactions between this parameter and the theAEEventClass parameter. See AEEventID.
handler

A universal procedure pointer to the Apple event handler function to install. See AEEventHandlerUPP.
handlerRefcon

A reference constant. The Apple Event Manager passes this value to the handler each time it calls it. If your handler doesn’t require a reference constant, pass 0 for this parameter.
isSysHandler

Specifies the Apple event dispatch table to add the handler to. Pass TRUE to add the handler to the system dispatch table or FALSE to add the handler to your application’s dispatch table. See Version Notes for related information.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The parameters theAEEventClass and theAEEventID specify the event class and event ID of the Apple events handled by the handler for this dispatch table entry. If there is already an entry in the specified dispatch table for the same event class and event ID, it is replaced. For these parameters, you must provide one of the following combinations:
the event class and event ID of a single Apple event to dispatch to the handler (for example, an event class of kAECoreSuite and an event ID of kAEDelete so that a specific kind of delete event is dispatched to the handler) 
the typeWildCard constant for theAEEventClass and an event ID for theAEEventID, which indicates that Apple events from all event classes whose event IDs match theAEEventID should be dispatched to the handler (for example, an event class of typeWildCard and an event ID of kAEDelete so that for all event classes, the delete event is dispatched to the handler) 
an event class for theAEEventClass and the typeWildCard constant for theAEEventID, which indicates that all events from the specified event class should be dispatched to the handler (for example, an event class of kAECoreSuite and an event ID of typeWildCard so that all events for the core suite are dispatched to the handler) 
the typeWildCard constant for both the theAEEventClass and theAEEventID parameters, which indicates that all Apple events should be dispatched to the handler

If you use the typeWildCard constant for either the theAEEventClass or the theAEEventID parameter (or for both parameters), the corresponding handler must return the error errAEEventNotHandled if it does not handle a particular event.

If an Apple event dispatch table contains one entry for an event class and a specific event ID, and also contains another entry that is identical except that it specifies a wildcard value for either the event class or the event ID, the Apple Event Manager dispatches the more specific entry. For example, if an Apple event dispatch table includes one entry that specifies the event class as kAECoreSuite and the event ID as kAEDelete, and another entry that specifies the event class as kAECoreSuite and the event ID as typeWildCard, the Apple Event Manager dispatches the Apple event handler associated with the entry that specifies the event ID as kAEDelete.

In addition to the Apple event handler dispatch tables, applications can add entries to special handler dispatch tables, as described in “Managing Special Handler Dispatch Tables”. 
Version Notes

Thread safe starting in Mac OS X v10.2.

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AppleEvents.h*/
OSErr AEInstallEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   long handlerRefcon,
   Boolean isSysHandler){
//TODO
};


/*NewAEEventHandlerUPP

Creates a new universal procedure pointer to an event handler function.

AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
);
Return Value

See AEEventHandlerUPP.
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

AEEventHandlerUPP NewAEEventHandlerUPP (AEEventHandlerProcPtr userRoutine){
//TODO
};

/*AECountItems

Counts the number of descriptors in a descriptor list.

OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
);
Parameters
theAEDescList

A pointer to the descriptor list to count. See AEDescList.
theCount

A pointer to a count variable. On return, the number of descriptors in the specified descriptor list.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application typically counts the descriptors in a descriptor list when it is extracting data from an Apple event. You can use the functions in “Getting Items From Descriptor Lists” to get an individual item from a descriptor list or to iterate through the items. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECountItems (const AEDescList * theAEDescList,long * theCount){
//TODO
};


/*AEGetNthPtr

Gets a copy of the data from a descriptor at a specified position in a descriptor list; typically used when your application needs to work with the extracted data directly.

OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAEDescList

A pointer to the descriptor list that contains the descriptor. See AEDescList.
index

A one-based positive integer indicating the position in the descriptor list of the descriptor to get the data from. AEGetNthPtr returns an error if you pass zero, a negative number, or a value that is out of range.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the index parameter is not of the desired type, AEGetNthPtr attempts to coerce the data to this type. If you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the copied data is the same as the descriptor type of the original descriptor.

See DescType.
theAEKeyword

A pointer to a keyword. On return, the keyword for the specified descriptor, if you are getting data from a list of keyword-specified descriptors; otherwise, AEGetNthPtr returns the value typeWildCard. Some keyword constants are described in “Keyword Attribute Constants” and “Keyword Parameter Constants”. See AEKeyword.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the data pointed to by dataPtr. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor at the position in the descriptor list specified by the index parameter.
maximumSize

The maximum length, in bytes, of the expected data. The AEGetNthPtr function will not return more data than you specify in this parameter. 
actualSize

A pointer to a size variable. On return, the length, in bytes, of the data for the specified descriptor. If this value is larger than the value of the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the descriptor, though AEGetNthPtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetNthPtr again.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AEGetNthPtr function uses a buffer to return the data for a specified descriptor from a specified descriptor list. The function attempts to coerce the descriptor to the descriptor type specified by the desiredType parameter.

Before calling AEGetNthPtr, you can call the AESizeOfNthItem function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AESizeOfNthItem may coerce the data, which may cause the size of the data to change. If you are using AEGetNthPtr to iterate through a list of descriptors of the same type with a fixed size, such as a list of descriptors of type typeFSS, you can get the size once, allocate a buffer, and reuse it for each call.

The order of items in an Apple event record may change after an insertion or deletion. In addition, duplicating an Apple event record is not guaranteed to preserve the item order. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize){
//TODO
};

/*AEGetDescData

Gets the data from the specified descriptor.

OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
);
Parameters
theAEDesc

A pointer to the descriptor to get the data from. See AEDesc.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes should be the same as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor.
maximumSize

The length, in bytes, of the expected descriptor data. The AEGetDescData function will not return more data than you specify in this parameter. You typically determine the maximum size by calling AEGetDescDataSize.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application can call AEGetDescDataSize to get the size, in bytes, of the data in a descriptor, allocate a buffer or variable of that size, then call AEGetDescData to get the data. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize){
//TODO
};


/*AEBuildAppleEvent

Constructs an entire Apple event in a single call.

OSStatus AEBuildAppleEvent (
   AEEventClass theClass,
   AEEventID theID,
   DescType addressType,
   const void * addressData,
   long addressLength,
   short returnID,
   long transactionID,
   AppleEvent * result,
   AEBuildError * error,
   const char * paramsFmt,
   ...
);
Parameters
theClass

The event class for the resulting Apple event. See AEEventClass.
theID

The event id for the resulting Apple event. See AEEventID.
addressType

The address type for the addressing information described in the next two parameters: usually one of typeApplSignature, typeProcessSerialNumber, or typeKernelProcessID. See DescType.
addressData

A pointer to the address information.
addressLength

The number of bytes pointed to by the addressData parameter.
returnID

The return ID for the created Apple event. If you pass a value of kAutoGenerateReturnID, the Apple Event Manager assigns the created Apple event a return ID that is unique to the current session. If you pass any other value, the Apple Event Manager assigns that value for the ID.
transactionID

The transaction ID for this Apple event. A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the client’s initial request for a service. All Apple events that are part of a transaction must have the same transaction ID. You can specify the kAnyTransactionID constant if the Apple event is not one of a series of interdependent Apple events.
result

A pointer to a descriptor where the resulting descriptor should be stored. See AppleEvent for a description of the data type.
error

A pointer to an AEBuildError structure where additional information about any errors that occur will be saved. This is an optional parameter and you can pass NULL if this information is not required. See AEBuildError for a description of the data type.
paramsFmt

An AEBuild format string describing the AppleEvent record to be created. The format of these strings is described in Technical Note TN2106, AEBuild*, AEPrint*, and Friends. That technote also describes possible error return codes for syntax errors in the format string.
Return Value

A numeric result code indicating the success of the call. A value of AEBuildSyntaxNoErr (zero) means the call succeeded. You can use the error parameter to discover information about other errors. See “Apple Event Manager Result Codes”.
Discussion

IMPORTANT: Following the parameters described above, the AEBuildAppleEvent function takes a variable number of parameters as specified by the format string provided in the paramsFmt parameter.

This function and related “AEBuild” routines (including AEBuildDesc and AEBuildParameters, and the variable-argument versions, vAEBuildAppleEvent, vAEBuildDesc, and vAEBuildParameters) provide a very simple translation service for converting specially formatted strings into complex Apple event descriptors. Normally, creating complex Apple event descriptors requires a large number of calls to Apple event Manager routines to build up the descriptor piece by piece. The AEBuildAppleEvent function and related routines allow you to consolidate all of the calls required to construct a complex Apple event descriptor into a single system call that creates the desired structure as directed by a format string that you provide.

In many ways, the AEBuild routines are very much like the standard C library's printf suite of routines. The syntax for the format string that you provide is very simple and allows for the substitution of data items into the Apple event descriptors being created.

The AEBuildAppleEvent function is similar to AECreateAppleEvent, but in addition to creating the Apple event, it also constructs the parameters for the event from the last three arguments. You can use AEBuildAppleEvent to build an entire Apple event, or AEBuildParameters to add additional parameters to an existing Apple event.

The syntax of the formatting string for an entire Apple event (as passed to AEBuildAppleEvent) is almost identical to that used to represent the contents of an Apple event, without the curly braces. The event is defined as a sequence of name-value pairs, with optional parameters preceded with a tilde (~) character. The syntax is described in Technical Note TN2106, AEBuild*, AEPrint*, and Friends.

It is important to note that the identifier for the direct parameter in an Apple event, specified by the constant keyDirectObject, is four minus signs ('----'). The minus sign has special meaning in AEBuild strings, and it should always be enclosed in single quotes when it is used to identify the direct parameter for an Apple event in a descriptor string.
Version Notes

Prior to Mac OS X version 10.3, AEBuildAppleEvent would fail if you supplied a data parameter with size greater than 32767 bytes.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEHelpers.h*/
OSStatus AEBuildAppleEvent (
   AEEventClass theClass,
   AEEventID theID,
   DescType addressType,
   const void * addressData,
   long addressLength,
   short returnID,
   long transactionID,
   AppleEvent * result,
   AEBuildError * error,
   const char * paramsFmt,
   int A,    int  B){
//TODO
};


/*AECreateDesc

Creates a new descriptor that incorporates the specified data.

OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
);
Parameters

typeCode

The descriptor type for the new descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the new descriptor. This data is copied into a newly-allocated block of memory for the descriptor that is created. To minimize copying overhead, consider using AECreateDescFromExternalPtr.
dataSize

The length, in bytes, of the data for the new descriptor.
result

A pointer to a descriptor. On successful return, a descriptor that incorporates the data specified by the dataPtr parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

While it is possible to create an Apple event descriptor or a descriptor list or a descriptor with the AECreateDesc function (assuming you have access to the raw data for an Apple event, list, or descriptor), you typically create these structured objects with their specific creation routines—AECreateAppleEvent, AECreateList, or AECreateDesc. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result){
//TODO
};


/*AESendMessage

Sends an AppleEvent to a target process without some of the overhead required by AESend.

OSStatus AESendMessage (
   const AppleEvent * event,
   AppleEvent * reply,
   AESendMode sendMode,
   long timeOutInTicks
);
Parameters
event

A pointer to the Apple event to send.
reply

A pointer to a reply Apple event. On return, contains the reply Apple event from the server application, if you specified the kAEWaitReply flag in the sendMode parameter. If you specify the kAEQueueReply flag in the sendMode parameter, you receive the reply Apple event in your event queue. If you specify kAENoReply flag, the reply Apple event is a null descriptor (one with descriptor type typeNull). If you specify kAEWaitReply in the sendMode parameter, and if the function returns successfully (see function result below), your application is responsible for using the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter.
sendMode

Specifies various options for how the server application should handle the Apple event. To obtain a value for this parameter, you add together constants to set bits that specify the reply mode, the interaction level, the application switch mode, the reconnection mode, and the return receipt mode. For more information, see AESendMode.
timeOutInTicks

If the reply mode specified in the sendMode parameter is kAEWaitReply, or if a return receipt is requested, this parameter specifies the length of time (in ticks) that the client application is willing to wait for the reply or return receipt from the server application before timing out. Most applications should use the kAEDefaultTimeout constant, which tells the Apple Event Manager to provide an appropriate timeout duration. If the value of this parameter is kNoTimeOut, the Apple event never times out. These constants are described in “Timeout Constants”.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AESendMessage function allows you to send Apple events by linking with just the Application Services framework, and not the entire Carbon framework, as required by AESend. Linking with Carbon brings in the HIToolbox framework, which requires that your application have a connection to the window server. Daemons and other applications that have no interface but wish to send and receive Apple events can use the following functions for working with Apple events at a lower level: AESendMessage, AEGetRegisteredMachPort, AEDecodeMessage, and AEProcessMessage. See the descriptions for those functions for more information on when you might use them.

The AESendMessage function is both asynchronous and thread-safe, so you could, for example, set up a thread to send an Apple event and wait for a reply. If you use threads, you must add a typeReplyPortAttr attribute to your event that identifies the mach port on which to receive the reply. 

If the target of an event sent with AESendMessage is the current process (as specified by using typeProcessSerialNumber of { 0, kCurrentProcess } in the Apple event being sent), the Apple event is dispatched directly to the appropriate event handler in your process and not serialized.
Availability
Not available in CarbonLib.
Available in Mac OS X v10.0 and later.
Declared In
AEMach.h*/
OSStatus AESendMessage (
   const AppleEvent * event,
   AppleEvent * reply,
   AESendMode sendMode,
   long timeOutInTicks){
//TODO
};

/*AEGetParamPtr

Gets a copy of the data for a specified Apple event parameter from an Apple event or an Apple event record (type AERecord); typically used when your application needs to work with the extracted data directly.

OSErr AEGetParamPtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAppleEvent

A pointer to the Apple event to get the parameter data from. See AppleEvent.
theAEKeyword

The keyword that specifies the desired Apple event parameter. Some keyword constants are described in “Keyword Parameter Constants”. See AEKeyword.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the theAEKeyword parameter is not of the desired type, AEGetParamPtr attempts to coerce the data to this type. However, if the desired type is typeWildCard, no coercion is performed.

On return, you can determine the actual descriptor type by examining the typeCode parameter.

See DescType.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the data pointed to by dataPtr. The returned type is either the same as the type specified by the desiredType parameter or, if the desired type was type wildcard, the true type of the descriptor. Specify NULL if you do not care about this return value. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the parameter data. Specify NULL if you do not care about this return value. 
maximumSize

The maximum length, in bytes, of the expected Apple event parameter data. The AEGetParamPtr function will not return more data than you specify in this parameter.
actualSize

A pointer to a variable of type Size. On return, the length, in bytes, of the data for the specified Apple event parameter. If this value is larger than the value you passed in the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the parameter, though AEGetParamPtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetParamPtr again. Specify NULL if you do not care about this return value.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

You should use this function only to extract data from value descriptors such as typeUTF8Text.

Because this function allows you to specify a desired type, it can result in coercion. When used correctly, this has the positive effect of returning the data in the desired format. However, it can have side effects you may not be expecting, such as the overhead of calls to coercion handlers. See also the Version Notes section below for possible problems with coercion.

To get Apple event parameter data for your application to use directly, call AEGetParamPtr. To get a descriptor for an Apple event parameter to pass on to another Apple Event Manager routine, call AEGetParamDesc.

Before calling AEGetParamPtr, you can call the AESizeOfParam function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AEGetParamPtr may coerce the data, which may cause the size of the data to change. 

In some cases, you may get improved efficiency extracting information from an Apple event with the AEGetDescDataRange function.
Version Notes

Thread safe starting in Mac OS X v10.2.

If the actual parameter you are getting with AEGetParamPtr is a record, AEGetParamPtr will erroneously allow you to get the parameter as any type at all, when it really should allow only typeAERecord, typeAEList, or typeWildcard. For other types, it will place raw record data into the designated buffer. With AppleScript 1.1.2, it would then return errAECoercionFail, as expected. With AppleScript 1.3 and later, however, it returns noErr.

You can work around this problem by checking the returned parameter from any call to AEGetParamPtr. If the source type is typeAERecord and the type you asked for was anything other than typeAERecord, typeAEList, or typeWildcard, you should assume the coercion failed.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetParamPtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize){
//TODO
};


/*AEGetNthDesc

Copies a descriptor from a specified position in a descriptor list into a specified descriptor; typically used when your application needs to pass the extracted data to another function as a descriptor.

OSErr AEGetNthDesc (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   AEDesc * result
);
Parameters
theAEDescList

A pointer to the descriptor list to get the descriptor from. See AEDescList.
index

A one-based positive integer indicating the position of the descriptor to get. AEGetNthDesc returns an error if you pass zero, a negative number, or a value that is out of range.
desiredType

The desired descriptor type for the descriptor to copy. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the index parameter is not of the desired type, AEGetNthDesc attempts to coerce it to this type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the copied descriptor is the same as the descriptor type of the original descriptor.

See DescType.
theAEKeyword

A pointer to a keyword. On successful return, the keyword for the specified descriptor, if you are getting data from a list of keyword-specified descriptors; otherwise, AEGetNthDesc returns the value typeWildCard. Some keyword constants are described in “Keyword Attribute Constants” and “Keyword Parameter Constants”. See AEKeyword.
result

A pointer to a descriptor. On successful return, a copy of the descriptor specified by the index parameter, coerced, if necessary, to the descriptor type specified by the desiredType parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

If the Nth descriptor in the list is itself an Apple event record and the desired type is not wildcard, record, or list, AEGetNthDesc will fail with an errAECoercionFailed error. This behavior prevents coercion problems. 

You may find the AEGetNthPtr function convenient for retrieving data for direct use in your application, as it includes automatic coercion. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEGetNthDesc (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   AEDesc * result){
//TODO
};


/*AECreateAppleEvent

Creates an Apple event with several important attributes but no parameters.

OSErr AECreateAppleEvent (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   const AEAddressDesc * target,
   AEReturnID returnID,
   AETransactionID transactionID,
   AppleEvent * result
);
Parameters
theAEEventClass

The event class of the Apple event to create. This parameter becomes accessible through the keyEventClassAttr attribute of the Apple event. Some event classes are described in “Event Class Constants”. See AEEventClass.
theAEEventID

The event ID of the Apple event to create. This parameter becomes accessible through the keyEventIDAttr attribute of the Apple event. Some event IDs are described in “Event ID Constants”. See AEEventID.
target

A pointer to an address descriptor. Before calling AECreateAppleEvent, you set the descriptor to identify the target (or server) application for the Apple event. This parameter becomes accessible through the keyAddressAttr attribute of the Apple event. See AEAddressDesc.
returnID

The return ID for the created Apple event. If you pass a value of kAutoGenerateReturnID, the Apple Event Manager assigns the created Apple event a return ID that is unique to the current session. If you pass any other value, the Apple Event Manager assigns that value for the ID. This parameter becomes accessible through the keyReturnIDAttr attribute of the Apple event. The return ID constant is described in “ID Constants for the AECreateAppleEvent Function”. See AEReturnID.
transactionID

The transaction ID for this Apple event. A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the client’s initial request for a service. All Apple events that are part of a transaction must have the same transaction ID. You can specify the kAnyTransactionID constant if the Apple event is not one of a series of interdependent Apple events. This parameter becomes accessible through the keyTransactionIDAttr attribute of the Apple event. This transaction ID constant is described in “ID Constants for the AECreateAppleEvent Function”. See AETransactionID.
result

A pointer to an Apple event. On successful return, the new Apple event. On error, a null descriptor (one with descriptor type typeNull). If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting Apple event after it has finished using it. See the AppleEvent data type.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AECreateAppleEvent function creates an empty Apple event. You can add parameters to the Apple event after you create it with the functions described in “Adding Parameters and Attributes to an Apple Event”. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateAppleEvent (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   const AEAddressDesc * target,
   AEReturnID returnID,
   AETransactionID transactionID,
   AppleEvent * result){
//TODO
};

/*AEPutParamDesc

Puts a descriptor and a keyword into an Apple event or Apple event record as an Apple event parameter.

OSErr AEPutParamDesc (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   const AEDesc * theAEDesc
);
Parameters
theAppleEvent

A pointer to the Apple event to add a parameter to. See the AppleEvent data type.
theAEKeyword

The keyword specifying the parameter to add. If the Apple event already has a parameter with this keyword, the parameter is replaced.

Some keyword constants are described in “Keyword Parameter Constants”.

See AEKeyword.
theAEDesc

A pointer to the descriptor for the parameter to add. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEPutParamDesc (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   const AEDesc * theAEDesc){
//TODO
};


/*AECreateList

Creates an empty descriptor list or Apple event record.

OSErr AECreateList (
   const void * factoringPtr,
   Size factoredSize,
   Boolean isRecord,
   AEDescList * resultList
);
Parameters
factoringPtr

A pointer to the data at the beginning of each descriptor that is the same for all descriptors in the list. If there is no common data, or if you decide not to isolate the common data, pass NULL as the value of this parameter.
factoredSize

The size of the common data. If there is no common data, or if you decide not to isolate the common data, pass 0 as the value of this parameter. (See the Discussion section for more information.)
isRecord

A Boolean value that specifies the kind of list to create. Pass a value of TRUE to create an Apple event record (a data structure of type AERecord) or FALSE to create a descriptor list.
resultList

A pointer to a descriptor list variable. On successful return, the descriptor list or Apple event record that the AECreateList function creates. On error, a null descriptor. See AEDescList.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AECreateList function creates an empty descriptor list or Apple event record. You can use the functions described in “Adding Items to Descriptor Lists” to populate the list as part of creating an Apple event. After sending the Apple event with the AESend function, you should dispose of the descriptor list with the AEDisposeDesc function when you no longer need it.

If you intend to use a descriptor list for a factored Apple event array, you must provide, in the factoringPtr parameter, a pointer to the data shared by all items in the array and, in the factoredSize parameter, the size of the common data. The common data must be 4, 8, or more than 8 bytes in length because it always consists of (a) the descriptor type (4 bytes) (b) the descriptor type (4 bytes) and the size of each item’s data (4 bytes) or (c) the descriptor type (4 bytes), the size of each item’s data (4 bytes), and some portion of the data itself (1 or more bytes).

For information about data types used with Apple event arrays, see “Apple Event Manager Data Types”.
Version Notes

The factoringPtr and factoredSize parameters are not supported in Mac OS X v10.2 and later. You should pass NULL and zero, respectively, for these parameters.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateList (
   const void * factoringPtr,
   Size factoredSize,
   Boolean isRecord,
   AEDescList * resultList){
//TODO
};


/*AECoercePtr

Coerces data to a desired descriptor type and creates a descriptor containing the newly coerced data.

OSErr AECoercePtr (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   AEDesc * result
);
Parameters
typeCode

The descriptor type of the source data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data to coerce.
dataSize

The length, in bytes, of the data to coerce.
toType

The desired descriptor type of the resulting descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
result

A pointer to a descriptor. On successful return, a descriptor containing the coerced data and matching the descriptor type specified in toType. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Starting in Mac OS X version 10.2, pointer-based coercion handlers are not called if the input type is “structured”—that is, if the type to be coerced is typeAEList, typeAERecord, or coerced typeAERecord. If you want to add a coercion handler for one of these types, it must be a descriptor-based handler. This does not mean you are required to use descriptor-based coercion handlers everywhere—for “flat” data types, such as typeText, pointer-based handlers are still fine.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECoercePtr (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   AEDesc * result){
//TODO
};

/*AECoerceDesc

Coerces the data in a descriptor to another descriptor type and creates a descriptor containing the newly coerced data.

OSErr AECoerceDesc (
   const AEDesc * theAEDesc,
   DescType toType,
   AEDesc * result
);
Parameters
theAEDesc

A pointer to the descriptor containing the data to coerce. See AEDesc.
toType

The desired descriptor type of the resulting descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
result

A pointer to a descriptor. On successful return, a descriptor containing the coerced data and matching the descriptor type specified in toType. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it.
Return Value

A result code. See “Apple Event Manager Result Codes”. If AECoerceDesc returns a nonzero result code, it returns a null descriptor record (a descriptor record of type typeNull, which does not contain any data) unless the Apple Event Manager is not available because of limited memory.
Version Notes

See the Version Notes section for the AECoercePtr function for information on when to use descriptor-based versus pointer-based coercion handlers starting in Mac OS X version 10.2.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECoerceDesc (
   const AEDesc * theAEDesc,
   DescType toType,
   AEDesc * result){
//TODO
};

/*CreateObjSpecifier

Assembles an object specifier that identifies one or more Apple event objects, from other descriptors.

OSErr CreateObjSpecifier (
   DescType desiredClass,
   AEDesc * theContainer,
   DescType keyForm,
   AEDesc * keyData,
   Boolean disposeInputs,
   AEDesc * objSpecifier
);
Parameters
desiredClass

The object class of the desired Apple event objects. See DescType.
theContainer

A pointer to a descriptor that describes the container for the requested object, usually in the form of another object specifier. See AEDesc.
keyForm

The key form for the object specifier.
keyData

A pointer to a descriptor that supplies the key data for the object specifier.
disposeInputs

A Boolean value. Pass (TRUE) if the function should dispose of the descriptors for the theContainer and keyData parameters or (FALSE) if your application will. A value of FALSE may be more efficient for some applications because it allows them to reuse descriptors.
objSpecifier

On successful return, a pointer to the object specifier created by the CreateObjSpecifier function. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of this descriptor after it has finished using it.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEPackObject.h*/
OSErr CreateObjSpecifier (
   DescType desiredClass,
   AEDesc * theContainer,
   DescType keyForm,
   AEDesc * keyData,
   Boolean disposeInputs,
   AEDesc * objSpecifier){
//TODO
};


/*AEPutParamPtr

Puts a pointer to data, a descriptor type, and a keyword into an Apple event or Apple event record as an Apple event parameter.

OSErr AEPutParamPtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);
Parameters
theAppleEvent

A pointer to the Apple event to add a parameter to. See the AppleEvent data type.
theAEKeyword

The keyword for the parameter to add. If the Apple event already includes an parameter with this keyword, the parameter is replaced.

Some keyword constants are described in “Keyword Parameter Constants”.

See AEKeyword.
typeCode

The descriptor type for the parameter to add. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the parameter to add.
dataSize

The length, in bytes, of the data for the parameter to add.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutParamPtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize){
//TODO
};


/*AEInitializeDesc

Initializes a new descriptor. 

void AEInitializeDesc (
   AEDesc * desc
);
Parameters
desc

A pointer to a new descriptor. See AEDesc.
Discussion

The function sets the type of the descriptor to typeNull and sets the data handle to NULL. If you need to initialize a descriptor that already has some data in it, use AEDisposeDesc to deallocate the memory and initialize the descriptor.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

void AEInitializeDesc (
   AEDesc * desc){
//TODO
};


/*AEGetDescDataSize

Gets the size, in bytes, of the data in the specified descriptor.

Size AEGetDescDataSize (
   const AEDesc * theAEDesc
);
Parameters
theAEDesc

A pointer to the descriptor to obtain the data size for. See AEDesc.
Return Value

Returns the size, in bytes, of the data in the specified descriptor.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
Size AEGetDescDataSize (
   const AEDesc * theAEDesc){
//TODO
};

/*AEPutDesc

Adds a descriptor to any descriptor list, possibly replacing an existing descriptor in the list.

OSErr AEPutDesc (
   AEDescList * theAEDescList,
   long index,
   const AEDesc * theAEDesc
);
Parameters
theAEDescList

A pointer to the descriptor list to add a descriptor to. See AEDescList.
index

A one-based positive integer indicating the position to insert the descriptor at. If there is already a descriptor in the specified position, it is replaced.

You can pass a value of zero or count + 1 to add the descriptor at the end of the list. AEPutDesc returns an error (AEIllegalIndex) if you pass a negative number or a value that is out of range.
theAEDesc

A pointer to the descriptor to add to the list. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutDesc (
   AEDescList * theAEDescList,
   long index,
   const AEDesc * theAEDesc){
//TODO
};

