#include <CFNetwork/CFNetwork.h>

/*CFReadStreamCreateWithFTPURL

Creates an FTP read stream.

CFReadStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
ftpURL

A pointer to a CFURL structure for the URL to be downloaded that can be created by calling any of the CFURLCreate functions, such as CFURLCreateWithString.
Return Value

A new read stream, or NULL if the call failed. Ownership follows the Create Rule.
Discussion

This function creates an FTP read stream for downloading data from an FTP URL. If the ftpURL parameter is created with the user name and password as part of the URL (such as ftp://username:password@ftp.example.com) then the user name and password will automatically be set in the CFReadStream. Otherwise, call CFReadStreamSetProperty to set the steam’s properties, such as kCFStreamPropertyFTPUserName and kCFStreamPropertyFTPPassword to associate a user name and password with the stream that are used to log in when the stream is opened. See "Constants" for a description of all FTP stream properties.

To initiate a connection with the FTP server, call CFReadStreamOpen. To read the FTP stream, call CFReadStreamRead. If the URL refers to a directory, the stream provides the listing results sent by the server. If the URL refers to a file, the stream provides the data in that file.

To close a connection with the FTP server, call CFReadStreamClose.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/

CFReadStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
){};


/*CFFTPCreateParsedResourceListing

Parses an FTP listing to a dictionary.

CFIndex CFFTPCreateParsedResourceListing (
    CFAllocatorRef alloc,
    const UInt8 *buffer,
    CFIndex bufferLength,
    CFDictionaryRef *parsed
);
Parameters
alloc

The allocator to use to allocate memory for the dictionary. Pass NULL or kCFAllocatorDefault to use the current default allocator.
buffer

A pointer to a buffer holding zero or more lines of resource listing.
bufferLength

The length in bytes of the buffer pointed to by buffer.
parsed

Upon return, contains a dictionary containing the parsed resource information. If parsing fails, a NULL pointer is returned.
Return Value

The number of bytes parsed, 0 if no bytes were available for parsing, or -1 if parsing failed.
Discussion

This function examines the contents of buffer as an FTP directory listing and parses into a CFDictionary the information for a single file or folder. The CFDictionary is returned in the parsed parameter, and the number of bytes used from buffer is returned.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
CFIndex CFFTPCreateParsedResourceListing (
    CFAllocatorRef alloc,
    const UInt8 *buffer,
    CFIndex bufferLength,
    CFDictionaryRef *parsed
){};

/*CFWriteStreamCreateWithFTPURL

Creates an FTP write stream.

CFWriteStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
ftpURL

A pointer to a CFURL structure for the URL to be uploaded created by calling any of the CFURLCreate functions, such as CFURLCreateWithString.
Return Value

A new write stream, or NULL if the call failed. Ownership follows the Create Rule.
Discussion

This function creates an FTP write stream for uploading data to an FTP URL. If the ftpURL parameter is created with the user name and password as part of the URL (such as ftp://username:password@ftp.example.com) then the user name and password will automatically be set in the CFWriteStream. Call CFWriteStreamSetProperty to set the steam’s properties, such as kCFStreamPropertyFTPUserName and kCFStreamPropertyFTPPassword to associate a user name and password with the stream that are used to log in when the stream is opened. See "Constants" for a description of all FTP stream properties.

After creating the write stream, you can call CFWriteStreamGetStatus at any time to check the status of the stream.

To initiate a connection with the FTP server, call CFWriteStreamOpen. If the URL specifies a directory, the open is immediately followed by the event kCFStreamEventEndEncountered (and the stream passes to the state kCFStreamStatusAtEnd). Once the stream reaches this state, the directory has been created. Intermediary directories are not created.

To write to the FTP stream, call CFWriteStreamWrite.

To close a connection with the FTP server, call CFWriteStreamClose.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
CFWriteStreamRef CFWriteStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
){};











