#ifndef CARBONCORE_H
#include <CarbonCore/CarbonCore.h>
#endif

int DebugStr(int a){
//TODO
};

/*BlockZero


void BlockZero (
   void * destPtr,
   Size byteCount
);
Parameters
destPtr
byteCount
Special Considerations

Beginning in Mac OS X v10.4, the BlockZero function is inlined to a direct call to the POSIX bzero function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockZero (
   void * destPtr,
   Size byteCount){
//TODO
};


/*DisposeHandle

Releases memory occupied by a relocatable block.

void DisposeHandle (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

The DisposeHandle function releases the memory occupied by the relocatable block whose handle is h. It also frees the handles master pointer for other uses.

Do not use DisposeHandle to dispose of a handle obtained from the Resource Manager (for example, by a previous call to GetResource), use ReleaseResource instead. If, however, you have called DetachResource on a resource handle, you should dispose of the storage by calling DisposeHandle.

Call the function MemError to get the result code. See Memory Manager Result Codes.
Special Considerations

After a call to DisposeHandle, all handles to the released block become invalid and should not be used again. Any subsequent calls to DisposeHandle using an invalid handle might crash your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void DisposeHandle (
   Handle h){
//TODO
};


/*GetHandleSize

Returns the logical size of the relocatable block corresponding to a handle.

Size GetHandleSize (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Return Value

The logical size, in bytes, of the relocatable block whose handle is h. In case of error, the function return 0. 
Discussion

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

You should not call GetHandleSize at interrupt time because the heap might be in an inconsistent state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Size GetHandleSize (
   Handle h){
//TODO
};


/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (
   SInt16 forkRefNum){
//TODO
};

/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount){
//TODO
};

/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum){
//TODO
};

/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef){
//TODO
};


/*NewHandle

Allocates a new relocatable memory block of a specified size in the current heap zone.

Handle NewHandle (
   Size byteCount
);
Parameters
byteCount

The requested size, in bytes, of the relocatable block. Maximum size is 2 GB, the maximum size for variables of type Size.
Return Value

A handle to the new block. If NewHandle cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandle function pursues all available avenues to create a block of the requested size, including compacting the heap zone, increasing its size, and purging blocks from it. If all of these techniques fail and the heap zone has a grow-zone function installed, NewHandle calls the function. Then NewHandle tries again to free the necessary amount of memory, once more compacting and purging the heap zone if necessary. If NewHandle still cannot allocate memory, NewHandle calls the grow-zone function again, unless that function had returned 0, in which case NewHandle gives up and returns NULL.

If the NewHandle function succeeds in creating the requested block, this new block is unlocked and unpurgeable.

If you allocate a relocatable block that you plan to lock for long periods of time, you can prevent heap fragmentation by allocating the block as low as possible in the heap zone. To do this, see the description of the function ReserveMem.

If you plan to lock a relocatable block for short periods of time, you might want to move it to the top of the heap zone to prevent heap fragmentation. For more information, see the description of the function MoveHHi.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandle allocates memory, you should not call it at interrupt time.

Do not try to manufacture your own handles without this function by simply assigning the address of a variable of type Ptr to a variable of type Handle. The resulting “fake handle” would not reference a relocatable block and could cause a system crash. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandle (
   Size byteCount){
//TODO
};

/*FSOpenResFile

Opens a resource file using a file system reference (FSRef).

short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission){
//TODO
};

/*CloseResFile

Closes a resource fork before your application terminates.

void CloseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork to close. If this parameter does not contain a file reference number for a file whose resource fork is open, the function does nothing, and the ResError function returns the result code resFNotFound. If the value of this parameter is 0, it represents the System file and is ignored. You cannot close the System file’s resource fork. 
Discussion

This function performs four tasks. First, it updates the file by calling the UpdateResFile function. Second, it releases the memory occupied by each resource in the resource fork by calling the DisposeHandle function. Third, it releases the memory occupied by the resource map. The fourth task is to close the resource fork.

When your application terminates, the Resource Manager automatically closes every resource fork open to your application except the System file’s resource fork. You need to call this function only if you want to close a resource fork before your application terminates.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void CloseResFile (
   short refNum){
//TODO
};

/*Get1IndResource

Returns a handle to a resource of a given type in the current resource file.

Handle Get1IndResource (
   ResType theType,
   short index
);
Parameters
theType

A resource type.
index

An integer ranging from 1 to the number of resources of a given type returned by the Count1Resources function, which is the number of resources of that type in the current resource file.
Return Value

A handle to a resource of the given type. If you call Get1IndResource repeatedly over the entire range of the index, it returns handles to all resources of the given type in the current resource file. If you provide an index that is either 0 or negative, the function returns NULL, and the ResError function returns the result code resNotFound. If the given index is larger than the value returned by Count1Resources, Get1IndResource returns NULL, and ResError returns the result code resNotFound. If the resource to be read won’t fit into memory, the function returns NULL, and ResError returns the appropriate result code.
Discussion

The function reads the resource data into memory if it’s not already there, unless you’ve called the SetResLoad function with the load parameter set to FALSE. If you’ve called SetResLoad with the load parameter set to FALSE and the data isn’t already in memory, Get1IndResource returns an empty handle (that is, a handle whose master pointer is set to NULL). This can also happen if you read resource data for a purgeable resource into memory and then call SetResLoad with the load parameter set to FALSE. If the resource data is later purged and you call the Get1IndResource function, the function returns an empty handle. You should test for an empty handle in these situations. To make the handle a valid handle to resource data in memory, you can call the MacLoadResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1IndResource (
   ResType theType,
   short index){
//TODO
};

/*DetachResource

Sets the value of a resource’s handle in the resource map in memory to NULL while keeping the resource data in memory.

void DetachResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If this parameter doesn’t contain a handle to a resource or if the resource’s resChanged attribute is set, the function does nothing. To determine whether either of these errors occurred, call the ResError function. 
Discussion

After this call, the Resource Manager no longer recognizes the handle as a handle to a resource. However, this function does not release the memory used for the resource data, and the master pointer is still valid. Thus, you can access the resource data directly by using the handle.

If your application subsequently calls a Resource Manager function to get the released resource, the Resource Manager assigns a new handle.You can use DetachResource if you want to access the resource data directly without using Resource Manager functions. You can also use the DetachResource function to keep resource data in memory after closing a resource fork.

To copy a resource and install an entry for the duplicate in the resource map, call DetachResource, then call the AddResource function using a different resource ID. 
Special Considerations

Do not use this function to detach a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void DetachResource (
   Handle theResource){
//TODO
};


/*CloseComponent

Terminates your applications connection to a component. 

OSErr CloseComponent (
   ComponentInstance aComponentInstance
);
Parameters
aComponentInstance

The connection you wish to close. Your application obtains the component instance from the OpenComponent function or the OpenDefaultComponent function. You can use a component identifier here, but you must coerce the data type appropriately. 
Return Value

A result code. See Component Manager Result Codes.
Discussion

This function closes only a single connection. If your application has several connections to a single component, you must call it once for each connection. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/


OSErr CloseComponent (
   ComponentInstance aComponentInstance){
//TODO
};


/*OpenDefaultComponent

Opens a connection to a registered component of the component type and subtype specified by your application. 

ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType
);
Parameters
componentType

The type of the component. All components of a particular type support a common set of interface functions. Use this parameter to search for components of a given type. 
componentSubType

The subtype of the component. Different subtypes of a component type may support additional features or provide interfaces that extend beyond the standard functions for a given component type. For example, the subtype of an image compressor component indicates the compression algorithm employed by the compressor.

Your application can use the componentSubType parameter to perform a more specific lookup operation than is possible using only the componentType parameter. For example, you may want your application to use only components of a certain component type ('draw') that also have a specific subtype ('oval'). Set this parameter to 0 to select a component with any subtype value.
Return Value

A component instance that identifies the connection opened to the component which matches your search criteria. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If more than one component in the list of registered components meets the search criteria, the function opens the first one that it finds in its list. If it cannot open the specified component, it returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. This function searches for a component by type and subtype. You do not have to supply a component description structure or call the FindNextComponent function to use this function. If you want to exert more control over the selection process, you can use the FindNextComponent and OpenComponent functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
ComponentInstance OpenDefaultComponent (
   OSType componentType,
   OSType componentSubType){
//TODO
};


/*Gestalt

Obtains information about the operating environment.

OSErr Gestalt (
   OSType selector,
   long * response
);
Parameters
selector

The selector code for the information you need. You can provide any of the four-character sequences defined in Gestalt Manager Constants.
response

On input, Gestalt interprets this parameter as an address at which it is to place the result returned by the selector function. Gestalt ignores any information already at this address. 

On return, a pointer to the requested information whose format depends on the selector code specified in the selector parameter. Note that the Gestalt function returns the response from all selectors in a long word, which occupies 4 bytes. When not all 4 bytes are needed, the significant information appears in the low-order byte or bytes.
Return Value

A result code. See Gestalt Manager Result Codes.
Discussion

The Apple-defined selector codes fall into two categories: environmental selectors, which supply specific environmental information you can use to control the behavior of your application, and informational selectors, which cant supply information you can use to determine what hardware or software features are available. You can use one of the selector codes defined by Apple or a selector code defined by a third-party product.

Selectors with the suffix Attr return a 32-bit response value in which the individual bits represent specific attributes. The constants listed for these response values represent bit numbers. 
Special Considerations

When passed one of the Apple-defined selector codes, the Gestalt function does not move or purge memory and therefore may be called even at interrupt time. However, selector functions associated with non-Apple selector codes might move or purge memory, and third-party software can alter the Apple-defined selector functions. Therefore, it is safest always to assume that Gestalt could move or purge memory.
Version Notes

The ROMVersion and machineType selectors are not supported in Carbon.

In general, the Gestalt function returns a different result when called from a Carbon application running in Mac OS X than it returns when called from a Classic application in Mac OS X, because these are different environments. For example, Carbon does not use a ROM, so calling Gestalt from a Carbon application on a beige G3 Macintosh computer and passing the ROMVersion selector returns a different result than Gestalt returns for a Classic application on the same computer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr Gestalt (
   OSType selector,
   long * response){
//TODO
};

/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator){
//TODO
};

/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names){
//TODO
};

/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef){
//TODO
};

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (
   FSIterator iterator){
//TODO
};

/*GetDateTime

Obtains the current date-time information, expressed as the number of seconds elapsed since midnight, January 1, 1904. (Deprecated in Mac OS X v10.4. Use CFAbsoluteTimeGetCurrent instead.)

void GetDateTime (
   unsigned long * secs
);
Parameters
secs

On return, the number of seconds elapsed since midnight, January 1, 1904. 
Discussion

The low-memory copy of the date and time information is also accessible through the global variable Time.

If an application disables interrupts for longer than a second, the date-time information returned by the GetDateTime function might not be exact. The GetDateTime function is intended to provide fairly accurate time information, but not scientifically precise data. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void GetDateTime (
   unsigned long * secs){
//TODO
};

/*SecondsToDate

Converts a number of seconds elapsed since midnight, January 1, 1904 to a date and time. (Deprecated in Mac OS X v10.4. Use the CFCalendarRef data type and the functions that operate on it instead.)

void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d
);
Parameters
secs

The number of seconds elapsed since midnight, January 1, 1904. 
d

On return, the fields of the date-time structure that contain the date and time corresponding to the value indicated in the s parameter. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
DateTimeUtils.h*/
void SecondsToDate (
   unsigned long secs,
   DateTimeRec * d){
//TODO
};


/*OpenADefaultComponent


OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci
);
Parameters
componentType
componentSubType
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenADefaultComponent (
   OSType componentType,
   OSType componentSubType,
   ComponentInstance * ci){
//TODO
};

/*FSPathMakeRef

Converts a path into an FSRef structure.

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);
Parameters
path

The path for which to return an FSRef. This path can be used by POSIX-style calls. 
ref

On return, a pointer to the FSRef. 
isDirectory

A Boolean value indicating whether the object at specified by the given path is a directory. This parameter is optional and can be NULL. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory){
//TODO
};

/*FSGetVolumeInfo

Returns information about a volume.

OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);
Parameters
volume

If you wish to obtain information on a particular volume, pass that volume’s reference number here. If you wish to index through the list of mounted volumes, pass the constant kFSInvalidVolumeRefNum in this parameter. See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
volumeIndex

The index of the desired volume, or 0 to use the volume reference number in the volume parameter. 
actualVolume

On return, a pointer to the volume reference number of the volume. This is useful when indexing over all mounted volumes. If you don’t want this information (if, for instance, you supplied a particular volume reference number in the volume) parameter, set actualVolume to NULL.
whichInfo

A bitmap specifying which volume information fields to get and return in the info parameter. If you don’t want information about the volume returned in the info parameter, set whichInfo to kFSVolInfoNone. See Volume Information Bitmap Constants for a description of the bits in this parameter.
info

On return, a pointer to the volume information. If you don’t want this output, set this parameter to NULL. See FSVolumeInfo for a description of the FSVolumeInfo data type.
volumeName

On return, a pointer to the Unicode name of the volume. If you do not wish the name returned, pass NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
rootDirectory

On return, a pointer to the FSRef for the volume’s root directory. If you do not wish the root directory returned, pass NULL. See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You can specify a particular volume or index through the list of mounted volumes. To get information on a particular volume, pass the volume reference number of the desired volume in the volume parameter and set the volumeIndex parameter to zero. To index through the list of mounted volumes, pass kFSInvalidVolumeRefNum in the volume parameter and set volumeIndex to the index, starting at 1 with the first call to FSGetVolumeInfo.

When indexing through the list of mounted volumes, you may encounter an error with a particular volume. The terminating error code for full traversal of this list is nsvErr. In order to completely traverse the entire list, you may have to bump the index count when encountering other errors (for example, ioErr).

To get information about the root directory of a volume, use the FSGetCatalogInfo function, or one of the corresponding parameter block calls, PBGetCatalogInfoSync and PBGetCatalogInfoAsync. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to FSGetVolumeInfo returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.*/
OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory){
//TODO
};


/*PBHGetVolParmsSync

Returns information about the characteristics of a volume.

OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the volume’s name. You can use a either a name or a volume specification to specify the volume. If you use a volume specification to specify the volume, you should set the ioNamePtr field to NULL. 
ioVRefNum 

On input, a volume specification. You can use a either a name or a volume specification to specify the volume. A volume specification can be a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a GetVolParmsInfoBuffer record; you must allocate this memory to hold the returned attributes. On return, the PBHGetVolParmsSync function places the attributes information in the bufferVolumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer structure. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear, then the volume does not implement the HFS Plus APIs and they are being emulated for that volume by the File Manager. 
ioReqCount 

On input, the size, in bytes, of the buffer area pointed to in the ioBuffer field. 
ioActCount 

On output, the size of the data actually returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock){
//TODO
};

/*OpenComponent

Opens a connection to the component with the component identifier specified by your application.

ComponentInstance OpenComponent (
   Component aComponent
);
Parameters
aComponent

The component you wish to open. Your application obtains this identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent function or the RegisterComponentResource function. 
Return Value

A component instance which identifies your application’s connection to the component. You must supply this component instance whenever you call the functions provided by the component. When you close the component, you must also supply this component instance to the CloseComponent function.

If it cannot open the specified component, the function returns NULL.

See the description of the ComponentInstance data type.
Discussion

Your application must open a component before it can call any component functions. To use this function, you must already have obtained a component identifier. Alternatively, you can use the OpenDefaultComponent function to open a component without calling FindNextComponent. 

Note that your application may maintain several connections to a single component, or it may have connections to several components at the same time. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/

ComponentInstance OpenComponent (
   Component aComponent){
//TODO
};


/*FindNextComponent

Returns the component identifier for the next registered component that meets the selection criteria specified by your application. 

Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking
);
Parameters
aComponent

The starting point for the search. Set this field to 0 to start the search at the beginning of the component list. If you are continuing a search, you can specify a component identifier previously returned by this function. The function then searches the remaining components. 
looking

A pointer to a ComponentDescription structure. Your application specifies the criteria for the component search in the fields of this structure.

The Component Manager ignores fields in the component description structure that are set to 0. For example, if you set all the fields to 0, all components meet the search criteria. In this case, your application can retrieve information about all of the components that are registered in the system by repeatedly calling FindNextComponent and GetComponentInfo until the search is complete. Similarly, if you set all fields to 0 except for the componentManufacturer field, the Component Manager searches all registered components for a component supplied by the manufacturer you specify. Note that this function does not modify the contents of the component description structure you supply. To retrieve detailed information about a component, you need to use the GetComponentInfo function to get the component description structure for each returned component.

Return Value

The component identifier of a component that meets the search criteria or 0 when there are no more matching components. Your application can use the component identifier returned by this function to get more information about the component, using GetComponentInfo, or to open the component, using either the OpenDefaultComponent function or the OpenComponent function. See the description of the Component data type.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
Component FindNextComponent (
   Component aComponent,
   ComponentDescription * looking){
//TODO
};
/*GetComponentInfo

Returns to your application the registration information for a component. 

OSErr GetComponentInfo (
   Component aComponent,
   ComponentDescription * cd,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon
);
Parameters
aComponent

The component about which you wish to obtain information. Your application obtains a component identifier from the FindNextComponent function. If your application registers a component, it can also obtain a component identifier from the RegisterComponent or RegisterComponentResource function.

You may supply a component instance rather than a component identifier to this function, but you must coerce the data type appropriately. Your application can obtain a component instance from the OpenComponent or OpenDefaultComponent functions.

cd

A pointer to a ComponentDescription structure. The function returns information about the specified component in this structure. 
componentName

On return, a handle to the component’s name. If the component does not have a name, an empty handle. Set this field to NULL if you do not want to receive the component’s name. 
componentInfo

On return, a handle to the component’s information string. If the component does not have an information string, an empty handle. Set this field to NULL if you do not want to receive the component’s information string.
componentIcon

On return, a handle to the component’s icon. If the component does not have an icon, an empty handle. Set this field to NULL if you do not want to receive the component’s icon. To get a handle to the component’s icon suite, if it provides one, use the GetComponentIconSuite function.
Return Value

A result code. See “Component Manager Result Codes”.
Discussion

For information on registering components, see “Registering Components”. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr GetComponentInfo (
   Component aComponent,
   ComponentDescription * cd,
   Handle componentName,
   Handle componentInfo,
   Handle componentIcon){
//TODO
};


/*FSMakeFSSpec

Creates an FSSpec structure describing a file or directory. (Deprecated in Mac OS X v10.4. Use FSMakeFSRefUnicode instead.)

OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);
Parameters
vRefNum

A volume specification for the volume containing the file or directory. This parameter can contain a volume reference number, a drive number, or 0 to specify the default volume. 
dirID

The parent directory ID of the target object. If the directory is sufficiently specified in the fileName parameter, the dirID parameter can be set to 0. If the fileName parameter contains an empty string, FSMakeFSSpec creates an FSSpec structure for the directory specified by the dirID parameter. 
fileName

A full or partial pathname. If the fileName parameter specifies a full pathname, FSMakeFSSpec ignores both the vRefNum and dirID parameters. A partial pathname might identify only the final target, or it might include one or more parent directory names. If fileName specifies a partial pathname, then vRefNum, dirID, or both must be valid. 
spec

A pointer to a file system specification to be filled in by FSMakeFSSpec. The FSMakeFSSpec function fills in the fields of the file system specification using the information contained in the other three parameters. If your application receives any result code other than noErr or fnfErr, all fields of the resulting FSSpec structure are set to 0. 

The file system specification structure that you pass in this parameter should not share storage space with the input pathname; the name field may be initialized to the empty string before the pathname has been processed. For example, fileName should not refer to the name field of the output file system specification.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

You should call FSMakeFSSpec, or one of the corresponding parameter block functions, PBMakeFSSpecSync and PBMakeFSSpecAsync , whenever you want to create an FSSpec structure. You should not create an FSSpec by filling in the fields of the structure yourself.

If the specified volume is mounted and the specified parent directory exists, but the target file or directory doesn’t exist in that location, FSMakeFSSpec fills in the structure and then returns fnfErr instead of noErr. The structure is valid, but it describes a target that doesn’t exist. You can use the structure for other operations, such as creating a file with the FSpCreate function. 
Carbon Porting Notes

Non-Carbon applications can also specify a working directory reference number in the vRefNum parameter. However, because working directories are not supported in Carbon, you cannot specify a working directory reference number if you wish your application to be Carbon-compatible.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec){
//TODO
};

/*BlockMove

Copies a sequence of bytes from one location in memory to another.

void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr

The address of the first byte to copy. 
destPtr

The destination address.
byteCount

The number of bytes to copy. If the value of byteCount is 0, BlockMove does nothing. 
Discussion

The BlockMove function copies the specified number of bytes from the address designated by srcPtr to that designated by destPtr. It updates no pointers.

The BlockMove function works correctly even if the source and destination blocks overlap.

You can safely call BlockMove at interrupt time. Even though it moves memory, BlockMove does not move relocatable blocks, but simply copies bytes.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

The BlockMove function currently flushes the processor caches whenever it moves more than 12 bytes. This behavior can adversely affect your application’s performance. You might want to avoid calling BlockMove to move small amounts of data in memory if there is no possibility of moving stale data or instructions. For more information about stale data and instructions, see the discussion of the processor caches in the chapter “Memory Management Utilities” in Inside Macintosh: Memory. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMove function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMove (
   const void * srcPtr,
   void * destPtr,
   Size byteCount){
//TODO
};


/*BlockMoveData


void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount
);
Parameters
srcPtr
destPtr
byteCount
Discussion

You should not make any assumptions about the state of the destination memory while BlockMoveData is executing. In the intermediate state, values may be present that are neither the original nor the final ones. For example, this function may use the 'dcbz' instruction. If the underlying memory is not cacheable, if the memory is write-through instead of copy-back, or if the cache block is flushed for some reason, the 'dcbz' instruction will write zeros to the destination. You can avoid the use of the 'dcbz' instruction by calling BlockMoveDataUncached, but even that function makes no other guarantees about the memory block's intermediate state. 
Special Considerations

Beginning in Mac OS X v10.4, the BlockMoveData function is inlined to a direct call to the POSIX memmove function. For more information, see the header file MacMemory.h.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void BlockMoveData (
   const void * srcPtr,
   void * destPtr,
   Size byteCount){
//TODO
};


/*PBGetCatInfoSync

Returns catalog information about a file or directory. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBGetCatInfoSync function returns information about a file or directory, depending on the values you specify in the ioFDirIndex, ioNamePtr, ioVRefNum, and ioDirID or ioDrDirID fields. If you need to determine whether the information returned is for a file or a directory, you can test bit 4 of the ioFlAttrib field; if that bit is set, the information returned describes a directory.

The PBGetCatInfoSync function selects a file or directory according to these rules:
If the value of ioFDirIndex is positive, ioNamePtr is not used as an input parameter and PBGetCatInfoSync returns information about the file or directory whose directory index is ioFDirIndex in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). If ioNamePtr is not NULL, then it must point to a Str31 buffer where the file or directory name will be returned. 
If the value of ioFDirIndex is 0, PBGetCatInfoSync returns information about the file or directory specified by ioNamePtr in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (again, this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). 
If the value of ioFDirIndex is negative, PBGetCatInfoSync ignores the ioNamePtr field and returns information about the directory specified in the ioDrDirID field. If ioNamePtr is not NULL, then it must point to a Str31 buffer where the directory name will be returned. 

With files, PBGetCatInfoSync is similar to PBHGetFInfoSync but returns some additional information. If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, the name of the file is returned in this field, if the file is open. If you do not want the name of the file returned, pass NULL in this field. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFRefNum 

On output, a file reference number. If the file is open, the reference number of the first access path found is returned here. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for the meaning of the file attributes. 
ioFlFndrInfo 

On output, information used by the Finder. 
ioDirID 

On input, a directory ID. On output, the file ID. You might need to save the value of ioDirID before calling PBGetCatInfoSync if you make subsequent calls with the same parameter block. 
ioFlStBlk 

On output, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioFlCrDat field to 0. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 
ioFlBkDat 

On output, the date and time of the file’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioFlBkDat field to 0. 
ioFlXFndrInfo 

On output, additional information used by the Finder. 
ioFlParID 

On output, the directory ID of the file’s parent directory. 
ioFlClpSiz 

On output, the file’s clump size. 

You can also use PBGetCatInfoSync to determine whether a file has a file ID reference. The value of the file ID is returned in the ioDirID field. Because that parameter could also represent a directory ID, call PBResolveFileIDRefSync to see if the value is a real file ID. If you want to determine whether a file ID reference exists for a file and create one if it doesn’t, use PBCreateFileIDRefSync , which will either create a file ID or return fidExists.

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, a pointer to the directory’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the directory attributes. See File Attribute Constants for the meaning of the bits in this field.The bits in this field for directories are read-only. You cannot alter directory attributes by setting these bits using the functions PBSetCatInfoSync or PBSetCatInfoAsync. Instead, you can call the PBHSetFLockSync and PBHRstFLockSync functions to lock and unlock a directory, and the PBShareSync and PBUnshareSync functions to enable and disable file sharing on local directories. 
ioACUser 

On output, the directory access rights. The PBGetCatInfoSync function returns the information in this field only for shared volumes. As a result, you should set this field to 0 before calling PBGetCatInfoSync. PBGetCatInfoSync does not return the blank access privileges bit in this field; to determine whether a directory has blank access privileges, use the PBHGetDirAccessSync function. See User Privileges Constants for a description of the constants that may be returned here. 
ioDrUsrWds 

On output, information used by the Finder. 
ioDrDirID 

On input, if you wish to obtain information about a specific directory, that directory’s ID. Otherwise, if the object returned is a directory, this field contains the directory ID on output. 
ioDrNmFls 

On output, the number of files in the directory. 
ioDrCrDat 

On output, the date and time of the directory’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioDrCrDat field to 0.
ioDrMdDat 

On output, the date and time of the directory’s last modification. 
ioDrBkDat 

On output, the date and time of the directory’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioDrBkDat field to 0.
ioDrFndrInfo 

On output, additional information used by the Finder. 
ioDrParID 

On output, the directory ID of the directory’s parent directory. 

To get information on a file or directory with named forks, or on a file larger than 2GB, use one of the FSGetCatalogInfo , PBGetCatalogInfoSync , or PBGetCatalogInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock){
//TODO
};


/*Munger

Searches text for a specified string pattern and replaces it with another string.

long Munger (
   Handle h,
   long offset,
   const void * ptr1,
   long len1,
   const void * ptr2,
   long len2
);
Parameters
h

A handle to the text string that is being manipulated. 
offset

The byte offset in the destination string at which Munger begins its operation. 
ptr1

A pointer to the first character in the string for which Munger is searching. 
len1

The number of bytes in the string for which Munger is searching.
ptr2

A pointer to the first character in the substitution string.
len2

The number of bytes in the substitution string.
Return Value

A negative value if Munger cannot find the designated string. 
Discussion

Munger manipulates bytes in a string to which you specify a handle in the h parameter. The manipulation begins at a byte offset, specified in offset, in the string. Munger searches for the string specified by ptr1 and len1; when it finds an instance of that string, it replaces it with the substitution string, which is specified by ptr2 and len2.

Munger operates on a byte-by-byte basis, which can produce inappropriate results for 2-byte script systems. The ReplaceText function works properly for all languages. You are encouraged to use ReplaceText instead of Munger whenever possible.

Munger takes special action if either of the specified pointer values is NULL or if either of the length values is 0.
If ptr1 is NULL, Munger replaces characters without searching. It replaces len1 characters starting at the offset location with the substitution string. 
If ptr1 is NULL and len1 is negative, Munger replaces all of the characters from the offset location to the end of the string with the substitution string. 
If len1 is 0, Munger inserts the substitution string without replacing anything. Munger inserts the string at the offset location and returns the offset of the first byte past where the insertion occurred. 
If ptr2 is NULL, Munger searches but does not replace. In this case, Munger returns the offset at which the string was found. 
If len2 is 0 and ptr2 is not NULL, Munger searches and deletes. In this case, Munger returns the offset at which it deleted. 
If the portion of the string from the offset location to its end matches the beginning of the string that Munger is searching for, Munger replaces that portion with the substitution string. 

Be careful not to specify an offset with a value that is greater than the length of the destination string. Unpredictable results may occur.

Munger calls the GetHandleSize and SetHandleSize functions to access or modify the length of the string it is manipulating. 
Special Considerations

Munger may move memory; your application should not call this function at interrupt time.

The destination string must be in a relocatable block that was allocated by the Memory Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
TextUtils.h*/
long Munger (
   Handle h,
   long offset,
   const void * ptr1,
   long len1,
   const void * ptr2,
   long len2){
//TODO
};


/*MemError

Determines if an application’s last direct call to a Memory Manager function executed successfully.

OSErr MemError (void);
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

For each thread, MemError yields the result code produced by the last Memory Manager function your application called directly.

MemError is useful during application debugging. You might also use MemError as one part of a memory-management scheme to identify instances in which the Memory Manager rejects overly large memory requests by returning the error code memFullErr.

To view the result codes that MemError can produce, see “Memory Manager Result Codes”.

Do not rely on MemError as the only component of a memory-management scheme. For example, suppose you call NewHandle or NewPtr and receive the result code noErr, indicating that the Memory Manager was able to allocate sufficient memory. In this case, you have no guarantee that the allocation did not deplete your application’s memory reserves to levels so low that simple operations might cause your application to crash. Instead of relying on MemError, check before making a memory request that there is enough memory both to fulfill the request and to support essential operations. 
Version Notes

Starting with Mac OS X v10.3, the MemError function provides error codes on a per-thread basis.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr MemError (void){
//TODO
};


/*NewAliasMinimalFromFullPath

Creates an alias record that contains only the full pathname of the target. (Deprecated in Mac OS X v10.4. Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.)

Not recommended

OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias
);
Parameters
fullPathLength

The number of characters in the full pathname of the target.
fullPath

A pointer to a buffer that contains the full pathname of the target. The full pathname starts with the name of the volume, includes all of the directory names in the path to the target, and ends with the target name. (For a description of pathnames, see the documentation for the File Manager.)
zoneName

The AppleTalk zone name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
serverName

The AppleTalk server name of the AppleShare volume on which the target resides. Set this parameter to a null string if you do not need it.
alias

A pointer to an alias handle. On return, this handle refers to the newly created alias record. If the function fails to create an alias record, it sets alias to NULL.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The NewAliasMinimalFromFullPath function creates an alias record that identifies the target by full pathname. You can call NewAliasMinimalFromFullPath to create an alias record for a file that doesn’t exist or that resides on an unmounted volume.

The NewAliasMinimalFromFullPath function uses the standard alias record data structure, but it fills in only the information provided in the input parameters. You can therefore use NewAliasMinimalFromFullPath to create alias records for targets on unmounted volumes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSNewAliasMinimal or FSNewAliasMinimalUnicode instead.
Declared In
Aliases.h*/
OSErr NewAliasMinimalFromFullPath (
   short fullPathLength,
   const void * fullPath,
   ConstStr32Param zoneName,
   ConstStr31Param serverName,
   AliasHandle * alias){
//TODO
};

/*ResolveAlias

Identifies the single most likely target of an alias record. (Deprecated in Mac OS X v10.4. Use FSResolveAlias instead.)

Not recommended

OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged
);
Parameters
fromFile

A pointer to the starting point for a relative search. If you pass a fromFile parameter of NULL, ResolveAlias performs only an absolute search. If you pass a pointer to a valid FSSpec structure in the fromFile parameter, ResolveAlias performs a relative search for the target, followed by an absolute search only if the relative search fails. If you want to perform an absolute search followed by a relative search, you must use the MatchAlias function.
alias

A handle to the alias record to be resolved and, if necessary, updated.
target

A pointer to the target of the alias record. This parameter must be a valid FSSpec structure.
wasChanged

A pointer to a Boolean value indicating whether the alias record to be resolved was updated because it contained some outdated information about the target. If it updates the alias record, ResolveAlias sets the wasChanged parameter to true. Otherwise, it sets it to false. (ResolveAlias never updates a minimal alias, so it never sets wasChanged to true when resolving a minimal alias.
Return Value

A result code. For more information, see the Carbon Result Code Index. 
Discussion

The ResolveAlias function performs a fast search for the target of the alias. If the resolution is successful, ResolveAlias returns (in the target parameter) the FSSpec structure for the target file system object, updates the alias record if necessary, and reports (through the wasChanged parameter) whether the record was updated. If the target is on an unmounted AppleShare volume, ResolveAlias automatically mounts the volume. If the target is on an unmounted ejectable volume, ResolveAlias asks the user to insert the volume. The ResolveAlias function exits after it finds one acceptable target.

After it identifies a target, ResolveAlias compares some key information about the target with the information in the alias record. (The description of the MatchAlias function lists the key information.) If the information differs, ResolveAlias updates the record to match the target.

When it finds the specified volume and parent directory but fails to find the target file or directory in that location, ResolveAlias returns a result code of fnfErr and fills in the target parameter with a complete FSSpec structure describing the target (that is, the volume reference number, parent directory ID, and filename or folder name). The FSSpec structure is valid, although the object it describes does not exist. This information is intended as a "hint" that lets you explore possible solutions to the resolution failure. You can, for example, pass the FSSpec structure to the File Manager function FSpCreate to create a replacement for a missing file.

The ResolveAlias function displays the standard dialog boxes when it needs input from the user, such as a name and password for mounting a remote volume. The user can cancel the resolution through these dialog boxes. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later but deprecated in Mac OS X v10.4.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Use FSResolveAlias instead.
Declared In
Aliases.h*/
OSErr ResolveAlias (
   const FSSpec * fromFile,
   AliasHandle alias,
   FSSpec * target,
   Boolean * wasChanged){
//TODO
};



/*NewHandleClear

Allocates a relocatable block of memory of a specified size with all its bytes set to 0.

Handle NewHandleClear (
   Size byteCount
);
Parameters
byteCount

The requested size (in bytes) of the relocatable block. The NewHandleClear function sets each of these bytes to 0. 
Return Value

A handle to the new block. If NewHandleClear cannot allocate a block of the requested size, it returns NULL. 
Discussion

The NewHandleClear function works like the NewHandle function, but sets all bytes in the new block to 0 instead of leaving the contents of the block undefined.

Call the function MemError to get the result code. See “Memory Manager Result Codes”.

Because NewHandleClear allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
Handle NewHandleClear (
   Size byteCount){
//TODO
};


/*PtrToHand

Copies data referenced by a pointer to a new relocatable block.

OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size
);
Parameters
srcPtr

The address of the first byte to copy. 
dstHndl

A handle for which you have not yet allocated any memory. The PtrToHand function allocates memory for the handle and copies the specified number of bytes beginning at srcPtr into it. The dstHndl parameter is an output parameter that will hold the result. Its value on entry is ignored. If no error occurs, on exit it points to an unlocked, non-purgeable Handle of the requested size. 
size

The number of bytes to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

If you dereference and lock a handle, the PtrToHand function can copy its data to a new handle. However, for copying data from one handle to another, the HandToHand function is more efficient.

Because PtrToHand allocates memory, you should not call it at interrupt time. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrToHand (
   const void * srcPtr,
   Handle * dstHndl,
   long size){
//TODO
};


/*MPCreateSemaphore

Creates a semaphore.

OSStatus MPCreateSemaphore (
   MPSemaphoreCount maximumValue,
   MPSemaphoreCount initialValue,
   MPSemaphoreID * semaphore
);
Parameters
maximumValue

The maximum allowed value of the semaphore. 
initialValue

The initial value of the semaphore.
semaphore

On return, semaphore contains the ID of the newly–created semaphore. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

If you want to create a binary semaphore, you can call the macro MPCreateBinarySemaphore (MPSemaphoreID *semaphore) instead, which simply calls MPCreateSemaphore with both maximumValue and initialValue set to 1.

Also see the function MPDeleteSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPCreateSemaphore (
   MPSemaphoreCount maximumValue,
   MPSemaphoreCount initialValue,
   MPSemaphoreID * semaphore){
//TODO
};


/*Byte Operations

The Driver Services Library provides several 32-, 16-, and 8-bit atomic memory operations for use by device drivers. These routines take logical address pointers and ensure that the operations are atomic with respect to all devices (for example, other processors and DMA engines) that participate in the coherency architecture of the Power Macintosh system.

IMPORTANT

Memory locations used by these operations must be long word aligned; if they are stored in a structure, you should use the compiler directive #pragma options align=power. 
Boolean
CompareAndSwap (long oldValue, long newValue, long *Value); 

SInt32      IncrementAtomic     (SInt32 *value);
SInt32      DecrementAtomic     (SInt32 *value); 

SInt32      AddAtomic           (SInt32 amount,         SInt32 *value); 

UInt32      BitAndAtomic        (UInt32 mask,           UInt32 *value);
UInt32      BitOrAtomic         (UInt32 mask,           UInt32 *value);
UInt32      BitXorAtomic        (UInt32 mask,           UInt32 *value); 

SInt16      IncrementAtomic16   (SInt16 *value);
SInt16      DecrementAtomic16   (SInt16 *value);
SInt16      AddAtomic16         (SInt32 amount,         SInt16 *value);
UInt16      BitAndAtomic16      (UInt32 mask,           UInt16 *value);
UInt16      BitOrAtomic16       (UInt32 mask,           UInt16 *value);
UInt16      BitXorAtomic16      (UInt32 mask,           UInt16 *value); 

SInt8       IncrementAtomic8    (SInt8 *value);
SInt8       DecrementAtomic8    (SInt8 *value);
SInt8       AddAtomic8          (SInt32 amount,         SInt8 *value);
UInt8       BitAndAtomic8       (UInt32 mask,           UInt8 *value);
UInt8       BitOrAtomic8        (UInt32 mask,           UInt8 *value);
UInt8       BitXorAtomic8       (UInt32 mask,           UInt8 *value); 
DESCRIPTION

The atomic routines perform various operations on the memory address specified by value : 
The CompareAndSwap routine compares the value at the specified address with oldValue. The value of newValue is written to the specified address only if oldValue and the value at the specified address are equal. CompareAndSwap returns true if newValue is written to the specified address; otherwise, it returns false. A false return value does not imply that oldValue and the value at the specified address are not equal; it only implies that CompareAndSwap did not write newValue to the specified address.
IncrementAtomic increments the value by 1 and DecrementAtomic decrements it by 1. These functions return the value as it was before the change.
AddAtomic adds the specified amount to the value at the specified address and returns the result. 
BitAndAtomic performs a logical and operation between the bits of the specified mask and the value at the specified address, returning the result. Similarly, BitOrAtomic performs a logical OR operation and BitXorAtomic performs a logical XOR operation.
EXECUTION CONTEXT

The atomic operation routines may be called from task level, secondary interrupt level, or hardware interrupt level.*/
Boolean CompareAndSwap (long oldValue, long newValue, long *Value){};

SInt32      IncrementAtomic     (SInt32 *value){};
SInt32      DecrementAtomic     (SInt32 *value){}; 

SInt32      AddAtomic           (SInt32 amount,         SInt32 *value){};

UInt32      BitAndAtomic        (UInt32 mask,           UInt32 *value){};
UInt32      BitOrAtomic         (UInt32 mask,           UInt32 *value){};
UInt32      BitXorAtomic        (UInt32 mask,           UInt32 *value){};
SInt16      IncrementAtomic16   (SInt16 *value){};
SInt16      DecrementAtomic16   (SInt16 *value){};
SInt16      AddAtomic16         (SInt32 amount,         SInt16 *value){};
UInt16      BitAndAtomic16      (UInt32 mask,           UInt16 *value){};
UInt16      BitOrAtomic16       (UInt32 mask,           UInt16 *value){};
UInt16      BitXorAtomic16      (UInt32 mask,           UInt16 *value){};
SInt8       IncrementAtomic8    (SInt8 *value){};
SInt8       DecrementAtomic8    (SInt8 *value){};
SInt8       AddAtomic8          (SInt32 amount,         SInt8 *value){};
UInt8       BitAndAtomic8       (UInt32 mask,           UInt8 *value){};
UInt8       BitOrAtomic8        (UInt32 mask,           UInt8 *value){};
UInt8       BitXorAtomic8       (UInt32 mask,           UInt8 *value){};


/*MPSignalSemaphore

Signals a semaphore. 

OSStatus MPSignalSemaphore (
   MPSemaphoreID semaphore
);
Parameters
semaphore

The ID of the semaphore you want to signal. 
Return Value

A result code. See "Multiprocessing Services Result Codes". If the value of the semaphore was already at the maximum, MPSignalSemaphore returns kInsufficientResourcesErr.
Discussion

If tasks are waiting on the semaphore, the oldest (first queued) task is unblocked so that the corresponding MPWaitOnSemaphore call for that task completes. Otherwise, if the value of the semaphore is not already equal to its maximum value, it is incremented by one.

Note that you can call this function from an interrupt handler. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPSignalSemaphore (
   MPSemaphoreID semaphore){
//TODO
};


/*Dequeue

Removes a queue element directly from an operating-system queue or from a queue that you have created.

OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to a queue element to remove from a queue. 
qHeader

A pointer to a queue header. 
Return Value

A result code. See “Memory Management Utilities Result Codes”.
Discussion

The Dequeue function attempts to find the queue element specified by the qElement parameter in the queue specified by the qHeader parameter. If Dequeue finds the element, it removes the element from the queue, adjusts the other elements in the queue accordingly, and returns noErr. Otherwise, it returns qErr, indicating that it could not find the element in the queue. The Dequeue function does not deallocate the memory occupied by the queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

The Dequeue function disables interrupts as it searches through the queue for the element to be removed. The time during which interrupts are disabled depends on the length of the queue and the position of the entry in the queue. The Dequeue function can be called at interrupt time. However, the Dequeue function is ordinarily used only by system software and, whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose removal functions. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Dequeue:
SlotVRemove

Removes a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VRemove

Removes a system-based VBL task. This function is available with the Vertical Retrace Manager.
WaitNextEvent

Removes an Event. This function is available with the Event manager.
SIntRemove

Removes a slot interrupt task. This function is available with the Slot Manager.
NMRemove

Removes a Notification request. This function is available with the Notification Manager.
SleepQRemove

Removes a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
OSErr Dequeue (
   QElemPtr qElement,
   QHdrPtr qHeader){
//TODO
};


/*Enqueue

Adds elements directly to an operating-system queue or a queue that you create.

void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader
);
Parameters
qElement

A pointer to the queue element to add to a queue. 
qHeader

A pointer to a queue header. 
Discussion

The Enqueue function adds the queue element specified by the qElement parameter to the end of the queue specified by the qHeader parameter. The specified queue header is updated to reflect the new queue element.

For a description of the QElem record, see QElem; for a description of the QHdr record, see QHdr.

Because interrupt functions are likely to manipulate operating-system queues, interrupts are disabled for a short time while the specified queue is updated. You can call the Enqueue function at interrupt time. However, the Enqueue function is ordinarily used only by system software. Whenever possible, you should manipulate an operating-system queue indirectly, by calling special-purpose functions whenever possible, instead of the Enqueue function. You can use the Queue Utilities functions for directly manipulating queues that you create. Use the following functions instead of Enqueue:
SlotVInstall

Installs a slot-based VBL task. This function is available with the Vertical Retrace Manager.
VInstall

Installs a system-based VBL task. This function is available with the Vertical Retrace Manager.
AddDrive

Adds a disk drive. This function is available with the Device Manager.
PPostEvent and PostEvent

Installs an Event. This function is available with the Event manager.
DTInstall

Installs a deferred task. This function is available with the Memory Management Utilities.
SIntInstall

Installs a slot interrupt task. This function is available with the Slot Manager.
NMInstall

Installs a Notification request. This function is available with the Notification Manager.
SleepQInstall

Installs a Sleep task. This function is available with the Power Manager.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OSUtils.h*/
void Enqueue (
   QElemPtr qElement,
   QHdrPtr qHeader){
//TODO
};


/*Bit Operations
Boolean TestAndSet(
                     UInt32 bit
                     UInt8 *startAddress); Boolean TestAndClear(
                     UInt32 bit
                     UInt8 *startAddress); 
--> bit 
The bit number in the range 0 through 7.
--> startAddress 
The address of the byte in which the bit is located.
DESCRIPTION

TestAndSet sets and TestAndClear clears a single bit in a byte at a specified address. They return true if the bit was already set or cleared respectively and false otherwise.
EXECUTION CONTEXT

TestAndSet and TestAndClear may be called from task level, secondary interrupt level, or hardware interrupt level.*/
Boolean TestAndSet(
                     UInt32 bit,
                     UInt8 *startAddress){}; 
Boolean TestAndClear(
                     UInt32 bit,
                     UInt8 *startAddress){}; 
/*MPWaitOnSemaphore

Waits on a semaphore

OSStatus MPWaitOnSemaphore (
   MPSemaphoreID semaphore,
   Duration timeout
);
Parameters
semaphore

The ID of the semaphore you want to wait on. 
timeout

The maximum time the function should wait before timing out. See Timer Duration Constants for a list of constants you can use to specify the wait interval. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

If the value of the semaphore is greater than zero, the value is decremented and the function returns with noErr. Otherwise, the task is blocked awaiting a signal until the specified timeout is exceeded.

If you call this function from a cooperative task, you should specify only kDurationImmediate for the timeout length; other waits will cause the task to block. 

Also see the function MPSignalSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/
OSStatus MPWaitOnSemaphore (
   MPSemaphoreID semaphore,
   Duration timeout){
//TODO
};


/*MPDeleteSemaphore

Removes a semaphore. 

OSStatus MPDeleteSemaphore (
   MPSemaphoreID semaphore
);
Parameters
semaphore

The ID of the semaphore you want to remove. 
Return Value

A result code. See "Multiprocessing Services Result Codes".
Discussion

Calling this function unblocks all tasks waiting on the semaphore and the tasks’ respective MPWaitOnSemaphore calls will return with the result code kMPDeletedErr.

Also see the function MPCreateSemaphore. 
Version Notes

Introduced with Multiprocessing Services 1.0. 
Availability
Available in CarbonLib 1.0 and later when MultiprocessingLib 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Multiprocessing.h*/

OSStatus MPDeleteSemaphore (
   MPSemaphoreID semaphore){
//TODO
};

/*Microseconds

Determines the number of microseconds that have elapsed since system startup time.

void Microseconds (
   UnsignedWide * microTickCount
);
Parameters
microTickCount

The number of microseconds elapsed since system startup.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Timer.h*/
void Microseconds (
   UnsignedWide * microTickCount){
//TODO
};

int CSSetComponentsThreadMode(int a){
//TODO
};


/*FSpOpenDF

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose data fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s data fork. In most cases, you can simply set the permission parameter to fsCurPerm. Some applications request fsRdWrPerm, to ensure that they can both read from and write to a file. For a description of the types of access that you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open data fork. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenDF is not available, you can use the function HOpenDF instead.

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenDF function, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum){
//TODO
};

/*GetEOF

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSGetForkSize instead.)

OSErr GetEOF (
   short refNum,
   long * logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

On return, a pointer to the logical size (the logical end-of-file) of the given file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetEOF (
   short refNum,
   long * logEOF){
//TODO
};

/*FSRead

Reads any number of bytes from an open file. (Deprecated in Mac OS X v10.4. Use FSReadFork instead.)

OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);
Parameters
refNum

The file reference number of the open file from which to read. 
count

On input, a pointer to the number of bytes to read; on output, a pointer to the number of bytes actually read. 
buffPtr

A pointer to the data buffer into which the data will be read. This buffer is allocated by your application and must be at least as large as the count parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read operation begins at the current mark, you might want to set the mark first by calling the SetFPos function. If you try to read past the logical end-of-file, FSRead reads in all the data up to the end-of-file, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, FSRead moves the file mark to the byte following the last byte read and returns noErr.

The low-level functions PBReadSync and PBReadAsync let you set the mark without having to call SetFPos. Furthermore, if you want to read data in newline mode, you must use PBReadSync or PBReadAsync instead of FSRead. For a description of the PBReadSync and PBReadAsync functions, see the Device Manager Reference .

If you wish to read from named forks other than the data or resource forks, or from files larger than 2GB, you must use the FSReadFork function, or one of its corresponding parameter block calls, PBReadForkSync and PBReadForkAsync. If you attempt to use FSRead to read from a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr){
//TODO
};

/*FSClose

Closes an open file. (Deprecated in Mac OS X v10.4. Use FSCloseFork instead.)

OSErr FSClose (
   short refNum
);
Parameters
refNum

The file reference number of the open file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSClose function removes the access path for the specified file and writes the contents of the volume buffer to the volume.

The FSClose function calls the PBFlushFileSync function internally to write the file’s bytes onto the volume. To ensure that the file’s catalog entry is updated, you should call FlushVol after you call FSClose. 
Special Considerations

Make sure that you do not call FSClose with a file reference number of a file that has already been closed. Attempting to close the same file twice may result in loss of data on a volume.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSClose (
   short refNum){
//TODO
};

/*PtrAndHand

Concatenates part or all of a memory block to the end of a relocatable block.

OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size
);
Parameters
ptr1

A pointer to the beginning of the data that the Memory Manager is to concatenate onto the end of the relocatable block. 
hand2

A handle to the relocatable block, whose size the Memory Manager expands so that it can concatenate the information from ptr1 onto the end of this block. 
size

The number of bytes of the block referenced by ptr1 to copy. 
Return Value

A result code. See “Memory Manager Result Codes”.
Discussion

The PtrAndHand function takes the number of bytes specified by the size parameter, beginning at the location specified by ptr1, and concatenates them onto the end of the relocatable block to which hand2 is a handle. The contents of the source block remain unchanged.

Because PtrAndHand allocates memory, you should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
OSErr PtrAndHand (
   const void * ptr1,
   Handle hand2,
   long size){
//TODO
};

/*HLock

Prevents a relocatable block from moving within its heap zone.

void HLock (
   Handle h
);
Parameters
h

A handle to a relocatable block. 
Discussion

If you plan to dereference a handle and then allocate, move, or purge memory (or call a function that does so), then you should lock the handle before using the dereferenced handle.

If the block is already locked, HLock does nothing.

If you plan to lock a relocatable block for long periods of time, you can prevent fragmentation by ensuring that the block is as low as possible in the heap zone. To do this, see the description of the ReserveMem function.

If you plan to lock a relocatable block for short periods of time, you can prevent heap fragmentation by moving the block to the top of the heap zone before locking. For more information, see the description of the MoveHHi function.

Call the function MemError to get the result code. See “Memory Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacMemory.h*/
void HLock (Handle h){
//TODO
};

/*OpenAComponent


OSErr OpenAComponent (
   Component aComponent,
   ComponentInstance * ci
);
Parameters
aComponent
ci
Return Value

A result code. See “Component Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when QuickTime 2.5 or later is present. Available in Mac OS X 10.0 and later.
Available in QuickTime for Windows.
Carbon Porting Notes
Declared In
Components.h*/
OSErr OpenAComponent (
   Component aComponent,
   ComponentInstance * ci){
//TODO
};

/*NumToString

Converts a long integer value into a Pascal string. (Deprecated in Mac OS X v10.4. Use CFStringCreateWithFormat instead.)

void NumToString (
   long theNum,
   Str255 theString
);
Parameters
theNum

A long integer value. If the value of the number in the parameter theNum is negative, the string begins with a minus sign; otherwise, the sign is omitted. 
theString

On output, contains the Pascal string representation of the number. Leading zeros are suppressed, except that a value of 0 produces the string “0”. NumToString does not include thousand separators or decimal points in its formatted output. 
Discussion

NumToString creates a string representation of theNum as a base-10 value and returns the result in theString.

Unless patched by a script system with different rules, this function assumes that you are using standard numeric token processing, meaning that the Roman script system number processing rules are used.

For functions that make use of the token-processing information that is found in the tokens ('itl4') resource of script systems for converting numbers, see the sections “Using Number Format Specification Strings for International Number Formatting” and “Converting Between Strings and Floating-Point Numbers”. 
Special Considerations

NumToString may move memory; your application should not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
NumberFormatting.h*/
void NumToString (
   long theNum,
   Str255 theString){
//TODO
};


/*FSFindFolder

Obtains location information for system-related directories.

OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType)on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Passing kCreateFolder will not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundRef

A pointer to a file system reference. On return, the FSRef refers to the directory specified by the vRefNum and folderType parameters.
Return Value

A result code. See "Folder Manager Result Codes".
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef){
//TODO
};

/*X2Fix

Converts an Extended number to a Fixed number.

Fixed X2Fix (
   double x
);
Parameters
x

The Extended number to be converted to a Fixed number. 
Return Value

The best Fixed approximation of the Extended number x. If x is greater than the maximum representable Fixed number, the X2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, X2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed X2Fix (
   double x){
//TODO
};

/*FSRefMakePath

Converts an FSRef into a path.

OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);
Parameters
ref

The FSRef to convert into a path. 
path

On return, a pointer to the path. This path can be used by POSIX-style calls. 
pathSize

The size of the path. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize){
//TODO
};

/*FSGetDataForkName

Returns a Unicode string constant for the name of the data fork.

OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);
Parameters
dataForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the data fork. Currently, this is the empty string. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName){
//TODO
};


/*FSGetForkSize

Returns the size of an open fork. 

OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
forkSize

On return, a pointer to the logical size (the logical end-of-file) of the fork, in bytes. The size returned is the total number of bytes that can be read from the fork; the amount of space actually allocated on the volume (the physical size) will probably be larger. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

To determine whether the FSGetForkSize function is present, call the Gestalt function. If FSGetForkSize is present, but is not directly supported by a volume, the File Manager will call PBGetEOFSync; however, you will not be able to determine the size of a fork other than the data or resource fork, or of a fork larger than 2 GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize){
//TODO
};

/*FSEjectVolumeSync

Ejects a volume.

OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);
Parameters
vRefNum

The volume reference number of the volume to eject. 
flags

Options for future use.
dissenter

On return, a pointer to the pid of the process which denied the unmount if the eject is denied.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function ejects the volume specified by the vRefNum parameter. If the volume cannot be ejected the pid of the process which denied the unmount will be returned in the dissenter parameter. This function returns after the eject is complete. Ejecting a volume will result in the unmounting of other volumes on the same device.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter){
//TODO
};

/*PBMakeFSRefSync

Creates an FSRef for a file or directory, given an FSSpec.

OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the parameter block based calls, the fields of the source FSSpec are passed as separate parameters (in the ioNamePtr, ioVRefNum, and ioDirID fields). This allows the call to be dispatched to external file systems the same way as other FSp calls are. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you wish to create an FSRef. 
ioVRefNum 

On input, a volume specification for the volume containing the file or directory. This can be a volume reference number, a drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the file or directory’s parent directory. 
newRef 

On input, a pointer to an FSRef structure. On output, this FSRef refers to the specified file or directory. 

To obtain an FSSpec from an FSRef, use the PBGetCatalogInfoSync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock){
//TODO
};


/*Fix2X

Converts a Fixed number to an Extended number.

double Fix2X (
   Fixed x
);
Parameters
x

The Fixed number to be converted to an Extended number. 
Return Value

The Extended equivalent of the Fixed number x. 
Special Considerations

Fix2X does not move memory; you can call it at interrupt time.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
double Fix2X (
   Fixed x){};




