#include <CoreAudio/CoreAudio.h>
/*AudioHardwareGetPropertyInfo


Retrieve information about the given property. 
extern OSStatus AudioHardwareGetPropertyInfo(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property to query.
outSize
A pointer to a UInt32 that receives the size of the property data in bytes on exit. This can be NULL if the size information is not being requested.
outWritable
A pointer to a Boolean that receives indication of whether or not the given property can be set. This can be NULL if the writability is not being requested.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the functions AudioObjectHasProperty(), AudioObjectIsPropertySettable(), and AudioObjectGetPropertyDataSize(). 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioHardwareGetPropertyInfo(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable){};  

/*AudioHardwareGetProperty


Queries an the AudioSystemObject to get the data of the given property and places it in the provided buffer. 
extern OSStatus AudioHardwareGetProperty(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property to query.
ioDataSize
A UInt32 which on entry indicates the size of the buffer pointed to by outData and on exit indicates how much of the buffer was used.
outData
The buffer into which the AudioSystemObject will put the data for the given property.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the function AudioObjectGetPropertyData(). 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioHardwareGetProperty(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData){};



/*AudioDeviceGetProperty


Queries an the AudioDevice object to get the data of the given property and places it in the provided buffer. 
extern OSStatus AudioDeviceGetProperty(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData);  
Parameters
inDevice
The AudioDevice to query.
inChannel
The channel of the property to query where 0 is the master channel.
isInput
Which section of the AudioDevice to query.
inPropertyID
The AudioDevicePropertyID of the property to query.
ioPropertyDataSize
A UInt32 which on entry indicates the size of the buffer pointed to by outData and on exit indicates how much of the buffer was used.
outPropertyData
The buffer into which the object will put the data for the given property.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the function AudioObjectGetPropertyData(). 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioDeviceGetProperty(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData){};


/*AudioDeviceGetPropertyInfo


Retrieve information about the given property of an AudioDevice. 
extern OSStatus AudioDeviceGetPropertyInfo(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable);  
Parameters
inDevice
The AudioDevice to query.
inChannel
The channel of the property to query where 0 is the master channel.
isInput
Which section of the AudioDevice to query.
inPropertyID
The AudioDevicePropertyID of the property to query.
outSize
A pointer to a UInt32 that receives the size of the property data in bytes on exit. This can be NULL if the size information is not being requested.
outWritable
A pointer to a Boolean that receives indication of whether or not the given property can be set. This can be NULL if the writability is not being requested.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the functions AudioObjectHasProperty(), AudioObjectIsPropertySettable(), and AudioObjectGetPropertyDataSize(). 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioDeviceGetPropertyInfo(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable){};


/*AudioHardwareAddPropertyListener


Registers the given AudioHardwarePropertyListenerProc to receive notifications when the given property changes. 
extern OSStatus AudioHardwareAddPropertyListener(
    AudioHardwarePropertyID inPropertyID, 
    AudioHardwarePropertyListenerProc inProc, 
    void*inClientData);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property to listen to.
inProc
AudioHardwarePropertyListenerProc to call.
inClientData
A pointer to client data that is passed to the listener when it is called.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by AudioObjectAddPropertyListener in conjunction with AudioObjectPropertyListenerProc. 
Availability
Introduced in Mac OS X v10.0.*/
OSStatus AudioHardwareAddPropertyListener(
    AudioHardwarePropertyID inPropertyID, 
    AudioHardwarePropertyListenerProc inProc, 
    void*inClientData){};


