@class NSBitmapImageRep, NSCursor, NSGraphicsContext, NSImage, NSPasteboard, NSScrollView, NSWindow, NSAttributedString;

@interface NSView (ADD)
/*
inLiveResize

A convenience method, expected to be called from drawRect:, to assist in decisions about optimized drawing.

- (BOOL)inLiveResize
Return Value

YES if the receiver is in a live-resize operation, NO otherwise.
Availability
Available in Mac OS X v10.1 and later.
See Also
– viewDidEndLiveResize
– viewWillStartLiveResize*/
- (BOOL)inLiveResize; //hys

/*bitmapImageRepForCachingDisplayInRect:

Returns a bitmap-representation object suitable for caching the specified portion of the receiver.

- (NSBitmapImageRep *)bitmapImageRepForCachingDisplayInRect:(NSRect)aRect
Parameters
aRect

A rectangle defining the area of the receiver to be cached.
Return Value

An autoreleased NSBitmapImageRep object or nil if the object could not be created.
Discussion

Passing the visible rectangle of the receiver ([self visibleRect]) returns a bitmap suitable for caching the current contents of the view, including all of its descendants. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– cacheDisplayInRect:toBitmapImageRep:*/
- (NSBitmapImageRep *)bitmapImageRepForCachingDisplayInRect:(NSRect)aRect;

/*cacheDisplayInRect:toBitmapImageRep:

Draws the specified area of the receiver, and its descendants, into a provided bitmap-representation object.

- (void)cacheDisplayInRect:(NSRect)rect toBitmapImageRep:(NSBitmapImageRep *)bitmapImageRep
Parameters
rect

A rectangle defining the region to be drawn into bimapImageRep.
bitmapImageRep

An NSBitmapImageRep object. For pixel-format compatibility, bitmapImageRep should have been obtained from bitmapImageRepForCachingDisplayInRect:. 
Discussion

You are responsible for initializing the bitmap to the desired configuration before calling this method. However, once initialized, you can reuse the same bitmap multiple times to refresh the cached copy of your view’s contents.

The bitmap produced by this method is transparent (that is, has an alpha value of 0) wherever the receiver and its descendants do not draw any content. 
Availability
Available in Mac OS X v10.4 and later.
See Also
– bitmapImageRepForCachingDisplayInRect:*/
- (void)cacheDisplayInRect:(NSRect)rect toBitmapImageRep:(NSBitmapImageRep *)bitmapImageRep;

@end
/*NSViewGlobalFrameDidChangeNotification

Posted whenever an NSView object that has attached surfaces (that is, NSOpenGLContext objects) moves to a different screen, or other cases where the NSOpenGLContext object needs to be updated. The notification object is the surface’s view. This notification does not contain a userInfo dictionary.
Availability
Available in Mac OS X v10.1 and later.*.
APPKIT_EXPORT NSString *NSViewGlobalFrameDidChangeNotification; //hys*/
APPKIT_EXPORT NSString *NSViewGlobalFrameDidChangeNotification;