#ifndef AUDIOFORMAT_H
#define AUDIOFORMAT_H


#include <AvailabilityMacros.h>
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif

#if defined(__cplusplus)
extern "C"
{
#endif

/*Audio Format Types
Defined Data Types

The AudioFormatPropertyID typedef is used to hold the property ID being queried using the audio format functions.
typedef UInt32 AudioFormatPropertyID
Data Structures*/
typedef UInt32 AudioFormatPropertyID;

/*AudioChannelLayout Properties
kAudioFormatProperty_ChannelLayoutForTag = 'cmpl 

Takes an “Channel Layout Tags” value (as specified in CoreAudioTypes.h) as the specifier and returns an AudioChannelLayout with all of its members filled with their respective versions of the input data.
kAudioFormatProperty_TagForChannelLayout = 'cmpt'

Takes an AudioChannelLayout as the specifier and returns an AudioChannelLayoutTag with all of its members filled with their respective versions of the input data.
kAudioFormatProperty_ChannelLayoutForBitmap = 'cmpb'

Takes in a UInt32 that contains a layout bitmap and returns an AudioChannelLayout with all of its members filled with their respective versions of the input data.
kAudioFormatProperty_BitmapForLayoutTag = 'bmtg'

Takes in a “Channel Layout Tags” value and returns a UInt32 with the bitmap of the channel layout.
kAudioFormatProperty_ChannelLayoutName = 'lonm'

Takes in an AudioChannelLayout and returns a CFStringRef with the name of the channel.
kAudioFormatProperty_ChannelName = 'cnam'

Takes in an AudioChannelDescription with a populated mChannelLabel value, and returns a CFStringRef with the name of the channel.
kAudioFormatProperty_MatrixMixMap = 'mmap'

Takes in an array of two AudioChannelLayout pointers, the first to the input and the second to the output, and returns a two dimensional Float32 array, with the input being the rows and the output being the columns, where the value at a coordinate is the gain that needs to be applied to the input to achieve the output at that channel.
kAudioFormatProperty_NumberOfChannelsForLayout = 'nchm'

Takes in an AudioChannelLayout as the specifier and returns a UInt32 with the number of channels represented in the layout.
kAudioFormatProperty_PanningMatrix = 'panm'

Takes in an AudioPanningInfo instance and returns a Float32 array where each channel receives a volume level for each channel in the AudioPanningInfo’s AudioChannelLayout array.*/
enum {
kAudioFormatProperty_ChannelLayoutForTag = 'cmpl ',
kAudioFormatProperty_TagForChannelLayout = 'cmpt',
kAudioFormatProperty_ChannelLayoutForBitmap = 'cmpb',
kAudioFormatProperty_BitmapForLayoutTag = 'bmtg',
kAudioFormatProperty_ChannelLayoutName = 'lonm',
kAudioFormatProperty_ChannelName = 'cnam',
kAudioFormatProperty_MatrixMixMap = 'mmap',
kAudioFormatProperty_NumberOfChannelsForLayout = 'nchm',
kAudioFormatProperty_PanningMatrix = 'panm'
};

/*AudioFormatGetPropertyInfo

Retrieves the size of the data to be returned by the property.

extern OSStatus AudioFormatGetPropertyInfo(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* outPropertyDataSize
);
Availability
Available in Mac OS X v10.3 and later.*/
extern OSStatus AudioFormatGetPropertyInfo(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* outPropertyDataSize
);

/*AudioFormatGetProperty

Retrieves the property information for the given property ID and selected specifier.

extern OSStatus AudioFormatGetProperty(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* ioPropertyDataSize,
void* outPropertyData
);
Availability
Available in Mac OS X v10.3 and later.*/
extern OSStatus AudioFormatGetProperty(
AudioFormatPropertyID inPropertyID,
UInt32 inSpecifierSize,
void* inSpecifier,
UInt32* ioPropertyDataSize,
void* outPropertyData
);

#ifdef __cplusplus
}
#endif

#endif