#ifndef AUCOMPONENT_H
#define AUCOMPONENT_H

#include <AvailabilityMacros.h>
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreServices/CoreServices.h>
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <Components.h>
	#include <CoreAudioTypes.h>
#endif

#include <HYS/AudioUnit/AUComponent.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Types

These basic types are common within the context of audio units.typedef UInt32 AudioUnit
typedef UInt32 AudioUnitPropertyID
typedef UInt32 AudioUnitParameterID
typedef UInt32 AudioUnitScope
typedef UInt32 AudioUnitElement
typedef UInt32 AUParameterEventType
typedef UInt32 AudioUnitParameterUnit*/
typedef UInt32 AudioUnit;
typedef UInt32 AudioUnitPropertyID;
typedef UInt32 AudioUnitParameterID;
typedef UInt32 AudioUnitScope;
typedef UInt32 AudioUnitElement;
typedef UInt32 AUParameterEventType;
typedef UInt32 AudioUnitParameterUnit;

/*AURenderCallback

A callback set by kAudioUnitProperty_SetRenderCallback for performing an audio unit’s render.

typedef CALLBACK_API_C( OSStatus , AURenderCallback )(void *inRefCon, AudioUnitRenderActionFlags *ioActionFlags, const AudioTimeStamp *inTimeStamp, UInt32 inBusNumber, UInt32 inNumberFrames, AudioBufferList *ioData)

OSStatus AURenderCallback(
void *      inRefCon;
AudioUnitRenderActionFlags      * ioActionFlags;
const AudioTimeStamp    *   inTimeStamp;
UInt32       inBusNumber;
UInt32       inNumberFrames;
AudioBufferList*       ioData
)
Parameters
inRefCon

Parameters passed to the callback.
ioActionFlags

Flags for rendering options.
inTimeStamp

The time that the callback is invoked.
inBusNumber

The bun on which data will be supplied.
inNumberFrames

The number of frames to be rendered.
ioData

The audio data to be rendered upon.*/


typedef OSStatus (*AURenderCallback)(
void *      inRefCon,
AudioUnitRenderActionFlags      * ioActionFlags,
const AudioTimeStamp    *   inTimeStamp,
UInt32       inBusNumber,
UInt32       inNumberFrames,
AudioBufferList*       ioData
);


/*AudioUnitInitialize

Initializes an audio unit instance.

ComponentResult AudioUnitInitialize(
AudioUnit           ci
)
Parameters
ci

The audio unit to be initialized.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitInitialize(
AudioUnit           ci
);

/*AudioUnitRender

Performs the action on a buffer of audio data.

ComponentResult AudioUnitRender(
   AudioUnit                     ci,
   AudioUnitRenderActionFlags*   ioActionFlags,
   const AudioTimeStamp*         inTimeStamp,
   UInt32                        inOutputBusNumber,
   UInt32                        inNumberFrames,
   AudioBufferList*              ioData
)
Parameters
ci

The audio unit to be changed.
ioActionFlags

Flags that provide information on the render; see “Render Action Flags”.
inTimeStamp

The time the render is begun.
inOutputBusNumber

The bus on which the output will be placed.
inNumberFrames

The number of frames to be rendered.
ioData

The audio data, before and after the render.
Availability
Available in Mac OS X v10.2 and later.*/

ComponentResult AudioUnitRender(
   AudioUnit                     ci,
   AudioUnitRenderActionFlags*   ioActionFlags,
   const AudioTimeStamp*         inTimeStamp,
   UInt32                        inOutputBusNumber,
   UInt32                        inNumberFrames,
   AudioBufferList*              ioData
);

/*AudioUnitGetProperty

Returns the size of the data for a specified property.

ComponentResult AudioUnitGetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   void*                 outData,
   UInt32*               ioDataSize
)
Parameters
ci

The audio unit on which the property is to be queried.
inID

The property to be queried upon.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
outData

A pointer to the data corresponding to the property.
ioDataSize

The expected data size and the actual data size returned.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitGetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   void*                 outData,
   UInt32*               ioDataSize
);

/*AudioUnitGetPropertyInfo

Returns the size of the data that will be returned when calling AudioUnitGetProperty for the specified property.

ComponentResult AudioUnitGetPropertyInfo(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   UInt32*               outDataSize,
   Boolean*              outWritable
)
Parameters
ci

The audio unit on which the property is to be queried.
inID

The property to be queried upon.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
outDataSize

The size, in bytes, of the property.
outWritable

A boolean showing if the property is writable.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitGetPropertyInfo(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   UInt32*               outDataSize,
   Boolean*              outWritable
);

/*AudioUnitUninitialize

Uninitializes an audio unit instance.

ComponentResult AudioUnitUninitialize(
AudioUnit ci
)
Parameters
ci

The audio unit to be uninitialized.
Availability
Available in Mac OS X v10.0 and later.*/

ComponentResult AudioUnitUninitialize(
AudioUnit ci
);

/*AudioUnitSetProperty

Sets a property’s value to the supplied value.

ComponentResult AudioUnitSetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   const void*           inData,
   UInt32                inDataSize
)
Parameters
ci

The audio unit on which the property is to be applied.
inID

The property to be modified.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
inData

A pointer to the data to be applied to the property.
inDataSize

The size of the data being passed in.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitSetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   const void*           inData,
   UInt32                inDataSize
);

#ifdef __cplusplus
}
#endif

#endif