#ifndef CFHTTPMESSAGE_H
#define CFHTTPMESSAGE_H

#ifndef CFSTRING_H
#include <CoreFoundation/CFString.h>
#endif

#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CFHTTP Version Constants

Sets the HTTP version in a CFHTTPMessage request or response object.

const CFStringRef kCFHTTPVersion1_0;const CFStringRef kCFHTTPVersion1_1;
Constants
kCFHTTPVersion1_0

Specifies HTTP version 1.0.

Available in Mac OS X version 10.1 and later.
kCFHTTPVersion1_1

Specifies HTTP version 1.1.

Available in Mac OS X version 10.1 and later.
Discussion

The HTTP version constants are used when you call CFHTTPMessageCreateRequest and CFHTTPMessageCreateResponse to create a request or response message.
Declared In
CFNetwork/CFHTTPMessage.h*/
const CFStringRef kCFHTTPVersion1_0;
const CFStringRef kCFHTTPVersion1_1;

/*CFHTTPMessageRef

An opaque reference representing an HTTP message.

typedef struct __CFHTTPMessage *CFHTTPMessageRef;
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
typedef struct __CFHTTPMessage *CFHTTPMessageRef;

/*CFHTTPMessageCreateRequest

Creates and returns a CFHTTPMessage object for an HTTP request.

CFHTTPMessageRef CFHTTPMessageCreateRequest (
    CFAllocatorRef allocator,
    CFStringRef requestMethod,
    CFURLRef url,
    CFStringRef httpVersion
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
requestMethod

The request method for the request. Use any of the request methods allowed by the HTTP version specified by httpVersion.
url

The URL to which the request will be sent.
httpVersion

The HTTP version for this message. Pass kCFHTTPVersion1_0 or kCFHTTPVersion1_1.
Return Value

A new CFHTTPMessage object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function returns a CFHTTPMessage object that you can use to build an HTTP request. Continue building the request by callingCFHTTPMessageSetBody to set the message’s body. Call CFHTTPMessageCopyHeaderFieldValue to set the message’s headers.

If you are using a CFReadStream object to send the message, call CFReadStreamCreateForHTTPRequest to create a read stream for the request. If you are not using CFReadStream, call CFHTTPMessageCopySerializedMessage to make the message ready for transmission by serializing it.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFHTTPMessageRef CFHTTPMessageCreateRequest (
    CFAllocatorRef allocator,
    CFStringRef requestMethod,
    CFURLRef url,
    CFStringRef httpVersion
);


#ifdef __cplusplus
}
#endif

#endif