#ifndef RESOURCES_H
#define RESOURCES_H



#ifndef __MACTYPES__
#include <CarbonCore/MacTypes.h>
#endif

#ifndef __MIXEDMODE__
#include <CarbonCore/MixedMode.h>
#endif

#ifndef __FILES__
#include <CarbonCore/Files.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*FSOpenResFile

Opens a resource file using a file system reference (FSRef).

short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);
Availability
Available in CarbonLib 1.1 and later when running Mac OS 9.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
short FSOpenResFile (
   const FSRef * ref,
   SInt8 permission
);

/*CloseResFile

Closes a resource fork before your application terminates.

void CloseResFile (
   short refNum
);
Parameters
refNum

The file reference number for the resource fork to close. If this parameter does not contain a file reference number for a file whose resource fork is open, the function does nothing, and the ResError function returns the result code resFNotFound. If the value of this parameter is 0, it represents the System file and is ignored. You cannot close the System file’s resource fork. 
Discussion

This function performs four tasks. First, it updates the file by calling the UpdateResFile function. Second, it releases the memory occupied by each resource in the resource fork by calling the DisposeHandle function. Third, it releases the memory occupied by the resource map. The fourth task is to close the resource fork.

When your application terminates, the Resource Manager automatically closes every resource fork open to your application except the System file’s resource fork. You need to call this function only if you want to close a resource fork before your application terminates.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void CloseResFile (
   short refNum
);

/*Get1IndResource

Returns a handle to a resource of a given type in the current resource file.

Handle Get1IndResource (
   ResType theType,
   short index
);
Parameters
theType

A resource type.
index

An integer ranging from 1 to the number of resources of a given type returned by the Count1Resources function, which is the number of resources of that type in the current resource file.
Return Value

A handle to a resource of the given type. If you call Get1IndResource repeatedly over the entire range of the index, it returns handles to all resources of the given type in the current resource file. If you provide an index that is either 0 or negative, the function returns NULL, and the ResError function returns the result code resNotFound. If the given index is larger than the value returned by Count1Resources, Get1IndResource returns NULL, and ResError returns the result code resNotFound. If the resource to be read won’t fit into memory, the function returns NULL, and ResError returns the appropriate result code.
Discussion

The function reads the resource data into memory if it’s not already there, unless you’ve called the SetResLoad function with the load parameter set to FALSE. If you’ve called SetResLoad with the load parameter set to FALSE and the data isn’t already in memory, Get1IndResource returns an empty handle (that is, a handle whose master pointer is set to NULL). This can also happen if you read resource data for a purgeable resource into memory and then call SetResLoad with the load parameter set to FALSE. If the resource data is later purged and you call the Get1IndResource function, the function returns an empty handle. You should test for an empty handle in these situations. To make the handle a valid handle to resource data in memory, you can call the MacLoadResource function.
Special Considerations

This function may move or purge memory blocks in the application heap. Your application should not call this function at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1IndResource (
   ResType theType,
   short index
);

/*DetachResource

Sets the value of a resource’s handle in the resource map in memory to NULL while keeping the resource data in memory.

void DetachResource (
   Handle theResource
);
Parameters
theResource

A handle to the resource which you wish to detach. If this parameter doesn’t contain a handle to a resource or if the resource’s resChanged attribute is set, the function does nothing. To determine whether either of these errors occurred, call the ResError function. 
Discussion

After this call, the Resource Manager no longer recognizes the handle as a handle to a resource. However, this function does not release the memory used for the resource data, and the master pointer is still valid. Thus, you can access the resource data directly by using the handle.

If your application subsequently calls a Resource Manager function to get the released resource, the Resource Manager assigns a new handle.You can use DetachResource if you want to access the resource data directly without using Resource Manager functions. You can also use the DetachResource function to keep resource data in memory after closing a resource fork.

To copy a resource and install an entry for the duplicate in the resource map, call DetachResource, then call the AddResource function using a different resource ID. 
Special Considerations

Do not use this function to detach a System resource that might be shared by several applications.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
void DetachResource (
   Handle theResource
);

/*Get1Resource

Gets resource data for a resource in the current resource file.

Handle Get1Resource (
   ResType theType,
   short theID
);
Parameters
theType

The resource type of the resource about which you wish to retrieve data.
theID

An integer that uniquely identifies the resource about which you wish to retrieve data.
Return Value

If the function finds an entry for the resource in the current resource file’s resource map and the entry contains a valid handle, it returns that handle. If the entry contains a handle whose value is NULL, and if you haven’t called the SetResLoad function with the load parameter set to FALSE, Get1Resource attempts to read the resource into memory.

If the function can’t find the resource data, it returns NULL, and ResError returns the result code resNotFound. The Get1Resource function also returns NULL if the resource data to be read into memory won’t fit, in which case ResError returns an appropriate Memory Manager result code.

If you call this function with a resource type that can’t be found in the resource map of the current resource file, the function returns NULL, but ResError returns the result code noErr. You should always check that the value of the returned handle is not NULL.
Discussion

The function searches the current resource file’s resource map in memory for the specified resource.

You can change the resource map search order by calling the UseResFile function before Get1Resource.

To include ROM-resident system resources in the Resource Manager’s search of the resource maps for open resource forks, use the RGetResource function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
Handle Get1Resource (
   ResType theType,
   short theID
);

/*ResError

Determines what error occurred, if any, after calling a Resource Manager function. 

OSErr ResError ();
Return Value

A result code. See “Resource Manager Result Codes”. If no error occurred, the function returns noErr. If an error occurs at the Resource Manager level, the function returns one of the result codes specific to the Resource Manager. If an error occurs at the Operating System level, the function returns an Operating System result code. In certain cases, the ResError function returns noErr even though a Resource Manager function was unable to perform the requested operation. See the individual function descriptions for details about the circumstances under which this happens.
Discussion

Resource Manager functions do not report error information directly. Instead, after calling a Resource Manager function, your application should call this function to determine whether an error occurred. You also can use this function to check for an error after application startup (system software opens the resource fork of your application during application startup).

Resource Manager functions usually return NULL or –1 as the function result when there’s an error. For Resource Manager functions that return –1, your application can call the ResError function to determine the specific error that occurred. For Resource Manager functions that return handles, your application should always check whether the value of the returned handle is NULL. If it is, your application can use this function to obtain specific information about the nature of the error. Note, however, that in some cases ResError returns noErr even though the value of the returned handle is NULL.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Resources.h*/
OSErr ResError ();

#ifdef __cplusplus
}
#endif

#endif