#ifndef CFDATE_H
#define CFDATE_H



#include <CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CFDateRef

A reference to an immutable CFDate object.

typedef const struct __CFDate *CFDateRef;
Availability
Available in Mac OS X v10.0 and later*/
typedef const struct __CFDate *CFDateRef;



/*CFTimeInterval

Type used to represent elapsed time in seconds.

typedef double CFTimeInterval;
Availability
Available in Mac OS X v10.0 and later.*/
typedef double CFTimeInterval;

/*CFAbsoluteTime

Type used to represent a specific point in time relative to the absolute reference date of 1 Jan 2001 00:00:00 GMT.

typedef CFTimeInterval CFAbsoluteTime;
Discussion

Absolute time is measured by the number of seconds between the reference date and the specified date. Negative values indicate dates/times before the reference date. Positive values indicate dates/times after the reference date. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef CFTimeInterval CFAbsoluteTime;


/*CFDateGetTypeID

Returns the type identifier for the CFDate opaque type.

CFTypeID CFDateGetTypeID ();
Return Value

The type identifier for the CFDate opaque type. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDateGetTypeID ();

/*CFAbsoluteTimeGetCurrent

Returns the current system absolute time.

CFAbsoluteTime CFAbsoluteTimeGetCurrent ();
Return Value

The current absolute time. 
Discussion

Absolute time is measured in seconds relative to the absolute reference date of Jan 1 2001 00:00:00 GMT. A positive value represents a date after the reference date, a negative value represents a date before it. For example, the absolute time -32940326 is equivalent to December 16th, 1999 at 17:54:34. Repeated calls to this function do not guarantee monotonically increasing results. The system time may decrease due to synchronization with external time references or due to an explicit user change of the clock.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/
CFAbsoluteTime CFAbsoluteTimeGetCurrent ();

/*CFDateCreate

Creates a CFDate object given an absolute time.

CFDateRef CFDateCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime at
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
at

The absolute time to converted to a CFDate object. 
Return Value

A date object that represents the absolute time at. Ownership follows the Create Rule.
Discussion

CFDate objects must always be created using absolute time. Time intervals are not supported. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDateRef CFDateCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime at
);

#ifdef __cplusplus
}
#endif

#endif