#ifndef ICONS_H
#define ICONS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif

#ifndef CGCONTEXT_H
#include <CoreGraphics/CGContext.h>
#endif

#include <HYS/HIServices/Icons.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif


#ifdef __cplusplus
extern "C" {
#endif

/*Networking Icon Constants

Identify standard networking icons.

enum {
   kAppleTalkIcon = 'atlk',
   kAppleTalkZoneIcon = 'atzn',
   kAFPServerIcon = 'afps',
   kFTPServerIcon = 'ftps',
   kHTTPServerIcon = 'htps',
   kGenericNetworkIcon = 'gnet',
   kIPFileServerIcon = 'isrv'
};
Discussion

Icon Services defines constants for a number of standard networking icons. You can pass one of these constants in the iconType parameter of the function GetIconRef, for example.*/
enum {
   kAppleTalkIcon = 'atlk',
   kAppleTalkZoneIcon = 'atzn',
   kAFPServerIcon = 'afps',
   kFTPServerIcon = 'ftps',
   kHTTPServerIcon = 'htps',
   kGenericNetworkIcon = 'gnet',
   kIPFileServerIcon = 'isrv'
};

/*Icon Alignment Constants

Define constants that allow you to specify how to align an icon within its rectangle.

enum {
   kAlignNone = 0x00,
   kAlignVerticalCenter = 0x01,
   kAlignTop = 0x02,
   kAlignBottom = 0x03,
   kAlignHorizontalCenter = 0x04,
   kAlignAbsoluteCenter = kAlignVerticalCenter | kAlignHorizontalCenter,
   kAlignCenterTop = kAlignTop | kAlignHorizontalCenter,
   kAlignCenterBottom = kAlignBottom | kAlignHorizontalCenter,
   kAlignLeft = 0x08,
   kAlignCenterLeft = kAlignVerticalCenter | kAlignLeft,
   kAlignTopLeft = kAlignTop | kAlignLeft,
   kAlignBottomLeft = kAlignBottom | kAlignLeft,
   kAlignRight = 0x0C,
   kAlignCenterRight = kAlignVerticalCenter | kAlignRight,
   kAlignTopRight = kAlignTop | kAlignRight,
   kAlignBottomRight = kAlignBottom | kAlignRight
};
typedef SInt16 IconAlignmentType;
Constants
kAlignNone

Use this value if you do not wish to specify a particular alignment.

Available in Mac OS X v10.0 and later.
kAlignVerticalCenter

Use this value to center the icon vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTop

Use this value to top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottom

Use this value to bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignHorizontalCenter

Use this value to center the icon horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignAbsoluteCenter

Use this value to center the icon horizontally and vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterTop

Use this value to top align the icon and center it horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterBottom

Use this value to bottom align the icon and center it horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignLeft

Use this value to left align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterLeft

Use this value to left align the icon and center it vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTopLeft

Use this value to left and top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottomLeft

Use this value to left and bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignRight

Use this value to right align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterRight

Use this value to right align the icon and center it vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTopRight

Use this value to right and top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottomRight

Use this value to right and bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
Discussion

Icon Services and Utilities functions use the IconAlignmentType constants to determine how an icon is aligned within its bounding rectangle.*/
enum {
   kAlignNone = 0x00,
   kAlignVerticalCenter = 0x01,
   kAlignTop = 0x02,
   kAlignBottom = 0x03,
   kAlignHorizontalCenter = 0x04,
   kAlignAbsoluteCenter = kAlignVerticalCenter | kAlignHorizontalCenter,
   kAlignCenterTop = kAlignTop | kAlignHorizontalCenter,
   kAlignCenterBottom = kAlignBottom | kAlignHorizontalCenter,
   kAlignLeft = 0x08,
   kAlignCenterLeft = kAlignVerticalCenter | kAlignLeft,
   kAlignTopLeft = kAlignTop | kAlignLeft,
   kAlignBottomLeft = kAlignBottom | kAlignLeft,
   kAlignRight = 0x0C,
   kAlignCenterRight = kAlignVerticalCenter | kAlignRight,
   kAlignTopRight = kAlignTop | kAlignRight,
   kAlignBottomRight = kAlignBottom | kAlignRight
};
typedef SInt16 IconAlignmentType;

/*Icon Transformation Constants

Define values that Icon Services uses to report how an icon has been transformed after you call the function GetIconRefVariant.

enum {
   kTransformNone = 0x00,
   kTransformDisabled = 0x01,
   kTransformOffline = 0x02,
   kTransformOpen = 0x03,
   kTransformLabel1 = 0x0100,
   kTransformLabel2 = 0x0200,
   kTransformLabel3 = 0x0300,
   kTransformLabel4 = 0x0400,
   kTransformLabel5 = 0x0500,
   kTransformLabel6 = 0x0600,
   kTransformLabel7 = 0x0700,
   kTransformSelected = 0x4000,
   kTransformSelectedDisabled = kTransformSelected | kTransformDisabled,
   kTransformSelectedOffline = kTransformSelected | kTransformOffline,
   kTransformSelectedOpen = kTransformSelected | kTransformOpen
};
typedef SInt16 IconTransformType;
Discussion

The functions PlotIconIDPlotIconMethod, PlotIconHandle, PlotCIconHandle, PlotIconSuite, LoadIconCache and PlotSICNHandle use these constants to specify how an icon should be modified, if at all, when plotted.*/
enum {
   kTransformNone = 0x00,
   kTransformDisabled = 0x01,
   kTransformOffline = 0x02,
   kTransformOpen = 0x03,
   kTransformLabel1 = 0x0100,
   kTransformLabel2 = 0x0200,
   kTransformLabel3 = 0x0300,
   kTransformLabel4 = 0x0400,
   kTransformLabel5 = 0x0500,
   kTransformLabel6 = 0x0600,
   kTransformLabel7 = 0x0700,
   kTransformSelected = 0x4000,
   kTransformSelectedDisabled = kTransformSelected | kTransformDisabled,
   kTransformSelectedOffline = kTransformSelected | kTransformOffline,
   kTransformSelectedOpen = kTransformSelected | kTransformOpen
};
typedef SInt16 IconTransformType;

/*IconRef

Defines an icon reference.

typedef struct OpaqueIconRef * IconRef;
Discussion

An IconRef is a 32–bit values identifying cached icon data. IconRef 0 is invalid.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueIconRef * IconRef;

#ifdef __cplusplus
}
#endif

#endif