#ifndef CONTROLDEFINITIONS_H
#define CONTROLDEFINITIONS_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef APPEARANCE_H
#include <HIToolbox/Appearance.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef LISTS_H
#include <HIToolbox/Lists.h>
#endif

#ifndef MACHELP_H
#include <HIToolbox/MacHelp.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif


#include <HYS/HIToolbox/ControlDefinitions.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*User Item and User Pane Control Data Tag Constants

enum {
   kControlUserItemDrawProcTag = 'uidp',
   kControlUserPaneDrawProcTag = 'draw',
   kControlUserPaneHitTestProcTag = 'hitt',
   kControlUserPaneTrackingProcTag = 'trak',
   kControlUserPaneIdleProcTag = 'idle',
   kControlUserPaneKeyDownProcTag = 'keyd',
   kControlUserPaneActivateProcTag = 'acti',
   kControlUserPaneFocusProcTag = 'foci',
   kControlUserPaneBackgroundProcTag = 'back'
};
Constants
kControlUserItemDrawProcTag

Gets or sets an application-defined item drawing function. If an embedding hierarchy is established, a user pane drawing function should be used instead of an item drawing function.

Data type returned or set: UserItemUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneDrawProcTag

Gets or sets a user pane drawing function; see ControlUserPaneBackgroundProcPtr. Indicates that the Control Manager needs to draw a control.

Data type returned or set: ControlUserPaneDrawingUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneHitTestProcTag

Gets or sets a user pane hit-testing function. Indicates that the Control Manager needs to determine if a control part was hit; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneHitTestUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneTrackingProcTag

Gets or sets a user pane tracking function, which will be called when a control definition function returns the kControlHandlesTracking feature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane handles its own tracking; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneTrackingUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneIdleProcTag

Gets or sets a user pane idle function, which will be called when a control definition function returns the kControlWantsIdle feature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane performs idle processing; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneIdleUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneKeyDownProcTag

Gets or sets a user pane key down function, which will be called when a control definition function returns the kControlSupportsFocus feature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane performs keyboard event processing; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneKeyDownUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneActivateProcTag

Gets or sets a user pane activate function, which will be called when a control definition function returns the kControlWantsActivatefeature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane wants to be informed of activate and deactivate events; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneActivateUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneFocusProcTag

Gets or sets a user pane keyboard focus function, which will be called when a control definition function returns the kControlSupportsFocus feature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane handles keyboard focus; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneFocusUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneBackgroundProcTag

Gets or sets a user pane background function, which will be called when a control definition function returns the kControlHasSpecialBackgroundand kControlSupportsEmbeddingfeature bits in response to a kControlMsgGetFeatures message. Indicates that a user pane can set its background color or pattern; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneBackgroundUPP

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlUserItemDrawProcTag = 'uidp',
   kControlUserPaneDrawProcTag = 'draw',
   kControlUserPaneHitTestProcTag = 'hitt',
   kControlUserPaneTrackingProcTag = 'trak',
   kControlUserPaneIdleProcTag = 'idle',
   kControlUserPaneKeyDownProcTag = 'keyd',
   kControlUserPaneActivateProcTag = 'acti',
   kControlUserPaneFocusProcTag = 'foci',
   kControlUserPaneBackgroundProcTag = 'back'
};

/*Pop-up Button Control Data Tag Constants

enum {
   kControlPopupButtonMenuHandleTag = 'mhan',
   kControlPopupButtonMenuRefTag = 'mhan',
   kControlPopupButtonMenuIDTag = 'mnid'
};
Constants
kControlPopupButtonMenuHandleTag

Gets or sets the menu handle for a popup button. Available with Appearance Manager 1.0.1 and later.

Data type returned or set: MenuHandle

Available in Mac OS X v10.0 and later.
kControlPopupButtonMenuRefTag

Gets or sets the menu reference assigned to a popup button. If setting the menu reference, the popup button does not own the menu, so you must dispose of it yourself. To allow the popup button to take ownership of the menu, use the kControlPopupButtonOwnedMenuRefTag tag (defined in “Mac OS 8.5 Pop-up Button Control Data Tag Constants”) instead. 

Data type returned or set: MenuRef

Available in Mac OS X v10.0 and later.
kControlPopupButtonMenuIDTag

Gets or sets the menu ID for a popup button. Available with Appearance Manager 1.0.1 and later.

Data type returned or set: SInt16

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/

enum {
   kControlPopupButtonMenuHandleTag = 'mhan',
   kControlPopupButtonMenuRefTag = 'mhan',
   kControlPopupButtonMenuIDTag = 'mnid'
};


/*Clock Control Data Tag Constants

enum {
   kControlClockLongDateTag = 'date',
   kControlClockFontStyleTag = kControlFontStyleTag,
   kControlClockAnimatingTag = 'anim'
};
Constants
kControlClockLongDateTag

Gets or sets the clock control’s time or date. 

Data type returned or set: LongDateRec structure. Note that depending on the variant of clock control specified, some of the fields in the longDateRec structure may not be valid. For example, if the control variant displays only a non-live user-adjustable date, the hour and minute fields are not valid and will contain garbage. 

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlClockLongDateTag = 'date',
   kControlClockFontStyleTag = kControlFontStyleTag,
   kControlClockAnimatingTag = 'anim'
};

/*Icon Control Data Tag Constants

enum {
   kControlClockLongDateTag = 'date',
   kControlClockFontStyleTag = kControlFontStyleTag,
   kControlClockAnimatingTag = 'anim'
};enum {
   kControlIconTransformTag = 'trfm',
   kControlIconAlignmentTag = 'algn'
};
Constants
kControlIconTransformTag

Gets or sets a transform that is added to the standard transform of an icon see “Icon Utilities.”

Data type returned or set: IconTransformType

Available in Mac OS X v10.0 and later.
kControlIconAlignmentTag

Gets or sets an icon’s position (centered, left, right).

Data type returned or set: IconAlignmentType

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message.

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlIconTransformTag = 'trfm',
   kControlIconAlignmentTag = 'algn'
};


/*List Box Control Data Tag Constants

enum {
   kControlListBoxListHandleTag = 'lhan',
   kControlListBoxKeyFilterTag = kControlKeyFilterTag,
   kControlListBoxFontStyleTag = kControlFontStyleTag
};
enum {
   kControlListBoxDoubleClickTag = 'dblc',
   kControlListBoxLDEFTag = 'ldef'
};
Constants
kControlListBoxListHandleTag

Gets a handle to a list box.

Data type returned: ListHandle

Available in Mac OS X v10.0 and later.
kControlListBoxDoubleClickTag

Checks to see whether the most recent click in a list box was a double click. Available with Appearance 1.0.1 and later.

Data type returned: Boolean; if true, the last click was a double click; if false, not.

Available in Mac OS X v10.0 and later.
kControlListBoxLDEFTag

Sets the 'LDEF' resource to be used to draw a list box’s contents this is useful for creating a list box without an 'ldes' resource. Available with Appearance 1.0.1 and later.

Data type set: SInt16

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlListBoxListHandleTag = 'lhan',
   kControlListBoxKeyFilterTag = kControlKeyFilterTag,
   kControlListBoxFontStyleTag = kControlFontStyleTag
};
enum {
   kControlListBoxDoubleClickTag = 'dblc',
   kControlListBoxLDEFTag = 'ldef'
};

/*Push Button Control Data Tag Constants

enum {
   kControlPushButtonDefaultTag = 'dflt',
   kControlPushButtonCancelTag = 'cncl'
};
Constants
kControlPushButtonDefaultTag

Tells Appearance-compliant button whether to draw a default ring, or returns whether the Appearance Manager draws a default ring for the button.

Data type returned or set: Boolean

Available in Mac OS X v10.0 and later.
kControlPushButtonCancelTag

Gets or sets whether a given push button in a dialog or alert should be drawn with the theme-specific adornments for a Cancel button.

Data type retrieved or set: Boolean; default is false.

Available in Mac OS X v10.0 and later.
Discussion

The Mac OS 8.5 Control Manager defines this new control data tag constant. This constant is passed in the inTagName parameters of the functions SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass this constant in the inTagName parameter of the function GetControlDataSize if you wish to determine the size of variable-length control data. This constant can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message.

The data that your application gets or sets can be of various types. The description here shows the data type for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/
enum {
   kControlPushButtonDefaultTag = 'dflt',
   kControlPushButtonCancelTag = 'cncl'
};


/*Progress Bar Control Data Tag Constants

enum {
   kControlProgressBarIndeterminateTag = 'inde',
   kControlProgressBarAnimatingTag = 'anim'
};
Constants
kControlProgressBarIndeterminateTag

Gets or sets whether a progress indicator is determinate or indeterminate.

Data type returned or set: Boolean; if true, switches to an indeterminate progress indicator; if false, switches to an determinate progress indicator.

Available in Mac OS X v10.0 and later.
Discussion

You can use this control data tag constant to set or obtain data that is associated with a control. This constant is passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass this constant in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. This constant can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message.

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the description of this control data tag constant lists the data type for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

This control data tag constant is available with Appearance Manager 1.0 and later.*/
enum {
   kControlProgressBarIndeterminateTag = 'inde',
   kControlProgressBarAnimatingTag = 'anim'
};


/*ControlEditTextSelectionRec

struct ControlEditTextSelectionRec {
   SInt16 selStart;
   SInt16 selEnd;
};
typedef struct ControlEditTextSelectionRec ControlEditTextSelectionRec;
typedef ControlEditTextSelectionRec * ControlEditTextSelectionPtr;
Fields
selStart

The start of the editable text selection. 
selEnd

The end of the editable text selection.
Discussion

You can use the ControlEditTextSelectionRec type to specify a selection range in an editable text control. You pass a pointer to the editable text selection structure to GetControlData and SetControlData to access and set the current selection range in an editable text control. 
Version Notes

The ControlEditTextSelectionRec type is available with Appearance Manager 1.0 and later.
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlEditTextSelectionRec {
   SInt16 selStart;
   SInt16 selEnd;
};
typedef struct ControlEditTextSelectionRec ControlEditTextSelectionRec;
typedef ControlEditTextSelectionRec * ControlEditTextSelectionPtr;


/*Editable Text Control Data Tag Constants

enum {
   kControlEditTextStyleTag = kControlFontStyleTag,
   kControlEditTextTextTag = 'text',
   kControlEditTextTEHandleTag = 'than',
   kControlEditTextKeyFilterTag = kControlKeyFilterTag,
   kControlEditTextSelectionTag = 'sele',
   kControlEditTextPasswordTag = 'pass'
};
enum {
   kControlEditTextKeyScriptBehaviorTag = 'kscr',
   kControlEditTextLockedTag = 'lock',
   kControlEditTextFixedTextTag = 'ftxt',
   kControlEditTextValidationProcTag = 'vali',
   kControlEditTextInlinePreUpdateProcTag = 'prup',
   kControlEditTextInlinePostUpdateProcTag = 'poup'
};
enum {
   kControlEditTextCFStringTag = 'cfst',
   kControlEditTextPasswordCFStringTag = 'pwcf'
};
Constants
kControlEditTextTextTag

Gets or sets text in an editable text control.

Data type returned or set: character buffer 

Available in Mac OS X v10.0 and later.
kControlEditTextTEHandleTag

Gets a handle to a text edit structure.

Data type returned: TEHandle

Available in Mac OS X v10.0 and later.
kControlEditTextSelectionTag

Gets or sets the selection in an editable text control.

Data type returned or set: ControlEditTextSelectionRec structure

Available in Mac OS X v10.0 and later.
kControlEditTextKeyScriptBehaviorTag

Gets or sets the kind of behavior to be used in an editable text control with respect to changing and locking the keyboard menu as the field is focused.

Data type retrieved or set: ControlKeyScriptBehavior. The default for password fields is kControlKeyScriptBehaviorPrefersRoman. The default for non-password fields is kControlKeyScriptBehaviorAllowAnyScript. See ControlEditTextValidationProcPtr for descriptions of possible values.

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextLockedTag

Gets or sets whether the text in an editable text control is currently editable.

Data type retrieved or set: Boolean; if true, the text is locked and cannot be edited; if false, the text is editable.

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextFixedTextTag

Gets or sets inline input text in an editable text control, after confirming any text in the active input area with the Text Services Manager function FixTSMDocument.

Data type retrieved or set: character buffer

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextValidationProcTag

Gets or sets a universal procedure pointer to a callback function such as that described in ControlEditTextValidationProcPtr, which can be used to validate editable text after an operation that changes the text, such as inline text entry, a cut, or paste.

Data type retrieved or set: ControlEditTextValidationUPP

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextInlinePreUpdateProcTag

Gets or sets a universal procedure pointer to a Text Services Manager pre-update callback function.

Data type retrieved or set: TSMTEPreUpdateUPP

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextInlinePostUpdateProcTag

Gets or sets a universal procedure pointer to a Text Services Manager post-update callback function.

Data type retrieved or set: TSMTEPostUpdateUPP

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextCFStringTag

Retrieves the contents of the edit text field as a CFString. 

Data type retrieved: CFStringRef. You must release the string when you no longer need it. 

Available in CarbonLib 1.5 and Mac OS X v10.0 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextPasswordCFStringTag

Extract the content of the edit text field if it is a password field. 

Data type retrieved: CFStringRef. You must release the string when you no longer need it. 

Available in CarbonLib 1.5 and Mac OS X v10.0 and later. 

Available in Mac OS X v10.1 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data (e.g., text in an editable text control). These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlEditTextStyleTag = kControlFontStyleTag,
   kControlEditTextTextTag = 'text',
   kControlEditTextTEHandleTag = 'than',
   kControlEditTextKeyFilterTag = kControlKeyFilterTag,
   kControlEditTextSelectionTag = 'sele',
   kControlEditTextPasswordTag = 'pass'
};
enum {
   kControlEditTextKeyScriptBehaviorTag = 'kscr',
   kControlEditTextLockedTag = 'lock',
   kControlEditTextFixedTextTag = 'ftxt',
   kControlEditTextValidationProcTag = 'vali',
   kControlEditTextInlinePreUpdateProcTag = 'prup',
   kControlEditTextInlinePostUpdateProcTag = 'poup'
};
enum {
   kControlEditTextCFStringTag = 'cfst',
   kControlEditTextPasswordCFStringTag = 'pwcf'
};



/*Callback Data Structure Version

Specifies the version of the latest standard callback data structure.

enum {
   kDataBrowserLatestCallbacks = 0
};
Constants
kDataBrowserLatestCallbacks

A convenience constant used in the DataBrowserCallbacks data structure to specify the version of the structure.

Available in Mac OS X v10.0 and later.*/
enum {
   kDataBrowserLatestCallbacks = 0
};


/*Properties

Specify attributes for items, containers, and columns.

enum {
   kDataBrowserItemNoProperty = 0L,
   kDataBrowserItemIsActiveProperty = 1L,
   kDataBrowserItemIsSelectableProperty = 2L,
   kDataBrowserItemIsEditableProperty = 3L,
   kDataBrowserItemIsContainerProperty = 4L,
   kDataBrowserContainerIsOpenableProperty = 5L,
   kDataBrowserContainerIsClosableProperty = 6L,
   kDataBrowserContainerIsSortableProperty = 7L,
   kDataBrowserItemSelfIdentityProperty = 8L,
   kDataBrowserContainerAliasIDProperty = 9L,
   kDataBrowserColumnViewPreviewProperty = 10L,
   kDataBrowserItemParentContainerProperty = 11L
};
Constants
kDataBrowserItemNoProperty

No property; no associated data.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsActiveProperty

The active state of the item. The associated data is of type Boolean. The default value true indicates the item is active.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsSelectableProperty

The selection capability of the item. The associated data is of type Boolean. The default value true indicates the item can be selected.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsEditableProperty

The editing capability of the item. The associated data is of type Boolean. The default value false indicates the item cannot be edited.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsContainerProperty

The container attribute for an item. The associated data is of type Boolean. The default value false indicates the item cannot contain other items.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerIsOpenableProperty

The opening capability of a container item. The associated data is of type Boolean. The default value true indicates the container can be opened.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerIsClosableProperty

The closing capability of a container item. The associated data is of type Boolean. The default value true indicates the container can be closed.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerIsSortableProperty

The sorting capability of container item. The associated data is of type Boolean. The default value true indicates the items in the container can be sorted.

Available in Mac OS X v10.0 and later.
kDataBrowserItemSelfIdentityProperty

This property is used only in column view for the item-data and item-compare callbacks. You should not use this property for anything else. It is passed to your item-data callback when the data browser needs to know the data to draw to represent the item. It is your responsibility to provide the data to display for that item in whatever format would be appropriate for the column view display type, which is kDataBrowserIconAndTextType. 

Available in Mac OS X v10.0 and later.
kDataBrowserContainerAliasIDProperty

An alias or symbolic link from an item to a container item. The associated data is of type DataBrowserItemID. This property is sent to your item-data callback to provide your application with a chance to follow an alias that the item might represent. If the incoming item is an alias to another item, you can call the function SetDataBrowserItemDataItemID to inform the data browser which other item the incoming item points to.

This property is sent only from column view. Your support for it is optional. Your response allows the data browser to be a bit more memory efficient with its internal storage. If a given item is an alias to an item whose contents are already displayed in one column of the column view, the contents can be shared between those two columns.

Available in Mac OS X v10.0 and later.
kDataBrowserColumnViewPreviewProperty

The column displays a preview. There is no associated data. Available only in column view. This property is sent to your draw-item callback to indicate the need for you to draw a preview of the given item. It can be sent to other callbacks to provide an opportunity for your application to draw or track in the preview column. 

You can also pass this in the propertyID parameter of the function RevealDataBrowserItem (along with the appropriate item ID of the item whose preview is displayed) to make sure the preview column is visible to the user.

Available in Mac OS X v10.0 and later.
kDataBrowserItemParentContainerProperty

Designates the parent of the specified item. The associated data is of type DataBrowserItemID. This is sent to your item-data callback when the data browser needs to know the parent container item for a given item.

In column view, this allows the function SetDataBrowserTarget to process the data properly. The target is the leaf node item whose contents you want to display, which is the rightmost column in column view. However, unlike SetDataBrowserColumnViewPath, the function SetDataBrowserTarget doesn’t offer a way for you to communicate the item IDs of the rest of the column containers, so SetDataBrowserTarget asks for them explicitly by requesting the item’s parent, then the parent of the item’s parent, and so on. (Your item-data callback might be called with the parent container property at times other than an explicit call to SetDataBrowserTarget, so your item-data callback should support this property.)

In list view, this property allows you to pass a non-container to SetDataBrowserTarget. In this case, the data browser requests the parent of the target so it knows which container to display the contents of in the list view. (Again, your item-data callback might be called with the parent container property at times other than an explicit call to SetDataBrowserTarget, so your item-data callback should be sure to support this property.)

Available in Mac OS X v10.0 and later.
Discussion

You can use these constants along with the appropriate value to manage the attributes of items in a data browser. Typically your item-data callback responds to inquires about these properties by calling the appropriate accessor function from within the callback. See DataBrowserItemDataProcPtr for more information on the item-data callback. “Getting and Setting Item Data” describes the accessor functions.*/
enum {
   kDataBrowserItemNoProperty = 0L,
   kDataBrowserItemIsActiveProperty = 1L,
   kDataBrowserItemIsSelectableProperty = 2L,
   kDataBrowserItemIsEditableProperty = 3L,
   kDataBrowserItemIsContainerProperty = 4L,
   kDataBrowserContainerIsOpenableProperty = 5L,
   kDataBrowserContainerIsClosableProperty = 6L,
   kDataBrowserContainerIsSortableProperty = 7L,
   kDataBrowserItemSelfIdentityProperty = 8L,
   kDataBrowserContainerAliasIDProperty = 9L,
   kDataBrowserColumnViewPreviewProperty = 10L,
   kDataBrowserItemParentContainerProperty = 11L
};


/*No Item Constant

Specifies that there is no item to provide or obtain.

enum {
   kDataBrowserNoItem = 0L
};
Constants
kDataBrowserNoItem

A convenience constant used when there is no item to provide or obtain. This value is of type DataBrowserItemID.

Available in Mac OS X v10.0 and later.*/
enum {
   kDataBrowserNoItem = 0L
};

/*DataBrowserItemDataRef

Defines a data type for a pointer that specifies an item.

typedef void *DataBrowserItemDataRef;
Discussion

Functions listed in “Getting and Setting Item Data” are called from within a data browser item-data callback routine (DataBrowserItemDataProcPtr). Each of these functions use a DataBrowserItemDataRef data type to specify the item to get or set data for.
Availability
Available in Mac OS X v10.0 and later.*/
typedef void *DataBrowserItemDataRef;

/*DataBrowserPropertyID

Defines a data type for a value that identifies a column independent of its position in a data browser.

typedef UInt32 DataBrowserPropertyID;
Discussion

Typically, this is a four-character sequence that you assign to represent a column in list view. For example, a column that displays song titles could be assigned a property ID of SONG and you’d assign it to a constant in your application using code similar to the following:

kSongColumn = SONG;

Then, each time call a function that requires a parameter of type DataBrowserPropertyID, supply the appropriate application-defined constant.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 DataBrowserPropertyID;

/*DataBrowserItemID

Defines a data type for a value that identifies an item independent of its position in a data browser.

typedef UInt32 DataBrowserItemID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 DataBrowserItemID;

/*DataBrowserItemDataProcPtr

Defines a pointer to an item-data callback function that gets and sets properties for individual items in a data browser.

typedef OSStatus (*DataBrowserItemDataProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemDataRef itemData,
   Boolean setValue
);

You would declare an item-data callback function named MyDataBrowserItemDataCallback like this:

OSStatus MyDataBrowserItemDataCallback (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemDataRef itemData,
   Boolean setValue
);
Parameters
browser

The data browser.
item

The item ID of the item whose data is set or obtained.
property

A property ID. This value can be any of the following: 
A four-character sequence that you assign to represent a column in list view.
Any of the API-defined properties, such as kDataBrowserItemSelfIdentityProperty for a column in column view or kDataBrowserItemIsContainerProperty for an item in list or column view that has children. See “Properties” for a complete list and more information on the API-defined properties. 
itemData

The data buffer that either contains the data to set or receives the data to obtain. 
setValue

A value that indicates whether data is to be obtained or set. This value is false if your application needs to set the value of the item by calling one of the set functions described in the section “Getting and Setting Item Data”. This value is true if the value of the item has changed. In this case, you should call the appropriate get function, passing the item data reference provided to you in the itemData parameter. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

The item-data callback communicates data between the data browser and your application. When the data browser needs to display a value for an item, it invokes your callback to request the data. If the user changes the value, the data browser invokes your callback with a new copy of the data that you can use to replace your application’s internal copy. Your application must supply an item-data callback; otherwise, your data browser will not contain any data.

Your callback determines the kind of data is associated with an item and whether data needs to be obtained or set. Then, your callback takes the appropriate action by calling one of the functions listed in “Getting and Setting Item Data”. 

To provide a pointer to your item-data callback, you create a universal procedure pointer (UPP) of type DataBrowserItemDataUPP, using the function NewDataBrowserItemDataUPP. You can do so with code similar to the following: DataBrowserItemDataUPP MyDataBrowserItemDataUPP;
MyDataBrowserItemDataUPP = NewDataBrowserItemDataUPP
                            (&MyDataBrowserItemDataCallback);


You can then assign MyDataBrowserItemDataUPP to the itemDataCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserItemDataUPP function.*/
typedef OSStatus (*DataBrowserItemDataProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemDataRef itemData,
   Boolean setValue
);


/*DataBrowserCallbacks

Contains universal procedure pointers (UPPs) to callback functions used to obtain information from your application or notify your application of changes to the data browser.

struct DataBrowserCallbacks {
   UInt32 version
   union {
      struct {
         DataBrowserItemDataUPP itemDataCallback;
         DataBrowserItemCompareUPP itemCompareCallback;
         DataBrowserItemNotificationUPP itemNotificationCallback;
         DataBrowserAddDragItemUPP addDragItemCallback;
         DataBrowserAcceptDragUPP acceptDragCallback;
         DataBrowserReceiveDragUPP receiveDragCallback;
         DataBrowserPostProcessDragUPP postProcessDragCallback;
         DataBrowserItemHelpContentUPP itemHelpContentCallback;
         DataBrowserGetContextualMenuUPP getContextualMenuCallback;
         DataBrowserSelectContextualMenuUPP selectContextualMenuCallback;
      } v1;
   } u;
};
typedef struct DataBrowserCallbacks DataBrowserCallbacks;
Fields
version

The version of the custom callbacks structure. Set this field to the constant kDataBrowserLatestCallbacks.
u.v1.itemDataCallback

A universal procedure pointer to an item-data callback.
u.v1.itemCompareCallback

A universal procedure pointer to an item-compare callback.
u.v1.itemNotificationCallback

A universal procedure pointer to an item-notification callback or item-notification-with-data callback.
u.v1.addDragItemCallback

A universal procedure pointer to an add-drag-item callback.
u.v1.acceptDragCallback

A universal procedure pointer to an accept-drag callback.
u.v1.receiveDragCallback

A universal procedure pointer to a receive-drag callback.
u.v1.postProcessDragCallback

A universal procedure pointer to a postprocess-drag callback.
u.v1.itemHelpContentCallback

A universal procedure pointer to an item-help-content callback.
u.v1.getContextualMenuCallback

A universal procedure pointer to a get-contextual-menu callback.
u.v1.selectContextualMenuCallback

A universal procedure pointer to a select-contextual-menu callback.
Discussion

Your application does not need to fill out the entire data structure. It must provide a UPP to an item-data callback. You provide UPPs only for the other tasks your application wants to handle. For more information on installing callbacks, see the functions InitDataBrowserCallbacks and SetDataBrowserCallbacks. 
Availability
Available in Mac OS X v10.0 and later.*/

struct DataBrowserCallbacks {
   UInt32 version;
   union {
      struct {
         DataBrowserItemDataUPP itemDataCallback;
         DataBrowserItemCompareUPP itemCompareCallback;
         DataBrowserItemNotificationUPP itemNotificationCallback;
         DataBrowserAddDragItemUPP addDragItemCallback;
         DataBrowserAcceptDragUPP acceptDragCallback;
         DataBrowserReceiveDragUPP receiveDragCallback;
         DataBrowserPostProcessDragUPP postProcessDragCallback;
         DataBrowserItemHelpContentUPP itemHelpContentCallback;
         DataBrowserGetContextualMenuUPP getContextualMenuCallback;
         DataBrowserSelectContextualMenuUPP selectContextualMenuCallback;
      } v1;
   } u;
};
typedef struct DataBrowserCallbacks DataBrowserCallbacks;


/*Control Part Code Constants

enum {
   kControlLabelPart = 1,
   kControlMenuPart = 2,
   kControlTrianglePart = 4,
   kControlEditTextPart = 5,
   kControlPicturePart = 6,
   kControlIconPart = 7,
   kControlClockPart = 8,
   kControlListBoxPart = 24,
   kControlListBoxDoubleClickPart = 25,
   kControlImageWellPart = 26,
   kControlRadioGroupPart = 27,
   kControlButtonPart = 10,
   kControlCheckBoxPart = 11,
   kControlRadioButtonPart = 11,
   kControlUpButtonPart = 20,
   kControlDownButtonPart = 21,
   kControlPageUpPart = 22,
   kControlPageDownPart = 23,
   kControlClockHourDayPart = 9,
   kControlClockMinuteMonthPart = 10,
   kControlClockSecondYearPart = 11,
   kControlClockAMPMPart = 12,
   kControlDataBrowserPart = 24,
   kControlDataBrowserDraggedPart = 25
};
Constants
kControlLabelPart

Identifies the label of a pop-up menu control.

Available in Mac OS X v10.0 and later.
kControlMenuPart

Identifies the menu of a pop-up menu control. For bevel buttons with a menu attached, this part code specifies a menu item of the bevel button.

Available in Mac OS X v10.0 and later.
kControlTrianglePart

Identifies a disclosure triangle control.

Available in Mac OS X v10.0 and later.
kControlEditTextPart

Identifies an editable text control.

Available with Appearance Manager 1.0 and later.
kControlPicturePart

Identifies a picture control.

Available with Appearance Manager 1.0 and later.
kControlIconPart

Identifies an icon control.

Available with Appearance Manager 1.0 and later.
kControlClockPart

Identifies a clock control.

Available with Appearance Manager 1.0 and later.
kControlListBoxPart

Identifies a list box control.

Available with Appearance Manager 1.0 and later.
kControlListBoxDoubleClickPart

Identifies a double-click in a list box control.

Available with Appearance Manager 1.0 and later.
kControlImageWellPart

Identifies an image well control.

Available with Appearance Manager 1.0 and later.
kControlRadioGroupPart

Identifies a radio group control.

Available with Appearance Manager 1.0.2 and later.
kControlButtonPart

Identifies either a push button or bevel button control. For bevel buttons with a menu attached, this part code specifies the button but not the attached menu.

Available in Mac OS X v10.0 and later.
kControlCheckBoxPart

Identifies a checkbox control.

Available in Mac OS X v10.0 and later.
kControlRadioButtonPart

Identifies a radio button control.

Available in Mac OS X v10.0 and later.
kControlUpButtonPart

Identifies the up button of a scroll bar control (the arrow at the top or the left).

Available in Mac OS X v10.0 and later.
kControlDownButtonPart

Identifies the down button of a scroll bar control (the arrow at the right or the bottom).

Available in Mac OS X v10.0 and later.
kControlPageUpPart

Identifies the page-up part of a scroll bar control.

Available in Mac OS X v10.0 and later.
kControlPageDownPart

Identifies the page-down part of a scroll bar control.

Available in Mac OS X v10.0 and later.
kControlClockHourDayPart

Identifies the part of a clock control that contains the hour or the day. The Mac OS 8.5 Control Manager defines this new control part code constant. 

Available in Mac OS X v10.0 and later.
kControlClockMinuteMonthPart

Identifies the part of a clock control that contains the minute or the month. The Mac OS 8.5 Control Manager defines this new control part code constant. 

Available in Mac OS X v10.0 and later.
kControlClockSecondYearPart

Identifies the part of a clock control that contains the second or the year. The Mac OS 8.5 Control Manager defines this new control part code constant. 

Available in Mac OS X v10.0 and later.
kControlClockAMPMPart

Identifies the part of a clock control that contains the AM/PM information. The Mac OS 8.5 Control Manager defines this new control part code constant. 

Available in Mac OS X v10.0 and later.
Discussion

Constants of type ControlPartCode identify specific parts of controls.

Part codes are meaningful only within the scope of a single control definition function. For example, the standard tab control uses part codes 1...N, where N is the number of tabs, even though those numbers do collide with part codes defined for use with other control definition functions. Therefore, when you wish to specify part codes for the tab control for use with the function SetControlData, for example, you should use a part code corresponding to a 1-based index of the tab whose data you wish to set. In other words, the first tab is part code 1, the second tab is part code 2, and so on.*/
enum {
   kControlLabelPart = 1,
   kControlMenuPart = 2,
   kControlTrianglePart = 4,
   kControlEditTextPart = 5,
   kControlPicturePart = 6,
   kControlIconPart = 7,
   kControlClockPart = 8,
   kControlListBoxPart = 24,
   kControlListBoxDoubleClickPart = 25,
   kControlImageWellPart = 26,
   kControlRadioGroupPart = 27,
   kControlButtonPart = 10,
   kControlCheckBoxPart = 11,
   kControlRadioButtonPart = 11,
   kControlUpButtonPart = 20,
   kControlDownButtonPart = 21,
   kControlPageUpPart = 22,
   kControlPageDownPart = 23,
   kControlClockHourDayPart = 9,
   kControlClockMinuteMonthPart = 10,
   kControlClockSecondYearPart = 11,
   kControlClockAMPMPart = 12,
   kControlDataBrowserPart = 24,
   kControlDataBrowserDraggedPart = 25
};


/*Little Arrows Control Tag Constant

enum {
   kControlLittleArrowsIncrementValueTag = 'incr'
};
Constants
kControlLittleArrowsIncrementValueTag

Gets or sets the increment value of the control. Currently, the little arrows control does not use the increment value because the control does not change the value itself. You must use an action proc to change the value. Available in Mac OS X v10.3 and later.

Data type retrieved: SInt32

Available in Mac OS X v10.3 and later.*/
enum {
   kControlLittleArrowsIncrementValueTag = 'incr'
};

/*Tab Control Info Tag Constant

enum {
   kControlTabInfoTag = 'tabi'
};
Constants
kControlTabInfoTag

Gets or sets information for a tab in a tab control; see ControlTabInfoRec.

Data type returned or set: ControlTabInfoRec.

Available in Mac OS X v10.0 and later.
Discussion

You can use this control data tag constant to set or obtain data that is associated with a control. This constant is passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass this constant in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. This constant can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the description of this control data tag constant lists the data type for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

This control data tag constant is available with Appearance Manager 1.0.1 and later.*/
enum {
   kControlTabInfoTag = 'tabi'
};

/*Control Tab Info Version Constants

enum {
   kControlTabInfoVersionZero = 0,
   kControlTabInfoVersionOne = 1
};*/
enum {
   kControlTabInfoVersionZero = 0,
   kControlTabInfoVersionOne = 1
};

/*ControlTabInfoRecV1

struct ControlTabInfoRecV1 {
   SInt16 version;
   SInt16 iconSuiteID;
   CFStringRef name;
};
typedef struct ControlTabInfoRecV1 ControlTabInfoRecV1;
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlTabInfoRecV1 {
   SInt16 version;
   SInt16 iconSuiteID;
   CFStringRef name;
};
typedef struct ControlTabInfoRecV1 ControlTabInfoRecV1;

/*ControlTabEntry

struct ControlTabEntry {
   ControlButtonContentInfo * icon;
   CFStringRef name;
   Boolean enabled;
};
typedef struct ControlTabEntry ControlTabEntry;
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlTabEntry {
   ControlButtonContentInfo * icon;
   CFStringRef name;
   Boolean enabled;
};
typedef struct ControlTabEntry ControlTabEntry;

/*Control Tab Direction Constants

typedef UInt16 ControlTabDirection;
enum {
   kControlTabDirectionNorth = 0,
   kControlTabDirectionSouth = 1,
   kControlTabDirectionEast = 2,
   kControlTabDirectionWest = 3
};*/
typedef UInt16 ControlTabDirection;
enum {
   kControlTabDirectionNorth = 0,
   kControlTabDirectionSouth = 1,
   kControlTabDirectionEast = 2,
   kControlTabDirectionWest = 3
};

/*Control Tab Size Constants

typedef UInt16 ControlTabSize;
enum {
   kControlTabSizeLarge = kControlSizeNormal,
   kControlTabSizeSmall = kControlSizeSmall
};*/
typedef UInt16 ControlTabSize;
enum {
   kControlTabSizeLarge = kControlSizeNormal,
   kControlTabSizeSmall = kControlSizeSmall
};

/*Static Text Control Data Tag Constants

enum {
   kControlStaticTextStyleTag = kControlFontStyleTag,
   kControlStaticTextTextTag = 'text',
   kControlStaticTextTextHeightTag = 'thei',
   kControlStaticTextTruncTag = 'trun',
   kControlStaticTextCFStringTag = 'cfst',
   kControlStaticTextIsMultilineTag = 'stim'
};
Constants
kControlStaticTextTextTag

Gets or sets text in a static text control. 

Data type returned or set: character buffer.

Available with Appearance Manager 1.0 and later.
kControlStaticTextTextHeightTag

Gets the height of text in a static text control. Available with Appearance Manager 1.0 and later.

Data type returned or set:SInt16

Available in Mac OS X v10.0 and later.
kControlStaticTextTruncTag

Gets or sets the control’s text truncation style. Truncation will not occur unless kControlStaticTextIsMultilineTag is set to false. 

Data type returned or set: TruncCode. The value truncEnd indicates that characters are truncated off the end of the string; the value truncMiddle indicates that characters are truncated from the middle of the string. Default is a value of -1, which indicates that no truncation occurs and the text is wrapped instead.

Available with Appearance Manager 1.1 (Mac OS 8.5) and later.

Available in Mac OS X v10.0 and later.
kControlStaticTextCFStringTag

Gets or sets the control’s current text. When setting the text, the control retains the string, so you may release the string after calling SetControlData. If the string you set is mutable, the control will make a copy of the string, so any changes to the string after calling SetControlData will not affect the control. When retrieving the text, the control retains the string before returning it to you, so you must release the string after you are done with it. 

Data type returned or set: CFStringRef

Available in CarbonLib 1.5 and later, and Mac OS X v10.0 and later.

Available in Mac OS X v10.0 and later.
kControlStaticTextIsMultilineTag

Gets or sets a flag specifying whether the control draws its text in multiple lines if the text is too wide for the control bounds. If false, the control always draws the text in a single line. 

Data type returned or set: Boolean

Available in Mac OS X v10.1 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/
enum {
   kControlStaticTextStyleTag = 'kControlFontStyleTag',
   kControlStaticTextTextTag = 'text',
   kControlStaticTextTextHeightTag = 'thei',
   kControlStaticTextTruncTag = 'trun',
   kControlStaticTextCFStringTag = 'cfst',
   kControlStaticTextIsMultilineTag = 'stim'
};

/*CreateTabsControl

Creates a tabs control.

OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
size

The control tab size. See Control Tab Size Constants for possible values.
direction

The control tab direction. See Control Tab Direction Constants for possible values.
numTabs

The initial number of tabs.
tabArray

Information about each tab. There must be the same number of entries as specified by the numTabs parameter.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

If you want to customize the accessibility information provided for individual tabs of a tabs control, such as by handling various kEventClassAccessibility Carbon Events and by calling HIObjectSetAuxiliaryAccessibilityAttribute, you need to know how to build or interpret AXUIElement reference that represent individual tabs. The AXUIElement representing an individual tab must be constructed using the tab control’s ControlRef and the UInt64 identifier of the one-based index of the tab to which the element refers. A UInt64 identifier of 0 represents the tabs control as a whole. You cannot interpret or create tab control elements whose identifiers are greater than the count of tabs in the tabs control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);

/*CreateUserPaneControl

Creates a user pane control.

OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
features

The user pane features with which the user pane is to be created. For possible constants, see “Control Features Constants”. 
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

User panes have two primary purposes: to allow easy implementation of a custom control by the developer, and to provide a generic container for embedding other controls.

In Carbon, with the advent of Carbon-event-based controls, you may find it easier to write a new control from scratch than to customize a user pane control. The set of callbacks provided by the user pane will not be extended to support new Control Manager features; instead, you should just write a real control.User panes do not, by default, support embedding. If you try to embed a control into a user pane, you will get the errControlIsNotEmbedder. You can make a user pane support embedding by passing the kControlSupportsEmbedding flag in the features parameter when you create the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);

/*CreateStaticTextControl

Creates a new static text control.

OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);

/*CreatePushButtonControl

Creates a push button control.

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);

/*CreateLittleArrowsControl

Creates a little arrows control.

OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value the control can have.
maximum

The maximum value the control can have.
increment

The amount to increment each time an arrow is clicked.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements the little up and down arrows seen in the Date & Time system preferences panel. To change the value of this control, you need to create a control action proc. The following sample code creates the control and sets the action proc:CreateLittleArrowsControl(&rect, minimum, maximum, increment,  value);
SetControlAction(Arrows, LittleArrowActionProc);


Here is sample code for the action proc:void LittleArrowActionProc(ControlRef cref, ControlPartCode part)  {
    SInt32 val = GetControl32BitValue(cref);
    SInt32 s = 0;
    GetControlData(MWArrows, 0, kControlLittleArrowsIncrementValueTag,  sizeof(SInt32), &s, nil;
    switch (part) {
        case kControlUpButtonPart:
            SetControl32BitValue(cref, val+s);
            break;
        case kControlDownButtonPart:
            SetControl32BitValue(cref, val-s);
            break;
        };
    };

Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl
);

/*SetDataBrowserCallbacks

Sets the callback routines to use with a data browser, replacing any previously installed callbacks.

OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks
);
Parameters
browser

A data browser.
callbacks

A pointer to a DataBrowserCallbacks structure that is filled out with universal procedure pointers (UPPs) to the callback routines your application provides. At a minimum, you need to provide a UPP to an item-data callback (DataBrowserItemDataProcPtr).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCallbacks you must first call InitDataBrowserCallbacks to initialize the data browser callback structure. Calling SetDataBrowserCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following callbacks. If you don’t supply callbacks in cases for which it’s optional, you get the default behavior provided by the data browser API.
DataBrowserItemDataProcPtr. You must provide this callback because communicates the text, icons, or other data to display in list view. It also communicates the metadata that defines how data is displayed, such as whether or not an item is a container or has a parent. If you set up your data browser to allow the user to edit, this callback informs your application when the user makes a change.
DataBrowserItemCompareProcPtr. You must provide a sorting callback if you want users to be able to sort the items in a column. If you want containers in a hierarchical list to be sorted independently, then you must provide a sorting callback that handles the hierarchical lists appropriately.
DataBrowserItemNotificationProcPtr. You must provide this (or the next) callback if you have hierarchical data in a list, or if you use column view.
DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr. You can provide this callback to allow dragging out of your data browser. 
DataBrowserAcceptDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to accept a drag item.
DataBrowserReceiveDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to receive a drag item.
DataBrowserPostProcessDragProcPtr. If you provide callbacks to allow dragging into your data browser, you can optionally provide a postprocess-drag callback to perform cleanup tasks.
DataBrowserGetContextualMenuProcPtr. You can optionally support a contextual menu. If so, you’ll need to provide the next callback too.
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr. You can optionally provide help tags.

Note that this function sets a different set of callbacks from those that are set by calling the function SetDataBrowserCustomCallbacks.

To replace a callback, you first need to get the current set of callbacks by calling the function GetDataBrowserCallbacks. Set the appropriate fields in the DataBrowserCallbacks structure to your callback. Then you call the function SetDataBrowserCallbacks. Your application can set as many callbacks as appropriate. 

The following code shows how to assign UPPs to the callbacks structure and then call the function SetDataBrowserCallbacks. The code assumes you have already called the function InitDataBrowserCallbacks to initialize the data browser callback structure.myCallbacks.u.v1.itemNotificationCallback =
        NewDataBrowserItemNotificationUPP (MyItemNotificationCallback);
 
myCallbacks.u.v1.acceptDragCallback =
        NewDataBrowserAcceptDragUPP (MyAcceptDragCallback);
myCallbacks.u.v1.receiveDragCallback =
        NewDataBrowserReceiveDragUPP (MyReceiveDragCallback);
myCallbacks.u.v1.addDragItemCallback =
        NewDataBrowserAddDragItemUPP (MyAddDragItemCallback);
myCallbacks.u.v1.itemHelpContentCallback =
        NewDataBrowserItemHelpContentUPP (MyItemHelpContentCallback);
myCallbacks.u.v1.getContextualMenuCallback =
        NewDataBrowserGetContextualMenuUPP (MyGetContextualMenuCallback);
myCallbacks.u.v1.selectContextualMenuCallback =
        NewDataBrowserSelectContextualMenuUPP (
                    MySelectContextualMenuCallback);
SetDataBrowserCallbacks (browser, &myCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks
);

/*NewDataBrowserItemDataUPP

Creates a universal procedure pointer to an item-data callback function.

DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-data callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemDataProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine
);

/*InitDataBrowserCallbacks

Initializes a data browser callback structure in preparation for adding your own callbacks to the structure.

OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCallbacks structure. Before calling the function InitDataBrowserCallbacks, set the version field of this structure to kDataBrowserLatestCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call this function, set the appropriate fields in the DataBrowserCallbacks structure to your callbacks. The DataBrowserCallbacks structure contains fields for the following:
DataBrowserItemDataProcPtr
DataBrowserItemCompareProcPtr
DataBrowserItemNotificationProcPtr or DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr
DataBrowserAcceptDragProcPtr
DataBrowserReceiveDragProcPtr
DataBrowserPostProcessDragProcPtr
DataBrowserGetContextualMenuProcPtr
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr

After you assign your callbacks to the appropriate field, call the function SetDataBrowserCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCustomCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks
);

/*IsDataBrowserItemSelected

Checks to see if a data item is selected.

Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item
);
Parameters
browser

A data browser.
item

The item ID of the item to check.
Return Value

A value of true if the item is a member of the current selection. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item
);

/*SetDataBrowserItemDataText

Specifies the text to draw.

OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData
);
Parameters
itemData

The item data reference for the item whose text you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataText. 
theData

The CFString object that contains the text you want to draw. You are responsible for releasing the CFString object.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataText from inside a data callback routine when the item being drawn is inside a column that has the kDataBrowserTextType display type or the kDataBrowserIconAndTextType display type. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData
);

/*AddDataBrowserItems

Adds one or more items to a data browser. 

OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container to which you want to add items. Adding one or more items to an existing container opens the container. If you a pass kDataBrowserNoItem, the items are added to the root container.
numItems

The number of items in the array pointed to by the items parameter.
items

A pointer to an array of item ID values for the items you want to add to the data browser. You supply item ID values based on your own identification scheme. If you pass NULL, each time you call AddDataBrowserItems the data browser generates item ID values starting at 1. Calling the function in this way clears whatever items are in the container. Because of this clearing behavior, passing NULL is not recommended unless your application uses a data browser to display a simple list that is populated only once with data.
preSortProperty

The property ID of the column whose sorting order matches the sorting order of the items array. A property ID is a four-character sequence that you assign to represent a column in list view. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order of your data. You’ll get the best performance from this function if you provide a sorting order. 
Return Value

A result code. If the item ID specified by the container parameter is not classified as a container, returns errDataBrowserItemNotAdded if you attempt to add subitems to it. See “Data Browser Result Codes”.
Discussion

Hierarchical lists are constructed in a top-down fashion. Your application must install all the top-level, or parent, item IDs in the data browser before it associates a list of item ID values as subitems. You can add items to a parent item only after the parent item is classified as a container. A container is an item for which the property kDataBrowserItemIsContainerProperty is set to true. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);

/*RemoveDataBrowserItems

Removes one or more items from a data browser.

OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container from which you want to remove items. Pass kDataBrowserNoItem to remove items from the root container.
numItems

The number of items in the array pointed to by the items parameter. To remove all items pass 0 and also pass NULL in the items parameter.
items

A pointer to an array of item ID values for the items you want to remove from the data browser. You can delete an arbitrary list of items from a container. To remove all items, pass NULL, and also pass 0 in the numItems parameter. 
preSortProperty

The property ID of the column whose sorting order is the same as the sorting order of the items array. A property ID is a value that identifies a column independent of its position in a data browser. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order. You’ll get the best performance from this function if you provide a sorting order.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);

#ifdef __cplusplus
}
#endif

#endif