#ifndef EVENTS_H
#define EVENTS_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#include <HYS/HIToolbox/Events.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Character Codes

Define character codes for events. 

enum {
   kNullCharCode = 0,
   kHomeCharCode = 1,
   kEnterCharCode = 3,
   kEndCharCode = 4,
   kHelpCharCode = 5,
   kBellCharCode = 7,
   kBackspaceCharCode = 8,
   kTabCharCode = 9,
   kLineFeedCharCode = 10,
   kVerticalTabCharCode = 11,
   kPageUpCharCode = 11,
   kFormFeedCharCode = 12,
   kPageDownCharCode = 12,
   kReturnCharCode = 13,
   kFunctionKeyCharCode = 16,
   kCommandCharCode = 17,
   kCheckCharCode = 18,
   kDiamondCharCode = 19,
   kAppleLogoCharCode = 20,
   kEscapeCharCode = 27,
   kClearCharCode = 27,
   kLeftArrowCharCode = 28,
   kRightArrowCharCode = 29,
   kUpArrowCharCode = 30,
   kDownArrowCharCode = 31,
   kSpaceCharCode = 32,
   kDeleteCharCode = 127,
   kBulletCharCode = 165,
   kNonBreakingSpaceCharCode = 202
};
Constants
kNullCharCode

Available in Mac OS X v10.0 and later.
kHomeCharCode

Available in Mac OS X v10.0 and later.
kEnterCharCode

Available in Mac OS X v10.0 and later.
kEndCharCode

Available in Mac OS X v10.0 and later.
kHelpCharCode

Available in Mac OS X v10.0 and later.
kBellCharCode

Available in Mac OS X v10.0 and later.
kBackspaceCharCode

Available in Mac OS X v10.0 and later.
kTabCharCode

Available in Mac OS X v10.0 and later.
kLineFeedCharCode

Available in Mac OS X v10.0 and later.
kVerticalTabCharCode

Available in Mac OS X v10.0 and later.
kPageUpCharCode

Available in Mac OS X v10.0 and later.
kFormFeedCharCode

Available in Mac OS X v10.0 and later.
kPageDownCharCode

Available in Mac OS X v10.0 and later.
kReturnCharCode

Available in Mac OS X v10.0 and later.
kFunctionKeyCharCode

Available in Mac OS X v10.0 and later.
kCommandCharCode

Available in Mac OS X v10.1 and later.
kCheckCharCode

Available in Mac OS X v10.1 and later.
kDiamondCharCode

Available in Mac OS X v10.1 and later.
kAppleLogoCharCode

Available in Mac OS X v10.1 and later.
kEscapeCharCode

Available in Mac OS X v10.0 and later.
kClearCharCode

Available in Mac OS X v10.0 and later.
kLeftArrowCharCode

Available in Mac OS X v10.0 and later.
kRightArrowCharCode

Available in Mac OS X v10.0 and later.
kUpArrowCharCode

Available in Mac OS X v10.0 and later.
kDownArrowCharCode

Available in Mac OS X v10.0 and later.
kSpaceCharCode

Available in Mac OS X v10.1 and later.
kDeleteCharCode

Available in Mac OS X v10.0 and later.
kBulletCharCode

Available in Mac OS X v10.1 and later.
kNonBreakingSpaceCharCode

Available in Mac OS X v10.0 and later.*/
enum {
   kNullCharCode = 0,
   kHomeCharCode = 1,
   kEnterCharCode = 3,
   kEndCharCode = 4,
   kHelpCharCode = 5,
   kBellCharCode = 7,
   kBackspaceCharCode = 8,
   kTabCharCode = 9,
   kLineFeedCharCode = 10,
   kVerticalTabCharCode = 11,
   kPageUpCharCode = 11,
   kFormFeedCharCode = 12,
   kPageDownCharCode = 12,
   kReturnCharCode = 13,
   kFunctionKeyCharCode = 16,
   kCommandCharCode = 17,
   kCheckCharCode = 18,
   kDiamondCharCode = 19,
   kAppleLogoCharCode = 20,
   kEscapeCharCode = 27,
   kClearCharCode = 27,
   kLeftArrowCharCode = 28,
   kRightArrowCharCode = 29,
   kUpArrowCharCode = 30,
   kDownArrowCharCode = 31,
   kSpaceCharCode = 32,
   kDeleteCharCode = 127,
   kBulletCharCode = 165,
   kNonBreakingSpaceCharCode = 202
};

/*charCodeMask


enum {
   charCodeMask = 0x000000FF,
   keyCodeMask = 0x0000FF00,
   adbAddrMask = 0x00FF0000,
   osEvtMessageMask = 0xFF000000
};
Constants
charCodeMask

The enumerator indicating you want your application to receive a character-code keyboard event.

Available in Mac OS X v10.0 and later.
keyCodeMask

The enumerator indicating you want your application to receive a key-code keyboard event.

Available in Mac OS X v10.0 and later.
adbAddrMask

The enumerator indicating you want your application to receive an ADB address if there is an ADB keyboard. 

Available in Mac OS X v10.0 and later.
osEvtMessageMask

The enumerator indicating you want your application to receive a keyboard event that can be used to extract a message code.

Available in Mac OS X v10.0 and later*/
enum {
   charCodeMask = 0x000000FF,
   keyCodeMask = 0x0000FF00,
   adbAddrMask = 0x00FF0000,
   osEvtMessageMask = 0xFF000000
};


/*Event Kind Constants

Define event kinds. 

enum {
   nullEvent = 0,
   mouseDown = 1,
   mouseUp = 2,
   keyDown = 3,
   keyUp = 4,
   autoKey = 5,
   updateEvt = 6,
   diskEvt = 7,
   activateEvt = 8,
   osEvt = 15,
   kHighLevelEvent = 23
};
typedef UInt16 EventKind;
Constants
nullEvent

The event code indicating that there are no other pending events.

Available in Mac OS X v10.0 and later.
mouseDown

The event code indicating that the mouse button has been pressed.

Available in Mac OS X v10.0 and later.
mouseUp

The event code indicating that the mouse button has been released.

Available in Mac OS X v10.0 and later.
keyDown

The event code indicating that a key has been pressed.

Available in Mac OS X v10.0 and later.
keyUp

The event code indicating that a key has been released.

Available in Mac OS X v10.0 and later.
autoKey

The event code indicating that a key has been repeatedly held down.

Available in Mac OS X v10.0 and later.
updateEvt

The event code indicating that a window needs updating.

Available in Mac OS X v10.0 and later.
diskEvt

The event code indicating that a disk has been inserted.

Available in Mac OS X v10.0 and later.
activateEvt

The event code indicating that a window has been activated or deactivated.

Available in Mac OS X v10.0 and later.
osEvt

The event code indicating a suspend, resume, or mouse-moved operating-system event.

Available in Mac OS X v10.0 and later.
kHighLevelEvent

A high-level event.

Available in Mac OS X v10.0 and later.*/
enum {
   nullEvent = 0,
   mouseDown = 1,
   mouseUp = 2,
   keyDown = 3,
   keyUp = 4,
   autoKey = 5,
   updateEvt = 6,
   diskEvt = 7,
   activateEvt = 8,
   osEvt = 15,
   kHighLevelEvent = 23
};
typedef UInt16 EventKind;

/*Event Modifier Constants

Define modifiers for event types. 

enum {
   activeFlagBit = 0,
   btnStateBit = 7,
   cmdKeyBit = 8,
   shiftKeyBit = 9,
   alphaLockBit = 10,
   optionKeyBit = 11,
   controlKeyBit = 12,
   rightShiftKeyBit = 13,
   rightOptionKeyBit = 14,
   rightControlKeyBit = 15
};
typedef UInt16 EventModifiers;
Constants
activeFlagBit

Available in Mac OS X v10.0 and later.
btnStateBit

Available in Mac OS X v10.0 and later.
cmdKeyBit

Available in Mac OS X v10.0 and later.
shiftKeyBit

Available in Mac OS X v10.0 and later.
alphaLockBit

Available in Mac OS X v10.0 and later.
optionKeyBit

Available in Mac OS X v10.0 and later.
controlKeyBit

Available in Mac OS X v10.0 and later.
rightShiftKeyBit

Available in Mac OS X v10.0 and later.
rightOptionKeyBit

Available in Mac OS X v10.0 and later.
rightControlKeyBit

Available in Mac OS X v10.0 and later.*/
enum {
   activeFlagBit = 0,
   btnStateBit = 7,
   cmdKeyBit = 8,
   shiftKeyBit = 9,
   alphaLockBit = 10,
   optionKeyBit = 11,
   controlKeyBit = 12,
   rightShiftKeyBit = 13,
   rightOptionKeyBit = 14,
   rightControlKeyBit = 15
};
typedef UInt16 EventModifiers;

/*EventRecord

Contains information associated with an event.

struct EventRecord {
   EventKind what;
   UInt32 message;
   UInt32 when;
   Point where;
   EventModifiers modifiers;
};
typedef struct EventRecord EventRecord;
Fields
what

The kind of event received. The Event Manager specifies the kind of event with one of the values defined by the EventKind enumeration. 
message

Additional information associated with the event. The interpretation of this information depends on the event type. The contents of the message field for each event type are summarized here:
For a null, mouse-up, or mouse-down event, the event message is:Undefined.
For a key-up, key-down, or auto-key event, the event message is:The low-order word contains the character code and virtual key code, which you can access with the constants charCodeMask and keyCodeMask, respectively. For Apple Desktop Bus (ADB) keyboards, the low byte of the high-order word contains the ADB address of the keyboard where the keyboard event occurred. The high byte of the high-order word is reserved.
For an update or activate event, the event message is:A pointer to the window to update, activate, or deactivate.
For a disk-inserted event, the event message is:The drive number in the low-order word, the File Manager result code in the high-order word.
For a resume event, the event message is:The suspendResumeMessage enumerator in bits 24–31 and a 1 (the resumeFlag enumerator) in bit 0 indicate the event is a resume event. Bit 1 contains a 1 (the convertClipBoardFlag enumerator) if Clipboard conversion is required, and bits 2–23 are reserved.
For a suspend event, the event message is:The suspendResumeMessage enumerator in bits 24–31 and a 0 in bit 0 to indicate the event is a suspend event. Bit 1 is undefined, and bits 2–23 are reserved.
For a mouse-moved event, the event message is:The mouseMovedMessage enumerator in bits 24–31. Bits 2–23 are reserved, and bit 0 and bit 1 are undefined.
For a high-level event, the event message is:

The class of events to which the high-level event belongs. The message and where fields of a high-level event define the specific type of high-level event received.
when

The when field indicates the time when the event was posted (in ticks since system startup).
where

For low-level events and operating-system events, the where field contains the location of the cursor at the time the event was posted (in global coordinates).

For high-level events, the where field contains a second event specifier, the event ID. The event ID defines the particular type of event within the class of events defined by the message field of the high-level event. For high-level events, you should interpret the where field as having the data type OSType, not Point.
modifiers

The modifiers field contains information about the state of the modifier keys and the mouse button at the time the event was posted. For activate events, this field also indicates whether the window should be activated or deactivated. In System 7 it also indicates whether the mouse-down event caused your application to switch to the foreground. 

Each of the modifier keys is represented by a specific bit in the modifiers field of the event structure. The modifier keys include the Option, Command, Caps Lock, Control, and Shift keys. If your application attaches special meaning to any of these keys in combination with other keys or when the mouse button is down, you can test the state of the modifiers field to determine the action your application should take. For example, you can use this information to determine whether the user pressed the Command key and another key to make a menu choice.

Discussion

When your application uses an Event Manager function to retrieve an event, the Event Manager returns information about the retrieved event in an event structure, which is a structure of type EventRecord. 
Availability
Available in Mac OS X v10.0 and later.*/
struct EventRecord {
   EventKind what;
   UInt32 message;
   UInt32 when;
   Point where;
   EventModifiers modifiers;
};
typedef struct EventRecord EventRecord;

/*Button

Determines whether the user pressed the mouse button.

Not recommended

Boolean Button ();
Parameters
Return Value
Discussion

The Button function simply checks to see if the mouse button is down. If so, it returns true; otherwise, it returns false. To determine whether the mouse button is still down after a mouse-down event, use the StillDown function. To check to see if the mouse was released, use the WaitMouseUp function. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

You should avoid using any calls that poll the state of the mouse button, as they use excessive processor time and slow down the system. In most cases you are more interested in the transitions of the mouse button rather than its instantaneous state, so you should adopt Carbon events and take action on mouse-up and mouse-down events. If you need to track the mouse while down, consider using the Carbon Event Manager functions TrackMouseLocation or TrackMouseRegion. On Mac OS X v.10.2 and later, if you need to know the button state, you should call the GetCurrentEventButtonState function. 
Declared In
Events.h*/
Boolean Button ();

#ifdef __cplusplus
}
#endif

#endif