#ifndef HIGEOMETRY_H
#define HIGEOMETRY_H

#ifndef COREGRAPHICS_H
#include <CoreGraphics/CoreGraphics.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*HISize

Defines the width and height of an object using floating-point coordinates.

typedef CGSize HISize;
Availability
Available in Mac OS X v10.2 and later.
Declared In
HIGeometry.h*/
typedef CGSize HISize;

/*HIRect

Defines the position and size of a rectangle using floating-point coordinates.

typedef CGRect HIRect;
Discussion

The HIRect type is a data structure that defines the position and size (width and height) of a rectangle in a floating-point coordinate space. When you obtain a rectangle of type HIRect from an HIToolbox function or a Carbon event, typically the y-axis of the drawing coordinate space is inverted with the origin (0,0) in the upper-left corner of the main display. In this case, the position or origin of the rectangle is its upper-left corner. Note that although it replaces the QuickDraw Rect data structure, the HIRect data structure does not contain the same fields.
Availability
Available in Mac OS X v10.2 and later.
Declared In
HIGeometry.h*/
typedef CGRect HIRect;

/*HIPoint

Defines the position of a point using floating-point coordinates.

typedef CGPoint HIPoint;
Discussion

The HIPoint type is a data structure that defines the position of a point (x,y) in a floating-point coordinate space. When you obtain a point of type HIPoint from an HIToolbox function or a Carbon event, typically the y-axis of the drawing coordinate space is inverted with the origin (0,0) in the upper-left corner of the main display. Note that although it replaces the QuickDraw Point data structure, the HIPoint data structure does not contain the same fields.
Availability
Available in Mac OS X v10.1 and later.
Declared In
HIGeometry.h*/
typedef CGPoint HIPoint;

#ifdef __cplusplus
}
#endif
#endif