#ifndef IOUSBLIB_H
#define IOUSBLIB_H

#include <IOKit/usb/USB.h>
#include <IOKit/IOKitLib.h>

#include <CoreFoundation/CFRunLoop.h>
#include <CoreFoundation/CFPlugIn.h>

#include <sys/cdefs.h>
#include <HYS/IOKit/usb/IOUSBLib.h>

#ifndef CFPLUGINCOM_H
#include </CoreFoundation/CFPlugInCOM.h>
#endif

/*kIOUSBDeviceInterfaceID

#define kIOUSBDeviceInterfaceID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x5c, 0x81, 0x87, 0xd0, 0x9e, 0xf3, 0x11, 0xD4, \ 
    0x8b, 0x45, 0x00, 0x0a, 0x27, 0x05, 0x28, 0x61) 
Discussion 

This UUID constant is used to obtain a device interface corresponding to an IOUSBDevice user client in the kernel. The type of this device interface is IOUSBDeviceInterface. This device interface is obtained after the device interface for the service itself has been obtained. 

Note: The IOUSBDeviceInterface is returned by all versions of the IOUSBFamily currently shipping. However, there are some functions that are available only in IOUSBFamily version 1.8.2 and above. Access to these functions, in addition to the functions contained in IOUSBDeviceInterface, can be obtained by using one of the other UUIDs listed in this header. 

Example: 
    IOCFPluginInterface		**iodev; 	// obtained earlier
    
    IOUSBDeviceInterface	**dev;		// fetching this now
    IOReturn                    err;
    
    err = (*iodev)->QueryInterface(iodev,
                                    CFUUIDGetUUIDBytes(kIOUSBDeviceInterfaceID),
                                    (LPVoid)&dev);    */
#define kIOUSBDeviceInterfaceID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x5c, 0x81, 0x87, 0xd0, 0x9e, 0xf3, 0x11, 0xD4, \ 
    0x8b, 0x45, 0x00, 0x0a, 0x27, 0x05, 0x28, 0x61) 


/*kIOUSBDeviceUserClientTypeID

#define kIOUSBDeviceUserClientTypeID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x9d, 0xc7, 0xb7, 0x80, 0x9e, 0xc0, 0x11, 0xD4, \ 
    0xa5, 0x4f, 0x00, 0x0a, 0x27, 0x05, 0x28, 0x61) 
Discussion 

This UUID constant is used to obtain a device interface corresponding to an io_service_t corresponding to an IOUSBDevice in the kernel. Once you have obtained the device interface for the service, you must use the QueryInterface function to obtain the device interface for the user client itself. 

Example: 
  io_service_t            usbDeviceRef;   // obtained earlier
        
  IOCFPlugInInterface     **iodev;        // fetching this now
        
  SInt32                  score;          // not used
  IOReturn                err;
        
  err = IOCreatePlugInInterfaceForService(usbDeviceRef,
                                    kIOUSBDeviceUserClientTypeID,
                                    kIOCFPlugInInterfaceID,
                                    &iodev,
                                    &score);*/
#define kIOUSBDeviceUserClientTypeID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x9d, 0xc7, 0xb7, 0x80, 0x9e, 0xc0, 0x11, 0xD4, \ 
    0xa5, 0x4f, 0x00, 0x0a, 0x27, 0x05, 0x28, 0x61) 


#endif