#ifndef CGIMAGEDESTINATION_H
#define CGIMAGEDESTINATION_H

#include <ImageIO/CGImageSource.h>

/*CGImageDestinationRef

Defines an opaque type that represents a Quartz image destination.

typedef struct CGImageDestination *CGImageDestinationRef;
Discussion

In Mac OS X v10.4 and later, CGImageDestinationRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.4 and later.*/
typedef struct CGImageDestination *CGImageDestinationRef;

/*CGImageDestinationFinalize

Writes image data and properties to the data, URL, or data consumer associated with the image destination.

bool CGImageDestinationFinalize(
   CGImageDestinationRef idst
);
Parameters
idst

An image destination.
Return Value

Returns true if the image is successfully written; false otherwise.
Discussion

You must call this function or the output of the image destination will not be valid. After calling this function, no additional data is written to the image destination.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
bool CGImageDestinationFinalize(
   CGImageDestinationRef idst
);

/*CGImageDestinationAddImage

Adds an image to an image destination.

void CGImageDestinationAddImage(
   CGImageDestinationRef idst,
   CGImageRef image,
   CFDictionaryRef properties
);
Parameters
idst

An image destination
image

The image to add. 
properties

An optional dictionary that specifies the properties of the added image.
Discussion

The function CGImageDestiantionAddImage sets the next image in the image destination. The function logs an error if you add more images than what you specified when you created the image destination.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
void CGImageDestinationAddImage(
   CGImageDestinationRef idst,
   CGImageRef image,
   CFDictionaryRef properties
);

/*CGImageDestinationCreateWithURL

Creates an image destination that writes to a location specified by a URL.

CGImageDestinationRef CGImageDestinationCreateWithURL(
   CFURLRef url,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);
Parameters
url

The URL to write to. If the URL already exists, the data at this location is overwritten.
type

The UTI (uniform type identifier) of the resulting image file.
count

The number of images (not including thumbnail images) that the image file will contain.
options

Reserved for future use. Pass NULL.
Return Value

A Quartz image destination. You are responsible for releasing this object using CFRelease.
Discussion

See Uniform Type Identifiers Overview for a list of system-declared and third-party UTIs.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CGImageDestination.h*/
CGImageDestinationRef CGImageDestinationCreateWithURL(
   CFURLRef url,
   CFStringRef type,
   size_t count,
   CFDictionaryRef options
);

#endif