#ifndef QUICKDRAW_H
#define QUICKDRAW_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef COREGRAPHICS_H
#include <CoreGraphics/CoreGraphics.h>
#endif

#ifndef QUICKDRAWTEXT_H
#include <QD/QuickdrawText.h>
#endif

#ifndef CMTYPES_H
#include <ColorSync/CMTypes.h>
#endif

#include <HYS/QD/Quickdraw.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Pixel Formats

enum {
   k16LE555PixelFormat = 'L555',
   k16LE5551PixelFormat = '5551',
   k16BE565PixelFormat = 'B565',
   k16LE565PixelFormat = 'L565',
   k24BGRPixelFormat = '24BG',
   k32BGRAPixelFormat = 'BGRA',
   k32ABGRPixelFormat = 'ABGR',
   k32RGBAPixelFormat = 'RGBA',
   kYUVSPixelFormat = 'yuvs',
   kYUVUPixelFormat = 'yuvu',
   kYVU9PixelFormat = 'YVU9',
   kYUV411PixelFormat = 'Y411',
   kYVYU422PixelFormat = 'YVYU',
   kUYVY422PixelFormat = 'UYVY',
   kYUV211PixelFormat = 'Y211',
   k2vuyPixelFormat = '2vuy'
};*/
enum {
   k16LE555PixelFormat = 'L555',
   k16LE5551PixelFormat = '5551',
   k16BE565PixelFormat = 'B565',
   k16LE565PixelFormat = 'L565',
   k24BGRPixelFormat = '24BG',
   k32BGRAPixelFormat = 'BGRA',
   k32ABGRPixelFormat = 'ABGR',
   k32RGBAPixelFormat = 'RGBA',
   kYUVSPixelFormat = 'yuvs',
   kYUVUPixelFormat = 'yuvu',
   kYVU9PixelFormat = 'YVU9',
   kYUV411PixelFormat = 'Y411',
   kYVYU422PixelFormat = 'YVYU',
   kUYVY422PixelFormat = 'UYVY',
   kYUV211PixelFormat = 'Y211',
   k2vuyPixelFormat = '2vuy'
};


/*k1MonochromePixelFormat

enum {
   k1MonochromePixelFormat = 0x00000001,
   k2IndexedPixelFormat = 0x00000002,
   k4IndexedPixelFormat = 0x00000004,
   k8IndexedPixelFormat = 0x00000008,
   k16BE555PixelFormat = 0x00000010,
   k24RGBPixelFormat = 0x00000018,
   k32ARGBPixelFormat = 0x00000020,
   k1IndexedGrayPixelFormat = 0x00000021,
   k2IndexedGrayPixelFormat = 0x00000022,
   k4IndexedGrayPixelFormat = 0x00000024,
   k8IndexedGrayPixelFormat = 0x00000028
};*/
enum {
   k1MonochromePixelFormat = 0x00000001,
   k2IndexedPixelFormat = 0x00000002,
   k4IndexedPixelFormat = 0x00000004,
   k8IndexedPixelFormat = 0x00000008,
   k16BE555PixelFormat = 0x00000010,
   k24RGBPixelFormat = 0x00000018,
   k32ARGBPixelFormat = 0x00000020,
   k1IndexedGrayPixelFormat = 0x00000021,
   k2IndexedGrayPixelFormat = 0x00000022,
   k4IndexedGrayPixelFormat = 0x00000024,
   k8IndexedGrayPixelFormat = 0x00000028
};

/*Source, Pattern, and Arithmetic Transfer Mode Constants

enum {
   srcCopy = 0,
   srcOr = 1,
   srcXor = 2,
   srcBic = 3,
   notSrcCopy = 4,
   notSrcOr = 5,
   notSrcXor = 6,
   notSrcBic = 7,
   patCopy = 8,
   patOr = 9,
   patXor = 10,
   patBic = 11,
   notPatCopy = 12,
   notPatOr = 13,
   notPatXor = 14,
   notPatBic = 15,
   grayishTextOr = 49,
   hilitetransfermode = 50,
   hilite = 50,
   blend = 32,
   addPin = 33,
   addOver = 34,
   subPin = 35,
   addMax = 37,
   adMax = 37,
   subOver = 38,
   adMin = 39,
   ditherCopy = 64,
   transparent = 36
};
Constants
srcCopy

For basic graphics ports, force the destination pixel black where the source pixel is black; where the source pixel is white, force the destination pixel white.

For color graphics ports, determines how close the color of the source pixel is to black, and assigns this relative amount of foreground color to the destination pixel. Determines how close the color of the source pixel is to white, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
srcOr

For basic graphics ports, forces the destination pixel black if the source pixel is black; where the source pixel is white, leaves the destination pixel unaltered.

For color graphics ports, determines how close the color of the source pixel is to black, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
srcXor

For basic and color graphics ports, inverts destination pixel where the source pixel is black. For a basic graphics port, where the source pixel is white, leaves the destination pixel unaltered. 

For a color graphics port, for a colored destination pixel, uses the complement of its color if the pixel is direct, or inverts its index if the pixel is indexed.

Available in Mac OS X v10.0 and later.
srcBic

For a basic graphics port, forces destination pixel white where source pixel is black; where source pixel is white, leaves the destination pixel unaltered.

For a color graphics port, determines how close the color of the source pixel is to black, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcCopy

For a basic graphics port, forces the destination pixel white where the source pixel is black; where the source pixel is white, forces the destination pixel black.

For a color graphics port, determines how close the color of the source pixel is to black, and assigns this relative amount of background color to the destination pixel. Determines how close the color of the source pixel is to white, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcOr

For a basic graphics port, leaves the destination pixel unaltered where the source pixel is black; where the source pixel is white, forces the destination pixel black.

For a color graphics port, determines how close the color of the source pixel is to white, and assigns this relative amount of foreground color to the destination pixel.

Available in Mac OS X v10.0 and later.
notSrcXor

For basic and color graphics ports, where the source pixel is white, inverts the destination pixel. For a basic graphics port, where the source pixel is black, leaves the destination pixel unaltered.

For a color graphics port, for a colored destination pixel, uses the complement of its color if the pixel is direct, or inverts its index if the pixel is indexed.

Available in Mac OS X v10.0 and later.
notSrcBic

For a basic graphics port, where the source pixel is black, leaves the destination pixel unaltered; where the source pixel is white, forces the destination pixel white.

For a color graphics port, determines how close the color of the source pixel is to white, and assigns this relative amount of background color to the destination pixel.

Available in Mac OS X v10.0 and later.
patCopy

Where the pattern pixel is black, applies foreground color to the destination pixel; where the pattern pixel is white, applies background color to the destination pixel.

Available in Mac OS X v10.0 and later.
patOr

Where the pattern pixel is black, inverts the destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
patXor

Where the pattern pixel is black, inverts the destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
patBic

Where the pattern pixel is black, applies the background color to destination pixel; where the pattern pixel is white, leaves the destination pixel unaltered.

Available in Mac OS X v10.0 and later.
notPatCopy

Where the pattern pixel is black, applies background color to destination pixel; where the pattern pixel is white, applies foreground color to the destination pixel

Available in Mac OS X v10.0 and later.
notPatOr

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, applies foreground color to the destination pixel

Available in Mac OS X v10.0 and later.
notPatXor

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, inverts the destination pixel

Available in Mac OS X v10.0 and later.
notPatBic

Where the pattern pixel is black, leaves the destination pixel unaltered; where the pattern pixel is white, applies background color to the destination pixel.

Available in Mac OS X v10.0 and later.
grayishTextOr

Draws dimmed text on the screen. You can use it for black-and-white or color graphics ports. The grayishTextOr transfer mode is not considered a standard transfer mode because currently it is not stored in pictures, and printing with it is undefined. (It does not pass through the QuickDraw bottleneck functions.)

Available in Mac OS X v10.0 and later.
hilite

Adds highlighting to the source or pattern mode. With highlighting, QuickDraw replaces the background color with the highlight color when your application copies images between graphics ports. This has the visual effect of using a highlighting pen to select the object. (The global variable HiliteRGB is read from parameter RAM when the machine starts. Basic graphics ports use the color stored in the HiliteRGB global variable as the highlight color. Color graphics ports default to the HiliteRGB global variable, but can be overridden by the HiliteColor function.)

For text, specifies that the caret position should be determined according to the primary line direction, based on the value of SysDirection.

Available in Mac OS X v10.0 and later.
blend

Replaces the destination pixel with a blend of the source and destination pixel colors. If the destination is a bitmap or 1-bit pixel map, reverts to srcCopy mode.

Available in Mac OS X v10.0 and later.
addPin

Replaces the destination pixel with the sum of the source and destination pixel colors-- up to a maximum allowable values. If the destination is a bitmap or 1-bit pixel map, reverts to srcBic mode.

Available in Mac OS X v10.0 and later.
addOver

Replaces the destination pixel with the sum of the source and destination pixel colors, except if the value of the red, green, or blue component exceeds 65,536, then addOver subtracts 65,536 from that value. If the destination is a bitmap or 1-bit pixel map, reverts to srcXor mode.

Available in Mac OS X v10.0 and later.
subPin

Replaces the destination pixel with the difference of the source and destination pixel colors, but not less than a minimum allowable value. If the destination is a bitmap or 1-bit pixel map, reverts to srcOr mode.

Available in Mac OS X v10.0 and later.
addMax

Compares the source and destination pixels, and replaces the destination pixel with the color containing the greater saturation of each of the RGB components. If the destination is a bitmap or 1-bit pixel map, reverts to srcBic mode.

Available in Mac OS X v10.0 and later.
subOver

Replaces the destination pixel with the difference of the source and destination pixel colors, except if the value of the red, green, or blue component is less than 0, then it adds the negative result to 65,536. if the destination is a bitmap or 1-bit pixel map, revert to srcXor mode.

Available in Mac OS X v10.0 and later.
adMin

Compares the source and destination pixels, and replaces the destination pixel with the color containing the lesser saturation of each of the RGB components. If the destination is a bitmap or 1-bit pixel map, reverts to srcOr mode.

Available in Mac OS X v10.0 and later.
ditherCopy

On computers running System 7, you can add dithering to any source mode by adding this constant or the value it represents to the source mode.

Dithering is a technique that mixes existing colors to create the effect of additional colors. It also improves images that you shrink or that you copy from a direct pixel device to an indexed device.

Available in Mac OS X v10.0 and later.
transparent

Replaces the destination pixel with the source pixel if the source pixel is not equal to the background color. The transparent mode replaces the destination pixel with the source pixel if the source pixel isn’t equal to the background color. This mode is most useful in 8-bit, 4-bit, or 2-bit color modes.

Available in Mac OS X v10.0 and later.
Discussion

CopyBits uses the source and arithmetic transfer mode constants in the mode parameter to specify the manner in which pixels are transferred from a source pixel map to a destination pixel map.

PenMode uses the pattern mode constants in the mode parameter to specify source modes for transferring the bits from a source bitmap to a destination bitmap.

The TextMode function uses these constants to set the transfer mode in the graphics port txMode field. 

The transfer mode determines the interplay between what an application is drawing (the source) and what already exists on the display device (the destination), resulting in the text display.

There are two basic kinds of modes: pattern ( pat) and source ( src). 

The pattern mode constants are patCopy, patOr, patXor, patBic, notPatCopy, notPatOr, notPatXor, and notPatBic.

Source is the kind that you use for drawing text. There are four basic Boolean operations: Copy, Or, Xor, and Bic (bit clear), each of which has an inverse variant in which the source is inverted before the transfer, yielding eight operations in all. Basic QuickDraw supports these eight transfer modes. Color QuickDraw interprets the source mode constants differently than basic QuickDraw does. Color QuickDraw enables your application to achieve color effects within those basic transfer modes, and offers an additional set of transfer modes that perform arithmetic operations on the RGB values of the source and destination pixels. Other transfer modes are grayishTextOr, transparent mode, and text mask mode.

The arithmetic transfer modes are addOver, addPin, subOver, subPin, addMax, adMax, adMin, and blend. For color, the arithmetic modes change the destination pixels by performing arithmetic operations on the source and destination pixels. Arithmetic transfer modes calculate pixel values by adding, subtracting, or averaging the RGB components of the source and destination pixels. They are most useful for 8-bit color, but they work on 4-bit and 2-bit color also. When the destination bitmap is one bit deep, the mode reverts to the basic transfer mode that best approximates the arithmetic mode requested.*/
enum {
   srcCopy = 0,
   srcOr = 1,
   srcXor = 2,
   srcBic = 3,
   notSrcCopy = 4,
   notSrcOr = 5,
   notSrcXor = 6,
   notSrcBic = 7,
   patCopy = 8,
   patOr = 9,
   patXor = 10,
   patBic = 11,
   notPatCopy = 12,
   notPatOr = 13,
   notPatXor = 14,
   notPatBic = 15,
   grayishTextOr = 49,
   hilitetransfermode = 50,
   hilite = 50,
   blend = 32,
   addPin = 33,
   addOver = 34,
   subPin = 35,
   addMax = 37,
   adMax = 37,
   subOver = 38,
   adMin = 39,
   ditherCopy = 64,
   transparent = 36
};


/*RgnHandle

typedef struct OpaqueRgnHandle * RgnHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueRgnHandle * RgnHandle;

/*BitMap

struct BitMap {
   Ptr baseAddr;
   short rowBytes;
   Rect bounds;
};
typedef struct BitMap BitMap;
typedef BitMap * BitMapPtr;
Fields
baseAddr

A pointer to the beginning of the bit image.
rowBytes

The offset in bytes from one row of the image to the next. The value of the rowBytes field must be less than $4000.
bounds

The bitmap’s boundary rectangle by default, the entire main screen.
Discussion

A bitmap, which is a data structure of type BitMap, defines a bit image in terms of the QuickDraw coordinate plane. (A bit image is a collection of bits in memory that form a grid.)

A bitmap has three parts: a pointer to a bit image, the row width of that image, and a boundary rectangle that links the local coordinate system of a graphics port to QuickDraw’s global coordinate system and defines the area of the bit image into which QuickDraw can draw.

The width of the boundary rectangle determines how many bits of one row are logically owned by the bitmap. This width must not exceed the number of bits in each row of the bit image. The height of the boundary rectangle determines how many rows of the image are logically owned by the bitmap. The number of rows enclosed by the boundary rectangle must not exceed the number of rows in the bit image.

The boundary rectangle defines the local coordinate system used by the port rectangle for a graphics port (described next). The upper-left corner (which for a window is called the window origin) of the port rectangle usually has a vertical coordinate of 0 and a horizontal coordinate of 0, although you can use the function SetOrigin to change the coordinates of the window origin. 
Availability
Available in Mac OS X v10.0 and later.*/
struct BitMap {
   Ptr baseAddr;
   short rowBytes;
   Rect bounds;
};
typedef struct BitMap BitMap;
typedef BitMap * BitMapPtr;

/*GrafPtr

typedef struct OpaqueGrafPtr * GrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueGrafPtr * GrafPtr;

/*CGrafPtr

typedef GrafPtr CGrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef GrafPtr CGrafPtr;

/*ITab

struct ITab {
   long iTabSeed;
   short iTabRes;
   Byte iTTable[1];
};
typedef struct ITab ITab;
typedef ITab * ITabPtr;
typedef ITabPtr * ITabHandle;
Fields
iTabSeed

The iTabSeed value, initially set from the corresponding CLUT’s ctSeed field. If at any time these do not match, then the color table was changed, and the inverse table needs to be rebuilt.
iTabRes

The resolution of this inverse table.
iTTable

An array of index values. The size of the iTabTable field in bytes is 23*iTabRes.
Discussion

The ITab data structure contains the inverse table information that the Color Manager uses for fast mapping of RGB color values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ITab {
   long iTabSeed;
   short iTabRes;
   Byte iTTable[1];
};
typedef struct ITab ITab;
typedef ITab * ITabPtr;
typedef ITabPtr * ITabHandle;



/*RGBColor

struct RGBColor {
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};
typedef struct RGBColor RGBColor;
typedef RGBColor * RGBColorPtr;
Fields
red

An unsigned integer specifying the red value of the color.
green

An unsigned integer specifying the green value of the color.
blue

An unsigned integer specifying the blue value of the color.
Discussion

You usually specify a color to QuickDraw by creating an RGBColor structure in which you assign the red, green, and blue values of the foreground color. For example, when you want to set the foreground color for drawing, you create an RGBColor structure that defines the foreground color you desire; then you pass that structure as a parameter to the RGBForeColor function. 

In an RGBColor structure, three 16-bit unsigned integers give the intensity values for the three additive primary colors. 
Availability
Available in Mac OS X v10.0 and later.*/
struct RGBColor {
   unsigned short red;
   unsigned short green;
   unsigned short blue;
};
typedef struct RGBColor RGBColor;
typedef RGBColor * RGBColorPtr;


/*ColorSpec

struct ColorSpec {
   short value;
   RGBColor rgb;
};
typedef struct ColorSpec ColorSpec;
typedef ColorSpec * ColorSpecPtr;
Fields
value

The pixel value assigned by QuickDraw for the color specified in the rgb field of this structure. QuickDraw assigns a pixel value based on the capabilities of the user’s screen. For indexed devices, the pixel value is an index number assigned by QuickDraw to the closest color available on the indexed device for direct devices, this value expresses the best available red, green, and blue values for the color on the direct device.
rgb

An RGBColor structure that fully specifies the color whose approximation QuickDraw specifies in the value field. 
Discussion

When creating a PixMap structure for an indexed device, QuickDraw creates a ColorTable structure that defines the best colors available for the pixel image on that graphics device. QuickDraw also stores a ColorTable structure for the currently available colors in the graphics device’s CLUT. 

One of the fields in a ColorTable structure requires a value of type cSpecArray, which is defined as an array of ColorSpec structures. Typically, your application never needs to create ColorTable structures or ColorSpec structures. For completeness, the data structure of type ColorSpec is shown here. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorSpec {
   short value;
   RGBColor rgb;
};
typedef struct ColorSpec ColorSpec;
typedef ColorSpec * ColorSpecPtr;

/*CSpecArray

typedef ColorSpec CSpecArray[1];
Availability
Available in Mac OS X v10.0 and later.*/
typedef ColorSpec CSpecArray[1];


/*ColorTable

struct ColorTable {
   long ctSeed;
   short ctFlags;
   short ctSize;
   CSpecArray ctTable;
};
typedef struct ColorTable ColorTable;
typedef ColorTable * CTabPtr;
typedef CTabPtr * CTabHandle;
Fields
ctSeed

Identifies a particular instance of a color table. QuickDraw uses the ctSeed value to compare an indexed device’s color table with its associated inverse table (a table it uses for fast color lookup).When the color table for a graphics device has been changed, QuickDraw needs to rebuild the inverse table.
ctFlags

Flags that distinguish pixel map color tables from color tables in GDevice structures.
ctSize

One less than the number of entries in the table.
ctTable

An array of ColorSpec entries, each containing a pixel value and a color specified by an RGBColor structure. 
Discussion

When creating a PixMap structure for a particular graphics device, QuickDraw creates a ColorTable structure that defines the best colors available for the pixel image on that particular graphics device. QuickDraw also creates a ColorTable structure of all available colors for use by the CLUT on indexed devices.

Typically, your application needs to create ColorTable structures only if it uses the Palette Manager. 

Your application should never need to directly change the fields of a ColorTable structure. If you find it absolutely necessary for your application to do so, immediately use the CTabChanged function to notify QuickDraw that your application has changed the ColorTable structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorTable {
   long ctSeed;
   short ctFlags;
   short ctSize;
   CSpecArray ctTable;
};
typedef struct ColorTable ColorTable;
typedef ColorTable * CTabPtr;
typedef CTabPtr * CTabHandle;



/*CTabPtr

Abst_CTabPtr

typedef ColorTable * CTabPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ColorTable * CTabPtr;

/*CTabHandle

Abst_CTabHandle

typedef CTabPtr * CTabHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef CTabPtr * CTabHandle;



/*PixMap

Contains information about the dimensions and contents of a pixel image, as well as its storage format, depth, resolution, and color usage.

struct PixMap {
   Ptr           baseAddr;
   short         rowBytes;
   Rect          bounds;
   short         pmVersion;
   short         packType;
   long          packSize;
   Fixed         hRes;
   Fixed         vRes;
   short         pixelType;
   short         pixelSize;
   short         cmpCount;
   short         cmpSize;
   OSType        pixelFormat;
   CTabHandle    pmTable;
   void *        pmExt;
};
Fields
baseAddr
Discussion

For an onscreen pixel image, a pointer to the first byte of the image. For optimal performance, this should be a multiple of 4. The baseAddr field of the PixMap record for an offscreen graphics world contains a handle instead of a pointer. Your application should never directly access the baseAddr field of the PixMap record for an offscreen graphics world.
rowBytes
Discussion

The offset in bytes from one row of the image to the next. The value must be even, less than 0x4000, and for best performance it should be a multiple of 4. The high 2 bits of rowBytes are used as flags. If bit 15 =1, the data structure pointed to is a PixMap structure; otherwise it is a BitMap structure.
bounds
Discussion

The boundary rectangle, which links the local coordinate system of a graphics port to QuickDraw's global coordinate system and defines the area of the bit image into which QuickDraw can draw. By default, the boundary rectangle is the entire main screen. Do not use the value of this field to determine the size of the screen; instead use the value of the gdRect field of the GDevice structure for the screen.
pmVersion
Discussion

The version number of Color QuickDraw that created this PixMap structure. The value of pmVersion is normally 0. If pmVersion is 4, Color QuickDraw treats the PixMap record's baseAddr field as 32-bit clean. All other flags are private. Most applications never need to set this field
packType
Discussion

The packing algorithm used to compress image data. Color QuickDraw currently supports a packType of 0, which means no packing, and values of 1 to 4 for packing direct pixels.
packSize
Discussion

The size of the packed image in bytes. When the packType field contains the value 0, this field is always set to 0.
hRes
Discussion

The horizontal resolution of the pixel image in pixels per inch. By default, this value is 0x00480000 (for 72 pixels per inch).
vRes
Discussion

The vertical resolution of the pixel image in pixels per inch. By default, this value is 0x00480000 (for 72 pixels per inch).
pixelType
Discussion

The storage format for a pixel image. Indexed pixels are indicated by a value of 0. Direct pixels are specified by a value of RGBDirect, or 16. In the PixMap record of the GDevice structure for a direct device, this field is set to RGBDirect when the screen depth is set.
pixelSize
Discussion

The number of bits used to represent a pixel. Indexed pixels can have sizes of 1, 2, 4, and 8 bits; direct pixel sizes are 16 and 32 bits.
cmpCount
Discussion

The number of components used to represent a color for a pixel. With indexed pixels, each pixel is a single value representing an index in a color table, and therefore this field contains the value 1; the index is the single component. With direct pixels, each pixel contains three components (one integer each for the intensities of red, green, and blue) so this field contains the value 3.
cmpSize
Discussion

The size in bits of each component for a pixel. Color QuickDraw expects that the sizes of all components are the same, and that the value of the cmpCount field multiplied by the value of the cmpSize field is less than or equal to the value in the pixelSize field.

For an indexed pixel value, which has only one component, the value of the cmpSize field is the same as the value of the pixelSize field; that is, 1, 2, 4, or 8. For direct pixels there are two additional possibilities. A 16-bit pixel, which has three components, has a cmpSize value of 5; this leaves an unused high-order bit, which Color QuickDraw sets to 0. A 32-bit pixel, which has three components (red, green, and blue), has a cmpSize value of 8; this leaves an unused high-order byte, which Color QuickDraw sets to 0.

If presented with a 32-bit image (for example, in the CopyBits procedure) Color QuickDraw passes whatever bits are there, and it does not set the high byte to 0. Generally, therefore, your application should clear the memory for the image to 0 before creating a 16-bit or 32-bit image.
planeBytes
Discussion

The offset in bytes from one drawing plane to the next. This field is set to 0.
pmTable
Discussion

A handle to a ColorTable structure for the colors in this pixel map.
pmReserved
Discussion

Reserved. This field must be set to 0 for future compatibility.
pixelFormat
Discussion

The way the pixels are arranged; see Pixel Formats.
pmTable
Discussion

Color map for this structure.
pmExt
Discussion

Handle to a PixMapExtension structure. Set to NIL if there is no extension.
Discussion

The pixel map for a window's color graphics port always consists of the pixel depth, color table, and boundary rectangle of the main screen, even if the window is created on or moved to an entirely different screen.
Version Notes

Earlier versions of this structure were different in the last three fields; see the C interface file for details.
Programming Info
C interface file: Quickdraw.h*/
struct PixMap {
   Ptr           baseAddr;
   short         rowBytes;
   Rect          bounds;
   short         pmVersion;
   short         packType;
   long          packSize;
   Fixed         hRes;
   Fixed         vRes;
   short         pixelType;
   short         pixelSize;
   short         cmpCount;
   short         cmpSize;
   OSType        pixelFormat;
   CTabHandle    pmTable;
   void *        pmExt;
};
typedef  struct PixMap PixMap;



/*PixMapPtr

Abst_PixMapPtr

typedef PixMap * PixMapPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PixMap * PixMapPtr;

/*PixMapHandle

Abst_PixMapHandle

typedef PixMapPtr * PixMapHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PixMapPtr * PixMapHandle;


/*GDevice

struct GDevice {
   short gdRefNum;
   short gdID;
   short gdType;
   ITabHandle gdITable;
   short gdResPref;
   SProcHndl gdSearchProc;
   CProcHndl gdCompProc;
   short gdFlags;
   PixMapHandle gdPMap;
   long gdRefCon;
   GDHandle gdNextGD;
   Rect gdRect;
   long gdMode;
   short gdCCBytes;
   short gdCCDepth;
   Handle gdCCXData;
   Handle gdCCXMask;
   long gdReserved;
};
typedef struct GDevice GDevice;
typedef GDevice * GDPtr;
typedef GDPtr * GDHandle;
Fields
gdRefNum

The reference number of the driver for the screen associated with the video device. For most video devices, this information is set at system startup time.
gdID

Reserved. If you create your own GDevice structure, set this field to 0.
gdType

The general type of graphics device. See Graphics Device Type Constants for a description of the values which you can use in this field.
gdITable

A handle to the inverse table for color mapping. 
gdResPref

The preferred resolution for inverse tables.
gdSearchProc

A handle to the list of search functions. Its value is NULL for the default function. 
gdCompProc

A handle to a list of complement functions. Its value is NULL for the default function. 
gdFlags

The GDevice structure’s attributes. To set the attribute bits in the gdFlags field, use the SetDeviceAttribute function. Do not set gdFlags directly in the GDevice structure.
gdPMap

A handle to a PixMap structure giving the dimension of the image buffer, along with the characteristics of the graphics device (resolution, storage format, color depth, and color table). For GDevice structures, the high bit of the global variable 

(((**TheGDevice).**gdPMap).**pmTable).ctFlags

is always set.

gdRefCon

A value used by system software to pass device-related parameters. Since a graphics device is shared, do not store data here.
gdNextGD

A handle to the next graphics device in the device list. If this is the last graphics device in the device list, the field contains 0. 
gdRect

The boundary rectangle of the graphics device represented by the GDevice structure. The main screen has the upper-left corner of the rectangle set to (0,0). All other graphics devices are relative to this point.
gdMode

The current setting for the graphics device mode. This value is passed to the video driver to set its pixel depth and to specify color or black and white; applications do not need this information.
gdCCBytes

The rowBytes value of the expanded cursor. Your application should not change this field.
gdCCDepth

The depth of the expanded cursor. Your application should not change this field.
gdCCXData

A handle to the cursor’s expanded data. Your application should not change this field.
gdCCXMask

A handle to the cursor’s expanded mask. Your application should not change this field.
gdReserved

Reserved for future expansion; it must be set to 0 for future compatibility.
Discussion

Color QuickDraw stores state information for video devices and offscreen graphics worlds in GDevice structures. When the system starts up, it allocates and initializes one handle to a GDevice structure for each video device it finds. When you use the Offscreen Graphics Devices function, NewGWorld, Color QuickDraw automatically creates a GDevice structure for the new offscreen graphics world. The system links these GDevice structures in a list, called the device list. (You can find a handle to the first element in the device list in the global variable DeviceList.) By default, the GDevice structure corresponding to the first video device found is marked as the current device. All other graphics devices in the list are initially marked as inactive. 

When the user moves a window or creates a window on another screen, and your application draws into that window, Color QuickDraw automatically makes the video device for that screen the current device. Color QuickDraw stores that information in the global variable TheGDevice. 

GDevice structures that correspond to video devices have drivers associated with them. These drivers can be used to change the mode of the video device from black and white to color and to change the pixel depth. Application-created GDevice structures usually don’t require drivers. 

Your application should never need to directly change the fields of a GDevice structure. If you find it absolutely necessary for your application to so, immediately use the GDeviceChanged function to notify QuickDraw that your application has changed the GDevice structure. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct GDevice GDevice;
typedef GDevice * GDPtr;
typedef GDPtr * GDHandle;

struct GDevice {
   short gdRefNum;
   short gdID;
   short gdType;
   ITabHandle gdITable;
   short gdResPref;
   SProcHndl gdSearchProc;
   CProcHndl gdCompProc;
   short gdFlags;
   PixMapHandle gdPMap;
   long gdRefCon;
   GDHandle gdNextGD;
   //int  gdNextGD; //hys
   Rect gdRect;
   long gdMode;
   short gdCCBytes;
   short gdCCDepth;
   Handle gdCCXData;
   Handle gdCCXMask;
   long gdReserved;
};





/*Picture

struct Picture {
   short picSize;
   Rect picFrame;
};
typedef struct Picture Picture;
typedef Picture * PicPtr;
typedef PicPtr * PicHandle;
Fields
picSize

The size of the rest of this structure for a version 1 picture. To maintain compatibility with the version 1 picture format, the picSize field was not changed for the version 2 picture or extended version 2 formats. The information in this field is used only for version 1 pictures, which cannot exceed 32 KB in size. Because version 2 and extended version 2 pictures can be much larger than the 32 KB limit imposed by the 2-byte picSize field, you should use the Memory Manager function GetHandleSize to determine the size of a picture in memory; you should use the File Manager function PBGetFInfo to determine the size of a picture in a 'PICT' file; and you should use the Resource Manager function GetMaxResourceSize to determine the size of a 'PICT' resource.
picFrame

The bounding rectangle for the picture defined in the rest of this structure. The DrawPicture function uses this rectangle to scale the picture if you draw it into a destination rectangle of a different size.
Discussion

When you use the OpenCPicture or OpenPicture function, QuickDraw begins collecting your subsequent drawing commands in a Picture structure. (You use the ClosePicture function to complete a picture definition.) When you use the GetPicture function to retrieve a picture stored in a resource, GetPicture reads the resource into memory as a Picture structure. By using the DrawPicture procedure, you can draw onscreen the picture defined by the commands stored in the Picture structure.

A picture opcode is a number that the DrawPicture function uses to determine what object to draw or what mode to change for subsequent drawing. Generally, donot read or write this picture data directly. Instead, use the OpenCPicture (or OpenPicture), ClosePicture, and DrawPicture functions to process these opcodes.

The Picture structure can also contain picture comments. Created by applications using the PicComment function, picture comments contain data or commands for special processing by output devices, such as PostScript printers. 

You can use File Manager functions to save the picture in a file of type 'PICT', you can use Resource Manager functions to save the picture in a resource of type 'PICT', and you can use the Scrap Manager function PutScrap to store the picture in 'PICT' scrap format. 
Availability
Available in Mac OS X v10.0 and later.*/
struct Picture {
   short picSize;
   Rect picFrame;
};
typedef struct Picture Picture;
typedef Picture * PicPtr;
typedef PicPtr * PicHandle;

/*PicPtr

Abst_PicPtr

typedef Picture * PicPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Picture * PicPtr;

/*PicHandle

Abst_PicHandle

typedef PicPtr * PicHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PicPtr * PicHandle;

/*GrafPtr

typedef struct OpaqueGrafPtr * GrafPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueGrafPtr * GrafPtr;

/*WindowPtr

Defines a window pointer. 

typedef struct OpaqueWindowPtr * WindowPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueWindowPtr * WindowPtr;

/*WindowRef

Represents a window. 

typedef WindowPtr WindowRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef WindowPtr WindowRef;

/*DialogPtr

typedef struct OpaqueDialogPtr * DialogPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueDialogPtr * DialogPtr;

/*Pattern

struct Pattern {
   UInt8 pat[8];
};
typedef struct Pattern Pattern;
typedef Pattern * PatPtr;
typedef PatPtr * PatHandle;
Discussion

Your application typically does not create Pattern structures. Although you can create Pattern structures in your program code, it is usually easier to create bit patterns using the pattern, ‘PAT’, or pattern list, ‘PAT#’, resource.

A bit pattern is a 64-bit image, organized as an 8-by-8 bit square, that defines a repeating design or tone. When a pattern is drawn, it is aligned so that adjacent areas of the same pattern in the same graphics port form a continuous, coordinated pattern. QuickDraw provides predefined patterns in global variables named white, black, gray, ltGray, and dkGray. The row width of a pattern is 1 byte. 
Availability
Available in Mac OS X v10.0 and later.*/
struct Pattern {
   UInt8 pat[8];
};
typedef struct Pattern Pattern;
typedef Pattern * PatPtr;
typedef PatPtr * PatHandle;

/*PenState

struct PenState {
   Point pnLoc;
   Point pnSize;
   short pnMode;
   Pattern pnPat;
};
typedef struct PenState PenState;
Fields
pnLoc

For the current graphics port at the time the GetPenState function was called, the value of that graphics port’s pnLoc field. This value is the point where QuickDraw begins drawing next. The location of the graphics pen is a point in the graphics port’s coordinate system, not a pixel in a bit image. The upper-left corner of the pen is at the pen location the graphics pen hangs below and to the right of this point.
pnSize

For the current graphics port at the time the GetPenState function was called, the value of that graphics port’s pnSize field. The graphics pen is rectangular in shape, and its width and height are specified by the values in the pnSize field. The default size is a 1-by-1 bit square; the width and height can range from 0 by 0 to 32,767 by 32,767. If either the pen width or the pen height is 0, the pen does not draw. Heights or widths of less than 0 are undefined.
pnMode

The pattern mode—that is, for the current graphics port at the time the GetPenState function was called, the value of that graphics port’s pnMode field. This value determines how the pen pattern is to affect what’s already in the bit image when lines or shapes are drawn. When the graphics pen draws, QuickDraw first determines what bits in the bit image are affected, finds their corresponding bits in the pattern, and then transfers the bits from the pattern into the image according to this mode, which specifies one of eight Boolean transfer operations. The resulting bit is stored into its proper place in the bit image.
pnPat

For the current graphics port at the time the GetPenState function was called, the pen pattern for that graphics port. This pattern determines how the bits under the graphics pen are affected when lines or shapes are drawn. 
Discussion

The GetPenState function saves the location, size, pattern, and pattern mode of the graphics pen for the current graphics port in a PenState structure, which is a data structure of type PenState. After changing the graphics pen as necessary, you can later restore these pen states with the SetPenState function. 
Availability
Available in Mac OS X v10.0 and later.*/
struct PenState {
   Point pnLoc;
   Point pnSize;
   short pnMode;
   Pattern pnPat;
};
typedef struct PenState PenState;

/*SetRect

Assigns coordinates to a rectangle. 

void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);
Parameters
r

A pointer to the rectangle to set.
left

The horizontal coordinate of the new upper-left corner of the rectangle.
top

The vertical coordinate of the new upper-left corner of the rectangle.
right

The horizontal coordinate of the new lower-right corner of the rectangle.
bottom

The vertical coordinate of the new lower-right corner of the rectangle.
Discussion

The SetRect function assigns the coordinates you specify in the left, top, right, and bottom parameters to the rectangle that you specify in the r parameter. This function is provided to help you shorten your program text. If you want a more readable text, at the expense of source text length, you can instead assign integers (or points) directly into the fields of a Rect structure.

You can use a rectangle to specify locations and sizes for various graphics operations.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/
void SetRect (
   Rect * r,
   short left,
   short top,
   short right,
   short bottom
);

/*GetPortBounds

(Deprecated. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);
Carbon Porting Notes

Use this new accessor function in place of direct access to structs.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/

Rect * GetPortBounds (
   CGrafPtr port,
   Rect * rect
);

/*EraseRect

Erases a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void EraseRect (
   const Rect * r
);
Parameters
r

The rectangle to erase.
Discussion

Using the patCopy pattern mode, the EraseRect function draws the interior of the rectangle that you specify in the r parameter with the background pattern for the current graphics port. This effectively erases the rectangle, making the shape blend into the background pattern of the graphics port. For example, use EraseRect to erase the port rectangle for a window before redrawing into the window.

This function leaves the location of the graphics pen unchanged. 
Special Considerations

The EraseRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void EraseRect (
   const Rect * r
);

/*CopyBits

Copies a portion of a bitmap or a pixel map from one graphics port or offscreen graphics world into another graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);
Parameters
srcBits

The source BitMap structure. 
dstBits

The destination BitMap structure.
srcRect

The source rectangle.
dstRect

The destination rectangle.
mode

One of the eight source modes in which the copy is to be performed. See Source, Pattern, and Arithmetic Transfer Mode Constants. The CopyBits function always dithers images when shrinking them between pixel maps on direct devices. 

When transferring pixels from a source pixel map to a destination pixel map, color QuickDraw interprets the source mode constants differently than basic QuickDraw does.

When you use CopyBits on a computer running color QuickDraw, you can also specify one of the transfer modes in the mode parameter.
maskRgn

A region to use as a clipping mask. You can pass a region handle to specify a mask region the resulting image is always clipped to this mask region and to the boundary rectangle of the destination bitmap. If the destination bitmap is the current graphics port’s bitmap, it is also clipped to the intersection of the graphics port’s clipping region and visible region. If you do not want to clip to a masking region, just pass NULL for this parameter. 
Discussion

The CopyBits function transfers any portion of a bitmap between two basic graphics ports, or any portion of a pixel map between two color graphics ports. Use CopyBits to move offscreen graphic images into an onscreen window, to blend colors for the image in a pixel map, and to shrink and expand images.

Specify a source bitmap in the srcBits parameter and a destination bitmap in the dstBits parameter. When copying images between color graphics ports, you must coerce each CGrafPort structure to a GrafPort structure, dereference the portBits fields of each, and then pass these “bitmaps” in the srcBits and dstBits parameters. If your application copies a pixel image from a color graphics port called MyColorPort, for example, you could specify (* GrafPtr(MyColorPort)).portBits in the srcBits parameter. In a CGrafPort structure, the high 2 bits of the portVersion field are set. This field, which shares the same position in a CGrafPort structure as the portBits.rowBytes field in a GrafPort structure, indicates to CopyBits that you have passed it a handle to a pixel map rather than a bitmap.

Using the srcRect and dstRect parameters, you can specify identically or differently sized source and destination rectangles; for differently sized rectangles, CopyBits scales the source image to fit the destination. If the bit image is a circle in a square source rectangle, and the destination rectangle is not square, the bit image appears as an oval in the destination. When you specify rectangles in the srcRect and dstRect parameters, use the local coordinate systems of, respectively, the source and destination graphics ports.

The CopyDeepMask function combines the functions of the CopyBits and CopyMask functions. 
Special Considerations

When you use the CopyBits function to transfer an image between pixel maps, the source and destination images may be of different pixel depths, of different sizes, and they may have different color tables. However, CopyBits assumes that the destination pixel map uses the same color table as the color table for the current GDevice structure. (This is because the Color Manager requires an inverse table for translating the color table from the source pixel map to the destination pixel map.) 

The CopyBits function applies the foreground and background colors of the current graphics port to the image in the destination pixel map (or bitmap), even if the source image is a bitmap. This causes the foreground color to replace all black pixels in the destination and the background color to replace all white pixels. To avoid unwanted coloring of the image, use the RGBForeColor function to set the foreground to black and use the RGBBackColor function to set the background to white before calling CopyBits.

The source bitmap or pixel map must not occupy more memory than half the available stack space. The stack space required by CopyBits is roughly five times the value of the rowBytes field of the source pixel map: one rowBytes value for the pixel map (or bitmap), an additional rowBytes value for dithering, another rowBytes value when stretching or shrinking the source pixel map into the destination, another rowBytes value for any color map changing, and a fifth additional rowBytes value for any color aliasing. If there is insufficient memory to complete a CopyBits operation in Color QuickDraw, the QDError function returns the result code –143.

If you use CopyBits to copy between two graphics ports that overlap, you must first use the LocalToGlobal function to convert to global coordinates, and then specify the global variable screenBits for both the srcBits and dstBits parameters.

The CopyBits function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

If you are reading directly from a NuBus video card with a base address of Fs00000 and there is not a card in the slot (s–1) below it, CopyBits reads addresses less than the base address of the pixel map. This causes a bus error. To work around the problem, remap the baseAddr field of the pixel map in your video card to at least 20 bytes above the NuBus boundary; an address link of Fs000020 precludes the problem.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void CopyBits (
   const BitMap * srcBits,
   const BitMap * dstBits,
   const Rect * srcRect,
   const Rect * dstRect,
   short mode,
   RgnHandle maskRgn
);

/*QDFlushPortBuffer

Calls the Quartz compositor to flush all new drawing in a Carbon window to the display. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);
Parameters
port

A window port. If the port has no back buffer, or if the port is an offscreen or printing port, this function does nothing.
region

An update region. Under normal conditions, you should pass NULL to avoid the overhead of additional region operations.
Discussion

In Mac OS X, drawing in a window port updates a back buffer associated with the window. Updates to this buffer are accumulated in a list called the dirty region. 

The back buffer is automatically flushed to the display each time through the event loop. When the event loop does not get control soon enough—for example, during an animation sequence—you can call this function to flush the port buffer to the device immediately. 

When you call this function, there are several different execution paths:
If the region parameter is NULL, the dirty region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the dirty region is set to empty.
If the region parameter specifies an update region, the intersection of the dirty region and the update region is flushed—along with any Quartz 2D drawing operations marked for update by calls to CGContextSynchronize—and the flushed region is subtracted from the dirty region.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void QDFlushPortBuffer (
   CGrafPtr port,
   RgnHandle region
);

/*SetPort

Changes the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPort (
   GrafPtr port
);
Parameters
port

A pointer to a GrafPort structure. Typically, you pass a pointer to a GrafPort structure that you previously saved with the GetPort function. The SetPort function sets this structure to be the current graphics port. 
Discussion

All QuickDraw drawing functions affect the bitmap of, and use the local coordinate system of, the current graphics port. Each graphics port has its own graphics pen and text characteristics, which remain unchanged when the graphics port isn’t selected as the current graphics port.

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the SetGWorld function instead of SetPort. The SetGWorld function restores the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void SetPort (
   GrafPtr port
);

/*GetPort

Saves the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPort (
   GrafPtr * port
);
Parameters
port

On return, a pointer to a GrafPort structure for the current graphics port. If the current graphics port is a color graphics port, GetPort coerces its CGrafPort structure into a GrafPort structure. 
Discussion

When your application runs in Color QuickDraw or uses offscreen graphics worlds, it should use the GetGWorld function instead of GetPort. The GetGWorld function saves the current graphics port for basic and color graphics ports as well as offscreen graphics worlds. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPort (
   GrafPtr * port
);

/*GlobalToLocal

Converts the coordinates of a point from global coordinates to the local coordinates of the current graphics port (basic or color). (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GlobalToLocal (
   Point * pt
);
Parameters
pt

A pointer to a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]). On return, this point is converted to local coordinates.
Discussion

The GlobalToLocal procedure takes a point expressed in global coordinates (where the upper-left corner of the main screen has coordinates [0,0]) and converts it into the local coordinates of the current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GlobalToLocal (
   Point * pt
);

/*GetPenState

Determines the graphics pen’s location, size, pattern, and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void GetPenState (
   PenState * pnState
);
Parameters
pnState

On return, a pointer to a PenState structure holding information about the graphics pen. The GetPenState function saves the location, size, pattern, and pattern mode of the graphics pen for the current graphics port in this structure. 
Discussion

After changing the graphics pen as necessary, restore these pen states with the SetPenState function. 

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void GetPenState (
   PenState * pnState
);

/*PenSize

Sets the dimensions of the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenSize (
   short width,
   short height
);
Parameters
width

The pen width, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
height

The pen height, as an integer from 0 to 32,767. If you set the value to 0, the pen does not draw. Values less than 0 are undefined.
Discussion

The PenSize function sets the width that you specify in the width parameter and the height that you specify in the height parameter for the graphics pen in the current graphics port. All subsequent calls to the Line and LineTo functions and to the functions that draw framed shapes in the current graphics port use the new pen dimensions.

You can get the current pen dimensions from the pnSize field of the current graphics port, where the width and height are stored as a Point structure.

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenSize (
   short width,
   short height
);

/*PenPat

Sets the bit pattern to be used by the graphics pen in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PenPat (
   const Pattern * pat
);
Parameters
pat

A bit pattern, as defined by a Pattern structure. 
Discussion

The PenPat function sets the graphics pen to use the bit pattern defined in the Pattern structure that you specify in the pat parameter. (The standard patterns white, black, gray, ltGray, and dkGray are predefined; the initial bit pattern for the pen is black.) This pattern is stored in the pnPat field of a GrafPort structure. The QuickDraw painting functions (such as PaintRect) also use the pen’s pattern when drawing a shape.

The PenPat function also sets a bit pattern for the graphics pen in a color graphics port. The PenPat function creates a handle, of type PixPatHandle, for the bit pattern and stores this handle in the pnPixPat field of the CGrafPort structure. This pattern always uses the graphics port’s current foreground and background colors.

To define your own patterns, you typically create pattern, ‘PAT’, or pattern list, ‘PAT#’, resources. 
Special Considerations

The PenPat function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PenPat (
   const Pattern * pat
);

/*SetPenState

Restores the state of the graphics pen that was saved with the GetPenState function. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void SetPenState (
   const PenState * pnState
);
Parameters
pnState

A PenState structure previously created with the GetPenState function. The SetPenState function sets the graphics pen’s location, size, pattern, and pattern mode in the current graphics port to the values stored in this structure. 
Discussion

This pen-manipulation function uses the local coordinate system of the current graphics port. Remember that each graphics port has its own pen, the state of which is stored in several fields of its GrafPort or CGrafPort structure. If you draw in one graphics port, change to another, and return to the first, the pen for the first graphics port has the same state as when you left it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void SetPenState (
   const PenState * pnState
);

/*GetQDGlobalsGray

(Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

Pattern * GetQDGlobalsGray (
   Pattern * gray
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
Pattern * GetQDGlobalsGray (
   Pattern * gray
);

/*FrameRect

Draws an outline inside a rectangle. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void FrameRect (
   const Rect * r
);
Parameters
r

The rectangle to frame.
Discussion

Using the pattern, pattern mode, and size of the graphics pen for the current graphics port, the FrameRect function draws an outline just inside the rectangle that you specify in the r parameter. The outline is as wide as the pen width and as tall as the pen height. The pen location does not change.

If a region is open and being formed, the outside outline of the new rectangle is mathematically added to the region’s boundary. 
Special Considerations

The FrameRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/
void FrameRect (
   const Rect * r
);

/*PaintRect

Paints a rectangle with the graphics pen’s pattern and pattern mode. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void PaintRect (
   const Rect * r
);
Parameters
r

The rectangle to paint.
Discussion

The PaintRect function draws the interior of the rectangle that you specify in the r parameter with the pen pattern for the current graphics port, according to the pattern mode for the current graphics port. The pen location does not change.

Use the FillRect to draw the interior of a rectangle with a pen pattern different from that for the current graphics port. 
Special Considerations

The PaintRect function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void PaintRect (
   const Rect * r
);


/*PtInRect

Determines whether a pixel below is enclosed in a rectangle. 

Boolean PtInRect (
   Point pt,
   const Rect * r
);
Parameters
pt

The point to test.
r

The rectangle to test.
Return Value

TRUE if the pixel below and to the right of the point specified in the pt parameter is enclosed in the rectangle specified in the r parameter. FALSE if it is not. 
Discussion

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

Boolean PtInRect (
   Point pt,
   const Rect * r
);

/*RGBForeColor

Changes the color of the “ink” used for framing and painting. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void RGBForeColor (
   const RGBColor * color
);
Parameters
color

An RGBColor structure. 
Discussion

If the current port is defined by a CGrafPort structure, QuickDraw supplies its rgbFgColor field with the RGB value that you specify in the color parameter, and places the pixel value most closely matching that color in the fgColor field. For indexed devices, the pixel value is an index to the current device’s CLUT. For direct devices, the value is the 16-bit or 32-bit equivalent to the RGB value.

If the current port is defined by a GrafPort structure, basic QuickDraw supplies its fgColor field with a color value determined by taking the high bit of each of the red, green, and blue components of the color that you supply in the color parameter. Basic QuickDraw uses that 3-bit number to select a color from its eight-color system. 

You can also use Palette Manager functions to set the foreground color.

To determine the current foreground color, use the GetForeColor function.

QuickDraw ignores the foreground and background colors when your application draws with a pixel pattern. Assign a pixel pattern to the foreground pattern used by the graphics pen; by using the BackPixPat function to assign a pixel pattern as the background pattern for the current color graphics port; and by using the FillCRect, FillCOval, FillCRoundRect, FillCArc, FillCRgn, and FillCPoly functions to fill shapes with a pixel pattern. 
Special Considerations

The RGBForeColor function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Version Notes

The RGBForeColor function is available for basic QuickDraw only in System 7. To set the foreground color for basic graphics ports on older versions of system software, use the ForeColor function.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void RGBForeColor (
   const RGBColor * color
);

/*NewRgn

Begins creating a new region. (Deprecated in Mac OS X v10.4.)

RgnHandle NewRgn ();
Return Value

A handle to the new region. 
Discussion

The NewRgn function allocates space for a new, variable-size region and initializes it to the empty region defined by the rectangle (0,0,0,0). This is the only function that creates a new region; other functions merely alter the size or shape of existing regions.

To begin defining a region, use the OpenRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

The NewRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.

Use the Memory Manager function MaxMem to determine whether the memory for the region is valid before using NewRgn.

Ensure that the memory for a region is valid before calling this function to manipulate that region if there isn’t sufficient memory, the system may crash. Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in color QuickDraw. Before defining a region, you can use the Memory Manager function MaxMem to determine whether the memory for the region is valid. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you record drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in color QuickDraw, the QDError function returns the result code regionTooBigError.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
RgnHandle NewRgn ();


/*OpenRgn

Begins defining a region. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void OpenRgn ();
Discussion

The OpenRgn function allocates temporary memory to start saving lines and framed shapes for processing as a region definition. Call OpenRgn only after initializing a region with the NewRgn function.

The NewRgn function stores the definition for a region in a Region structure.

While a region is open, all calls to Line, LineTo, and the functions that draw framed shapes (except arcs) affect the outline of the region. Only the line endpoints and shape boundaries affect the region definition—the pattern mode, pattern, and size do not affect it.

When you are finished defining the region, call the CloseRgn function.

The OpenRgn function calls HidePen, so no drawing occurs on the screen while the region is open (unless you call ShowPen just after OpenRgn, or you called ShowPen previously without balancing it by a call to HidePen). Since the pen hangs below and to the right of the pen location, drawing lines with even the smallest pen changes pixels that lie outside the region you define.

The outline of a region is mathematically defined and infinitely thin, and it separates the bit or pixel image into two groups of pixels: those within the region and those outside it. 

A region should consist of one or more closed loops. Each framed shape itself constitutes a loop. Any lines drawn with the Line or LineTo function should connect with each other or with a framed shape. Even if the onscreen presentation of a region is clipped, the definition of a region is not; you can define a region anywhere on the coordinate plane with complete disregard for the location of various graphics port entities on that plane.

When a region is open, the current graphics port’s rgnSave field contains a handle to information related to the region definition. If you want to temporarily disable the collection of lines and shapes, you can save the current value of this field, set the field to NULL, and later restore the saved value to resume the region definition. Also, calling SetPort while a region is being formed discontinues formation of the region until another call to SetPort resets the region’s original graphics port.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. You can determine the current size of an existing region by calling the Memory Manager function GetHandleSize. When you structure drawing operations in an open region, the resulting region description may overflow the 32 KB or 64 KB limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. 

Do not call OpenRgn while another region or a polygon is already open. When you are finished constructing the region, use the CloseRgn function, which is described next.

The OpenRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void OpenRgn ();

/*MoveTo

Moves the graphics pen to a particular location in the current graphics port. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void MoveTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new position.
v

The vertical coordinate of the graphics pen’s new position.
Discussion

The MoveTo function changes the graphics pen’s current location to the new horizontal coordinate you specify in the h parameter and the new vertical coordinate you specify in the v parameter. Specify the new location in the local coordinates of the current graphics port. The MoveTo function performs no drawing. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/
void MoveTo (
   short h,
   short v
);

/*LineTo

Draws a line from the graphics pen’s current location to a new location. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void LineTo (
   short h,
   short v
);
Parameters
h

The horizontal coordinate of the graphics pen’s new location.
v

The vertical coordinate of the graphics pen’s new location.
Discussion

The LineTo function draws a line from the graphics pen’s current location in the current graphics port to the new location (h,v), which you specify in the local coordinates of the current graphics port. If you are using LineTo to draw a region or polygon, its outline is infinitely thin and is not affected by the values of the pnSize, pnMode, or pnPat field of the graphics port. 
Special Considerations

The LineTo function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Deprecated in Mac OS X v10.4.
Available in Mac OS X v10.0 and later.
Declared In
Quickdraw.h*/


void LineTo (
   short h,
   short v
);

/*CloseRgn

Organizes a collection of lines and shapes into a region definition. (Deprecated in Mac OS X v10.4. Use Quartz 2D instead; see Quartz Programming Guide for QuickDraw Developers.)

void CloseRgn (
   RgnHandle dstRgn
);
Parameters
dstRgn

The handle to the region to close. This handle should be a region handle returned by the NewRgn function. 
Discussion

The CloseRgn function stops the collection of lines and framed shapes, organizes them into a region definition, and saves the result in the region whose handle you pass in the dstRgn parameter. 

The CloseRgn function does not create the destination region; you must have already allocated space for it by using the OpenRgn function. The CloseRgn function calls the ShowPen function, balancing the call to the HidePen function made by OpenRgn. 

When you no longer need the memory occupied by the region, use the DisposeRgn function.

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Special Considerations

Regions are limited to 32 KB in size in basic QuickDraw and 64 KB in Color QuickDraw. When you structure drawing operations in an open region, the resulting region description may overflow this limit. Should this happen in Color QuickDraw, the QDError function returns the result code regionTooBigError. Since the resulting region is potentially corrupt, the CloseRgn function returns an empty region if it detects QDError has returned regionTooBigError.

The CloseRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void CloseRgn (
   RgnHandle dstRgn
);


/*DisposeRgn

Releases the memory occupied by a region. (Deprecated in Mac OS X v10.4.)

void DisposeRgn (
   RgnHandle rgn
);
Parameters
rgn

A handle to the region to dispose. This handle should be a region handle returned by the NewRgn function. 
Discussion

Use DisposeRgn only after you are completely through with a region. 
Special Considerations

The DisposeRgn function may move or purge memory blocks in the application heap; do not call this function at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Quickdraw.h*/

void DisposeRgn (
   RgnHandle rgn
);

/*InsetRect

Shrinks or expands a rectangle. 

void InsetRect (
   Rect * r,
   short dh,
   short dv
);
Parameters
r

A pointer to the rectangle to alter.
dh

The horizontal distance to move the left and right sides in toward or outward from the center of the rectangle.
dv

The vertical distance to move the top and bottom sides in toward or outward from the center of the rectangle.
Discussion

The InsetRect function shrinks or expands the rectangle that you specify in the r parameter: the left and right sides are moved in by the amount you specify in the dh parameter; the top and bottom are moved toward the center by the amount you specify in the dv parameter. If the value you pass in dh or dv is negative, the appropriate pair of sides is moved outward instead of inward. The effect is to alter the size by 2*dh horizontally and 2*dv vertically, with the rectangle remaining centered in the same place on the coordinate plane.

If the resulting width or height becomes less than 1, the rectangle is set to the empty rectangle (0,0,0,0).

If the points or rectangles supplied to this function are defined in a graphics port other than your current graphics port, you must convert them to the local coordinate system of your current graphics port. You can accomplish this by using the SetPort function to change to the graphics port containing the points or rectangles, using the LocalGlobal function to convert their locations to global coordinates, using SetPort to return to your starting graphics port, and then using the GlobalToLocal function to convert the locations of points or rectangles to the local coordinates of your current graphics port. 
Declared In
Quickdraw.h*/

void InsetRect (
   Rect * r,
   short dh,
   short dv
);

#ifdef __cplusplus
}
#endif

#endif