#ifndef IMAGECODEC_H
#define IMAGECODEC_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef IMAGECOMPRESSION_H
#include <QuickTime/ImageCompression.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


typedef Fixed fixed;

#include <HYS/QuickTime/ImageCodec.h>
#include <ADD/QuickTime/ImageCodec.h>

/*ImageSubCodecDecompressRecord Values

Constants passed to ImageSubCodecDecompressRecord.

enum {
   kCodecFrameTypeUnknown        = 0,
   kCodecFrameTypeKey            = 1,
   kCodecFrameTypeDifference     = 2,
   kCodecFrameTypeDroppableDifference = 3
};
Constants
kCodecFrameTypeUnknown

The frame type is unknown. 

Available in Mac OS X v10.0 and later.
kCodecFrameTypeKey

This is a key frame. 

Available in Mac OS X v10.0 and later.
kCodecFrameTypeDifference

This is a difference frame. 

Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

enum {
   kCodecFrameTypeUnknown        = 0,
   kCodecFrameTypeKey            = 1,
   kCodecFrameTypeDifference     = 2,
   kCodecFrameTypeDroppableDifference = 3
};


/*Codec Properties

Constants that represent the properties of codecs.

codecImageBufferIsInPCIMemory = 1L << 5
codecSupportsOutOfOrderDisplayTimes = 1L << 8
codecSupportsScheduledBackwardsPlaybackWithDifferenceFrames = 1L << 9
codecConditionNewMask         = 1L << 6
codecInfoResourceType         = 'cdci'
codecInterfaceVersion         = 2
codecSuggestedBufferSentinel  = 'sent'
codecMinimumDataSize          = 32768L
codecImageBufferIsInPCIMemory

Codec image buffer is across a PCI bus; byte writes are bad. 

Available in Mac OS X v10.0 and later.
codecSupportsOutOfOrderDisplayTimes

Codec supports frames queued in one order for display in a different order, for example IPB content. 

Available in Mac OS X v10.3 and later.
codecSupportsScheduledBackwardsPlaybackWithDifferenceFrames

Codec can use additional buffers to minimize redecoding during backwards playback. 

Available in Mac OS X v10.3 and later.
codecInfoResourceType

Codec info resource type. 

Available in Mac OS X v10.0 and later.
codecInterfaceVersion

High word returned in component GetVersion. 

Available in Mac OS X v10.0 and later.
codecSuggestedBufferSentinel

Codec public resource containing suggested data pattern to put past end of data buffer. 

Available in Mac OS X v10.2 and later.*/
enum {
codecImageBufferIsInPCIMemory = 1L << 5 ,
codecSupportsOutOfOrderDisplayTimes = 1L << 8,
codecSupportsScheduledBackwardsPlaybackWithDifferenceFrames = 1L << 9,
codecConditionNewMask         = 1L << 6,
codecInfoResourceType         = 'cdci',
codecInterfaceVersion         = 2,
codecSuggestedBufferSentinel  = 'sent',
codecMinimumDataSize          = 32768L
};

////typedef

/*ImageSubCodecDecompressRecord

Contains information needed for decompressing a frame.

struct ImageSubCodecDecompressRecord {
   Ptr                      baseAddr;
   long                     rowBytes;
   Ptr                      codecData;
   ICMProgressProcRecord    progressProcRecord;
   ICMDataProcRecord        dataProcRecord;
   void *                   userDecompressRecord;
   UInt8                    frameType;
   UInt8                    pad[3];
   long                     priv[2];
};
Fields
baseAddr
Discussion

The address of the destination pixel map, which includes adjustment for the offset. Note that if the bit depth of the pixel map is less than 8, your image decompressor component must adjust for the bit offset.
rowBytes
Discussion

The offset in bytes from one row of the destination pixel map to the next. The value of the rowBytes field must be less than 0x4000.
codecData
Discussion

A pointer to the data to be decompressed.
progressProcRecord
Discussion

An ICMProgressProcRecord structure that specifies a progress function. This function reports on the progress of a decompression operation. If there is no progress function, the Image Compression Manager sets the progressProc field in the ICMProgressProcRecord structure to NIL.
dataProcRecord
Discussion

An ICMDataProcRecord structure that specifies a data-loading function. If the data to be decompressed is not all in memory, your component can call this function to load more data. If there is no data-loading function, the Image Compression Manager sets the dataProc field in the ICMDataProcRecord structure to NIL, and the entire image must be in memory at the location specified by the codecData field of the ImageSubCodecDecompressRecord structure.
userDecompressRecord
Discussion

A pointer to storage for the decompression operation. The storage is allocated by the base image decompressor after it calls ImageCodecInitialize. The size of the storage is determined by the decompressRecordSize field of the ImageSubCodecDecompressCapabilities structure that is returned by ImageCodecInitialize. Your image decompressor component should use this storage to store any additional information needed about the frame in order to decompress it.
frameType
Discussion

A constant (see below) that indicates the frame type. See these constants: 
kCodecFrameTypeUnknown
kCodecFrameTypeKey
kCodecFrameTypeDifference
kCodecFrameTypeDroppableDifference
pad
Discussion

Unused.
priv
Discussion

Private to QuickTime; do not use.
Related Functions
ImageCodecBeginBand
ImageCodecDrawBand
ImageCodecEndBand
ImageCodecMPDrawBandProc 
Declared In
ImageCodec.h*/
struct ImageSubCodecDecompressRecord {
   Ptr                      baseAddr;
   long                     rowBytes;
   Ptr                      codecData;
   ICMProgressProcRecord    progressProcRecord;
   ICMDataProcRecord        dataProcRecord;
   void *                   userDecompressRecord;
   UInt8                    frameType;
   UInt8                    pad[3];
   long                     priv[2];
};

typedef struct ImageSubCodecDecompressRecord ImageSubCodecDecompressRecord;

/*CodecDecompressParams

The basic parameter block that is passed to a decompressor.

struct CodecDecompressParams {
   ImageSequence              sequenceID;
   ImageDescriptionHandle     imageDescription;
   Ptr                        data;
   long                       bufferSize;
   long                       frameNumber;
   long                       startLine;
   long                       stopLine;
   long                       conditionFlags;
   CodecFlags                 callerFlags;
   CodecCapabilities *        capabilities;
   ICMProgressProcRecord      progressProcRecord;
   ICMCompletionProcRecord    completionProcRecord;
   ICMDataProcRecord          dataProcRecord;
   CGrafPtr                   port;
   PixMap                     dstPixMap;
   BitMapPtr                  maskBits;
   PixMapPtr                  mattePixMap;
   Rect                       srcRect;
   MatrixRecord *             matrix;
   CodecQ                     accuracy;
   short                      transferMode;
   ICMFrameTimePtr            frameTime;
   long                       reserved[1];
   SInt8                      matrixFlags;
   SInt8                      matrixType;
   Rect                       dstRect;
   UInt16                     majorSourceChangeSeed;
   UInt16                     minorSourceChangeSeed;
   CDSequenceDataSourcePtr    sourceData;
   RgnHandle                  maskRegion;
   OSType **                  wantedDestinationPixelTypes;
   long                       screenFloodMethod;
   long                       screenFloodValue;
   short                      preferredOffscreenPixelSize;
   ICMFrameTimeInfoPtr        syncFrameTime;
   Boolean                    needUpdateOnTimeChange;
   Boolean                    enableBlackLining;
   Boolean                    needUpdateOnSourceChange;
   Boolean                    pad;
   long                       unused;
   CGrafPtr                   finalDestinationPort;
   long                       requestedBufferWidth;
   long                       requestedBufferHeight;
   Rect                       displayableAreaOfRequestedBuffer;
   Boolean                    requestedSingleField;
   Boolean                    needUpdateOnNextIdle;
   Boolean                    pad2[2];
   fixed                      bufferGammaLevel;
   UInt32                     taskWeight;
   OSType                     taskName;
};
Fields
sequenceID
Discussion

Contains the unique sequence identifier. If the image to be decompressed is part of a sequence, this field contains the sequence identifier that was assigned by DecompressSequenceBegin. If the image is not part of a sequence, this field is set to 0.
imageDescription
Discussion

Contains a handle to the ImageDescription that describes the image to be decompressed.
data
Discussion

Points to the compressed image data. This must be a 32-bit clean address. The bufferSize field indicates the size of this data buffer. If the entire compressed image does not fit in memory, the application should provide a data-loading function, identified by the dataProc field of the data-loading function structure stored in the dataProcRecord field. This field is used only by ImageCodecBandDecompress.
bufferSize
Discussion

Specifies the size of the image data buffer. This field is used only by ImageCodecBandDecompress.
frameNumber
Discussion

Contains a frame identifier. Indicates the relative frame number within the sequence. The Image Compression Manager increments this value for each frame in the sequence. This field is used only by ImageCodecBandDecompress.
startLine
Discussion

Specifies the starting line for the band. The line number refers to the pixel row in the image, starting from the top of the image. The first row in the image is row number 0. This field is used only by ImageCodecBandDecompress.
stopLine
Discussion

Specifies the ending line for the band. The line number refers to the pixel row in the image, starting from the top of the image. The first row is row number 0. The image band includes the row specified by this field. So, to define a band that contains one row of pixels at the top of an image, you set the startLine field to 0 and the stopLine field to 1. This field is used only by ImageCodecBandDecompress.
conditionFlags
Discussion

Contains flags (see below) that identify the condition under which your component has been called (in order to save the component some work). The flags in this field are passed to the component by ImageCodecBandCompress and ImageCodecPreDecompress when conditions change, to save it some work. In addition, these fields contain information about actions taken by your component. See these constants: 
codecConditionFirstBand
codecConditionLastBand
codecConditionFirstFrame
codecConditionNewDepth
codecConditionNewTransform
codecConditionNewSrcRect
codecConditionNewMatte
codecConditionNewTransferMode
codecConditionNewClut
codecConditionNewAccuracy
codecConditionNewDestination
codecConditionCodecChangedMask
codecConditionFirstScreen
codecConditionDoCursor
codecConditionCatchUpDiff
codecConditionMaskMayBeChanged
codecConditionToBuffer
callerFlags
Discussion

Contains flags (see below) that provide further control information. This field is used only by ImageCodecBandCompress. See these constants: 
codecFlagUpdatePrevious
codecFlagWasCompressed
codecFlagUpdatePreviousComp
codecFlagLiveGrab
capabilities
Discussion

Points to a CodecCapabilities structure. The Image Compression Manager uses this parameter to determine the capabilities of your decompressor component. This field is used only by ImageCodecPreDecompress.
progressProcRecord
Discussion

Contains a ICMProgressProcRecord structure. During the decompression operation, your decompressor may occasionally call a function that the application provides in order to report your progress. This field contains a structure that identifies the progress function. If the progressProc field of this structure is set to NIL, the application did not provide a progress function. This field is used only by ImageCodecBandDecompress.
completionProcRecord
Discussion

Contains an ICMCompletionProcRecord structure. This field governs whether you perform the decompression asynchronously. If the completionProc field in this structure is set to NIL, perform the decompression synchronously. If this field is not NIL, it specifies an application completion function. Perform the decompression asynchronously and call that completion function when your component is finished. If this field has a value of -1, perform the operation asynchronously but do not call the application's completion function. This field is used only by ImageCodecBandDecompress.
dataProcRecord
Discussion

Contains an ICMDataProcRecord structure. If the data stream is not all in memory, your component may call an application function that loads more compressed data. This field contains a structure that identifies that data-loading function. If the application did not provide a data-loading function, the dataProc field in this structure is set to NIL. In this case, the entire image must be in memory at the location specified by the data field. This field is used only by ImageCodecBandDecompress.
port
Discussion

Points to the color graphics port that receives the decompressed image.
dstPixMap
Discussion

Points to the pixel map where the decompressed image is to be displayed. The GDevice global variable is set to the destination graphics device. The contents of this pixel map differ from a standard pixel map in two ways. First, the rowBytes field is a full 16-bit value; the high-order bit is not necessarily set to 1. Second, the baseAddr field must contain a 32-bit clean address.
maskBits
Discussion

Contains an update mask. If your component can mask result data, use this mask to indicate which pixels in the destination pixel map to update. Your component indicates whether it can mask with the codecCanMask flag in the flags field of the CodecCapabilities structure referred to by the capabilities field. This field is updated in response to the ImageCodecPreDecompress request. If the mask has not changed since the last ImageCodecBandDecompress request, the codecConditionCodecChangedMask flag in the conditionFlags field is set to 0. This field is used only by ImageCodecBandDecompress.
mattePixMap
Discussion

Points to a pixel map that contains a blend matte. The matte can be defined at any supported pixel depth; the matte depth need not correspond to the source or destination depths. The matte must be in the coordinate system of the source image. If the application does not want to apply a blend matte, this field is set to NIL. The contents of this pixel map differ from a standard pixel map in two ways. First, the rowBytes field is a full 16-bit value; the high-order bit is not necessarily set to 1. Second, the baseAddr field must contain a 32-bit clean address. This field is used only by ImageCodecBandDecompress.
srcRect
Discussion

Points to a rectangle defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the compressed image, which is defined by the width and height fields of the image description structure referred to by the imageDescription field.
matrix
Discussion

Points to a matrix structure that specifies how to transform the image during decompression.
accuracy
Discussion

Constant (see below) that specifies the accuracy desired in the decompressed image. Values for this parameter are on the same scale as compression quality; see CompressImage. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
transferMode
Discussion

Specifies the QuickDraw transfer mode for the operation; see Graphics Transfer Modes.
frameTime
Discussion

Contains a pointer to an ICMFrameTimeRecord structure. This structure contains a frame's time information for scheduled asynchronous decompression operations.
matrixFlags
Discussion

Flag (see below) specifying the transformation matrix. Set to 0 for no transformation. See these constants: 
matrixFlagScale2x
matrixFlagScale1x
matrixFlagScaleHalf
matrixType
Discussion

Contains the type of the transformation matrix, as returned by GetMatrixType.
dstRect
Discussion

The destination rectangle. It is the result of transforming the source rectangle (the srcRect parameter) by the transformation matrix (the matrix parameter).
majorSourceChangeSeed
Discussion

Contains an integer value that is incremented each time a data source is added or removed. This provides a fast way for a codec to know when it needs to redetermine which data source inputs are available.
minorSourceChangeSeed
Discussion

Contains an integer value that is incremented each time a data source is added or removed, or the data contained in any of the data sources changes. This provides a way for a codec to know if the data available to it has changed.
sourceData
Discussion

Contains a pointer to a CDSequenceDataSource structure. This structure contains a linked list of all data sources. Because each data source contains a link to the next data source, a codec can access all data sources from this field.
maskRegion
Discussion

If the maskRegion field is not NIL, it contains a QuickDraw region that is equivalent to the bit map contained in the maskBits field. For some codecs, using the QuickDraw region may be more convenient than the mask bit map.
wantedDestinationPixelTypes
Discussion

Filled in by the codec during the execution of ImageCodecPreDecompress. Contains a handle to a zero-terminated list of non-RGB pixels that the codec can decompress to. Leave set to NIL if the codec does not support non-RGB pixel spaces. The ICM copies this data structure, so it is up to the codec to dispose of it later. Since the predecompress call can be called often, it is suggested that codecs allocate this handle during the Open function and dispose of it during the Close function.
screenFloodMethod
Discussion

A constant (see below) for codecs that require key-color flooding. See these constants: 
kScreenFloodMethodNone
kScreenFloodMethodKeyColor
kScreenFloodMethodAlpha
screenFloodValue
Discussion

If screenFloodMethod is kScreenFloodMethodKeyColor, contains the index of the color that should be used to flood the image area on screen when a refresh occurs. This is valid for both indexed and direct screen devices (e.g., for devices with 16 bit depth, it should contain the 5-5-5 RGB value). If screenFloodMethod is kScreenFloodMethodAlpha, contains the value that the alpha channel should be flooded with.
preferredOffscreenPixelSize
Discussion

Should be filled in ImageCodecPreDecompress with the preferred depth of an offscreen buffer should the ICM have to create one. It is not guaranteed that an offscreen buffer will actually be of this depth. A codec should still be sure to specify what depths it can decompress to by using the capabilities field. A codec might use this field if if was capable of decompressing to several depths, but was faster decompressing to a particular depth.
syncFrameTime
Discussion

A pointer to an ICMFrameTimeInfo structure. This structure contains timing information about the display of the frame.
needUpdateOnTimeChange
Discussion

Undocumented
enableBlackLining
Discussion

If TRUE, indicates that the client has requested blacklining (displaying every other line of the image). Blacklining increases the speed of movie playback while decreasing the image quality.
needUpdateOnSourceChange
Discussion

Undocumented
pad
Discussion

Unused.
unused
Discussion

Unused.
finalDestinationPort
Discussion

Undocumented
requestedBufferWidth
Discussion

Specifies the width of the image buffer to use, in pixels. For this value to be used, the codecWantsSpecialScaling flag in CodecCapabilities must be set.
requestedBufferHeight
Discussion

Specifies the height of the image buffer to use, in pixels. For this value to be used, the codecWantsSpecialScaling flag in CodecCapabilities must be set.
displayableAreaOfRequestedBuffer
Discussion

This field can be used to prevent parts of the requested buffer from being displayed. When the codecWantsSpecialScaling flag is set, this rectangle can be filled in to indicate what portion of the requested buffer's width and height should be used. The buffer rectangle created by the requested buffer is always based at (0,0), so this coordinate system is also used by displayableAreaOfRequestedBuffer. If this field is not filled in, a default value of (0,0,0,0) is used, and the entire buffer is displayed. Use this field if you are experiencing edge problems with FlashPix images.
requestedSingleField
Discussion

Undocumented
needUpdateOnNextIdle
Discussion

Undocumented
pad2
Discussion

Unused.
bufferGammaLevel
Discussion

The gamma level of the data buffer.
taskWeight
Discussion

The preferred weight for multiprocessing tasks implementing this operation. You should assign a value by means of the Mac OS function MPSetTaskWeight.
taskName
Discussion

The preferred type for multiprocessing tasks implementing this operation. You should assign a value by means of the Mac OS function MPSetTaskType.
Discussion

The Image Compression Manager creates the decompression parameters structure, and your image decompressor component is required only to provide values for the wantedDestinationPixelSize and wantedDestinationPixelTypes fields of the structure. Your image decompressor component can also modify other fields if necessary. For example, if it can scale images, it must set the codecCapabilityCanScale flag in the capabilities field of the structure.
Version Notes

Some of the fields in CodecDecompressParams were added for various versions of QuickTime starting with version 2.1. See comments in the C interface file for details.
Related Functions
ImageCodecBandDecompress
ImageCodecBeginBand
ImageCodecEffectBegin
ImageCodecEffectSetup
ImageCodecNewImageBufferMemory
ImageCodecNewImageGWorld
ImageCodecPreDecompress
ImageCodecPreflight 
Declared In
ImageCodec.h*/
struct CodecDecompressParams {
   ImageSequence              sequenceID;
   ImageDescriptionHandle     imageDescription;
   Ptr                        data;
   long                       bufferSize;
   long                       frameNumber;
   long                       startLine;
   long                       stopLine;
   long                       conditionFlags;
   CodecFlags                 callerFlags;
   CodecCapabilities *        capabilities;
   ICMProgressProcRecord      progressProcRecord;
   ICMCompletionProcRecord    completionProcRecord;
   ICMDataProcRecord          dataProcRecord;
   CGrafPtr                   port;
   PixMap                     dstPixMap;
   BitMapPtr                  maskBits;
   PixMapPtr                  mattePixMap;
   Rect                       srcRect;
   MatrixRecord *             matrix;
   CodecQ                     accuracy;
   short                      transferMode;
   ICMFrameTimePtr            frameTime;
   long                       reserved[1];
   SInt8                      matrixFlags;
   SInt8                      matrixType;
   Rect                       dstRect;
   UInt16                     majorSourceChangeSeed;
   UInt16                     minorSourceChangeSeed;
   CDSequenceDataSourcePtr    sourceData;
   RgnHandle                  maskRegion;
   OSType **                  wantedDestinationPixelTypes;
   long                       screenFloodMethod;
   long                       screenFloodValue;
   short                      preferredOffscreenPixelSize;
   ICMFrameTimeInfoPtr        syncFrameTime;
   Boolean                    needUpdateOnTimeChange;
   Boolean                    enableBlackLining;
   Boolean                    needUpdateOnSourceChange;
   Boolean                    pad;
   long                       unused;
   CGrafPtr                   finalDestinationPort;
   long                       requestedBufferWidth;
   long                       requestedBufferHeight;
   Rect                       displayableAreaOfRequestedBuffer;
   Boolean                    requestedSingleField;
   Boolean                    needUpdateOnNextIdle;
   Boolean                    pad2[2];
   fixed                      bufferGammaLevel;
   UInt32                     taskWeight;
   OSType                     taskName;
};
typedef struct CodecDecompressParams CodecDecompressParams;

/*ImageCodecGetParameterList

Returns a parameter description atom container for a specified effect component instance.

ComponentResult ImageCodecGetParameterList (
   ComponentInstance    ci,
   QTAtomContainer      *parameterDescription );
Parameters
ci

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
parameterDescription

The returned atom container for this component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the parameter description for the effect specified by the component instance ci, as a handle containing an 'atms' resource of ID 1. The handle should be detached if it has been read in from a resource. Each parameter of the effect is described in the parameter description, with details of its name, type, legal values and hints about how a user interface to the parameter should be constructed.
Special Considerations

The calling application is responsible for disposing of the QT atom container returned in parameterDescription. The application should do this by calling QTDisposeAtomContainer once it has finished using the parameter description.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

ComponentResult ImageCodecGetParameterList (
   ComponentInstance    ci,
   QTAtomContainer      *parameterDescription );





#ifdef __cplusplus
}
#endif
#endif