//inc
#ifndef IMAGECOMPRESSION_H
#define IMAGECOMPRESSION_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif


#include <OpenGL/OpenGL.h>
#include <QuartzCore/CoreVideo.h>

#include <HYS/QuickTime/ImageCompression.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CodecInfo Values

Constants passed to CodecInfo.

enum {
   codecInfoDepth1               = (1L << 0),
   /* compressed data at 1 bpp depth available *
   codecInfoDepth2               = (1L << 1),
   /* compressed data at 2 bpp depth available *
   codecInfoDepth4               = (1L << 2),
   /* compressed data at 4 bpp depth available *
   codecInfoDepth8               = (1L << 3),
   /* compressed data at 8 bpp depth available *
   codecInfoDepth16              = (1L << 4),
   /* compressed data at 16 bpp depth available *
   codecInfoDepth32              = (1L << 5),
   /* compressed data at 32 bpp depth available *
   codecInfoDepth24              = (1L << 6),
   /* compressed data at 24 bpp depth available *
   codecInfoDepth33              = (1L << 7),
   /* compressed data at 1 bpp monochrome depth  available *
   codecInfoDepth34              = (1L << 8),
   /* compressed data at 2 bpp grayscale depth available *
   codecInfoDepth36              = (1L << 9),
   /* compressed data at 4 bpp grayscale depth available *
   codecInfoDepth40              = (1L << 10),
   /* compressed data at 8 bpp grayscale depth available *
   codecInfoStoresClut           = (1L << 11),
   /* compressed data can have custom cluts *
   codecInfoDoesLossless         = (1L << 12),
   /* compressed data can be stored in lossless format *
   codecInfoSequenceSensitive    = (1L << 13) /* compressed data is sensitive to out of sequence decoding *
};
Constants
codecInfoDepth1

Compressed data available at 1 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth2

Compressed data available at 2 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth4

Compressed data available at 4 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth8

Compressed data available at 8 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth16

Compressed data available at 16 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth32

Compressed data available at 32 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth24

Compressed data available at 24 bit-per-pixel depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth33

Compressed data available at 1 bit-per-pixel monochrome depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth34

Compressed data available at 2 bit-per-pixel grayscale depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth36

Compressed data available at 4 bit-per-pixel grayscale depth. 

Available in Mac OS X v10.0 and later.
codecInfoDepth40

Compressed data available at 8 bit-per-pixel grayscale depth. 

Available in Mac OS X v10.0 and later.
codecInfoStoresClut

Compressed data can have custom color lookup tables. 

Available in Mac OS X v10.0 and later.
codecInfoDoesLossless

Compressed data can be stored in lossless format. 

Available in Mac OS X v10.0 and later.*/

enum {
   codecInfoDepth1               = (1L << 0),
   /* compressed data at 1 bpp depth available */
   codecInfoDepth2               = (1L << 1),
   /* compressed data at 2 bpp depth available */
   codecInfoDepth4               = (1L << 2),
   /* compressed data at 4 bpp depth available */
   codecInfoDepth8               = (1L << 3),
   /* compressed data at 8 bpp depth available */
   codecInfoDepth16              = (1L << 4),
   /* compressed data at 16 bpp depth available */
   codecInfoDepth32              = (1L << 5),
   /* compressed data at 32 bpp depth available */
   codecInfoDepth24              = (1L << 6),
   /* compressed data at 24 bpp depth available */
   codecInfoDepth33              = (1L << 7),
   /* compressed data at 1 bpp monochrome depth  available */
   codecInfoDepth34              = (1L << 8),
   /* compressed data at 2 bpp grayscale depth available */
   codecInfoDepth36              = (1L << 9),
   /* compressed data at 4 bpp grayscale depth available */
   codecInfoDepth40              = (1L << 10),
   /* compressed data at 8 bpp grayscale depth available */
   codecInfoStoresClut           = (1L << 11),
   /* compressed data can have custom cluts */
   codecInfoDoesLossless         = (1L << 12),
   /* compressed data can be stored in lossless format */
   codecInfoSequenceSensitive    = (1L << 13) /* compressed data is sensitive to out of sequence decoding */
};


/*Graphics Importer Component Type

Graphics importer components have this component type:enum {
    GraphicsImporterComponentType = 'grip'
};*/

enum {
    GraphicsImporterComponentType = 'grip'
};



/*CodecComponent

Represents a type used by the Compression and Decompression API.

typedef Component CodecComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef Component CodecComponent;

/*CodecType

Abst_CodecType

typedef OSType CodecType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType CodecType;

/*CMValidTime_DecodeDurationIsValid

Constants grouped with kICMValidTime_DecodeDurationIsValid.

enum {
   /
   * Indicates that a display time stamp is valid.
   *
   kICMValidTime_DisplayTimeStampIsValid = 1L << 0,
   /
   * Indicates that a display duration is valid.
   *
   kICMValidTime_DisplayDurationIsValid = 1L << 1,
   /
   * Indicates that a decode time stamp is valid.
   *
   kICMValidTime_DecodeTimeStampIsValid = 1L << 2,
   /
   * Indicates that a decode duration is valid.
   *
   kICMValidTime_DecodeDurationIsValid = 1L << 3,
   /
   * Indicates that a display offset (the offset from a decode time
   * stamp to a display time stamp) is valid.
   *
   kICMValidTime_DisplayOffsetIsValid = 1L << 4
};
Constants
kICMValidTime_DisplayTimeStampIsValid

The time value passed in displayTimeStamp is valid. 

Available in Mac OS X v10.3 and later.
kICMValidTime_DisplayDurationIsValid

The time value passed in displayDuration is valid. 

Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
enum {
   /*
   * Indicates that a display time stamp is valid.
   */
   kICMValidTime_DisplayTimeStampIsValid = 1L << 0,
   /*
   * Indicates that a display duration is valid.
   */
   kICMValidTime_DisplayDurationIsValid = 1L << 1,
   /*
   * Indicates that a decode time stamp is valid.
   */
   kICMValidTime_DecodeTimeStampIsValid = 1L << 2,
   /*
   * Indicates that a decode duration is valid.
   */
   kICMValidTime_DecodeDurationIsValid = 1L << 3,
   /*
   * Indicates that a display offset (the offset from a decode time
   * stamp to a display time stamp) is valid.
   */
   kICMValidTime_DisplayOffsetIsValid = 1L << 4
};
/*MEncodedFrameSetFrameType Values

Constants passed to ICMEncodedFrameSetFrameType.

enum {
   kICMFrameType_I               = 'I',
   kICMFrameType_P               = 'P',
   kICMFrameType_B               = 'B',
   kICMFrameType_Unknown         = 0
};
Declared In
ImageCompression.h*/

enum {
   kICMFrameType_I               = 'I',
   kICMFrameType_P               = 'P',
   kICMFrameType_B               = 'B',
   kICMFrameType_Unknown         = 0
};


/*QTSetPixMapPtrRequestedGammaLevel Values

Constants passed to QTSetPixMapPtrRequestedGammaLevel.

enum {
   kQTUsePlatformDefaultGammaLevel = 0,
   / When decompressing into this PixMap,
   gamma-correct to the platform's standard gamma. *
   kQTUseSourceGammaLevel        = -1L,
   / When decompressing into this PixMap,
   don't perform gamma-correction. 
   kQTCCIR601VideoGammaLevel     = 0x00023333 / 2.2,
   standard television video gamma.
};
Constants
kQTCCIR601VideoGammaLevel

Gamma 2.2, for ITU-R BT.601 based video. 

Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
enum {
   kQTUsePlatformDefaultGammaLevel = 0,
   /* When decompressing into this PixMap,
   gamma-correct to the platform's standard gamma. */
   kQTUseSourceGammaLevel        = -1L,
   /* When decompressing into this PixMap,
   don't perform gamma-correction. */
   kQTCCIR601VideoGammaLevel     = 0x00023333 /* 2.2,
   standard television video gamma.*/
};
/*Graphics Importer Flags

Constants that represent the flags of graphics importers.

enum {
   graphicsImporterIsBaseImporter = 1L << 0,
   graphicsImporterCanValidateFile = 1L << 9,
   graphicsImporterSubTypeIsFileExtension = 1L << 12,
   graphicsImporterHasMIMEList   = 1L << 14,
   graphicsImporterUsesImageDecompressor = 1L << 23
};
enum {
   kGraphicsImporterDontDoGammaCorrection = 1L << 0,
   kGraphicsImporterTrustResolutionFromFile = 1L << 1,
   kGraphicsImporterEnableSubPixelPositioning = 1L << 2,
   kGraphicsImporterDontUseColorMatching = 1L << 3 /set this flag (*before* calling GraphicsImportGetColorSyncProfile) if you do matching yourself 
};
Declared In
ImageCompression.h*/
enum {
   graphicsImporterIsBaseImporter = 1L << 0,
   graphicsImporterCanValidateFile = 1L << 9,
   graphicsImporterSubTypeIsFileExtension = 1L << 12,
   graphicsImporterHasMIMEList   = 1L << 14,
   graphicsImporterUsesImageDecompressor = 1L << 23
};
enum {
   kGraphicsImporterDontDoGammaCorrection = 1L << 0,
   kGraphicsImporterTrustResolutionFromFile = 1L << 1,
   kGraphicsImporterEnableSubPixelPositioning = 1L << 2,
   kGraphicsImporterDontUseColorMatching = 1L << 3 /* set this flag (*before* calling GraphicsImportGetColorSyncProfile) if you do matching yourself */
};


/*Codec Flags

Constants that represent codec flags.

enum {
   codecCompletionSource         = (1 << 0),
   // asynchronous codec is done with source data 
   codecCompletionDest           = (1 << 1),
   // asynchronous codec is done with destination data 
   codecCompletionDontUnshield   = (1 << 2),
   // on dest complete don't unshield cursor *
   codecCompletionWentOffscreen  = (1 << 3),
   / codec used offscreen buffer *
   codecCompletionUnlockBits     = (1 << 4),
   / on dest complete,
   call ICMSequenceUnlockBits *
   codecCompletionForceChainFlush = (1 << 5),
   / ICM needs to flush the whole chain *
   codecCompletionDropped        = (1 << 6),
   / codec decided to drop this frame *
   codecCompletionDecoded        = (1 << 10),
   / codec has decoded this frame; if it is cancelled and rescheduled,
   set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags *
   codecCompletionNotDisplayable = (1 << 11),
   / the frame may still be scheduled for decode,
   but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames. *
   codecCompletionNotDrawn       = (1 << 12) / set in conjunction with codecCompletionDest to indicate that the frame was not drawn *
};
enum {
   codecFlagOutUpdateOnNextIdle  = (1L << 9),
   codecFlagOutUpdateOnDataSourceChange = (1L << 10),
   codecFlagSequenceSensitive    = (1L << 11),
   codecFlagOutUpdateOnTimeChange = (1L << 12),
   codecFlagImageBufferNotSourceImage = (1L << 13),
   codecFlagUsedNewImageBuffer   = (1L << 14),
   codecFlagUsedImageBuffer      = (1L << 15)
};
enum {
   codecInfoDoes1                = (1L << 0),
   /* codec can work with 1-bit pixels *
   codecInfoDoes2                = (1L << 1),
   /* codec can work with 2-bit pixels *
   codecInfoDoes4                = (1L << 2),
   /* codec can work with 4-bit pixels *
   codecInfoDoes8                = (1L << 3),
   /* codec can work with 8-bit pixels *
   codecInfoDoes16               = (1L << 4),
   / codec can work with 16-bit pixels *
   codecInfoDoes32               = (1L << 5),
   / codec can work with 32-bit pixels *
   codecInfoDoesDither           = (1L << 6),
   / codec can do ditherMode *
   codecInfoDoesStretch          = (1L << 7),
   / codec can stretch to arbitrary sizes *
   codecInfoDoesShrink           = (1L << 8),
   / codec can shrink to arbitrary sizes *
   codecInfoDoesMask             = (1L << 9),
   /* codec can mask to clipping regions *
   codecInfoDoesTemporal         = (1L << 10),
   /* codec can handle temporal redundancy *
   codecInfoDoesDouble           = (1L << 11),
   /* codec can stretch to double size exactly *
   codecInfoDoesQuad             = (1L << 12),
   /* codec can stretch to quadruple size exactly *
   codecInfoDoesHalf             = (1L << 13),
   /* codec can shrink to half size *
   codecInfoDoesQuarter          = (1L << 14),
   /* codec can shrink to quarter size *
   codecInfoDoesRotate           = (1L << 15),
   /* codec can rotate on decompress *
   codecInfoDoesHorizFlip        = (1L << 16),
   /* codec can flip horizontally on decompress *
   codecInfoDoesVertFlip         = (1L << 17),
   /* codec can flip vertically on decompress *
   codecInfoHasEffectParameterList = (1L << 18),
   /* codec implements get effects parameter list call,
   once was codecInfoDoesSkew *
   codecInfoDoesBlend            = (1L << 19),
   /* codec can blend on decompress *
   codecInfoDoesReorder          = (1L << 19),
   /* codec can rearrange frames during compression *
   codecInfoDoesWarp             = (1L << 20),
   /* codec can warp arbitrarily on decompress *
   codecInfoDoesMultiPass        = (1L << 20),
   /* codec can perform multi-pass compression *
   codecInfoDoesRecompress       = (1L << 21),
   /* codec can recompress image without accumulating errors *
   codecInfoDoesSpool            = (1L << 22),
   /* codec can spool image data *
   codecInfoDoesRateConstrain    = (1L << 23) / codec can data rate constrain *
};
enum {
   codecLockBitsShieldCursor     = (1 << 0) /* shield cursor *
};
Constants
codecCompletionSource

The Image Compression Manager is done with the source buffer. The Image Compression Manager sets this flag to 1 when it is done with the processing associated with the source buffer. For compression operations, the source is the uncompressed pixel map you are compressing. For decompression operations, the source is the decompressed data you are decompressing. 

Available in Mac OS X v10.0 and later.
codecCompletionDest

The Image Compression Manager is done with the destination buffer. The Image Compression Manager sets this flag to 1 when it is done with the processing associated with the destination buffer. 

Available in Mac OS X v10.0 and later.
codecCompletionWentOffscreen

Codec used offscreen buffer. 

Available in Mac OS X v10.0 and later.
codecCompletionUnlockBits

On dest complete, call ICMSequenceUnlockBits. 

Available in Mac OS X v10.0 and later.
codecCompletionForceChainFlush

ICM needs to flush the whole chain. 

Available in Mac OS X v10.0 and later.
codecCompletionDropped

Codec decided to drop this frame. 

Available in Mac OS X v10.0 and later.
codecCompletionDecoded

Codec has decoded this frame; if it is cancelled and rescheduled, set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags. 

Available in Mac OS X v10.3 and later.
codecCompletionNotDisplayable

The frame may still be scheduled for decode, but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames.. 

Available in Mac OS X v10.3 and later.
codecCompletionNotDrawn

Set in conjunction with codecCompletionDest to indicate that the frame was not drawn. 

Available in Mac OS X v10.3 and later.
codecFlagUsedImageBuffer

Indicates to your application that the decompressor used the offscreen image buffer for this frame. If this flag is set to 1, the decompressor used the image buffer. If this flag is set to 0, the decompressor did not use the image buffer. 

Available in Mac OS X v10.0 and later.
codecInfoDoes1

Codec can work with 1-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes2

Codec can work with 2-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes4

Codec can work with 4-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes8

Codec can work with 8-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes16

Codec can work with 16-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoes32

Codec can work with 32-bit pixels. 

Available in Mac OS X v10.0 and later.
codecInfoDoesDither

Codec can dither images. 

Available in Mac OS X v10.0 and later.
codecInfoDoesStretch

Codec can stretch images to arbitrary sizes. 

Available in Mac OS X v10.0 and later.
codecInfoDoesShrink

Codec can shrink images to arbitrary sizes. 

Available in Mac OS X v10.0 and later.
codecInfoDoesMask

Codec can mask images to clipping regions. 

Available in Mac OS X v10.0 and later.
codecInfoDoesTemporal

Codec can handle temporal redundancy. 

Available in Mac OS X v10.0 and later.
codecInfoDoesDouble

Codec can stretch images to exactly double size. 

Available in Mac OS X v10.0 and later.
codecInfoDoesQuad

Codec can stretch images to exactly quadruple size. 

Available in Mac OS X v10.0 and later.
codecInfoDoesHalf

Codec can shrink images to exactly half size. 

Available in Mac OS X v10.0 and later.
codecInfoDoesQuarter

Codec can shrink images to exactly quarter size. 

Available in Mac OS X v10.0 and later.
codecInfoDoesRotate

Codec can rotate images during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoDoesHorizFlip

Codec can flip images horizontally during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoDoesVertFlip

Codec can flip images vertically during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoHasEffectParameterList

Codec implements QTGetEffectsList. 

Available in Mac OS X v10.0 and later.
codecInfoDoesBlend

Codec can blend image during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoDoesReorder

Codec can rearrange frames during compression. 

Available in Mac OS X v10.3 and later.
codecInfoDoesWarp

Codec can warp image arbitrarily during decompression. 

Available in Mac OS X v10.0 and later.
codecInfoDoesMultiPass

Codec can perform multi-pass compression. 

Available in Mac OS X v10.3 and later.
codecInfoDoesRecompress

Codec can recompress image without accumulating errors. 

Available in Mac OS X v10.0 and later.
codecInfoDoesSpool

Codec can spool image data. 

Available in Mac OS X v10.0 and later.*/
enum {
   codecCompletionSource         = (1 << 0),
   /* asynchronous codec is done with source data */
   codecCompletionDest           = (1 << 1),
   /* asynchronous codec is done with destination data */
   codecCompletionDontUnshield   = (1 << 2),
   /* on dest complete don't unshield cursor */
   codecCompletionWentOffscreen  = (1 << 3),
   /* codec used offscreen buffer */
   codecCompletionUnlockBits     = (1 << 4),
   /* on dest complete,
   call ICMSequenceUnlockBits */
   codecCompletionForceChainFlush = (1 << 5),
   /* ICM needs to flush the whole chain */
   codecCompletionDropped        = (1 << 6),
   /* codec decided to drop this frame */
   codecCompletionDecoded        = (1 << 10),
   /* codec has decoded this frame; if it is cancelled and rescheduled,
   set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags */
   codecCompletionNotDisplayable = (1 << 11),
   /* the frame may still be scheduled for decode,
   but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames. */
   codecCompletionNotDrawn       = (1 << 12) /* set in conjunction with codecCompletionDest to indicate that the frame was not drawn */
};
enum {
   codecFlagOutUpdateOnNextIdle  = (1L << 9),
   codecFlagOutUpdateOnDataSourceChange = (1L << 10),
   codecFlagSequenceSensitive    = (1L << 11),
   codecFlagOutUpdateOnTimeChange = (1L << 12),
   codecFlagImageBufferNotSourceImage = (1L << 13),
   codecFlagUsedNewImageBuffer   = (1L << 14),
   codecFlagUsedImageBuffer      = (1L << 15)
};
enum {
   codecInfoDoes1                = (1L << 0),
   /* codec can work with 1-bit pixels */
   codecInfoDoes2                = (1L << 1),
   /* codec can work with 2-bit pixels */
   codecInfoDoes4                = (1L << 2),
   /* codec can work with 4-bit pixels */
   codecInfoDoes8                = (1L << 3),
   /* codec can work with 8-bit pixels */
   codecInfoDoes16               = (1L << 4),
   /* codec can work with 16-bit pixels */
   codecInfoDoes32               = (1L << 5),
   /* codec can work with 32-bit pixels */
   codecInfoDoesDither           = (1L << 6),
   /* codec can do ditherMode */
   codecInfoDoesStretch          = (1L << 7),
   /* codec can stretch to arbitrary sizes */
   codecInfoDoesShrink           = (1L << 8),
   /* codec can shrink to arbitrary sizes */
   codecInfoDoesMask             = (1L << 9),
   /* codec can mask to clipping regions */
   codecInfoDoesTemporal         = (1L << 10),
   /* codec can handle temporal redundancy */
   codecInfoDoesDouble           = (1L << 11),
   /* codec can stretch to double size exactly */
   codecInfoDoesQuad             = (1L << 12),
   /* codec can stretch to quadruple size exactly */
   codecInfoDoesHalf             = (1L << 13),
   /* codec can shrink to half size */
   codecInfoDoesQuarter          = (1L << 14),
   /* codec can shrink to quarter size */
   codecInfoDoesRotate           = (1L << 15),
   /* codec can rotate on decompress */
   codecInfoDoesHorizFlip        = (1L << 16),
   /* codec can flip horizontally on decompress */
   codecInfoDoesVertFlip         = (1L << 17),
   /* codec can flip vertically on decompress */
   codecInfoHasEffectParameterList = (1L << 18),
   /* codec implements get effects parameter list call,
   once was codecInfoDoesSkew */
   codecInfoDoesBlend            = (1L << 19),
   /* codec can blend on decompress */
   codecInfoDoesReorder          = (1L << 19),
   /* codec can rearrange frames during compression */
   codecInfoDoesWarp             = (1L << 20),
   /* codec can warp arbitrarily on decompress */
   codecInfoDoesMultiPass        = (1L << 20),
   /* codec can perform multi-pass compression */
   codecInfoDoesRecompress       = (1L << 21),
   /* codec can recompress image without accumulating errors */
   codecInfoDoesSpool            = (1L << 22),
   /* codec can spool image data */
   codecInfoDoesRateConstrain    = (1L << 23) /* codec can data rate constrain */
};
enum {
   codecLockBitsShieldCursor     = (1 << 0) /* shield cursor */
};

/*Codec Type Constants

Constants that represent codec types.

kDVCPro50NTSCCodecType        = 'dv5n'
kDVCPro50PALCodecType         = 'dv5p'
kDVCPro100NTSCCodecType       = 'dv1n'
kDVCPro100PALCodecType        = 'dv1p'
kDVCPROHD720pCodecType        = 'dvhp'
kDVCPROHD1080i60CodecType     = 'dvh6'
kDVCPROHD1080i50CodecType     = 'dvh5'
kSorenson3CodecType           = 'SVQ3'
kMPEG4VisualCodecType         = 'mp4v'
k422YpCbCr8CodecType          = '2vuy'
k444YpCbCr8CodecType          = 'v308'
k4444YpCbCrA8CodecType        = 'v408'
k422YpCbCr16CodecType         = 'v216'
k422YpCbCr10CodecType         = 'v210'
k444YpCbCr10CodecType         = 'v410'
k4444YpCbCrA8RCodecType       = 'r408'
kJPEG2000CodecType            = 'mjp2'
kPixletCodecType              = 'pxlt'
kH264CodecType                = 'avc1'
kSorenson3CodecType

Available in QuickTime 5 and later. 

Available in Mac OS X v10.0 and later.
k422YpCbCr8CodecType

Component Y'CbCr 8-bit 4:2:2. 

Available in Mac OS X v10.0 and later.
k444YpCbCr8CodecType

Component Y'CbCr 8-bit 4:4:4. 

Available in Mac OS X v10.0 and later.
k4444YpCbCrA8CodecType

Component Y'CbCrA 8-bit 4:4:4:4. 

Available in Mac OS X v10.0 and later.
k422YpCbCr16CodecType

Component Y'CbCr 10,12,14,16-bit 4:2:2. 

Available in Mac OS X v10.0 and later.
k422YpCbCr10CodecType

Component Y'CbCr 10-bit 4:2:2. 

Available in Mac OS X v10.0 and later.
k444YpCbCr10CodecType

Component Y'CbCr 10-bit 4:4:4. 

Available in Mac OS X v10.0 and later.
k4444YpCbCrA8RCodecType

Component Y'CbCrA 8-bit 4:4:4:4, rendering format. full range alpha, zero biased YUV. 

Available in Mac OS X v10.0 and later.*/
enum {
kDVCPro50NTSCCodecType        = 'dv5n' ,
kDVCPro50PALCodecType         = 'dv5p',
kDVCPro100NTSCCodecType       = 'dv1n',
kDVCPro100PALCodecType        = 'dv1p',
kDVCPROHD720pCodecType        = 'dvhp',
kDVCPROHD1080i60CodecType     = 'dvh6',
kDVCPROHD1080i50CodecType     = 'dvh5',
kSorenson3CodecType           = 'SVQ3',
kMPEG4VisualCodecType         = 'mp4v',
k422YpCbCr8CodecType          = '2vuy',
k444YpCbCr8CodecType          = 'v308',
k4444YpCbCrA8CodecType        = 'v408',
k422YpCbCr16CodecType         = 'v216',
k422YpCbCr10CodecType         = 'v210',
k444YpCbCr10CodecType         = 'v410',
k4444YpCbCrA8RCodecType       = 'r408',
kJPEG2000CodecType            = 'mjp2',
kPixletCodecType              = 'pxlt',
kH264CodecType                = 'avc1'
};


//Typedef&


/*ICMCompletionProc

Called by a compressor component upon completion of an asynchronous operation.

typedef void (*ICMCompletionProcPtr) (OSErr result, short flags, long refcon);

If you name your function MyICMCompletionProc, you would declare it this way:

void MyICMCompletionProc (
   OSErr    result,
   short    flags,
   long     refcon );
Parameters
result

Indicator of success of current operation.
flags

Contains flags (see below) that indicate which part of the operation is complete. Note that more than one of the flags may be set to 1. See these constants: 
codecCompletionSource
codecCompletionDest
refcon

Contains a reference constant value for use by your completion function. Your application specifies the value of this reference constant in the callback function structure you pass to the Image Compression Manager.
Declared In
ImageCompression.h*/
typedef void (*ICMCompletionProcPtr) (OSErr result, short flags, long refcon);

/*ICMCompletionUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMCompletionProcPtr) ICMCompletionUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMCompletionProcPtr) ICMCompletionUPP;

/*ICMCompletionProcRecord

Specifies an image compression completion callback.

struct ICMCompletionProcRecord {
   ICMCompletionUPP    completionProc;
   long                completionRefCon;
};
Fields
completionProc
Discussion

Contains a Universal Procedure Pointer that accesses your ICMCompletionProc callback. 
completionRefCon
Discussion

Contains a reference constant for use by your callback.
Discussion

This structure governs whether you perform a compression asynchronously. If the completionProc field in this structure is set to NIL, perform the compression synchronously. If this field is not NIL, it specifies an application completion function. Perform the compression asynchronously and call that completion function when your component is finished. If the completionProc field in this structure has a value of -1, perform the operation asynchronously but do not call the application's completion function
Related Functions
CompressSequenceFrame
DecompressSequenceFrame
DecompressSequenceFrameS
DecompressSequenceFrameWhen
ICMDecompressComplete
ICMDecompressCompleteS
MediaQueueNonPrimarySourceData
MediaSetNonPrimarySourceData
SCCompressSequenceFrameAsync
TweenerDataProc 
Programming Info
C interface file: ImageCompression.h*/
struct ICMCompletionProcRecord {
   ICMCompletionUPP    completionProc;
   long                completionRefCon;
};
typedef struct ICMCompletionProcRecord ICMCompletionProcRecord;

/*ICMCompletionProcRecordPtr

Abst_ICMCompletionProcRecordPtr

typedef ICMCompletionProcRecord * ICMCompletionProcRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ICMCompletionProcRecord * ICMCompletionProcRecordPtr;

/*DecompressorComponent

Represents a type used by the Compression and Decompression API.

typedef Component DecompressorComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef Component DecompressorComponent;

/*MatrixRecord

Contains a transformation matrix.

struct MatrixRecord {
   Fixed    matrix[3][3];
};
Fields
matrix
Discussion

A 3-by-3 array of matrix values.
Related Functions
GetMovieMatrix
GetTrackMatrix
GraphicsImportGetDefaultMatrix
MediaSetMatrix
TransformRgn
TranslateMatrix
VDSetPlayThruDestination 
Programming Info
C interface file: ImageCompression.h*/
struct MatrixRecord {
   Fixed    matrix[3][3];
};
typedef struct MatrixRecord MatrixRecord;

/*MatrixRecordPtr

Abst_MatrixRecordPtr

typedef MatrixRecord * MatrixRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MatrixRecord * MatrixRecordPtr;

/*ImageSequence

Abst_ImageSequence

typedef long ImageSequence;
Availability
Available in Mac OS X v10.0 and later.*/
typedef long ImageSequence;

/*GraphicsImportCreateCGImage Values

Constants passed to GraphicsImportCreateCGImage.

enum {
   kGraphicsImportCreateCGImageUsingCurrentSettings = 1L << 0
};
Declared In
ImageCompression.h*/
enum {
   kGraphicsImportCreateCGImageUsingCurrentSettings = 1L << 0
};


/*Codec Identifiers

Identify codec components and data types in QuickTime.

kAnimationCodecType          ='rle '
kAVRJPEGCodecType            ='avr '
kBaseCodecType               ='base'
kBMPCodecType                ='WRLE'
kCinepakCodecType            ='cvid'
kCloudCodecType              ='clou'
kCMYKCodecType               ='cmyk'
kComponentVideoCodecType     ='yuv2'
kComponentVideoSigned        ='yuvu'
kComponentVideoUnsigned      ='yuvs'
kDVCNTSCCodecType            ='dvc '
kDVCPALCodecType             ='dvcp'
kDVCProNTSCCodecType         ='dvpn'
kDVCProPALCodecType          ='dvpp'
kFireCodecType               ='fire'
kFLCCodecType                ='flic'
k48RGBCodecType              ='b48r'
kGIFCodecType                ='gif '
kGraphicsCodecType           ='smc '
kH261CodecType               ='h261'
kH263CodecType               ='h263'
kIndeo4CodecType             ='IV41'
kJPEGCodecType               ='jpeg'
kMacPaintCodecType           ='PNTG'
kMicrosoftVideo1CodecType    ='msvc'
kMotionJPEGACodecType        ='mjpa'
kMotionJPEGBCodecType        ='mjpb'
kMpegYUV420CodecType         ='myuv'
kOpenDMLJPEGCodecType        ='dmb1'
kPhotoCDCodecType            ='kpcd'
kPlanarRGBCodecType          ='8BPS'
kPNGCodecType                ='png '
kQuickDrawCodecType          ='qdrw'
kQuickDrawGXCodecType        ='qdgx'
kRawCodecType                ='raw '
kSGICodecType                ='.SGI'
k16GrayCodecType             ='b16g'
k64ARGBCodecType             ='b64a'
kSorensonCodecType           ='SVQ1'
kSorensonYUV9CodecType       ='syv9'
kTargaCodecType              ='tga '
k32AlphaGrayCodecType        ='b32a'
kTIFFCodecType               ='tiff'
kVectorCodecType             ='path'
kVideoCodecType              ='rpza'
kWaterRippleCodecType        ='ripl'
kWindowsRawCodecType         ='WRAW'
kYUV420CodecType             ='y420
Discussion

All codec components of the same type provide the same kinds of services and support a common application programming interface.*/
enum {
kAnimationCodecType          ='rle ',
kAVRJPEGCodecType            ='avr ',
kBaseCodecType               ='base',
kBMPCodecType                ='WRLE',
kCinepakCodecType            ='cvid',
kCloudCodecType              ='clou',
kCMYKCodecType               ='cmyk',
kComponentVideoCodecType     ='yuv2',
kComponentVideoSigned        ='yuvu',
kComponentVideoUnsigned      ='yuvs',
kDVCNTSCCodecType            ='dvc ',
kDVCPALCodecType             ='dvcp',
kDVCProNTSCCodecType         ='dvpn',
kDVCProPALCodecType          ='dvpp',
kFireCodecType               ='fire',
kFLCCodecType                ='flic',
k48RGBCodecType              ='b48r',
kGIFCodecType                ='gif ',
kGraphicsCodecType           ='smc ',
kH261CodecType               ='h261',
kH263CodecType               ='h263',
kIndeo4CodecType             ='IV41',
kJPEGCodecType               ='jpeg',
kMacPaintCodecType           ='PNTG',
kMicrosoftVideo1CodecType    ='msvc',
kMotionJPEGACodecType        ='mjpa',
kMotionJPEGBCodecType        ='mjpb',
kMpegYUV420CodecType         ='myuv',
kOpenDMLJPEGCodecType        ='dmb1',
kPhotoCDCodecType            ='kpcd',
kPlanarRGBCodecType          ='8BPS',
kPNGCodecType                ='png ',
kQuickDrawCodecType          ='qdrw',
kQuickDrawGXCodecType        ='qdgx',
kRawCodecType                ='raw ',
kSGICodecType                ='.SGI',
k16GrayCodecType             ='b16g',
k64ARGBCodecType             ='b64a',
kSorensonCodecType           ='SVQ1',
kSorensonYUV9CodecType       ='syv9',
kTargaCodecType              ='tga ',
k32AlphaGrayCodecType        ='b32a',
kTIFFCodecType               ='tiff',
kVectorCodecType             ='path',
kVideoCodecType              ='rpza',
kWaterRippleCodecType        ='ripl',
kWindowsRawCodecType         ='WRAW',
kYUV420CodecType             ='y420'
};

/*Constants

The following constants are used to specify graphics exporter characteristics:
enum {
    GraphicsExporterComponentType = FOUR_CHAR_CODE('grex'),
    kBaseGraphicsExporterSubType = FOUR_CHAR_CODE('base')
};
 
enum {
    graphicsExporterIsBaseExporter = 1L << 0,
    graphicsExporterCanTranscode = 1L << 1,
    graphicsExporterUsesImageCompressor = 1L << 2
};*/

enum {
    GraphicsExporterComponentType = FOUR_CHAR_CODE('grex'),
    kBaseGraphicsExporterSubType = FOUR_CHAR_CODE('base')
};
 
enum {
    graphicsExporterIsBaseExporter = 1L << 0,
    graphicsExporterCanTranscode = 1L << 1,
    graphicsExporterUsesImageCompressor = 1L << 2
};


/*GraphicsExportComponent

Represents a type used by the Graphics Import and Export API.

typedef ComponentInstance GraphicsExportComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef ComponentInstance GraphicsExportComponent;

/*ICMProgressProc

Reports on the progress of a compressor or decompressor.

typedef OSErr (*ICMProgressProcPtr) (short message, Fixed completeness, long refcon);

If you name your function MyICMProgressProc, you would declare it this way:

OSErr MyICMProgressProc (
   short    message,
   Fixed    completeness,
   long     refcon );
Parameters
message

Indicates why the Image Compression Manager called your function. There are three valid messages, listed below. See these constants: 
codecProgressOpen
codecProgressUpdatePercent
codecProgressClose
completeness

Contains a fixed-point value indicating how far the operation has progressed. Its value is always between 0.0 and 1.0. This parameter is valid only when the message field is set to codecProgressUpdatePercent.
refcon

Contains a reference constant value for use by your progress function. Your application specifies the value of this reference constant in the progress function structure you pass to the Image Compression Manager.
Return Value

See Error Codes. Your callback should return noErr if there is no error. When a component calls your progress function, it supplies you with a number that indicates the completion percentage. Your program can cause the component to terminate the current operation by returning a result code of codecAbortErr.
Discussion

The Image Compression Manager calls your progress function only during long operations, and it does not call your function more than 30 times per second.
Declared In
ImageCompression.h*/
typedef OSErr (*ICMProgressProcPtr) (short message, Fixed completeness, long refcon);

/*ICMProgressUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMProgressProcPtr) ICMProgressUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMProgressProcPtr) ICMProgressUPP;

/*ICMProgressProcRecord

Specifies an image compression progress callback.

struct ICMProgressProcRecord {
   ICMProgressUPP    progressProc;
   long              progressRefCon;
};
Fields
progressProc
Discussion

Contains a pointer to your progress function.
progressRefCon
Discussion

Contains a reference constant for use by your progress function.
Discussion

During a compression operation, your compressor may occasionally call a function that the application provides in order to report your progress. This field contains a structure that identifies the progress function. If the progressProc field in this structure is set to NIL, the application has not supplied a progress function
Related Functions
DrawPictureFile
DrawTrimmedPicture
DrawTrimmedPictureFile
FCompressImage
FCompressPicture
FCompressPictureFile
FDecompressImage
GetCompressedPixMapInfo
GraphicsExportGetProgressProc
GraphicsExportSetProgressProc
GraphicsImportGetProgressProc
GraphicsImportSetProgressProc
ImageCodecTrimImage
MakeFilePreview
MakeThumbnailFromPicture
MakeThumbnailFromPictureFile
MakeThumbnailFromPixMap
PreviewMakePreview
SetCompressedPixMapInfo
SetSequenceProgressProc
TrimImage 
Programming Info
C interface file: ImageCompression.h*/

struct ICMProgressProcRecord {
   ICMProgressUPP    progressProc;
   long              progressRefCon;
};
typedef  struct ICMProgressProcRecord ICMProgressProcRecord;

/*ICMProgressProcRecordPtr

Abst_ICMProgressProcRecordPtr

typedef ICMProgressProcRecord * ICMProgressProcRecordPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ICMProgressProcRecord * ICMProgressProcRecordPtr;

/*GraphicsImportComponent

Represents a type used by the Graphics Import and Export API.

typedef ComponentInstance GraphicsImportComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
typedef ComponentInstance GraphicsImportComponent;

/*ICM Preferences and Flags

Constants that represent the flags and preferences for ICM sessions.

enum {
   icmFrameTimeHasVirtualStartTimeAndDuration = 1 << 0,
   icmFrameAlreadyDecoded        = 1 << 1,
   icmFrameTimeIsNonScheduledDisplayTime = 1 << 2,
   icmFrameTimeHasDecodeTime     = 1 << 3,
   icmFrameTimeDecodeImmediately = 1 << 4,
   icmFrameTimeDoNotDisplay      = 1 << 5
};
enum {
   kICMGetChainUltimateParent    = 0,
   kICMGetChainParent            = 1,
   kICMGetChainChild             = 2,
   kICMGetChainUltimateChild     = 3
};
enum {
   kICMImageBufferNoPreference   = 0,
   kICMImageBufferPreferMainMemory = 1,
   kICMImageBufferPreferVideoMemory = 2
};
enum {
   kICMNoDeinterlacing           = 0,
   kICMDeinterlaceFields         = 1
};
enum {
   kICMPixelFormatIsPlanarMask   = 0x0F,
   // these bits in formatFlags indicate how many planes there are; they're 0 if chunky
   kICMPixelFormatIsIndexed      = (1L << 4),
   kICMPixelFormatIsSupportedByQD = (1L << 5),
   kICMPixelFormatIsMonochrome   = (1L << 6),
   kICMPixelFormatHasAlphaChannel = (1L << 7)
};
enum {
   kICMSequenceTaskWeight        = 'twei',
   // data is pointer to UInt32
   kICMSequenceTaskName          = 'tnam',
   //data is pointer to OSType
   kICMSequenceUserPreferredCodecs = 'punt' // data is pointer to CodecComponentHandle
};
enum {
   kICMTempThenAppMemory         = 1L << 12,
   kICMAppThenTempMemory         = 1L << 13
};
Constants
icmFrameTimeHasVirtualStartTimeAndDuration

Indicates that virtualStartTime and virtualDuration are valid. 

Available in Mac OS X v10.0 and later.
icmFrameTimeHasDecodeTime

Indicates that decodeTime is valid. 

Available in Mac OS X v10.3 and later.
kICMPixelFormatIsPlanarMask

If this flag is 1, the pixel format is a planar mask and bitsPerPixel[] represents the bits for each pixel component. If this flag is 0, the pixel format is chunky (not planar) and bitsPerPixel[0] represents the bits per pixel. Chunky pixel formats pack the different components together. For example, 3 pixels of 32-bit ARGB is represented in memory as ARGBARGBARGB. Planar formats pack the different components separately. If the pixel format is planar, then (formatFlags & kICMPixelFormatIsPlanarMask) is equal to the number of components. 

Available in Mac OS X v10.0 and later.
kICMPixelFormatIsIndexed

If the pixel format is indexed (which, by definition, means that there are no individual components) then this flag is 1. Generally, color modes of 8 bit per pixel or less are indexed. 

Available in Mac OS X v10.0 and later.
kICMPixelFormatIsSupportedByQD

If this flag is 1, you can call QuickDraw on PixMap structures that store this kind of pixel data. With Macintosh, the classic QD pixel formats will have this set, but not any of the YUV pixel formats. With Windows, more formats will have this set, because the Windows implementation of QuickDraw needs to support more pixel formats. 

Available in Mac OS X v10.0 and later.
kICMSequenceUserPreferredCodecs

Data is pointer to CodecComponentHandle. 

Available in Mac OS X v10.0 and later.*/
enum {
   icmFrameTimeHasVirtualStartTimeAndDuration = 1 << 0,
   icmFrameAlreadyDecoded        = 1 << 1,
   icmFrameTimeIsNonScheduledDisplayTime = 1 << 2,
   icmFrameTimeHasDecodeTime     = 1 << 3,
   icmFrameTimeDecodeImmediately = 1 << 4,
   icmFrameTimeDoNotDisplay      = 1 << 5
};
enum {
   kICMGetChainUltimateParent    = 0,
   kICMGetChainParent            = 1,
   kICMGetChainChild             = 2,
   kICMGetChainUltimateChild     = 3
};
enum {
   kICMImageBufferNoPreference   = 0,
   kICMImageBufferPreferMainMemory = 1,
   kICMImageBufferPreferVideoMemory = 2
};
enum {
   kICMNoDeinterlacing           = 0,
   kICMDeinterlaceFields         = 1
};
enum {
   kICMPixelFormatIsPlanarMask   = 0x0F,
   /* these bits in formatFlags indicate how many planes there are; they're 0 if chunky*/
   kICMPixelFormatIsIndexed      = (1L << 4),
   kICMPixelFormatIsSupportedByQD = (1L << 5),
   kICMPixelFormatIsMonochrome   = (1L << 6),
   kICMPixelFormatHasAlphaChannel = (1L << 7)
};
enum {
   kICMSequenceTaskWeight        = 'twei',
   /* data is pointer to UInt32*/
   kICMSequenceTaskName          = 'tnam',
   /* data is pointer to OSType*/
   kICMSequenceUserPreferredCodecs = 'punt' /* data is pointer to CodecComponentHandle*/
};
enum {
   kICMTempThenAppMemory         = 1L << 12,
   kICMAppThenTempMemory         = 1L << 13
};

/*decompressionTrackingFlags

One or more flags describing the a frame's state transitions:
kICMDecompressionTracking_LastCall = 1L<<0

This is the last call for this sourceFrameRefCon.
kICMDecompressionTracking_ReleaseSourceData = 1L<<1

The session no longer needs the source data pointer.
kICMDecompressionTracking_EmittingFrame = 1L<<2

A frame is being emitted. The pixelBuffer parameter contains the decompressed frame. If the decompression session is targetting a visual context, the frame has not yet been sent to the visual context but will be sent after the callback returns.
kICMDecompressionTracking_FrameDecoded = 1L<<3

This frame was decoded.
kICMDecompressionTracking_FrameDropped = 1L<<4

The codec decided to drop this frame.
kICMDecompressionTracking_FrameNeedsRequeueing = 1L<<5

This frame will not be able to be displayed unless it is queued for redecode ( this constant is also known as FrameNotDisplayable).*/
enum {
kICMDecompressionTracking_LastCall = 1L<<0,
kICMDecompressionTracking_ReleaseSourceData = 1L<<1,
kICMDecompressionTracking_EmittingFrame = 1L<<2,
kICMDecompressionTracking_FrameDecoded = 1L<<3,
kICMDecompressionTracking_FrameDropped = 1L<<4,
kICMDecompressionTracking_FrameNeedsRequeueing = 1L<<5
};

/*ICM Property IDs

Constants that contain the IDs of ICM properties.

enum {
      //Both fields should be decompressed.
   
   kICMFieldMode_BothFields      = 0,
   
   // Only the top field should be decompressed,
   //producing a half-height
   // image.
   //
   kICMFieldMode_TopFieldOnly    = 1,
   
   //Only the bottom field should be decompressed,
   //producing a
   //half-height image.
   
   /ICMFieldMode_BottomFieldOnly = 2,
   //
   //Both fields should be decompressed,
   //and then filtered to reduce
   /interlacing artifacts.
   //
   kICMFieldMode_DeinterlaceFields = 3
};
enum {
   /*
   * Class identifier for compression frame options object properties.
   */
   //kQTPropertyClass_ICMCompressionFrameOptions = 'icfo',
   /*
   * Forces frames to be compressed as key frames.
   * The compressor must obey the "force key frame" flag if set. By
   * default this property is false.
   */
 //  kICMCompressionFrameOptionsPropertyID_ForceKeyFrame = 'keyf',
   /* Boolean,
   Read/Write */
   /*
   * Requests a frame be compressed as a particular frame type.
   *  The frame type setting may be ignored by the compressor if not
   * appropriate.
   * By default this is set to kICMFrameType_Unknown.
   * Do not assume that kICMFrameType_I means a key frame; if you need
   * a key frame,
   set the "force key frame" property.
   */
   //kICMCompressionFrameOptionsPropertyID_FrameType = 'frty' /* ICMFrameType,
  // Read/Write */
//};
//enum {
   /*
   * Class identifier for compression session options object properties.
   */
   //kQTPropertyClass_ICMCompressionSessionOptions = 'icso',
   /*
   * Enables temporal compression. By default,
   temporal compression is
   * disabled.
   * IMPORTANT: If you want temporal compression (P frames and/or B
   * frames) you must set this to true.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression = 'p ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables frame reordering.
   * In order to encode B frames,
   a compressor must reorder frames,
   * which means that the order in which they will be emitted and
   * stored (the decode order) is different from the order in which
   * they were presented to the compressor (the display order).
   * By default,
   frame reordering is disabled.
   * IMPORTANT: In order to encode using B frames,
   you must enable
   * frame reordering.
   */
  // kICMCompressionSessionOptionsPropertyID_AllowFrameReordering = 'b ok',
   /* Boolean,
   Read/Write */
   /*
   * Indicates that durations of emitted frames are needed.
   * If this flag is set and source frames are provided with times but
   * not durations,
   then frames will be delayed so that durations can
   * be calculated as the difference between one frame's time stamp and
   * the next frame's time stamp.
   * By default,
   this flag is clear,
   so frames will not be delayed in
   * order to calculate durations.
   * IMPORTANT: If you will be passing encoded frames to
   * AddMediaSampleFromEncodedFrame,
   you must set this flag to true.
   */
  // kICMCompressionSessionOptionsPropertyID_DurationsNeeded = 'need',
   /* Boolean,
   Read/Write */
   /*
   * The maximum interval between key frames,
   also known as the key
   * frame rate.
   * Key frames,
   also known as sync frames,
   reset inter-frame
   * dependencies; decoding a key frame is sufficient to prepare a
   * decompressor for correctly decoding the difference frames that
   * follow.
   * Compressors are allowed to generate key frames more frequently if
   * this would result in more efficient compression.
   * The default key frame interval is 0,
   which indicates that the
   * compressor should choose where to place all key frames. A key
   * frame interval of 1 indicates that every frame must be a key
   * frame,
   2 indicates that at least every other frame must be a key
   * frame,
   etc.
   */
   //kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval = 'kyfr',
   /* SInt32,
   Read/Write */
   /*
   * The requested maximum interval between partial sync frames. If the
   * interval is n,
   any sequence of n successive frames must include at
   * least one key or partial sync frame.
   * Where supported,
   partial sync frames perform a partial reset of
   * inter-frame dependencies; decoding two partial sync frames and the
   * non-droppable difference frames between them is sufficient to
   * prepare a decompressor for correctly decoding the difference
   * frames that follow.
   * Compressors are allowed to generate partial sync frames more
   * frequently if this would result in more efficient compression.
   *
   * The default partial sync frame interval is 0,
   which indicates that
   * the compressor should choose where to place partial sync frames. A
   * partial sync frame interval of 1 means there can be no difference
   * frames,
   so it is equivalent to a key frame interval of 1. A
   * partial sync frame interval of 2 means that every other frame must
   * be a key frame or a partial sync frame.
   * Compressors that do not support partial sync frames will ignore
   * this setting.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval = 'psfr',
   /* SInt32,
   Read/Write */
   /*
   * Enables the compressor to modify frame times.
   * Some compressors are able to identify and coalesce runs of
   * identical frames and output single frames with longer duration,
   or
   * output frames at a different frame rate from the original. This
   * feature is controlled by the "allow frame time changes" flag. By
   * default,
   this flag is set to false,
   which forces compressors to
   * emit one encoded frame for every source frame,
   and to preserve
   * frame display times.
   * (Note: this feature replaces the practice of having compressors
   * return special high similarity values to indicate that frames
   * could be dropped.)
   * If you want to allow the compressor to modify frame times in order
   * to improve compression performance,
   enable frame time changes.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges = '+ ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables the compressor to call the encoded-frame callback from a
   * different thread.
   * By default,
   the flag is false,
   which means that the compressor
   * must call the encoded-frame callback from the same thread that
   * ICMCompressionSessionEncodeFrame and
   * ICMCompressionSessionCompleteFrames were called on.
   */
 //  kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion = 'asok',
   /* Boolean,
   Read/Write */
   /*
   * The maximum frame delay count is the maximum number of frames that
   * a compressor is allowed to hold before it must output a compressed
   * frame. It limits the number of frames that may be held in the
   * "compression window". If the maximum frame delay count is M,
   then
   * before the call to encode frame N returns,
   frame N-M must have
   * been emitted.
   * The default is kICMUnlimitedFrameDelayCount,
   which sets no limit
   * on the compression window.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount = 'cwin',
   /* SInt32,
   Read/Write */
   /*
   * The maximum frame delay time is the maximum difference between a
   * source frame's display time and the corresponding encoded frame's
   * decode time. It limits the span of display time that may be held
   * in the "compression window". If the maximum frame delay time is
   * TM,
   then before the call to encode a frame with display time TN
   * returns,
   all frames with display times up to and including TN-TM
   * must have been emitted.
   * The default is kICMUnlimitedFrameDelayTime,
   which sets no time
   * limit on the compression window.
   */
  // kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime = 'cwit',
   /* TimeValue64,
   Read/Write */
   /*
   * Sets a specific compressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * Use this API to force the Image Compression Manager to use a
   * specific compressor component or compressor component instance.
   * (If you pass in a component instance that you opened,
   the ICM will
   * not close that instance; you must do so after the compression
   * session is released.) To allow the Image Compression Manager to
   * choose the compressor component,
   set the compressorComponent to
   * anyCodec (the default),
   bestSpeedCodec,
   bestFidelityCodec or
   * bestCompressionCodec.
   */
 //  kICMCompressionSessionOptionsPropertyID_CompressorComponent = 'imco',
   /* CompressorComponent,
   Read/Write */
   /*
   * A handle containing compressor settings. The compressor will be
   * configured with these settings (by a call to
   * ImageCodecSetSettings) during ICMCompressionSessionCreate.
   */
  // kICMCompressionSessionOptionsPropertyID_CompressorSettings = 'cost',
   /* Handle,
   Read/Write */
   /*
   * The depth for compression.
   * If a compressor does not support a specific depth,
   the closest
   * supported depth will be used (preferring deeper depths to
   * shallower depths). The default depth is k24RGBPixelFormat.
   */
 //  kICMCompressionSessionOptionsPropertyID_Depth = 'deep',
   /* UInt32,
   Read/Write */
   /*
   * The color table for compression.  Used with indexed-color depths.
   *
   * Clients who get this property are responsible for disposing the
   * returned CTabHandle.
   */
  // kICMCompressionSessionOptionsPropertyID_ColorTable = 'clut',
   /* CTabHandle,
   Read/Write*/
   /*
   * The compression quality.
   * This value is always used to set the spatialQuality; if temporal
   * compression is enabled,
   it is also used to set temporalQuality.
   * <BR> The default quality is codecNormalQuality.
   */
   //kICMCompressionSessionOptionsPropertyID_Quality = 'qual',
   /* CodecQ,
   Read/Write */
   /*
   * The long-term desired average data rate in bytes per second.
   *  This is not a hard limit.
   * The default data rate is zero,
   which indicates that the quality
   * setting should determine the size of compressed data.
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
  // kICMCompressionSessionOptionsPropertyID_AverageDataRate = 'aver',
   /* SInt32,
   Read/Write */
   /*
   * Zero,
   one or two hard limits on data rate.
   * Each hard limit is described by a data size in bytes and a
   * duration in seconds,
   and requires that the total size of
   * compressed data for any contiguous segment of that duration (in
   * decode time) must not exceed the data size.
   * By default,
   no data rate limits are set.
   * When setting this property,
   the inPropValueSize parameter should
   * be the number of data rate limits multiplied by
   * sizeof(ICMDataRateLimit).
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
  // kICMCompressionSessionOptionsPropertyID_DataRateLimits = 'hard',
   /* C array of ICMDataRateLimit struct,
   Read/Write */
   /*
   * The current number of data rate limits.
   */
  // kICMCompressionSessionOptionsPropertyID_DataRateLimitCount = 'har#',
   /* UInt32,
   Read */
   /*
   * The maximum allowed number of data rate limits.  (Currently 2.)
   */
  // kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits = 'mhar',
   /* UInt32,
   Read */
   /*
   * Indicates that the source was previously compressed.
   * This property is purely an optional,
   informational hint to the
   * compressor; by default it is false.
   */
  // kICMCompressionSessionOptionsPropertyID_WasCompressed = 'wasc',
   /* Boolean,
   Read/Write */
   /*
   * Recommends a CPU time budget for the compressor in microseconds
   * per frame.
   * Zero means to go as fast as possible.
   * By default,
   this is set to kICMUnlimitedCPUTimeBudget,
   which sets
   * no limit.
   * This is an advisory hint to the compressor,
   and some compressors
   * may ignore it. Multithreaded compressors may use this amount of
   * CPU time on each processor.
   * Compressors should not feel compelled to use the full time budget
   * if they complete ahead of time!
   */
  // kICMCompressionSessionOptionsPropertyID_CPUTimeBudget = 'cput',
   /* UInt32,
   Read/Write */
   /*
   * Storage for multi-pass compression.
   * To enable multipass compression,
   the client must provide a storage
   * location for multipass data.  Use
   * ICMMultiPassStorageCreateWithTemporaryFile to have the ICM store
   * it in a temporary file.  Use
   * ICMMultiPassStorageCreateWithCallbacks to manage the storage
   * yourself.
   * Note that the amount of multipass data to be stored can be
   * substantial; it could be greater than the size of the output movie
   * file.
   * If this property is not NULL,
   the client must call
   * ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass
   * around groups of calls to ICMCompressionSessionEncodeFrame.
   *  By default,
   this property is NULL and multipass compression is
   * not enabled. The compression session options object retains the
   * multipass storage object,
   when one is set.
   */
   //kICMCompressionSessionOptionsPropertyID_MultiPassStorage = 'imps',
   /* ICMMultiPassStorageRef,
   Read/Write */
   /*
   * Indicates the number of source frames,
   if known. If nonzero,
   this
   * should be the exact number of times that the client calls
   * ICMCompressionSessionEncodeFrame in each pass.
   * The default is 0,
   which indicates that the number of source frames
   * is not known.
   */
 //  kICMCompressionSessionOptionsPropertyID_SourceFrameCount = 'frco',
   /* UInt64,
   Read/Write */
   /*
   * Indicates the expected frame rate,
   if known. The frame rate is
   * measured in frames per second. This is not used to control the
   * frame rate; it is provided as a hint to the compressor so that it
   * can set up internal configuration before compression begins. The
   * actual frame rate will depend on frame durations and may vary. By
   * default,
   this is zero,
   indicating "unknown".
   */
  // kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate = 'fran',
   /* Fixed,
   Read/Write */
   /*
   * Indicates how source frames to a compression session should be
   * scaled if the dimensions and/or display aspect ratio do not match.
   */
  // kICMCompressionSessionOptionsPropertyID_ScalingMode = 'scam',
   /* OSType,
   Read/Write */
   /*
   * Describes the clean aperture for compressed frames. Note that if
   * the compressor enforces a clean aperture,
   it will override this
   * setting. The clean aperture will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
 //  kICMCompressionSessionOptionsPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio for compressed frames. Note that
   * if the compressor enforces a pixel aspect ratio,
   it will override
   * this setting. The pixel aspect ratio will be set on the output
   * image description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
  // kICMCompressionSessionOptionsPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the number and order of fields for compressed frames.
   * Note that if the compressor enforces field info,
   it will override
   * this setting. The field info will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
  // kICMCompressionSessionOptionsPropertyID_FieldInfo = 'fiel' /* FieldInfoImageDescriptionExtension2,
   //Read/Write */
//};
//enum {
   /*
   * Class identifier for compression session properties.
   */
  // kQTPropertyClass_ICMCompressionSession = 'icse',
   /*
   * The time scale for the compression session.
   */
 //  kICMCompressionSessionPropertyID_TimeScale = 'tscl',
   /* TimeScale,
   Read */
   /*
   * The compressor's pixel buffer attributes for the compression
   * session. You can use these to create a pixel buffer pool for
   * source pixel buffers. Note that this is not the same as the
   * sourcePixelBufferAttributes passed in to
   * ICMCompressionSessionCreate. Getting this property does not change
   * its retain count.
   */
  // kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes = 'batt',
   /* CFDictionaryRef,
   Read */
   /*
   * A pool that can provide ideal source pixel buffers for a
   * compression session. The compression session creates this pixel
   * buffer pool based on the compressor's pixel buffer attributes and
   * any pixel buffer attributes passed in to
   * ICMCompressionSessionCreate. If the source pixel buffer attributes
   * and the compressor pixel buffer attributes can not be reconciled,
   * the pool is based on the source pixel buffer attributes and the
   * ICM converts each CVPixelBuffer internally.
   */
  // kICMCompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * The image description for the compression session. For some
   * codecs,
   the image description may not be available before the
   * first frame is compressed. Multiple calls to retrieve this
   * property will return the same handle. The ICM will dispose this
   * handle when the compression session is disposed.
   * IMPORTANT: The caller must NOT dispose this handle.
   */
  // kICMCompressionSessionPropertyID_ImageDescription = 'idsc' /* ImageDescriptionHandle,
  // Read */
//};
//enum {
   /*
   * Class identifier for decompression frame options object properties.
   */
  // kQTPropertyClass_ICMDecompressionFrameOptions = 'idfo',
   /*
   * A specific pixel buffer that the frame should be decompressed
   * into. Setting this circumvents the pixel buffer pool mechanism. If
   * this buffer is not compatible with the codec's pixel buffer
   * requirements,
   decompression will fail.
   */
  // kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer = 'cvpb' /* CVPixelBufferRef,
 //  Read/Write */
//};
//enum {
   /*
   * Class identifier for decompression session options object
   * properties.
   */
  // kQTPropertyClass_ICMDecompressionSessionOptions = 'idso',
   /*
   * By default,
   this is true,
   meaning that frames must be output in
   * display order. Set this to false to allow frames to be output in
   * decode order rather than in display order.
   */
  // kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired = 'dorq',
   /* Boolean,
   Read/Write */
   /*
   * A specific decompressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * By default,
   this is anyCodec.
   */
   //kICMDecompressionSessionOptionsPropertyID_DecompressorComponent = 'imdc',
   /* DecompressorComponent,
   Read/Write */
   /*
   * The decompression accuracy.
   * The default accuracy is codecNormalQuality.
   */
//   kICMDecompressionSessionOptionsPropertyID_Accuracy = 'acur',
   /* CodecQ,
   Read/Write */
   /*
   * Requests special handling of fields. Not all codecs will obey this
   * request; some codecs will only handle it at certain accuracy
   * levels. Ignored for non-interlaced content.
   */
   //kICMDecompressionSessionOptionsPropertyID_FieldMode = 'fiel',
   /* ICMFieldMode,
   Read/Write */
   /*
   * The maximum number of buffers ahead of the current time that
   * should be decompressed. Used in sessions that target visual
   * contexts. By default,
   the number of buffers will be determined
   * from the visual context.
   */
  // kICMDecompressionSessionOptionsPropertyID_MaxBufferCount = 'm#bf',
   /* UInt32,
   Read/Write */
   /*
   * The minimum time ahead of the current time that frames should be
   * decompressed. Used in sessions that target visual contexts. By
   * default,
   the output-ahead time will be determined from the visual
   * context.
   */
  // kICMDecompressionSessionOptionsPropertyID_OutputAheadTime = 'futu' /* TimeRecord,
  // Read/Write */
////};
//enum {
   /*
   * Class identifier for decompression session properties.
   */
  // kQTPropertyClass_ICMDecompressionSession = 'icds',
   /*
   * The non-scheduled display time for a decompression session.
   * Setting this requests display of the non-scheduled queued frame at
   * that display time,
   if there is one.
   * See ICMDecompressionSessionSetNonScheduledDisplayTime.
   */
  // kICMDecompressionSessionPropertyID_NonScheduledDisplayTime = 'nsti',
   /* ICMNonScheduledDisplayTime,
   Read/Write */
   /*
   * The direction for non-scheduled display time.
   * See ICMDecompressionSessionSetNonScheduledDisplayDirection.
   */
  // kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection = 'nsdu',
   /* Fixed,
   Read/Write */
   /*
   * The pixel buffer pool from which emitted pixel buffers are
   * allocated. Getting this does not change the retain count of the
   * pool.
   */
 //  kICMDecompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * Indicates whether the a common pixel buffer pool is shared between
   * the decompressor and the session client. This is false if separate
   * pools are used because the decompressor's and the client's pixel
   * buffer attributes were incompatible.
   */
//   kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared = 'plsh' /* Boolean,
//   Read */
//};
//enum {
   /*
   * Class identifier for image description properties.
   */
  // kQTPropertyClass_ImageDescription = 'idsc',
   /*
   * The width of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's width field.
 //  */
//   kICMImageDescriptionPropertyID_EncodedWidth = 'encw',
   /* SInt32,
   Read/Write */
   /*
   * The height of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's height field.
   */
//   kICMImageDescriptionPropertyID_EncodedHeight = 'ench',
   /* SInt32,
   Read/Write */
   /*
   * Describes the clean aperture of the buffer. If not specified
   * explicitly in the image description,
   the default clean aperture
   * (full encoded width and height) will be returned.
   */
  // kICMImageDescriptionPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio. If not specified explicitly in
   * the image description,
   a square (1:1) pixel aspect ratio will be
   * returned.
   */
  // kICMImageDescriptionPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * A width at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
 //  kICMImageDescriptionPropertyID_DisplayWidth = 'disw',
   /* SInt32,
   Read */
   /*
   * A height at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
 //  kICMImageDescriptionPropertyID_DisplayHeight = 'dish',
   /* SInt32,
   Read */
   /*
   * A width at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayWidth instead.
   */
  // kICMImageDescriptionPropertyID_ProductionDisplayWidth = 'pdsw',
   /* SInt32,
   Read */
   /*
   * A height at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayHeight instead.
   */
 //  kICMImageDescriptionPropertyID_ProductionDisplayHeight = 'pdsh',
   /* SInt32,
   Read */
   /*
   * Color information,
   if available in the
   * NCLCColorInfoImageDescriptionExtension format.
   */
 //  kICMImageDescriptionPropertyID_NCLCColorInfo = 'nclc',
   /* Native-endian NCLCColorInfoImageDescriptionExtension,
   Read/Write */
   /*
   * The gamma level described by the image description.
   */
//   kICMImageDescriptionPropertyID_GammaLevel = 'gama',
   /* Fixed,
   Read/Write */
   /*
   * Information about the number and order of fields,
   if available.
   */
//   kICMImageDescriptionPropertyID_FieldInfo = 'fiel',
   /* FieldInfoImageDescriptionExtension2,
   Read/Write */
   /*
   * The offset in bytes from the start of one row to the next. Only
   * valid if the codec type is a chunky pixel format.
   */
 //  kICMImageDescriptionPropertyID_RowBytes = 'rowb',
   /* SInt32,
   Read/Write */
   /*
   * A track width suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
  // kICMImageDescriptionPropertyID_ClassicTrackWidth = 'claw',
   /* Fixed,
   Read */
   /*
   * A track height suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
  // kICMImageDescriptionPropertyID_ClassicTrackHeight = 'clah' /* Fixed,
 //  Read */
//};
//enum {
   /*
   * In this pass the compressor shall output encoded frames.
   */
  // kICMCompressionPassMode_OutputEncodedFrames = 1L << 0,
   /*
   * In this pass the client need not provide source frame buffers.
   */
   //kICMCompressionPassMode_NoSourceFrames = 1L << 1,
   /*
   * In this pass the compressor may write private data to multipass
   * storage.
   */
 //  kICMCompressionPassMode_WriteToMultiPassStorage = 1L << 2,
   /*
   * In this pass the compressor may read private data from multipass
   * storage.
   */
  // kICMCompressionPassMode_ReadFromMultiPassStorage = 1L << 3,
   /*
   * The compressor will set this flag to indicate that it will not be
   * able to output encoded frames in the coming pass. If this flag is
   * not set,
   then the client is allowed to set the
   * kICMCompressionPassMode_OutputEncodedFrames flag before calling
   * ICMCompressionSessionBeginPass.
   */
  // kICMCompressionPassMode_NotReadyToOutputEncodedFrames = 1L << 4
//};
//enum {
   /*
   * Indicates that this is the last call for this sourceFrameRefCon.
   */
  // kICMSourceTracking_LastCall   = 1L << 0,
   /*
   * Indicates that the session is done with the source pixel buffer
   * and has released any reference to it that it had.
   */
  // kICMSourceTracking_ReleasedPixelBuffer = 1L << 1,
   /*
   * Indicates that this frame was encoded.
   */
  // kICMSourceTracking_FrameWasEncoded = 1L << 2,
   /*
   * Indicates that this frame was dropped.
   */
   //kICMSourceTracking_FrameWasDropped = 1L << 3,
   /*
   * Indicates that this frame was merged into other frames.
   */
  // kICMSourceTracking_FrameWasMerged = 1L << 4,
   /*
   * Indicates that the time stamp of this frame was modified.
   */
 //  kICMSourceTracking_FrameTimeWasChanged = 1L << 5,
   /*
   * Indicates that the ICM has copied the image from the source pixel
   * buffer into another pixel buffer because the source pixel buffer
   * was not compatible with the compressor's required pixel buffer
   * attributes.
   */
 //  kICMSourceTracking_CopiedPixelBuffer = 1L << 6
//};
//enum {
   /*
   * The full width and height of source frames shall be scaled to the
   * full width and height of the destination. This is the default if
   * no other scaling mode is specified.
   */
//   kICMScalingMode_StretchProductionAperture = 'sp2p',
   /*
   * The clean aperture of the source frames shall be scaled to the
   * clean aperture of the destination.
   */
//   kICMScalingMode_StretchCleanAperture = 'sc2c',
   /*
   * The clean aperture of the source frames shall be scaled to fit
   * inside the clean aperture of the destination,
   preserving the
   * original display aspect ratio. If the display aspect ratios are
   * different,
   the source frames will be centered with black bars
   * above and below,
   or to the left and right.
   */
 //  kICMScalingMode_Letterbox     = 'lett',
   /*
   * The clean aperture of the source frames shall be scaled to cover
   * the clean aperture of the destination,
   preserving the original
   * display aspect ratio. If the display aspect ratios are different,
   * the source frames will be centered and cropped.
   */
  // kICMScalingMode_Trim          = 'trim'
/*};
Constants
kICMCompressionFrameOptionsPropertyID_ForceKeyFrame

Boolean, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionFrameOptionsPropertyID_FrameType

ICMFrameType, ReadWrite. 

Available in Mac OS X v10.3 and later.
kQTPropertyClass_ICMCompressionSessionOptions

Class identifier for compression session option object properties. Also 'icso'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression

Enables temporal compression of P-frames and B-frames. By default, temporal compression is disabled. Also 'p ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowFrameReordering

Enables frame reordering. To encode B-frames a compressor must reorder frames, which may mean that the order in which they are emitted and stored (the decode order) may be different from the order in which they are presented to the compressor (the display order). By default, frame reordering is disabled. To encode using B-frames, you must enable frame reordering by passing TRUE in this property. Also 'b ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DurationsNeeded

Indicates that durations of emitted frames are needed. If this option is set and source frames are provided with times but not durations, then frames will be delayed so that durations can be calculated as the difference between one frame's time stamp and the next frame's time stamp. By default, this flag is FALSE, so frames will not be delayed in order to calculate durations. If you pass encoded frames to AddMediaSampleFromEncodedFrame, you must set this flag to TRUE. Also 'need'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval

The maximum interval between key frames, also known as the key frame rate. Compressors are allowed to generate key frames more frequently if this would result in more efficient compression. The default key frame interval is 0, which indicates that the compressor should choose where to place all key frames. This differs from previous practice, in which a key frame rate of zero disabled temporal compression. Also 'kyfr'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges

Enables the compressor to modify frame times, improving its performance. Some compressors are able to identify and coalesce runs of identical frames and emit single frames with longer duration, or emit frames at a different frame rate from the original. By default, this flag is set to FALSE, which forces the compressor to emit one encoded frame for every source frame and to preserve frame display times. This option replaces the practice of having compressors return special high similarity values to indicate that frames can be dropped. Also '+ ok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion

Enables the compressor to call the encoded-frame callback from a different thread. By default this option is FALSE, which means that the compressor must call the encoded-frame callback from the same thread as ICMCompressionSessionEncodeFrame and ICMCompressionSessionCompleteFrames. Also 'asok'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount

The maximum frame delay count is the maximum number of frames that a compressor is allowed to hold before it must output a compressed frame. This value limits the number of frames that may be held in the compression window. If the maximum frame delay count is M, then before the call to encode frame N returns, frame N-M must have been emitted. The default value is kICMUnlimitedFrameDelayCount, which sets no limit on the compression window. Also 'cwin'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime

TimeValue64, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CompressorComponent

Sets a specific compressor component or component instance to be used, or passes one of the wildcards anyCodec, bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. Pass this option to force the Image Compression Manager to use a specific compressor component or compressor component instance. To allow the Image Compression Manager to choose the compressor component, set the compressorComponent to anyCodec (the default), bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. If you pass in a component instance that you opened, the ICM will not close that instance; you must do so after the compression session is released. Also 'imco'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CompressorSettings

A handle containing compressor settings. The compressor will be configured with these settings (by a call to ImageCodecSetSettings) during the ICMCompressionSessionCreate process. Also 'cost'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_Depth

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ColorTable

The color table for compression, used with indexed-color depths. Clients who are passed this property are responsible for disposing the returned CTabHandle. Also 'clut'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_Quality

The compression quality. This value is always used to set the spatial quality; if temporal compression is enabled, it is also used to set temporal quality. The default quality is codecNormalQuality. Also 'qual'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_AverageDataRate

The long-term desired average data rate in bytes per second. This is not an absolute limit. The default data rate is zero, indicating that the setting of kICMCompressionSessionOptionsPropertyID_Quality should determine the size of compressed data. Data rate settings have effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'aver'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DataRateLimits

Zero, one, or two hard limits on data rate. Each hard limit is described by a data size in bytes and a duration in seconds. It requires that the total size of compressed data for any contiguous segment of that duration (in decode time) must not exceed the data size. By default, no data rate limits are set. When setting this property, the inPropValueSize parameter should be the number of data rate limits multiplied by sizeof(ICMDataRateLimit). Data rate settings have an effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'hard'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_DataRateLimitCount

UInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits

UInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_WasCompressed

Indicates that the source was previously compressed. This property is an optional information hint to the compressor; by default it is FALSE. Also 'wasc'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CPUTimeBudget

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_MultiPassStorage

A multipass compression client must provide a storage location for multipass data. Pass ICMMultiPassStorageCreateWithTemporaryFile to make the ICM store multipass data in a temporary file. Pass ICMMultiPassStorageCreateWithCallbacks to manage the storage yourself. Note that the amount of multipass data to be stored can be substantial; it could be greater than the size of the output movie file. If this property is not NULL, the client must call ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass around groups of calls to ICMCompressionSessionEncodeFrame. By default, this property is NULL and multipass compression is not enabled. The compression session options object retains the multipass storage object when one is set. Also 'imps'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_SourceFrameCount

UInt64, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_ScalingMode

OSType, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_CleanAperture

Native-endian CleanApertureImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_PixelAspectRatio

Native-endian PixelAspectRatioImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMCompressionSessionOptionsPropertyID_FieldInfo

FieldInfoImageDescriptionExtension2, ReadWrite. 

Available in Mac OS X v10.3 and later.
kQTPropertyClass_ICMCompressionSession

Class identifier for compression session properties. Also 'icse'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_TimeScale

The time scale for the compression session. Also 'tscl'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes

The compressor's pixel buffer attributes for the compression session. You can use these to create a pixel buffer pool for source pixel buffers. This is not the same as the sourcePixelBufferAttributes property passed to ICMCompressionSessionCreate. Getting this property does not change its retain count. Also 'batt'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_PixelBufferPool

A pool that can provide ideal source pixel buffers for a compression session. The compression session creates this pixel buffer pool based on the compressor's pixel buffer attributes and any pixel buffer attributes passed in to ICMCompressionSessionCreate. If the source pixel buffer attributes and the compressor pixel buffer attributes can not be reconciled, the pool is based on the source pixel buffer attributes and the ICM converts each CVPixelBuffer internally. Also 'pool'.

Available in Mac OS X v10.3 and later.
kICMCompressionSessionPropertyID_ImageDescription

The image description for a compression session. For some codecs, the image description may not be available before the first frame is compressed. Multiple calls to retrieve this property will return the same handle. The ICM will dispose of this handle when the compression session is disposed; the caller must not dispose of it. Also 'idsc'.

Available in Mac OS X v10.3 and later.
kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer

CVPixelBufferRef, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired

Boolean, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_DecompressorComponent

DecompressorComponent, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_Accuracy

CodecQ, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_FieldMode

ICMFieldMode, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_MaxBufferCount

UInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionOptionsPropertyID_OutputAheadTime

TimeRecord, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_NonScheduledDisplayTime

ICMNonScheduledDisplayTime, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_PixelBufferPool

CVPixelBufferPoolRef, Read. 

Available in Mac OS X v10.3 and later.
kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared

Boolean, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_EncodedWidth

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_EncodedHeight

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_CleanAperture

Native-endian CleanApertureImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_PixelAspectRatio

Native-endian PixelAspectRatioImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_DisplayWidth

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_DisplayHeight

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ProductionDisplayWidth

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ProductionDisplayHeight

SInt32, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_NCLCColorInfo

Native-endian NCLCColorInfoImageDescriptionExtension, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_GammaLevel

Fixed, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_FieldInfo

FieldInfoImageDescriptionExtension2, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_RowBytes

SInt32, ReadWrite. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ClassicTrackWidth

Fixed, Read. 

Available in Mac OS X v10.3 and later.
kICMImageDescriptionPropertyID_ClassicTrackHeight

Fixed, Read. 

Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

enum {
   /*
   * Both fields should be decompressed.
   */
   kICMFieldMode_BothFields      = 0,
   /*
   * Only the top field should be decompressed,
   producing a half-height
   * image.
   */
   kICMFieldMode_TopFieldOnly    = 1,
   /*
   * Only the bottom field should be decompressed,
   producing a
   * half-height image.
   */
   kICMFieldMode_BottomFieldOnly = 2,
   /*
   * Both fields should be decompressed,
   and then filtered to reduce
   * interlacing artifacts.
   */
   kICMFieldMode_DeinterlaceFields = 3
};
enum {
   /*
   * Class identifier for compression frame options object properties.
   */
   kQTPropertyClass_ICMCompressionFrameOptions = 'icfo',
   /*
   * Forces frames to be compressed as key frames.
   * The compressor must obey the "force key frame" flag if set. By
   * default this property is false.
   */
   kICMCompressionFrameOptionsPropertyID_ForceKeyFrame = 'keyf',
   /* Boolean,
   Read/Write */
   /*
   * Requests a frame be compressed as a particular frame type.
   *  The frame type setting may be ignored by the compressor if not
   * appropriate.
   * By default this is set to kICMFrameType_Unknown.
   * Do not assume that kICMFrameType_I means a key frame; if you need
   * a key frame,
   set the "force key frame" property.
   */
   kICMCompressionFrameOptionsPropertyID_FrameType = 'frty' /* ICMFrameType,
   Read/Write */
};
enum {
   /*
   * Class identifier for compression session options object properties.
   */
   kQTPropertyClass_ICMCompressionSessionOptions = 'icso',
   /*
   * Enables temporal compression. By default,
   temporal compression is
   * disabled.
   * IMPORTANT: If you want temporal compression (P frames and/or B
   * frames) you must set this to true.
   */
   kICMCompressionSessionOptionsPropertyID_AllowTemporalCompression = 'p ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables frame reordering.
   * In order to encode B frames,
   a compressor must reorder frames,
   * which means that the order in which they will be emitted and
   * stored (the decode order) is different from the order in which
   * they were presented to the compressor (the display order).
   * By default,
   frame reordering is disabled.
   * IMPORTANT: In order to encode using B frames,
   you must enable
   * frame reordering.
   */
   kICMCompressionSessionOptionsPropertyID_AllowFrameReordering = 'b ok',
   /* Boolean,
   Read/Write */
   /*
   * Indicates that durations of emitted frames are needed.
   * If this flag is set and source frames are provided with times but
   * not durations,
   then frames will be delayed so that durations can
   * be calculated as the difference between one frame's time stamp and
   * the next frame's time stamp.
   * By default,
   this flag is clear,
   so frames will not be delayed in
   * order to calculate durations.
   * IMPORTANT: If you will be passing encoded frames to
   * AddMediaSampleFromEncodedFrame,
   you must set this flag to true.
   */
   kICMCompressionSessionOptionsPropertyID_DurationsNeeded = 'need',
   /* Boolean,
   Read/Write */
   /*
   * The maximum interval between key frames,
   also known as the key
   * frame rate.
   * Key frames,
   also known as sync frames,
   reset inter-frame
   * dependencies; decoding a key frame is sufficient to prepare a
   * decompressor for correctly decoding the difference frames that
   * follow.
   * Compressors are allowed to generate key frames more frequently if
   * this would result in more efficient compression.
   * The default key frame interval is 0,
   which indicates that the
   * compressor should choose where to place all key frames. A key
   * frame interval of 1 indicates that every frame must be a key
   * frame,
   2 indicates that at least every other frame must be a key
   * frame,
   etc.
   */
   kICMCompressionSessionOptionsPropertyID_MaxKeyFrameInterval = 'kyfr',
   /* SInt32,
   Read/Write */
   /*
   * The requested maximum interval between partial sync frames. If the
   * interval is n,
   any sequence of n successive frames must include at
   * least one key or partial sync frame.
   * Where supported,
   partial sync frames perform a partial reset of
   * inter-frame dependencies; decoding two partial sync frames and the
   * non-droppable difference frames between them is sufficient to
   * prepare a decompressor for correctly decoding the difference
   * frames that follow.
   * Compressors are allowed to generate partial sync frames more
   * frequently if this would result in more efficient compression.
   *
   * The default partial sync frame interval is 0,
   which indicates that
   * the compressor should choose where to place partial sync frames. A
   * partial sync frame interval of 1 means there can be no difference
   * frames,
   so it is equivalent to a key frame interval of 1. A
   * partial sync frame interval of 2 means that every other frame must
   * be a key frame or a partial sync frame.
   * Compressors that do not support partial sync frames will ignore
   * this setting.
   */
   kICMCompressionSessionOptionsPropertyID_MaxPartialSyncFrameInterval = 'psfr',
   /* SInt32,
   Read/Write */
   /*
   * Enables the compressor to modify frame times.
   * Some compressors are able to identify and coalesce runs of
   * identical frames and output single frames with longer duration,
   or
   * output frames at a different frame rate from the original. This
   * feature is controlled by the "allow frame time changes" flag. By
   * default,
   this flag is set to false,
   which forces compressors to
   * emit one encoded frame for every source frame,
   and to preserve
   * frame display times.
   * (Note: this feature replaces the practice of having compressors
   * return special high similarity values to indicate that frames
   * could be dropped.)
   * If you want to allow the compressor to modify frame times in order
   * to improve compression performance,
   enable frame time changes.
   */
   kICMCompressionSessionOptionsPropertyID_AllowFrameTimeChanges = '+ ok',
   /* Boolean,
   Read/Write */
   /*
   * Enables the compressor to call the encoded-frame callback from a
   * different thread.
   * By default,
   the flag is false,
   which means that the compressor
   * must call the encoded-frame callback from the same thread that
   * ICMCompressionSessionEncodeFrame and
   * ICMCompressionSessionCompleteFrames were called on.
   */
   kICMCompressionSessionOptionsPropertyID_AllowAsyncCompletion = 'asok',
   /* Boolean,
   Read/Write */
   /*
   * The maximum frame delay count is the maximum number of frames that
   * a compressor is allowed to hold before it must output a compressed
   * frame. It limits the number of frames that may be held in the
   * "compression window". If the maximum frame delay count is M,
   then
   * before the call to encode frame N returns,
   frame N-M must have
   * been emitted.
   * The default is kICMUnlimitedFrameDelayCount,
   which sets no limit
   * on the compression window.
   */
   kICMCompressionSessionOptionsPropertyID_MaxFrameDelayCount = 'cwin',
   /* SInt32,
   Read/Write */
   /*
   * The maximum frame delay time is the maximum difference between a
   * source frame's display time and the corresponding encoded frame's
   * decode time. It limits the span of display time that may be held
   * in the "compression window". If the maximum frame delay time is
   * TM,
   then before the call to encode a frame with display time TN
   * returns,
   all frames with display times up to and including TN-TM
   * must have been emitted.
   * The default is kICMUnlimitedFrameDelayTime,
   which sets no time
   * limit on the compression window.
   */
   kICMCompressionSessionOptionsPropertyID_MaxFrameDelayTime = 'cwit',
   /* TimeValue64,
   Read/Write */
   /*
   * Sets a specific compressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * Use this API to force the Image Compression Manager to use a
   * specific compressor component or compressor component instance.
   * (If you pass in a component instance that you opened,
   the ICM will
   * not close that instance; you must do so after the compression
   * session is released.) To allow the Image Compression Manager to
   * choose the compressor component,
   set the compressorComponent to
   * anyCodec (the default),
   bestSpeedCodec,
   bestFidelityCodec or
   * bestCompressionCodec.
   */
   kICMCompressionSessionOptionsPropertyID_CompressorComponent = 'imco',
   /* CompressorComponent,
   Read/Write */
   /*
   * A handle containing compressor settings. The compressor will be
   * configured with these settings (by a call to
   * ImageCodecSetSettings) during ICMCompressionSessionCreate.
   */
   kICMCompressionSessionOptionsPropertyID_CompressorSettings = 'cost',
   /* Handle,
   Read/Write */
   /*
   * The depth for compression.
   * If a compressor does not support a specific depth,
   the closest
   * supported depth will be used (preferring deeper depths to
   * shallower depths). The default depth is k24RGBPixelFormat.
   */
   kICMCompressionSessionOptionsPropertyID_Depth = 'deep',
   /* UInt32,
   Read/Write */
   /*
   * The color table for compression.  Used with indexed-color depths.
   *
   * Clients who get this property are responsible for disposing the
   * returned CTabHandle.
   */
   kICMCompressionSessionOptionsPropertyID_ColorTable = 'clut',
   /* CTabHandle,
   Read/Write*/
   /*
   * The compression quality.
   * This value is always used to set the spatialQuality; if temporal
   * compression is enabled,
   it is also used to set temporalQuality.
   * <BR> The default quality is codecNormalQuality.
   */
   kICMCompressionSessionOptionsPropertyID_Quality = 'qual',
   /* CodecQ,
   Read/Write */
   /*
   * The long-term desired average data rate in bytes per second.
   *  This is not a hard limit.
   * The default data rate is zero,
   which indicates that the quality
   * setting should determine the size of compressed data.
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
   kICMCompressionSessionOptionsPropertyID_AverageDataRate = 'aver',
   /* SInt32,
   Read/Write */
   /*
   * Zero,
   one or two hard limits on data rate.
   * Each hard limit is described by a data size in bytes and a
   * duration in seconds,
   and requires that the total size of
   * compressed data for any contiguous segment of that duration (in
   * decode time) must not exceed the data size.
   * By default,
   no data rate limits are set.
   * When setting this property,
   the inPropValueSize parameter should
   * be the number of data rate limits multiplied by
   * sizeof(ICMDataRateLimit).
   * Note that data rate settings only have an effect when timing
   * information is provided for source frames,
   and that some codecs do
   * not support limiting to specified data rates.
   */
   kICMCompressionSessionOptionsPropertyID_DataRateLimits = 'hard',
   /* C array of ICMDataRateLimit struct,
   Read/Write */
   /*
   * The current number of data rate limits.
   */
   kICMCompressionSessionOptionsPropertyID_DataRateLimitCount = 'har#',
   /* UInt32,
   Read */
   /*
   * The maximum allowed number of data rate limits.  (Currently 2.)
   */
   kICMCompressionSessionOptionsPropertyID_MaxDataRateLimits = 'mhar',
   /* UInt32,
   Read */
   /*
   * Indicates that the source was previously compressed.
   * This property is purely an optional,
   informational hint to the
   * compressor; by default it is false.
   */
   kICMCompressionSessionOptionsPropertyID_WasCompressed = 'wasc',
   /* Boolean,
   Read/Write */
   /*
   * Recommends a CPU time budget for the compressor in microseconds
   * per frame.
   * Zero means to go as fast as possible.
   * By default,
   this is set to kICMUnlimitedCPUTimeBudget,
   which sets
   * no limit.
   * This is an advisory hint to the compressor,
   and some compressors
   * may ignore it. Multithreaded compressors may use this amount of
   * CPU time on each processor.
   * Compressors should not feel compelled to use the full time budget
   * if they complete ahead of time!
   */
   kICMCompressionSessionOptionsPropertyID_CPUTimeBudget = 'cput',
   /* UInt32,
   Read/Write */
   /*
   * Storage for multi-pass compression.
   * To enable multipass compression,
   the client must provide a storage
   * location for multipass data.  Use
   * ICMMultiPassStorageCreateWithTemporaryFile to have the ICM store
   * it in a temporary file.  Use
   * ICMMultiPassStorageCreateWithCallbacks to manage the storage
   * yourself.
   * Note that the amount of multipass data to be stored can be
   * substantial; it could be greater than the size of the output movie
   * file.
   * If this property is not NULL,
   the client must call
   * ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass
   * around groups of calls to ICMCompressionSessionEncodeFrame.
   *  By default,
   this property is NULL and multipass compression is
   * not enabled. The compression session options object retains the
   * multipass storage object,
   when one is set.
   */
   kICMCompressionSessionOptionsPropertyID_MultiPassStorage = 'imps',
   /* ICMMultiPassStorageRef,
   Read/Write */
   /*
   * Indicates the number of source frames,
   if known. If nonzero,
   this
   * should be the exact number of times that the client calls
   * ICMCompressionSessionEncodeFrame in each pass.
   * The default is 0,
   which indicates that the number of source frames
   * is not known.
   */
   kICMCompressionSessionOptionsPropertyID_SourceFrameCount = 'frco',
   /* UInt64,
   Read/Write */
   /*
   * Indicates the expected frame rate,
   if known. The frame rate is
   * measured in frames per second. This is not used to control the
   * frame rate; it is provided as a hint to the compressor so that it
   * can set up internal configuration before compression begins. The
   * actual frame rate will depend on frame durations and may vary. By
   * default,
   this is zero,
   indicating "unknown".
   */
   kICMCompressionSessionOptionsPropertyID_ExpectedFrameRate = 'fran',
   /* Fixed,
   Read/Write */
   /*
   * Indicates how source frames to a compression session should be
   * scaled if the dimensions and/or display aspect ratio do not match.
   */
   kICMCompressionSessionOptionsPropertyID_ScalingMode = 'scam',
   /* OSType,
   Read/Write */
   /*
   * Describes the clean aperture for compressed frames. Note that if
   * the compressor enforces a clean aperture,
   it will override this
   * setting. The clean aperture will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio for compressed frames. Note that
   * if the compressor enforces a pixel aspect ratio,
   it will override
   * this setting. The pixel aspect ratio will be set on the output
   * image description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the number and order of fields for compressed frames.
   * Note that if the compressor enforces field info,
   it will override
   * this setting. The field info will be set on the output image
   * description and may affect scaling in some scaling modes. By
   * default,
   this is all zeros,
   meaning unset.
   */
   kICMCompressionSessionOptionsPropertyID_FieldInfo = 'fiel' /* FieldInfoImageDescriptionExtension2,
   Read/Write */
};
enum {
   /*
   * Class identifier for compression session properties.
   */
   kQTPropertyClass_ICMCompressionSession = 'icse',
   /*
   * The time scale for the compression session.
   */
   kICMCompressionSessionPropertyID_TimeScale = 'tscl',
   /* TimeScale,
   Read */
   /*
   * The compressor's pixel buffer attributes for the compression
   * session. You can use these to create a pixel buffer pool for
   * source pixel buffers. Note that this is not the same as the
   * sourcePixelBufferAttributes passed in to
   * ICMCompressionSessionCreate. Getting this property does not change
   * its retain count.
   */
   kICMCompressionSessionPropertyID_CompressorPixelBufferAttributes = 'batt',
   /* CFDictionaryRef,
   Read */
   /*
   * A pool that can provide ideal source pixel buffers for a
   * compression session. The compression session creates this pixel
   * buffer pool based on the compressor's pixel buffer attributes and
   * any pixel buffer attributes passed in to
   * ICMCompressionSessionCreate. If the source pixel buffer attributes
   * and the compressor pixel buffer attributes can not be reconciled,
   * the pool is based on the source pixel buffer attributes and the
   * ICM converts each CVPixelBuffer internally.
   */
   kICMCompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * The image description for the compression session. For some
   * codecs,
   the image description may not be available before the
   * first frame is compressed. Multiple calls to retrieve this
   * property will return the same handle. The ICM will dispose this
   * handle when the compression session is disposed.
   * IMPORTANT: The caller must NOT dispose this handle.
   */
   kICMCompressionSessionPropertyID_ImageDescription = 'idsc' /* ImageDescriptionHandle,
   Read */
};
enum {
   /*
   * Class identifier for decompression frame options object properties.
   */
   kQTPropertyClass_ICMDecompressionFrameOptions = 'idfo',
   /*
   * A specific pixel buffer that the frame should be decompressed
   * into. Setting this circumvents the pixel buffer pool mechanism. If
   * this buffer is not compatible with the codec's pixel buffer
   * requirements,
   decompression will fail.
   */
   kICMDecompressionFrameOptionsPropertyID_DestinationPixelBuffer = 'cvpb' /* CVPixelBufferRef,
   Read/Write */
};
enum {
   /*
   * Class identifier for decompression session options object
   * properties.
   */
   kQTPropertyClass_ICMDecompressionSessionOptions = 'idso',
   /*
   * By default,
   this is true,
   meaning that frames must be output in
   * display order. Set this to false to allow frames to be output in
   * decode order rather than in display order.
   */
   kICMDecompressionSessionOptionsPropertyID_DisplayOrderRequired = 'dorq',
   /* Boolean,
   Read/Write */
   /*
   * A specific decompressor component or component instance to be
   * used,
   or one of the wildcards anyCodec,
   bestSpeedCodec,
   * bestFidelityCodec,
   or bestCompressionCodec.
   * By default,
   this is anyCodec.
   */
   kICMDecompressionSessionOptionsPropertyID_DecompressorComponent = 'imdc',
   /* DecompressorComponent,
   Read/Write */
   /*
   * The decompression accuracy.
   * The default accuracy is codecNormalQuality.
   */
   kICMDecompressionSessionOptionsPropertyID_Accuracy = 'acur',
   /* CodecQ,
   Read/Write */
   /*
   * Requests special handling of fields. Not all codecs will obey this
   * request; some codecs will only handle it at certain accuracy
   * levels. Ignored for non-interlaced content.
   */
   kICMDecompressionSessionOptionsPropertyID_FieldMode = 'fiel',
   /* ICMFieldMode,
   Read/Write */
   /*
   * The maximum number of buffers ahead of the current time that
   * should be decompressed. Used in sessions that target visual
   * contexts. By default,
   the number of buffers will be determined
   * from the visual context.
   */
   kICMDecompressionSessionOptionsPropertyID_MaxBufferCount = 'm#bf',
   /* UInt32,
   Read/Write */
   /*
   * The minimum time ahead of the current time that frames should be
   * decompressed. Used in sessions that target visual contexts. By
   * default,
   the output-ahead time will be determined from the visual
   * context.
   */
   kICMDecompressionSessionOptionsPropertyID_OutputAheadTime = 'futu' /* TimeRecord,
   Read/Write */
};
enum {
   /*
   * Class identifier for decompression session properties.
   */
   kQTPropertyClass_ICMDecompressionSession = 'icds',
   /*
   * The non-scheduled display time for a decompression session.
   * Setting this requests display of the non-scheduled queued frame at
   * that display time,
   if there is one.
   * See ICMDecompressionSessionSetNonScheduledDisplayTime.
   */
   kICMDecompressionSessionPropertyID_NonScheduledDisplayTime = 'nsti',
   /* ICMNonScheduledDisplayTime,
   Read/Write */
   /*
   * The direction for non-scheduled display time.
   * See ICMDecompressionSessionSetNonScheduledDisplayDirection.
   */
   kICMDecompressionSessionPropertyID_NonScheduledDisplayDirection = 'nsdu',
   /* Fixed,
   Read/Write */
   /*
   * The pixel buffer pool from which emitted pixel buffers are
   * allocated. Getting this does not change the retain count of the
   * pool.
   */
   kICMDecompressionSessionPropertyID_PixelBufferPool = 'pool',
   /* CVPixelBufferPoolRef,
   Read */
   /*
   * Indicates whether the a common pixel buffer pool is shared between
   * the decompressor and the session client. This is false if separate
   * pools are used because the decompressor's and the client's pixel
   * buffer attributes were incompatible.
   */
   kICMDecompressionSessionPropertyID_PixelBufferPoolIsShared = 'plsh' /* Boolean,
   Read */
};
enum {
   /*
   * Class identifier for image description properties.
   */
   kQTPropertyClass_ImageDescription = 'idsc',
   /*
   * The width of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's width field.
   */
   kICMImageDescriptionPropertyID_EncodedWidth = 'encw',
   /* SInt32,
   Read/Write */
   /*
   * The height of the encoded image. Usually,
   but not always,
   this is
   * the ImageDescription's height field.
   */
   kICMImageDescriptionPropertyID_EncodedHeight = 'ench',
   /* SInt32,
   Read/Write */
   /*
   * Describes the clean aperture of the buffer. If not specified
   * explicitly in the image description,
   the default clean aperture
   * (full encoded width and height) will be returned.
   */
   kICMImageDescriptionPropertyID_CleanAperture = 'clap',
   /* Native-endian CleanApertureImageDescriptionExtension,
   Read/Write */
   /*
   * Describes the pixel aspect ratio. If not specified explicitly in
   * the image description,
   a square (1:1) pixel aspect ratio will be
   * returned.
   */
   kICMImageDescriptionPropertyID_PixelAspectRatio = 'pasp',
   /* Native-endian PixelAspectRatioImageDescriptionExtension,
   Read/Write */
   /*
   * A width at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
   kICMImageDescriptionPropertyID_DisplayWidth = 'disw',
   /* SInt32,
   Read */
   /*
   * A height at which the buffer's image could be displayed on a
   * square-pixel display,
   possibly calculated using the clean aperture
   * and pixel aspect ratio.
   */
   kICMImageDescriptionPropertyID_DisplayHeight = 'dish',
   /* SInt32,
   Read */
   /*
   * A width at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayWidth instead.
   */
   kICMImageDescriptionPropertyID_ProductionDisplayWidth = 'pdsw',
   /* SInt32,
   Read */
   /*
   * A height at which the image could be displayed on a square-pixel
   * display,
   disregarding any clean aperture but honoring the pixel
   * aspect ratio. This may be useful for authoring applications that
   * want to expose the edge processing region. For general viewing,
   * use kICMImageDescriptionPropertyID_DisplayHeight instead.
   */
   kICMImageDescriptionPropertyID_ProductionDisplayHeight = 'pdsh',
   /* SInt32,
   Read */
   /*
   * Color information,
   if available in the
   * NCLCColorInfoImageDescriptionExtension format.
   */
   kICMImageDescriptionPropertyID_NCLCColorInfo = 'nclc',
   /* Native-endian NCLCColorInfoImageDescriptionExtension,
   Read/Write */
   /*
   * The gamma level described by the image description.
   */
   kICMImageDescriptionPropertyID_GammaLevel = 'gama',
   /* Fixed,
   Read/Write */
   /*
   * Information about the number and order of fields,
   if available.
   */
   kICMImageDescriptionPropertyID_FieldInfo = 'fiel',
   /* FieldInfoImageDescriptionExtension2,
   Read/Write */
   /*
   * The offset in bytes from the start of one row to the next. Only
   * valid if the codec type is a chunky pixel format.
   */
   kICMImageDescriptionPropertyID_RowBytes = 'rowb',
   /* SInt32,
   Read/Write */
   /*
   * A track width suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
   kICMImageDescriptionPropertyID_ClassicTrackWidth = 'claw',
   /* Fixed,
   Read */
   /*
   * A track height suitable for passing to NewMovieTrack when creating
   * a new track to hold this image data.
   */
   kICMImageDescriptionPropertyID_ClassicTrackHeight = 'clah' /* Fixed,
   Read */
};
enum {
   /*
   * In this pass the compressor shall output encoded frames.
   */
   kICMCompressionPassMode_OutputEncodedFrames = 1L << 0,
   /*
   * In this pass the client need not provide source frame buffers.
   */
   kICMCompressionPassMode_NoSourceFrames = 1L << 1,
   /*
   * In this pass the compressor may write private data to multipass
   * storage.
   */
   kICMCompressionPassMode_WriteToMultiPassStorage = 1L << 2,
   /*
   * In this pass the compressor may read private data from multipass
   * storage.
   */
   kICMCompressionPassMode_ReadFromMultiPassStorage = 1L << 3,
   /*
   * The compressor will set this flag to indicate that it will not be
   * able to output encoded frames in the coming pass. If this flag is
   * not set,
   then the client is allowed to set the
   * kICMCompressionPassMode_OutputEncodedFrames flag before calling
   * ICMCompressionSessionBeginPass.
   */
   kICMCompressionPassMode_NotReadyToOutputEncodedFrames = 1L << 4
};
enum {
   /*
   * Indicates that this is the last call for this sourceFrameRefCon.
   */
   kICMSourceTracking_LastCall   = 1L << 0,
   /*
   * Indicates that the session is done with the source pixel buffer
   * and has released any reference to it that it had.
   */
   kICMSourceTracking_ReleasedPixelBuffer = 1L << 1,
   /*
   * Indicates that this frame was encoded.
   */
   kICMSourceTracking_FrameWasEncoded = 1L << 2,
   /*
   * Indicates that this frame was dropped.
   */
   kICMSourceTracking_FrameWasDropped = 1L << 3,
   /*
   * Indicates that this frame was merged into other frames.
   */
   kICMSourceTracking_FrameWasMerged = 1L << 4,
   /*
   * Indicates that the time stamp of this frame was modified.
   */
   kICMSourceTracking_FrameTimeWasChanged = 1L << 5,
   /*
   * Indicates that the ICM has copied the image from the source pixel
   * buffer into another pixel buffer because the source pixel buffer
   * was not compatible with the compressor's required pixel buffer
   * attributes.
   */
   kICMSourceTracking_CopiedPixelBuffer = 1L << 6
};
enum {
   /*
   * The full width and height of source frames shall be scaled to the
   * full width and height of the destination. This is the default if
   * no other scaling mode is specified.
   */
   kICMScalingMode_StretchProductionAperture = 'sp2p',
   /*
   * The clean aperture of the source frames shall be scaled to the
   * clean aperture of the destination.
   */
   kICMScalingMode_StretchCleanAperture = 'sc2c',
   /*
   * The clean aperture of the source frames shall be scaled to fit
   * inside the clean aperture of the destination,
   preserving the
   * original display aspect ratio. If the display aspect ratios are
   * different,
   the source frames will be centered with black bars
   * above and below,
   or to the left and right.
   */
   kICMScalingMode_Letterbox     = 'lett',
   /*
   * The clean aperture of the source frames shall be scaled to cover
   * the clean aperture of the destination,
   preserving the original
   * display aspect ratio. If the display aspect ratios are different,
   * the source frames will be centered and cropped.
   */
   kICMScalingMode_Trim          = 'trim'
};

/*ICMDecompressionTrackingCallbackRecord

Designates a tracking callback for an ICM decompression session.

struct ICMDecompressionTrackingCallbackRecord {
   ICMDecompressionTrackingCallback    decompressionTrackingCallback;
   void                                *decompressionTrackingRefCon;
};
Fields
decompressionTrackingCallback
Discussion

The callback function pointer. See ICMDecompressionTrackingCallbackProc.
decompressionTrackingRefCon
Discussion

The callback's reference value.
Declared In
ImageCompression.h*/
struct ICMDecompressionTrackingCallbackRecord {
   ICMDecompressionTrackingCallback    decompressionTrackingCallback;
   void                                *decompressionTrackingRefCon;
};
typedef  struct ICMDecompressionTrackingCallbackRecord ICMDecompressionTrackingCallbackRecord;
/*ImageDescriptionPtr

Abst_ImageDescriptionPtr

typedef ImageDescription * ImageDescriptionPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ImageDescription * ImageDescriptionPtr;

/*ImageDescriptionHandle

Abst_ImageDescriptionHandle

typedef ImageDescriptionPtr * ImageDescriptionHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ImageDescriptionPtr * ImageDescriptionHandle;

/*ICMFrameTimeRecord

Contains a frame's time information for scheduled asynchronous decompression operations.

struct ICMFrameTimeRecord {
   wide           value;
   long           scale;
   void *         base;
   long           duration;
   Fixed          rate;
   long           recordSize;
   long           frameNumber;
   long           flags;
   wide           virtualStartTime;
   long           virtualDuration;
   TimeValue64    decodeTime;
};
Fields
value
Discussion

Specifies the time at which the frame is to be displayed.
scale
Discussion

Indicates the units for the frame's display time.
base
Discussion

Refers to the time base.
duration
Discussion

Specifies the duration for which the frame is to be displayed. This must be in the same units as specified by the scale field. It is 0 if the duration is unknown.
rate
Discussion

Indicates the time base's effective rate.
recordSize
Discussion

Total number of bytes in this structure.
frameNumber
Discussion

Number of frame; 0 if the frame number is not known.
flags
Discussion

Flag (see below) to indicate if virtualStartTime and virtualDuration are valid. See these constants: 
icmFrameTimeHasVirtualStartTimeAndDuration
icmFrameTimeHasDecodeTime
virtualStartTime
Discussion

Conceptual start time.
virtualDuration
Discussion

Conceptual duration.
decodeTime
Discussion

Suggested decode time. Valid only if icmFrameTimeHasDecodeTime is set in the flags parameter.
Programming Info
C interface file: ImageCompression.h*/
struct ICMFrameTimeRecord {
   wide           value;
   long           scale;
   void *         base;
   long           duration;
   Fixed          rate;
   long           recordSize;
   long           frameNumber;
   long           flags;
   wide           virtualStartTime;
   long           virtualDuration;
   TimeValue64    decodeTime;
};
typedef  struct ICMFrameTimeRecord ICMFrameTimeRecord;
typedef ICMFrameTimeRecord *ICMFrameTimePtr; //hys

/*Component Property IDs and Flags

Constants that contain the flags and IDs of component properties.

uppCallComponentGetComponentPropertyInfoProcInfo = 0x0003FFF0
uppCallComponentGetComponentPropertyProcInfo = 0x0003FFF0
uppCallComponentSetComponentPropertyProcInfo = 0x0000FFF0
uppCallComponentAddComponentPropertyListenerProcInfo = 0x0000FFF0
uppCallComponentRemoveComponentPropertyListenerProcInfo = 0x0000FFF0
kCallComponentExecuteWiredActionSelect     = -9
kComponentPropertyFlagCanSetLater = (1L << 0)
kComponentPropertyFlagCanSetNow = (1L << 1)
kComponentPropertyFlagCanGetNow = (1L << 3)
kComponentPropertyFlagHasExtendedInfo = (1L << 4)
kComponentPropertyFlagValueMustBeReleased = (1L << 5)
kComponentPropertyFlagValueIsCFTypeRef = (1L << 6)
kComponentPropertyFlagGetBufferMustBeInitialized = (1L << 7)
kQTComponentPropertyListenerCollectionContextVersion = 1
kQTGetComponentPropertyInfoSelect          = -11
kQTGetComponentPropertySelect              = -12
kQTSetComponentPropertySelect              = -13
kQTAddComponentPropertyListenerSelect      = -14
kQTRemoveComponentPropertyListenerSelect   = -15*/
enum {
uppCallComponentGetComponentPropertyInfoProcInfo = 0x0003FFF0,
uppCallComponentGetComponentPropertyProcInfo = 0x0003FFF0,
uppCallComponentSetComponentPropertyProcInfo = 0x0000FFF0,
uppCallComponentAddComponentPropertyListenerProcInfo = 0x0000FFF0,
uppCallComponentRemoveComponentPropertyListenerProcInfo = 0x0000FFF0,
kCallComponentExecuteWiredActionSelect     = -9,
kComponentPropertyFlagCanSetLater = (1L << 0),
kComponentPropertyFlagCanSetNow = (1L << 1),
kComponentPropertyFlagCanGetNow = (1L << 3),
kComponentPropertyFlagHasExtendedInfo = (1L << 4),
kComponentPropertyFlagValueMustBeReleased = (1L << 5),
kComponentPropertyFlagValueIsCFTypeRef = (1L << 6),
kComponentPropertyFlagGetBufferMustBeInitialized = (1L << 7),
kQTComponentPropertyListenerCollectionContextVersion = 1,
kQTGetComponentPropertyInfoSelect          = -11,
kQTGetComponentPropertySelect              = -12,
kQTSetComponentPropertySelect              = -13,
kQTAddComponentPropertyListenerSelect      = -14,
kQTRemoveComponentPropertyListenerSelect   = -15,
};

/*QTSetComponentProperty Values

Constants passed to QTSetComponentProperty.

enum {
   kComponentPropertyCacheFlagNotPersistent = (1L << 0),
   // property metadata should not be saved in persistent cache
   kComponentPropertyCacheFlagIsDynamic = (1L << 1) //property metadata should not cached at all
};
enum {
   kComponentPropertyClassPropertyInfo = 'pnfo',
   // property info class 
   // property info property IDs 
   kComponentPropertyInfoList    = 'list',
   //array of ComponentPropertyInfo (CFData),
   //one for each property 
   kComponentPropertyCacheSeed   = 'seed',
   // property cache seed value 
   kComponentPropertyCacheFlags  = 'flgs',
   // see kComponentPropertyCache flags 
   kComponentPropertyExtendedInfo = 'meta' // CFDictionary with extended property information
};
Constants
kComponentPropertyCacheFlagNotPersistent

Property metadata should not be saved in persistent cache. 

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheFlagIsDynamic

Property metadata should not be cached at all. 

Available in Mac OS X v10.3 and later.
kComponentPropertyClassPropertyInfo

A QTComponentPropertyInfo structure that defines a property information class. Also 'pnfo'.

Available in Mac OS X v10.3 and later.
kComponentPropertyInfoList

An array of QTComponentPropertyInfo structures, one for each property. Also 'list'.

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheSeed

A component property cache seed value. Also 'seed'.

Available in Mac OS X v10.3 and later.
kComponentPropertyCacheFlags

One of the following two flags: Also 'flgs'.

Available in Mac OS X v10.3 and later.*/
enum {
   kComponentPropertyCacheFlagNotPersistent = (1L << 0),
   // property metadata should not be saved in persistent cache
   kComponentPropertyCacheFlagIsDynamic = (1L << 1) //property metadata should not cached at all
};
enum {
   kComponentPropertyClassPropertyInfo = 'pnfo',
   // property info class 
   // property info property IDs 
   kComponentPropertyInfoList    = 'list',
   //array of ComponentPropertyInfo (CFData),
   //one for each property 
   kComponentPropertyCacheSeed   = 'seed',
   // property cache seed value 
   kComponentPropertyCacheFlags  = 'flgs',
   // see kComponentPropertyCache flags 
   kComponentPropertyExtendedInfo = 'meta' // CFDictionary with extended property information
};

/*VDSetCompression Values

Constants passed to VDSetCompression.

enum {
   codecLosslessQuality          = 0x00000400,
   codecMaxQuality               = 0x000003FF,
   codecMinQuality               = 0x00000000,
   codecLowQuality               = 0x00000100,
   codecNormalQuality            = 0x00000200,
   codecHighQuality              = 0x00000300
};
Constants
codecLosslessQuality

Lossless compression or decompression. This special value is valid only for components that can support lossless compression or decompression. 

Available in Mac OS X v10.0 and later.
codecMaxQuality

The maximum standard value. 

Available in Mac OS X v10.0 and later.
codecMinQuality

The minimum valid value. 

Available in Mac OS X v10.0 and later.
codecLowQuality

Low-quality image reproduction. This value should correspond to the lowest image quality that still results in acceptable display characteristics. 

Available in Mac OS X v10.0 and later.
codecNormalQuality

Image reproduction of normal quality. 

Available in Mac OS X v10.0 and later.*/
enum {
   codecLosslessQuality          = 0x00000400,
   codecMaxQuality               = 0x000003FF,
   codecMinQuality               = 0x00000000,
   codecLowQuality               = 0x00000100,
   codecNormalQuality            = 0x00000200,
   codecHighQuality              = 0x00000300
};

/*CodecQ

Abst_CodecQ

typedef unsigned long CodecQ;
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long CodecQ;

/*ICMDataProc

Supplies compressed data during a decompression operation.

typedef OSErr (*ICMDataProcPtr) (Ptr *dataP, long bytesNeeded, long refcon);

If you name your function MyICMDataProc, you would declare it this way:

OSErr MyICMDataProc (
   Ptr     *dataP,
   long    bytesNeeded,
   long    refcon );
Parameters
dataP

Contains a pointer to the address of the data buffer. The decompressor uses this parameter to indicate where your data-loading function should return the compressed data. You establish this data buffer when you start the decompression operation. For example, the data parameter to FDecompressImage defines the location of the data buffer for that operation. Upon return from your data-loading function, this pointer should refer to the beginning of the compressed data that you loaded. The decompressor may also use this parameter to indicate that it wants to reset the mark within the compressed data stream. If the dataP parameter is set to NIL, the bytesNeeded parameter contains the new mark position, relative to the current position of the data stream. If your data-loading function does not support this operation, return a nonzero result code.
bytesNeeded

Specifies the number of bytes requested or the new mark offset. If the decompressor has requested additional compressed data (that is, the value of the dataP parameter is not NIL), then this parameter specifies how many bytes to return. This value never exceeds the size of the original data buffer. Your data-loading function should read the data from the current mark in the input data stream. If the decompressor has requested to set a new mark position in the data stream (that is, the value of the dataP parameter is NIL), then this parameter specifies the new mark position relative to the current position of the data stream.
refcon

Contains a reference constant value for use by your data-loading function. Your application specifies the value of this reference constant in the data-loading function structure you pass to the Image Compression Manager.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
ImageCompression.h*/
typedef OSErr (*ICMDataProcPtr) (Ptr *dataP, long bytesNeeded, long refcon);

/*ICMDataUPP

Represents a type used by the Image Compression API.

typedef STACK_UPP_TYPE(ICMDataProcPtr) ICMDataUPP;
Declared In
ImageCompression.h*/
typedef STACK_UPP_TYPE(ICMDataProcPtr) ICMDataUPP;

/*ICMDataProcRecord

Specifies an image compression data-loading function.

struct ICMDataProcRecord {
   ICMDataUPP    dataProc;
   long          dataRefCon;
};
Fields
dataProc
Discussion

Contains a pointer to your data-loading function.
dataRefCon
Discussion

Contains a reference constant for use by your data-loading function.
Discussion

If there is no data-loading function, the Image Compression Manager sets the dataProc field to NIL, and the entire image must be in memory at the location specified by the codecData field of the ImageSubCodecDecompressRecord structure.
Related Functions
FDecompressImage
GetCompressedImageSize
GetCompressedPixMapInfo
ImageCodecGetCompressedImageSize
ImageCodecTrimImage
SetCompressedPixMapInfo
SetDSequenceDataProc
TrimImage 
Programming Info
C interface file: ImageCompression.h*/
struct ICMDataProcRecord {
   ICMDataUPP    dataProc;
   long          dataRefCon;
};
typedef struct ICMDataProcRecord ICMDataProcRecord;

/*CodecInfo

Describes the capabilities of a compressor.

struct CodecInfo {
   Str31             typeName;
   short             version;
   short             revisionLevel;
   long              vendor;
   long              decompressFlags;
   long              compressFlags;
   long              formatFlags;
   UInt8             compressionAccuracy;
   UInt8             decompressionAccuracy;
   unsigned short    compressionSpeed;
   unsigned short    decompressionSpeed;
   UInt8             compressionLevel;
   UInt8             resvd;
   short             minimumHeight;
   short             minimumWidth;
   short             decompressPipelineLatency;
   short             compressPipelineLatency;
   long              privateData;
};
Fields
typeName
Discussion

Indicates the compression algorithm used by the component; for example, 'Animation'. This Pascal string may be used to identify the compression algorithm to the user. The string always takes up 32 bytes no matter how long it is. The 32 bytes consist of 31 bytes plus one length byte. Apple assigns these type names. The value of this field should correspond to the value of the typeName field in the appropriate compressor name structure returned by GetCodecNameList.
version
Discussion

Indicates the version of compressed data this component supports. The contents of this field should indicate the most recent version of the compression algorithm that the component can understand.
revisionLevel
Discussion

Indicates the version of the component; for example, 0x00010001 (1.0.1). Developers of compressors assign these version numbers.
vendor
Discussion

Identifies the developer of the component; for example, 'appl'. The value of this field corresponds to the manufacturer code or application signature assigned to the developer.
decompressFlags
Discussion

Contains flags (see below) that specify the decompression capabilities of the component. Typically, these flags are of interest only to developers of image decompressors. See these constants: 
codecInfoDoes1
codecInfoDoes2
codecInfoDoes4
codecInfoDoes8
codecInfoDoes16
codecInfoDoes32
codecInfoDoesDither
codecInfoDoesStretch
codecInfoDoesShrink
codecInfoDoesMask
codecInfoDoesTemporal
codecInfoDoesDouble
codecInfoDoesQuad
codecInfoDoesHalf
codecInfoDoesQuarter
codecInfoDoesRotate
codecInfoDoesHorizFlip
codecInfoDoesVertFlip
codecInfoHasEffectParameterList
codecInfoDoesBlend
codecInfoDoesWarp
codecInfoDoesRecompress
codecInfoDoesSpool
codecInfoDoesRateConstrain
compressFlags
Discussion

Contains flags (see below) that specify the compression capabilities of the component. Typically, these flags are of interest only to developers of image compressors.
formatFlags
Discussion

Contains flags (see below) that describe the possible format for compressed data produced by this component and the format of compressed files that the component can handle during decompression. Typically, these flags are of interest only to developers of compressor components. See these constants: 
codecInfoDepth1
codecInfoDepth2
codecInfoDepth4
codecInfoDepth8
codecInfoDepth16
codecInfoDepth24
codecInfoDepth32
codecInfoDepth33
codecInfoDepth34
codecInfoDepth36
codecInfoDepth40
codecInfoStoresClut
codecInfoDoesLossless
codecInfoSequenceSensitive
compressionAccuracy
Discussion

Indicates the relative accuracy of the compression algorithm employed by the component. Valid values for this field range from 0 to 255. A value of 0 means that the accuracy is unknown. Values from 1 to 255 provide a gauge for the relative accuracy of the compression algorithm; higher values indicate better accuracy. The Image Compression Manager examines this field to determine which compressor component can most accurately compress a given image. The compressionAccuracy field can only approximate the accuracy of a compression algorithm. Typically, compression algorithms produce results of varying quality based on a variety of parameters, including image size and content. Since this information is not available until a compression request is issued, a precise measure of accuracy is not possible. However, the value of this field should still give a rough idea of the accuracy of the supported algorithm.
decompressionAccuracy
Discussion

Indicates the relative accuracy of the decompression algorithm employed by the component. Valid values for this field range from 0 to 255. A value of 0 means that the accuracy is unknown. Values from 1 to 255 indicate the relative accuracy of the decompression technique; higher values mean better accuracy. The Image Compression Manager examines this field to determine which decompressor component can most accurately decompress a given image. The decompressionAccuracy field can only approximate the accuracy of a decompression algorithm. Typically, decompression algorithms produce results of varying quality based on a variety of parameters, including image size and content. Since this information is not available until a decompression request is issued, a precise measure of accuracy is not possible. However, the value of this field should still give a rough idea of the accuracy of the supported algorithm.
compressionSpeed
Discussion

Indicates the relative speed of the component for compression operations. Valid values for this field lie in the range from 0 to 65,535. A value of 0 means that the speed is unknown. Values from 1 to 65,535 correspond to the number of milliseconds the component requires to compress a 320-by-240 pixel image on a Macintosh II computer. The Image Compression Manager examines this field to determine which compressor component can most quickly compress a given image.
decompressionSpeed
Discussion

Indicates the relative speed of the component for decompression operations. Valid values for this field lie in the range from 0 to 65,535. A value of 0 means that the speed is unknown. Values from 1 to 65,535 correspond to the number of milliseconds the component requires to decompress a 320-by-240 pixel image on a Macintosh II computer. The Image Compression Manager examines this field to determine which compressor component can most quickly decompress a given image.
compressionLevel
Discussion

Indicates the relative compression achieved by this component. Valid values for this field lie in the range from 0 to 255. A value of 0 means that the compression level is unknown. Values from 1 to 255 map to percentage values of relative compression; lower values mean lesser compression. A value of 1 means no compression (0 percent); a value of 255 means maximum compression (100 percent). The Image Compression Manager examines this field to determine which available compressor component will yield the smallest resulting data for a given image. The compressionLevel field can only approximate the effectiveness of a compression algorithm. Typically, compression algorithms produce results of varying quality based on a variety of parameters, including image size and content. Since this information is not available until a compression request is issued, a precise measure of compression is not possible. However, the value of this field should still give a rough idea of the effectiveness of the supported algorithm.
resvd
Discussion

Reserved; set to 0.
minimumHeight
Discussion

Specifies the height in pixels of the smallest image the component can handle. Together with the minimumWidth field, this field defines the block size for the component. The Image Compression Manager does not issue compression or decompression requests for images smaller than the block size.
minimumWidth
Discussion

Specifies the width in pixels of the smallest image the component can handle. Together with the minimumHeight field, this field defines the block size for the component. The Image Compression Manager does not issue compression or decompression requests for images smaller than the block size.
decompressPipelineLatency
Discussion

Decompression pipeline latency in milliseconds, for asynchronous codecs.
compressPipelineLatency
Discussion

Compression pipeline latency in milliseconds, for asynchronous codecs.
privateData
Discussion

Reserved for future use. This field must be set to 0.
Discussion

Contains the description of a codec.
Version Notes

The codecInfoHasEffectParameterList constant was formerly codecInfoDoesSkew.
Related Functions
GetCodecInfo
ImageCodecGetCodecInfo 
Programming Info
C interface file: ImageCompression.h*/
struct CodecInfo {
   Str31             typeName;
   short             version;
   short             revisionLevel;
   long              vendor;
   long              decompressFlags;
   long              compressFlags;
   long              formatFlags;
   UInt8             compressionAccuracy;
   UInt8             decompressionAccuracy;
   unsigned short    compressionSpeed;
   unsigned short    decompressionSpeed;
   UInt8             compressionLevel;
   UInt8             resvd;
   short             minimumHeight;
   short             minimumWidth;
   short             decompressPipelineLatency;
   short             compressPipelineLatency;
   long              privateData;
};
typedef struct CodecInfo CodecInfo;

/*CompressorComponent

Abst_CompressorComponent

typedef Component CompressorComponent;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Component CompressorComponent;


//Func
/*QTGetComponentProperty

Returns the value of a specific component property.

ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );

/*QTGetComponentPropertyInfo

Returns information about the properties of a component.

ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
outPropType

A pointer to memory allocated to hold the property type on return. This pointer may be NULL.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. This pointer may be NULL.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );

/*QTSetComponentProperty

Sets the value of a specific component property.

ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );

/*QTOpenGLTextureContextCreate
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Creates a new OpenGL texture context for a specified OpenGL context and pixel format.

OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Parameters
allocator

The allocator used to create the texture context.
cglContext

A pointer to an opaque CGLPContextObj structure representing the OpenGL context used to create textures. You can create this structure using CGLCreateContext.
cglPixelFormat

The pixel format object that specifies buffer types and other attributes of the new context.
attributes

A dictionary of attributes.
newTextureContext

A pointer to a variable to receive the new OpenGL texture context.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );

/*QTVisualContextSetAttribute

Sets a visual context attribute.

OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );
Parameters
visualContext

The visual context.
attributeKey

Identifier of attribute to set
attributeValue

The value of the attribute to set, or NULL to remove a value. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );

/*QTVisualContextRelease

Releases a visual context object.

void QTVisualContextRelease (
   QTVisualContextRef visualContext
);
Parameters
visualContext

A reference to a visual context object. If you pass NULL, nothing happens.
Discussion

When the retain count decreases to zero, the visual context is disposed.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
void QTVisualContextRelease (
   QTVisualContextRef visualContext
);

/*QTVisualContextCopyImageForTime

Retrieves an image buffer from the visual context, indexed by the provided time.

OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);
Parameters
visualContext

The visual context.
allocator

Allocator used to create new CVImageBufferRef.
timeStamp

Time in question. Pass NULL to request the image at the current time.
newImage

Points to variable to receive the new image.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You should not request image buffers further ahead of the current time than the read-ahead time specified with the kQTVisualContextExpectedReadAheadKey attribute. You may skip images by passing later times, but you may not pass an earlier time than passed to a previous call to this function.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);

/*QTVisualContextTask

Enables the visual context to release internally held resources for later use.

void QTVisualContextTask (
   QTVisualContextRef visualContext
);
Parameters
visualContext

The visual context.
Discussion

For optimal resource management, this function should be called in every rendering pass. It should be called after old images have been released, new images have been used and all rendering has been flushed to the screen. The call is not mandatory.
Version Notes

Introduced in QuickTime 7
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

void QTVisualContextTask (
   QTVisualContextRef visualContext
);

/*QTVisualContextIsNewImageAvailable

Queries whether a new image is available for a given time.

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);
Parameters
visualContext

The visual context.
timeStamp

Time in question.
Return Value

A Boolean.
Discussion

This function returns TRUE if there is a image available for the specified time that is different from the last image retrieved from QTVisualContextCopyImageForTime.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);

/*QTAddComponentPropertyListener

Installs a callback to monitor a component property.

ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inDispatchProc

A Universal Procedure Pointer to a QTComponentPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. You may pass NULL in this parameter.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );

/*ICMDecompressionSessionRelease

Decrements the retain count of a decompression session.

void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session );

/*ICMDecompressionSessionSetNonScheduledDisplayTime

Sets the display time for a decompression session, and requests display of the non-scheduled queued frame at that display time, if there is one.

OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
displayTime

A display time. Usually this is the display time of a non-scheduled queued frame. 
displayTimeScale

The timescale according to which displayTime should be interpreted. 
flags

Reserved; set to 0. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags );

/*ICMDecompressionSessionDecodeFrame

Queues a frame for decompression.

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
data

A pointer to the compressed data for this frame. The data must remain in this location until ICMDecompressionTrackingCallbackProc is called with the kICMDecompressionTracking_ReleaseSourceData flag set in decompressionTrackingFlags.
dataSize

The number of bytes of compressed data. You may not pass 0 in this parameter. 
frameOptions

A reference to a frame decompression options object containing options for this frame. You can create this object by calling ICMDecompressionFrameOptionsCreate.
frameTime

A pointer to a structure describing the frame's timing information. 
sourceFrameRefCon

Your reference value for the frame. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon );

/*ICMDecompressionSessionOptionsRelease

Decrements the retain count of a decompression session options object.

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options );
Parameters
options

A reference to a decompression session options object. This reference is returned by ICMDecompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options );

/*ICMDecompressionSessionCreate

Creates a session for decompressing video frames.

OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut );
Parameters
allocator

An allocator for the session. Pass NULL to use the default allocator. 
desc

An image description for the source frames. 
decompressionOptions

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate. The session will retain the object. You may change some options during the session by modifying the object. You may also pass NULL.
destinationPixelBufferAttributes

Requirements for emitted pixel buffers. You may pass NULL.
trackingCallback

A pointer to a structure that designates a callback to be called for information about queued frames and pixel buffers containing decompressed frames. See ICMDecompressionTrackingCallbackRecord and ICMDecompressionTrackingCallbackProc.
decompressionSessionOut

A pointer to a variable to receive a reference to the new decompression session. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

Frames are returned through calls to the callback pointed to by trackingCallback.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut );

/*ICMDecompressionSessionOptionsCreate

Creates a decompression session options object.

OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options );
Parameters
allocator

An allocator. Pass NULL to use the default allocator.
options

On return, a reference to a decompression session options object.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options );

/*ICMImageDescriptionGetProperty

Returns a particular property of a image description handle.

OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );
Parameters
inDesc

The image description handle being interrogated.
inPropClass

The class of property being requested.
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

Points to the buffer to receive the property value.
outPropValueSizeUsed

Points to a variable to receive the actual size of returned property value. (This can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns a particular property of a image description handle.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );

/*ICMDecompressionSessionOptionsSetProperty

Sets the value of a specific property of a decompression session options object.

OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress );
Parameters
options

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
inPropValueSize

The size of the property value to be set.
inPropValueAddress

A pointer to the value of the property to be set.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress );

/*QTNewGWorld

Creates an offscreen graphics world that may have a non-Macintosh pixel format.

OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags );
Parameters
offscreenGWorld

On return, a pointer to the offscreen graphics world created by this routine.
PixelFormat

The new graphics world's pixel format; see Pixel Formats. This function won't work with planar pixel formats; use QTNewGWorldFromPtr instead. See the ICMPixelFormatInfo structure for a discussion of planar and chunky formats.
boundsRect

A pointer to the boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if this function creates one. If you specify 0 in the PixelFormat parameter, the function interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. It then uses the pixel format, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NIL in this parameter, the function uses the default color table for the pixel format that you specify in the PixelFormat parameter. If you set the PixelFormat parameter to 0, the function ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use this function on a computer that supports only basic QuickDraw, you may specify only NIL in this parameter.
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case the function attaches this structure to the new offscreen graphics world. If you set the PixelFormat parameter to 0, or if you do not set the noNewDevice flag, the function ignores this parameter, so you should set it to NIL. If you set the PixelFormat parameter to 0, the function uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NIL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds.
flags

Constants (see below) that identify options available to your application. You can set a combination of these flags. If you don't wish to use any of them, pass 0 in this parameter. In this case the default behavior is to create an offscreen graphics world where the base address for the offscreen pixel image is unpurgeable, the graphics world uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure, it uses memory in your application heap, and it allows graphics accelerators to cache the offscreen pixel image. See these constants: 
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags );

/*ICMImageDescriptionSetProperty

Sets a particular property of a image description handle.

OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress );
Parameters
inDesc

The image description handle being modified.
inPropClass

The class of property being set.
inPropID

The ID of the property being set.
inPropValueSize

The size of property value.
inPropValueAddress

Points to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress );

/*GraphicsImportDraw

Draws an imported image.

ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function draws the image currently in use by the graphics import component to the graphics port and device specified by GraphicsImportSetGWorld. GraphicsImportDraw takes into account all settings previously specified for the image, such as the source rectangle, transformation matrix, clipping region, graphics mode, and image quality.
Special Considerations

The base graphics importer's drawing function uses the results of GraphicsImportGetImageDescription and GraphicsImportGetDataOffsetAndSize to create a decompression sequence, which it uses to draw the image. Subsequent draw operations with the same connection may reuse the decompression sequence. Other graphics importers may override this behavior.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci );

/*GraphicsImportSetProgressProc

Installs a progress procedure to call while drawing an imported image.

ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets a progress function that will be installed in the image decompression sequence used to draw the image.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );


/*GraphicsImportSetGWorld

Sets the graphics port and device for drawing an imported image.

ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
port

A pointer to the CGrafPort structure that defines the destination graphics port or graphics world. Set to NIL to use the current port.
gd

A handled to the GDevice structure that defines the destination graphics device. Set to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's device.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The graphics world is initialized to the current port and device when the graphics importer component is opened. Use this function to select another port or device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd );

/*GraphicsImportSetBoundsRect

Defines the rectangle in which to draw an imported image.

ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure that describes the bounding rectangle into which the image will be drawn.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You use this function to define the rectangle into which the graphics image should be drawn. The function creates a transformation matrix to map the image's natural bounds to the specified bounds and then calls GraphicsImportSetMatrix.
Special Considerations

Because this function affects the transformation matrix, you should use GraphicsImportSetMatrix instead of this function if you also need to specify more complex transformations of the matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds );

/*GraphicsImportGetNaturalBounds

Returns the bounding rectangle of an imported image.

ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
naturalBounds

A pointer to a Rect structure that describes the size of the bounding rectangle for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to determine the native size of the image associated with a graphics importer component. The natural bounds are always zero-based. This is a convenience function that simply calls GraphicsImportGetImageDescription and extracts the width and height fields.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds );


/*NewICMProgressUPP

Allocates a Universal Procedure Pointer for the ICMProgressProc callback.

ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMProgressProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine );

/*GetGraphicsImporterForDataRef

Locates and opens a graphics importer component that can be used to draw the image from specified data reference.

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi );
Parameters
dataRef

The data reference to be drawn using a graphics importer component.
dataRefType

The type of data reference pointed to by the dataRef parameter; see Data References. For alias-based data references, the dataRef handle contains an AliasRecord and dataRefType is set to rAliasType.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found, this parameter will be set to NIL. If GetGraphicsImporterForDataRef is able to locate a graphics importer for the data reference, the returned graphics importer ComponentInstance will already be set up to draw from the specified data reference to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function tries to locate a graphics importer component for the specified data reference by checking the file extension (such as .GIF or .JPG), the Macintosh file type, and the MIME type of the file. The file extension is retrieved from the data reference by using DataHGetFileName to call the data handler associated with the data reference. If a graphics importer cannot be found using the file's type, file extension, or MIME type, GetGraphicsImporterForDataRef asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming; to bypass it, call GetGraphicsImporterForDataRefWithFlags instead.
Special Considerations

The caller of GetGraphicsImporterForDataRef is responsible for closing the returned ComponentInstance using CloseComponent. You must call CloseComponent when you are finished with the importer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi );

/*GraphicsImportSetQuality

Sets the image quality value for an imported image.

ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
quality

Contains a constant (see below) that defines the desired image quality for decompression. Values for this parameter are on the same scale as compression quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The quality parameter controls how precisely the decompressor decompresses the image data. Some decompressors may choose to ignore some image data to improve decompression speed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality );

/*GraphicsExportDoExport

Performs a graphics export operation.

ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
actualSizeWritten

Points to a variable to receive the number of bytes written. If you are not interested in this information, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before calling this function , you must specify an input image, using one of the GraphicsExportSetInput... functions, and a destination for the output image file, using one of the GraphicsExportSetOutput... functions.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten );

/*GraphicsExportSetProgressProc

Installs a progress function in a graphics export operation.

ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is always implemented by the base graphics exporter.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );

/*GraphicsExportSetCompressionQuality

Defines the compression quality for a graphics export operation.

ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
spatialQuality

A constant (see below) that defines the currently specified quality value. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This setting is only supported by lossy compression methods.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality );

/*GraphicsExportSetOutputFile

Defines the output file for a graphics export operation.

ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
theFile

an FSSpec structure that identifies the file.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile );

/*GraphicsExportSetInputGraphicsImporter

Specifies that the source image for a graphics export operation is to be drawn by a graphics importer instance.

ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
grip

The source graphics importer component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to specify a source before you call GraphicsExportDoExport. The source can be a QuickTime graphics importer component instance, a QuickDraw Picture, a graphics world, a PixMap structure, or a piece of compressed data described by an ImageDescription structure. Compressed data can be in a file, handle, pointer, or other data reference. The application must make sure that the source is not disposed of before the graphics exporter instance is closed or given a new source. All of the get and set functions for these sources are implemented by the base graphics exporter; format-specific importers should delegate all of them.
Special Considerations

It is the caller's responsibility to dispose of the graphics importer.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip );

/*GraphicsExportGetMIMETypeList

Returns MIME types and other information about the graphics format in a graphics export operation.

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Receives a newly-created QuickTime atom container that contains information about the graphics format.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a QuickTime atom container that contains the format's name, as a string in an atom of type 'desc' (kMimeInfoDescriptionTag), and optionally the MIME type as a string in an atom of type 'mime'[atom] (kMimeInfoMimeTypeTag).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );

/*GraphicsExportGetDefaultFileNameExtension

Returns the suggested file name extension for a graphics export operation.

ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
fileNameExtension

Points to a location to receive the file name extension.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

File name extensions are returned as upper-case big-endian four-character codes. For example, the extension .png would be returned as 'PNG ' (0x504E4720).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension );

/*GraphicsImportCreateCGImage

Imports an image as a Core Graphics CGImage.

ComponentResult GraphicsImportCreateCGImage (
   GraphicsImportComponent    ci,
   CGImageRef                 *imageRefOut,
   UInt32                     flags );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
imageRefOut

A reference to the CG image to be created.
flags

A flag that determines the settings to use.
kGraphicsImportCreateCGImageUsingCurrentSettings

Use the current settings.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: ImageCompression.h*/
ComponentResult GraphicsImportCreateCGImage (
   GraphicsImportComponent    ci,
   CGImageRef                 *imageRefOut,
   UInt32                     flags );


/*GetGraphicsImporterForFile

Locates and opens a graphics importer component that can be used to draw a specified file.

OSErr GetGraphicsImporterForFile (
   const FSSpec         *theFile,
   ComponentInstance    *gi );
Parameters
theFile

The file to be drawn using a graphics importer component.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found for the specified file, the gi will be set to NIL. If GetGraphicsImporterForFile is able to locate a graphics importer for the file, the returned graphics importer ComponentInstance will already be set up to draw the specified file to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function first tries to locate a graphics importer component for the specified file based on its file type. If it is unable to locate a graphics importer component based on the Macintosh file type, or the call is made on a non-Macintosh file, GetGraphicsImporterForFile will try to locate a graphics importer component based on the file extension (such as .JPG or .GIF). If a graphics importer cannot be found using the file's type or extension, GetGraphicsImporterForFile asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming. To bypass the validation attempt, call GetGraphicsImporterForFileWithFlags instead. The following code sample illustrates the use of GetGraphicsImporterForFile:// Get a graphics importer for the image file, determine the natural size
// of the image, and draw the image
// See "Discovering QuickTime," page 274
void drawFile(const FSSpec *fss, const Rect *boundsRect)
    {
        GraphicsImportComponent gi;
        GetGraphicsImporterForFile(fss, &gi);
        GraphicsImportSetBoundsRect(gi, boundsRect);
        GraphicsImportDraw(gi);
        CloseComponent(gi);
    }

Special Considerations

The caller of GetGraphicsImporterForFile is responsible for closing the returned ComponentInstance using CloseComponent.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetGraphicsImporterForFile (
   const FSSpec         *theFile,
   ComponentInstance    *gi );

/*MakeImageDescriptionForPixMap

Fills out an ImageDescription structure corresponding to a PixMap structure.

OSErr MakeImageDescriptionForPixMap (
   PixMapHandle              pixmap,
   ImageDescriptionHandle    *idh );
Parameters
pixmap

A handle to a PixMap structure.
idh

The handle of an ImageDescription structure. On entry, this parameter normally points to an ImageDescription structure whose contents are NIL. On return, the structure is correctly filled out for the selected PixMap.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr MakeImageDescriptionForPixMap (
   PixMapHandle              pixmap,
   ImageDescriptionHandle    *idh );

/*DecompressSequenceBegin

Obsolete. See DecompressSequenceBeginS.

OSErr DecompressSequenceBegin (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceBegin (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );

/*DecompressSequenceFrameS

Queues a frame for decompression and specifies the size of the compressed data; new applications should use DecompressSequenceFrameWhen.

OSErr DecompressSequenceFrameS (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );
Parameters
seqID

Contains the unique sequence identifier that was returned by the DecompressSequenceBegin function.
data

Points to the compressed image data. This pointer must contain a 32-bit clean address.
dataSize

The size of the data buffer.
inFlags

Contains flags (see below) that provide further control information. See these constants: 
codecFlagNoScreenUpdate
codecFlagDontOffscreen
codecFlagOnlyScreenUpdate
outFlags

Contains status flags (see below). The decompressor updates these flags at the end of the decompression operation. See these constants: 
codecFlagUsedNewImageBuffer
codecFlagUsedImageBuffer
codecFlagDontUseNewImageBuffer
codecFlagInterlaceUpdate
codecFlagCatchUpDiff
asyncCompletionProc

Points to an ICMCompletionProcRecord structure. The compressor calls your completion function when an asynchronous decompression operation is complete. You can cause the decompression to be performed asynchronously by specifying a completion function. If you specify asynchronous operation, you must not read the decompressed image until the decompressor indicates that the operation is complete by calling your completion function. Set asyncCompletionProc to NIL to specify synchronous decompression. If you set asyncCompletionProc to -1, the operation is performed asynchronously but the decompressor does not call your completion function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function accepts the same parameters as the DecompressSequenceFrame function, with the addition of the dataSize parameter.
Special Considerations

New applications should use DecompressSequenceFrameWhen.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceFrameS (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );

/*CDSequenceEnd

Indicates the end of processing for an image sequence.

OSErr CDSequenceEnd (
   ImageSequence    seqID );
Parameters
seqID

Contains the unique sequence identifier that was returned by DecompressSequenceBegin or CompressSequenceBegin.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceEnd (
   ImageSequence    seqID );

/*SetIdentityMatrix

Sets the contents of a matrix so that it performs no transformation.

void SetIdentityMatrix (
   MatrixRecord    *matrix );
Parameters
matrix

A pointer to a MatrixRecord structure. The function updates the contents of this matrix so that the matrix describes the identity matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void SetIdentityMatrix (
   MatrixRecord    *matrix );

/*RotateMatrix

Modifies the contents of a matrix so that it defines a rotation operation.

void RotateMatrix (
   MatrixRecord    *m,
   Fixed           degrees,
   Fixed           aboutX,
   Fixed           aboutY );
Parameters
m

A pointer to a MatrixRecord structure.
degrees

The number of degrees of rotation.
aboutX

The x coordinate of the anchor point of rotation.
aboutY

The y coordinate of the anchor point of rotation.
Discussion

This function updates the contents of a matrix so that the matrix describes a rotation operation; that is, it concatenates the rotation transformations onto whatever was initially in the matrix structure. You specify the direction and amount of rotation with the degrees parameter. You specify the point of rotation with the aboutX and aboutY parameters.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void RotateMatrix (
   MatrixRecord    *m,
   Fixed           degrees,
   Fixed           aboutX,
   Fixed           aboutY );

/*TranslateMatrix

Adds a translation value to a specified matrix.

void TranslateMatrix (
   MatrixRecord    *m,
   Fixed           deltaH,
   Fixed           deltaV );
Parameters
m

A pointer to the MatrixRecord structure for this operation.
deltaH

The value to be added to the x coordinate translation value.
deltaV

The value to be added to the y coordinate translation value.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
void TranslateMatrix (
   MatrixRecord    *m,
   Fixed           deltaH,
   Fixed           deltaV );

/*GraphicsImportSetMatrix

Defines the transformation matrix to use for drawing an imported image.

ComponentResult GraphicsImportSetMatrix (
   GraphicsImportComponent    ci,
   const MatrixRecord         *matrix );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
matrix

A pointer to a matrix structure that specifies how to transform the image during decompression. For example, you can use a transformation matrix to scale or rotate the image. To set the matrix to identity, pass NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function establishes the transformation matrix to be applied to an image, which determines where and how it will be drawn.
Special Considerations

This function affects the bounding rectangle defined for the image. You can specify where an image will be drawn by setting either a transformation matrix or a bounding rectangle, but it is usually more convenient for applications to set a bounding rectangle using the GraphicsImportSetBoundsRect function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetMatrix (
   GraphicsImportComponent    ci,
   const MatrixRecord         *matrix );

/*GraphicsImportGetBoundsRect

Returns the bounding rectangle for drawing an imported image.

ComponentResult GraphicsImportGetBoundsRect (
   GraphicsImportComponent    ci,
   Rect                       *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure describing the bounding rectangle that has been defined for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a convenience function. It is implemented by calling GraphicsImportGetMatrix and GraphicsImportGetNaturalBounds and using the results to calculate the drawing rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetBoundsRect (
   GraphicsImportComponent    ci,
   Rect                       *bounds );

/*GraphicsImportSetSourceRect

Sets the source rectangle to use for an imported image.

ComponentResult GraphicsImportSetSourceRect (
   GraphicsImportComponent    ci,
   const Rect                 *sourceRect );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
sourceRect

A pointer to a Rect structure defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the source image. Set to NIL to use the entire image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function provides a way to use only a portion of the source image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetSourceRect (
   GraphicsImportComponent    ci,
   const Rect                 *sourceRect );


/*GraphicsImportSetFlags

Sets the flags for a graphics importer component.

ComponentResult GraphicsImportSetFlags (
   GraphicsImportComponent    ci,
   long                       flags );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
flags

The new flags (see below) to use. See these constants: 
kGraphicsImporterDontDoGammaCorrection
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetFlags (
   GraphicsImportComponent    ci,
   long                       flags );

/*GraphicsImportSetClip

Defines the clipping region for drawing an imported image.

ComponentResult GraphicsImportSetClip (
   GraphicsImportComponent    ci,
   RgnHandle                  clipRgn );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
clipRgn

A handle to a MacRegion structure that defines the clipping region in the destination coordinate system. Set to NIL to disable clipping. The graphics import component makes a copy of this region.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Because all drawing operations ignore the port clipping region, you must use this function to clip an image. The graphics importer component draws only that portion of the image that lies within the specified clipping region.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetClip (
   GraphicsImportComponent    ci,
   RgnHandle                  clipRgn );

/*ICMCompressorSourceFrameGetFrameOptions

Retrieves the frame compression options for a source frame.

ICMCompressionFrameOptionsRef ICMCompressorSourceFrameGetFrameOptions (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

A compression session frame options reference representing options for this frame. A frame options object is created by ICMCompressionFrameOptionsCreate.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMCompressionFrameOptionsRef ICMCompressorSourceFrameGetFrameOptions (
   ICMCompressorSourceFrameRef   sourceFrame );

/*ICMCompressionSessionOptionsGetAllowTemporalCompression

Retrieves the allow temporal compression flag.

Boolean ICMCompressionSessionOptionsGetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns TRUE if temporal compression is allowed, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
Boolean ICMCompressionSessionOptionsGetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options );

/*ICMCompressionFrameOptionsGetForceKeyFrame

Retrieves the force key frame flag.

Boolean ICMCompressionFrameOptionsGetForceKeyFrame (
   ICMCompressionFrameOptionsRef   options );
Parameters
options

A compression frame options reference. This reference is returned by ICMCompressionFrameOptionsCreate.
Return Value

Returns TRUE if frames are forced to be compressed as key frames, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
Boolean ICMCompressionFrameOptionsGetForceKeyFrame (
   ICMCompressionFrameOptionsRef   options );

/*ICMCompressorSourceFrameRetain

Increments the retain count of a source frame object.

ICMCompressorSourceFrameRef ICMCompressorSourceFrameRetain (
   ICMCompressorSourceFrameRef    sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame. If you pass NULL, nothing happens.
Return Value

A reference to the object passed in sourceFrame, for convenience.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMCompressorSourceFrameRef ICMCompressorSourceFrameRetain (
   ICMCompressorSourceFrameRef    sourceFrame );

/*ICMCompressorSourceFrameRelease

Decrements the retain count of a source frame object.

void ICMCompressorSourceFrameRelease (
   ICMCompressorSourceFrameRef    sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMCompressorSourceFrameRelease (
   ICMCompressorSourceFrameRef    sourceFrame );


/*ICMCompressorSourceFrameGetDisplayNumber

Retrieves a source frames display number.

long ICMCompressorSourceFrameGetDisplayNumber (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

The display number of the source frame.
Discussion

The ICM tags source frames with display numbers in the order that they are passed to ICMCompressionSessionEncodeFrame. The first display number is 1. Compressors may compare these numbers to work out whether prediction is forward or backward, even when display times are not provided. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
long ICMCompressorSourceFrameGetDisplayNumber (
   ICMCompressorSourceFrameRef   sourceFrame );

/*ICMCompressionSessionOptionsGetAllowFrameReordering

Retrieves the allow frame reordering flag.

Boolean ICMCompressionSessionOptionsGetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns TRUE if frame reordering is allowed, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/


Boolean ICMCompressionSessionOptionsGetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options );

/*ICMCompressorSourceFrameGetDisplayTimeStampAndDuration

Retrieves the display time stamp and duration of a source frame.

OSStatus ICMCompressorSourceFrameGetDisplayTimeStampAndDuration (
   ICMCompressorSourceFrameRef    sourceFrame,
   TimeValue64                    *displayTimeStampOut,
   TimeValue64                    *displayDurationOut,
   TimeScale                      *timeScaleOut,
   ICMValidTimeFlags              *validTimeFlagsOut );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
displayTimeStampOut

A pointer to the source frame's display time stamp.
displayDurationOut

A pointer to the source frame's display duration.
timeScaleOut

A pointer to the source frame's display time scale.
validTimeFlagsOut

A pointer to one of these display time flags for the source frame: kICMValidTime_DisplayTimeStampIsValid = 1L<<0 The value of displayTimeStamp is valid. kICMValidTime_DisplayDurationIsValid = 1L<<1 The value of displayDuration is valid. See these constants: 
kICMValidTime_DisplayTimeStampIsValid
kICMValidTime_DisplayDurationIsValid
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressorSourceFrameGetDisplayTimeStampAndDuration (
   ICMCompressorSourceFrameRef    sourceFrame,
   TimeValue64                    *displayTimeStampOut,
   TimeValue64                    *displayDurationOut,
   TimeScale                      *timeScaleOut,
   ICMValidTimeFlags              *validTimeFlagsOut );

/*ICMCompressionSessionOptionsGetProperty

Retrieves the value of a specific property of a compression session options object.

OSStatus ICMCompressionSessionOptionsGetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ComponentValuePtr                 outPropValueAddress,
   ByteCount                         *outPropValueSizeUsed );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
outPropType

A pointer to the type of the returned property's value.
outPropValueAddress

A pointer to a variable to receive the returned property's value.
outPropValueSizeUsed

On return, a pointer to the number of bytes actually used to store the property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsGetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ComponentValuePtr                 outPropValueAddress,
   ByteCount                         *outPropValueSizeUsed );

/*ICMEncodedFrameCreateMutable

Called by a compressor to create an encoded-frame token corresponding to a given source frame.

OSStatus ICMEncodedFrameCreateMutable (
   ICMCompressorSessionRef       session,
   ICMCompressorSourceFrameRef   sourceFrame,
   ByteCount                     bufferSize,
   ICMMutableEncodedFrameRef     *frameOut );
Parameters
session

A reference to the compression session between the ICM and an image compressor component.
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
bufferSize

The size of the frame buffer in bytes.
frameOut

On return, a reference to an encoded frame object with write capabilities.
Return Value

An error code. Returns noErr if there is no error.
Discussion

The encoded frame will initially show 0 for mediaSampleFlags; if the frame is not a key frame, the compressor must call ICMEncodedFrameSetMediaSampleFlags to set mediaSampleNotSync. If the frame is droppable, the compressor should set mediaSampleDroppable. If the frame is a partial key frame, the compressor should set mediaSamplePartialSync.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameCreateMutable (
   ICMCompressorSessionRef       session,
   ICMCompressorSourceFrameRef   sourceFrame,
   ByteCount                     bufferSize,
   ICMMutableEncodedFrameRef     *frameOut );


/*ICMEncodedFrameGetDataPtr

Gets the data buffer for an encoded frame.

UInt8 *ICMEncodedFrameGetDataPtr (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

A pointer to the object's data buffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
UInt8 *ICMEncodedFrameGetDataPtr (
   ICMEncodedFrameRef   frame );

/*ICMCompressorSourceFrameGetPixelBuffer

Retrieves a source frames pixel buffer.

CVPixelBufferRef ICMCompressorSourceFrameGetPixelBuffer (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

A reference to the pixel buffer containing the source frame's image being compressed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
CVPixelBufferRef ICMCompressorSourceFrameGetPixelBuffer (
   ICMCompressorSourceFrameRef   sourceFrame );

/*ICMEncodedFrameSetDataSize

Sets the data size of the compressed frame in an encoded frame's buffer.

OSStatus ICMEncodedFrameSetDataSize (
   ICMMutableEncodedFrameRef   frame,
   ByteCount                   dataSize );
Parameters
frame

A reference to an encoded frame object with write capabilities.
dataSize

The data size of the compressed frame in the encoded frame object's buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMEncodedFrameSetDataSize (
   ICMMutableEncodedFrameRef   frame,
   ByteCount                   dataSize );


/*ICMEncodedFrameSetMediaSampleFlags

Sets the media sample flags for an encoded frame.

OSStatus ICMEncodedFrameSetMediaSampleFlags (
   ICMMutableEncodedFrameRef   frame,
   MediaSampleFlags            mediaSampleFlags );
Parameters
frame

A reference to an encoded frame object with write capabilities.
mediaSampleFlags

The object's media sample flags. These flags are listed in the header file Movies.h.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMEncodedFrameSetMediaSampleFlags (
   ICMMutableEncodedFrameRef   frame,
   MediaSampleFlags            mediaSampleFlags );

/*ICMEncodedFrameSetFrameType

Sets the frame type for an encoded frame.

OSStatus ICMEncodedFrameSetFrameType (
   ICMMutableEncodedFrameRef   frame,
   ICMFrameType                frameType );
Parameters
frame

A reference to an encoded frame object with write capabilities.
frameType

The frame type to be set: kICMFrameType_I = 'I' An I frame. kICMFrameType_P = 'P' A P frame. kICMFrameType_B = 'B' A B frame. kICMFrameType_Unknown = 0 A frame of unknown type. See these constants: 
kICMFrameType_I
kICMFrameType_P
kICMFrameType_B
kICMFrameType_Unknown
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameSetFrameType (
   ICMMutableEncodedFrameRef   frame,
   ICMFrameType                frameType );


/*ICMCompressorSessionEmitEncodedFrame

Called by a compressor to output an encoded frame corresponding to one or more source frames.

OSStatus ICMCompressorSessionEmitEncodedFrame (
   ICMCompressorSessionRef       session,
   ICMMutableEncodedFrameRef     encodedFrame,
   long                          numberOfSourceFrames,
   ICMCompressorSourceFrameRef   sourceFrames[] );
Parameters
session

A reference to the compression session between the ICM and an image compressor component.
encodedFrame

A reference to an encoded frame object with write capabilities.
numberOfSourceFrames

The number of source frames encoded in the encoded frame.
sourceFrames

References to frames that have been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Encoded frames may correspond to more than one source frame only if allowFrameTimeChanges is set in the compression session's compressionSessionOptions.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressorSessionEmitEncodedFrame (
   ICMCompressorSessionRef       session,
   ICMMutableEncodedFrameRef     encodedFrame,
   long                          numberOfSourceFrames,
   ICMCompressorSourceFrameRef   sourceFrames[] );

/*ICMEncodedFrameRelease

Decrements the retain count of an encoded frame object.

void ICMEncodedFrameRelease (
   ICMEncodedFrameRef    frame );
Parameters
frame

A reference to an encoded frame object. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMEncodedFrameRelease (
   ICMEncodedFrameRef    frame );


/*ICMCompressionSessionOptionsRelease

Decrements the retain count of a compression session options object.

void ICMCompressionSessionOptionsRelease (
   ICMCompressionSessionOptionsRef    options );
Parameters
options

A reference to a compression session options object. This reference is returned by ICMCompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMCompressionSessionOptionsRelease (
   ICMCompressionSessionOptionsRef    options );

/*ICMCompressionFrameOptionsGetFrameType

Retrieves the frame type setting.

ICMFrameType ICMCompressionFrameOptionsGetFrameType (
   ICMCompressionFrameOptionsRef   options );
Parameters
options

A compression frame options reference. This reference is returned by ICMCompressionFrameOptionsCreate.
Return Value

On return, one of the frame types listed below.
Discussion

This function can return one of these constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMFrameType ICMCompressionFrameOptionsGetFrameType (
   ICMCompressionFrameOptionsRef   options );


/*ICMCompressionSessionOptionsRetain

Increments the retain count of a compression session options object.

ICMCompressionSessionOptionsRef ICMCompressionSessionOptionsRetain (
   ICMCompressionSessionOptionsRef    options );
Parameters
options

A reference to a compression session options object. This reference is returned by ICMCompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Return Value

A copy of the object reference passed in options, for convenience.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

ICMCompressionSessionOptionsRef ICMCompressionSessionOptionsRetain (
   ICMCompressionSessionOptionsRef    options );

/*ICMCompressionSessionOptionsGetMaxKeyFrameInterval

Retrieves the maximum key frame interval.

SInt32 ICMCompressionSessionOptionsGetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns the maximum key frame interval.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

SInt32 ICMCompressionSessionOptionsGetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options );


/*GetCodecInfo

Returns information about a single compressor component.

OSErr GetCodecInfo (
   CodecInfo         *info,
   CodecType         cType,
   CodecComponent    codec );
Parameters
info

A pointer to a CodecInfo structure. GetCodecInfo returns detailed information about the appropriate compressor component in this structure.
cType

Set this parameter to a valid compressor type constant; see Codec Identifiers. If you want information about any compressor of the type specified by this parameter, set the codec parameter to 0. The Image Compression Manager then returns information about the first compressor it finds of the type you have specified.
codec

Set this parameter to the component identifier of the specific compressor for the request, or to 0 for any compressor. Component identifiers are available in the CodecNameSpecList structure returned by GetCodecNameList.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCodecInfo (
   CodecInfo         *info,
   CodecType         cType,
   CodecComponent    codec );

/*GraphicsExportGetSettingsAsAtomContainer

Retrieves the current settings from a graphics exporter component.

ComponentResult GraphicsExportGetSettingsAsAtomContainer (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Points to a variable to receive a new QuickTime atom container containing the current graphics exporter component settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

The caller is responsible for disposing of the returned atom container.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetSettingsAsAtomContainer (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );

/*GraphicsImportGetExportSettingsAsAtomContainer

Retrieves settings for image files exported by the graphics importer.

ComponentResult GraphicsImportGetExportSettingsAsAtomContainer (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
qtAtomContainerPtr

A pointer to a QuickTime atom container that is to receive the settings information.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a new QuickTime atom container which holds information about how images will be saved by GraphicsImportExportImageFile.
Special Considerations

It is the responsibility of the caller to dispose of this atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportGetExportSettingsAsAtomContainer (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );

/*GetMaxCompressionSize

Determines the maximum size an image will be after compression.

OSErr GetMaxCompressionSize (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecQ                 quality,
   CodecType              cType,
   CompressorComponent    codec,
   long                   *size );
Parameters
src

A handle to the source image. The source image must be stored in a pixel map structure. The compressor uses only the image's size and pixel depth to determine the maximum size of the compressed image.
srcRect

A pointer to a rectangle defining the portion of the source image that is to be compressed. You may set this parameter to NIL if you are interested only in information about quality settings. GetCompressionTime then uses the bounds of the source pixel map.
colorDepth

The depth at which the image is to be compressed. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by GetCodecInfo.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

You must set this parameter to a valid compressor type constant; see Codec Identifiers.
codec

A compressor identifier. Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). You can also specify a component instance. This may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
size

A pointer to a field to receive the size, in bytes, of the compressed image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the maximum resulting size for the specified image and parameters. Your application may then use this information to allocate memory for the compression operation. The following code sample illustrates its use:// GetMaxCompressionSize coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetMaxCompressionSize (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecQ                 quality,
   CodecType              cType,
   CompressorComponent    codec,
   long                   *size );


/*CompressImage

Compresses a single-frame image that is currently stored as a pixel map structure.

OSErr CompressImage (
   PixMapHandle              src,
   const Rect                *srcRect,
   CodecQ                    quality,
   CodecType                 cType,
   ImageDescriptionHandle    desc,
   Ptr                       data );
Parameters
src

A handle to the image to be compressed. The image must be stored in a pixel map structure.
srcRect

A pointer to a rectangle defining the portion of the image to compress.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

A compressor type; see Codec Identifiers.
desc

A handle that is to receive a formatted ImageDescription structure. The Image Compression Manager resizes this handle for the returned image description structure. Your application should store this image description with the compressed image data.
data

Points to a location to receive the compressed image data. It is your program's responsibility to make sure that this location can receive at least as much data as indicated by the GetMaxCompressionSize function. The Image Compression Manager places the actual size of the compressed image into the dataSize field of the ImageDescription structure structure referred to by the desc parameter. This pointer must contain a 32-bit clean address.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The following code sample illustrates the process of compressing and decompressing a pixel map.// CompressImage coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CompressImage (
   PixMapHandle              src,
   const Rect                *srcRect,
   CodecQ                    quality,
   CodecType                 cType,
   ImageDescriptionHandle    desc,
   Ptr                       data );

/*DecompressImage

Decompresses a single-frame image into a pixel map structure.

OSErr DecompressImage (
   Ptr                       data,
   ImageDescriptionHandle    desc,
   PixMapHandle              dst,
   const Rect                *srcRect,
   const Rect                *dstRect,
   short                     mode,
   RgnHandle                 mask );
Parameters
data

Points to the compressed image data. This pointer must contain a 32-bit clean address.
desc

A handle to the ImageDescription structure that describes the compressed image.
dst

A handle to the pixel map where the decompressed image is to be displayed. Set the current graphics port to the port that contains this pixel map.
srcRect

A pointer to a rectangle defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the compressed image, which is defined by (0,0) and ((**desc).width,(**desc).height). If you want to decompress the entire source image, set this parameter to NIL. If the parameter is NIL, the rectangle is set to the rectangle structure of the ImageDescription structure.
dstRect

A pointer to the rectangle into which the decompressed image is to be loaded. The compressor scales the source image to fit into this destination rectangle.
mode

The transfer mode for the operation, as listed in Graphics Transfer Modes.
mask

A handle to a clipping region in the destination coordinate system. If specified, the compressor applies this mask to the destination image. If you do not want to mask bits in the destination, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Note that DecompressImage is invoked through the StdPix function. The following code sample illustrates the process of compressing and decompressing a pixel map.// DecompressImage coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DecompressImage (
   Ptr                       data,
   ImageDescriptionHandle    desc,
   PixMapHandle              dst,
   const Rect                *srcRect,
   const Rect                *dstRect,
   short                     mode,
   RgnHandle                 mask );

#ifdef __cplusplus
}
#endif

#endif 
