#ifndef SYS_UN_H
#define SYS_UN_H

#include <sys/appleapiopts.h>
#include <sys/cdefs.h>
#include <sys/_types.h>
#include <HYS/sys/un.h>
/*ADDRESSING
     UNIX-domain addresses are variable-length filesystem pathnames of at most
     104 characters.  The include file <sys/un.h> defines this address:

           struct sockaddr_un {
                   u_char  sun_len;
                   u_char  sun_family;
                   char    sun_path[104];
           };

     Binding a name to a UNIX-domain socket with bind(2) causes a socket file
     to be created in the filesystem.  This file is not removed when the
     socket is closed--unlink(2) must be used to remove the file.

     The UNIX-domain protocol family does not support broadcast addressing or
     any form of ``wildcard'' matching on incoming messages.  All addresses
     are absolute- or relative-pathnames of other UNIX-domain sockets.  Normal
     filesystem access-control mechanisms are also applied when referencing
     pathnames; e.g., the destination of a connect(2) or sendto(2) must be
     writable.
*/

struct sockaddr_un {
	 unsigned char sun_len;
	unsigned char  sun_family;
         char    sun_path[104];
 };

#endif