#ifndef HITOOLBOX_H
#include <HIToolbox/HIToolbox.h>
#endif

int NewCWindow(int a, int b, int c, int d, int e, int f, int g, int h){};

/*RunStandardAlert

Shows and runs a standard alert using a modal dialog loop.

OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit
);
Parameters
inAlert

The alert to display. Note that this function automatically disposes of the dialog you pass in this parameter before returning. 
filterProc

An event filter function for handling events that do not apply to the alert. May be NULL. 
outItemHit

On exit, contains the item index of the button that was pressed to close the alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus RunStandardAlert (
   DialogRef inAlert,
   ModalFilterUPP filterProc,
   DialogItemIndex * outItemHit){
//TODO
};


/*CreateStandardAlert

Creates an alert containing standard elements and using standard formatting rules.

OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert
);
Parameters
alertType

The type of alert to create. 
error

The error string to display. 
explanation

The explanation string to display. May be NULL or empty to display no explanation.
param

The parameter block describing how to create the alert. May be NULL. 
outAlert

On exit, contains the new alert. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

CreateStandardAlert should be used in conjunction with RunStandardAlert. After CreateStandardAlert returns, the alert is still invisible. RunStandardAlert will show the alert and run a modal dialog loop to process events in the alert.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Dialogs.h*/
OSStatus CreateStandardAlert (
   AlertType alertType,
   CFStringRef error,
   CFStringRef explanation,
   const AlertStdCFStringAlertParamRec * param,
   DialogRef * outAlert){
//TODO
};




/*GetFrontWindowOfClass

Obtains the frontmost window of a given class. 

WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindowClass

The class of the window you want to obtain. If you pass kAllWindowClasses, the function returns the frontmost window in the window list. 
mustBeVisible

If set to true, the function returns the frontmost visible window. If set to false, the function returns the frontmost window of the specified class, regardless of whether the window is visible.
Return Value

A reference to the frontmost window of the class specified by inWindowClass.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes
Declared In
MacWindows.h*/
WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible){
//TODO
};


/*ShowWindow

Makes an invisible window visible.

void ShowWindow (
   WindowRef window
);
Parameters
window

The window that is to be made visible.
Discussion

The ShowWindow function makes an invisible window visible. If the specified window is already visible, ShowWindow has no effect. Your application typically creates a new window in an invisible state, performs any necessary setup of the content region, and then calls ShowWindow to make the window visible.

When you call ShowWindow to display a window that is invisible, the Window Manager draws the window frame and sends an event to request the application to draw the content region before the window becomes visible. For compositing windows, the Window Manager sends a kEventControlDraw event to each HIView in the window. For non-compositing windows, the Window Manager sends a kEventWindowDrawContent event. If a non-compositing window does not handle the kEventWindowDrawContent, the Window Manager shows the window and generates an update event to request your application to draw the content region.

If the newly visible window is the frontmost window, ShowWindow highlights it if it’s not already highlighted and generates an activate event to make it active. The ShowWindow function does not activate a window that is not frontmost on the desktop.

Because ShowWindow does not change the front-to-back ordering of windows, it is not the inverse of HideWindow. If you make the frontmost window invisible with HideWindow, andHideWindow has activated another window, you must call both ShowWindow and SelectWindow to bring the original window back to the front.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ShowWindow (
   WindowRef window){
//TODO
};


/*SetWindowModified

Sets the modification state of the specified window.

OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);
Parameters
window

The window whose modification state is to be set.
modified

Pass true if the content of the window has been modified; otherwise, pass false.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application can use the functions SetWindowModified and IsWindowModified instead of maintaining its own separate record of the modification state of the content of a window. The modification state of a window is visually represented by a dot in the window’s close box. If the dot is present, the window is modified; if the dot is absent, the window is not modified.

Your application should distinguish between the modification state of the window and the modification state of the window’s contents, typically a document. The modification state of the window contents are what should affect SetWindowModified. For example, in the case of a word processing document, you call SetWindowModified (passing true in the modified parameter) whenever the user types new characters into the document. However, you do not call SetWindowModified when the user moves the window, because that change does not affect the document contents. If you need to track whether the window position has changed, you need to do this with your own flag. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified){
//TODO
};

/*SetMenuBarFromNib

Unarchives a menu bar from a nib file, then makes the menu bar available in your application.

OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName
);
Parameters
inNibRef

A reference to the nib file that contains the menu bar you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the menu bar you want to unarchive. This is the name you supplied to the menu bar in the Instances pane of Interface Builder. (The default name is “MainMenu”.) See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
Return Value

A result code. See Runtime Errors.
Discussion

The function SetMenuBarFromNib makes the menu bar visible and selectable by the user when your application opens. If you don’t want the menu bar to be visible and selectable when it is unarchived, use the function CreateMenuBarFromNib. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus SetMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName){
//TODO
};



/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu item’s command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID){
//TODO
};

/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (
   MenuRef theMenu,
   short item){
//TODO
};


/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem){
//TODO
};

/*CreateNibReference

Creates a reference to a nib file in the current bundle.

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef
);
Parameters
inNibName

A CFStringRef that represents the name of a nib file you created for your application, but without the nib extension. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outNibRef

On output, points to a nib reference. You pass the nib reference to Interface Builder Services functions that unarchive objects from a nib file.
Return Value

A result code. See Runtime Errors.
Discussion

Use this function if the nib file is located in the current bundle. Use the function CreateNibReferenceWithCFBundle if the nib file is located in a framework or other bundle that is not the current bundle. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/

OSStatus CreateNibReference (
   CFStringRef inNibName,
   IBNibRef * outNibRef){
//TODO
};

/*NewEventHandlerUPP

Creates an event handler UPP.

EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event handler. 
Return Value

The UPP for your event handler.
Discussion

When registering your event handler with InstallEventHandler, you must pass a universal procedure pointer (UPP) to your event handler instead of a standard procedure pointer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventHandlerUPP NewEventHandlerUPP (
   EventHandlerProcPtr userRoutine){
//TODO
};

/*TXNRevert

Reverts to the last saved version of a document. 

OSStatus TXNRevert (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNRevert function with files that contain only text as well as files that were created using MLTE. If the file was not previously saved, the document reverts to an empty document. To revert to data that is embedded in a private file type, use the TXNSetSelection function to select all of the current data and then use the TXNSetDataFromFile function to read in the old data. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNRevert (TXNObject iTXNObject){
//TODO
};


/*TXNPageSetup

Displays the Page Setup dialog for the current default printer and manages changes, such as reformatting the text, in response to page layout changes.

OSStatus TXNPageSetup (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object for the active document. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPageSetup (
   TXNObject iTXNObject){
//TODO
};


/*TXNPrint

Prints the document so it is formatted to fit the page size selected for the printer. 

OSStatus TXNPrint (
   TXNObject iTXNObject
);
Parameters
iTXNObject

The text object that identifies the document you want to print. 
Return Value

A result code. See “MLTE Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNPrint (
   TXNObject iTXNObject){
//TODO
};



/*GetEventKind

Returns the event kind for the specified event.

UInt32 GetEventKind (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The kind of the event. 
Discussion

Event kind values overlap in different event classes. For example, kEventMouseDown and kEventAppActivated both have the same value (1). The combination of class and kind determines a unique event signature.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventKind (
   EventRef inEvent){
//TODO
};

/*GetEventClass

Returns the class of an event (for example, window, mouse, or keyboard).

UInt32 GetEventClass (
   EventRef inEvent
);
Parameters
inEvent

The event in question. 
Return Value

The class ID of the event. See “Event Class Constants” for more details. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
UInt32 GetEventClass (
   EventRef inEvent){
//TODO
};




/*GetControl32BitValue

Obtains the current setting of a control.

SInt32 GetControl32BitValue (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current setting you wish to obtain. 
Return Value

The current setting of the control. 
Discussion

Your application may use the GetControl32BitValue function to obtain a 32-bit value previously set with the function SetControl32BitValue.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitValue (
   ControlRef theControl){
//TODO
};


/*GetControlPopupMenuHandle

Gets the menu handle for a pop-up control.

MenuRef GetControlPopupMenuHandle (
   ControlRef control
);
Parameters
control

The pop-up control to query.
Return Value

See the Menu Manager documentation for a description of the MenuRef data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
MenuRef GetControlPopupMenuHandle (
   ControlRef control){
//TODO
};




/*RunApplicationEventLoop

Runs the application event loop.

void RunApplicationEventLoop ();
Discussion

This function is used as the main event loop for a Carbon Event-based application. Once entered, this function waits for events to arrive and dispatches them to your event handlers automatically. 

Note that calling RunApplicationEventLoop also installs the standard application handler, which provides standard handler responses for menu and application events. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void RunApplicationEventLoop (){
//TODO
};


/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (MenuRef inMenu,MenuItemIndex inItem,CFStringRef * outString){
//TODO
};


/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits){
//TODO
};

int HIThemeDrawTextBox( int a, int b, int c, int d, int e ){
//TODO
};

int HIThemeGetTextDimensions( int a, int b, int c, int d, int e,int  f){
//TODO
};

/*NewEventLoopTimerUPP

Creates an event loop timer UPP. 

EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event timer callback function. 
Return Value

The UPP for your event timer callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopTimerUPP NewEventLoopTimerUPP (
   EventLoopTimerProcPtr userRoutine){
//TODO
};



/*GetMainEventLoop

Obtains a reference to the main event loop.

EventLoopRef GetMainEventLoop ();
Return Value

An event loop reference. 
Discussion

The main loop is the event loop for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetMainEventLoop ();

/*InstallEventLoopTimer

Installs a timer.

OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer
);
Parameters
inEventLoop

The event loop to add the timer. 
inFireDelay

The delay before first firing this timer, in seconds. In Mac OS X v10.3 and earlier, the delay must be greater than zero. In Mac OS X v10.4, the delay can be greater than or equal to zero. 

In Mac OS X and CarbonLib 1.5 and later, you may pass kEventDurationForever to stop the timer from firing at all until SetEventLoopTimerNextFireTime is used to start it; in earlier versions of CarbonLib, to achieve the same effect, just pass zero and then immediately call SetEventLoopTimerNextFireTime( timer, (kEventDurationForever ) before returning control to your event loop.
inInterval

The timer interval, in seconds. Pass 0 or (in Mac OS X and CarbonLib 1.5 and later) kEventDurationForever for a one-shot timer. 
inTimerProc

The function to call when the timer fires. 
inTimerData

Data to pass to the timer function when called.
outTimer

A reference to the newly installed timer. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Installs a timer onto the event loop specified. The timer can either fire once or repeatedly at a specified interval depending on the parameters passed to this function. It executes at task level and should not be confused with Time Manager tasks or any other interrupt-level callback. This means you can call toolbox functions, allocate memory, and draw without worrying about consequences. When a timer fires, it calls the callback you specified when the timer was installed.

Timers in general have two uses: as a timeout mechanism and as a periodic task. An everyday example of using a timer for a timeout might be a light that goes out if no motion is detected in a room for 5 minutes. For this, you might install a timer which will fire in 5 minutes. If motion is detected, you would reset the timer fire time and let the clock start over. If no motion is detected for the full 5 minutes, the timer will fire and you could power off the light. A periodic timer is one that fires at regular intervals (say every second or so). You might use such a timer to blink the insertion point in your editor, and so on.

One advantage of timers is that you can install the timer right from the code that wants the time. For example, the standard editable text control can install a timer to blink the cursor when it’s active, meaning that the Control Manager function IdleControls is a no-op for that control and doesn’t need to be called. When the control is inactive, it removes its timer and doesn’t waste CPU time in that state.

Currently, if you do decide to draw when your timer is called, be sure to save and restore the current port so that calling your timer doesn’t inadvertently change the port out from under someone. 

Be sure to dispose of the timer when you no longer need it by calling RemoveEventLoopTimer. Doing so is especially important if your timer calls code that may no longer exist. For example, if a plugin creates a timer that calls back to it, the timer will attempt to call it even after the plugin is removed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventLoopTimer (
   EventLoopRef inEventLoop,
   EventTimerInterval inFireDelay,
   EventTimerInterval inInterval,
   EventLoopTimerUPP inTimerProc,
   void * inTimerData,
   EventLoopTimerRef * outTimer){
//TODO
};


/*GetControlEventTarget

Obtains the event target reference for the specified control.

EventTargetRef GetControlEventTarget (
   ControlRef inControl
);
Parameters
inControl

The control to return the target for. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetControlEventTarget (
   ControlRef inControl){
//TODO
};



/*UnregisterEventHotKey

Unregisters a global hot key. 

OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);
Parameters
inHotKey

The event hot key reference of the hot key you want to unregister. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Unregisters a global hot key that was previously registered with the function RegisterEventHotKey. You do not need to unregister a hot key when your application terminates; the system takes care of that for you. You can use this function if the user changes a hot key for something in your application—you would unregister the previous key and register your new key. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey){
//TODO
};


/*HIViewSetNeedsDisplay

Marks a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);
Parameters
inView

The view to mark as dirty (needing to be redrawn) or clean (not needing to be redrawn).
inNeedsDisplay

A Boolean whose value is true to mark the view as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay){
//TODO
};



/*CopyWindowTitleAsCFString

Copies the window title into a Core Foundation string.

OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString
);
Parameters
inWindow

The window whose title is to be copied.
outString

On output, the window’s title. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString){
//TODO
};


/*CreateNewWindow

Creates a window from parameter data.

OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
windowClass

A constant that categorizes the class of window to be created. For certain classes, the window class can be altered after the window is created by calling HIWindowChangeClass. See “Window Class Constants” for a description of possible values for this parameter.
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes.
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region.
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateNewWindow function creates a window based on the attributes and class you specify in the attributes and windowClass parameters. CreateNewWindow sets the new window’s content region to the size and location specified by the rectangle passed in the bounds parameter, which in turn determines the dimensions of the entire window. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateNewWindow, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow){
//TODO
};


/*RepositionWindow

Positions a window relative to another window or a display screen.

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method
);
Parameters
window

The window whose position you want to set.
parentWindow

A pointer to the “parent” window, as defined by your application. In cases where the window positioning method does not require a parent window, you should set the parentWindow parameter to NULL.
method

A constant specifying the window positioning method to be used; see “Window Position Constants” for descriptions of possible values. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application may call the RepositionWindow function to position any window, relative to another window or to a display screen. After positioning the window, RepositionWindow displays the window in its new position.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method){
//TODO
};

/*CreateTabsControl

Creates a tabs control.

OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
size

The control tab size. See Control Tab Size Constants for possible values.
direction

The control tab direction. See Control Tab Direction Constants for possible values.
numTabs

The initial number of tabs.
tabArray

Information about each tab. There must be the same number of entries as specified by the numTabs parameter.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

If you want to customize the accessibility information provided for individual tabs of a tabs control, such as by handling various kEventClassAccessibility Carbon Events and by calling HIObjectSetAuxiliaryAccessibilityAttribute, you need to know how to build or interpret AXUIElement reference that represent individual tabs. The AXUIElement representing an individual tab must be constructed using the tab control’s ControlRef and the UInt64 identifier of the one-based index of the tab to which the element refers. A UInt64 identifier of 0 represents the tabs control as a whole. You cannot interpret or create tab control elements whose identifiers are greater than the count of tabs in the tabs control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl){
//TODO
};


/*HIViewAddSubview

Adds a subview to the given parent view.

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
);
Parameters
inParent

The view that will receive the new subview.
inNewChild

The subview being added.
Return Value

An operating system result code. The result code errNeedsCompositedWindow is returned if you try to embed into the content view in a non-compositing window; you can only embed into the content view in a compositing window.
Discussion

The new subview is added to the front of the list of subviews (that is, it is made topmost). The subview being added is not retained by the new parent view. Do not release the view after adding it, or it will cease to exist. All views in a window are released automatically when the window is destroyed.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild){
//TODO
};


/*SetControlCommandID

Sets the command ID for a control. 

OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID
);
Parameters
inControl

. For a description of this data type, see 
inCommandID

The command ID that is to be set.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlCommandID (
   ControlRef inControl,
   UInt32 inCommandID){
//TODO
};


/*SetControlID

Sets a control’s ID. 

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID
);
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSStatus SetControlID (
   ControlRef inControl,
   const ControlID * inID){
//TODO
};


/*HIViewSetLayoutInfo

Sets the layout information of an HIView. 

OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
);
Parameters
inView

The view whose layout information is to be set.
inLayoutInfo

A pointer to an HILayoutInfo structure containing the layout values that are to be set.
Return Value

An operating system result code.
Discussion

Layouts are used to automatically change the size and positioning of a view when another view changes size or position. Layout changes only take effect in two cases:
When HIViewApplyLayout is called after the view’s layout has been set by calling HIViewSetLayoutInfo. The HIViewApplyLayout function is most useful when first applying a scaling or positioning layout to a view in order to set up the view’s initial position and size relative to the view referenced in the layout.
When the related view changes its size or position.

A layout allows a view’s size or position to be modified in three ways: side binding, axial scaling, and axial positioning. In the following examples, View A initially has a left side of 100 and a right side of 150, and is placed inside a parent view that has a width of 275.
Bindings — Setting up a binding relationship between two views specifies that one edge of a view is to change by an amount equal to the change in an edge of another view. If View A has a right-side binding to its parent’s maximum (or right) side, when the parent’s right side changes, View A’s right side changes by the same amount. If the parent view resizes to be 325 units wide (50 units wider than before), View A is resized so that its left side changes to 150 units and its right side changes to 200, which is 50 units more to the right than before. You can think of bindings as a way to maintain distance. An edge bound to another view’s edge always maintains its offset from that related edge. In other view systems, this concept is often referred to as “springs and rods.” Note that a binding does not cause one side of the view to exactly align with the side of another view; a binding merely causes one side of the view to change by the same amount as another view changes. To align one edge of a view to another view’s edge, use positioning. Bindings depend on changes in size or position of the related view. As a result, calling HIViewApplyLayout does not activate side bindings, as no changes have occurred. Bindings are implemented using the HIBinding structure and one HISideBinding structure per view edge.
Scaling — Setting up a scaling relationship between two views specifies that the axial size (that is, the width or height) of a view is to be a specified ratio of the size of another view when that other view moves or resizes. If View A has an x-axis scaling for its parent view with a ratio of 0.8, when the parent view’s width changes, View A’s width changes to be the parent’s width multiplied by 0.8. If the parent view resizes to be 325 units wide, View A resizes so that its left side stays at 100 and its right side changes to 360 (100 + 325 * 0.8). Note that when a scaling layout is first set up on a view with HIViewSetLayoutInfo, no scaling is applied to the view because scaling only occurs when the related view resizes. If scaling is required at initial setup, call HIViewSetLayoutInfo and then HIViewApplyLayout. Scaling is implemented using the HIScaling structure and one HIAxisScale structure per view axis.
Positioning — Setting up a positioning relationship between two views specifies that the axial position (i.e., vertical or horizontal) of a view is to change so that the view aligns with the minimum, maximum, or center of another view when that other view resizes. If View A has an x-axis position with its parent view with center positioning specified, when the parent view changes size, View A moves so that it is centered horizontally relative to its parent. If the parent view resizes to be 300 units wide, View A repositions so that its left side is at 125 and its right side is at 175, centered in the parent view. Positioning is implemented using the HIPositioning structure and one HIAxisPosition per view axis.

The HIView layout engine applies transformations to a view sequentially. First, bindings are applied. Then scaling is applied, which could override some of the previously applied bindings. Then positioning is applied, which could also override some of the previously applied bindings. The bindings are applied recursively to a container’s subviews, which requires care on your part to avoid infinite recursion, especially when applying inter-relational bindings. For example, if View A’s x axis is scaled relative to View B and View B’s x-axis is scaled to View A, your application could hang when the layouts are applied because View A would affect View B, which would affect View A, and so on.

For more information on using the layout engine, see HIView Programming Guide.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo){
//TODO
};


/*CreateUserPaneControl

Creates a user pane control.

OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
features

The user pane features with which the user pane is to be created. For possible constants, see “Control Features Constants”. 
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

User panes have two primary purposes: to allow easy implementation of a custom control by the developer, and to provide a generic container for embedding other controls.

In Carbon, with the advent of Carbon-event-based controls, you may find it easier to write a new control from scratch than to customize a user pane control. The set of callbacks provided by the user pane will not be extended to support new Control Manager features; instead, you should just write a real control.User panes do not, by default, support embedding. If you try to embed a control into a user pane, you will get the errControlIsNotEmbedder. You can make a user pane support embedding by passing the kControlSupportsEmbedding flag in the features parameter when you create the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl){
//TODO
};


/*HIViewSetVisible

Hides or shows a view. 

OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
);
Parameters
inView

The view to hide or show.
inVisible

A Boolean value that indicates whether you want to hide the view (false) or show the view (true).
Return Value

An operating system result code.
Discussion

Marks the area the view will occupy or previously occupied as needing to be redrawn later. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible){
//TODO
};


/*CreateStaticTextControl

Creates a new static text control.

OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl){
//TODO
};



/*CreatePushButtonControl

Creates a push button control.

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl){
//TODO
};


/*GetControl32BitMinimum

Obtains the minimum setting of a control.

SInt32 GetControl32BitMinimum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose minimum setting you wish to obtain. For a description of this data type, see “ControlRef”.
Return Value

The minimum setting of the control. 
Discussion

Your application may use the GetControl32BitMinimum function to obtain a 32-bit value previously set with the function SetControl32BitMinimum.

If your application uses a 32-bit control minimum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMinimum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitMinimum (
   ControlRef theControl){
//TODO
};



/*HIViewGetLastSubview

Returns the last subview in a parent view.

HIViewRef HIViewGetLastSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the last subview of a container. The last subview is the bottommost subview in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetLastSubview (
   HIViewRef inView){
//TODO
};



/*HIViewGetPreviousView

Returns the view above the specified view.

HIViewRef HIViewGetPreviousView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view in front of it or is invalid.
Discussion

Returns the view before the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetPreviousView (
   HIViewRef inView){
//TODO
};


/*DisableMenuItem

Disables a menu item or a menu.

void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be disabled. 
item

The index of the menu item that you wish to disable. Pass 0 to specify the menu title (disabling the entire menu). 
Discussion

The DisableMenuItem function disables a menu item (and any associated icon) so that the user cannot choose the item from the menu. 

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the EnableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Note that the implementation of Carbon on Mac OS 8.1 only supports disabling menu items less than or equal to 31.
Declared In
Menus.h*/
void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item){
//TODO
};


/*EnableMenuItem

Enables a menu item or a menu.

void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be enabled. 
item

The item number of the menu item that you wish to enable. If you pass 0, EnableMenuItem enables the menu title and all items in the menu that were not previously individually disabled. 
Discussion

The EnableMenuItem function enables a menu item so that the user can choose the item from the menu. If the menu item has an associated icon, that icon is also enabled, unless the icon was previously individually disabled with the function DisableMenuItemIcon.

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the DisableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item){
//TODO
};

/*GetNextWindowOfClass

Obtains the next window in a given window group. 

WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindow

The window at which to start.
inWindowClass

The class of window to obtain. If you pass kAllWindowClasses, the function returns the window directly behind the input window. If no windows exist behind the front window, the function returns NULL. 
mustBeVisible

If set to true, this function returns the next visible window of the specified window class. If set to false, this function returns the next window of the specified window class, regardless of whether it is visible.
Return Value

A reference for the next window of the specified class after the window specified by inWindow.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible){
//TODO
};

int GetMouse(int a ){
//TODO
};


/*RemoveEventLoopTimer

Removes the specified timer.

OSStatus RemoveEventLoopTimer (
   EventLoopTimerRef inTimer
);
Parameters
inTimer

The timer to remove. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Removes a timer that was previously installed by a call to InstallEventLoopTimer or InstallEventLoopIdleTimer. You call this function when you are done using a timer. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus RemoveEventLoopTimer (
   EventLoopTimerRef inTimer){
//TODO
};


/*DisposeEventLoopTimerUPP

Disposes of an event loop timer. 

void DisposeEventLoopTimerUPP (
   EventLoopTimerUPP userUPP
);
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void DisposeEventLoopTimerUPP (
   EventLoopTimerUPP userUPP){
//TODO
};

/*SetEventLoopTimerNextFireTime

Sets the next time that the specified timer will fire.

OSStatus SetEventLoopTimerNextFireTime (
   EventLoopTimerRef inTimer,
   EventTimerInterval inNextFire
);
Parameters
inTimer

The timer whose firing time you want to set. 
inNextFire

The interval from the current time to wait until firing the timer again. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used to “reset” a timer. It controls the next time the timer fires. This will override any interval you might have set. For example, if you have a timer that fires every second, and you call this function setting the next time to 5 seconds from now, the timer will sleep for 5 seconds, then fire. The timer will then resume its one second interval. This function acts as if you removed the timer and reinstalled it with a new first-fire delay.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventLoopTimerNextFireTime (
   EventLoopTimerRef inTimer,
   EventTimerInterval inNextFire){
//TODO
};


/*GetControlOwner

Returns the window to which a control is bound.

WindowRef GetControlOwner (
   ControlRef control
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
Return Value

The window reference to which the control is bound, or NULL if the control is not bound to a window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
WindowRef GetControlOwner (
   ControlRef control){
//TODO
};

/*SetControlAction

Sets the action function for a control.

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc
);
Parameters
theControl

A handle to the control whose action function is to be changed. For a description of this data type, see 
actionProc

A universal procedure pointer to an action function defining what action your application takes while the user holds down the mouse button. See ControlActionProcPtr for a description of an action function. 
Discussion

The SetControlAction function associates the action function specified by actionProc with the control specified by theControl. If the cursor is in the specified control, the HandleControlClick and TrackControl functions call the specified action function when the user holds down the mouse button. You must provide the action function, and it must define some action to perform repeatedly as long as the user holds down the mouse button. HandleControlUnderClick and TrackControl always highlight and drag the control as appropriate.

SetControlAction should be used to set the application-defined action function for providing live feedback for standard system scroll bar controls.

Note that the action function associated with a control is used by TrackControl only if you set the action function to TrackControl to Pointer(–1). Also, an action function can be specified in the actionProc parameter to TrackControl, so you don’t have to call SetControlAction to change it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControlAction (
   ControlRef theControl,
   ControlActionUPP actionProc){
//TODO
};

/*HIViewSetText

Sets the text of a view to the specified string.

OSStatus HIViewSetText (
HIViewRef inView,
CFStringRef inText
);
Parameters
inView

The view whose text is to be set.
inText

The text that is to be set.
Return Value

An operating system result code.
Discussion

This function attempts to set the text that is displayed when drawing the view and is generally successful on views that handle the kControlEditTextCFStringTag SetControlData tag. If this function can’t set that text, it sets the text in the view’s title instead.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetText (HIViewRef inView,CFStringRef inText){
//TODO
};


/*GetWRefCon

Returns the reference constant from a window.

long GetWRefCon (
   WindowRef window
);
Parameters
window

The window whose reference constant is to be returned.
Return Value

The long integer data stored in the refCon field of the window structure specified in the window parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
long GetWRefCon (WindowRef window){
//TODO
};


/*SetWRefCon

Sets the refCon field of a window.

void SetWRefCon (
   WindowRef window,
   long data
);
Parameters
window

The window whose refCon field is to be set.
data

On input, the data to be placed in the refCon field. 
Discussion

The SetWRefCon function places the specified data in the refCon field of the specified window structure. The refCon field is available to your application for any window-related data it needs to store. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWRefCon (
   WindowRef window,
   long data){
//TODO
};


/*HIViewSetID

Sets the HIViewID of a view.

OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID
);
Parameters
inView

The view whose HIViewID is to be set.
inID

The HIViewID to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID){
//TODO
};


/*CreateLittleArrowsControl

Creates a little arrows control.

OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value the control can have.
maximum

The maximum value the control can have.
increment

The amount to increment each time an arrow is clicked.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements the little up and down arrows seen in the Date & Time system preferences panel. To change the value of this control, you need to create a control action proc. The following sample code creates the control and sets the action proc:CreateLittleArrowsControl(&rect, minimum, maximum, increment,  value);
SetControlAction(Arrows, LittleArrowActionProc);


Here is sample code for the action proc:void LittleArrowActionProc(ControlRef cref, ControlPartCode part)  {
    SInt32 val = GetControl32BitValue(cref);
    SInt32 s = 0;
    GetControlData(MWArrows, 0, kControlLittleArrowsIncrementValueTag,  sizeof(SInt32), &s, nil;
    switch (part) {
        case kControlUpButtonPart:
            SetControl32BitValue(cref, val+s);
            break;
        case kControlDownButtonPart:
            SetControl32BitValue(cref, val-s);
            break;
        };
    };

Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl){
//TODO
};

/*GetControlData

Obtains control-specific data.

OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize
);
Parameters
inControl

A handle to the control to be examined. 
inPart

The part code of the control part from which data is to be obtained; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. For a description of this data type, see “ControlPartCode”. 
inTagName

A constant representing the control-specific data you wish to obtain see the data tag constants in the “Control Manager Constants” section. 
inBufferSize

The size (in bytes) of the data pointed to by the inBuffer parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inBufferSize parameter. The number of bytes must match the actual data size. 
inBuffer

On input, a pointer to a buffer allocated by your application. On return, the buffer contains a copy of the control-specific data. If you pass NULL on input, it is equivalent to calling GetControlDataSize. The actual size of the control-specific data will be returned in the outActualSize parameter. For variable-length data, the number of bytes must match the actual data size.
outActualSize

On input, a pointer to a Size value. On return, the value is set to the actual size of the data. You can pass NULL if you don’t care about this value. 
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The GetControlData function will only copy the amount of data specified in the inBufferSize parameter, but will tell you the actual size of the buffer so you will know if the data was truncated. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inBufferSize,
   void * inBuffer,
   Size * outActualSize){
//TODO
};

/*SetControl32BitValue

Changes the current setting of a control and redraws it accordingly.

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue
);
Parameters
theControl

A handle to the control whose current setting you wish to change. For a description of this data type, see “ControlRef”.
newValue

A value specifying the new setting of the control. If the specified value is less than the minimum setting for the control, SetControl32BitValue sets the current setting of the control to its minimum setting. If the specified value is greater than the maximum setting, SetControl32BitValue sets the control to its maximum.
Discussion

Your application may use the SetControl32BitValue function to set a 32-bit value as the current setting for a control.

If your application uses a 32-bit control value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlValue because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitValue. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void SetControl32BitValue (
   ControlRef theControl,
   SInt32 newValue){
//TODO
};

/*SetWindowDefaultButton

Specifies a default button for a window.

OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl
);
Parameters
inWindow

The window whose default button you want to set. See the Window Manager documentation for a description of the WindowRef data type.
inControl

The control to designate as the default. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to specify a control (normally a button) to be the default for a given window. This button would be considered to have been clicked if the user instead presses the Return or Enter keys on the keyboard. 

The standard window event handler looks for keystrokes that correspond to the default button and generates events of type kEventControlHit when it detects the correct key being pressed. This is similar to the way the Dialog Manager responds to default buttons, except that instead of returning an item index for which button is pressed, the Carbon Event Manager generates a control hit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl){
//TODO
};


/*HIObjectGetEventTarget

Obtains the event target of an HIObjectRef. 

EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject
);
Parameters
inObject

The object whose target you want.
Return Value

An EventTargetRef.
Availability
Available in Mac OS X v10.2 and later.*/
EventTargetRef HIObjectGetEventTarget (
   HIObjectRef inObject){
//TODO
};


/*StandardAlert

Displays a standard alert box. 

OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit
);
Parameters
inAlertType

A constant indicating the type of alert box you wish to create; see “Alert Type Constants”. 
inError

A pointer to a Pascal string containing the primary error text you wish to display. 
inExplanation

A pointer to a Pascal string containing the secondary text you wish to display; secondary text is displayed in the small system font. Pass null to indicate no secondary text.
inAlertParam

A pointer to the standard alert structure; see AlertStdAlertParamRec. Pass null to specify that you do not wish to your alert box to incorporate any of the features that the standard alert structure provides. 
outItemHit

A pointer to a signed 16-bit integer value. On return, the value indicates the alert button pressed; see “Alert Button Constants”. 
Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

The StandardAlert function displays an alert box based on the values you pass it. You can pass the error text you wish displayed in the error and explanation parameters, and customize the alert button text by filling in the appropriate fields of the standard alert structure passed in the inAlertParam parameter.

StandardAlert automatically resizes the height of a dialog box to fit all static text. It ignores alert stages and therefore provides no corresponding alert sounds. 
Special Considerations

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr StandardAlert (
   AlertType inAlertType,
   ConstStr255Param inError,
   ConstStr255Param inExplanation,
   const AlertStdAlertParamRec * inAlertParam,
   SInt16 * outItemHit){
//TODO
};

/*Draw1Control

Draws a control and any embedded controls that are currently visible in the specified window. 

void Draw1Control (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to draw. For a description of this data type, see “ControlRef”.
Discussion

Although you should generally use the functionUpdateControls to update controls, you can use the DrawOneControl function to update a single control. If an embedding hierarchy exists and the control passed in has embedded controls, DrawOneControl draws the control and embedded controls. If the root control for a window is passed in, the result is the same as if DrawControls was called.

If you are using compositing mode, you generally do not need to call Draw1Control. If you call Draw1Control in compositing mode, keep in mind that it draws the specified control as well as all other controls that intersect the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void Draw1Control (
   ControlRef theControl){
//TODO
};

/*SetDataBrowserCallbacks

Sets the callback routines to use with a data browser, replacing any previously installed callbacks.

OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks
);
Parameters
browser

A data browser.
callbacks

A pointer to a DataBrowserCallbacks structure that is filled out with universal procedure pointers (UPPs) to the callback routines your application provides. At a minimum, you need to provide a UPP to an item-data callback (DataBrowserItemDataProcPtr).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCallbacks you must first call InitDataBrowserCallbacks to initialize the data browser callback structure. Calling SetDataBrowserCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following callbacks. If you don’t supply callbacks in cases for which it’s optional, you get the default behavior provided by the data browser API.
DataBrowserItemDataProcPtr. You must provide this callback because communicates the text, icons, or other data to display in list view. It also communicates the metadata that defines how data is displayed, such as whether or not an item is a container or has a parent. If you set up your data browser to allow the user to edit, this callback informs your application when the user makes a change.
DataBrowserItemCompareProcPtr. You must provide a sorting callback if you want users to be able to sort the items in a column. If you want containers in a hierarchical list to be sorted independently, then you must provide a sorting callback that handles the hierarchical lists appropriately.
DataBrowserItemNotificationProcPtr. You must provide this (or the next) callback if you have hierarchical data in a list, or if you use column view.
DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr. You can provide this callback to allow dragging out of your data browser. 
DataBrowserAcceptDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to accept a drag item.
DataBrowserReceiveDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to receive a drag item.
DataBrowserPostProcessDragProcPtr. If you provide callbacks to allow dragging into your data browser, you can optionally provide a postprocess-drag callback to perform cleanup tasks.
DataBrowserGetContextualMenuProcPtr. You can optionally support a contextual menu. If so, you’ll need to provide the next callback too.
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr. You can optionally provide help tags.

Note that this function sets a different set of callbacks from those that are set by calling the function SetDataBrowserCustomCallbacks.

To replace a callback, you first need to get the current set of callbacks by calling the function GetDataBrowserCallbacks. Set the appropriate fields in the DataBrowserCallbacks structure to your callback. Then you call the function SetDataBrowserCallbacks. Your application can set as many callbacks as appropriate. 

The following code shows how to assign UPPs to the callbacks structure and then call the function SetDataBrowserCallbacks. The code assumes you have already called the function InitDataBrowserCallbacks to initialize the data browser callback structure.myCallbacks.u.v1.itemNotificationCallback =
        NewDataBrowserItemNotificationUPP (MyItemNotificationCallback);
 
myCallbacks.u.v1.acceptDragCallback =
        NewDataBrowserAcceptDragUPP (MyAcceptDragCallback);
myCallbacks.u.v1.receiveDragCallback =
        NewDataBrowserReceiveDragUPP (MyReceiveDragCallback);
myCallbacks.u.v1.addDragItemCallback =
        NewDataBrowserAddDragItemUPP (MyAddDragItemCallback);
myCallbacks.u.v1.itemHelpContentCallback =
        NewDataBrowserItemHelpContentUPP (MyItemHelpContentCallback);
myCallbacks.u.v1.getContextualMenuCallback =
        NewDataBrowserGetContextualMenuUPP (MyGetContextualMenuCallback);
myCallbacks.u.v1.selectContextualMenuCallback =
        NewDataBrowserSelectContextualMenuUPP (
                    MySelectContextualMenuCallback);
SetDataBrowserCallbacks (browser, &myCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks){
//TODO
};

/*NewDataBrowserItemDataUPP

Creates a universal procedure pointer to an item-data callback function.

DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-data callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemDataProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine){
//TODO
};


/*InitDataBrowserCallbacks

Initializes a data browser callback structure in preparation for adding your own callbacks to the structure.

OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCallbacks structure. Before calling the function InitDataBrowserCallbacks, set the version field of this structure to kDataBrowserLatestCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call this function, set the appropriate fields in the DataBrowserCallbacks structure to your callbacks. The DataBrowserCallbacks structure contains fields for the following:
DataBrowserItemDataProcPtr
DataBrowserItemCompareProcPtr
DataBrowserItemNotificationProcPtr or DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr
DataBrowserAcceptDragProcPtr
DataBrowserReceiveDragProcPtr
DataBrowserPostProcessDragProcPtr
DataBrowserGetContextualMenuProcPtr
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr

After you assign your callbacks to the appropriate field, call the function SetDataBrowserCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCustomCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks){
//TODO
};

/*IsDataBrowserItemSelected

Checks to see if a data item is selected.

Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item
);
Parameters
browser

A data browser.
item

The item ID of the item to check.
Return Value

A value of true if the item is a member of the current selection. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item){
//TODO
};

/*GetControlValue

Obtains a control’s current setting. (Deprecated. Use GetControl32BitValue instead.)

Not recommended

SInt16 GetControlValue (
   ControlRef theControl
);
Parameters
theControl

On input, a handle to a control. 
Return Value

The current setting of the control. 
Discussion

When you create a control, you specify an initial setting either in the control resource or in the value parameter of the function NewControl. You can change the setting by calling SetControlValue.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

SInt16 GetControlValue (
   ControlRef theControl){
//TODO
};

/*SetDataBrowserItemDataText

Specifies the text to draw.

OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData
);
Parameters
itemData

The item data reference for the item whose text you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataText. 
theData

The CFString object that contains the text you want to draw. You are responsible for releasing the CFString object.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataText from inside a data callback routine when the item being drawn is inside a column that has the kDataBrowserTextType display type or the kDataBrowserIconAndTextType display type. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData){
//TODO
};

/*AddDataBrowserItems

Adds one or more items to a data browser. 

OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container to which you want to add items. Adding one or more items to an existing container opens the container. If you a pass kDataBrowserNoItem, the items are added to the root container.
numItems

The number of items in the array pointed to by the items parameter.
items

A pointer to an array of item ID values for the items you want to add to the data browser. You supply item ID values based on your own identification scheme. If you pass NULL, each time you call AddDataBrowserItems the data browser generates item ID values starting at 1. Calling the function in this way clears whatever items are in the container. Because of this clearing behavior, passing NULL is not recommended unless your application uses a data browser to display a simple list that is populated only once with data.
preSortProperty

The property ID of the column whose sorting order matches the sorting order of the items array. A property ID is a four-character sequence that you assign to represent a column in list view. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order of your data. You’ll get the best performance from this function if you provide a sorting order. 
Return Value

A result code. If the item ID specified by the container parameter is not classified as a container, returns errDataBrowserItemNotAdded if you attempt to add subitems to it. See “Data Browser Result Codes”.
Discussion

Hierarchical lists are constructed in a top-down fashion. Your application must install all the top-level, or parent, item IDs in the data browser before it associates a list of item ID values as subitems. You can add items to a parent item only after the parent item is classified as a container. A container is an item for which the property kDataBrowserItemIsContainerProperty is set to true. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty){
//TODO
};

/*SetMenuBar

Sets the current menu list to a specified menu list.

void SetMenuBar (
   MenuBarHandle mbar
);
Parameters
mbar

A handle to a menu list that specifies the menus for a menu bar. You should specify a handle returned by GetMenuBar or GetNewMBar. 
Discussion

The SetMenuBar function copies the given menu list to the current menu list. As with GetMenuBar , SetMenuBar doesn’t copy the menu structures, just the menu list (which contains handles to the menu structures).

You can use SetMenuBar to restore a menu list that you previously saved using GetMenuBar or to set the current menu list to a menu list created from a nib file or from GetNewMBar. 

The SetMenuBar function sets the current menu list and calls InvalMenuBar so the menu bar can be updated the next time through the event loop; if you want to redraw the menu bar immediately, call the DrawMenuBar function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void SetMenuBar (
   MenuBarHandle mbar){
//TODO
};

/*RemoveDataBrowserItems

Removes one or more items from a data browser.

OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container from which you want to remove items. Pass kDataBrowserNoItem to remove items from the root container.
numItems

The number of items in the array pointed to by the items parameter. To remove all items pass 0 and also pass NULL in the items parameter.
items

A pointer to an array of item ID values for the items you want to remove from the data browser. You can delete an arbitrary list of items from a container. To remove all items, pass NULL, and also pass 0 in the numItems parameter. 
preSortProperty

The property ID of the column whose sorting order is the same as the sorting order of the items array. A property ID is a value that identifies a column independent of its position in a data browser. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order. You’ll get the best performance from this function if you provide a sorting order.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty){
//TODO
};

/*CreateMenuBarFromNib

Unarchives a menu bar from a nib file.

OSStatus CreateMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   Handle * outMenuBar
);
Parameters
inNibRef

A reference to the nib file that contains the menu bar you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the menu bar you want to unarchive. This is the name you supplied to the menu bar in the Instances pane of Interface Builder. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
outMenuBar

On output, points to a handle to the menu bar. 
Return Value

A result code. See Runtime Errors.
Discussion

You need to call the Menu Manager function SetMenuBarFromNib to make the unarchived menu bar available in your application. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus CreateMenuBarFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   Handle * outMenuBar){
//TODO
};


/*AESend

Sends the specified Apple event.

OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc
);
Parameters
theAppleEvent

A pointer to the Apple event to send. See AppleEvent.
reply

A pointer to a reply Apple event. On return, contains the reply Apple event from the server application, if you specified the kAEWaitReply flag in the sendMode parameter. If you specify the kAEQueueReply flag in the sendMode parameter, you receive the reply Apple event in your event queue. If you specify kAENoReply flag, the reply Apple event is a null descriptor (one with descriptor type typeNull). If you specify kAEWaitReply in the sendMode parameter, and if the function returns successfully (see function result below), your application is responsible for using the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter.
sendMode

Specifies various options for how the server application should handle the Apple event. To obtain a value for this parameter, you add together constants to set bits that specify the reply mode, the interaction level, the application switch mode, the reconnection mode, and the return receipt mode. For more information, see AESendMode.
sendPriority

See the Version Notes section below for important information. A value that specifies the priority for processing the Apple event. You can specify normal or high priority, using the constants described in AESendMode. See AESendPriority.
timeOutInTicks

If the reply mode specified in the sendMode parameter is kAEWaitReply, or if a return receipt is requested, this parameter specifies the length of time (in ticks) that the client application is willing to wait for the reply or return receipt from the server application before timing out. Most applications should use the kAEDefaultTimeout constant, which tells the Apple Event Manager to provide an appropriate timeout duration. If the value of this parameter is kNoTimeOut, the Apple event never times out. These constants are described in “Timeout Constants”.
idleProc

A universal procedure pointer to a function that handles events (such as update, operating-system, activate, and null events) that your application receives while waiting for a reply. Your idle function can also perform other tasks (such as displaying a wristwatch or spinning beach ball cursor) while waiting for a reply or a return receipt.

If your application specifies the kAEWaitReply flag in the sendMode parameter and you wish your application to get periodic time while waiting for the reply to return, you must provide an idle function. Otherwise, you can pass a value of NULL for this parameter. For more information on the idle function, see AEIdleProcPtr.
filterProc

A universal procedure pointer to a function that determines which incoming Apple events should be received while the handler waits for a reply or a return receipt. If your application doesn’t need to filter Apple events, you can pass a value of NULL for this parameter. If you do so, no application-oriented Apple events are processed while waiting. For more information on the filter function, see AEFilterProcPtr.
Return Value

A result code. See “Apple Event Manager Result Codes”. The AESend function returns noErr if the Event Manager successfully sends the Apple event—this value does not indicate that the Apple event was handled successfully. If the handler returns a result code other than noErr, and if the client is waiting for a reply, AESend returns the result code in the keyErrorNumber parameter of the reply Apple event. For a result code other than noErr, you should not call the AEDisposeDesc function to dispose of the descriptor returned in the reply parameter, because the descriptor is invalid.
Discussion

You typically create an Apple event to send with the AECreateAppleEvent function and add information to it with the functions described in “Adding Parameters and Attributes to an Apple Event”.

If the Apple Event Manager cannot find a handler for the Apple event in the server application’s dispatch table or in the system dispatch table, it returns the result code errAEEventNotHandled to the server application (as the result of the AEProcessAppleEvent function). If the client application is waiting for a reply, the Apple Event Manager also returns this result code to the client in the keyErrorNumber parameter of the reply event.

In addition to specifying the wait duration for replies, the timeOutInTicks parameter is used as a wait value when queuing events for other applications. The Apple Event Manager waits for the specified duration as it attempts to queue the event. If you specify kAEWaitReply and the target application quits or crashes after the event is queued but before the reply is returned, the Apple Event Manager returns a sessionClosedErr result code. 

In some situations, there are advantages to sending Apple events with the AESendMessage function. That function requires less overhead than AESend and it allows you to send Apple events while linking with just the Application Services framework, and not the entire Carbon framework (and window server), as required by AESend. For more information on sending Apple events, see “Sending an Apple Event” in Apple Events Programming Guide.
Version Notes

In Mac OS 9 and earlier, you use the sendMode parameter to specify how the server should handle the Apple event. AESendMode provides a complete description of the constants you use with this parameter. The sendPriority parameter is deprecated in Mac OS X and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEInteraction.h*/
OSErr AESend (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   AESendMode sendMode,
   AESendPriority sendPriority,
   long timeOutInTicks,
   AEIdleUPP idleProc,
   AEFilterUPP filterProc){
//TODO
};


/*GetApplicationTextEncoding

Returns the application text encoding for Resource Manager resources.

TextEncoding GetApplicationTextEncoding ();
Return Value

See the Text Encoding Conversion Manager documentation for a description of the TextEncoding data type.
Discussion

Your application needs to use the application text encoding when it creates a CFStringRef from text stored in Resource Manager resources. Typically the text uses a Mac encoding such as MacRoman or MacJapanese. 
Availability
Available in CarbonLib 1.2 and later.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
TextEncoding GetApplicationTextEncoding (){
//TODO
};

/*SetControlMaximum

Changes the maximum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMaximum instead.)

Not recommended

void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. 
newMaximum

The new maximum setting. 
Discussion

The SetControlMaximum function changes the maximum value of a control to the value specified by the newMaximum parameter and redraws its indicator or scroll box to reflect its new range.

When you set the maximum setting of a scroll bar equal to its minimum setting, the control definition function makes the scroll bar inactive. When you make the maximum setting exceed the minimum, the control definition function makes the scroll bar active again.

When you create a control, you specify an initial maximum setting either in the control resource or in the max parameter of the function NewControl. To determine a control’s current maximum setting, use the function GetControlMaximum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMaximum (
   ControlRef theControl,
   SInt16 newMaximum){
//TODO
};


/*SetControlMinimum

Changes the minimum setting of a control and redraws its indicator or scroll box accordingly. (Deprecated. Use SetControl32BitMinimum instead.)

Not recommended

void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum
);
Parameters
theControl

A handle to the control whose minimum setting you wish to change. For a description of this data type, see “ControlRef”.
newMinimum

The new minimum setting.
Discussion

The SetControlMinimum function changes the control’s minimum value to the value specified by the newMinimum parameter and redraws its indicator or scroll box to reflect its new range.

When you create a control, you specify an initial minimum setting either in the control resource or in the min parameter of the NewControl function. To obtain a control’s current minimum setting, use the function GetControlMinimum. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlMinimum (
   ControlRef theControl,
   SInt16 newMinimum){
//TODO
};


/*CountMenuItems

Obtains the number of menu items in a menu

UInt16 CountMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to count. 
Return Value

The number of menu items in the menu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
UInt16 CountMenuItems (
   MenuRef theMenu){
//TODO
};

/*AppendDialogItemList

Adds items to an existing dialog box while your program is running.

OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method
);
Parameters
dialog

A pointer to the dialog box to which the items in the item list resource specified in the ditlID parameter are to be appended. 
ditlID

The resource ID of the item list resource whose items are to be appended to the dialog box specified in the dialog parameter. 
method

The manner in which the new items are to be displayed in the dialog box.

If you use the overlayDITL constant, AppendDialogItemList superimposes the appended items over the dialog box by interpreting the coordinates of the display rectangles for the appended items (as specified in their item list resource) as local coordinates within the dialog box.

If you use the appendDITLRight constant, AppendDialogItemList appends the items to the right of the dialog box by positioning the display rectangles of the appended items relative to the upper-right coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

If you use the appendDITLBottom constant, AppendDialogItemList appends the items to the bottom of the dialog box by positioning the display rectangles of the appended items relative to the lower-left coordinate of the dialog box. The AppendDialogItemList function automatically expands the dialog box to accommodate the new dialog items.

You can append a list of items relative to an existing item by passing a negative number. The absolute value of this number is interpreted as the item in the dialog box relative to which the new items are to be positioned. For example, if you pass -2, the display rectangles of the appended items are offset relative to the upper-left corner of item number 2 in the dialog box.

Return Value

A result code. See “Dialog Manager Result Codes”.
Discussion

To be Appearance-compliant, your program should use the AppendDialogItemList function rather than the AppendDITL function. Unlike AppendDITL, the AppendDialogItemList function takes a 'DITL' resource ID instead of a handle as the parameter describing the dialog item list to be appended, and it properly appends entries from a dialog font table ( 'dftb') resource, if there is a 'dftb' resource with the same resource ID as the 'DITL' resource.

The AppendDialogItemList function adds the items in the item list resource specified in the parameter ditlID to the items of a dialog box. This is especially useful if several dialog boxes share a single item list resource, because you can use AppendDialogItemList to add items that are appropriate for individual dialog boxes. Your application can use the Resource Manager function GetResource to get a handle to the item list resource whose items you wish to add.

You typically create an invisible dialog box, call the AppendDialogItemList function, then make the dialog box visible by using the Window Manager function ShowWindow. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr AppendDialogItemList (
   DialogRef dialog,
   SInt16 ditlID,
   DITLMethod method){
//TODO
};


/*CreateWindowFromNib

Unarchives a window from a nib file.

OSStatus CreateWindowFromNib (
   IBNibRef inNibRef,
   CFStringRef inName,
   WindowRef *outWindow
);
Parameters
inNibRef

A reference to the nib file that contains the window you want to unarchive. You obtain this reference by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
inName

A CFStringRef that denotes the window you want to unarchive. This is the name you supplied to the window in the Instances pane of Interface Builder. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString. 
outWindow

On output, points to the window unarchived from the nib file.
Return Value

A result code. See Runtime Errors.
Discussion

You need to call the Window Manager function ShowWindow to make the unarchived window visible. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus CreateWindowFromNib (IBNibRef inNibRef,CFStringRef inName, WindowRef *outWindow){
//TODO
};


/*SetControl32BitMaximum

Changes the maximum setting of a control and, if appropriate, redraws it accordingly.

void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum
);
Parameters
theControl

A handle to the control whose maximum setting you wish to change. For a description of this data type, see “ControlRef”.
newMaximum

The new maximum setting of the control. In general, to avoid unpredictable behavior, do not set the maximum control value lower than the current minimum value. 
Discussion

Your application may use the SetControl32BitMaximum function to set a 32-bit value as the maximum setting for a control.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value. Instead, use the function GetControl32BitMaximum.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControl32BitMaximum (
   ControlRef theControl,
   SInt32 newMaximum){
//TODO
};

/*TXNGetDataEncoded

Copies the text in a specified range, and if necessary, translates the text to match your application’s preferred encoding. 

OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding
);
Parameters
iTXNObject

The text object that contains the data you want to copy.
iStartOffset

The absolute offset from which data copying should begin. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The absolute offset at which data copying should end. You can use the TXNGetSelection function to get the absolute offsets of the current selection.
oDataHandle

A pointer to a handle. On return, a handle to the requested data. TXNGetDataEncoded allocates the handle as necessary. Your application must dispose of the handle. If there is no text in the range specified, the returned handle is NULL, and the function returns noErr.
encoding

The type of data to be encoded. See Supported Data Types for a full description of possible values. You should specify either the kTXNTextData or kTXNUnicodeTextData constant. If the iEncoding parameter specifies an encoding different from that used to store the text data internally, the Conversion Manager translates the data to the specified type (text or Unicode). If the iEncoding parameter is not recognized, the data is returned in the current encoding. On systems that do not use ATSUI version 1.1 or later, the current encoding is the Mac OS encoding. Otherwise, the current encoding is Unicode. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNGetDataEncoded (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   Handle * oDataHandle,
   TXNDataType iEncoding){
//TODO
};

/*InstallEventHandler

Installs an event handler on a specified event target. 

OSStatus InstallEventHandler (
   EventTargetRef inTarget,
   EventHandlerUPP inHandler,
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   void * inUserData,
   EventHandlerRef * outRef
);
Parameters
inTarget

The event target to register your handler with. 
inHandler

A pointer to your event handler function. 
inNumTypes

The number of events you are registering for. 
inList

A pointer to an array of EventTypeSpec entries representing the events you are interested in. 
inUserData

The value you pass in this parameter is passed to your event handler function when it is called.
outRef

On return, an event handler reference, which you can use later to remove the handler. You can pass NULL if you don’t want the reference—when the target is disposed, the handler is disposed as well. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

After being installed, your handler will be called when an event you registered for is sent to the specified event target. Note that CarbonEvents.h defines several macros which you can use for particular event classes. These macros simply combine the appropriate GetxxxEventTarget call with InstallEventHandler.
InstallApplicationEventHandler
InstallWindowEventHandler
InstallControlEventHandler
InstallMenuEventHandler
InstallHIObjectEventHandler (in Mac OS X v10.2 and later)
HIViewInstallEventHandler (in Mac OS X v10.2 and later)

Be sure to remove the event handler when you no longer need it by callling RemoveEventHandler. Doing so is especially important if the handler calls code that may disappear. For example, if a plugin installs an event handler and is later removed without removing the handler, the system may attempt to call back to the now nonexistent plugin code.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus InstallEventHandler (
   EventTargetRef inTarget,
   EventHandlerUPP inHandler,
   UInt32 inNumTypes,
   const EventTypeSpec * inList,
   void * inUserData,
   EventHandlerRef * outRef){
//TODO
};



/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget (){
//TODO
};


/*GetEventParameter

Obtains a parameter from the specified event. 

OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData
);
Parameters
inEvent

The event to get the parameter from. 
inName

The symbolic name of the parameter (for example, kEventParamDirectObject). The Carbon Event Manager defines a number of constants defining possible parameters. 
inDesiredType

The desired type of the parameter (for example, typeWindowRef). The Carbon Event Manager automatically uses AppleEvent coercion handlers to convert the data in the event into the desired type, if possible. The Carbon Event Manager defines a number of constants to indicate possible parameter types. Pass typeWildCard to request that the data be returned in its original format. 
outActualType

The actual type of the parameter (can be NULL if you are not interested in receiving this information).
inBufferSize

The size of the output buffer. 
outActualSize

The actual size of the data, or NULL if you don’t want this information.
outData

The pointer to the buffer receiving the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Events often contain additional useful pieces of data, such as the location of a mouse-down event or the window in which an event occurred. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus GetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inDesiredType,
   EventParamType * outActualType,
   UInt32 inBufferSize,
   UInt32 * outActualSize,
   void * outData){
//TODO
};



/*CreateEvent

Creates an event.

OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent
);
Parameters
inAllocator

A reference to the desired memory allocator to use to allocate memory for the event. Pass NULL to use the default allocator. See the Base Services documentation for a description of the CFAllocatorRef data type.
inClassID

The event class of the event to create.
kind

The event kind of the event to create. 
when

The time the event occurred. Pass 0 to specify the current event time (as returned by the GetCurrentEventTime function). 
flags

The event attributes to set. Currently you can pass kEventAttributeNone or kEventAttributeUserEvent. 
outEvent

On return, a reference to the newly created event. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to create your own custom events or to simulate existing events. If you are creating custom events, you must make sure that the event signature (the combination of event class and event kind) does not conflict with any existing events. 
Declared In
CarbonEventsCore.h*/
OSStatus CreateEvent (
   CFAllocatorRef inAllocator,
   UInt32 inClassID,
   UInt32 kind,
   EventTime when,
   EventAttributes flags,
   EventRef * outEvent){
//TODO
};


/*GetCurrentEventTime

Returns the current time since last system startup, in seconds. 

EventTime GetCurrentEventTime ();
Return Value

EventTime. 
Discussion

Returns the current time since last system startup in seconds. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventTime GetCurrentEventTime (){
//TODO
};


/*SetEventParameter

Sets a parameter associated with a particular event. 

OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr
);
Parameters
inEvent

The event to set the data for. 
inName

The symbolic name of the parameter. 
inType

The symbolic type of the parameter. 
inSize

The size of the parameter data. 
inDataPtr

A pointer to the parameter data.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

When creating events, you may want to specify additional event-related information, such as the mouse location or the window in which the event occurred. To set these you call SetEventParameter, specifying the type and value for the desired parameter. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus SetEventParameter (
   EventRef inEvent,
   EventParamName inName,
   EventParamType inType,
   UInt32 inSize,
   const void * inDataPtr){
//TODO
};


/*ReleaseEvent

Releases, and possibly disposes of, the specified event.

void ReleaseEvent (
   EventRef inEvent
);
Parameters
inEvent

The event to release.
Discussion

This function decrements the reference count of an event. If the reference count reaches 0, the event is disposed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
void ReleaseEvent (
   EventRef inEvent){
//TODO
};

/*HITextViewGetTXNObject

Obtains the text object associated with an HITextView.

TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView)
);
Parameters
inTextView

The HITextView associated with the text object you want to retrieve.
Return Value

Returns the text object associated with the given view.
Discussion

You can supply the extracted text object as a parameter to many of the MLTE functions that take a text object as a parameter. However, not all MLTE functions that take a text object can operate on an MLTE object that comes from an HITextView. In general, you cannot use MLTE functions that may alter the geometry of the object or explicitly invoke drawing. If you do, the function returns the result code kTXNDisabledFunctionalityErr. See HITextViewCreate for a list of the functions that return an error if you pass a text object that comes from an HITextView.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacTextEditor.h*/
TXNObject HITextViewGetTXNObject(
   HIViewRef inTextView){
//TODO
};

/*TXNSetData

Replaces a range of data (text, graphics, and so forth).

OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data.
iDataType

The type of the replacement data. See Supported Data Types for a description of possible values. 
iDataPtr

A pointer to the data that will replace the data that is in the range specified by the iStartOffset and iEndOffset parameters.
iDataSize

The size of the data (in bytes) to which iDataPtr points.
iStartOffset

The beginning of the range of data to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. 
iEndOffset

The end of the range to replace. You can use the TXNGetSelection function to get the absolute offsets of the current selection. If you want to insert text, the ending and starting offsets should be the same value.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

If you have a text object that has word wrap disabled, and you want to avoid horizontal scrolling, you can try the following. After you call the function TXNSetData, call TXNSetSelection with the value of the ending offset set to what it was before you called TXNSetData. Then, call the function TXNShowSelection to scroll the text back into view.

Offsets in MLTE are always character offsets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetData (
   TXNObject iTXNObject,
   TXNDataType iDataType,
   const void * iDataPtr,
   ByteCount iDataSize,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
//TODO
};


/*TXNSetDataFromCFURLRef

Replaces a range of data with the contents of a file. (Deprecated in Mac OS X v10.4. Use TXNReadFromCFURL instead.)

Not recommended.

OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document in which you want to replace data. You can either call the function TXNCreateObject to allocate a text object or you can call the function HITextViewGetTXNObject to obtain the text object associated with an HITextView. 
iURL

A reference to the Core Foundation URL that specifies the file which contains the data you want to add to the object. 
iStartOffset

The starting position at which to insert the file into the document. If you want to replace the current selection, set the iStartOffset parameter to kTXNCurrentSelection. If you want to replace the entire document, set the iStartOffset parameter to 0. Offsets in MLTE are always character offsets.
iEndOffset

The ending position of the range being replaced by the file. You can use the TXNGetSelection function to get the absolute offsets of the current selection. Offsets in MLTE are always character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

Your application must open the file and set the iStartOffset parameter to the appropriate value before you call the TXNSetDataFromCFURLRef function. If you want to embed MLTE data within private data or other MLTE data, you must set the file position to the appropriate position.

In the (now deprecated) function TXNNewObject your could pass a file reference and MLTE supported functionality to revert back to the original file reference. When you call the function TXNSetDataFromURLRef, MLTE saves the CFURLRef. If you change the contents of the text object and then call the function TXNRevert, the document reverts to the contents specified by the saved CFURLRef.
Availability
Available in Mac OS X v10.3 and later.
Deprecated in Mac OS X v10.4.
Declared In
MacTextEditor.h*/
OSStatus TXNSetDataFromCFURLRef (
   TXNObject   iTXNObject,
   CFURLRef    iURL,
   TXNOffset   iStartOffset,
   TXNOffset   iEndOffset){
//TODO
};

/*TXNSetSelection

Specifies the selection range or the position of the insertion point. 

OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset
);
Parameters
iTXNObject

The text object that identifies the document for which you want to set the selection range or insertion point position. 
iStartOffset

The new starting offset. Offset values are character offsets. 
iEndOffset

The new ending offset. Offset values are character offsets.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

You can use the TXNSetSelection function to highlight an initial default value in a document, such as a data-entry form, or to position the insertion point at the start of the field where you want the user to enter a value. To position the insertion point, specify the same value for the iStartOffset and iEndOffset parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNSetSelection (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset){
//TODO
};

/*TXNShowSelection

Scrolls the current selection into view.

void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd
);
Parameters
iTXNObject

The text object for the current text area. 
iShowEnd

A Boolean value. If you set this to true, the end of the selection is scrolled into view. Otherwise, the beginning of the selection is scrolled into view. 
Discussion

You can use this to scroll text into view after you have called the TXNFind function and the matching text is not in the current view of the text object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacTextEditor.h*/
void TXNShowSelection (
   TXNObject iTXNObject,
   Boolean iShowEnd){
//TODO
};

/*SetWindowTitleWithCFString

Sets the window title to the contents of a Core Foundation string. 

OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
Parameters
inWindow

The window whose title is to be set.
inString

The title to set. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString){
//TODO
};


/*DisposeWindow

Removes a window.

void DisposeWindow (
   WindowRef window
);
Parameters
window

On input, the window to be closed.
Discussion

The DisposeWindow function reduces a window’s reference count by one. If the resulting reference count is zero, then DisposeWindow removes the window from the screen and deletes it from the window list, then releases the memory occupied by all structures associated with the window, including the window structure. 

Note that DisposeWindow assumes that any picture pointed to by the window structure field windowPic is data, not a resource, and it calls the QuickDraw function KillPicture to delete it. If your application uses a picture stored as a resource, you must release the resource or release the memory it occupies with the ReleaseResource function and set the windowPic field to NULL before closing the window.

Any pending update events for the window are discarded. If the window being removed is the frontmost window, the window behind it, if any, becomes the active window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DisposeWindow (WindowRef window){
//TODO
};


/*GetControlByID

Finds a control in a window by its unique ID.

OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl
);
Parameters
inWindow

The window to query.
inID

The control ID.
outControl

A pointer to a value of type ControlRef that, on output, is filled in with the control reference for the control specified by inID. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

As of Mac OS X v10.3, this function is superseded by the HIViewFindByID function, which is preferred over the GetControlByID function. The first parameter to the HIViewFindByID function is a view and not a window, so you can start the search at any point in the hierarchy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlByID (
   WindowRef inWindow,
   const ControlID * inID,
   ControlRef * outControl){
//TODO
};


/*GetWindowEventTarget

Obtains the event target reference for a specified window. 

EventTargetRef GetWindowEventTarget (
   WindowRef inWindow
);
Parameters
inWindow

The window to return the event target for. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install an event handler on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetWindowEventTarget (
   WindowRef inWindow){
//TODO
};


/*HIViewFindByID

Obtains a view by its ID. 

OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);
Parameters
inStartView

The view to start searching at. 
inID

The ID of the view you are looking for. 
outControl

Receives the control if found. 
Return Value

An operating system result code.
Discussion

Allows you to find a particular view by its ID. The HIViewID type used by this function is identical to the ControlID type used by the Control Manager.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl){
//TODO
};


/*HIViewGetRoot

Obtains the root view for a window. 

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);
Parameters
inWindow

The window to get the root for.
Return Value

The root view for the window, or NULL if an invalid window is passed.
Discussion

Note that the root view is not the same as the Control Manager root control.
Availability
Available in Mac OS X v10.2 and later.*/

HIViewRef HIViewGetRoot (
   WindowRef inWindow){
//TODO
};


/*SetWindowProxyFSSpec

Associates a file with a window.

Not recommended

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile
);
Parameters
window

A pointer to the window with which the specified file is to be associated. 
inFile

Set the file system specification structure to contain the data for the file to associate with the specified window. You can obtain an FSSpec structure by calling the function GetWindowProxyFSSpec. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application should call the SetWindowProxyFSSpec function to establish a proxy icon for a given window. The creator code and file type of the file associated with a window determine the proxy icon that is displayed for the window.

Because the SetWindowProxyFSSpec function won’t work without a saved file, you must establish the initial proxy icon for a new, untitled window with the function SetWindowProxyCreatorAndType , which requires that you know the file type and creator code for the file, but does not require that the file have been saved.

See also the function SetWindowProxyAlias. 
Special Considerations

With Mac OS 8.5, you must save and restore the current graphics port—by calling the QuickDraw functions GetPort and SetPort—around each call to the SetWindowProxyFSSpec function.
Version Notes

This function is available with Mac OS 8.5 and later.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use of file specifications is no longer recommended. An alternate API that uses FSRef types is preferred.
Declared In
MacWindows.h*/

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile){
//TODO
};




/*SendEventToEventTarget

Sends an event to the specified event target. 

OSStatus SendEventToEventTarget (
   EventRef inEvent,
   EventTargetRef inTarget
);
Parameters
inEvent

The event to send. 
inTarget

The target to send it to. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

If you are creating your own events, you can dispatch them immediately to an event target by calling this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus SendEventToEventTarget (
   EventRef inEvent,
   EventTargetRef inTarget){
//TODO
};


/*DisposeNibReference

Disposes of a nib reference.

void DisposeNibReference (
   IBNibRef inNibRef
);
Parameters
inNibRef

A nib reference you created by calling the function CreateNibReference or CreateNibReferenceWithCFBundle.
Return Value
Discussion

You should call the function DisposeNibReference immediately after you have finished unarchiving objects (windows, menus, menu bar, and so forth) from the nib file associated with the nib reference. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
void DisposeNibReference (
   IBNibRef inNibRef){
//TODO
};


/*SetControlData

Sets control-specific data.

OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData
);
Parameters
inControl

A handle to the control for which data is to be set. 
inPart

The part code of the control part for which data is to be set; see “Control Meta Part Code Constants”, “Control Part Code Constants”, and “Control State Part Code Constants”. Passing kControlEntireControl indicates that either the control has no parts or the data is not tied to any specific part of the control. 
inTagName

A constant representing the control-specific data you wish to set see the data tag constants in the “Control Manager Constants” section. 
inSize

The size (in bytes) of the data pointed to by the inData parameter. For variable-length control data, pass the value returned in the outMaxSize parameter of GetControlDataSize in the inSize parameter. The number of bytes must match the actual data size. 
inData

A pointer to a buffer allocated by your application. This buffer contains the data that you are sending to the control. After calling SetControlData, your application is responsible for disposing of this buffer, if necessary, as information is copied by control.
Return Value

A result code. See “Control Manager Result Codes”. The result code errDataNotSupported indicates that the inTagName parameter is not valid.
Discussion

The SetControlData function sets control-specific data represented by the value in the inTagName parameter to the data pointed to by the inData parameter. SetControlData could be used, for example, to switch a progress indicator from a determinate to indeterminate state. For a list of the control attributes that can be set, see the data tag constants in the “Control Manager Constants” section. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetControlData (
   ControlRef inControl,
   ControlPartCode inPart,
   ResType inTagName,
   Size inSize,
   const void * inData){
//TODO
};


/*SetWindowBounds

Sets a window’s size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the window’s size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The SetWindowBounds function sets a window’s size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the window’s content region or its structure region is more important in determining the window’s ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window—and, therefore, its spatial relationship to the rest of the screen—may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your application’s content is of greatest concern, then it is important to note that with some appearances some part of the window’s structure region or “frame” may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds){
//TODO
};



/*GetWindowBounds

Obtains the size and position of the bounding rectangle of the specified window region.

OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);
Parameters
window

The window whose bounds you want to obtain.
regionCode

A constant identifying the window region whose bounds you want to obtain. See “Window Region Constants” for a list of possible values.
globalBounds

A pointer to a structure of type Rect. On return, the rectangle contains the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Use the GetWindowBounds function to obtain the bounding rectangle for the specified window region for the specified window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds){
//TODO
};


/*HideWindow

Makes a window invisible.

void HideWindow (
   WindowRef window
);
Parameters
window

The window that is to be made invisible.
Discussion

The HideWindow function make a visible window invisible. If you hide the frontmost window, HideWindow removes the highlighting, brings the window behind it to the front, highlights the new frontmost window, and generates the appropriate activate events.

To reverse the actions of HideWindow, you must call both ShowWindow, to make the window visible, and SelectWindow, to select it. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void HideWindow (
   WindowRef window){
//TODO
};

/*HIViewGetBounds

Obtains the local bounds of a view. 

OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose local bounds are to be obtained.
outRect

The local bounds of the view.
Return Value

An operating system result code.
Discussion

The local bounds are the coordinate system that is completely view-relative. A view’s top left coordinate starts out at 0, 0. Most operations use local coordinates. Note, however, that the frame is used to move a view, not local coordinates.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect){
//TODO
};

/*RegisterEventHotKey

Registers a global hot key.

OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);
Parameters
inHotKeyCode

The virtual key code of the hot key you want to register. 
inHotKeyModifiers

The keyboard modifiers to look for. In Mac OS X v10.2 and earlier, if you do not specify a modifier key, this function returns paramErr. In Mac OS X v10.3 and later, passing 0 does not cause an error.
inHotKeyID

The application-specified hot key ID. You will receive this ID in the kEventHotKeyPressed event as the direct object parameter. 
inTarget

The target to notify when the hot key is pressed. 
inOptions

Currently unused. You must pass 0.
outRef

On return, a reference to the new hot key. You need this reference if you later wish to unregister it. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function registers a global hot key based on the virtual key code and modifiers you pass in. When the user enters the hot-key combination, a kEventHotKeyPressed event is sent to the target you specified. Only one such combination can exist for the current application (that is, multiple entities in the same application cannot register for the same hot key combination). The same hot key can, however, be registered by multiple applications. This means that multiple applications can potentially be notified when a particular hot key is requested. This might not necessarily be desirable, but it is how it works at present. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef){
//TODO
};


/*HIWindowSetProxyFSRef

Sets the proxy icon for a window using an FSRef to a file system object.

OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);
Parameters
inWindow

The window whose proxy icon is to be set.
inRef

The file system object the window represents.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function determines the window’s proxy icon by asking Icon Services for the icon for the object specified by inRef.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef){
//TODO
};

/*HIViewGetValue

Obtains the value of a view.

SInt32 HIViewGetValue (
HIViewRef inView
);
Parameters
inView

The view whose value is to be obtained.
Return Value

The view’s value.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetValue (
HIViewRef inView){};

/*HIViewSetHilite

Sets highlighting on a view.

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart
);
Parameters
inView

The view for which highlighting is to be set.
inHilitePart

The part of the view whose highlighting is to be set. For possible values, see “HIViewPartCode Constants”.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart){};

/*HIViewSetValue

Sets the value of a view.

OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue
);
Parameters
inView

The view whose value is to be set.
inValue

The value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue){};


/*HIViewSetMaximum

Sets a view’s maximum value.

OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum
);
Parameters
inView

The view whose maximum value is to be set.
inView

The maximum value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum){};



/*HIViewSetViewSize

Sets the view size of a view.

OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize
);
Parameters
inView

The view whose view size is to be set.
inViewSize

The view size that is to be set.
Return Value

An operating system result code.
Discussion

The view size is the size of the content to which a view’s display is proportioned. The view size is commonly used to set the proportional size of a scroll bar’s thumb indicator.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize){};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewSetMinimum (
HIViewRef inView){};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/

SInt32 HIViewGetMinimum (
HIViewRef inView){};


/*GetControlReference

Obtains a control’s current reference value. 

SInt32 GetControlReference (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose current reference value you wish to determine. 
Return Value

The current reference value for the specified control. 
Discussion

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. The reference value is stored in the contrlRfCon field of the control structure. You can use this field for any purpose, and you can use the function SetControlReference to change this value. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControlReference (
   ControlRef theControl){};



/*SetControlReference

Changes a control’s current reference value. 

void SetControlReference (
   ControlRef theControl,
   SInt32 data
);
Parameters
theControl

A handle to the control whose reference value you want to change. For a description of this data type, see “ControlRef”.
data

The new reference value for the control.
Discussion

The SetControlReference function sets the control’s reference value to the value you specify in the data parameter.

When you create a control, you specify an initial reference value, either in the control resource or in the refCon parameter of the function NewControl. Call GetControlReference to obtain the current value. You can use this value for any purpose.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlReference (
   ControlRef theControl,
   SInt32 data){};


/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewGet Maximum(
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetMaximum (
HIViewRef inView){};



/*HIViewGetSuperview

Returns a view’s parent view.

HIViewRef HIViewGetSuperview (
   HIViewRef inView
);
Parameters
inView

The view whose parent you are interested in getting.
Return Value

An HIView reference, or NULL if this view has no parent or is invalid.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetSuperview (
   HIViewRef inView){};


/*HIViewConvertRect

Converts a rectangle from one view to another. 

OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioRect

The rectangle to convert. 
inSourceView

The view whose coordinate system ioRect is starting out in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
inDestView

The view whose coordinate system ioRect should end up in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView){};


/*CallNextEventHandler

Calls the next handler in the handler chain.

OSStatus CallNextEventHandler (
   EventHandlerCallRef inCallRef,
   EventRef inEvent
);
Parameters
inCallRef

The event handler call reference passed into your event handler. 
inEvent

The event you want to pass to the next handler. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Calls through to the event handlers below you in the event handler stack of the target to which your handler is bound. You might use this to call through to the default toolbox handling in order to post-process the event. You can only call this routine from within an event handler. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus CallNextEventHandler (
   EventHandlerCallRef inCallRef,
   EventRef inEvent
){};

/*HIViewDrawCGImage

Draws a Core Graphics image appropriately for a view.

OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
);
Parameters
inContext

The context to draw in.
inBounds

The bounds to draw the image into.
inImage

The image to draw.
Return Value

An operating system status code.
Discussion

This function is similar to CGContextDrawImage, but it flips the context so that the image is drawn correctly. The origin of a view is at the top left corner, so you are really drawing upside-down. This call insulates you from that fact.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
){};


/*HIObjectRegisterSubclass

Registers an HIObject subclass.

OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
);
Parameters
inClassID

The class ID of your class. It should be unique. We recommend using Java-style com.company.foo naming conventions to avoid collisions.
inBaseClassID

The class ID of the class you derive from. Passing NULL indicates you want to subclass HIObject (the base class) directly.
inOptions

Any special options for your class. Currently you must pass 0 for this parameter.
inConstructProc

A universal procedure pointer to the event handler for this subclass. You pass the address of an event handler into this parameter. This handler is called directly, rather than through the normal event-dispatching mechanism. This means that the EventHandlerCallRef passed in will be NULL, and you cannot use it for calls like CallNextEventHandler. Other than that, you should return a result as usual. After your object is constructed, this procedure is installed as the event handler for the remaining events specified in the inEventList parameter. In Mac OS X v10.4 and later, passing NULL creates an “abstract class” that cannot be instantiated but can still be used as a base class for subclasses. If you pass NULL, HIObjectCreate on the class ID will return hiObjectClassIsAbstractErr.
inNumEvents

The number of events you are installing.
inEventList

The events your handler wants to receive. You must handle the kEventHIObjectConstruct and kEventHIObjectDestruct event. If these events are not specified, an error is returned.
inConstructData

Pass any info you want passed into your event handler here. For a C++ hierarchy based on HIObjects, you might actually pass a static method to construct your object here, and the base class event handler to do construction as your event handler.
outClassRef

The newly created class reference. Pass NULL if you don’t care.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X version 10.2 (v10.2) and later.*/
OSStatus HIObjectRegisterSubclass (
   CFStringRef inClassID,
   CFStringRef inBaseClassID,
   OptionBits inOptions,
   EventHandlerUPP inConstructProc,
   UInt32 inNumEvents,
   const EventTypeSpec* inEventList,
   void * inConstructData,
   HIObjectClassRef* outClassRef
){};



/*QuitApplicationEventLoop

Terminates the application event loop.

void QuitApplicationEventLoop ();
Discussion

This function is used to quit the RunApplicationEventLoop function. Typically, your application doesn’t need to call this. If your application has the Quit menu item tagged with the kHICommandQuit menu command ID, the toolbox will automatically call this for your application, automatically terminating your event loop. If your application wants to do pre-processing before the event loop exits, it should intercept either the kHICommandQuit menu command, or the kEventAppQuit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void QuitApplicationEventLoop (){};



/*ActiveNonFloatingWindow

Returns the currently active nonfloating window. 

WindowRef ActiveNonFloatingWindow ();
Return Value

A reference to the active window.
Discussion

Note that the active window is not necessarily the frontmost window, and it is not necessarily the window with user focus. Call GetUserFocusWindow to get the window that has user focus. For information on the GetUserFocusWindow function, see Carbon Event Manager Reference.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef ActiveNonFloatingWindow (){};


/*GetCurrentEventLoop

Obtains a reference to the current event loop.

EventLoopRef GetCurrentEventLoop ();
Return Value

An event loop reference. 
Discussion

This function returns the event loop for the current thread. If the current thread is a cooperative thread, the main event loop is returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventLoopRef GetCurrentEventLoop (){};

/*FrontNonFloatingWindow

Returns to the application the frontmost visible window that is not a floating window.

WindowRef FrontNonFloatingWindow ();
Return Value

The first visible window in the window list that is of a nonfloating class. See “Window Class Constants” for a description of window classes.
Discussion

Your application should call the FrontNonFloatingWindow function when you want to identify the frontmost visible window that is not a floating window. If you want to identify the frontmost visible window, whether floating or not, your application should call the function FrontWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef FrontNonFloatingWindow (){
//TODO
};



/*EnableControl

Enables a control.

OSStatus EnableControl (
   ControlRef inControl
);
Parameters
theControl

The control that is to be enabled. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus EnableControl (
   ControlRef inControl
){};

/*DeactivateControl

Deactivates a control and any latent embedded controls.

OSErr DeactivateControl (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to deactivate. If you pass a window’s root control, DeactivateControl deactivates all controls in that window. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The DeactivateControl function should be called instead of HiliteControl to deactivate a specified control and its latent embedded controls. 

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you activate a latent embedded control whose embedder is deactivated, the embedded control becomes latent until the embedder is activated. However, if you deactivate a latent embedded control, it will not be activated when its embedder is activated.

If a control definition function supports activate events, it will receive a kControlMsgActivate message before redrawing itself in its inactive state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr DeactivateControl (
   ControlRef inControl
){};



/*HIImageViewSetImage

Sets the image to display in an image view.

OSStatus HIImageViewSetImage (
   HIViewRef inView,
   CGImageRef inImage
);
Parameters
inView

The image view to affect.
inImage

The image to set.
Return Value

An operating system status code.
Discussion

The image passed in is retained by the view, so you may release the image after calling this function if you no longer need to reference it.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetImage (
   HIViewRef inView,
   CGImageRef inImage
){};

/*GetControlProperty

Obtains a piece of data that has been previously associated with a control.

OSStatus GetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
control

A handle to the control whose associated data you wish to obtain. 
propertyCreator

Your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The ‘macs' property signature is reserved for the system and should not be used. 
propertyTag

The application-defined code identifying the data.
bufferSize

A value specifying the size of the data to be obtained. If the size of the data is unknown, use the function GetControlPropertySize to get the data’s size. If the size specified in the bufferSize parameter does not match the actual size of the property, GetControlProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the actual size of the associated data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified control.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

You may use the function GetControlProperty to obtain a copy of data previously set by your application with the function SetControlProperty. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
){};


/*HIImageViewSetOpaque

Sets the opacity of an image view.

OSStatus HIImageViewSetOpaque (
   HIViewRef inView,
   Boolean inOpaque
);
Parameters
inView

The image view to set.
inOpaque

A Boolean whose value is true to make the image view opaque or false to disable the opacity setting.
Return Value

An operating system result code.
Discussion

When opacity is enabled, the image view can make certain optimizations for compositing and scrolling. The alpha-related image view APIs are rendered useless when opacity is enabled. An image view, when created, is opaque by default. You must pass false to this function in order to change the alpha, etc. or if your image does not fill the full bounds of the view.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetOpaque (
   HIViewRef inView,
   Boolean inOpaque
){};


/*HIViewNewTrackingArea

Creates a new tracking area for a view.

OSStatus HIViewNewTrackingArea (
HIViewRef inView,
HIShapeRef inShape,
HIViewTrackingAreaID inID,
HIViewTrackingAreaRef * outRef
);
Parameters
inView

The view for which a new tracking area is to be created.
inShape

The shape to use. Pass NULL to use the entire structure region of the view.
inID

An identifier for the new tracking area. You can specify any value you want, or zero if you don’t want associate an identifier with the new tracking area.
outRef

On return, a pointer to the reference to the new tracking area. A count is not maintained for this reference.
Return Value

An operating system result code.
Discussion

All tracking areas attached to a view are automatically disposed of when the view is disposed of, so you don’t need to dispose of a tracking area explicitly unless you want to remove it from a view before the view is disposed of.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewNewTrackingArea (
HIViewRef inView,
HIShapeRef inShape,
HIViewTrackingAreaID inID,
HIViewTrackingAreaRef * outRef
){};


/*SetControlProperty

Associates data with a control.

OSStatus SetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);
Parameters
control

A handle to the control with which you wish to associate data. For a description of this data type, see “ControlRef”.
propertyCreator

Your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and should not be used. 
propertyTag

A value identifying the data. You define the tag your application uses to identify the data.
propertySize

A value specifying the size of the data. 
propertyData

On input, a pointer to data of any type. Pass a pointer to a buffer containing the data to be associated; this buffer should be at least as large as the value specified in the propertySize parameter.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Your application may use the SetControlProperty function to associate any type of data with a control. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlProperty (
   ControlRef control,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
){};


/*SetControlDragTrackingEnabled

Sets the drag tracking state for a control. 

OSStatus SetControlDragTrackingEnabled (
   ControlRef inControl,
   Boolean inTracks
);
Parameters
inControl

The control for which the drag tracking state is to be set. 
inTracks

A Boolean whose value is true if you want the control to track and receive drags or false if want to disable support for drag and drop.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Call this function to enable a control’s support for drag and drop. If you don’t enable drag and drop support, the control won’t track drags.

Some controls don’t support drag and drop; these controls won’t track or receive drags even if you call this function with the inTracks parameter set to true.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlDragTrackingEnabled (
   ControlRef inControl,
   Boolean inTracks
){};

/*SetThemeCursor

Sets the cursor to a version of the specified cursor type that is consistent with the current theme.

OSStatus SetThemeCursor (
   ThemeCursor inCursor
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of possible values.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors. Because these are color cursors, they currently cannot be set from interrupt time. 

Your application should call the SetThemeCursor function to ensure that its cursors are theme-compliant, rather than the QuickDraw cursor utilities functions SetCursor or SetCCursor. If you wish an animatable cursor to be theme-compliant, call the function SetAnimatedThemeCursor. 
Special Considerations

Do not call SetThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemeCursor (
   ThemeCursor inCursor
){};

/*SetControlTitleWithCFString

Sets the title for a control to the specified Core Foundation string. 

OSStatus SetControlTitleWithCFString (
   ControlRef inControl,
   CFStringRef inString
);
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetControlTitleWithCFString (
   ControlRef inControl,
   CFStringRef inString
){};

int GetDragPasteboard(int a, int b ){};

/*SetAutomaticControlDragTrackingEnabledForWindow

Enables or disables automatic drag tracking for a window. 

OSStatus SetAutomaticControlDragTrackingEnabledForWindow (
   WindowRef inWindow,
   Boolean inTracks
);
Parameters
inWindow
inTracks

A Boolean whose value is true to enable the Control Manager’s automatic drag tracking support or false to disable automatic drag tracking support.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

By default, your application is responsible for installing drag tracking and receive handlers on a given window. The Control Manager, however, has support for automatically tracking and receiving drags over controls that you can enable by calling this function with the inTracks parameter set to true.

The Control Manager automatic drag tracking detects the control the drag is over and calls HandleControlDragTracking and HandleControlDragReceive appropriately. By default, the Control Manager’s automatic drag tracking is disabled.

Earlier versions of system software enabled automatic drag tracking by default, but as of Mac OS X v10.1.3, Mac OS 9.2, and CarbonLib 1.4, you must call this function to enable automatic drag tracking.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus SetAutomaticControlDragTrackingEnabledForWindow (
   WindowRef inWindow,
   Boolean inTracks
){};

/*RunAppModalLoopForWindow

Puts the window in an application-modal state. 

OSStatus RunAppModalLoopForWindow (
   WindowRef inWindow
);
Parameters
inWindow

The window you wish to behave modally. See the Window Manager documentation for a description of the WindowRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used as a replacement for the Dialog Manager function ModalDialog to drive a Carbon Event-based modal dialog. Once called, this function will not exit until QuitAppModalLoopForWindow is called. 

While in the modal state, the standard toolbox dispatcher processes events only for the modal window and any that are above it (that is, closer to the front). This feature allows you to create stacked modal dialogs, if desired. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RunAppModalLoopForWindow (
   WindowRef inWindow
){};


/*QuitAppModalLoopForWindow

Quits the application-modal state for a window. 

OSStatus QuitAppModalLoopForWindow (
   WindowRef inWindow
);
Parameters
inWindow

The window that is leaving the modal state. See the Window Manager documentation for a description of the WindowRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used to quit a currently running call to RunAppModalLoopForWindow (that is, it terminates a modal loop). Typically you call this from a handler you have installed on the modal window in question when the user clicks the appropriate button (Ok, Cancel, and so on). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus QuitAppModalLoopForWindow (
   WindowRef inWindow
){};

/*SetControlValue

Changes the current setting of a control and redraws it accordingly. (Deprecated. Use SetControl32BitValue instead.)

Not recommended

void SetControlValue (
   ControlRef theControl,
   SInt16 newValue
);
Parameters
theControl

A handle to the control whose current setting you wish to change. For a description of this data type, see “ControlRef”.
newValue

The new setting for the control. 
Discussion

For controls whose values the user can set, you can use the SetControlValue function to change the value to the specified value and redraw the control to reflect the new setting. For checkboxes and radio buttons, the value 1 fills the control with the appropriate mark, and 0 removes the mark. For Mac OS 8 checkboxes and radio buttons, 2 represents a mixed state; see “Checkbox Value Constants” and “Radio Button Value Constants”. For scroll bars, SetControlValue redraws the scroll box where appropriate. 

If the specified value is less than the minimum setting for the control, SetControlValue sets the control to its minimum setting; if the value is greater than the maximum setting, SetControlValue sets the control to its maximum.

When you create a control, you specify an initial setting either in the control resource or in the value parameter of the function NewControl. To determine a control’s current setting before changing it in response to a user’s click in that control, use the function GetControlValue. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void SetControlValue (
   ControlRef theControl,
   SInt16 newValue
){};


/*NewControlActionUPP

Creates a UPP for a control action callback function. 

ControlActionUPP NewControlActionUPP (
   ControlActionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your control action callback function. See ControlActionProcPtr for information about defining this function. 
Return Value

A UPP to your control action callback function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
ControlActionUPP NewControlActionUPP (
   ControlActionProcPtr userRoutine
){};

/*HIImageViewSetAlpha

Sets the alpha value for an image view.

OSStatus HIImageViewSetAlpha (
   HIViewRef inView,
   float inAlpha
);
Parameters
inView

The image view to affect.
inAlpha

The new alpha value. 
Return Value

An operating system result code.
Discussion

Allows you to set the alpha for an image, making it more or less transparent. An alpha of 1.0 is fully opaque, and an alpha of 0.0 is fully transparent. The default alpha for an image is 1.0. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetAlpha (
   HIViewRef inView,
   float inAlpha
){};

/*HIImageViewSetScaleToFit

Specifies whether an image should scale or clip to the view’s bounds.

OSStatus HIImageViewSetScaleToFit (
   HIViewRef inView,
   Boolean inScaleToFit
);
Parameters
inView

The image view.
inScaleToFit

A Boolean whose value is true to indicate that the image should be scaled to fit the view bounds or false to indicate that the image should clip to the view’s bounds.
Return Value

An operating system status code.
Discussion

Normally, an image view clips to the view’s bounds. Use this function to tell the image view to size the image to fit into the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetScaleToFit (
   HIViewRef inView,
   Boolean inScaleToFit
){};













/*IsWindowModified

Obtains the modification state of the specified window.

Boolean IsWindowModified (
   WindowRef window
);
Parameters
window

The window whose modification state is to be obtained.
Return Value

true if the content of the window has been modified; otherwise, false. Newly created windows start out with their modification state automatically set to true. 
Discussion

Your application can use the functions IsWindowModified and SetWindowModified instead of maintaining its own separate record of the modification state of the content of a window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean IsWindowModified (
   WindowRef window
){};


/*SelectWindow

Makes a window active.

void SelectWindow (
   WindowRef window
);
Parameters
window

The window that is to be made active.
Discussion

The SelectWindow function removes highlighting from the previously active window, brings the specified window to the front, highlights it, and generates the activate events to deactivate the previously active window and activate the specified window. If the specified window is already active, SelectWindow has no effect. Call SelectWindow when the user presses the mouse button while the cursor is in the content region of an inactive window.

Even if the specified window is invisible, SelectWindow brings the window to the front, activates the window, and deactivates the previously active window. Note that in this case, no active window is visible on the screen. If you do select an invisible window, be sure to call ShowWindow immediately to make the window visible (and accessible to the user). 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SelectWindow (
   WindowRef window
){};

/*TXNWriteRangeToCFURL

Writes a range of a text object to a file or to a special file bundle.

OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
);
Parameters
iTXNObject

The text object having a range that is to be written.
iStartOffset

The offset in iTXNObject at which to start writing data to iFileURL.
iEndOffset

The offset in iTXNObject at which to stop writing data to iFileURL. 
iDataOptions

A CFDictionaryRef that specifies options for writing out the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is written out using MLTE’s native format.
iDocumentAttributes

The document attributes that are to be embedded in the data stream. This parameter is only supported when writing out the data using one of the following formats: RTF and MLTE native format. Only the key / values defined in Document Attribute Keys are written out. The content of the dictionary is ignored for any other format. If the dictionary is NULL, no attributes are added to the data stream.
iFileURL

CFURLRef for an existing file or directory, whichever is appropriate for the file type. On return, iFileURL contains a copy of the data in the given range for the iTXNObject with the format and encoding specified by iDataOptions. 
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function writes a range of a text object to a file or a special file bundle (directory). It supports several document formats and encodings, which can be specified in the data options dictionary. Clients can specify additional document attributes when data is written out using a file format, such as RTF and native MLTE file format) that supports such attributes.
Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNWriteRangeToCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFDictionaryRef iDocumentAttributes,
   CFURLRef iFileURL
){};


/*SetKeyboardFocus

Sets the current keyboard focus to a specified control part for a window.

OSErr SetKeyboardFocus (
   WindowRef inWindow,
   ControlRef inControl,
   ControlFocusPart inPart
);
Parameters
inWindow

A pointer to the window containing the control that is to receive keyboard focus.
inControl

A handle to the control that is to receive keyboard focus. For a description of this data type, see 
inPart

A part code specifying the part of a control to receive keyboard focus. To clear a control’s keyboard focus, pass kControlFocusNoPart. For a description of this data type, see “ControlFocusPart”
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

A control with keyboard focus receives keyboard events. The Dialog Manager tests to see which control has keyboard focus when a keyboard event is processed and sends the event to that control. If no control has keyboard focus, the keyboard event is discarded. A control retains keyboard focus if it is hidden or deactivated.

Keyboard focus is only available if an embedding hierarchy has been established in the focusable control’s window. The default focusing order is based on the order in which controls are added to the window. For more details on embedding hierarchies, see EmbedControl.

The SetKeyboardFocus function sets the keyboard focus to a specified control part. The control to receive keyboard focus can be deactivated or invisible. This permits you to set the focus for an item in a dialog box before the dialog box is displayed. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr SetKeyboardFocus (
   WindowRef inWindow,
   ControlRef inControl,
   ControlFocusPart inPart
){};


/*DisableControl

Disables a control.

OSStatus DisableControl (
   ControlRef inControl
);
Parameters
inControl

The control to disable. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus DisableControl (
   ControlRef inControl
){};
/*TXNReadFromCFURL

Reads data from a CFURLRef into a TXNObject.

OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
);
Parameters
iTXNObject

The text object into which data read from iFileURL is to be added.
iStartOffset

The offset in iTXNObject at which to start placing data read from iFileURL.
iEndOffset

The offset in iTXNObject at which to stop placing data read from iFileURL. 
iDataOptions

Options for reading the data. See Data Option Key Value Constants for a list of the supported options. If this parameter is NULL, the data is read in using MLTE’s native format.
iFileURL

A CFURLRef to the data that is to be added to the text object specified by inTXNObject.
oDocumentAttributes

A value of type CFDictionary that, on return, contains the document attributes present in the data stream, if the file format supports them; otherwise this parameter is NULL. The native MLTE file format and RTF support embedded document attributes. See Document Attribute Keys for a list of supported attributes. If this parameter is NULL, no document attributes are written out.
Return Value

A result code. See “MLTE Result Codes”.
Discussion

This function reads data from a file or a special file bundle (directory) into a text object. Offset parameters are used to specify whether the new data is inserted, appended or replaces an existing data range in the text object. Clients can specify the document format and encoding of the data using the iDataOptions parameter. This functions also returns the document attributes present in the data stream. Document attributes are supported only for the rich text file formats supported by MLTE, which are RTF and MLTE native file format.

If the caller passes a pointer to a CFDictionaryRef, this function returns a reference to a dictionary of attributes, if there is one, that the caller is responsible for releasing. In all other cases, this function sets the reference to NULL. Here is some sample code:CFDictionaryRef oDocumentAttributes = NULL;
status = TXNReadFromCFRUL (....,&oDocumentAttributes);
if (oDocumentAttributes != NULL) ::CFReleases(oDocumentAttributes);

Availability
Available in Mac OS X v10.4 and later.
Declared In
MacTextEditor.h*/
OSStatus TXNReadFromCFURL (
   TXNObject iTXNObject,
   TXNOffset iStartOffset,
   TXNOffset iEndOffset,
   CFDictionaryRef iDataOptions,
   CFURLRef iFileURL,
   CFDictionaryRef * oDocumentAttributes
){};


/*HIWindowGetProxyFSRef

Obtains the FSRef used to determine the proxy icon for a window.

OSStatus HIWindowGetProxyFSRef (
   WindowRef inWindow,
   FSRef * outRef
);
Parameters
inWindow

The window whose proxy FSRef is to be obtained.
outRef

On exit, the FSRef for the window’s proxy icon.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

If the specified window’s proxy icon has been specified using HIWindowSetProxyFSRef or SetWindowProxyAlias, HIWindowGetProxyFSRef returns noErr and a valid FSRef for the window’s proxy icon. If the window has no proxy icon, or if the icon was specified by calling SetWindowProxyCreatorAndType or SetWindowProxyIcon, this function returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowGetProxyFSRef (
   WindowRef inWindow,
   FSRef * outRef
){};

/*SetPortWindowPort

Sets the current graphics port to the window’s port.

void SetPortWindowPort (
   WindowRef window
);
Parameters
window

The window whose graphics port is to be set.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetPortWindowPort (
   WindowRef window
){};

/*SizeWindow

Sets the size of a window. 

void SizeWindow (
   WindowRef window,
   short w,
   short h,
   Boolean fUpdate
);
Parameters
window

The window whose size is to be set.
w

On input, the new window width, in pixels. 
h

On input, the new window height, in pixels.
fUpdate

On input, a Boolean value that specifies whether any newly created area of the content region is to be accumulated into the update region (true) or not (false). You ordinarily pass a value of true to ensure that the area is updated. If you pass false, you’re responsible for maintaining the update region yourself. For a composited window, this parameter is ignored, and any views that intersect the newly exposed area of the window are automatically invalidated. For more information on adding rectangles to and removing rectangles from the update region, see InvalWindowRect and ValidWindowRect. 
Discussion

The SizeWindow function changes the size of the window’s graphics port rectangle to the dimensions specified by the w and h parameters, or does nothing if the values of w and h are both 0. The Window Manager redraws the window in the new size, recentering the title and truncating it if necessary.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SizeWindow (
   WindowRef window,
   short w,
   short h,
   Boolean fUpdate
){};

/*GetWindowPort

Gets the window’s color graphics port.

CGrafPtr GetWindowPort (
   WindowRef window
);
Parameters
window

The window whose color graphics port is to be obtained.
Return Value

A pointer to the window’s color graphics port. See the QuickDraw Manager documentation for a description of the CGrafPtr data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
CGrafPtr GetWindowPort (
   WindowRef window
){};


/*Button

Determines whether the user pressed the mouse button.

Not recommended

Boolean Button ();
Parameters
Return Value
Discussion

The Button function simply checks to see if the mouse button is down. If so, it returns true; otherwise, it returns false. To determine whether the mouse button is still down after a mouse-down event, use the StillDown function. To check to see if the mouse was released, use the WaitMouseUp function. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

You should avoid using any calls that poll the state of the mouse button, as they use excessive processor time and slow down the system. In most cases you are more interested in the transitions of the mouse button rather than its instantaneous state, so you should adopt Carbon events and take action on mouse-up and mouse-down events. If you need to track the mouse while down, consider using the Carbon Event Manager functions TrackMouseLocation or TrackMouseRegion. On Mac OS X v.10.2 and later, if you need to know the button state, you should call the GetCurrentEventButtonState function. 
Declared In
Events.h*/
Boolean Button (){};





/*GetDialogKeyboardFocusItem

Returns the item number of the editable text item in a dialog box that has keyboard focus.

SInt16 GetDialogKeyboardFocusItem (
   DialogRef dialog
);
Parameters
dialog

On input, a pointer to the dialog structure for the dialog box whose currently focused item you want to identify. 
Return Value

The number of the editable text item in a dialog box that currently has keyboard focus. 
Discussion

When the Appearance Manager is available and an embedding hierarchy is established, you should call the Control Manager function GetKeyboardFocus instead of GetDialogKeyboardFocusItem to return the item number of the item in a dialog box that has keyboard focus.

The GetDialogKeyboardFocusItem function accesses the edit field in the dialog structure. GetDialogKeyboardFocusItem should only be called when there is no embedding hierarchy in the dialog box. 
Version Notes

This function is not recommended with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
SInt16 GetDialogKeyboardFocusItem (
   DialogRef dialog
){};


/*GetDialogItem

Obtains a handle to a dialog item. 

void GetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType * itemType,
   Handle * item,
   Rect * box
);
Parameters
theDialog

A pointer to the dialog box to examine. 
itemNo

The position of the item in the dialog box’s item list resource use FindDialogItem to determine this value. 
itemType

A pointer to a short value. On return, the value identifies the item type of the dialog item requested in the itemNo parameter. 
item

A pointer to an item handle. On return the handle refers to the item specified in the itemNo parameter or, for application-defined draw functions, a pointer (coerced to a handle) to the draw function. 
box

A pointer to a rectangle. On return, the rectangle specifies the display rectangle (described in coordinates local to the dialog box), for the item specified in the itemNo parameter. 
Return Value
Discussion

The GetDialogItem function produces the item type, a handle to the item (or, for application-defined draw functions, the function pointer), and the display rectangle for a specified item in an item list resource. When a control hierarchy is present in the dialog box, GetDialogItem gets the appropriate information (for example, a text handle) from the controls. If you wish to get a control handle for a dialog item in an embedding hierarchy, see GetDialogItemAsControl.

You should call GetDialogItem before calling functions such as SetDialogItemText that need a handle to a dialog item. 

See also the function SetDialogItem. 
Version Notes

This function was changed with Appearance Manager 1.0 to support retrieving item information from controls.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h */

void GetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType * itemType,
   Handle * item,
   Rect * box
){};


/*GetDialogWindow


WindowRef GetDialogWindow (
   DialogRef dialog
);
Parameters
dialog
Return Value

See the QuickDraw Manager documentation for a description of the WindowRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
WindowRef GetDialogWindow (
   DialogRef dialog
){};

/*GetNewDialog

Creates a dialog box from a resource-based description. 

DialogRef GetNewDialog (
   SInt16 dialogID,
   void * dStorage,
   WindowRef behind
);
Parameters
dialogID

The resource ID of a dialog resource and an extended dialog resource. The resource IDs for both resources must be identical. If the dialog resource is missing, the Dialog Manager returns to your application without creating the requested dialog box. See ‘DLOG’ and ‘dlgx’ for a description of the dialog resource and the extended dialog resource, respectively. 
dStorage

A pointer to the memory for the dialog structure. If you set this parameter to null, the Dialog Manager automatically allocates a nonrelocatable block in your application heap. 
behind

A pointer to the window behind which the dialog box is to be placed on the desktop. Set this parameter to the window pointer (WindowPtr)-1L to bring the dialog box in front of all other windows. 
Return Value

Returns a pointer to a dialog box. If none was created, returns null. See the description of the DialogRef data type.
Discussion

The GetNewDialog function creates a dialog structure from information in a dialog resource and an extended dialog resource (if it exists) and returns a pointer to the dialog structure. You can use this pointer with Window Manager or QuickDraw functions to manipulate the dialog box. If the dialog resource specifies that the dialog box should be visible, the dialog box is displayed. If the dialog resource specifies that the dialog box should initially be invisible, use the Window Manager function ShowWindow to display the dialog box.

The dialog resource contains a resource ID that specifies both the dialog box’s item list ( 'DITL') resource and its dialog font table ( 'dftb') resource. After calling the Resource Manager to read these resources into memory (if they are not already in memory), GetNewDialog makes a copy of the 'DITL' resource and uses that copy; thus you may have several dialog boxes with identical items.

If you supply a dialog color table ( 'dctb') resource with the same resource ID as the dialog resource, GetNewDialog uses NewColorDialog and returns a pointer to a color graphics port. If no dialog color table resource is present, GetNewDialog uses NewDialog to return a pointer to a black-and-white graphics port, although system software draws the window frame using the system’s default colors. However, if the Appearance Manager is available and the kDialogFlagsUseThemeBackground feature bit of the extended dialog resource is set, then the 'dctb' resource is ignored and a color graphics port is created. 
Special Considerations

The GetNewDialog function doesn’t release the memory occupied by the resources. Therefore, your application should mark all resources used for a dialog box as purgeable or you should release the resources yourself.

If either the dialog resource or the item list resource can’t be read, the function result is null; your application should test to ensure that null is not returned before performing any more operations with the dialog box or its items.

As with all other windows, dialogs are created with an update region equal to their port rectangle. However, if the dialog’s 'DLOG' resource specifies that the dialog be made visible upon creation, the Dialog Manager draws the controls immediately and calls ValidRgn for each of their bounding rectangles. Other items are not drawn until the first update event for the dialog box is serviced.

If you need to display an alert box while your application is running in the background or is otherwise invisible to the user, call AEInteractWithUser
Version Notes

This function was changed with Appearance Manager 1.0 to support the extended dialog ('dlgx') resource and the dialog font table ('dftb') resource.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
DialogRef GetNewDialog (
   SInt16 dialogID,
   void * dStorage,
   WindowRef behind
){};
/*ModalDialog

Handles events while your application displays a modal or movable modal dialog box.

void ModalDialog (
   ModalFilterUPP modalFilter,
   DialogItemIndex * itemHit
);
Parameters
modalFilter

A universal procedure pointer for an event filter function. For modal dialog boxes, you can specify null if you want to use the standard event-handling function. For movable modal dialog boxes, you should specify your own event filter function. 
itemHit

A pointer to a short integer. After receiving an event involving an enabled item, ModalDialog produces a number representing the position of the selected item in the active dialog box’s item list resource. 
Return Value
Discussion

Call the ModalDialog function immediately after displaying a modal or movable modal dialog box. Your application should continue calling ModalDialog until the user dismisses your dialog.

For modal dialogs, the ModalDialog function repeatedly handles events until an event involving an enabled dialog box item—such as a click in a radio button, for example—occurs. If the event is a mouse-down event outside the content region of the dialog box, ModalDialog plays the system alert sound and gets the next event.

For movable modal dialogs, if the kDialogFlagsHandleMovableModal feature bit in the extended dialog resource is set, the ModalDialog function will handle all standard movable modal user interactions, such as dragging a dialog box by its title bar and allowing the user to switch into another application. However, a difference between the ModalDialog function’s behavior with movable modal and modal dialogs is that, with movable modal dialogs, your event filter function receives all events. If you want the Dialog Manager to assist you in handling events in movable modal dialog boxes, call GetStdFilterProc and StdFilterProc. 

For events inside the dialog box, ModalDialog passes the event to the event filter function pointed to in the modalFilter parameter before handling the event. When the event filter returns false, ModalDialog handles the event. If the event filter function handles the event, returning true, ModalDialog performs no more event handling.

If you set the modalFilter parameter to null, the standard event filter function is executed. The standard event filter function checks whether
the user has pressed the Enter or Return key and, if so, returns the item number of the default button 
the user has pressed the Escape key or Command-period and, if so, returns the item number of the Cancel button 
the cursor is over an editable text box, and optionally changes the cursor to an I-beam whenever this is the case 

If you set the modalFilter parameter to point to your own event filter function, that function can use the standard filter function to accomplish the above tasks. (To do so, you can call GetStdFilterProc, and dispatch the event to the standard filter function yourself, or you can call StdFilterProc, which obtains a ModalFilterUPP for the standard filter function and then dispatches the function.) Additionally, your own event filter function should also
handle update events, so that background processes can receive processor time, and return false 
return false for all events that your event filter function doesn’t handle 

You can also use your event filter function to test for and respond to keyboard equivalents and more complex events—for instance, the user dragging the cursor within an application-defined item. You can use your same event filter function in most or all of your alert and modal dialog boxes.

If the event filter function does not handle the event (returning false), ModalDialog handles the event as follows: 
In response to an activate or update event for the dialog box, ModalDialog activates or updates its window. 
If the user presses the mouse button while the cursor is in an editable text item, ModalDialog responds to the mouse activity as appropriate—that is, either by displaying an insertion point or by selecting text. If a key-down event occurs and there’s an editable text item, ModalDialog uses TextEdit to handle text entry and editing automatically. If the editable text item is enabled, ModalDialog produces its item number after it receives either the mouse-down or key-down event. Normally, editable text items are disabled, and you use the GetDialogItemText function to read the information in the items only after the user clicks the OK button. 
If the user presses the mouse button while the cursor is in a control, ModalDialog calls the Control Manager function TrackControl. If the user releases the mouse button while the cursor is in an enabled control, ModalDialog produces the control’s item number. Your application should respond appropriately—for example, by performing a command after the user clicks the OK button. 
If the user presses the mouse button while the cursor is in any other enabled item in the dialog box, ModalDialog produces the item’s number, and your application should respond appropriately. Generally, only controls should be enabled. If your application creates a control more complex than a button, radio button, or checkbox, your application must handle events inside that item with your event filter function. 
If the user presses the mouse button while the cursor is in a disabled item or in no item, or if any other event occurs, ModalDialog does nothing. 
Special Considerations

The ModalDialog function traps all events. This prevents your event loop from receiving activate events for your windows. Thus, if one of your application’s windows is active when you use GetNewDialog to create a modal dialog box, you must explicitly deactivate that window before displaying the modal dialog box.

When ModalDialog calls the Control Manager function TrackControl, it does not allow you to specify the action function necessary for anything more complex than a button, radio button, or checkbox. If you need a more complex control, you can create your own control, a picture, or an application-defined item that draws a control-like object in your dialog box. You must then provide an event filter function that appropriately handles events in that item. 
Version Notes

This function was changed with Appearance Manager 1.0 to handle events for movable modal dialogs.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void ModalDialog (
   ModalFilterUPP modalFilter,
   DialogItemIndex * itemHit
){};


/*HideDialogItem

Makes an item in a dialog box invisible. 

void HideDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
);
Parameters
theDialog

A pointer to a dialog structure. 
itemNo

A number corresponding to the position of an item in the dialog box’s item list resource. 
Return Value
Discussion

The HideDialogItem function hides the item specified by itemNo by giving it a display rectangle that’s off the screen. Specifically, if the left coordinate of the item’s display rectangle is less than 8192 (hexadecimal 0x2000), HideDialogItem adds 16,384 (hexadecimal 0x4000) to both the left and right coordinates of the rectangle. If the item is already hidden (that is, if the left coordinate is greater than 8192), HideDialogItem does nothing. To redisplay an item that’s been hidden by HideDialogItem, you can use the ShowDialogItem function. 
Special Considerations

If your application needs to display a number of dialog boxes that are similar except for one or two items, it’s generally easier to modify the common elements using the AppendDITL and ShortenDITL functions than to use the HideDialogItem and ShowDialogItem functions. 

If you hid an edit text item, the next visible edit text item will be highlighted.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/

void HideDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
){};

/*ShowDialogItem

Redisplays an item that has been hidden by HideDialogItem. 

void ShowDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
);
Parameters
theDialog

On input, a pointer to a dialog structure. 
itemNo

On input, a number corresponding to the position of an item in the dialog box’s item list resource. 
Return Value
Discussion

The ShowDialogItem function redisplays the item specified in the itemNo parameter by restoring the display rectangle the item had prior to HideDialogItem. If the left coordinate of the item’s display rectangle is greater than 8192, ShowDialogItem subtracts 16,384 from both the left and right coordinates of the rectangle. If the item is already visible (that is, if the left coordinate is less than 8192), ShowDialogItem does nothing.

The ShowDialogItem function adds the rectangle that contained the item to the update region so that it will be drawn. Note that if the item is a control you define in a control (' CNTL ') resource, the rectangle added to the update region is the rectangle defined in the control resource, not the display rectangle defined in the item list resource. If the item is an edit text item, ShowDialogItem activates it by calling the TextEdit function TEActivate. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void ShowDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo
){};


/*SetDialogItemText

Sets the text string for static text and editable text fields.

void SetDialogItemText (
   Handle item,
   ConstStr255Param text
);
Parameters
item

A handle to an editable text field or static text field. When embedding is on, you should pass in the control handle produced by a call to the function . If embedding is not on, pass in the handle produced by the “Alert Button Constants” function. 
text

A pointer to a string containing the text to display in the field. 
Discussion

The SetDialogItemText function sets and redraws text strings for static text and editable text fields. SetDialogItemText is useful for supplying a default text string—such as a document name—for an editable text field while your application is running. 
Version Notes

This function was changed with Appearance Manager 1.0 to support embedding hierarchies.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetDialogItemText (
   Handle item,
   ConstStr255Param text
){};

/*SelectDialogItemText

Selects and highlights text contained in an edit text item. 

void SelectDialogItemText (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   SInt16 strtSel,
   SInt16 endSel
);
Parameters
theDialog

On input, a pointer to a dialog structure. 
itemNo

On input, a number corresponding to the position of an edit text item in the dialog box’s item list resource. 
strtSel

On input, a number representing the position of the first character to begin selecting. 
endSel

On input, a number representing one position past the last character to be selected.
Discussion

If the item in the itemNo parameter is an edit text item that contains text, the SelectDialogItemText function sets the text selection range to extend from the character position specified in the strtSel parameter up to but not including the character position specified in the endSel parameter. The selection range is highlighted unless strtSel equals endSel, in which case a blinking vertical bar is displayed to indicate an insertion point at that position. If the edit text item doesn’t contain text, SelectDialogItemText displays the insertion point.

You can select the entire text by specifying the number 0 in the strtSel parameter and the number 32767 in the endSel parameter.

For example, if the user makes an unacceptable entry in the edit text item, your application can display an alert box reporting the problem and then use SelectDialogItemText to select the entire text so it can be replaced by a new entry. Without this function, the user would have to select the item before making the new entry. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Dialogs.h*/
void SelectDialogItemText (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   SInt16 strtSel,
   SInt16 endSel
){};


/*DisposeDialog

Dismisses a dialog box for which the Dialog Manager supplies memory and disposes of the dialog structure.

void DisposeDialog (
   DialogRef theDialog
);
Parameters
theDialog

A pointer to a dialog structure. 
Return Value
Discussion

The DisposeDialog function calls CloseDialog and, in addition, releases the memory occupied by the dialog box’s item list resource and the dialog structure. Call DisposeDialog when you’re done with a dialog box if you pass null in the dStorage parameter to GetNewDialog , NewColorDialog , or NewDialog. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void DisposeDialog (
   DialogRef theDialog
){};


/*GetDialogItemAsControl

Obtains the control handle for a dialog item in an embedding hierarchy. 

OSErr GetDialogItemAsControl (
   DialogRef inDialog,
   SInt16 inItemNo,
   ControlRef * outControl
);
Parameters
inDialog

A pointer to the dialog box to examine. 
inItemNo

The position of an item in the dialog box’s item list. 
outControl

A pointer to a control handle that, on return, refers to the embedded control. 
Return Value

A result code. See “Dialog Manager Result Codes”. The Control Manager result code errItemNotControl indicates that the specified dialog item is not a control.
Discussion

When an embedding hierarchy is established, GetDialogItemAsControl produces a handle to the embedded controls (except Help items). It should be used instead of GetDialogItem when an embedding hierarchy is established. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
OSErr GetDialogItemAsControl (
   DialogRef inDialog,
   SInt16 inItemNo,
   ControlRef * outControl
){};

/*GetControlBounds

Gets the bounds of a control.

Rect * GetControlBounds (
   ControlRef control,
   Rect * bounds
);
Parameters
control

The control to query. For a description of this data type, see “ControlRef”.
bounds

On input, a pointer to a QuickDraw rectangle. On output, the rectangle contains the bounds of the control in local coordinates.
Return Value

A pointer to the rectangle passed in the bounds parameter.
Discussion

When called in a composited window, this function returns the view’s frame, which is equivalent to calling HIViewGetFrame.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Rect * GetControlBounds (
   ControlRef control,
   Rect * bounds
){};

/*IsControlActive

Returns whether a control is active.

Boolean IsControlActive (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to be examined. 
Return Value

A Boolean whose value is true if the control is active; otherwise, false.
Discussion

If you wish to determine whether a control is active, you should call IsControlActive instead of testing the contrlHilite field of the control structure. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
Boolean IsControlActive (
   ControlRef inControl
){};

/*HideControl

Makes a control, and any latent embedded controls, invisible.

void HideControl (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to hide. For a description of this data type, see 
Discussion

The HideControl function makes the specified control invisible. This can be useful, for example, before adjusting a control’s size and location. It also adds the control’s rectangle to the window’s update region, so that anything else that was previously obscured by the control will reappear on the screen. If the control is already invisible, HideControl has no effect.

When hiding groups of controls, the state of an embedded control that is hidden or deactivated is preserved so that when the embedder control is shown or activated, the embedded control appears in the same state as the embedder. If the specified control has embedded controls, HideControl makes the embedded controls invisible as well.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you call HideControl on a latent embedded control, it would not be displayed the next time ShowControl was called on its embedder control.

To make the control visible again, call ShowControl.

You can also call SetControlVisibility to hide or show a control without causing it to redraw.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void HideControl (
   ControlRef theControl
){};


/*ShowControl

Makes an invisible control, and any latent embedded controls, visible.

void ShowControl (
   ControlRef theControl
);
Parameters
theControl

A handle to the control to make visible. For a description of this data type, see “ControlRef”.
Discussion

If the specified control is invisible, the ShowControl function makes it visible and immediately draws the control within its window without using your window’s standard updating mechanism. Note that the ShowControl function draws the control in its window, but the control can still be completely or partially obscured by overlapping windows or other objects. If the control is already visible, ShowControl has no effect.

When showing groups of controls, the state of an embedded control that is hidden or deactivated is preserved, so that when the embedder control is shown or activated, the embedded control appears in the same state as the embedder. If the specified control has embedded controls, ShowControl makes the embedded controls visible as well.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you call ShowControl on a latent embedded control whose embedder is disabled, the embedded control will remain invisible until its embedder control is enabled.

You can make a control invisible in several ways:
Specifying its invisibility in the control resource. 
Passing a value of false in the visible parameter of NewControl. 
Calling HideControl. 
Calling SetControlVisibility.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void ShowControl (
   ControlRef theControl
){};


/*AutoEmbedControl

Automatically embeds a control in the smallest appropriate embedder control.

OSErr AutoEmbedControl (
   ControlRef inControl,
   WindowRef inWindow
);
Parameters
inControl

A handle to the control to be embedded. 
inWindow

A pointer to the window in which to embed the control.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The Dialog Manager uses AutoEmbedControl to position dialog items in an embedding hierarchy based on both visual containment and the item list resource order. As items are added to a dialog box during creation, controls that already exist in the window will be containers for new controls if they both visually contain the control and have set the kControlSupportsEmbedding feature bit. For this reason, you should place the largest embedder controls at the beginning of the item list resource. As an example, the Dialog Manager would embed radio buttons in a tab control if they visually “fit” inside the tab control, as long as the tab control was already created in a'DITL' resource and established as an embedder control. For more information on embedding hierarchies in dialog and alert boxes, see the function EmbedControl. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr AutoEmbedControl (
   ControlRef inControl,
   WindowRef inWindow
){};


/*GetControlTitle

Obtains the title of a control. (Deprecated. Use CopyControlTitleAsCFString instead.)

Not recommended

void GetControlTitle (
   ControlRef theControl,
   Str255 title
);
Parameters
theControl

A handle to the control whose title you want to determine. 
title

On input, a pascal string. On output, the title of the control. 
Discussion

The GetControlTitle function produces the title of the specified control, which is stored in the contrlTitle field of the control structure.

When you create a control, you specify an initial title either in the control resource or in the title parameter of the function NewControl. You can change the title by using SetControlTitle. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

void GetControlTitle (
   ControlRef theControl,
   Str255 title
){};


/*SetPortDialogPort


void SetPortDialogPort (
   DialogRef dialog
);
Parameters
dialog
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetPortDialogPort (
   DialogRef dialog
){};

/*InvalWindowRect

Adds a rectangle to a window’s update region.

OSStatus InvalWindowRect (
   WindowRef window,
   const Rect * bounds
);
Parameters
window

The window containing the rectangle you want to be updated.
bounds

Set this structure to specify, in local coordinates, a rectangle to be added to the window’s update region. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The InvalWindowRect function informs the Window Manager that an area of a window should be redrawn.

See also the functions ValidWindowRect and InvalWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus InvalWindowRect (
   WindowRef window,
   const Rect * bounds
){};

/*ActivateControl

Activates a control and any latent embedded controls.

OSErr ActivateControl (
   ControlRef inControl
);
Parameters
inControl

A handle to the control to activate. If you pass a window’s root control, ActivateControl activates all controls in that window. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The ActivateControl function should be called instead of HiliteControl to activate a specified control and its latent embedded controls.

An embedded control is considered latent when it is deactivated or hidden due to its embedder control being deactivated or hidden. If you activate a latent embedded control whose embedder is deactivated, the embedded control becomes latent until the embedder is activated. However, if you deactivate a latent embedded control, it will not be activated when its embedder is activated.

If a control definition function supports activate events, it will receive a kControlMsgActivate message before redrawing itself in its active state. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr ActivateControl (
   ControlRef inControl
){};

/*MoveWindow

Moves a window on the desktop.

void MoveWindow (
   WindowRef window,
   short hGlobal,
   short vGlobal,
   Boolean front
);
Parameters
window

The window that is to be moved on the desktop.
hGlobal

On input, the new location, in global coordinates, of the left edge of the window’s port rectangle. 
vGlobal

On input, the new location, in global coordinates, of the top edge of the window’s port rectangle.
front

On input, a Boolean value specifying whether the window is to become the frontmost, active window. If the value of the front parameter is false, MoveWindow does not change its plane or status. If the value of the front parameter is true and the window isn’t active, MoveWindow makes it active by calling the SelectWindow function.
Discussion

The MoveWindow function moves the specified window to the location specified by the hGlobal and vGlobal parameters, without changing the window’s size. The upper-left corner of the window’s port rectangle is placed at the point (vGlobal, hGlobal). The local coordinates of the upper-left corner are unaffected.

Your application doesn’t normally call MoveWindow. When the user drags a window by dragging its title bar, you can call DragWindow which in turn calls MoveWindow when the user releases the mouse button. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void MoveWindow (
   WindowRef window,
   short hGlobal,
   short vGlobal,
   Boolean front
){};


/*SetDialogItem

Sets or changes information for a dialog item.

void SetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType itemType,
   Handle item,
   const Rect * box
);
Parameters
theDialog

A pointer to the dialog box containing the dialog item. 
itemNo

The position of the item in the dialog box’s item list resource use FindDialogItem to determine this value. 
itemType

A short value. Pass an item type constant identifying the dialog item specified in the itemNo parameter. When an embedding hierarchy is established, only the kItemDisableBit item type constant is honored. 
item

Either a handle to the dialog item specified in the itemNo parameter or, for a custom dialog item, a pointer (coerced to a handle) to an application-defined item drawing function. When an embedding hierarchy is established, the item parameter is ignored unless you pass a universal procedure pointer to an application-defined item draw function. 
box

A pointer to the display rectangle (in local coordinates) for the item specified in the itemNo parameter. If you set the control rectangle on an item when an embedding hierarchy is present, SetDialogItem will move and resize the item appropriately for you, on return. 
Return Value
Discussion

The SetDialogItem function sets the item specified by the itemNo parameter for the specified dialog box. If an embedding hierarchy exists, however, you cannot change the type or handle of an item, although application-defined item drawing functions can still be set.

See also the function GetDialogItem. 
Version Notes

This function was changed with Appearance Manager 1.0 to work with embedding hierarchies.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Dialogs.h*/
void SetDialogItem (
   DialogRef theDialog,
   DialogItemIndex itemNo,
   DialogItemType itemType,
   Handle item,
   const Rect * box
){};


/*BringToFront

Brings a window to the front.

void BringToFront (
   WindowRef window
);
Parameters
window

The window that is to be brought to the front.
Discussion

The BringToFront function puts the specified window at the beginning of the window list and redraws the window in front of all others on the screen. It does not change the window’s highlighting or make it active.

Your application does not ordinarily call BringToFront. The user interface guidelines specify that the frontmost window should be the active window. To bring a window to the front and make it active, call the function SelectWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void BringToFront (
   WindowRef window
){};


/*AdvanceKeyboardFocus

Advances the keyboard focus to the next focusable control in a window.

OSErr AdvanceKeyboardFocus (
   WindowRef inWindow
);
Parameters
inWindow

A pointer to the window for which to advance keyboard focus.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The AdvanceKeyboardFocus function skips over deactivated and hidden controls until it finds the next focusable control in the window. If it does not find a focusable item, it simply returns.

When AdvanceKeyboardFocus is called, the Control Manager calls your control definition function and passes kControlMsgFocus in its message parameter and kControlFocusNextPart in its param parameter. In response to this message, your control definition function should change keyboard focus to its next part, the entire control, or remove keyboard focus from the control, depending upon the circumstances. See ControlDefProcPtr for a discussion of possible responses to this message. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

OSErr AdvanceKeyboardFocus (
   WindowRef inWindow
){};


/*GetKeyboardFocus

Obtains a handle to the control with the current keyboard focus for a specified window.

OSErr GetKeyboardFocus (
   WindowRef inWindow,
   ControlRef * outControl
);
Parameters
inWindow

A pointer to the window for which to obtain keyboard focus.
outControl

On input, a pointer to a ControlHandle value. On return, the ControlHandle value is set to a handle to the control that currently has keyboard focus. Produces NULL if no control has focus. For a description of this data type, see 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The GetKeyboardFocus function returns the handle of the control with current keyboard focus within a specified window.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSErr GetKeyboardFocus (
   WindowRef inWindow,
   ControlRef * outControl
){};



/*TrackMouseLocation

Tracks the mouse, blocking your application when there is no activity.

OSStatus TrackMouseLocation (
   GrafPtr inPort,
   Point * outPt,
   MouseTrackingResult * outResult
);
Parameters
inPort

The grafport to consider for mouse coordinates. You can pass NULL for this parameter to indicate the current port. The mouse location is returned in terms of local coordinates of this port. See the QuickDraw Manager documentation for a description of the GrafPtr data type.
outPt

On exit, a pointer to the mouse location from the last mouse event that caused this function to exit. 
outResult

On exit, a pointer to a value representing what kind of event was received that cause the function to exit, such as kMouseTrackingMouseReleased. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Once entered, this function waits for certain mouse events (move, mouse down, mouse up). When one of these events occurs, the function returns and tells the caller what happened and where the mouse is currently located. While there is no activity, the current event loop is run, effectively blocking the current thread (save for any timers that fire). This helps to minimize CPU usage when there is nothing going on. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus TrackMouseLocation (
   GrafPtr inPort,
   Point * outPt,
   MouseTrackingResult * outResult
){};

/*HIViewConvertPoint

Converts a point’s coordinates from one view to another.

OSStatus HIViewConvertPoint (
   HIPoint* ioPoint,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioPoint

The point to convert. 
inSourceView

The view whose coordinate system ioPoint is starting out in. You can pass NULL to indicate that ioPoint is a window-relative point.
inDestView

The view whose coordinate system ioPoint should end up in. You can pass NULL to indicate that ioPoint is a window-relative point.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewConvertPoint (
   HIPoint* ioPoint,
   HIViewRef inSourceView,
   HIViewRef inDestView
){};

/*BeginCGContextForApplicationDockTile

Allocates a context reference (CGContextRef). 

CGContextRef BeginCGContextForApplicationDockTile ();
Return Value

A reference to a context reference. See the Quartz 2D documentation for a description of the CGContextRef data type.
Discussion

You can use this context to draw into your application Dock tile with Quartz. You must call the function EndCGContextForApplicationDockTile to lock your application tile in the Dock. Do not call the function CGEndContext for this purpose as it is not designed to work with a context reference for an application Dock tile. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
CGContextRef BeginCGContextForApplicationDockTile (){};


/*EndCGContextForApplicationDockTile

Disposes of the context reference (CGContextRef ) for your application tile and frees the lock on the application Dock tile.

void EndCGContextForApplicationDockTile (
   CGContextRef inContext
);
Parameters
inContext

A reference to the context you want to end. The context is invalid after this call and should no longer be used. 
Discussion

You must call the function EndCGContextForApplicationDockTile when you use the function BeginCGContextForApplicationDockTile. Do not use the function CGEndContext as the context associated with the application’s Dock tile won’t be disposed of and the lock on the application Dock tile won’t be freed. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/
void EndCGContextForApplicationDockTile (
   CGContextRef inContext
){};


/*ReleaseMenu

Decrements the retain count of a menu.

OSStatus ReleaseMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose retain count to decrement. If the retain count falls to zero, the menu is destroyed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The reference that you pass in the theMenu parameter is not valid after DisposeMenu returns. This function is identical to DisposeMenu.
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRelease instead of ReleaseMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ReleaseMenu (
   MenuRef inMenu
){};

/*CreateNewMenu

Creates a new, untitled, empty menu.

OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);
Parameters
inMenuID

The menu ID to use for the new menu. Note that zero is a valid ID in Carbon. 
inMenuAttributes

The menu attributes to use for the new menu. See “Menu Attribute Constants” for a list of possible values. 
outMenuRef

On exit, contains the new menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Unless you need to create new menus on-the-fly, you should not use functions like CreateNewMenu that create menus programmatically. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them.

CreateNewMenu is preferred over NewMenu because it allows you to specify the menu's attributes and it does not require you to specify a Str255-based menu title. To set the menu title, you should use SetMenuTitleWithCFString.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
){};


/*RetainMenu

Increments the reference count of a menu.

OSStatus RetainMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose reference count you want to increment. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

RetainMenu does not create a new menu. It simply adds one to the reference count. 
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRetain instead of RetainMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus RetainMenu (
   MenuRef inMenu
){};


/*SetMenuItemIconHandle

Sets a menu item’s icon.

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
);
Parameters
inMenu

The menu that contains the menu item for which you wish to set an icon. 
inItem

The menu index of the item. 
inIconType

Pass a value representing the type of icon ('ICON', 'cicn', 'SICN', icon suite, or IconRef) you wish to attach; see “Menu Item Icon Type Constants” for descriptions of possible values. 
inIconHandle

Pass a handle to the icon you wish to attach to a menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The SetMenuItemIconHandle function sets the icon of a menu item with an icon handle instead of a resource ID. SetMenuItemIconHandle allows you to set icons of type 'ICON', 'cicn', 'SICN', IconRef, CGImageRef, as well as icon suites. To set resource-based icons for a menu item, call SetItemIcon. 

With the exception of types IconRef and CGImageRef,disposing of the menu will not dispose of the icon handles set by this function. The Menu Manager retains IconRef, CGImageRef icons and releases them when the menu is disposed or the menu item is removed. For all other icon types, your application should dispose of the icons when you dispose of the menu, to prevent memory leaks.

See also the function GetMenuItemIconHandle. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
){};

/*SetMenuItemProperty

Associates data with a menu item.

OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);
Parameters
menu

The menu containing the item with which you wish to associate data. 
item

The index number of the menu item or 0 if the data is to be associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code that identifies the property to set. You define the tag your application uses to identify the data; this code is not to be confused with the file type for the data, but may coincide if you wish.
propertySize

The size of the data. 
propertyData

A pointer to the data. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the SetMenuItemProperty function to associate arbitrary data, tagged with an identifying code, with a menu item.

See also the GetMenuItemProperty and RemoveMenuItemProperty functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
){};


/*GetIndMenuItemWithCommandID

Finds a menu item with a specified command ID.

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
);
Parameters
inMenu

The menu in which to begin searching for items with the specified command ID. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID for which to search. 
inItemIndex

The 1-based index of the menu item to retrieve. In CarbonLib 1.0.x, this parameter must be 1. In CarbonLib 1.1 and Mac OS X 1.0, this parameter may vary from 1 to the number of menu items with the specified command ID. 
outMenu

On exit, the menu containing the menu item with the specified command ID.
outIndex

On exit, the item index of the menu item with the specified command ID. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

This API searches the specified menu and its submenus for the n'th menu item with the specified command ID. You often want to use this function in conjunction with CountMenuItemsWithCommandID.
Version Notes

In CarbonLib 1.1 and earlier, only the first menu item will be returned. In CarbonLib 1.2 and Mac OS X v10.0 and later, this API will iterate over all menu items with the specified command ID and return the itemIndex’th one. 

In Mac OS X v10.0 and CarbonLib 1.0 through 1.4, this function searches only top-level menus (that is, those that are visible in the menu bar) and submenus of top-level menus. It does not search hierarchical menus that are in the menu bar but are not submenus of a top-level menu. For example, it does not search menus that are inserted for use in a popup menu. In Mac OS X v10.1 and later, and CarbonLib 1.5 and later, this function also searches hierarchical menus. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
){};



/*GetMenuItemProperty

Obtains a piece of data that has been previously associated with a menu item.

OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
menu

The menu containing the item to be examined for associated data. 
item

The index number of the menu item or 0 if the data is associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature (also called a creator), as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code. Pass the application-defined code identifying the data.
bufferSize

The size of the data to be obtained. If this is unknown, use the function GetMenuItemPropertySize to get the data’s size. If the size specified in the bufferSize parameter does not match the actual size of the property, GetMenuItemProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the actual size of the associated data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the function GetMenuItemProperty to obtain a copy of data previously set with the function SetMenuItemProperty.

See also the RemoveMenuItemProperty function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
){};


/*RestoreApplicationDockTileImage

Restores your application Dock icon to the application icon. 

OSStatus RestoreApplicationDockTileImage ();
Return Value

A result code.
Discussion

If you’ve called the functions SetApplicationDockTileImage or OverlayApplicationDockTileImage, you can use the function RestoreApplicationDockTileImage to restore the Dock icon to the original application icon. 
Availability
Not available in Carbon.
Available in Mac OS X 10.0 and later.
Declared In
MacApplication.h*/

OSStatus RestoreApplicationDockTileImage (){};


/*SetMenuCommandMark

Locates the menu item with a specified command ID and sets its mark character.

OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be modified. If more than one item has this command ID, only the first will be modified. 
inMark

The new mark character. While this is a Unicode character, only the low byte is currently used as the mark character, and it is interpreted using the application text encoding. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If you have access to the menu item index, in most cases you should use SetItemMark instead, as that function is faster and requires no searching.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
){};


/*AddEventTypesToHandler

Adds events to an installed handler.

OSStatus AddEventTypesToHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
);
Parameters
inHandlerRef

The event handler to add events to. 
inNumTypes

The number of events to add. 
inList

A pointer to an array of EventTypeSpec structures. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to dynamically change which events you want your handler to respond to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus AddEventTypesToHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
){};


/*RemoveEventTypesFromHandler

Removes events from an installed event handler.

OSStatus RemoveEventTypesFromHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
);
Parameters
inHandlerRef

The event handler to remove the events from. 
inNumTypes

The number of events to remove. 
inList

A pointer to an array of EventTypeSpec structures. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function dynamically change which events you want your handler to respond to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/

OSStatus RemoveEventTypesFromHandler (
   EventHandlerRef inHandlerRef,
   UInt32 inNumTypes,
   const EventTypeSpec * inList
){};


/*GetEventMonitorTarget

Obtains an event monitor target.

EventTargetRef GetEventMonitorTarget (
   void
);
Return Value

An event monitor target. 
Discussion

The event monitor target is a special event target used to monitor user input events across all processes. When an event handler is installed on the event monitor target, the Carbon Event Manager examines the EventTypeSpec for user input event types, such as mouse-down, mouse-up, and key-down. It then requests that the WindowServer make copies of any of these events that are sent to any process, and delivers them to the current process. These events are queued into the main thread’s event queue and are sent directly to the event handlers installed on the event monitor target during normal event dispatching. Monitored events are not sent through the normal event dispatching path for the current process. Instead, they pass through the event dispatcher target and are sent directly to the event monitor target.Handlers installed on the event monitor target receive events only when the current application is inactive. When the current application is active, all events flow through the event dispatcher target, and no events are sent to the event monitor target.Currently, the event monitor supports the following event kinds: kEventRawKeyDown, kEventRawKeyUp, kEventRawKeyRepeat, kEventRawKeyModifiersChange, kEventMouseDown, kEventMouseUp, kEventMouseMoved, kEventMouseDragged, kEventMouseWheelMoved, kEventTabletPoint, and kEventTabletProximity.To prevent keyboard events from being passed to other applications, Carbon and Cocoa password-edit-text controls enable a secure input mode while the focus is on the control. Their password-edit-text controls prevent the monitoring event target from being used to capture password keystrokes.For added security, GetEventMonitorTarget requires that “Enable access for assistive devices” be checked in the Universal Access preference pane in order to monitor kEventRawKeyDown, kEventRawKeyUp, and kEventRawKeyRepeat events. If this control is not checked, you can still install handlers for these events on the event monitor target, but no events of these types will be sent to your handler. Administrator privileges are required to enable this feature. You can determine whether this control is checked using the AXAPIEnabled function in AXUIElement.h.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetEventMonitorTarget (
   void
){};

/*SetAnimatedThemeCursor

Animates a version of the specified cursor type that is consistent with the current theme.

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of the possible values. Note that only cursors designated as able to be animated should be used for this function. If you specify an unanimatable cursor type, SetAnimatedThemeCursor returns the error themeBadCursorIndexErr (–30565).
inAnimationStep

An unsigned 32-bit value. Pass a value specifying the current animation step of the cursor. To animate the cursor, increment the value by 1 with each call to SetAnimatedThemeCursor.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors.

Your application should call the SetAnimatedThemeCursor function to ensure that its animated cursors are theme-compliant, rather than using any QuickDraw cursor utilities functions such as SetCursor, SetCCursor, SpinCursor, or RotateCursor. If you wish a non-animated cursor to be theme-compliant, call the function SetThemeCursor.

Because these are color cursors, they currently cannot be set from interrupt time. Therefore, if you support animated cursors that are changed at interrupt time you should continue to use your own cursors for now. 
Special Considerations

Do not call SetAnimatedThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
){};


/*CreateNibReferenceWithCFBundle

Creates a reference to a nib file in the specified bundle. 

OSStatus CreateNibReferenceWithCFBundle (
   CFBundleRef inBundle,
   CFStringRef inNibName,
   IBNibRef * outNibRef
);
Parameters
inBundle

A CFBundleRef to your application’s bundle. See the Bundle Services documentation for a description of the CFBundleRef data type. You can get this reference by calling the appropriate Core Foundation Bundle Services functions.
inNibName

A CFStringRef that represents the name of a nib file you created for your application, but without the nib extension. See the Base Services documentation for a description of the CFStringRef data type. You can use the Core Foundation function CFSTR to convert a string to a CFString.
outNibRef

On output, points to a nib reference. You pass the nib reference to Interface Builder Services functions that unarchive objects from a nib file.
Return Value

A result code. See Runtime Errors.
Discussion

Use this function if the nib file is located in a framework or other bundle that is not the current bundle. Use the function CreateNibReference if the nib file is located in the current bundle. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
IBCarbonRuntime.h*/
OSStatus CreateNibReferenceWithCFBundle (
   CFBundleRef inBundle,
   CFStringRef inNibName,
   IBNibRef * outNibRef
){};

/*PostEventToQueue

Adds an event to the specified event queue.

OSStatus PostEventToQueue (
   EventQueueRef inQueue,
   EventRef inEvent,
   EventPriority inPriority
);
Parameters
inQueue

The event queue to post the event onto. 
inEvent

The event to post. 
inPriority

The priority of the event. See “Event Priority Constants” for a list of possible constants to pass. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Posts an event to the queue specified and increments its retain count. This automatically wakes up the event loop of the thread the queue belongs to. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
OSStatus PostEventToQueue (
   EventQueueRef inQueue,
   EventRef inEvent,
   EventPriority inPriority
){};


/*GetMainEventQueue

Obtains the main event queue. 

EventQueueRef GetMainEventQueue ();
Return Value

An event queue reference. 
Discussion

The main queue is the event queue for the main application thread. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEventsCore.h*/
EventQueueRef GetMainEventQueue (){};



/*HIViewSetFrame

Sets the frame of a view. 

OSStatus HIViewSetFrame (
   HIViewRef inView,
   const HIRect* inRect
);
Parameters
inView

The view whose frame is to be set.
inRect

The new frame to set.
Return Value

An operating system result code.
Discussion

This function effectively moves the view within its parent. It also marks the view (and anything that was exposed behind it) to be redrawn. 
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetFrame (
   HIViewRef inView,
   const HIRect* inRect
){};

/*HIObjectCreate

Creates an object derived from HIObject.

OSStatus HIObjectCreate (
   CFStringRef inClassID,
   EventRef inConstructData,
   HIObjectRef* outObject
);
Parameters
inClassID

The class ID of the class of object you want to instantiate.
inConstructData

If your class (or any class you derive from) accepts creation parameters, you need to pass an event into this parameter. The class must be kEventClassHIObject, and the kind should be kEventHIObjectInitialize. Any other parameters should be added as necessary. Specific subclasses of HIObject which require initialization parameters will specify those parameters in the appropriate headers.
outObject

The instance of the object you create.
Return Value

A result code. See “HIObject Result Codes”.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIObjectCreate (
   CFStringRef inClassID,
   EventRef inConstructData,
   HIObjectRef* outObject
){};





/*IsControlHilited

Indicates whether or not the control is highlighted.

Boolean IsControlHilited (
   ControlRef control
);
Parameters
control

The control that is to be queried. For a description of this data type, see 
Return Value

A Boolean whose value is true if the control is highlighted; otherwise, false.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/

Boolean IsControlHilited (
   ControlRef control
){};



/*HiewMoveBy

Move a view by the specified distance relative to its current location. 

OSStatus HIViewMoveBy (
   HIViewRef inView,
   float inDX,
   float inDY
);
Parameters
inView

The view you want to move.
inDX

The horizontal distance to move the view. Negative values move the view to the left, positive values to the right.
inDY

The vertical distance to move the view. Negative values move the view up, positive values down.
Return Value

An operating system result code.
Discussion

This function affects the view’s frame but does not affect the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewMoveBy (
   HIViewRef inView,
   float inDX,
   float inDY
){};
/*HIViewGetFirstSubview

Returns the first subview of a parent view. 

HIViewRef HIViewGetFirstSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the first subview of a container. The first subview is the topmost subview in z-order. 
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetFirstSubview (
   HIViewRef inView
){};


/*HIViewGetNextView

Returns the view behind the specified view.

HIViewRef HIViewGetNextView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view behind it or is invalid.
Discussion

Returns the view after the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetNextView (
   HIViewRef inView
){};


/*HIObjectDynamicCast

Obtains the instance data for a specific class of an HIObject. 

void* HIObjectDynamicCast (
   HIObjectRef inObject,
   CFStringRef inClassID
);
Parameters
inObject

The object whose class ID you want to check.
inClassID

The class ID to get the instance data for.
Return Value

A void * result containing the instance data for the object, or NULL if the object is not an instance of the class.
Discussion

The instance data returned is the same instance data the class’s construction event handler returns in the instance data parameter. This is stored off with the class reference so that it can be fetched later for use by this function. It allows your subclass to easily get at the data it created, if your subclass needs that data outside of an event handler. (Inside an event handler, your subclass can get at its instance data via the userData parameter to the event handler.) 
Availability
Available in Mac OS X v10.2 and later.*/

void* HIObjectDynamicCast (
   HIObjectRef inObject,
   CFStringRef inClassID
){};

/*GetControlID

Gets the control ID for a control.

OSStatus GetControlID (
   ControlRef inControl,
   ControlID * outID
);
Parameters
inControl

The control to query. For a description of this data type, see “ControlRef”.
outID

A pointer to a value of type ControlID that, on return, contains the control ID of the control specified by inControl.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
OSStatus GetControlID (
   ControlRef inControl,
   ControlID * outID
){};


/*DisposeControl

Decrements a control’s reference count and destroys it if the reference count becomes 0.

void DisposeControl (
   ControlRef theControl
);
Parameters
theControl

The control you want to dispose of. For a description of this data type, see “ControlRef”. 
Discussion

The DisposeControl function reduces the control’s reference count and, if the reference count becomes 0, releases the memory occupied by the control structure and any data structures associated with the control. Before destroying the control, DisposeControl removes the control (and any embedded controls it may possess) from the screen and deletes the control from the window’s control list.

To destroy all of the controls from a window you want to keep, use the function KillControls. If an embedding hierarchy is present, passing the root control to the DisposeControl function is the effectively the same as calling KillControls. In that situation, DisposeControl disposes of the controls embedded within a control before disposing of the container control.

You should use DisposeControl when you want to retain the window but remove one of its controls. The Window Manager functions CloseWindow and DisposeWindow automatically remove all controls associated with the window and release the memory the controls occupy. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
void DisposeControl (
   ControlRef theControl
){};



/*GetControl32BitMaximum

Obtains the maximum setting of a control.

SInt32 GetControl32BitMaximum (
   ControlRef theControl
);
Parameters
theControl

A handle to the control whose maximum setting you wish to obtain. For a description of this data type, see “ControlRef”.
Return Value

The maximum setting of the control. 
Discussion

Your application may use the GetControl32BitMaximum function to obtain a 32-bit value previously set with the function SetControl32BitMaximum.

If your application uses a 32-bit control maximum value, it should not attempt to obtain this value by calling the pre–Mac OS 8.5 function GetControlMaximum because the 16-bit value that is returned does not accurately reflect the current 32-bit control value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Controls.h*/
SInt32 GetControl32BitMaximum (
   ControlRef theControl
){};

/*DrawMenuBar

Draws the menu bar based on the current menu list.

void DrawMenuBar ();
Discussion

The DrawMenuBar function draws (or redraws) the menu bar according to the current menu list. Note that most Menu Manager calls that affect the menu bar call InvalMenuBar so that the menu bar is redrawn the next time through the event loop; however, you can call DrawMenuBar if you want the changes to appear immediately. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DrawMenuBar (){};


/*InsertMenu

Inserts an existing menu into the current menu list. 

void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
);
Parameters
theMenu

The menu to insert. 
beforeID

An integer that indicates where in the current menu list the menu should be inserted. InsertMenu inserts the menu into the current menu list before the menu whose menu ID is specified in the beforeID parameter. If the number in the beforeID parameter is 0 (or it isn’t the ID of any menu in the menu list), InsertMenu adds the new menu after all others (except before the Help menu). If the menu is already in the current menu list or the menu list is already full, InsertMenu does nothing. 

To insert a submenu into the current menu list, specify –1 or the equivalent constant kInsertHierarchicalMenu for the beforeID parameter. The submenus in the submenu portion of the menu list do not have to be currently associated with a hierarchical menu item; you can store submenus in the menu list and later specify that a menu item has a submenu if needed. However, note that during command key matching the Menu Manager scans all menus in the menu list for modifiers, including submenus that are not associated with any menu item. 

You can also specify –1 for the beforeID parameter to insert a pop-up menu into the current menu list. However, if you use the standard pop-up control definition function, the pop-up control automatically inserts the menu into the current menu list according to the needs of the pop-up control.

Discussion

Menus inserted using this function are added to a menu list attached to the current root menu. To obtain or set this root menu, call AcquireRootMenu and SetRootMenu respectively. 

Inserting a menu in the root menu (menu bar) increments its reference count; removing the menu decrements its reference count. 


To change a menu title, call SetMenuItemTextWithCFString. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
){};


/*SetMenuItemCommandID

Sets a menu item’s command ID. 

OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu that contains the menu item whose command ID you want to set. 
inItem

The menu index of the item. 
inCommandID

An integer representing the command ID that you wish to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can use a menu item’s command ID as a position-independent method of signalling a specific action in an application. See Carbon Event Manager Programming Guide for more information about command IDs. 

Note that Apple reserves all command IDs that contain all lowercase letters; your application is free to use any command ID containing uppercase characters.

See also the function GetMenuItemCommandID. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
){};

/*GetMenuHandle

Obtains a menu reference corresponding to a menu ID. 

MenuRef GetMenuHandle (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu whose reference you want to obtain. (Note that this is not the resource ID, although you often assign the menu ID so that it matches the resource ID.) You assign a menu ID in a nib file or in the 'MENU' resource of a menu. If you do not define your menus in nib files or in ‘MENU’' resources, you can assign a menu ID using NewMenu or SetMenuID. 
Return Value

The menu corresponding to the specified ID. If the specified menu is not in the current menu list, GetMenuHandle returns NULL. See the description of the MenuRef data type.
Discussion

You can also call this function as GetMenuRef (menuID);.

Use the GetMenuHandle function to obtain the menu reference for any of your application’s pull-down menus or submenus in the current menu list, other than the Help menu. You can also use the Help Manager function HMGetHelpMenuHandle to get a handle for your application’s Help menu. 
Special Considerations

To get a menu reference for a pop-up menu that you create using the pop-up control definition function, call the Control Manager functions GetControlData and GetControlDataSize, passing the tag constant kControlPopupButtonMenuRefTag in the tagName parameter to specify the menu reference.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef GetMenuHandle (
   MenuID menuID
){};

;
/*GetNextWindow

Returns the next window in a window list.

WindowRef GetNextWindow (
   WindowRef window
);
Parameters
window

The window to start from.
Return Value

The next window in a window list.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowRef GetNextWindow (
   WindowRef window
){};


/*FrontWindow

Identifies the frontmost visible window.

WindowRef FrontWindow ();
Return Value

The first visible window in the window list. If there are no visible windows, FrontWindow returns NULL.
Discussion

Most applications should use call ActiveNonFloatingWindow or FrontNonFloatingWindow instead of FrontWindow because ActiveNonFloatingWindow and FrontNonFloatingWindow return the active and frontmost document window, respectively, skipping over other types of windows that may be in front of the active document, such as the menubar window, floating windows, help tags and toolbars.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef FrontWindow (){};

/*CreateStandardWindowMenu

Creates a standard window menu for your application. 

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);
Parameters
inOptions

Option bits. Pass 0 or kWindowMenuIncludeRotate. For information on the kWindowMenuIncludeRotate constant, see “Rotating Window Menu Item Constant”.
outMenu

On output, a new menu reference that contains the standard window menu items and commands. 
Return Value

A result code. See “Window Manager Result Codes”. An operating system status code.
Discussion

You can call this function to create a window menu for your application. To register a window to be tracked by this menu, you either create your window with CreateNewWindow, passing the kWindowInWindowMenuAttribute, or you can use ChangeWindowAttributes after the window is created. The Toolbox takes care of acting on the standard items such as zoom and minimize, as well as bringing selected windows to the front. All you need to do is insert the menu in your menu bar (typically at the end of your menu list) and register your windows, and the Toolbox does the rest.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);



/*CreateStandardWindowMenu

Creates a standard window menu for your application. 

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);
Parameters
inOptions

Option bits. Pass 0 or kWindowMenuIncludeRotate. For information on the kWindowMenuIncludeRotate constant, see “Rotating Window Menu Item Constant”.
outMenu

On output, a new menu reference that contains the standard window menu items and commands. 
Return Value

A result code. See “Window Manager Result Codes”. An operating system status code.
Discussion

You can call this function to create a window menu for your application. To register a window to be tracked by this menu, you either create your window with CreateNewWindow, passing the kWindowInWindowMenuAttribute, or you can use ChangeWindowAttributes after the window is created. The Toolbox takes care of acting on the standard items such as zoom and minimize, as well as bringing selected windows to the front. All you need to do is insert the menu in your menu bar (typically at the end of your menu list) and register your windows, and the Toolbox does the rest.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
){};


















