#ifndef OPENGL_H
#include <OpenGL/OpenGL.h>
#endif

/*CGLGetCurrentContext

Returns the current rendering context.

CGLContextObj CGLGetCurrentContext(void);
Return Value

The current rendering context. If there is none, returns NULL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetCurrentContext*/
CGLContextObj CGLGetCurrentContext(void){
//TODO
};


/*CGLLockContext

Locks a CGL rendering context.

CGLError CGLLockContext(CGLContextObj ctx)
Parameters
ctx

The CGL context to lock.
Return Value

A result code. See “CGL Result Codes”.
Discussion

The function CGLLockContext blocks the thread it is on until all other threads have unlocked the same context using the function CGLUnlockContext. You can use CGLLockContext recursively. Context-specific CGL calls by themselves do not require locking, but you can guarantee serial processing for a group of calls by surrounding them with CGLLockContext and CGLUnlockContext. Keep in mind that calls from the OpenGL API (the API provided by the Architecture Review Board) require locking.

Applications that use NSOpenGL classes with multithreading can lock contexts using the functions CGLLockContext and CGLUnlockContext. To perform rendering in a thread other than the main one, you can lock the context that you want to access and safely execute OpenGL commands. The locking calls must be placed around all OpenGL calls in all threads.

For more information on multithreading OpenGL applications, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.4 and later.
Declared In
OpenGL.h
See Also
CGLUnlockContext*/
CGLError CGLLockContext(CGLContextObj ctx){
//TODO
};



/*CGLUnlockContext

Unlocks a CGL rendering context.

CGLError CGLUnlockContext(CGLContextObj ctx)
Parameters
ctx

The CGL context to unlock.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
OpenGL.h
See Also
CGLLockContext*/
CGLError CGLUnlockContext(CGLContextObj ctx){
//TODO
};

/*CGLGetParameter

Retrieves the value of a rendering context parameter.

CGLError CGLGetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   long  *params);
Parameters
ctx

A rendering context.
pname

The parameter whose value you want to retrieve. For a list of possible parameters, see Context Parameters.
params

On return, points to the value of the parameter.
Return Value

A result code. See “CGL Result Codes”.
Discussion

Some parameters may need to have a corresponding context option enabled for their value to take effect. You can enable, disable, and test whether an option is enabled with CGLEnable, CGLDisable, and CGLIsEnabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetParameter*/
CGLError CGLGetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   long  *params){};



