#include <sys/time.h>//hys

/*ROUND(3)                 BSD Library Functions Manual                 ROUND(3)

NAME
     round, lround, llround -- round to integral value, regardless of rounding
     direction

SYNOPSIS
     #include <math.h>

     double
     round(double x);

     long double
     roundl(long double x);

     float
     roundf(float x);

     long int
     lround(double x);

     long int
     lroundl(long double x);

     long int
     lroundf(float x);

     long long int
     llround(double x);

     long long int
     llroundl(long double x);

     long long int
     llroundf(float x);

DESCRIPTION
     The round() functions return the integral value nearest to x rounding
     half-way cases away from zero, regardless of the current rounding direc-direction.
     tion.

     The lround() and llround() functions return the integral value nearest to
     x (rounding half-way cases away from zero, regardless of the current
     rounding direction) in the return formats specified.  If the rounded
     value is outside the range of the return type, the numeric result is
     unspecified and the "invalid" floating-point exception is raised. A range
     error may occur if the magnitude of x is too large.

SPECIAL VALUES
     round(+-0) returns +-0.

     round(+-infinity) returns +-infinity.

     The round() functions may, but are not required to, raise the "inexact"
     floating-point exception for non-integer numeric arguments.

     The lround() and llround() functions need not raise the "inexact" float-floating-point
     ing-point exception for non-integer arguments that round to within the
     range of the return type.

SEE ALSO
     abs(3), fabs(3), ceil(3), floor(3), math(3), rint(3)

STANDARDS
     The round() , lround() , and llround() functions conform to ISO/IEC
     9899:1999(E).

BSD                              July 22, 2003                             BSD*/

 double
     round(double x);

     long double
     roundl(long double x);

     float
     roundf(float x);

     long int
     lround(double x);

     long int
     lroundl(long double x);

     long int
     lroundf(float x);

     long long int
     llround(double x);

     long long int
     llroundl(long double x);

     long long int
     llroundf(float x);

/*FLOOR(3)                 BSD Library Functions Manual                 FLOOR(3)



NAME
     floor -- round to largest integral value not greater than x

SYNOPSIS
     #include <math.h>

     double
     floor(double x);

     long double
     floorl(long double x);

     float
     floorf(float x);

DESCRIPTION
     The floor() functions return the largest integral value less than or
     equal to x.

SPECIAL VALUES
     floor(+-0) returns +-0.

     floor(+-infinity) returns +-infinity.

SEE ALSO
     abs(3), ceil(3), fabs(3), rint(3), math(3)

STANDARDS
     The floor() functions conform to ISO/IEC 9899:1999(E).

BSD                            November 20, 2002                           BSD*/
 double
     floor(double x);

     long double
     floorl(long double x);

     float
     floorf(float x);

/*RINT(3)                  BSD Library Functions Manual                  RINT(3)

NAME
     rint, lrint, llrint -- round to integral value

SYNOPSIS
     #include <math.h>

     double
     rint(double x);

     long double
     rintl(long double x);

     float
     rintf(float x);

     long int
     lrint(double x);

     long int
     lrintl(long double x);

     long int
     lrintf(float x);

     long long int
     llrint(double x);

     long long int
     llrintl(long double x);

     long long int
     llrintf(float x);

DESCRIPTION
     The rint() functions return the integral value nearest to x (according to
     the prevailing rounding mode) in floating-point format.

     The lrint() and llrint() functions return the integral value nearest to x
     (according to the prevailing rounding mode) in the return formats speci-specified.
     fied.  If the rounded value is outside the range of the return type, the
     numeric result is unspecified and the "invalid" floating-point exception
     is raised. A range error may occur if the magnitude of x is too large.

SPECIAL VALUES
     rint(+-0) returns +-0 for all rounding modes.

     rint(+-infinity) returns +-infinity for all rounding modes.

     All these functions raise the "inexact" floating-point exception if the
     result differs in value from the argument (except when they raise some
     other floating-point exception, such as "invalid").

SEE ALSO
     abs(3), fabs(3), ceil(3), floor(3), math(3)

STANDARDS
     The rint() , lrint() , and llrint() functions conform to ISO/IEC
     9899:1999(E).

BSD                            January 23, 2003                            BSD*/
  double
     rint(double x);

     long double
     rintl(long double x);

     float
     rintf(float x);

     long int
     lrint(double x);

     long int
     lrintl(long double x);

     long int
     lrintf(float x);

     long long int
     llrint(double x);

     long long int
     llrintl(long double x);

     long long int
     llrintf(float x);


/*LOG(3)                   BSD Library Functions Manual                   LOG(3)

NAME
     log, log2, log10, log1p, -- logarithm functions

SYNOPSIS
     #include <math.h>

     double
     log(double x);

     long double
     logl(long double x);

     float
     logf(float x);

     double
     log2(double x);

     long double
     log2l(long double x);

     float
     log2f(float x);

     double
     log10(double x);

     long double
     log10l(long double x);

     float
     log10f(float x);

     double
     log1p(double x);

     long double
     log1pl(long double x);

     float
     log1pf(float x);

DESCRIPTION
     The log() function computes the value of the natural logarithm of argu-argument
     ment x.

     The log2() function computes the value of the logarithm of argument x to
     base 2.

     The log10() function computes the value of the logarithm of argument x to
     base 10.

     The log1p() function computes the value of log(1+x) accurately even for
     very small values of x.

SPECIAL VALUES
     log(+-0) , log2(+-0) , and log10(+-0) return -infinity and raise the
     "divide-by-zero" floating-point exception.

     log(1) , log2(1) , and log10(1) return +0.

     log(x) , log2(x) , and log10(x) return a NaN and raise the "invalid"
     floating-point exception for x < 0.

     log(+infinity) , log2(+infinity) , and log10(+infinity) return +infinity.

     log1p(+-0) returns +-0.

     log1p(-1) returns -infinity and raises the "divide-by-zero" floating-
     point exception.

     log1p(x) returns a NaN and raises the "invalid" floating-point exception
     for x < -1.

     log1p(+infinity) returns +infinity.

SEE ALSO
     math(3), exp(3), exp2(3), expm1(3), pow(3)

STANDARDS
     The log() , log2() , log10() , and log1p() functions conform to ISO/IEC
     9899:1999(E).

4th Berkeley Distribution        July 2, 2003        4th Berkeley Distribution*/
 double
     log(double x);

     long double
     logl(long double x);

     float
     logf(float x);

     double
     log2(double x);

     long double
     log2l(long double x);

     float
     log2f(float x);

     double
     log10(double x);

     long double
     log10l(long double x);

     float
     log10f(float x);

     double
     log1p(double x);

     long double
     log1pl(long double x);

     float
     log1pf(float x);
