//inclu

#ifndef AEHELPERS_H
#define AEHELPERS_H


#include <stdarg.h>
#ifndef  APPLEEVENTS_H
#include <AE/AppleEvents.h>
#endif

#ifndef AEDATAMODEL_H
#include <AE/AEDataModel.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*AEBuild Error Codes

Represents syntax errors found by an “AEBuild” routine.

typedef UInt32 AEBuildErrorCode;
enum {
aeBuildSyntaxNoErr = 0,
aeBuildSyntaxBadToken = 1,
aeBuildSyntaxBadEOF = 2,
aeBuildSyntaxNoEOF = 3,
aeBuildSyntaxBadNegative = 4,
aeBuildSyntaxMissingQuote = 5,
aeBuildSyntaxBadHex = 6,
aeBuildSyntaxOddHex = 7,
aeBuildSyntaxNoCloseHex = 8,
aeBuildSyntaxUncoercedHex = 9,
aeBuildSyntaxNoCloseString = 10,
aeBuildSyntaxBadDesc = 11,
aeBuildSyntaxBadData = 12,
aeBuildSyntaxNoCloseParen = 13,
aeBuildSyntaxNoCloseBracket = 14,
aeBuildSyntaxNoCloseBrace = 15,
aeBuildSyntaxNoKey = 16,
aeBuildSyntaxNoColon = 17,
aeBuildSyntaxCoercedList = 18,
aeBuildSyntaxUncoercedDoubleAt = 19
};
Constants
aeBuildSyntaxNoErr

No error.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadToken

An illegal character was specified.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadEOF

An unexpected end of format string was encountered.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoEOF

There were unexpected characters beyond the end of the format string.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadNegative

A minus sign “-” was not followed by digits.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxMissingQuote

A string was not terminated by a closing quotation mark.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadHex

A hex string contained characters other than hexadecimal digits.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxOddHex

A hex string contained an odd number of digits.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseHex

A hex string was missing a “$” or “»” character.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxUncoercedHex

A hex string must be coerced to a type.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseString

A string was missing a closing quote.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadDesc

An illegal descriptor was specified.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxBadData

Bad data was found inside a variable argument list.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseParen

A data value was missing a closing parenthesis.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseBracket

A comma or closing bracket “]” was expected.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoCloseBrace

A comma or closing brace “}” was expected.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoKey

A keyword was missing from a descriptor.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxNoColon

In a descriptor, one of the keywords was not followed by a colon.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxCoercedList

Cannot coerce a list.

Available in Mac OS X v10.0 and later.
aeBuildSyntaxUncoercedDoubleAt

You must coerce a “@@” substitution.

Available in Mac OS X v10.0 and later.
AEhelpers.h*/
typedef UInt32 AEBuildErrorCode;
enum {
aeBuildSyntaxNoErr = 0,
aeBuildSyntaxBadToken = 1,
aeBuildSyntaxBadEOF = 2,
aeBuildSyntaxNoEOF = 3,
aeBuildSyntaxBadNegative = 4,
aeBuildSyntaxMissingQuote = 5,
aeBuildSyntaxBadHex = 6,
aeBuildSyntaxOddHex = 7,
aeBuildSyntaxNoCloseHex = 8,
aeBuildSyntaxUncoercedHex = 9,
aeBuildSyntaxNoCloseString = 10,
aeBuildSyntaxBadDesc = 11,
aeBuildSyntaxBadData = 12,
aeBuildSyntaxNoCloseParen = 13,
aeBuildSyntaxNoCloseBracket = 14,
aeBuildSyntaxNoCloseBrace = 15,
aeBuildSyntaxNoKey = 16,
aeBuildSyntaxNoColon = 17,
aeBuildSyntaxCoercedList = 18,
aeBuildSyntaxUncoercedDoubleAt = 19
};


/*AEBuildError

Defines a structure for storing additional error code information for “AEBuild” routines.

struct AEBuildError {
   AEBuildErrorCode fError;
   UInt32 fErrorPos;
};
typedef struct AEBuildError AEBuildError;
Fields
fError

The error code. See “AEBuild Error Codes” for a list of errors. 
fErrorPos

The character position where the parser detected the error. 
Availability
Available in Mac OS X v10.0 and later.
AEHelpers.h*/
struct AEBuildError {
   AEBuildErrorCode fError;
   UInt32 fErrorPos;
};
typedef struct AEBuildError AEBuildError;



/*AEBuildAppleEvent

Constructs an entire Apple event in a single call.

OSStatus AEBuildAppleEvent (
   AEEventClass theClass,
   AEEventID theID,
   DescType addressType,
   const void * addressData,
   long addressLength,
   short returnID,
   long transactionID,
   AppleEvent * result,
   AEBuildError * error,
   const char * paramsFmt,
   ...
);
Parameters
theClass

The event class for the resulting Apple event. See AEEventClass.
theID

The event id for the resulting Apple event. See AEEventID.
addressType

The address type for the addressing information described in the next two parameters: usually one of typeApplSignature, typeProcessSerialNumber, or typeKernelProcessID. See DescType.
addressData

A pointer to the address information.
addressLength

The number of bytes pointed to by the addressData parameter.
returnID

The return ID for the created Apple event. If you pass a value of kAutoGenerateReturnID, the Apple Event Manager assigns the created Apple event a return ID that is unique to the current session. If you pass any other value, the Apple Event Manager assigns that value for the ID.
transactionID

The transaction ID for this Apple event. A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the clients initial request for a service. All Apple events that are part of a transaction must have the same transaction ID. You can specify the kAnyTransactionID constant if the Apple event is not one of a series of interdependent Apple events.
result

A pointer to a descriptor where the resulting descriptor should be stored. See AppleEvent for a description of the data type.
error

A pointer to an AEBuildError structure where additional information about any errors that occur will be saved. This is an optional parameter and you can pass NULL if this information is not required. See AEBuildError for a description of the data type.
paramsFmt

An AEBuild format string describing the AppleEvent record to be created. The format of these strings is described in Technical Note TN2106, AEBuild*, AEPrint*, and Friends. That technote also describes possible error return codes for syntax errors in the format string.
Return Value

A numeric result code indicating the success of the call. A value of AEBuildSyntaxNoErr (zero) means the call succeeded. You can use the error parameter to discover information about other errors. See Apple Event Manager Result Codes.
Discussion

IMPORTANT: Following the parameters described above, the AEBuildAppleEvent function takes a variable number of parameters as specified by the format string provided in the paramsFmt parameter.

This function and related AEBuild routines (including AEBuildDesc and AEBuildParameters, and the variable-argument versions, vAEBuildAppleEvent, vAEBuildDesc, and vAEBuildParameters) provide a very simple translation service for converting specially formatted strings into complex Apple event descriptors. Normally, creating complex Apple event descriptors requires a large number of calls to Apple event Manager routines to build up the descriptor piece by piece. The AEBuildAppleEvent function and related routines allow you to consolidate all of the calls required to construct a complex Apple event descriptor into a single system call that creates the desired structure as directed by a format string that you provide.

In many ways, the AEBuild routines are very much like the standard C library's printf suite of routines. The syntax for the format string that you provide is very simple and allows for the substitution of data items into the Apple event descriptors being created.

The AEBuildAppleEvent function is similar to AECreateAppleEvent, but in addition to creating the Apple event, it also constructs the parameters for the event from the last three arguments. You can use AEBuildAppleEvent to build an entire Apple event, or AEBuildParameters to add additional parameters to an existing Apple event.

The syntax of the formatting string for an entire Apple event (as passed to AEBuildAppleEvent) is almost identical to that used to represent the contents of an Apple event, without the curly braces. The event is defined as a sequence of name-value pairs, with optional parameters preceded with a tilde (~) character. The syntax is described in Technical Note TN2106, AEBuild*, AEPrint*, and Friends.

It is important to note that the identifier for the direct parameter in an Apple event, specified by the constant keyDirectObject, is four minus signs ('----'). The minus sign has special meaning in AEBuild strings, and it should always be enclosed in single quotes when it is used to identify the direct parameter for an Apple event in a descriptor string.
Version Notes

Prior to Mac OS X version 10.3, AEBuildAppleEvent would fail if you supplied a data parameter with size greater than 32767 bytes.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEHelpers.h*/
OSStatus AEBuildAppleEvent (
   AEEventClass theClass,
   AEEventID theID,
   DescType addressType,
   const void * addressData,
   long addressLength,
   short returnID,
   long transactionID,
   AppleEvent * result,
   AEBuildError * error,
   const char * paramsFmt,
     ...
);


#ifdef __cplusplus
}
#endif

#endif

