#ifndef FIXMATH_H
#define FIXMATH_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>
#include <HYS/CarbonCore/FixMath.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*fixed1


enum {
   fixed1 = 0x00010000,
   fract1 = 0x40000000,
   positiveInfinity = 0x7FFFFFFF,
   negativeInfinity = 0x80000000
};
Constants
fixed1

Available in Mac OS X v10.0 and later.
fract1

Available in Mac OS X v10.0 and later.
positiveInfinity

Available in Mac OS X v10.0 and later.
negativeInfinity

Available in Mac OS X v10.0 and later.*/

enum {
   fixed1 = 0x00010000,
   fract1 = 0x40000000,
   positiveInfinity = 0x7FFFFFFF,
   negativeInfinity = 0x80000000
};

/*X2Fix

Converts an Extended number to a Fixed number.

Fixed X2Fix (
   double x
);
Parameters
x

The Extended number to be converted to a Fixed number. 
Return Value

The best Fixed approximation of the Extended number x. If x is greater than the maximum representable Fixed number, the X2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, X2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed X2Fix (
   double x
);

/*Fix2X

Converts a Fixed number to an Extended number.

double Fix2X (
   Fixed x
);
Parameters
x

The Fixed number to be converted to an Extended number. 
Return Value

The Extended equivalent of the Fixed number x. 
Special Considerations

Fix2X does not move memory; you can call it at interrupt time.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
double Fix2X (
   Fixed x
);
/*Long2Fix

Converts a LongInt number to a Fixed number.

Fixed Long2Fix (
   long x
);
Parameters
x

The long integer to be converted to a Fixed number. 
Return Value

The Fixed number equivalent to the long integer x. If x is greater than the maximum representable fixed-point number, the Long2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, Long2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

Fixed Long2Fix (
   long x
);

/*FixRatio

Obtains the Fixed equivalent of a fraction.

Fixed FixRatio (
   short numer,
   short denom
);
Parameters
numer

The numerator of the fraction. 
denom

The denominator of the fraction.
Return Value

The Fixed equivalent of the fraction numer/denom. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed FixRatio (
   short numer,
   short denom
);

/*Fix2Long

Converts a Fixed number to a LongInt number.

long Fix2Long (
   Fixed x
);
Parameters
x

The Fixed number to be converted to a long integer. 
Return Value

The long integer nearest to the Fixed number x. If x is halfway between two integers (0.5), it is rounded to the integer with the higher absolute value. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

long Fix2Long (
   Fixed x
);

/*FixMul

Multiplies a variable of type Fixed with another variable of type Fixed or with a variable of type Fract or LongInt.

Fixed FixMul (
   Fixed a,
   Fixed b
);
Parameters
a

The first operand, which can be a variable of type Fixed or a variable of type Fract or LongInt. 
b

The second operand, which can be a variable of type Fixed or a variable of type Fract or LongInt.
Return Value

The product of the numbers in a and b. At least one of a and b should be a variable of type Fixed. 

The returned value is in the format of a LongInt if one of a or b is a LongInt. It is a Fract number if one of a or b is Fract. It is a Fixed number if both a and b are Fixed numbers.

Overflows are set to the maximum representable value with the correct sign ($80000000 for negative results and $7FFFFFFF for positive results).

Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

Fixed FixMul (
   Fixed a,
   Fixed b
);


#ifdef __cplusplus
}
#endif

#endif