#ifndef FOLDERS_H
#define FOLDERS_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Folder Type Constants

Specify a type of folder on a particular volume. 

enum {
   kSystemFolderType = 'macs',
   kDesktopFolderType = 'desk',
   kSystemDesktopFolderType = 'sdsk',
   kTrashFolderType = 'trsh',
   kSystemTrashFolderType = 'strs',
   kWhereToEmptyTrashFolderType = 'empt',
   kPrintMonitorDocsFolderType = 'prnt',
   kStartupFolderType = 'strt',
   kShutdownFolderType = 'shdf',
   kAppleMenuFolderType = 'amnu',
   kControlPanelFolderType = 'ctrl',
   kSystemControlPanelFolderType = 'sctl',
   kExtensionFolderType = 'extn',
   kFontsFolderType = 'font',
   kPreferencesFolderType = 'pref',
   kSystemPreferencesFolderType = 'sprf',
   kTemporaryFolderType = 'temp'
};
enum {
   kExtensionDisabledFolderType = 'extD',
   kControlPanelDisabledFolderType = 'ctrD',
   kSystemExtensionDisabledFolderType = 'macD',
   kStartupItemsDisabledFolderType = 'strD',
   kShutdownItemsDisabledFolderType = 'shdD',
   kApplicationsFolderType = 'apps',
   kDocumentsFolderType = 'docs'
};
enum {
   kVolumeRootFolderType = 'root',
   kChewableItemsFolderType = 'flnt',
   kApplicationSupportFolderType = 'asup',
   kTextEncodingsFolderType = 'ƒtex',
   kStationeryFolderType = 'odst',
   kOpenDocFolderType = 'odod',
   kOpenDocShellPlugInsFolderType = 'odsp',
   kEditorsFolderType = 'oded',
   kOpenDocEditorsFolderType = 'ƒodf',
   kOpenDocLibrariesFolderType = 'odlb',
   kGenEditorsFolderType = 'ƒedi',
   kHelpFolderType = 'ƒhlp',
   kInternetPlugInFolderType = 'ƒnet',
   kModemScriptsFolderType = 'ƒmod',
   kPrinterDescriptionFolderType = 'ppdf',
   kPrinterDriverFolderType = 'ƒprd',
   kScriptingAdditionsFolderType = 'ƒscr',
   kSharedLibrariesFolderType = 'ƒlib',
   kVoicesFolderType = 'fvoc',
   kControlStripModulesFolderType = 'sdev',
   kAssistantsFolderType = 'astƒ',
   kUtilitiesFolderType = 'utiƒ',
   kAppleExtrasFolderType = 'aexƒ',
   kContextualMenuItemsFolderType = 'cmnu',
   kMacOSReadMesFolderType = 'morƒ',
   kALMModulesFolderType = 'walk',
   kALMPreferencesFolderType = 'trip',
   kALMLocationsFolderType = 'fall',
   kColorSyncProfilesFolderType = 'prof',
   kThemesFolderType = 'thme',
   kFavoritesFolderType = 'favs',
   kInternetFolderType = 'intƒ',
   kAppearanceFolderType = 'appr',
   kSoundSetsFolderType = 'snds',
   kDesktopPicturesFolderType = 'dtpƒ',
   kInternetSearchSitesFolderType = 'issf',
   kFindSupportFolderType = 'fnds',
   kFindByContentFolderType = 'fbcf',
   kInstallerLogsFolderType = 'ilgf',
   kScriptsFolderType = 'scrƒ',
   kFolderActionsFolderType = 'fasf',
   kLauncherItemsFolderType = 'laun',
   kRecentApplicationsFolderType = 'rapp',
   kRecentDocumentsFolderType = 'rdoc',
   kRecentServersFolderType = 'rsvr',
   kSpeakableItemsFolderType = 'spki',
   kKeychainFolderType = 'kchn',
   kQuickTimeExtensionsFolderType = 'qtex',
   kDisplayExtensionsFolderType = 'dspl',
   kMultiprocessingFolderType = 'mpxf',
   kPrintingPlugInsFolderType = 'pplg'
};
typedef OSType FolderType;
Constants
kSystemFolderType

Specifies the System Folder.

Available in Mac OS X v10.0 and later.
kDesktopFolderType

Specifies the Desktop Folder.

Available in Mac OS X v10.0 and later.
kSystemDesktopFolderType

Available in Mac OS X v10.0 and later.
kTrashFolderType

Specifies the single-user Trash folder.

Available in Mac OS X v10.0 and later.
kSystemTrashFolderType

Available in Mac OS X v10.0 and later.
kWhereToEmptyTrashFolderType

Specifies the shared Trash folder on a file server, this indicates the parent directory of all logged-on users’ Trash subdirectories.

Available in Mac OS X v10.0 and later.
kPrintMonitorDocsFolderType

Specifies the PrintMonitor Documents folder in the System Folder.

Available in Mac OS X v10.0 and later.
kStartupFolderType

Specifies the Startup Items folder in the System Folder.

Available in Mac OS X v10.0 and later.
kShutdownFolderType

Specifies the Shutdown Items folder in the System Folder.

Available in Mac OS X v10.0 and later.
kAppleMenuFolderType

Specifies the Apple Menu Items folder in the System Folder.

Available in Mac OS X v10.0 and later.
kControlPanelFolderType

Specifies the Control Panels folder in the System Folder.

Available in Mac OS X v10.0 and later.
kSystemControlPanelFolderType

Available in Mac OS X v10.0 and later.
kExtensionFolderType

Specifies the Extensions folder in the System Folder.

Available in Mac OS X v10.0 and later.
kFontsFolderType

Specifies the Fonts folder in the System Folder.

Available in Mac OS X v10.0 and later.
kPreferencesFolderType

Specifies the Preferences folder in the System Folder.

Available in Mac OS X v10.0 and later.
kSystemPreferencesFolderType

Available in Mac OS X v10.0 and later.
kTemporaryFolderType

Specifies the Temporary folder. This folder exists as an invisible folder at the volume root.

Available in Mac OS X v10.0 and later.
kExtensionDisabledFolderType

Specifies the Extensions (Disabled) folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kControlPanelDisabledFolderType

Specifies the Control Panels (Disabled) folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kSystemExtensionDisabledFolderType

Specifies the System Extensions (Disabled) folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kStartupItemsDisabledFolderType

Specifies the Startup Items (Disabled) folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kShutdownItemsDisabledFolderType

Specifies the Shutdown Items (Disabled) folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kApplicationsFolderType

Specifies the Applications folder installed at the root level of the volume. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kDocumentsFolderType

Specifies the Documents folder. This folder is created at the volume root. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kVolumeRootFolderType

Specifies the root folder of a volume. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kChewableItemsFolderType

Specifies the invisible folder on the system disk called “Cleanup at Startup” whose contents are deleted when the system is restarted, instead of merely being moved to the Trash. When the FindFolder function indicates this folder is available (by returning noErr), developers should usually use this folder for their temporary items, in preference to the Temporary Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kApplicationSupportFolderType

Specifies the Application Support folder in the System Folder. This folder contains code and data files needed by third-party applications. These files should usually not be written to after they are installed. In general, files deleted from this folder remove functionality from an application, unlike files in the Preferences folder, which should be non-essential. One type of file that could be placed here would be plug-ins that the user might want to maintain separately from any application, such as for an image-processing application that has many “fourth-party” plug-ins that the user might want to upgrade separately from the host application. Another type of file that might belong in this folder would be application-specific data files that are not preferences, such as for a scanner application that needs to read description files for specific scanner models according to which are currently available on the SCSI bus or network. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kTextEncodingsFolderType

Specifies the Text Encodings folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kStationeryFolderType

Specifies the OpenDoc stationery folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kOpenDocFolderType

Specifies the OpenDoc root folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kOpenDocShellPlugInsFolderType

Specifies the OpenDoc shell plug-ins folder in the OpenDoc folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kEditorsFolderType

Specifies the OpenDoc editors folder in the Mac OS folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kOpenDocEditorsFolderType

Specifies the OpenDoc subfolder in the Editors folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kOpenDocLibrariesFolderType

Specifies the OpenDoc libraries folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kGenEditorsFolderType

Specifies a general editors folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kHelpFolderType

Specifies the Help folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kInternetPlugInFolderType

Specifies the Browser Plug-ins folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kModemScriptsFolderType

Specifies the Modem Scripts folder in the Extensions folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kPrinterDescriptionFolderType

Specifies the Printer Descriptions folder in the Extensions folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kPrinterDriverFolderType

Specifies the printer drivers folder. This constant is not currently supported.

Available in Mac OS X v10.0 and later.
kScriptingAdditionsFolderType

Specifies the Scripting Additions folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kSharedLibrariesFolderType

Specifies the general shared libraries folder. This constant is not currently supported.

Available in Mac OS X v10.0 and later.
kVoicesFolderType

Specifies the Voices folder in the Extensions folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kControlStripModulesFolderType

Specifies the Control Strip Modules folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kAssistantsFolderType

Specifies the Assistants folder installed at the root level of the volume. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kUtilitiesFolderType

Specifies the Utilities folder installed at the root level of the volume. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kAppleExtrasFolderType

Specifies the Apple Extras folder installed at the root level of the volume. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kContextualMenuItemsFolderType

Specifies the Contextual Menu Items folder in the System Folder. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kMacOSReadMesFolderType

Specifies the Mac OS Read Me Files folder installed at the root level of the volume. Supported with Mac OS 8 and later.

Available in Mac OS X v10.0 and later.
kALMModulesFolderType

Specifies the Location Manager Modules folder in the Extensions Folder. Supported with Mac OS 8.1 and later.

Available in Mac OS X v10.0 and later.
kALMPreferencesFolderType

Specifies the Location Manager Prefs folder in the Preferences folder. Supported with Mac OS 8.1 and later.

Available in Mac OS X v10.0 and later.
kALMLocationsFolderType

Specifies the Locations folder in the Location Manager Prefs folder. Files containing configuration information for different locations are stored here. Supported with Mac OS 8.1 and later.

Available in Mac OS X v10.0 and later.
kColorSyncProfilesFolderType

Specifies the ColorSync Profiles folder in the System Folder. Supported with Mac OS 8.1 and later.

Available in Mac OS X v10.0 and later.
kThemesFolderType

Specifies the Theme Files folder in the Appearance folder. Supported with Mac OS 8.1 and later.

Available in Mac OS X v10.0 and later.
kFavoritesFolderType

Specifies the Favorites folder in the System Folder. This folder is for storing Internet location files, aliases, and aliases to other frequently used items. Facilities for adding items into this folder are found in Contextual Menus, the Finder, Navigation Services, and others. Supported with Mac OS 8.1 and later.

Available in Mac OS X v10.0 and later.
kInternetFolderType

Specifies the Internet folder installed at the root level of the volume. This folder is a location for saving Internet-related applications, resources, and tools. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kAppearanceFolderType

Specifies the Appearance folder in the System Folder. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kSoundSetsFolderType

Specifies the Sound Sets folder in the Appearance folder. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kDesktopPicturesFolderType

Specifies the Desktop Pictures folder in the Appearance folder. This folder is used for storing desktop picture files. Files of type 'JPEG' are auto-routed into this folder when dropped into the System Folder. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kInternetSearchSitesFolderType

Specifies the Internet Search Sites folder in the System Folder. This folder contains Internet search site specification files used by the Find application when it accesses Internet search sites. Files of type 'issp' are auto-routed to this folder. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kFindSupportFolderType

Specifies the Find folder in the Extensions folder. This folder contains files used by the Find application. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kFindByContentFolderType

Specifies the Find By Content folder installed at the root level of the volume. This folder is invisible and its use is private to Find By Content. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kInstallerLogsFolderType

Specifies the Installer Logs folder installed at the root level of the volume. You can use this folder to save installer log files. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kScriptsFolderType

Specifies the Scripts folder in the System Folder. This folder is for saving AppleScript scripts. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kFolderActionsFolderType

Specifies the Folder Action Scripts folder in the Scripts folder. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kLauncherItemsFolderType

Specifies the Launcher Items folder in the System Folder. Items in this folder appear in the Launcher control panel. Items included in folders with names beginning with a bullet (Option-8) character will appear as a separate panel in the Launcher window. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kRecentApplicationsFolderType

Specifies the Recent Applications folder in the Apple Menu Items folder. Apple Menu Items saves aliases to recent applications here. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kRecentDocumentsFolderType

Specifies the Recent Documents folder in the Apple Menu Items folder. Apple Menu Items saves aliases to recently opened documents here. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kRecentServersFolderType

Specifies the Recent Servers folder in the Apple Menu Items folder. Apple Menu Items saves aliases to recently mounted servers here. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kSpeakableItemsFolderType

Specifies the Speakable Items folder. This folder is for storing scripts and items recognized by speech recognition. Supported with Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.*/
enum {
   kSystemFolderType = 'macs',
   kDesktopFolderType = 'desk',
   kSystemDesktopFolderType = 'sdsk',
   kTrashFolderType = 'trsh',
   kSystemTrashFolderType = 'strs',
   kWhereToEmptyTrashFolderType = 'empt',
   kPrintMonitorDocsFolderType = 'prnt',
   kStartupFolderType = 'strt',
   kShutdownFolderType = 'shdf',
   kAppleMenuFolderType = 'amnu',
   kControlPanelFolderType = 'ctrl',
   kSystemControlPanelFolderType = 'sctl',
   kExtensionFolderType = 'extn',
   kFontsFolderType = 'font',
   kPreferencesFolderType = 'pref',
   kSystemPreferencesFolderType = 'sprf',
   kTemporaryFolderType = 'temp'
};
enum {
   kExtensionDisabledFolderType = 'extD',
   kControlPanelDisabledFolderType = 'ctrD',
   kSystemExtensionDisabledFolderType = 'macD',
   kStartupItemsDisabledFolderType = 'strD',
   kShutdownItemsDisabledFolderType = 'shdD',
   kApplicationsFolderType = 'apps',
   kDocumentsFolderType = 'docs'
};
enum {
   kVolumeRootFolderType = 'root',
   kChewableItemsFolderType = 'flnt',
   kApplicationSupportFolderType = 'asup',
   kTextEncodingsFolderType = 'ƒtex',
   kStationeryFolderType = 'odst',
   kOpenDocFolderType = 'odod',
   kOpenDocShellPlugInsFolderType = 'odsp',
   kEditorsFolderType = 'oded',
   kOpenDocEditorsFolderType = 'ƒodf',
   kOpenDocLibrariesFolderType = 'odlb',
   kGenEditorsFolderType = 'ƒedi',
   kHelpFolderType = 'ƒhlp',
   kInternetPlugInFolderType = 'ƒnet',
   kModemScriptsFolderType = 'ƒmod',
   kPrinterDescriptionFolderType = 'ppdf',
   kPrinterDriverFolderType = 'ƒprd',
   kScriptingAdditionsFolderType = 'ƒscr',
   kSharedLibrariesFolderType = 'ƒlib',
   kVoicesFolderType = 'fvoc',
   kControlStripModulesFolderType = 'sdev',
   kAssistantsFolderType = 'astƒ',
   kUtilitiesFolderType = 'utiƒ',
   kAppleExtrasFolderType = 'aexƒ',
   kContextualMenuItemsFolderType = 'cmnu',
   kMacOSReadMesFolderType = 'morƒ',
   kALMModulesFolderType = 'walk',
   kALMPreferencesFolderType = 'trip',
   kALMLocationsFolderType = 'fall',
   kColorSyncProfilesFolderType = 'prof',
   kThemesFolderType = 'thme',
   kFavoritesFolderType = 'favs',
   kInternetFolderType = 'intƒ',
   kAppearanceFolderType = 'appr',
   kSoundSetsFolderType = 'snds',
   kDesktopPicturesFolderType = 'dtpƒ',
   kInternetSearchSitesFolderType = 'issf',
   kFindSupportFolderType = 'fnds',
   kFindByContentFolderType = 'fbcf',
   kInstallerLogsFolderType = 'ilgf',
   kScriptsFolderType = 'scrƒ',
   kFolderActionsFolderType = 'fasf',
   kLauncherItemsFolderType = 'laun',
   kRecentApplicationsFolderType = 'rapp',
   kRecentDocumentsFolderType = 'rdoc',
   kRecentServersFolderType = 'rsvr',
   kSpeakableItemsFolderType = 'spki',
   kKeychainFolderType = 'kchn',
   kQuickTimeExtensionsFolderType = 'qtex',
   kDisplayExtensionsFolderType = 'dspl',
   kMultiprocessingFolderType = 'mpxf',
   kPrintingPlugInsFolderType = 'pplg'
};
typedef OSType FolderType;

/*kUsersFolderType


enum {
   kUsersFolderType = 'usrs',
   kCurrentUserFolderType = 'cusr',
   kCurrentUserRemoteFolderLocation = 'rusf',
   kCurrentUserRemoteFolderType = 'rusr',
   kSharedUserDataFolderType = 'sdat',
   kVolumeSettingsFolderType = 'vsfd'
};*/
enum {
   kUsersFolderType = 'usrs',
   kCurrentUserFolderType = 'cusr',
   kCurrentUserRemoteFolderLocation = 'rusf',
   kCurrentUserRemoteFolderType = 'rusr',
   kSharedUserDataFolderType = 'sdat',
   kVolumeSettingsFolderType = 'vsfd'
};

/*Create Folder Flags

Indicate whether a folder should be created, if it is not found.

enum {
   kCreateFolder = true,
   kDontCreateFolder = false
};
Constants
kCreateFolder

Specifies that the folder should be created, if it is not found. 

Available in Mac OS X v10.0 and later.
kDontCreateFolder

Specifies that the folder should not be created, if it is not found.

Available in Mac OS X v10.0 and later.
Discussion

You can pass these flag constants in the createFolder parameter of the function FSFindFolder.*/

enum {
   kCreateFolder = true,
   kDontCreateFolder = false
};


/*kDomainTopLevelFolderType



enum {
   kDomainTopLevelFolderType = 'dtop',
   kDomainLibraryFolderType = 'dlib',
   kColorSyncFolderType = 'sync',
   kColorSyncCMMFolderType = 'ccmm',
   kColorSyncScriptingFolderType = 'cscr',
   kPrintersFolderType = 'impr',
   kSpeechFolderType = 'spch',
   kCarbonLibraryFolderType = 'carb',
   kDocumentationFolderType = 'info',
   kDeveloperDocsFolderType = 'ddoc',
   kDeveloperHelpFolderType = 'devh',
   kISSDownloadsFolderType = 'issd',
   kUserSpecificTmpFolderType = 'utmp',
   kCachedDataFolderType = 'cach',
   kFrameworksFolderType = 'fram',
   kPrivateFrameworksFolderType = 'pfrm',
   kClassicDesktopFolderType = 'sdsk',
   kDeveloperFolderType = 'devf',
   kSystemSoundsFolderType = 'ssnd',
   kComponentsFolderType = 'cmpd',
   kQuickTimeComponentsFolderType = 'wcmp',
   kCoreServicesFolderType = 'csrv',
   kPictureDocumentsFolderType = 'pdoc',
   kMovieDocumentsFolderType = 'mdoc',
   kMusicDocumentsFolderType = 'doc',
   kInternetSitesFolderType = 'site',
   kPublicFolderType = 'pubb',
   kAudioSupportFolderType = 'adio',
   kAudioSoundsFolderType = 'asnd',
   kAudioSoundBanksFolderType = 'bank',
   kAudioAlertSoundsFolderType = 'alrt',
   kAudioPlugInsFolderType = 'aplg',
   kAudioComponentsFolderType = 'acmp',
   kKernelExtensionsFolderType = 'kext',
   kDirectoryServicesFolderType = 'dsrv',
   kDirectoryServicesPlugInsFolderType = 'dplg',
   kInstallerReceiptsFolderType = 'rcpt',
   kFileSystemSupportFolderType = 'fsys',
   kAppleShareSupportFolderType = 'shar',
   kAppleShareAuthenticationFolderType = 'auth',
   kMIDIDriversFolderType = 'midi',
   kKeyboardLayoutsFolderType = 'klay',
   kIndexFilesFolderType = 'indx',
   kFindByContentIndexesFolderType = 'fbcx',
   kManagedItemsFolderType = 'mang',
   kBootTimeStartupItemsFolderType = 'empz'
};*/
enum {
   kDomainTopLevelFolderType = 'dtop',
   kDomainLibraryFolderType = 'dlib',
   kColorSyncFolderType = 'sync',
   kColorSyncCMMFolderType = 'ccmm',
   kColorSyncScriptingFolderType = 'cscr',
   kPrintersFolderType = 'impr',
   kSpeechFolderType = 'spch',
   kCarbonLibraryFolderType = 'carb',
   kDocumentationFolderType = 'info',
   kDeveloperDocsFolderType = 'ddoc',
   kDeveloperHelpFolderType = 'devh',
   kISSDownloadsFolderType = 'issd',
   kUserSpecificTmpFolderType = 'utmp',
   kCachedDataFolderType = 'cach',
   kFrameworksFolderType = 'fram',
   kPrivateFrameworksFolderType = 'pfrm',
   kClassicDesktopFolderType = 'sdsk',
   kDeveloperFolderType = 'devf',
   kSystemSoundsFolderType = 'ssnd',
   kComponentsFolderType = 'cmpd',
   kQuickTimeComponentsFolderType = 'wcmp',
   kCoreServicesFolderType = 'csrv',
   kPictureDocumentsFolderType = 'pdoc',
   kMovieDocumentsFolderType = 'mdoc',
   kMusicDocumentsFolderType = 'doc',
   kInternetSitesFolderType = 'site',
   kPublicFolderType = 'pubb',
   kAudioSupportFolderType = 'adio',
   kAudioSoundsFolderType = 'asnd',
   kAudioSoundBanksFolderType = 'bank',
   kAudioAlertSoundsFolderType = 'alrt',
   kAudioPlugInsFolderType = 'aplg',
   kAudioComponentsFolderType = 'acmp',
   kKernelExtensionsFolderType = 'kext',
   kDirectoryServicesFolderType = 'dsrv',
   kDirectoryServicesPlugInsFolderType = 'dplg',
   kInstallerReceiptsFolderType = 'rcpt',
   kFileSystemSupportFolderType = 'fsys',
   kAppleShareSupportFolderType = 'shar',
   kAppleShareAuthenticationFolderType = 'auth',
   kMIDIDriversFolderType = 'midi',
   kKeyboardLayoutsFolderType = 'klay',
   kIndexFilesFolderType = 'indx',
   kFindByContentIndexesFolderType = 'fbcx',
   kManagedItemsFolderType = 'mang',
   kBootTimeStartupItemsFolderType = 'empz'
};


/*Disk and Domain Constants

Identify the disk or domain in which to locate a folder.

enum {
   kOnSystemDisk = -32768L,
   kOnAppropriateDisk = -32767,
   kSystemDomain = -32766,
   kLocalDomain = -32765,
   kNetworkDomain = -32764,
   kUserDomain = -32763,
   kClassicDomain = -32762
};
enum {
   kLastDomainConstant = kUserDomain
};
Constants
kOnSystemDisk

Specifies the system disk.

Available in Mac OS X v10.0 and later.
kOnAppropriateDisk

In most cases, the equivalent of kOnSystemDisk. On Mac OS X, use this constant instead of the constant kOnSytemDisk to indicate any disk.

Available in Mac OS X v10.0 and later.
kSystemDomain

Available in Mac OS X v10.0 and later.
kLocalDomain

Available in Mac OS X v10.0 and later.
kNetworkDomain

Available in Mac OS X v10.0 and later.
kUserDomain

Available in Mac OS X v10.0 and later.
kClassicDomain

Available in Mac OS X v10.0 and later.
kLastDomainConstant

Available in Mac OS X v10.0 and later.
Discussion

You can pass this constant in the vRefNum parameter of FSFindFolder to locate a folder on the startup disk.*/
enum {
   kOnSystemDisk = -32768L,
   kOnAppropriateDisk = -32767,
   kSystemDomain = -32766,
   kLocalDomain = -32765,
   kNetworkDomain = -32764,
   kUserDomain = -32763,
   kClassicDomain = -32762
};
enum {
   kLastDomainConstant = kUserDomain
};

/*FSFindFolder

Obtains location information for system-related directories.

OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType)on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Passing kCreateFolder will not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundRef

A pointer to a file system reference. On return, the FSRef refers to the directory specified by the vRefNum and folderType parameters.
Return Value

A result code. See "Folder Manager Result Codes".
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);

/*FindFolder

Obtains location information for system-related directories.

OSErr FindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   short * foundVRefNum,
   long * foundDirID
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType) on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Directories inside the System Folder are created only if the System Folder directory exists. The FindFolder function will not create a System Folder directory even if you specify the kCreateFolder constant in the createFolder parameter. Passing kCreateFolder will also not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundVRefNum

A pointer to a value of type short. On return, the value specifies the volume reference number for the volume containing the directory specified in the folderType parameter.
foundDirID

A pointer to a value of type long. On return, the value specifies the directory ID number for the directory specified in the folderType parameter. 
Return Value

A result code. See "Folder Manager Result Codes". The result code fnfErr indicates that the type has not been found in the 'fld#' resource, or the disk doesn’t have System Folder support, or the disk does not have desktop database support for Desktop Folder—in all cases, the folder has not been found. The result code dupFNErr indicates that a file has been found instead of a folder.
Discussion

As of Mac OS 8 and later, your application can add folders to the System Folder—or nest folders within other folders—and locate the folders via the FindFolder function. Prior to Mac OS 8, your application could only use FindFolder to find folders that were immediately inside of the System Folder, and a few other special folders such as the Trash folder and the System Folder itself. Now, once a folder (and any folders that it is nested within) is described in a folder descriptor—that is, registered using the function AddFolderDescriptor —your application can use FindFolder to find the folder no matter where it is located.

Those folders you’re most likely to want to access are Preferences and Trash. For example, you might wish to check for the existence of a user’s configuration file in Preferences or, if your application runs out of disk storage when trying to save a file, check how much disk storage is taken by items in the Trash directory and report this to the user.

The specified folder used for a given volume might be located on a different volume; therefore, do not assume the volume that you specify in vRefNum and the volume returned through foundVRefNum will be the same. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   short * foundVRefNum,
   long * foundDirID
);

#ifdef __cplusplus
}
#endif

#endif