#ifndef TIMER_H
#define TIMER_H

#ifndef  CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef OSUTILS_H
#include <CarbonCore/OSUtils.h>
#endif



#include <AvailabilityMacros.h>
#include <HYS/CarbonCore/Timer.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*TimerProcPtr

Defines a pointer to your application-defined Time Manager task that is executed after a specified delay.

typedef void (*TimerProcPtr) (
   TMTaskPtr tmTaskPtr
);

If you name your function MyTimerProc, you would declare it like this:

void MyTimerProc (
   TMTaskPtr tmTaskPtr
);
Parameters
tmTaskPtr

A pointer to a structure of type TMTask containing the information about the task.*/
typedef struct TMTask TMTask;
typedef TMTask * TMTaskPtr;


typedef void (*TimerProcPtr) (
   TMTaskPtr tmTaskPtr
);

/*TimerUPP

Defines a data type for the TimerProcPtr callback function.

typedef TimerProcPtr TimerUPP;
Discussion

For more information, see the description of the TimerProcPtr callback function.*/
typedef TimerProcPtr TimerUPP;


/*TMTask

Contains information for a Time Manager task.

struct TMTask {
   QElemPtr qLink;
   short qType;
   TimerUPP tmAddr;
   long tmCount;
   long tmWakeUp;
   long tmReserved;
};
typedef struct TMTask TMTask;
typedef TMTask * TMTaskPtr;
Fields
qLink

A pointer to the next element in the Time Manager queue. This field is used internally by the Time Manager. 
qType

The type of queue. The Time Manager automatically sets this field to the appropriate value. The high-order bit of this field is a flag that indicates whether the task is active.
tmAddr

A pointer to the function that is to execute after the delay specified in a call to PrimeTime. 
tmCount

Reserved in the original Time Manager. In the revised or extended Time Manager, the amount of time remaining until the task’s scheduled execution time. This field is valid only after you call RmvTime with a task that has not yet executed.
tmWakeUp

In the extended Time Manager, the time when the task specified in the tmAddr field was last executed. This field is used internally by the Time Manager. You should set it to 0 when you first install a task structure.
tmReserved

Reserved.
Availability
Available in Mac OS X v10.0 and later.*/
struct TMTask {
   QElemPtr qLink;
   short qType;
   TimerUPP tmAddr;
   long tmCount;
   long tmWakeUp;
   long tmReserved;
};
typedef struct TMTask TMTask;
typedef TMTask * TMTaskPtr;

//function

/*Microseconds

Determines the number of microseconds that have elapsed since system startup time.

void Microseconds (
   UnsignedWide * microTickCount
);
Parameters
microTickCount

The number of microseconds elapsed since system startup.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Timer.h*/
void Microseconds (
   UnsignedWide * microTickCount
);

/*PrimeTime

Activates a task in the Time Manager queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void PrimeTime (
QElemPtr tmTaskPtr,
long count
);
Discussion

This function is deprecated. You should use the function PrimeTimeTask instead.
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/

void PrimeTime (
QElemPtr tmTaskPtr,
long count
);

/*RmvTime

Remove a task from the Time Manager queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void RmvTime (
QElemPtr tmTaskPtr
);
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/
void RmvTime (
QElemPtr tmTaskPtr
);

/*InsTime

Installs a task record into the Time Manager task queue. (Deprecated in Mac OS X v10.4. Use Carbon Event Loop timers or Cocoa NSTImers instead.)

Not Recommended

void InsTime (
QElemPrt tmTaskPtr
);
Special Considerations

Carbon Event timers and Cocoa NSTimers provide a simpler and more efficient way to handle timed or periodic tasks. For more information about using Carbon Event timers, see the timers section in Carbon Event Manager Programming Guide. For information about NSTimers, see Timers. Both Carbon event timers and NSTimers are built on top of the lower-level Core Foundation CFRunLoop timers. For CFRunLoop information, see Run Loops.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Timer.h*/
typedef QElemPtr QElemPrt;

void InsTime (
QElemPrt tmTaskPtr
);


#ifdef __cplusplus
}
#endif

#endif