#ifndef CMICCPROFILE_H
#define CMICCPROFILE_H

#ifndef  CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#include <HYS/ColorSync/CMICCProfile.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

/*Flag Mask Definitions for Version 2.x Profiles

Define masks your application can use to set or test various bits in the flags field of the CM2Header structure.

enum {
   cmICCReservedFlagsMask = 0x0000FFFF,
   cmEmbeddedMask = 0x00000001,
   cmEmbeddedUseMask = 0x00000002,
   cmCMSReservedFlagsMask = 0xFFFF0000,
   cmQualityMask = 0x00030000,
   cmInterpolationMask = 0x00040000,
   cmGamutCheckingMask = 0x00080000
};
Constants
cmICCReservedFlagsMask

This mask provides access to bits 0 through 15 of the flags field, which are defined and reserved by the ICC. For more information, see the International Color Consortium Profile Format Specification, and the next two mask definitions.

To obtain a copy of the ICC specification, or to get other information about the ICC, visit the ICC Web site at http://www.color.org/.

Available in Mac OS X v10.0 and later.
cmEmbeddedMask

This mask provides access to bit 0 of the flags field, which specifies whether the profile is embedded. It has the value 1 if the profile is embedded, 0 if it is not.

Available in Mac OS X v10.0 and later.
cmEmbeddedUseMask

This mask provides access to bit 1 of the flags field, which specifies whether the profile can be used independently or can only be used as an embedded profile. It has the value 0 if the profile can be used anywhere, 1 if it must be embedded.

You should interpret the setting of this bit as an indication of copyright protection. If the profile developer set this bit to 1, you should use this profile as an embedded profile only and not copy the profile for your own purposes. The profile developer also specifies explicit copyright intention using the cmCopyrightTag profile tag (defined in the CMICCProfile.h header file).

Available in Mac OS X v10.0 and later.
cmCMSReservedFlagsMask

This mask provides access to bits 16 through 31 of the flags field, which are available for a color management system (CMS) vendor, such as ColorSync. ColorSync’s default CMM uses bits 16 through 19 to provide hints for color matching, as described in the following three mask definitions. Other CMM vendors should follow the same conventions.

Available in Mac OS X v10.0 and later.
cmQualityMask

This mask provides access to bits 16 and 17 of the flags field, which specify the preferred quality and speed preferences for color matching. In general, the higher the quality the slower the speed. For example, best quality is slowest, but produces the highest quality result.

Bits 16 and 17 have the value 0 for normal quality, 1 for draft quality, and 2 for best quality. “Quality Flag Values for Version 2.x Profiles” describes the constants ColorSync defines to test or set these bits.

This feature is provided by the ColorSync Manager; it is not defined by the ICC profile specification.

Available in Mac OS X v10.0 and later.
cmInterpolationMask

This mask provides access to bit 18 of the flags field, which specifies whether to use interpolation in color matching. The value 0 specifies interpolation. The value 1 specifies table lookup without interpolation. Specifying lookup only improves speed but can reduce accuracy. You might use lookup only for a monitor profile, for example, when high resolution is not crucial.

This feature is provided by the ColorSync Manager; it is not defined by the ICC profile specification.

Available in Mac OS X v10.0 and later.
cmGamutCheckingMask

This mask provides access to bit 19 of the flags field. When you use a profile to create a color world, bit 19 specifies whether the color world should include information for gamut checking. It has the value 0 if the color world should include a gamut-checking table, 1 if gamut-checking information is not required. ColorSync can create a color world without a gamut table more quickly and in less space.

Many applications do not perform gamut checking, so they should set this bit to 1. However, if you call a color checking function such as CWCheckColors, or CWMatchColors, after setting a profile’s gamut-checking bit so that the color world does not contain gamut information, these routines return the cmCantGamutCheckError error.

This feature is provided by the ColorSync Manager; it is not defined by the ICC profile specification.

Available in Mac OS X v10.0 and later.
Discussion

The flags field of the structure CM2Header is an unsigned long value whose bits specify information about a profile. The ICC reserves the use of bits 0 to 15 and has assigned values to bits 0 and 1. Bits 16 to 31 are reserved for use by color management system (CMS) vendors. ColorSync has assigned values to bits 16 through 19.*/

enum {
   cmICCReservedFlagsMask = 0x0000FFFF,
   cmEmbeddedMask = 0x00000001,
   cmEmbeddedUseMask = 0x00000002,
   cmCMSReservedFlagsMask = 0xFFFF0000,
   cmQualityMask = 0x00030000,
   cmInterpolationMask = 0x00040000,
   cmGamutCheckingMask = 0x00080000
};



/*Video Card Gamma Tags

Specify video card gamma information.

enum {
   cmPS2CRDVMSizeTag = 'psvm',
   cmVideoCardGammaTag = 'vcgt',
   cmMakeAndModelTag = 'mmod',
   cmProfileDescriptionMLTag = 'dscm',
   cmNativeDisplayInfoTag = 'ndin'
};
Constants
cmPS2CRDVMSizeTag

Available in Mac OS X v10.0 and later.
cmVideoCardGammaTag

Constant for profile tag that specifies video card gamma information. When you create a tag to store video card gamma data in a profile, you use the cmVideoCardGammaTag constant to specify the tag.

Starting with version 2.5, ColorSync supports an optional profile tag for video card gamma. The tag specifies gamma information, stored either as a formula or in table format, to be loaded into the video card when the profile containing the tag is put into use. As of version 2.5, the only ColorSync function that attempts to take advantage of video card gamma data is CMSetProfileByAVID.

Available in Mac OS X v10.0 and later.
cmMakeAndModelTag

Available in Mac OS X v10.0 and later.
cmProfileDescriptionMLTag

Available in Mac OS X v10.0 and later.
cmNativeDisplayInfoTag

Available in Mac OS X v10.1 and later.*/
enum {
   cmPS2CRDVMSizeTag = 'psvm',
   cmVideoCardGammaTag = 'vcgt',
   cmMakeAndModelTag = 'mmod',
   cmProfileDescriptionMLTag = 'dscm',
   cmNativeDisplayInfoTag = 'ndin'
};

/*Public Tags

Specify tag values available for public use.

enum {
   cmAToB0Tag = 'A2B0',
   cmAToB1Tag = 'A2B1',
   cmAToB2Tag = 'A2B2',
   cmBlueColorantTag = 'bXYZ',
   cmBlueTRCTag = 'bTRC',
   cmBToA0Tag = 'B2A0',
   cmBToA1Tag = 'B2A1',
   cmBToA2Tag = 'B2A2',
   cmCalibrationDateTimeTag = 'calt',
   cmChromaticAdaptationTag = 'chad',
   cmCharTargetTag = 'targ',
   cmCopyrightTag = 'cprt',
   cmDeviceMfgDescTag = 'dmnd',
   cmDeviceModelDescTag = 'dmdd',
   cmGamutTag = 'gamt',
   cmGrayTRCTag = 'kTRC',
   cmGreenColorantTag = 'gXYZ',
   cmGreenTRCTag = 'gTRC',
   cmLuminanceTag = 'lumi',
   cmMeasurementTag = 'meas',
   cmMediaBlackPointTag = 'bkpt',
   cmMediaWhitePointTag = 'wtpt',
   cmNamedColorTag = 'ncol',
   cmNamedColor2Tag = 'ncl2',
   cmPreview0Tag = 'pre0',
   cmPreview1Tag = 'pre1',
   cmPreview2Tag = 'pre2',
   cmProfileDescriptionTag = 'desc',
   cmProfileSequenceDescTag = 'pseq',
   cmPS2CRD0Tag = 'psd0',
   cmPS2CRD1Tag = 'psd1',
   cmPS2CRD2Tag = 'psd2',
   cmPS2CRD3Tag = 'psd3',
   cmPS2CSATag = 'ps2s',
   cmPS2RenderingIntentTag = 'ps2i',
   cmRedColorantTag = 'rXYZ',
   cmRedTRCTag = 'rTRC',
   cmScreeningDescTag = 'scrd',
   cmScreeningTag = 'scrn',
   cmTechnologyTag = 'tech',
   cmUcrBgTag = 'bfd ',
   cmViewingConditionsDescTag = 'vued',
   cmViewingConditionsTag = 'view'
};
Constants
cmAToB0Tag

Available in Mac OS X v10.0 and later.
cmAToB1Tag

Available in Mac OS X v10.0 and later.
cmAToB2Tag

Available in Mac OS X v10.0 and later.
cmBlueColorantTag

Available in Mac OS X v10.0 and later.
cmBlueTRCTag

Available in Mac OS X v10.0 and later.
cmBToA0Tag

Available in Mac OS X v10.0 and later.
cmBToA1Tag

Available in Mac OS X v10.0 and later.
cmBToA2Tag

Available in Mac OS X v10.0 and later.
cmCalibrationDateTimeTag

Available in Mac OS X v10.0 and later.
cmChromaticAdaptationTag

Available in Mac OS X v10.0 and later.
cmCharTargetTag

Available in Mac OS X v10.0 and later.
cmCopyrightTag

Available in Mac OS X v10.0 and later.
cmDeviceMfgDescTag

Available in Mac OS X v10.0 and later.
cmDeviceModelDescTag

Available in Mac OS X v10.0 and later.
cmGamutTag

Available in Mac OS X v10.0 and later.
cmGrayTRCTag

Available in Mac OS X v10.0 and later.
cmGreenColorantTag

Available in Mac OS X v10.0 and later.
cmGreenTRCTag

Available in Mac OS X v10.0 and later.
cmLuminanceTag

Available in Mac OS X v10.0 and later.
cmMeasurementTag

Available in Mac OS X v10.0 and later.
cmMediaBlackPointTag

Available in Mac OS X v10.0 and later.
cmMediaWhitePointTag

Available in Mac OS X v10.0 and later.
cmNamedColorTag

Available in Mac OS X v10.0 and later.
cmNamedColor2Tag

Available in Mac OS X v10.0 and later.
cmPreview0Tag

Available in Mac OS X v10.0 and later.
cmPreview1Tag

Available in Mac OS X v10.0 and later.
cmPreview2Tag

Available in Mac OS X v10.0 and later.
cmProfileDescriptionTag

Available in Mac OS X v10.0 and later.
cmProfileSequenceDescTag

Available in Mac OS X v10.0 and later.
cmPS2CRD0Tag

Available in Mac OS X v10.0 and later.
cmPS2CRD1Tag

Available in Mac OS X v10.0 and later.
cmPS2CRD2Tag

Available in Mac OS X v10.0 and later.
cmPS2CRD3Tag

Available in Mac OS X v10.0 and later.
cmPS2CSATag

Available in Mac OS X v10.0 and later.
cmPS2RenderingIntentTag

Available in Mac OS X v10.0 and later.
cmRedColorantTag

Available in Mac OS X v10.0 and later.
cmRedTRCTag

Available in Mac OS X v10.0 and later.
cmScreeningDescTag

Available in Mac OS X v10.0 and later.
cmScreeningTag

Available in Mac OS X v10.0 and later.
cmTechnologyTag

Available in Mac OS X v10.0 and later.
cmUcrBgTag

Available in Mac OS X v10.0 and later.
cmViewingConditionsDescTag

Available in Mac OS X v10.0 and later.
cmViewingConditionsTag

Available in Mac OS X v10.0 and later.*/
enum {
   cmAToB0Tag = 'A2B0',
   cmAToB1Tag = 'A2B1',
   cmAToB2Tag = 'A2B2',
   cmBlueColorantTag = 'bXYZ',
   cmBlueTRCTag = 'bTRC',
   cmBToA0Tag = 'B2A0',
   cmBToA1Tag = 'B2A1',
   cmBToA2Tag = 'B2A2',
   cmCalibrationDateTimeTag = 'calt',
   cmChromaticAdaptationTag = 'chad',
   cmCharTargetTag = 'targ',
   cmCopyrightTag = 'cprt',
   cmDeviceMfgDescTag = 'dmnd',
   cmDeviceModelDescTag = 'dmdd',
   cmGamutTag = 'gamt',
   cmGrayTRCTag = 'kTRC',
   cmGreenColorantTag = 'gXYZ',
   cmGreenTRCTag = 'gTRC',
   cmLuminanceTag = 'lumi',
   cmMeasurementTag = 'meas',
   cmMediaBlackPointTag = 'bkpt',
   cmMediaWhitePointTag = 'wtpt',
   cmNamedColorTag = 'ncol',
   cmNamedColor2Tag = 'ncl2',
   cmPreview0Tag = 'pre0',
   cmPreview1Tag = 'pre1',
   cmPreview2Tag = 'pre2',
   cmProfileDescriptionTag = 'desc',
   cmProfileSequenceDescTag = 'pseq',
   cmPS2CRD0Tag = 'psd0',
   cmPS2CRD1Tag = 'psd1',
   cmPS2CRD2Tag = 'psd2',
   cmPS2CRD3Tag = 'psd3',
   cmPS2CSATag = 'ps2s',
   cmPS2RenderingIntentTag = 'ps2i',
   cmRedColorantTag = 'rXYZ',
   cmRedTRCTag = 'rTRC',
   cmScreeningDescTag = 'scrd',
   cmScreeningTag = 'scrn',
   cmTechnologyTag = 'tech',
   cmUcrBgTag = 'bfd ',
   cmViewingConditionsDescTag = 'vued',
   cmViewingConditionsTag = 'view'
};

/*Color Space Signatures

Define four-character-sequences associated with color spaces.

enum {
   cmXYZData = 'XYZ ',
   cmLabData = 'Lab ',
   cmLuvData = 'Luv ',
   cmYCbCrData = 'YCbr',
   cmYxyData = 'Yxy ',
   cmRGBData = 'RGB ',
   cmSRGBData = 'sRGB',
   cmGrayData = 'GRAY',
   cmHSVData = 'HSV ',
   cmHLSData = 'HLS ',
   cmCMYKData = 'CMYK',
   cmCMYData = 'CMY ',
   cmMCH5Data = 'MCH5',
   cmMCH6Data = 'MCH6',
   cmMCH7Data = 'MCH7',
   cmMCH8Data = 'MCH8',
   cm3CLRData = '3CLR',
   cm4CLRData = '4CLR',
   cm5CLRData = '5CLR',
   cm6CLRData = '6CLR',
   cm7CLRData = '7CLR',
   cm8CLRData = '8CLR',
   cm9CLRData = '9CLR',
   cm10CLRData = 'ACLR',
   cm11CLRData = 'BCLR',
   cm12CLRData = 'CCLR',
   cm13CLRData = 'DCLR',
   cm14CLRData = 'ECLR',
   cm15CLRData = 'FCLR',
   cmNamedData = 'NAME'
};
Constants
cmXYZData

The XYZ data color space.

Available in Mac OS X v10.0 and later.
cmLabData

The L*a*b* data color space.

Available in Mac OS X v10.0 and later.
cmLuvData

The L*u*v* data color space.

Available in Mac OS X v10.0 and later.
cmYCbCrData

Available in Mac OS X v10.1 and later.
cmYxyData

The Yxy data color space.

Available in Mac OS X v10.0 and later.
cmRGBData

The RGB data color space.

Available in Mac OS X v10.0 and later.
cmSRGBData

Available in Mac OS X v10.0 and later.
cmGrayData

The Gray data color space.

Available in Mac OS X v10.0 and later.
cmHSVData

The HSV data color space.

Available in Mac OS X v10.0 and later.
cmHLSData

The HLS data color space.

Available in Mac OS X v10.0 and later.
cmCMYKData

The CMYK data color space.

Available in Mac OS X v10.0 and later.
cmCMYData

The CMY data color space.

Available in Mac OS X v10.0 and later.
cmMCH5Data

The five-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCH6Data

The six-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCH7Data

The seven-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cmMCH8Data

The eight-channel multichannel (HiFi) data color space.

Available in Mac OS X v10.0 and later.
cm3CLRData

Available in Mac OS X v10.0 and later.
cm4CLRData

Available in Mac OS X v10.0 and later.
cm5CLRData

Available in Mac OS X v10.0 and later.
cm6CLRData

Available in Mac OS X v10.0 and later.
cm7CLRData

Available in Mac OS X v10.0 and later.
cm8CLRData

Available in Mac OS X v10.0 and later.
cm9CLRData

Available in Mac OS X v10.1 and later.
cm10CLRData

Available in Mac OS X v10.1 and later.
cm11CLRData

Available in Mac OS X v10.1 and later.
cm12CLRData

Available in Mac OS X v10.1 and later.
cm13CLRData

Available in Mac OS X v10.1 and later.
cm14CLRData

Available in Mac OS X v10.1 and later.
cm15CLRData

Available in Mac OS X v10.1 and later.
cmNamedData

Available in Mac OS X v10.0 and later.
Discussion

A ColorSync profile header contains a dataColorSpace field that carries the signature of the data color space in which the color values in an image using the profile are expressed. This enumeration defines the signatures for the color spaces supported by ColorSync for version 2.x profiles.*/


enum {
   cmXYZData = 'XYZ ',
   cmLabData = 'Lab ',
   cmLuvData = 'Luv ',
   cmYCbCrData = 'YCbr',
   cmYxyData = 'Yxy ',
   cmRGBData = 'RGB ',
   cmSRGBData = 'sRGB',
   cmGrayData = 'GRAY',
   cmHSVData = 'HSV ',
   cmHLSData = 'HLS ',
   cmCMYKData = 'CMYK',
   cmCMYData = 'CMY ',
   cmMCH5Data = 'MCH5',
   cmMCH6Data = 'MCH6',
   cmMCH7Data = 'MCH7',
   cmMCH8Data = 'MCH8',
   cm3CLRData = '3CLR',
   cm4CLRData = '4CLR',
   cm5CLRData = '5CLR',
   cm6CLRData = '6CLR',
   cm7CLRData = '7CLR',
   cm8CLRData = '8CLR',
   cm9CLRData = '9CLR',
   cm10CLRData = 'ACLR',
   cm11CLRData = 'BCLR',
   cm12CLRData = 'CCLR',
   cm13CLRData = 'DCLR',
   cm14CLRData = 'ECLR',
   cm15CLRData = 'FCLR',
   cmNamedData = 'NAME'
};



#endif
