#ifndef CFNUMBER_H
#define CFNUMBER_H


#include <CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*Number Types

Flags used by CFNumber to indicate the data type of a value.

enum CFNumberType {
   kCFNumberSInt8Type = 1,
   kCFNumberSInt16Type = 2,
   kCFNumberSInt32Type = 3,
   kCFNumberSInt64Type = 4,
   kCFNumberFloat32Type = 5,
   kCFNumberFloat64Type = 6,
   kCFNumberCharType = 7,
   kCFNumberShortType = 8,
   kCFNumberIntType = 9,
   kCFNumberLongType = 10,
   kCFNumberLongLongType = 11,
   kCFNumberFloatType = 12,
   kCFNumberDoubleType = 13,
   kCFNumberCFIndexType = 14,
   kCFNumberMaxType = 14
};
typedef enum CFNumberType CFNumberType;
Constants
kCFNumberSInt8Type

Eight-bit, signed integer. The SInt8 data type is defined in MacTypes.h.

Available in Mac OS X v10.0 and later.
kCFNumberSInt16Type

Sixteen-bit, signed integer. The SInt16 data type is defined in MacTypes.h.

Available in Mac OS X v10.0 and later.
kCFNumberSInt32Type

Thirty-two-bit, signed integer. The SInt32 data type is defined in MacTypes.h.

Available in Mac OS X v10.0 and later.
kCFNumberSInt64Type

Sixty-four-bit, signed integer. The SInt64 data type is defined in MacTypes.h.

Available in Mac OS X v10.0 and later.
kCFNumberFloat32Type

Thirty-two-bit real. The Float32 data type is defined in MacTypes.h.

Available in Mac OS X v10.0 and later.
kCFNumberFloat64Type

Sixty-four-bit real. The Float64 data type is defined in MacTypes.h and conforms to the 64-bit IEEE 754 standard.

Available in Mac OS X v10.0 and later.
kCFNumberCharType

Basic C char type.

Available in Mac OS X v10.0 and later.
kCFNumberShortType

Basic C short type.

Available in Mac OS X v10.0 and later.
kCFNumberIntType

Basic C int type.

Available in Mac OS X v10.0 and later.
kCFNumberLongType

Basic C long type.

Available in Mac OS X v10.0 and later.
kCFNumberLongLongType

Basic C long long type.

Available in Mac OS X v10.0 and later.
kCFNumberFloatType

Basic C float type.

Available in Mac OS X v10.0 and later.
kCFNumberDoubleType

Basic C double type.

Available in Mac OS X v10.0 and later.
kCFNumberCFIndexType

CFIndex value.

Available in Mac OS X v10.0 and later.
kCFNumberMaxType

Same as kCFNumberCFIndexType.

Available in Mac OS X v10.0 and later.
Discussion

The type specified in the call to CFNumberCreate is not necessarily preserved when creating a new CFNumber object. A CFNumber object uses whatever internal storage type the creation function deems appropriate. Use the CFNumberGetType function to find out what type the CFNumber object used to store your value.*/
enum CFNumberType {
   kCFNumberSInt8Type = 1,
   kCFNumberSInt16Type = 2,
   kCFNumberSInt32Type = 3,
   kCFNumberSInt64Type = 4,
   kCFNumberFloat32Type = 5,
   kCFNumberFloat64Type = 6,
   kCFNumberCharType = 7,
   kCFNumberShortType = 8,
   kCFNumberIntType = 9,
   kCFNumberLongType = 10,
   kCFNumberLongLongType = 11,
   kCFNumberFloatType = 12,
   kCFNumberDoubleType = 13,
   kCFNumberCFIndexType = 14,
   kCFNumberMaxType = 14
};
typedef enum CFNumberType CFNumberType;

/*CFNumberRef

A reference to a CFNumber object.

typedef const struct __CFNumber *CFNumberRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFNumber *CFNumberRef;

/*CFBooleanRef

A reference to a CFBoolean object.

typedef const struct __CFBoolean *CFBooleanRef;
Discussion

CFBoolean objects are used to wrap boolean values for use in Core Foundation property lists and collection types. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFBoolean *CFBooleanRef;


/*Boolean Values

CFBoolean evaluates to either true or false values where kCFBooleanTrue is the true, and kCFBooleanFalse is the false value. 

const CFBooleanRef kCFBooleanTrue;
const CFBooleanRef kCFBooleanFalse;
Constants
kCFBooleanTrue

Boolean true value.

Available in Mac OS X v10.0 and later.
kCFBooleanFalse

Boolean false value.

Available in Mac OS X v10.0 and later.*/
const CFBooleanRef kCFBooleanTrue;
const CFBooleanRef kCFBooleanFalse;

/*CFBooleanGetValue

Returns the value of a CFBoolean object as a standard C type Boolean.

Boolean CFBooleanGetValue (
   CFBooleanRef boolean
);
Parameters
boolean

The boolean to examine. 
Return Value

The value of boolean. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFBooleanGetValue (
   CFBooleanRef boolean
);

/*CFNumberCreate

Creates a CFNumber object using a specified value.

CFNumberRef CFNumberCreate (
   CFAllocatorRef allocator,
   CFNumberType theType,
   const void *valuePtr
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the default allocator.
theType

A constant that specifies the data type of the value to convert. See Number Types for a list of possible values. 
valuePtr

A pointer to the value for the returned number object.
Return Value

A new number with the value specified by valuePtr. Ownership follows the Create Rule.
Discussion

The theType parameter is not necessarily preserved when creating a new CFNumber object. The CFNumber object will be created using whatever internal storage type the creation function deems appropriate. Use the function CFNumberGetType to find out what type the CFNumber object used to store your value. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFNumberRef CFNumberCreate (
   CFAllocatorRef allocator,
   CFNumberType theType,
   const void *valuePtr
);

/*CFBooleanGetTypeID

Returns the Core Foundation type identifier for the CFBoolean opaque type.

CFTypeID CFBooleanGetTypeID ();
Return Value

The Core Foundation type identifier for CFBoolean opaque type. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFBooleanGetTypeID ();

/*CFNumberGetValue

Obtains the value of a CFNumber object cast to a specified type.

Boolean CFNumberGetValue (
   CFNumberRef number,
   CFNumberType theType,
   void *valuePtr
);
Parameters
number

The CFNumber object to examine. 
theType

A constant that specifies the data type to return. See Number Types for a list of possible values. 
valuePtr

On return, contains the value of number.
Return Value

true if the operation was successful, otherwise false. 
Discussion

If the argument type differs from the return type, and the conversion is lossy or the return value is out of range, then this function passes back an approximate value in valuePtr and returns false. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
Boolean CFNumberGetValue (
   CFNumberRef number,
   CFNumberType theType,
   void *valuePtr
);

/*CFNumberGetTypeID

Returns the type identifier for the CFNumber opaque type.

CFTypeID CFNumberGetTypeID ();
Return Value

The type identifier for the CFNumber opaque type.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/

CFTypeID CFNumberGetTypeID ();

#ifdef __cplusplus
}
#endif
#endif