#ifndef CGAFFINETRANSFORM_H
#define CGAFFINETRANSFORM_H


#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGGeometry.h>



/*CGAffineTransform

Defines an affine transformation matrix.

struct CGAffineTransform {
   float a;
   float b;
   float c;
   float d;
   float tx;
   float ty;
};
typedef struct CGAffineTransform CGAffineTransform;
Fields
a

The entry at position [1,1] in the matrix.
b

The entry at position [1,2] in the matrix.
c

The entry at position [2,1] in the matrix.
d

The entry at position [2,2] in the matrix.
tx

The entry at position [3,1] in the matrix.
ty

The entry at position [3,2] in the matrix.
Discussion

In Quartz 2D, an affine transformation matrix is used to rotate, scale, translate, or skew the objects you draw in a graphics context. The CFAffineTransform type provides functions for creating, concatenating, and applying affine transformations.

In Quartz, affine transforms are represented by a 3 by 3 matrix:




Conceptually, a Quartz affine transform multiplies a row vector representing each point (x,y) in your drawing by this matrix, producing a vector that represents the corresponding point (x’,y’):




Given the 3 by 3 matrix, Quartz uses the following equations to transform a point (x, y) in one coordinate system into a resultant point (x’,y’) in another coordinate system.




The matrix thereby “links” two coordinate systems—it specifies how points in one coordinate system map to points in another.

Note that you do not typically need to create affine transforms directly. If you want only to draw an object that is scaled or rotated, for example, it is not necessary to construct an affine transform to do so. The most direct way to manipulate your drawing—whether by movement, scaling, or rotation—is to call the functions CGContextTranslateCTM, CGContextScaleCTM, or CGContextRotateCTM, respectively. You should generally only create an affine transform if you want to reuse it later.
Availability
Available in Mac OS X v10.0 and later.*/
struct CGAffineTransform {
   float a;
   float b;
   float c;
   float d;
   float tx;
   float ty;
};
typedef struct CGAffineTransform CGAffineTransform;

/*GAffineTransformIdentity

Specifies the identity transform.

const CGAffineTransform CGAffineTransformIdentity;
Discussion

This constant specifies the following matrix:*/

const CGAffineTransform CGAffineTransformIdentity;


//functions
/*CGAffineTransformMake

Returns an affine transformation matrix constructed from values you provide. 

CGAffineTransform CGAffineTransformMake (
   float a,
   float b,
   float c,
   float d,
   float tx,
   float ty
);
Parameters
a

The value at position [1,1] in the matrix.
b

The value at position [1,2] in the matrix.
c

The value at position [2,1] in the matrix.
d

The value at position [2,2] in the matrix.
tx

The value at position [3,1] in the matrix.
ty

The value at position [3,2] in the matrix.
Return Value

A new affine transform matrix constructed from the values you specify.
Discussion

This function creates a CGAffineTransform structure that represents a new affine transformation matrix, which you can use (and reuse, if you want) to transform a coordinate system. The matrix takes the following form:




If you want only to transform an object to be drawn, it is not necessary to construct an affine transform to do so. The most direct way to transform your drawing is by calling the appropriate CGContext function to adjust the current transformation matrix.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformMake (
   float a,
   float b,
   float c,
   float d,
   float tx,
   float ty
);

/*CGAffineTransformScale

Returns an affine transformation matrix constructed by scaling an existing affine transform.

CGAffineTransform CGAffineTransformScale (
   CGAffineTransform t,
   float sx,
   float sy
);
Parameters
t

An existing affine transform. 
sx

The value by which to scale x values of the affine transform.
sy

The value by which to scale y values of the affine transform.
Return Value

A new affine transformation matrix.
Discussion

You use this function to create a new affine transformation matrix by adding scaling values to an existing affine transform. The resulting structure represents a new affine transform, which you can use (and reuse, if you want) to scale a coordinate system. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformScale (
   CGAffineTransform t,
   float sx,
   float sy
);

/*CGAffineTransformRotate

Returns an affine transformation matrix constructed by rotating an existing affine transform.

CGAffineTransform CGAffineTransformRotate (
   CGAffineTransform t,
   float angle
);
Parameters
t

An existing affine transform. 
angle

The angle, in radians, by which to rotate the affine transform.
Return Value

A new affine transformation matrix.
Discussion

You use this function to create a new affine transformation matrix by adding a rotation value to an existing affine transform. The resulting structure represents a new affine transform, which you can use (and reuse, if you want) to rotate a coordinate system. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/

CGAffineTransform CGAffineTransformRotate (
   CGAffineTransform t,
   float angle
);

/*CGAffineTransformInvert

Returns an affine transformation matrix constructed by inverting an existing affine transform.

CGAffineTransform CGAffineTransformInvert (
   CGAffineTransform t
);
Parameters
t

An existing affine transform. 
Return Value

A new affine transformation matrix. If the affine transform passed in parameter t cannot be inverted, Quartz returns the affine transform unchanged.
Discussion

You can invert a matrix to produce an inverse matrix. Inversion is generally used to provide reverse transformation of points within transformed objects. Given the coordinates (x,y), which have been transformed by a given matrix to new coordinates (x’,y’), transforming the coordinates (x’,y’) by the inverse matrix produces the original coordinates (x,y).
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGAffineTransform.h*/
CGAffineTransform CGAffineTransformInvert (
   CGAffineTransform t
);




#endif
