#ifndef ICONS_H
#define ICONS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif

#ifndef CGCONTEXT_H
#include <CoreGraphics/CGContext.h>
#endif

#include <HYS/HIServices/Icons.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif


#ifdef __cplusplus
extern "C" {
#endif

/*IconSuiteRef

Defines a reference to an icon suite.

typedef Handle IconSuiteRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle IconSuiteRef;

/*Standard Finder Icon Constants

Identify standard Finder icons.

enum {
   kClipboardIcon = 'CLIP',
   kClippingUnknownTypeIcon = 'clpu',
   kClippingPictureTypeIcon = 'clpp',
   kClippingTextTypeIcon = 'clpt',
   kClippingSoundTypeIcon = 'clps',
   kDesktopIcon = 'desk',
   kFinderIcon = 'FNDR',
   kFontSuitcaseIcon = 'FFIL',
   kFullTrashIcon = 'ftrh',
   kGenericApplicationIcon = 'APPL',
   kGenericCDROMIcon = 'cddr',
   kGenericControlPanelIcon = 'APPC',
   kGenericControlStripModuleIcon = 'sdev',
   kGenericComponentIcon = 'thng',
   kGenericDeskAccessoryIcon = 'APPD',
   kGenericDocumentIcon = 'docu',
   kGenericEditionFileIcon = 'edtf',
   kGenericExtensionIcon = 'INIT',
   kGenericFileServerIcon = 'srvr',
   kGenericFontIcon = 'ffil',
   kGenericFontScalerIcon = 'sclr',
   kGenericFloppyIcon = 'flpy',
   kGenericHardDiskIcon = 'hdsk',
   kGenericIDiskIcon = 'idsk',
   kGenericRemovableMediaIcon = 'rmov',
   kGenericMoverObjectIcon = 'movr',
   kGenericPCCardIcon = 'pcmc',
   kGenericPreferencesIcon = 'pref',
   kGenericQueryDocumentIcon = 'qery',
   kGenericRAMDiskIcon = 'ramd',
   kGenericSharedLibaryIcon = 'shlb',
   kGenericStationeryIcon = 'sdoc',
   kGenericSuitcaseIcon = 'suit',
   kGenericURLIcon = 'gurl',
   kGenericWORMIcon = 'worm',
   kInternationalResourcesIcon = 'ifil',
   kKeyboardLayoutIcon = 'kfil',
   kSoundFileIcon = 'sfil',
   kSystemSuitcaseIcon = 'zsys',
   kTrashIcon = 'trsh',
   kTrueTypeFontIcon = 'tfil',
   kTrueTypeFlatFontIcon = 'sfnt',
   kTrueTypeMultiFlatFontIcon = 'ttcf',
   kUserIDiskIcon = 'udsk',
   kUnknownFSObjectIcon = 'unfs',
   kInternationResourcesIcon = kInternationalResourcesIcon
};
Discussion

Icon Services defines constants for a number of standard Finder icons. You can pass one of these constants in the iconType parameter of the function GetIconRef, for example.*/
enum {
   kClipboardIcon = 'CLIP',
   kClippingUnknownTypeIcon = 'clpu',
   kClippingPictureTypeIcon = 'clpp',
   kClippingTextTypeIcon = 'clpt',
   kClippingSoundTypeIcon = 'clps',
   kDesktopIcon = 'desk',
   kFinderIcon = 'FNDR',
   kFontSuitcaseIcon = 'FFIL',
   kFullTrashIcon = 'ftrh',
   kGenericApplicationIcon = 'APPL',
   kGenericCDROMIcon = 'cddr',
   kGenericControlPanelIcon = 'APPC',
   kGenericControlStripModuleIcon = 'sdev',
   kGenericComponentIcon = 'thng',
   kGenericDeskAccessoryIcon = 'APPD',
   kGenericDocumentIcon = 'docu',
   kGenericEditionFileIcon = 'edtf',
   kGenericExtensionIcon = 'INIT',
   kGenericFileServerIcon = 'srvr',
   kGenericFontIcon = 'ffil',
   kGenericFontScalerIcon = 'sclr',
   kGenericFloppyIcon = 'flpy',
   kGenericHardDiskIcon = 'hdsk',
   kGenericIDiskIcon = 'idsk',
   kGenericRemovableMediaIcon = 'rmov',
   kGenericMoverObjectIcon = 'movr',
   kGenericPCCardIcon = 'pcmc',
   kGenericPreferencesIcon = 'pref',
   kGenericQueryDocumentIcon = 'qery',
   kGenericRAMDiskIcon = 'ramd',
   kGenericSharedLibaryIcon = 'shlb',
   kGenericStationeryIcon = 'sdoc',
   kGenericSuitcaseIcon = 'suit',
   kGenericURLIcon = 'gurl',
   kGenericWORMIcon = 'worm',
   kInternationalResourcesIcon = 'ifil',
   kKeyboardLayoutIcon = 'kfil',
   kSoundFileIcon = 'sfil',
   kSystemSuitcaseIcon = 'zsys',
   kTrashIcon = 'trsh',
   kTrueTypeFontIcon = 'tfil',
   kTrueTypeFlatFontIcon = 'sfnt',
   kTrueTypeMultiFlatFontIcon = 'ttcf',
   kUserIDiskIcon = 'udsk',
   kUnknownFSObjectIcon = 'unfs',
   kInternationResourcesIcon = kInternationalResourcesIcon
};


/*System Icon Constant

Defines a creator type for all system–defined icons.

enum {
   kSystemIconsCreator = 'macs'
};
Discussion

You can use the kSystemIconsCreator constant to obtain System icons that are not associated with a file, such as the help icon.*/
enum {
   kSystemIconsCreator = 'macs'
};

/*Networking Icon Constants

Identify standard networking icons.

enum {
   kAppleTalkIcon = 'atlk',
   kAppleTalkZoneIcon = 'atzn',
   kAFPServerIcon = 'afps',
   kFTPServerIcon = 'ftps',
   kHTTPServerIcon = 'htps',
   kGenericNetworkIcon = 'gnet',
   kIPFileServerIcon = 'isrv'
};
Discussion

Icon Services defines constants for a number of standard networking icons. You can pass one of these constants in the iconType parameter of the function GetIconRef, for example.*/
enum {
   kAppleTalkIcon = 'atlk',
   kAppleTalkZoneIcon = 'atzn',
   kAFPServerIcon = 'afps',
   kFTPServerIcon = 'ftps',
   kHTTPServerIcon = 'htps',
   kGenericNetworkIcon = 'gnet',
   kIPFileServerIcon = 'isrv'
};

/*Icon Alignment Constants

Define constants that allow you to specify how to align an icon within its rectangle.

enum {
   kAlignNone = 0x00,
   kAlignVerticalCenter = 0x01,
   kAlignTop = 0x02,
   kAlignBottom = 0x03,
   kAlignHorizontalCenter = 0x04,
   kAlignAbsoluteCenter = kAlignVerticalCenter | kAlignHorizontalCenter,
   kAlignCenterTop = kAlignTop | kAlignHorizontalCenter,
   kAlignCenterBottom = kAlignBottom | kAlignHorizontalCenter,
   kAlignLeft = 0x08,
   kAlignCenterLeft = kAlignVerticalCenter | kAlignLeft,
   kAlignTopLeft = kAlignTop | kAlignLeft,
   kAlignBottomLeft = kAlignBottom | kAlignLeft,
   kAlignRight = 0x0C,
   kAlignCenterRight = kAlignVerticalCenter | kAlignRight,
   kAlignTopRight = kAlignTop | kAlignRight,
   kAlignBottomRight = kAlignBottom | kAlignRight
};
typedef SInt16 IconAlignmentType;
Constants
kAlignNone

Use this value if you do not wish to specify a particular alignment.

Available in Mac OS X v10.0 and later.
kAlignVerticalCenter

Use this value to center the icon vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTop

Use this value to top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottom

Use this value to bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignHorizontalCenter

Use this value to center the icon horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignAbsoluteCenter

Use this value to center the icon horizontally and vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterTop

Use this value to top align the icon and center it horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterBottom

Use this value to bottom align the icon and center it horizontally within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignLeft

Use this value to left align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterLeft

Use this value to left align the icon and center it vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTopLeft

Use this value to left and top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottomLeft

Use this value to left and bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignRight

Use this value to right align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignCenterRight

Use this value to right align the icon and center it vertically within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignTopRight

Use this value to right and top align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
kAlignBottomRight

Use this value to right and bottom align the icon within the rectangle.

Available in Mac OS X v10.0 and later.
Discussion

Icon Services and Utilities functions use the IconAlignmentType constants to determine how an icon is aligned within its bounding rectangle.*/
enum {
   kAlignNone = 0x00,
   kAlignVerticalCenter = 0x01,
   kAlignTop = 0x02,
   kAlignBottom = 0x03,
   kAlignHorizontalCenter = 0x04,
   kAlignAbsoluteCenter = kAlignVerticalCenter | kAlignHorizontalCenter,
   kAlignCenterTop = kAlignTop | kAlignHorizontalCenter,
   kAlignCenterBottom = kAlignBottom | kAlignHorizontalCenter,
   kAlignLeft = 0x08,
   kAlignCenterLeft = kAlignVerticalCenter | kAlignLeft,
   kAlignTopLeft = kAlignTop | kAlignLeft,
   kAlignBottomLeft = kAlignBottom | kAlignLeft,
   kAlignRight = 0x0C,
   kAlignCenterRight = kAlignVerticalCenter | kAlignRight,
   kAlignTopRight = kAlignTop | kAlignRight,
   kAlignBottomRight = kAlignBottom | kAlignRight
};
typedef SInt16 IconAlignmentType;

/*Icon Transformation Constants

Define values that Icon Services uses to report how an icon has been transformed after you call the function GetIconRefVariant.

enum {
   kTransformNone = 0x00,
   kTransformDisabled = 0x01,
   kTransformOffline = 0x02,
   kTransformOpen = 0x03,
   kTransformLabel1 = 0x0100,
   kTransformLabel2 = 0x0200,
   kTransformLabel3 = 0x0300,
   kTransformLabel4 = 0x0400,
   kTransformLabel5 = 0x0500,
   kTransformLabel6 = 0x0600,
   kTransformLabel7 = 0x0700,
   kTransformSelected = 0x4000,
   kTransformSelectedDisabled = kTransformSelected | kTransformDisabled,
   kTransformSelectedOffline = kTransformSelected | kTransformOffline,
   kTransformSelectedOpen = kTransformSelected | kTransformOpen
};
typedef SInt16 IconTransformType;
Discussion

The functions PlotIconIDPlotIconMethod, PlotIconHandle, PlotCIconHandle, PlotIconSuite, LoadIconCache and PlotSICNHandle use these constants to specify how an icon should be modified, if at all, when plotted.*/
enum {
   kTransformNone = 0x00,
   kTransformDisabled = 0x01,
   kTransformOffline = 0x02,
   kTransformOpen = 0x03,
   kTransformLabel1 = 0x0100,
   kTransformLabel2 = 0x0200,
   kTransformLabel3 = 0x0300,
   kTransformLabel4 = 0x0400,
   kTransformLabel5 = 0x0500,
   kTransformLabel6 = 0x0600,
   kTransformLabel7 = 0x0700,
   kTransformSelected = 0x4000,
   kTransformSelectedDisabled = kTransformSelected | kTransformDisabled,
   kTransformSelectedOffline = kTransformSelected | kTransformOffline,
   kTransformSelectedOpen = kTransformSelected | kTransformOpen
};
typedef SInt16 IconTransformType;

/*IconRef

Defines an icon reference.

typedef struct OpaqueIconRef * IconRef;
Discussion

An IconRef is a 32–bit values identifying cached icon data. IconRef 0 is invalid.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueIconRef * IconRef;


//function

/*GetIconRef

Provides an IconRef for an icon in the desktop database or for a registered icon.

OSErr GetIconRef (
   SInt16 vRefNum,
   OSType creator,
   OSType iconType,
   IconRef * theIconRef
);
Parameters
vRefNum

The volume where Icon Services should start to search for the desired icon. Pass the kOnSystemDisk constant if you are not sure which value to specify in this parameter.
creator

The creator code of the desired icon.
iconType

The type code of the desired icon.
theIconRef

On return, a pointer to the desired icon data.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

Icon Services defines constants for commonly-used system icons. You can pass one of these constants in the iconType parameter if you specify kSystemIconsCreator in the creator parameter. See “Folder Icon Constants” for a list of these constants.

Calling the GetIconRef function increments the reference count of the IconRef.

Remember to call the function ReleaseIconRef when you are done with an IconRef.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr GetIconRef (
   SInt16 vRefNum,
   OSType creator,
   OSType iconType,
   IconRef * theIconRef
);

/*ReleaseIconRef

Decrements the reference count for an IconRef.

OSErr ReleaseIconRef (
   IconRef theIconRef
);
Parameters
theIconRef

An IconRef whose reference count you wish to decrement.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

When an IconRef’s reference count reaches 0, all memory allocated for the IconRef is marked as disposable. Any subsequent attempt to use the IconRef returns a result code of - 2580 (invalidIconRefErr).
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr ReleaseIconRef (
   IconRef theIconRef
);

/*PlotIconRefInContext

Plots an IconRef using Quartz.

OSStatus PlotIconRefInContext (
   CGContextRef inContext,
   const CGRect * inRect,
   IconAlignmentType inAlign,
   IconTransformType inTransform,
   const RGBColor * inLabelColor,
   PlotIconRefFlags inFlags,
   IconRef inIconRef
);
Parameters
inContext

The graphics context to use. 
inRect

A pointer to the rectangle to plot the icon in. 
inAlign

The icon alignment. See “Icon Alignment Constants”.
inTransform

The icon transform. See “Icon Transformation Constants”.
inLabelColor

A pointer to the icon label color. 
inFlags

The drawing flags to use; this is usually kPlotIconRefNormalFlags.
inIconRef

The IconRef to plot.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
Icons.h*/

OSStatus PlotIconRefInContext (
   CGContextRef inContext,
   const CGRect * inRect,
   IconAlignmentType inAlign,
   IconTransformType inTransform,
   const RGBColor * inLabelColor,
   PlotIconRefFlags inFlags,
   IconRef inIconRef
);

/*SetIconFamilyData

Provides new raw icon data for an individual element of an icon family.

OSErr SetIconFamilyData (
   IconFamilyHandle iconFamily,
   OSType iconType,
   Handle h
);
Parameters
iconFamily

A handle to an iconFamily data structure to be used as the target.
iconType

The format of the icon data you provide.You may specify one of the icon types (as defined in IconStorage.h in the CoreServices/OSServices framework) or 'PICT' in this parameter. For a thumbnail icon, for example, you specify kThumbnail32BitData in this parameter. For a thumbnail mask, you specify kThumbnail8BitMask.
h

A handle to the icon data you provide. For a thumbnail icon, the handle contains raw image data in the form of 128x128, four bytes per pixel, RGB data. For a thumbnail mask, the data is in the same format except that it is one byte per pixel.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h 
SetSuiteLabel*/
OSErr SetIconFamilyData (
   IconFamilyHandle iconFamily,
   OSType iconType,
   Handle h
);

/*NewIconSuite

Gets a handle to an empty icon suite. 

OSErr NewIconSuite (
   IconSuiteRef * theIconSuite
);
Parameters
theIconSuite

On return, a pointer to a handle to a new, empty icon suite. Use the AddIconToSuite function to add handles to icon data.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

When you create an icon suite using this function, it sets the default label for the suite to none. To set a new default label for an icon suite, use the SetSuiteLabel function. NewIconSuite allocates the memory for the icon suite handle. To release the memory occupied by an icon suite, you must use the DisposeIconSuite function. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr NewIconSuite (
   IconSuiteRef * theIconSuite
);


/*AddIconToSuite

Adds an icon to an icon suite.

OSErr AddIconToSuite (
   Handle theIconData,
   IconSuiteRef theSuite,
   ResType theType
);
Parameters
theIconData

A handle to the data for the new icon to be added to the icon suite. You can obtain a handle to icon data using various functions, such as GetIcon or GetResource.

The handle to the icon data is added at the location reserved for icon data of the type specified by theType. If the icon suite already includes a handle to icon data for that type, this function replaces the handle to the old data without disposing of it. In this case you may want to call the GetIconFromSuite function first to obtain the old handle so that you can dispose of it. 

The handles that you add to the suite do not have to be associated with a resource fork. For example, your application might get icon data from the desktop database rather than reading it from a resource, or your application might read icon data from a resource and then detach it.
theSuite

A handle to the icon suite to which to add the icon.
theType

The resource type of the new icon. The resource type should be that of an icon family member.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

This function is most often used to read icons into an empty icon suite created with the NewIconSuite function. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr AddIconToSuite (
   Handle theIconData,
   IconSuiteRef theSuite,
   ResType theType
);

#ifdef __cplusplus
}


#endif

#endif