#ifndef EVENTS_H
#define EVENTS_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef QUICKDRAW_H
//#include <QD/Quickdraw.h>//hys
#endif


#include <HYS/HIToolbox/Events.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*KeyMap

Contains information about the current state of the keyboard, including the keypad, if any.

struct KeyMap {
   char map[16];
};
typedef struct KeyMap KeyMap;
Fields
map
Discussion

The type KeyMap is used in GetKeys to return the current state of the keyboard, including the keypad, if any. The KeyMap type is interpreted as an array of 128 elements, each having a Boolean value. Each key on the keyboard or keypad corresponds to an element in the KeyMap array. The index for a particular key is the same as the key’s virtual key code minus 1. For example, the key with virtual key code 38 (the “J” key on the Apple Keyboard II) is the 38th element in the returned array. A KeyMap element is true if the corresponding key is down and false if it isn’t. The maximum number of keys that can be down simultaneously is two character keys plus any combination of the five modifier keys. 
Availability
Available in Mac OS X v10.0 and later.*/
#ifndef TARGET_API_MAC_CARBON
struct KeyMap {
   char map[16];
};
typedef struct KeyMap KeyMap;
#else
typedef int KeyMap[16];//hys
#endif


/*resumeFlag

Indicates a resume event.

enum {
   resumeFlag = 1
};
Constants
resumeFlag

Flag for a resume event.

Available in Mac OS X v10.0 and later.*/

enum {
   resumeFlag = 1
};


/*mouseMovedMessage


enum {
   mouseMovedMessage = 0x00FA,
   suspendResumeMessage = 0x0001
};
Constants
mouseMovedMessage

The message code indicating the mouse-moved operating-system event.

Available in Mac OS X v10.0 and later.
suspendResumeMessage

The message code indicating a suspend or resume operating-system event.

Available in Mac OS X v10.0 and later.*/
enum {
   mouseMovedMessage = 0x00FA,
   suspendResumeMessage = 0x0001
};


/*Event Kind Constants

Define event kinds. 

enum {
   nullEvent = 0,
   mouseDown = 1,
   mouseUp = 2,
   keyDown = 3,
   keyUp = 4,
   autoKey = 5,
   updateEvt = 6,
   diskEvt = 7,
   activateEvt = 8,
   osEvt = 15,
   kHighLevelEvent = 23
};
typedef UInt16 EventKind;
Constants
nullEvent

The event code indicating that there are no other pending events.

Available in Mac OS X v10.0 and later.
mouseDown

The event code indicating that the mouse button has been pressed.

Available in Mac OS X v10.0 and later.
mouseUp

The event code indicating that the mouse button has been released.

Available in Mac OS X v10.0 and later.
keyDown

The event code indicating that a key has been pressed.

Available in Mac OS X v10.0 and later.
keyUp

The event code indicating that a key has been released.

Available in Mac OS X v10.0 and later.
autoKey

The event code indicating that a key has been repeatedly held down.

Available in Mac OS X v10.0 and later.
updateEvt

The event code indicating that a window needs updating.

Available in Mac OS X v10.0 and later.
diskEvt

The event code indicating that a disk has been inserted.

Available in Mac OS X v10.0 and later.
activateEvt

The event code indicating that a window has been activated or deactivated.

Available in Mac OS X v10.0 and later.
osEvt

The event code indicating a suspend, resume, or mouse-moved operating-system event.

Available in Mac OS X v10.0 and later.
kHighLevelEvent

A high-level event.

Available in Mac OS X v10.0 and later.*/

enum {
   nullEvent = 0,
   mouseDown = 1,
   mouseUp = 2,
   keyDown = 3,
   keyUp = 4,
   autoKey = 5,
   updateEvt = 6,
   diskEvt = 7,
   activateEvt = 8,
   osEvt = 15,
   kHighLevelEvent = 23
};
typedef UInt16 EventKind;


/*Event Mask Constants

Define constants you can use in the event mask. 

enum {
   mDownMask = 1 << mouseDown,
   mUpMask = 1 << mouseUp,
   keyDownMask = 1 << keyDown,
   keyUpMask = 1 << keyUp,
   autoKeyMask = 1 << autoKey,
   updateMask = 1 << updateEvt,
   diskMask = 1 << diskEvt,
   activMask = 1 << activateEvt,
   highLevelEventMask = 0x0400,
   osMask = 1 << osEvt,
   everyEvent = 0xFFFF
};
typedef UInt16 EventMask;
Constants
mDownMask

The enumerator indicating you want your application to receive a mouse-down event.

Available in Mac OS X v10.0 and later.
mUpMask

The enumerator indicating you want your application to receive a mouse-up event.

Available in Mac OS X v10.0 and later.
keyDownMask

The enumerator indicating you want your application to receive a key-down event.

Available in Mac OS X v10.0 and later.
keyUpMask

The enumerator indicating you want your application to receive a key-up event.

Available in Mac OS X v10.0 and later.
autoKeyMask

The enumerator indicating you want your application to receive an auto-key event.

Available in Mac OS X v10.0 and later.
updateMask

The enumerator indicating you want your application to receive an update event.

Available in Mac OS X v10.0 and later.
diskMask

The enumerator indicating you want your application to receive a disk-inserted event.

Available in Mac OS X v10.0 and later.
activMask

The enumerator indicating you want your application to receive an activate event.

Available in Mac OS X v10.0 and later.
highLevelEventMask

The enumerator indicating you want your application to receive a high-level event. 

Available in Mac OS X v10.0 and later.
osMask

The enumerator indicating you want your application to receive an operating-system event

Available in Mac OS X v10.0 and later.
everyEvent

The enumerator indicating you want your application to receive every event.

Available in Mac OS X v10.0 and later.*/
enum {
   mDownMask = 1 << mouseDown,
   mUpMask = 1 << mouseUp,
   keyDownMask = 1 << keyDown,
   keyUpMask = 1 << keyUp,
   autoKeyMask = 1 << autoKey,
   updateMask = 1 << updateEvt,
   diskMask = 1 << diskEvt,
   activMask = 1 << activateEvt,
   highLevelEventMask = 0x0400,
   osMask = 1 << osEvt,
   everyEvent = 0xFFFF
};
typedef UInt16 EventMask;


/*Character Codes

Define character codes for events. 

enum {
   kNullCharCode = 0,
   kHomeCharCode = 1,
   kEnterCharCode = 3,
   kEndCharCode = 4,
   kHelpCharCode = 5,
   kBellCharCode = 7,
   kBackspaceCharCode = 8,
   kTabCharCode = 9,
   kLineFeedCharCode = 10,
   kVerticalTabCharCode = 11,
   kPageUpCharCode = 11,
   kFormFeedCharCode = 12,
   kPageDownCharCode = 12,
   kReturnCharCode = 13,
   kFunctionKeyCharCode = 16,
   kCommandCharCode = 17,
   kCheckCharCode = 18,
   kDiamondCharCode = 19,
   kAppleLogoCharCode = 20,
   kEscapeCharCode = 27,
   kClearCharCode = 27,
   kLeftArrowCharCode = 28,
   kRightArrowCharCode = 29,
   kUpArrowCharCode = 30,
   kDownArrowCharCode = 31,
   kSpaceCharCode = 32,
   kDeleteCharCode = 127,
   kBulletCharCode = 165,
   kNonBreakingSpaceCharCode = 202
};
Constants
kNullCharCode

Available in Mac OS X v10.0 and later.
kHomeCharCode

Available in Mac OS X v10.0 and later.
kEnterCharCode

Available in Mac OS X v10.0 and later.
kEndCharCode

Available in Mac OS X v10.0 and later.
kHelpCharCode

Available in Mac OS X v10.0 and later.
kBellCharCode

Available in Mac OS X v10.0 and later.
kBackspaceCharCode

Available in Mac OS X v10.0 and later.
kTabCharCode

Available in Mac OS X v10.0 and later.
kLineFeedCharCode

Available in Mac OS X v10.0 and later.
kVerticalTabCharCode

Available in Mac OS X v10.0 and later.
kPageUpCharCode

Available in Mac OS X v10.0 and later.
kFormFeedCharCode

Available in Mac OS X v10.0 and later.
kPageDownCharCode

Available in Mac OS X v10.0 and later.
kReturnCharCode

Available in Mac OS X v10.0 and later.
kFunctionKeyCharCode

Available in Mac OS X v10.0 and later.
kCommandCharCode

Available in Mac OS X v10.1 and later.
kCheckCharCode

Available in Mac OS X v10.1 and later.
kDiamondCharCode

Available in Mac OS X v10.1 and later.
kAppleLogoCharCode

Available in Mac OS X v10.1 and later.
kEscapeCharCode

Available in Mac OS X v10.0 and later.
kClearCharCode

Available in Mac OS X v10.0 and later.
kLeftArrowCharCode

Available in Mac OS X v10.0 and later.
kRightArrowCharCode

Available in Mac OS X v10.0 and later.
kUpArrowCharCode

Available in Mac OS X v10.0 and later.
kDownArrowCharCode

Available in Mac OS X v10.0 and later.
kSpaceCharCode

Available in Mac OS X v10.1 and later.
kDeleteCharCode

Available in Mac OS X v10.0 and later.
kBulletCharCode

Available in Mac OS X v10.1 and later.
kNonBreakingSpaceCharCode

Available in Mac OS X v10.0 and later.*/
enum {
   kNullCharCode = 0,
   kHomeCharCode = 1,
   kEnterCharCode = 3,
   kEndCharCode = 4,
   kHelpCharCode = 5,
   kBellCharCode = 7,
   kBackspaceCharCode = 8,
   kTabCharCode = 9,
   kLineFeedCharCode = 10,
   kVerticalTabCharCode = 11,
   kPageUpCharCode = 11,
   kFormFeedCharCode = 12,
   kPageDownCharCode = 12,
   kReturnCharCode = 13,
   kFunctionKeyCharCode = 16,
   kCommandCharCode = 17,
   kCheckCharCode = 18,
   kDiamondCharCode = 19,
   kAppleLogoCharCode = 20,
   kEscapeCharCode = 27,
   kClearCharCode = 27,
   kLeftArrowCharCode = 28,
   kRightArrowCharCode = 29,
   kUpArrowCharCode = 30,
   kDownArrowCharCode = 31,
   kSpaceCharCode = 32,
   kDeleteCharCode = 127,
   kBulletCharCode = 165,
   kNonBreakingSpaceCharCode = 202
};

/*charCodeMask


enum {
   charCodeMask = 0x000000FF,
   keyCodeMask = 0x0000FF00,
   adbAddrMask = 0x00FF0000,
   osEvtMessageMask = 0xFF000000
};
Constants
charCodeMask

The enumerator indicating you want your application to receive a character-code keyboard event.

Available in Mac OS X v10.0 and later.
keyCodeMask

The enumerator indicating you want your application to receive a key-code keyboard event.

Available in Mac OS X v10.0 and later.
adbAddrMask

The enumerator indicating you want your application to receive an ADB address if there is an ADB keyboard. 

Available in Mac OS X v10.0 and later.
osEvtMessageMask

The enumerator indicating you want your application to receive a keyboard event that can be used to extract a message code.

Available in Mac OS X v10.0 and later*/
enum {
   charCodeMask = 0x000000FF,
   keyCodeMask = 0x0000FF00,
   adbAddrMask = 0x00FF0000,
   osEvtMessageMask = 0xFF000000
};


/*Event Modifier Constants

Define modifiers for event types. 

enum {
   activeFlagBit = 0,
   btnStateBit = 7,
   cmdKeyBit = 8,
   shiftKeyBit = 9,
   alphaLockBit = 10,
   optionKeyBit = 11,
   controlKeyBit = 12,
   rightShiftKeyBit = 13,
   rightOptionKeyBit = 14,
   rightControlKeyBit = 15
};
typedef UInt16 EventModifiers;
Constants
activeFlagBit

Available in Mac OS X v10.0 and later.
btnStateBit

Available in Mac OS X v10.0 and later.
cmdKeyBit

Available in Mac OS X v10.0 and later.
shiftKeyBit

Available in Mac OS X v10.0 and later.
alphaLockBit

Available in Mac OS X v10.0 and later.
optionKeyBit

Available in Mac OS X v10.0 and later.
controlKeyBit

Available in Mac OS X v10.0 and later.
rightShiftKeyBit

Available in Mac OS X v10.0 and later.
rightOptionKeyBit

Available in Mac OS X v10.0 and later.
rightControlKeyBit

Available in Mac OS X v10.0 and later.*/
enum {
   activeFlagBit = 0,
   btnStateBit = 7,
   cmdKeyBit = 8,
   shiftKeyBit = 9,
   alphaLockBit = 10,
   optionKeyBit = 11,
   controlKeyBit = 12,
   rightShiftKeyBit = 13,
   rightOptionKeyBit = 14,
   rightControlKeyBit = 15
};
typedef UInt16 EventModifiers;

/*EventRecord

Contains information associated with an event.

struct EventRecord {
   EventKind what;
   UInt32 message;
   UInt32 when;
   Point where;
   EventModifiers modifiers;
};
typedef struct EventRecord EventRecord;
Fields
what

The kind of event received. The Event Manager specifies the kind of event with one of the values defined by the EventKind enumeration. 
message

Additional information associated with the event. The interpretation of this information depends on the event type. The contents of the message field for each event type are summarized here:
For a null, mouse-up, or mouse-down event, the event message is:Undefined.
For a key-up, key-down, or auto-key event, the event message is:The low-order word contains the character code and virtual key code, which you can access with the constants charCodeMask and keyCodeMask, respectively. For Apple Desktop Bus (ADB) keyboards, the low byte of the high-order word contains the ADB address of the keyboard where the keyboard event occurred. The high byte of the high-order word is reserved.
For an update or activate event, the event message is:A pointer to the window to update, activate, or deactivate.
For a disk-inserted event, the event message is:The drive number in the low-order word, the File Manager result code in the high-order word.
For a resume event, the event message is:The suspendResumeMessage enumerator in bits 24–31 and a 1 (the resumeFlag enumerator) in bit 0 indicate the event is a resume event. Bit 1 contains a 1 (the convertClipBoardFlag enumerator) if Clipboard conversion is required, and bits 2–23 are reserved.
For a suspend event, the event message is:The suspendResumeMessage enumerator in bits 24–31 and a 0 in bit 0 to indicate the event is a suspend event. Bit 1 is undefined, and bits 2–23 are reserved.
For a mouse-moved event, the event message is:The mouseMovedMessage enumerator in bits 24–31. Bits 2–23 are reserved, and bit 0 and bit 1 are undefined.
For a high-level event, the event message is:

The class of events to which the high-level event belongs. The message and where fields of a high-level event define the specific type of high-level event received.
when

The when field indicates the time when the event was posted (in ticks since system startup).
where

For low-level events and operating-system events, the where field contains the location of the cursor at the time the event was posted (in global coordinates).

For high-level events, the where field contains a second event specifier, the event ID. The event ID defines the particular type of event within the class of events defined by the message field of the high-level event. For high-level events, you should interpret the where field as having the data type OSType, not Point.
modifiers

The modifiers field contains information about the state of the modifier keys and the mouse button at the time the event was posted. For activate events, this field also indicates whether the window should be activated or deactivated. In System 7 it also indicates whether the mouse-down event caused your application to switch to the foreground. 

Each of the modifier keys is represented by a specific bit in the modifiers field of the event structure. The modifier keys include the Option, Command, Caps Lock, Control, and Shift keys. If your application attaches special meaning to any of these keys in combination with other keys or when the mouse button is down, you can test the state of the modifiers field to determine the action your application should take. For example, you can use this information to determine whether the user pressed the Command key and another key to make a menu choice.

Discussion

When your application uses an Event Manager function to retrieve an event, the Event Manager returns information about the retrieved event in an event structure, which is a structure of type EventRecord. 
Availability
Available in Mac OS X v10.0 and later.*/
struct EventRecord {
   EventKind what;
   UInt32 message;
   UInt32 when;
   Point where;
   EventModifiers modifiers;
};
typedef struct EventRecord EventRecord;


/*Event Modifier Bits

Modifer bits for events. 

enum {
   activeFlag = 1 << activeFlagBit,
   btnState = 1 << btnStateBit,
   cmdKey = 1 << cmdKeyBit,
   shiftKey = 1 << shiftKeyBit,
   alphaLock = 1 << alphaLockBit,
   optionKey = 1 << optionKeyBit,
   controlKey = 1 << controlKeyBit,
   rightShiftKey = 1 << rightShiftKeyBit,
   rightOptionKey = 1 << rightOptionKeyBit,
   rightControlKey = 1 << rightControlKeyBit
};
Constants
activeFlag

The enumerator that indicates a window is being activated or that a mouse-down event caused a foreground switch.

Available in Mac OS X v10.0 and later.
btnState

The enumerator indicating that the mouse button has been released.

Available in Mac OS X v10.0 and later.
cmdKey

The enumerator indicating that the Command key is being pressed.

Available in Mac OS X v10.0 and later.
shiftKey

The enumerator indicating that the Shift key is being pressed.

Available in Mac OS X v10.0 and later.
alphaLock

The enumerator indicating that the Caps Lock key is being pressed.

Available in Mac OS X v10.0 and later.
optionKey

The enumerator indicating that the Option key is being pressed.

Available in Mac OS X v10.0 and later.
controlKey

The enumerator indicating that the Control key is being pressed.

Available in Mac OS X v10.0 and later.
rightShiftKey

Available in Mac OS X v10.0 and later.
rightOptionKey

Available in Mac OS X v10.0 and later.
rightControlKey

Available in Mac OS X v10.0 and later.*/

enum {
   activeFlag = 1 << activeFlagBit,
   btnState = 1 << btnStateBit,
   cmdKey = 1 << cmdKeyBit,
   shiftKey = 1 << shiftKeyBit,
   alphaLock = 1 << alphaLockBit,
   optionKey = 1 << optionKeyBit,
   controlKey = 1 << controlKeyBit,
   rightShiftKey = 1 << rightShiftKeyBit,
   rightOptionKey = 1 << rightOptionKeyBit,
   rightControlKey = 1 << rightControlKeyBit
};

//function

/*Button

Determines whether the user pressed the mouse button.

Not recommended

Boolean Button ();
Parameters
Return Value
Discussion

The Button function simply checks to see if the mouse button is down. If so, it returns true; otherwise, it returns false. To determine whether the mouse button is still down after a mouse-down event, use the StillDown function. To check to see if the mouse was released, use the WaitMouseUp function. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

You should avoid using any calls that poll the state of the mouse button, as they use excessive processor time and slow down the system. In most cases you are more interested in the transitions of the mouse button rather than its instantaneous state, so you should adopt Carbon events and take action on mouse-up and mouse-down events. If you need to track the mouse while down, consider using the Carbon Event Manager functions TrackMouseLocation or TrackMouseRegion. On Mac OS X v.10.2 and later, if you need to know the button state, you should call the GetCurrentEventButtonState function. 
Declared In
Events.h*/
Boolean Button ();

/*WaitNextEvent

Retrieves events one at a time from the Event Manager.

Boolean WaitNextEvent (
   EventMask eventMask,
   EventRecord * theEvent,
   UInt32 sleep,
   RgnHandle mouseRgn
);
Parameters
eventMask

A value that indicates which kinds of events are to be returned. This parameter is interpreted as a sum of event mask constants. You specify the event mask using values defined in “Event Mask Constants”. To accept all events, you can specify the everyEvent constant as the event mask.

If no event of any of the designated types is available, WaitNextEvent returns a null event. WaitNextEvent determines the next available event to return based on the eventMask parameter and the priority of the event. 

Events not designated by the event mask remain in the event stream until retrieved by an application. Low-level events in the Operating System event queue are kept in the queue until they are retrieved by your application or another application or until the queue becomes full. Once the queue becomes full, the Operating System Event Manager begins discarding the oldest events in the queue.

theEvent

A pointer to an event structure for the next available event of the specified type or types. The WaitNextEvent function removes the returned event from the event stream and returns the information about the event in an event structure. The event structure includes the type of event received and other information. 

In addition to the event structure, high-level events can contain additional data; use the Apple Event Manager AEProcessAppleEvent function to get additional data associated with these events.

sleep

The number of ticks (a tick is approximately 1/60 of a second) indicating the amount of time your application is willing to relinquish the processor if no events are pending for your application. If you specify a value greater than 0 for the sleep parameter, your application relinquishes the processor for the specified time or until an event occurs.

You should not set the sleep parameter to a value greater than the number of ticks returned by GetCaretTime if your application provides text-editing capabilities. When the specified time expires, and if there are no pending events for your application, WaitNextEvent returns a NULL event in the parameter theEvent. 

When running on Mac OS X, a Carbon application will block for the entire duration of the sleep parameter if there are no events to be delivered. This is slightly different behavior than on Mac OS 9, where the application will often receive NULL events before the sleep duration has elapsed.

mouseRgn

A handle to a region that specifies a region inside of which mouse movement does not cause mouse-moved events. In other words, your application receives mouse-moved events only when the cursor is outside the specified region. You should specify the region in global coordinates. If you pass an empty region or a null region handle, the Event Manager does not report mouse-moved events to your application. Note that your application should recalculate the mouseRgn parameter when it receives a mouse-moved event, or it will continue to receive mouse-moved events as long as the cursor position is outside the original mouseRgn. 
Return Value

The WaitNextEvent function returns false as its function result if the event being returned is a null event or if WaitNextEvent has intercepted the event; otherwise, WaitNextEvent returns true. 
Discussion

The WaitNextEvent function calls the Operating System Event Manager function SystemEvent to determine whether the event should be handled by the application or the Operating System.

If no events are pending for your application, WaitNextEvent waits for a specified amount of time for an event. (During this time, processing time may be allocated to background processes.) If an event occurs, it is returned through the parameter theEvent, and WaitNextEvent returns a function result of true. If the specified time expires and there are no pending events for your application, WaitNextEvent returns a null event in theEvent and a function result of false. 

Before returning an event to your application, WaitNextEvent performs other processing and may intercept the event. 

The WaitNextEvent function intercepts Command–Shift–number key sequences and calls the corresponding ' FKEY ' resource to perform the associated action. The Event Manager’s processing of Command–Shift–number key sequences with numbers 3 through 9 can be disabled by setting the ScrDmpEnable global variable (a byte) to 0. 

If the returned event is a high-level event and your application supports Apple events, use the Apple Event Manager function AEProcessAppleEvent to respond to the Apple event and to get additional information associated with the Apple event.

To retrieve an event without removing it from the event stream, use EventAvail. 
Version Notes
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
Boolean WaitNextEvent (
   EventMask eventMask,
   EventRecord * theEvent,
   UInt32 sleep,
   RgnHandle mouseRgn
);

/*GetKeys

Obtains the current state of the keyboard.

void GetKeys (
   KeyMap theKeys
);
Parameters
theKeys

Returns the current state of the keyboard, including the keypad, if any. The GetKeys function returns this information using the KeyMap type.

typedef long KeyMap[4];

The KeyMap type is interpreted as an array of 128 elements, each having a Boolean value. Each key on the keyboard or keypad corresponds to an element in the KeyMap array. The index for a particular key is the same as the key’s virtual key code minus 1. For example, the key with virtual key code 38 (the “J” key on the Apple Keyboard II) is the 38th element in the returned array. A KeyMap element is true if the corresponding key is down and false if it isn’t. The maximum number of keys that can be down simultaneously is two character keys plus any combination of the five modifier keys.

Return Value
Discussion

You can use the GetKeys function to determine the current state of the keyboard at any time. For example, you can determine whether one of the modifier keys is down by itself or in combination with another key using the GetKeys function. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/

void GetKeys (
   KeyMap theKeys
);

/*GetDblTime

Determines whether a sequence of mouse events constitutes a double click.

UInt32 GetDblTime ();
Parameters
Return Value
Discussion

The GetDblTime function returns the suggested maximum elapsed time, in ticks, between a mouse-up event and a mouse-down event. The user can adjust this value using the Mouse control panel.

If your application distinguishes a double click of the mouse from a single click, your application should use the value returned by GetDblTime to make this distinction. If your application uses TextEdit, the TextEdit functions automatically recognize and handle double clicks of text within a TextEdit edit structure by appropriately highlighting or unhighlighting the selection.

The ratio of ticks to value in the DoubleTime global variable is 1:1. However, the Finder multiplies DoubleTime by 2 to determine double click time because it needs to account for user problems that typically occur during icon arrangement. Therefore, the Finder uses DoubleTime*2 whereas the rest of the system uses DoubleTime. 

Incidentally, the Finder does not limit the DoubleTime to 64 ticks. In most places, it treats it like a byte although in some others it treats it like a longword. The best method would be to provide a one-second double-byte (two seconds in the Finder).

The value returned b y GetDblTime is also accessible in the system global variable DoubleTime. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt32 GetDblTime ();

/*KeyTranslate

Converts a virtual key code to a character code based on a 'KCHR' resource. 

UInt32 KeyTranslate (
   const void * transData,
   UInt16 keycode,
   UInt32 * state
);
Parameters
transData

A pointer to the 'KCHR' resource that you want the KeyTranslate function to use when converting the key code to a character code. 
keycode

A 16-bit value that your application should set so that bits 0–6 contain the virtual key code and bit 7 contains either 1 to indicate an up stroke or 0 to indicate a down stroke of the key. Bits 8–15 have the same interpretation as the high byte of the modifiers field of the event structure and should be set according to the needs of your application. 
state

A pointer to a value that your application should set to 0 the first time it calls KeyTranslate or any time your application calls KeyTranslate with a different 'KCHR' resource. Thereafter, your application should pass the same value in the state parameter as KeyTranslate returned in the previous call. 
Return Value
Discussion

The KeyTranslate function returns a 32-bit value that gives the character code for the virtual key code specified by the keycode parameter. 

The KeyTranslate function returns the values that correspond to one or possibly two characters that are generated by the specified virtual key code. For example, a given virtual key code might correspond to an alphabetic character with a separate accent character. For example, when the user presses Option-E followed by N, you can map this through the KeyTranslate function using the U.S. 'KCHR' resource to produce ´n, which KeyTranslate returns as two characters in the bytes labeled Character code 1 and Character code 2. If KeyTranslate returns only one character code, it is always in the byte labeled Character code 2. However, your application should always check both bytes labeled Character code 1 and Character code 2 for possible values that map to the virtual key code. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/
UInt32 KeyTranslate (
   const void * transData,
   UInt16 keycode,
   UInt32 * state
);

/*IsCmdChar

Tests whether the Command key is pressed in conjunction with another key (or keys) that could generate the specified test character.

Boolean IsCmdChar (
   const EventRecord * event,
   short test
);
Parameters
event

The event record for a key-down or auto-key event with the Command key down. 
test

The character you want to test.
Return Value

The function returns TRUE if the test character is produced with the current modifier keys, or if it would be produced by changing the current modifier key bits in either or both of the following ways: (1) turning the Command bit off or (2) toggling the Shift bit.
Discussion

This function tests whether the Command key is pressed in conjunction with another key (or keys) that could generate the test character for some combination of Command up or down and Shift up or down. This accommodates European keyboards that may have the test character as a shifted character, and non-Roman keyboards that will only generate the test character if the Command key is pressed. It's most useful for testing for Command-period, but it can test for command-AnyCharacter. 
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Events.h*/

Boolean IsCmdChar (
   const EventRecord * event,
   short test
);

#ifdef __cplusplus
}
#endif

#endif