#ifndef LISTS_H
#define LISTS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif



#include <HYS/HIToolbox/Lists.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*List Definition Constants


enum {
   lInitMsg = 0,
   lDrawMsg = 1,
   lHiliteMsg = 2,
   lCloseMsg = 3
};
Constants
lInitMsg

In response to the lInitMsg message, your list definition function should perform any special initialization needed for a list. For example, the function might set fields of the list record, such as the cellSize and indent fields, to appropriate values. Your list definition function does not necessarily need to do anything in response to the initialization message. If it does nothing, then memory is still allocated for the list, and fields of the list record are set to the same values as they would be set to if the default list definition function were being used.

Available in Mac OS X v10.0 and later.
lDrawMsg

Your list definition function should draw the cell specified by the theCell parameter after receiving an lDrawMsg message. The function must ensure that it does not draw anywhere but within the rectangle specified by the cellRect parameter. If the selected parameter is TRUE, then your list definition function should draw the cell in its highlighted state; otherwise, it should draw the cell without highlighting. When drawing, your list definition function should take care not to permanently change any characteristics of the drawing environment.

Available in Mac OS X v10.0 and later.
lHiliteMsg

Your list definition function should respond to the lHiliteMsg message by reversing the selection status of the cell contained within the rectangle specified by the cellRect parameter. If a cell is highlighted, your list definition function should remove the highlighting; if a cell is not highlighted, your list definition function should highlight it.

Available in Mac OS X v10.0 and later.
lCloseMsg

The List Manager sends your list definition function an lCloseMsg message before it disposes of a list and its data. Your list definition function need only respond to this message if additional memory has been allocated for the list. For example, your list definition function might allocate a relocatable block in response to the lInitMsg message. In this case, your list definition function would need to dispose of this relocatable block in response to the lCloseMsg message. Or, if your list definition function defines cells simply to contain pointers or handles to data stored elsewhere in memory, it would need to dispose of that memory in response to the lCloseMsg message.

Available in Mac OS X v10.0 and later.
Discussion

The List Manager passes these values to your ListDefProcPtr function to identify the operation to be performed.*/

enum {
   lInitMsg = 0,
   lDrawMsg = 1,
   lHiliteMsg = 2,
   lCloseMsg = 3
};


/*ListDefType


typedef UInt32 ListDefType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 ListDefType;

/*Cell


typedef Point Cell;
Discussion

The Cell data type defines a cell record. The functions LGetSelect , LSetSelect , LSetCell , LAddToCell , LClrCell , LGetCellDataLocation , LGetCell , LDraw , LSearch , LNextCell , LRect , and LLastClick use the Cell data type to specify the coordinates of a cell in a list.

Note that column and row numbers are 0-based. Also note that this reference designates cells using the notation (column–1, row–1), so that a cell with coordinates (2,5) is in the third column and sixth row of a list. You specify a cell with coordinates (2,5) by setting the cell’s h field to 2 and its v field to 5. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef Point Cell;

/*ListDefProcPtr

Defines a pointer to a list definition callback function. Your list definition callback function defines a custom list display.

typedef void (*ListDefProcPtr) (
   SInt16 lMessage,
   Boolean lSelect,
   Rect *lRect,
   Cell lCell,
   SInt16 lDataOffset,
   SInt16 lDataLen,
   ListHandle lHandle
);

If you name your function MyListDefProc, you would declare it like this:

void MyListDefProc (
   SInt16 lMessage,
   Boolean lSelect,
   Rect * lRect,
   Cell lCell,
   SInt16 lDataOffset,
   SInt16 lDataLen,
   ListHandle lHandle
);
Parameters
lMessage

A value that identifies the operation to be performed. See “List Definition Constants”. 
lSelect

Indicates whether the cell specified by the lCell parameter should be highlighted. This parameter is defined only for the lDrawMessage and lHiliteMsg messages. 
lRect

A pointer to the rectangle (in local coordinates of the list’s graphics port) that encloses the specified cell. Although this parameter is defined as a pointer, your list definition function must not change the coordinates of the rectangle. This parameter is defined only for the lDrawMessage and lHiliteMsg messages. 
lCell

The coordinates of the cell to be drawn or highlighted. This parameter is defined only for the lDrawMessage and lHiliteMsg messages. 
lDataOffset

The location of the cell data associated with the specified cell. The location is specified as an offset from the beginning of the relocatable block referenced by the cells field of the list record. This parameter is defined only for the lDrawMessage and lHiliteMsg messages.
lDataLen

The length in bytes of the cell data associated with the specified. This parameter is defined only for the lDrawMessage and lHiliteMsg messages.
lHandle

A handle to the list for which a message is being sent. Your application can access the list’s list record, or it can call List Manager functions to manipulate the list. 
Discussion

Your application can write a list definition function to customize list display. For example, you can write a list definition function to support the display of color icons. A custom list definition function must be compiled as a code resource of type 'LDEF' and added to the resource file of the application that needs to use it. 

The List Manager calls your list definition function whenever an application using the function creates a new list with the LNew function, needs a cell to be drawn, needs a cell’s highlighting state to be reversed, or has called the LDispose function to dispose of a list.

The pointer to your list definition function should be a universal procedure pointer (UPP). The definition of the UPP data type for your definition function is as follows:typedef (ListDefProcPtr) ListDefUPP;


Before using your list definition function, you must first create a new universal procedure pointer to it, using the NewListDefUPP function, as shown here:ListDefUPP MyListDefUPP;
MyListDefUPP = NewListDefUPP(&MyListDefProc)


The List Manager automatically invokes your list definition function when a new list is created. If you wish to call your own list definition callback function, you can use the InvokeListDefUPP function:InvokeListDefUPP(lMessage, lSelect, &lRect, lCell, lDataOffset,                      lDataLen, lHandle, MyListDefUPP)


When you are finished with your list definition function, you should dispose of the universal procedure pointer associated with it, using the DisposeListDefUPP function.DisposeListDefUPP(MyListDefUPP);


Because a list definition function is stored in a code resource, it cannot have its own global variables that it accesses through the A5 register. (Some development systems, however, may allow code resources to access global variables through some other register, such as A4. See your development system’s documentation for more information.) If your list definition function needs access to global data, it might store a handle to such data in the refCon or userHandle fields of the list record; however, applications would not then be able to use these fields for their own purposes. 
Special Considerations

Because a list definition function is stored in a code resource, it cannot have its own global variables that it accesses through the A5 register. (Some development systems, however, may allow code resources to access global variables through some other register, such as A4. See your development system’s documentation for more information.) If your list definition function needs access to global data, it might store a handle to such data in the refCon or userHandle fields of the list record; however, applications would not then be able to use these fields for their own purposes.*/
typedef void (*ListDefProcPtr) (
   SInt16 lMessage,
   Boolean lSelect,
   Rect *lRect,
   Cell lCell,
   SInt16 lDataOffset,
   SInt16 lDataLen,
   ListHandle lHandle
);



/*ListDefUPP


typedef ListDefProcPtr ListDefUPP;
Discussion

For more information, see the description of the ListDefUPP () callback function.*/
typedef ListDefProcPtr ListDefUPP;

/*ListBounds


typedef Rect ListBounds;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Rect ListBounds;


/*ListDefSpec


struct ListDefSpec {
   ListDefType defType
   union {
      ListDefUPP userProc;
   } u;
};
typedef struct ListDefSpec ListDefSpec;
typedef ListDefSpec * ListDefSpecPtr;
Fields
defType
ListDefUPP
Availability
Available in Mac OS X v10.0 and later.*/

struct ListDefSpec {
   ListDefType defType;
   union {
      ListDefUPP userProc;
   } u;
};
typedef struct ListDefSpec ListDefSpec;
typedef ListDefSpec * ListDefSpecPtr;

/*kListDefProcPtr


enum {
   kListDefProcPtr = 0,
   kListDefUserProcType = kListDefProcPtr,
   kListDefStandardTextType = 1,
   kListDefStandardIconType = 2
};
Constants
kListDefProcPtr

Available in Mac OS X v10.0 and later.
kListDefUserProcType

Available in Mac OS X v10.0 and later.
kListDefStandardTextType

Available in Mac OS X v10.0 and later.
kListDefStandardIconType

Available in Mac OS X v10.0 and later.
lDrawingModeOff*/
enum {
   kListDefProcPtr = 0,
   kListDefUserProcType = kListDefProcPtr,
   kListDefStandardTextType = 1,
   kListDefStandardIconType = 2
};

//functions 

/*LSize

Changes the size of a list.

void LSize (
   short listWidth,
   short listHeight,
   ListHandle lHandle
);
Parameters
listWidth

The new width (in pixels) of the list’s visible rectangle. 
listHeight

The new height (in pixels) of the list’s visible rectangle.
lHandle

The list whose size is being changed. 
Discussion

This function adjusts the lower-right side of the list so that the list’s visible rectangle is the width and height specified by the listWidth and listHeight parameters. 

Because the list’s visible rectangle does not include room for the scroll bars, your application should make listWidth 15 pixels less than the desired width of the list if it contains a vertical scroll bar, and it should make listHeight 15 pixels less than the desired height of the list if it contains a horizontal scroll bar.

The contents of the list and the scroll bars are adjusted and redrawn as necessary. However, this function does not draw a border around the list’s rectangle. Also, it does not erase any portions of the old list that may still be visible. This approach should not be a problem if your application only calls LSize after the user resizes a window containing a list in its lower-right corner.

Usually, you need to call this function only after calling the Window Manager function SizeWindow. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSize (
   short listWidth,
   short listHeight,
   ListHandle lHandle
);

/*LUpdate

Responds to an update event.

void LUpdate (
   RgnHandle theRgn,
   ListHandle lHandle
);
Parameters
theRgn

The visible region of the list’s port after a call to the Window Manager’s BeginUpdate function. 
lHandle

The list to be updated. 
Discussion

This function redraws all visible cells in the list specified by the lHandle parameter that intersect the region specified by the parameter theRgn. It also redraws the scroll bars if they intersect the region.

You should bracket calls to LUpdate by calls to the Window Manager functions BeginUpdate and EndUpdate. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LUpdate (
   RgnHandle theRgn,
   ListHandle lHandle
);

/*LDispose

Disposes of the memory associated with a list.

void LDispose (
   ListHandle lHandle
);
Parameters
lHandle

The list to be disposed of. 
Discussion

This function releases all memory allocated by the List Manager in creating a list. First, it issues a close request to the list definition function and calls the Control Manager function DisposeControl for the list’s scroll bars (if any). The function then uses the Memory Manager to free the memory referenced by the cells field, then disposes of the list record itself.

Because it disposes of data associated with cells in your list, there is no need to clear the data from list cells or to delete individual rows and columns before calling this function.

This function does not dispose of any memory associated with a list that the List Manager has not allocated. In particular, it does not dispose of any memory referenced by the userHandle field of the list record. Your application is responsible for deallocating any memory it has allocated through the userHandle field before calling this function. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Version Notes
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Lists.h*/

void LDispose (
   ListHandle lHandle
);

/*NewListDefUPP

Creates a new universal procedure pointer (UPP) to a list definition callback function.

ListDefUPP NewListDefUPP (
   ListDefProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ListDefUPP data type.
Discussion

See the ListDefProcPtr callback for more information. 
Special Considerations
Version Notes
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Lists.h*/

ListDefUPP NewListDefUPP (
   ListDefProcPtr userRoutine
);

/*CreateCustomList


OSStatus CreateCustomList (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cellSize,
   const ListDefSpec * theSpec,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert,
   ListHandle * outList
);
Parameters
rView
dataBounds
cellSize
theSpec
theWindow
drawIt
hasGrow
scrollHoriz
scrollVert
outList
Return Value

A result code.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

OSStatus CreateCustomList (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cellSize,
   const ListDefSpec * theSpec,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert,
   ListHandle * outList
);


/*LActivate

Activates or deactivates a list.

void LActivate (
   Boolean act,
   ListHandle lHandle
);
Parameters
act

Indicates whether the list should be activated. Specify TRUE to activate the list. Specify FALSE to deactivate the list. 
lHandle

The list to be activated or deactivated. 
Discussion

If a list is being deactivated, this function removes highlighting from selected cells and hides the scroll bars. If a list is being activated, the function highlights selected cells and shows the scroll bars.

This function has no effect on a list’s size box, if one exists. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

void LActivate (
   Boolean act,
   ListHandle lHandle
);

/*GetListViewBounds


Rect * GetListViewBounds (
   ListHandle list,
   Rect * view
);
Parameters
list
view
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

Rect * GetListViewBounds (
   ListHandle list,
   Rect * view
);

/*LClick

Processes a mouse-down event in a list.

Boolean LClick (
   Point pt,
   EventModifiers modifiers,
   ListHandle lHandle
);
Parameters
pt

The location in local coordinates of the mouse-down event. Your application can simply call GlobalToLocal(myEvent.where) and then pass myEvent.where in this parameter.

If the pt parameter specifies a portion of the list’s visible rectangle, then cells are selected with an algorithm that depends on the list’s selection flags and on the modifiers parameter. If the user drags the cursor above or below the list’s visible rectangle and vertical autoscrolling is enabled, then the List Manager vertically autoscrolls the list. If the user drags the cursor to the right or the left of the list’s visible rectangle and horizontal autoscrolling is enabled, then the List Manager horizontally autoscrolls the list.

If the pt parameter specifies a point within the list’s scroll bar, then the List Manager calls the scroll bar’s control definition function to track the cursor and it scrolls the list appropriately.
modifiers

An integer value corresponding to the modifiers field of the event record. 
lHandle

The list in which the mouse-down event occurred. 
Return Value

TRUE if the click was a double-click, or FALSE otherwise. 
Discussion

The LClick function handles all user interaction until the user releases the mouse button. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
Boolean LClick (
   Point pt,
   EventModifiers modifiers,
   ListHandle lHandle
);

#ifdef __cplusplus
}
#endif

#endif