#ifndef TRANSLATIONEXTENSIONS_H
#define TRANSLATIONEXTENSIONS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#include <HYS/HIToolbox/TranslationExtensions.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*FileType

Defines the translation file type of a document.

typedef OSType FileType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType FileType;

/*FileTypeSpec

Defines a descriptor for the source or destination file type used in a translation method.

struct FileTypeSpec {
   FileType format;
   long hint;
   TranslationAttributes flags;
   OSType catInfoType;
   OSType catInfoCreator;
};
typedef struct FileTypeSpec FileTypeSpec;
Fields
format

The translation file type of the document. Macintosh Easy Open uses this field as the canonical way to describe the format of a file for translation purposes.
hint

A 4-byte value reserved for use by your translation extension.
flags

A 4-byte value consisting of bit flags that specify how to control the translation. This field is used only for destination file types; you should set it to 0 for all source file type specifications. Currently 2 bits are defined; all other bits should be cleared to 0.
catInfoType

The type of the file as contained in the volume’s catalog file. 
catInfoCreator

The creator of the file as contained in the volume’s catalog file.
Discussion

The FileTranslationList structure uses file type specifications to describe document formats. A file type specification is defined by the FileTypeSpec data structure. 

The interpretation of some of the fields of a file type specification depends on whether the specification occurs in the list of source document types or in the list of destination document types:

In file type specifications occurring in the list of source document types in a file translation list, Macintosh Easy Open uses the format and catInfoCreator fields to determine the kind string displayed in the “From” format specification of the translation progress dialog box.

In file type specifications occurring in the list of destination document types in a file translation list, Macintosh Easy Open uses the format and catInfoCreator fields to determine the kind string displayed in the “To” format specification in the translation progress dialog box. The format and catInfoCreator fields are also used to get the information displayed in the Document Converter dialog box. However, Macintosh Easy Open uses the catInfoType and catInfoCreator fields to set the catalog type and creator of the destination file. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FileTypeSpec {
   FileType format;
   long hint;
   TranslationAttributes flags;
   OSType catInfoType;
   OSType catInfoCreator;
};
typedef struct FileTypeSpec FileTypeSpec;

#ifdef __cplusplus
}
#endif

#endif