#ifndef ATSUNICODEFONTS_H
#define ATSUNICODEFONTS_H

#ifndef ATSUNICODETYPES_H
#include <QD/ATSUnicodeTypes.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*ATSUFONDtoFontID

Finds the ATSUI font ID that corresponds to a font family number, if one exists. (Deprecated. There is no replacement because FONDs are a QuickDraw concept and QuickDraw is deprecated.)

Not recommended.

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
);
Parameters
iFONDNumber

The font family number of the ATSUI-compatible font for which to obtain an ATSUI font ID.
iFONDStyle

The font family style of the font, if any. Style identifiers exist only for fonts that split a font family into subgroups.
oFontID

A pointer to a ATSUFontID value. On return, the value provides a unique identifier for the specified font family number and style. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The function ATSUFONDtoFontID is not recommended for use. Instead, use the Font Manager functions that translate font family numbers to FMFont values, which are equivalent to ATSUFontID values. Font family numbers were used by QuickDraw to represent fonts to the Font Manager. Some of these fonts, even if compatible with ATSUI, may not have font IDs.

Note that Apple Type Services assigns ATSUFontID values systemwide at runtime. As a result, these font IDs can change when the system is restarted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
);


#ifdef __cplusplus
}
#endif

#endif