#ifndef ATSUNICODEOBJECTS_H
#define ATSUNICODEOBJECTS_H

#ifndef ATSUNICODETYPES_H
#include <QD/ATSUnicodeTypes.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*ATSUDisposeStyle

Disposes of the memory associated with a style object.

OSStatus ATSUDisposeStyle (
   ATSUStyle iStyle
);
Parameters
iStyle

An ATSUStyle value specifying the style object to dispose of.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUDisposeStyle function frees the memory associated with the specified style object and its internal structures, including style run attributes. It does not dispose of the memory pointed to by application-defined style run attributes or reference constants. You are responsible for doing so.

You should call this function after calling the function ATSUDisposeTextLayout to dispose of any text layout objects associated with the style object.

For best performance, once you create a style object, you should keep it and use it as often as needed. You should dispose of the style object only when it is no longer needed in your application.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUDisposeStyle (
   ATSUStyle iStyle
);

/*ATSUDisposeTextLayout

Disposes of the memory associated with a text layout object.

OSStatus ATSUDisposeTextLayout (
   ATSUTextLayout iTextLayout
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to dispose of. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUDisposeTextLayout function frees the memory associated with the specified text layout object and its internal structures, including line and layout control attributes, style runs, and soft line breaks. ATSUDisposeTextLayout does not dispose of any memory that may be allocated for reference constants or style objects associated with the text layout object. You are responsible for doing so.

For best performance, text layout objects are readily reusable and should be cached for later use, if possible. You can reuse a text layout object even if the text associated with it is altered. Call the functions ATSUSetTextPointerLocation, ATSUTextDeleted, or ATSUTextInserted to manage the altered text, rather than disposing of the text layout object and creating a new one.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUDisposeTextLayout (
   ATSUTextLayout iTextLayout
);

/*ATSUCreateAndCopyStyle

Creates a copy of a style object.

OSStatus ATSUCreateAndCopyStyle (
   ATSUStyle iStyle,
   ATSUStyle *oStyle
);
Parameters
iStyle

An ATSUStyle value specifying the style object to copy.
oStyle

A pointer to an ATSUStyle value. On return, the pointer refers to a newly created style object. This style object contains the same values for style attributes, font features, and font variations as those of the style object passed in the iStyle parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCreateAndCopyStyle function creates a new style object with values obtained from the source style object’s style attributes, font features, and font variations. ATSUCreateAndCopyStyle does not copy reference constants.

To create a new style object without copying a source object, you can call the function ATSUCreateStyle. Alternately, to copy the contents of a source style object into an existing style object, call the function ATSUCopyAttributes.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUCreateAndCopyStyle (
   ATSUStyle iStyle,
   ATSUStyle *oStyle
);

/*ATSUCreateTextLayoutWithTextPtr

Creates an opaque text layout object containing default text layout attributes as well as associated text and text styles.

OSStatus ATSUCreateTextLayoutWithTextPtr (
   ConstUniCharArrayPtr iText,
   UniCharArrayOffset iTextOffset,
   UniCharCount iTextLength,
   UniCharCount iTextTotalLength,
   ItemCount iNumberOfRuns,
   const UniCharCount *iRunLengths,
   ATSUStyle *iStyles,
   ATSUTextLayout *oTextLayout
);
Parameters
iText

A pointer of type ConstUniCharArrayPtr, referring to a text buffer containing UTF-16–encoded text. ATSUI associates this buffer with the new text layout object and analyzes the complete text of the buffer when obtaining the layout context for the current text range. Thus, for paragraph-format text, if you specify a buffer containing less than a complete paragraph, some of ATSUI’s layout results are not guaranteed to be accurate. For example, with a buffer of less than a full paragraph, ATSUI can neither reliably obtain the context for bidirectional processing nor reliably generate accent attachments and ligature formations for Roman text. 
iTextOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the range to include in the layout. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iTextLength parameter. 
iTextLength

A UniCharCount value specifying the length of the text range. Note that iTextOffset + iTextLength must be less than or equal to the value of the iTextTotalLength parameter. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
iTextTotalLength

A UniCharCount value specifying the length of the entire text buffer. This value should be greater than or equal to the range of text defined by the iTextLength parameter.
iNumberOfRuns

An ItemCount value specifying the number of text style runs you want to define within the overall text range. The number of style objects and style run lengths passed in the iStyles and iRunLengths parameters, respectively, should be equal to the number of runs specified here.
iRunLengths

A pointer to the first element in a UniCharCount array. This array provides ATSUI with the lengths of each of the text’s style runs. You can pass kATSUToTextEnd for the last style run length if you want the style run to extend to the end of the text range. If the sum of the style run lengths is less than the total length of the text range, the remaining characters are assigned to the last style run.
iStyles

A pointer to the first element in an ATSUStyle array. Each element in the array must contain a valid style object that corresponds to a style run defined by the iRunLengths array. 
oTextLayout

A valid pointer to an ATSUTextLayout value. On return, the value refers to the newly created text layout object. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCreateTextLayoutWithTextPtr function creates a text layout object associated with style objects and text and containing the default text layout attributes described in “Attribute Tags”. To provide nondefault line or layout attributes for a text layout object, you can call the functions ATSUSetLineControls or ATSUSetLayoutControls. After setting text attributes, call ATSUDrawText to draw the text.

Because the only way that ATSUI interacts with text is via the memory references you associate with a text layout object, you are responsible for keeping these references updated, as in the following cases:
When the user deletes or inserts a subrange within a text buffer (but the buffer itself is not relocated), you should call the functions ATSUTextDeleted and ATSUTextInserted, respectively.
When you relocate the entire text buffer (but no other changes have occurred that would affect the buffer’s current subrange), you should call the function ATSUTextMoved.
When both the buffer itself is relocated and a subrange of the buffer’s text is deleted or inserted (that is, a combination of cases 1 and 2, above), you must use the function ATSUSetTextPointerLocation to inform ATSUI.
When you are associating an entirely different buffer with a text layout object, you must call the function ATSUSetTextPointerLocation.

Note that, because ATSUI objects retain state information, doing superfluous calling can degrade performance. For example, you could call ATSUSetTextPointerLocation rather than ATSUTextInserted when the user inserts text, but there would be a performance penalty, as all the layout caches are flushed when you call ATSUSetTextPointerLocation, rather than just the affected ones.

Text layout objects are readily reusable and should themselves be cached for later use, if possible. Text objects are thread-safe starting with ATSUI version 2.4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUCreateTextLayoutWithTextPtr (
   ConstUniCharArrayPtr iText,
   UniCharArrayOffset iTextOffset,
   UniCharCount iTextLength,
   UniCharCount iTextTotalLength,
   ItemCount iNumberOfRuns,
   const UniCharCount *iRunLengths,
   ATSUStyle *iStyles,
   ATSUTextLayout *oTextLayout
);

/*ATSUSetTransientFontMatching

Turns automatic font substitution on or off for a text layout object.

OSStatus ATSUSetTransientFontMatching (
   ATSUTextLayout iTextLayout,
   Boolean iTransientFontMatching
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object for which to set automatic font substitution on or off. 
iTransientFontMatching

A Boolean value indicating whether ATSUI is to perform automatic font substitution for the text layout object. If you pass true, ATSUI performs automatic font substitution for the text range associated with the text layout object.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

Calling the ATSUSetTransientFontMatching function sets ATSUI’s automatic font substitution to on or off for a given text layout object. When automatic font substitution is on, ATSUI scans the text range associated with specified text layout object looking for undrawable characters whenever a layout is performed, for example, when text is measured or drawn. When ATSUI finds a character that cannot be drawn with the currently assigned font, it identifies a valid font for the character and draws the character. ATSUI continues scanning the text range for characters in need of substitute fonts, replacing the font and redrawing the characters as needed. ATSUI stops scanning when it reaches the end of the text range associated with the text layout object.

ATSUI’s default behavior for finding a substitute font is to use the first valid font that it finds when sequentially scanning the fonts in the user’s system. However, you can alter this behavior by calling the function ATSUCreateFontFallbacks and defining your own font fallback settings for the text layout object. If ATSUI cannot find any suitable replacement fonts, it substitutes the missing-character glyph—that is, a glyph representing an empty box—to indicate to the user that a valid font is not installed on their system.

Note that when ATSUSetTransientFontMatching performs font substitution, it does not change the font attribute in the associated style object. That is, the font attribute for the style object associated with the redrawn character(s) remains set to the invalid font—not the valid substitute font— just as it was prior to calling ATSUSetTransientFontMatching.

If you want ATSUI to identify a substitute font, but you do not want ATSUI to automatically perform the font substitution, you can call the function ATSUMatchFontsToText.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUSetTransientFontMatching (
   ATSUTextLayout iTextLayout,
   Boolean iTransientFontMatching
);

/*ATSUSetLayoutControls

Sets layout control attribute values in a text layout object.

OSStatus ATSUSetLayoutControls (
   ATSUTextLayout iTextLayout,
   ItemCount iAttributeCount,
   const ATSUAttributeTag *iTag,
   const ByteCount *iValueSize,
   const ATSUAttributeValuePtr *iValue
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object for which to set layout control attributes. 
iAttributeCount

An ItemCount value specifying the number of attributes to set. This value should correspond to the number of elements in the iTag and iValueSize arrays.
iTag

A pointer to the initial ATSUAttributeTag value in an array of layout control attribute tags. Each element in the array must contain a valid tag that corresponds to the layout control attribute to set. See “Attribute Tags” for a description of the Apple-defined layout control attribute tag constants. 
iValueSize

A pointer to the initial ByteCount value in an array of attribute value sizes. Each element in the array must contain the size (in bytes) of the corresponding layout control attribute being set. ATSUSetLayoutControls sets layout attributes after confirming the sizes in the array.
iValue

A pointer to the initial ATSUAttributeValuePtr value in an array of attribute value pointers. Each value in the array must correspond to a tag in the iTag array and be a legal value for that tag. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

When you use ATSUI to image your text, you can control the text’s display and formatting at a number of different levels.

One level is that of the entire text range associated with your text layout object, also known as the “layout level.” To affect display and formatting on this level, you can specify various layout control attributes using the ATSUSetLayoutControls function. These attributes affect the width of the text area from margin to margin, the alignment of the text, its justification, rotation, and direction, as well as other layout options.

Another level is that of a single line of text, that is, the “line level.” To affect display and formatting on this level, you specify various line control attributes via the function ATSUSetLineControls. These attributes are similar to those that you can apply on a full-layout basis, but each affects only an individual text line.

Given that ATSUI allows you to control similar aspects of the display and formatting of your text at either the line level or the layout level (or both, or neither), it is up to you to decide how much layout control to take. However, you should note the following:
Setting layout control attributes overrides the corresponding default layout-level settings for a text layout object. Any layout attributes that you do not set retain the default values described in “Attribute Tags”.
Setting line control attributes overrides the corresponding layout-level settings (whether set or at default values) for a text layout object. This is true even if you set the layout-level attributes subsequently to the line-level ones.
From a performance standpoint, it is preferable to work from the layout level and not specify layout line by line unless necessary.

Finally, it is also possible to control the display and formatting of your text at the level of an individual character or “run” of characters. At this level, you customize layout by manipulating style settings in a style object. Among the character-level aspects you can control are style attributes (such as font size and color), font features (such as ligatures), and font variations (such as continually varying font weights or widths). However, there are certain line control attributes (specified via the ATSLineLayoutOptions flags) that can override style attributes applied to the same text.

Similarly to style attributes, you use a “triple” to specify a line or layout control attribute. That is, an attribute tag, the value of the attribute it sets, and the size (in bytes) of the attribute value. Attribute tags are constants supplied by ATSUI. Attribute values may be a scalar, a structure, or a pointer. And as with style attributes, you can also create a custom attribute for a line or layout attribute for which ATSUI does not provide a tag.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUSetLayoutControls (
   ATSUTextLayout iTextLayout,
   ItemCount iAttributeCount,
   const ATSUAttributeTag *iTag,
   const ByteCount *iValueSize,
   const ATSUAttributeValuePtr *iValue
);

/*ATSUSetAttributes

Sets style attribute values in a style object.

OSStatus ATSUSetAttributes (
   ATSUStyle iStyle,
   ItemCount iAttributeCount,
   const ATSUAttributeTag *iTag,
   const ByteCount *iValueSize,
   const ATSUAttributeValuePtr *iValue
);
Parameters
iStyle

An ATSUStyle value specifying the style object for which to set attributes.
iAttributeCount

An ItemCount value specifying the number of attributes to set. This value should correspond to the number of elements in the iTag and iValueSize arrays.
iTag

A pointer to the initial ATSUAttributeTag value in an array of attribute tags. Each element in the array must contain a valid style attribute tag that corresponds to the style attribute value to set. Note that an attribute tag cannot be used in versions of the Mac OS that are earlier than the version in which the tag was introduced. For example, a tag available in Mac OS version 10.2 cannot be used in Mac OS version 10.1 or earlier. You can call the function Gestalt to check version information for ATSUI. See “Attribute Tags” for a description of the Apple-defined style attribute tag constants and for availability information.
iValueSize

A pointer to the initial ByteCount value in an array of attribute value sizes. Each element in the array must contain the size (in bytes) of the corresponding style run attribute value being set. ATSUSetAttributes sets style attributes after confirming the sizes in the array.
iValue

A pointer to the initial ATSUAttributeValuePtr value in an array of attribute value pointers. Each pointer in the array must reference an attribute value corresponding to a tag in the iTag array. The value referenced by the pointer must be legal for that tag.
Return Value

A result code. See “ATSUI Result Codes”. If there is a function error, ATSUSetAttributes does not set any attributes in the style object.
Discussion

Style attributes are a collection of values and settings that override the font-specified behavior for displaying and formatting text in a style run. To specify a style attribute, ATSUI uses a “triple” consisting of (1) an attribute tag, (2) a value for that tag, and (3) the size of the value.

The ATSUSetAttributes function enables you to set multiple style attribute values for a style object. When you call ATSUSetAttributes, any style attributes that you do not set retain their previous values. To set font features and font variations, call the functions ATSUSetFontFeatures and ATSUSetVariations, respectively.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/

OSStatus ATSUSetAttributes (
   ATSUStyle iStyle,
   ItemCount iAttributeCount,
   const ATSUAttributeTag *iTag,
   const ByteCount *iValueSize,
   const ATSUAttributeValuePtr *iValue
);

/*ATSUCreateStyle

Creates an opaque style object containing only default style attributes, font features, and font variations.

OSStatus ATSUCreateStyle (
   ATSUStyle *oStyle
);
Parameters
oStyle

A pointer to an ATSUStyle value. On return, the pointer refers to an empty style object.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCreateStyle function creates a style object containing only default values for style attributes, font features, and font variations. The default values for the font features and variations are assigned by the font. The default style attribute values are described in “Attribute Tags”.

To make changes to the default style attribute values, you can call the function ATSUSetAttributes. To set font features and font variations, call the functions ATSUSetFontFeatures and ATSUSetVariations, respectively. You can also use the function ATSUCreateAndCopyStyle to create a new style object by copying all the settings from an existing one.

For ATSUI to apply your selected character-style information, you must associate the style object with a text run in a text layout object. A text run consists of one or more characters that are contiguous in memory. If you associate these characters with a distinct style, you define a style run. You can use the function ATSUSetRunStyle to define a style run by associating a style object with a run of text in a text layout object. Or, to create a text layout object and associate style objects with it at the same time, you can call the function ATSUCreateTextLayoutWithTextPtr. In either case, each text run in a text layout object must be assigned a style object, which may or may not differ from other style objects assigned to other text runs in the text layout object.

Style objects are readily reusable and should be cached for later use, if possible. You can create a style object once and then use it for as many text layout objects as appropriate. Style objects are thread-safe starting with ATSUI version 2.3.

Note that you are responsible for disposing of the memory allocated for the style object. However, you should dispose of any text layout objects with which the style object is associated prior to disposing of the style object itself. To dispose of a style object, call the function ATSUDisposeStyle.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUCreateStyle (
   ATSUStyle *oStyle
);

/*ATSUSetTextPointerLocation

Associates text with a text layout object or updates previously associated text.

OSStatus ATSUSetTextPointerLocation (
   ATSUTextLayout iTextLayout,
   ConstUniCharArrayPtr iText,
   UniCharArrayOffset iTextOffset,
   UniCharCount iTextLength,
   UniCharCount iTextTotalLength
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object for which to set text. 
iText

A pointer of type ConstUniCharArrayPtr, referring to a text buffer containing UTF-16–encoded text. ATSUI associates this buffer with the text layout object and analyzes the complete text of the buffer when obtaining the layout context for the current text range. Thus, for paragraph-format text, if you specify a buffer containing less than a complete paragraph, some of ATSUI’s layout results are not guaranteed to be accurate. For example, with a buffer of less than a full paragraph, ATSUI can neither reliably obtain the context for bidirectional processing nor reliably generate accent attachments and ligature formations. 
iTextOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the range to include in the layout. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iTextLength parameter. 
iTextLength

A UniCharCount value specifying the length of the text range. Note that iTextOffset + iTextLength must be less than or equal to the value of the iTextTotalLength parameter. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
iTextTotalLength

A UniCharCount value specifying the length of the entire text buffer. This value should be greater than or equal to the range of text defined by the iTextLength parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

For ATSUI to render your text, you must associate the text with both a text layout object and style information. Some functions, such as ATSUCreateTextLayoutWithTextPtr, create a text layout object and associate text with it concurrently. However, if you use the function ATSUCreateTextLayout to create a text layout object, you must assign text to the object prior to attempting most ATSUI operations.

You can use the function ATSUSetTextPointerLocation or to associate text with a text layout object. When you call this function, you are both assigning a text buffer to a text layout object and specifying the current text subrange within the buffer to include in the layout.

If there is already text associated with a text layout object, calling ATSUSetTextPointerLocation overrides the previously associated text, as well as clearing the object’s layout caches. You would typically only call this function for a text layout object with existing associated text if either (a) both the buffer itself is relocated and a subrange of the buffer’s text is deleted or inserted or (b) when associating an entirely different buffer with a text layout object.

Note that, because ATSUI objects retain state, doing superfluous calling can degrade performance. For example, you could call ATSUSetTextPointerLocation rather than ATSUTextInserted when the user simply inserts a subrange of text within a text buffer, but there would be a performance penalty, as all the layout caches are flushed by ATSUSetTextPointerLocation, rather than just the affected ones.

Similarly, you should not call ATSUSetTextPointerLocation, when an entire text buffer associated with a text layout object is relocated, but no other changes have occurred that would affect the buffer’s current subrange. Instead, you should call ATSUTextMoved, which is a more focused function and therefore more efficient.

After associating text with a text layout object, use ATSUSetRunStyle to associate style information with the text. You can then call the function ATSUDrawText to display the text or a subrange of the text.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/
OSStatus ATSUSetTextPointerLocation (
   ATSUTextLayout iTextLayout,
   ConstUniCharArrayPtr iText,
   UniCharArrayOffset iTextOffset,
   UniCharCount iTextLength,
   UniCharCount iTextTotalLength
);

/*ATSUTextInserted

Informs ATSUI of the location and length of a text insertion.

OSStatus ATSUTextInserted (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iInsertionLocation,
   UniCharCount iInsertionLength
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object containing the inserted text. 
iInsertionLocation

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the memory location of the inserted text. To specify an insertion point at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. 
iInsertionLength

A UniCharCount value specifying the length of the inserted text.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

When you call the ATSUTextInserted function to inform ATSUI of a text insertion, it extends the style run containing the insertion point by the amount of the inserted text. If the insertion point is between two style runs, the first style run is extended to include the new text.

The ATSUTextInserted function also extends the total length of the text buffer containing the inserted text by the amount of the inserted text. That is, it shifts the memory location of the text following the inserted text by iInsertionLength. ATSUTextInserted then updates drawing caches.

Note that the ATSUTextInserted function does not change the actual memory location of the inserted text. You are responsible for placing the inserted text into the text buffer at the appropriate location.

The ATSUTextInserted function does not insert style runs or line breaks; to do so, call the functions ATSUSetRunStyle and ATSUSetSoftLineBreak, respectively. Break line operations should be redone after you call ATSUTextInserted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeObjects.h*/

OSStatus ATSUTextInserted (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iInsertionLocation,
   UniCharCount iInsertionLength
);


#ifdef __cplusplus
}
#endif

#endif
