#import <Cocoa/Cocoa.h>
#import <QTKit/QTKitDefines.h>
@class QTMovie;
@class QTMovieContentView;
@class QTMovieControllerView;


@interface QTMovieView : NSView <NSCoding, NSUserInterfaceValidations>
/*pause:

-(IBAction)pause:(id)sender
Discussion

This action method pauses the movie playback. This method does nothing if the movie is already paused.
Availability
Available in Mac OS X v10.3 and later.*/
-(IBAction)pause:(id)sender;

/*setMovie:

-(void)setMovie:(id)movie
Discussion

Sets the QTMovie object in a QTMovieView to movie. The currently set QuickTime movie is disposed of using DisposeMovie, unless the QTMovie was created with a call to initWithQuickTimeMovie and the disposeWhenDone flag was NO.
Availability
Available in Mac OS X v10.3 and later.*/
-(void)setMovie:(id)movie;

/*controllerBarHeight

-(float)controllerBarHeight
Discussion

Returns the height of the controller bar.
Availability
Available in Mac OS X v10.3 and later.*/
-(float)controllerBarHeight;

/*movie

-(QTMovie *)movie
Discussion

Returns the QTMovie object associated with the QTMovieView.
Availability
Available in Mac OS X v10.3 and later.*/
-(QTMovie *)movie;

@end
