#ifndef HISERVICES_H
#include <HIServices/HIServices.h>
#endif
/*ExitToShell

Terminates an application.

void ExitToShell (void);
Discussion

In general, you need to call ExitToShell only if you want your application to terminate without reaching the end of its main function.

The ExitToShell function terminates the calling process. The Process Manager removes your application from the list of open processes and performs any other necessary cleanup operations. In particular, all memory in your application partition and any temporary memory still allocated to your application is released. If necessary, the Application Died Apple event is sent to the process that launched your application.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
void ExitToShell (void){
//TODO
};


/*GetProcessBundleLocation

Retrieves the file system location of the application bundle (or executable file) associated with a process.

OSStatus GetProcessBundleLocation (
   const ProcessSerialNumber * PSN,
   FSRef * location
);
Parameters
PSN

A pointer to a valid process serial number. See ProcessSerialNumber for more information.
location
Return Value

A result code. See “Process Manager Result Codes”.
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSStatus GetProcessBundleLocation (
   const ProcessSerialNumber * PSN,
   FSRef * location){
//TODO
};


/*SetFrontProcess

Moves a process to the foreground.

OSErr SetFrontProcess (
   const ProcessSerialNumber * PSN
);
Parameters
PSN

A pointer to a valid process serial number. You can also pass a process serial number structure containing the constant kCurrentProcess to refer to the current process. See ProcessSerialNumber for more information.
Return Value

A result code. See Process Manager Result Codes.
Discussion

The SetFrontProcess function moves the specified process to the foreground immediately.

If the specified process serial number is invalid or if the specified process is a background-only application, SetFrontProcess returns a nonzero result code and does not change the current foreground process.
Special Considerations

Do not call SetFrontProcess at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr SetFrontProcess (
   const ProcessSerialNumber * PSN){
//TODO
};


/*GetCurrentProcess

Gets information about the current process, if any.

OSErr GetCurrentProcess (
   ProcessSerialNumber * PSN
);
Parameters
PSN

On output, a pointer to the process serial number of the current process, that is, the one currently accessing the CPU. This application can be running in either the foreground or the background. 
Return Value

A result code. See Process Manager Result Codes.
Discussion

Applications can use this function to find their own process serial number. Drivers can use this function to find the process serial number of the current process. You can use the returned process serial number in other Process Manager functions. 

This function is named MacGetCurrentProcess on non Macintosh platforms and GetCurrentProcess on Macintosh computers. However, even Macintosh code can use the MacGetCurrentProcess name because a macro exists that automatically maps that call to GetCurrentProcess.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr GetCurrentProcess (
   ProcessSerialNumber * PSN){
//TODO
};


/*GetFrontProcess

Gets the process serial number of the front process.

OSErr GetFrontProcess (
   ProcessSerialNumber * PSN
);
Parameters
PSN

On return, a pointer to the process serial number of the process running in the foreground. 
Return Value

A result code. See Process Manager Result Codes. If no process is running in the foreground, returns procNotFound.
Discussion

You can use this function to determine if your process or some other process is in the foreground. You can use the process serial number returned in the PSN parameter in other Process Manager functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr GetFrontProcess (
   ProcessSerialNumber * PSN){
//TODO
};

/*GetProcessInformation

Get information about a specific process.

Modified in Carbon

OSErr GetProcessInformation (
   const ProcessSerialNumber * PSN,
   ProcessInfoRec * info
);
Parameters
PSN

A pointer to a valid process serial number. You can pass a process serial number structure containing the constant kCurrentProcess to get information about the current process. See ProcessSerialNumber for more information.
info

On return, a pointer to a structure containing information about the specified process. 
Return Value

A result code. See Process Manager Result Codes.
Discussion

The information returned in the info parameter includes the applications name as it appears in the Application menu, the type and signature of the application, the address of the application partition, the number of bytes in the application partition, the number of free bytes in the application heap, the application that launched the application, the time at which the application was launched, and the location of the application file.

The GetProcessInformation function also returns information about the applications 'SIZE' resource and indicates whether the process is an application or a desk accessory.

You need to specify values for the processInfoLength, processName, and processAppSpec fields of the process information structure. Specify the length of the process information structure in the processInfoLength field. If you do not want information returned in the processName and processAppSpec fields, specify NULL for these fields. Otherwise, allocate at least 32 bytes of storage for the string pointed to by the processName field and, in the processAppSpec field, specify a pointer to an FSSpec structure.

The processName field may not be what you expect, especially if an application has a localized name. The processName field, if not NULL, on return will contain the filename part of the executable file of the application. If you want the localized, user-displayable name for an application, call CopyProcessName.
Special Considerations

Do not call GetProcessInformation at interrupt time.
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Carbon Porting Notes

The processActiveTime field of the returned ProcessInfoRec structure is not used in Carbon on Mac OS X. In Mac OS 8 and 9, the accumulated amount of CPU time used by the process is returned in this field. In Mac OS X, the value returned in this field is always 0.

On Mac OS X, some flags in processMode will not be set as they were on Mac OS 9, even for Classic applications. Mac OS X doesn't support applications which can't be sent into the background, so modeCanBackground will always be set. Similarly, Mac OS X applications will always have mode32BitCompatible and modeHighLevelEventAware set.

Other fields in the ProcessInfoRec structure (such as processSize and processFreeMem) may also no longer be applicable.

In most cases, you should consider using ProcessInformationCopyDictionary if you are running only on Mac OS X. 
Declared In
Processes.h */

OSErr GetProcessInformation (
   const ProcessSerialNumber * PSN,
   ProcessInfoRec * info){
//TODO
};


/*GetNextProcess

Gets information about the next process, if any, in the Process Managers internal list of open processes.

OSErr GetNextProcess (
   ProcessSerialNumber * PSN
);
Parameters
PSN

On input, a pointer to the process serial number of a process. This number should be a valid process serial number returned from LaunchApplication, GetFrontProcess, or GetCurrentProcess, or a process serial number structure containing kNoProcess. For details about this structure, see ProcessSerialNumber. On return, a pointer to the process serial number of the next process, or else kNoProcess. 
Return Value

A result code. See Process Manager Result Codes.
Discussion

The Process Manager maintains a list of all open processes. You can derive this list by using repetitive calls to GetNextProcess. Begin generating the list by calling GetNextProcess and specifying the constant kNoProcess in the PSN parameter. You can then use the returned process serial number to get the process serial number of the next process. Note that the order of the list of processes is internal to the Process Manager. When the end of the list is reached, GetNextProcess returns the constant kNoProcess in the PSN parameter and the result code procNotFound.

You can use the returned process serial number in other Process Manager functions. You can also use this process serial number to specify a target application when your application sends a high-level event. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In  Processes.h*/
OSErr GetNextProcess (
   ProcessSerialNumber * PSN){
//TODO
};


/*AXUIElementCopyElementAtPosition


Returns the accessibility object at the specified position in top-left relative screen coordinates.
extern AXError AXUIElementCopyElementAtPosition (
    AXUIElementRef application,
    float x,
    float y,
    AXUIElementRef *element);  
Parameters
application
The AXUIElementRef representing the application that contains the screen coordinates (or the system-wide accessibility object).
x
The horizontal position.
y
The vertical position.
element
On return, the accessibility object at the position specified by x and y. 

Return Value

If unsuccessful, AXUIElementCopyElementAtPosition may return one of the following error codes, among others: 
kAXErrorNoValue
There is no accessibility object at the specified position.
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.
Discussion 

This function does hit-testing based on window z-order (that is, layering). If one window is on top of another window, the returned accessibility object comes from whichever window is topmost at the specified location. Note that if the system-wide accessibility object is passed in the application parameter, the position test is not restricted to a particular application.*/
AXError AXUIElementCopyElementAtPosition (
    AXUIElementRef application,
    float x,
    float y,
    AXUIElementRef *element){
//TODO
};  

/*AXUIElementCreateSystemWide


Returns an accessibility object that provides access to system attributes. 
extern AXUIElementRef AXUIElementCreateSystemWide (
    void);  
Return Value

The AXUIElementRef representing the system-wide accessibility object. 
Discussion 

This is useful for things like finding the focused accessibility object regardless of which application is currently active.*/
AXUIElementRef AXUIElementCreateSystemWide (
    void){
//TODO
};  


/*AXAPIEnabled


Returns whether the accessibility API is enabled. 
extern Boolean AXAPIEnabled ();  
Return Value

Returns TRUE if the accessibility API is currently enabled, otherwise FALSE. 
Discussion 

Assistive applications will not work if the accessibility API is not enabled or if the calling process is not a trusted accessibility client. Users can enable the accessibility API by checking "Enable access for assistive devices" in Universal Access Preferences.*/
 Boolean AXAPIEnabled (){
//TODO
};  


/*AXUIElementCopyAttributeNames


Returns a list of all the attributes supported by the specified accessibility object.
extern AXError AXUIElementCopyAttributeNames (
    AXUIElementRef element,
    CFArrayRef *names);  
Parameters
element
The AXUIElementRef representing the accessibility object.
names
On return, an array containing the accessibility object's attribute names. 

Return Value

If unsuccessful, AXUIElementCopyAttributeNames may return one of the following error codes, among others: 
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorIllegalArgument
One or both of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorFailure
There was a system memory failure.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
 AXError AXUIElementCopyAttributeNames (
    AXUIElementRef element,
    CFArrayRef *names){
//TODO
};  


/*AXUIElementGetAttributeValueCount


Returns the count of the array of an accessibility object's attribute value.
extern AXError AXUIElementGetAttributeValueCount (
    AXUIElementRef element,
    CFStringRef attribute,
    CFIndex *count);  
Parameters
element
The AXUIElementRef representing the accessibility object.
attribute
The attribute name.
count
On return, the size of the array that is the attribute's value. 

Return Value

If unsuccessful, AXUIElementGetAttributeValueCount may return one of the following error codes, among others: 
kAXErrorIllegalArgument
The attribute's value is not an array or one of the other arguments is an illegal value.
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
AXError AXUIElementGetAttributeValueCount (
    AXUIElementRef element,
    CFStringRef attribute,
    CFIndex *count){
//TODO
};  


/*AXUIElementCopyAttributeValue


Returns the value of an accessibility object's attribute.
extern AXError AXUIElementCopyAttributeValue (
    AXUIElementRef element,
    CFStringRef attribute,
    CFTypeRef *value);  
Parameters
element
The AXUIElementRef representing the accessibility object.
attribute
The attribute name.
value
On return, the value associated with the specified attribute. 

Return Value

If unsuccessful, AXUIElementCopyAttributeValue may return one of the following error codes, among others: 
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorNoValue
The specified attribute does not have a value.
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
AXError AXUIElementCopyAttributeValue (
    AXUIElementRef element,
    CFStringRef attribute,
    CFTypeRef *value){
//TODO
};  


/*AXUIElementGetTypeID


Returns the unique type identifier for the AXUIElementRef type.
extern CFTypeID AXUIElementGetTypeID (
    void);  
Return Value

Returns a CFTypeID representing the AXUIElementRef type.*/
 CFTypeID AXUIElementGetTypeID (    void){
//TODO
};  


/*AXValueGetType

extern AXValueType AXValueGetType(
    AXValueRef value);  
Parameters
value


Discussion 

Returns the structure type encoded in value. If the type is not recognized, it returns kAXValueIllegalType.*/
AXValueType AXValueGetType(
    AXValueRef value){
//TODO
};  


/*AXValueGetValue

extern Boolean AXValueGetValue(
    AXValueRef value,
    AXValueType theType,
    void *valuePtr);  
Parameters
value


Discussion 

Decodes the structure stored in value and copies it into valuePtr. If the structure stored in value is not the same as requested by theType, the function returns false.*/
Boolean AXValueGetValue(
    AXValueRef value,
    AXValueType theType,
    void *valuePtr){
//TODO
};  


/*AXUIElementIsAttributeSettable


Returns whether the specified accessibility object's attribute can be modified. 
extern AXError AXUIElementIsAttributeSettable (
    AXUIElementRef element,
    CFStringRef attribute,
    Boolean *settable);  
Parameters
element
The AXUIElementRef representing the accessibility object.
attribute
The attribute name.
settable
On return, a Boolean value indicating whether the attribute is settable. 

Return Value

If unsuccessful, AXUIElementIsAttributeSettable may return one of the following error codes, among others: 
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way (often due to a timeout).
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorNoValue
The specified attribute does not have a value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorNotImplemented
The process does not fully support the accessibility API.
Discussion 

If you receive a kAXErrorCannotComplete error from this function, you might want to repeat the request or change the timeout value.*/
AXError AXUIElementIsAttributeSettable (
    AXUIElementRef element,
    CFStringRef attribute,
    Boolean *settable){
//TODO
};


/*UIElementCopyActionNames


Returns a list of all the actions the specified accessibility object can perform. 
extern AXError AXUIElementCopyActionNames (
    AXUIElementRef element,
    CFArrayRef *names);  
Parameters
element
The AXUIElementRef representing the accessibility object.
names
On return, an array of actions the accessibility object can perform (empty if the accessibility object supports no actions). 

Return Value

If unsuccessful, AXUIElementCopyActionNames may return one of the following error codes, among others: 
kAXErrorIllegalArgument
One or both of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorFailure
There was some sort of system memory failure.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
AXError AXUIElementCopyActionNames (
    AXUIElementRef element,
    CFArrayRef *names){
//TODO
};  


/*AXUIElementCopyActionDescription


Returns a localized description of the specified accessibility object's action.
extern AXError AXUIElementCopyActionDescription (
    AXUIElementRef element,
    CFStringRef action,
    CFStringRef *description);  
Parameters
element
The AXUIElementRef representing the accessibility object.
action
The action to be described.
description
On return, a string containing the description of the action. 

Return Value

If unsuccessful, AXUIElementCopyActionDescription may return one of the following error codes, among others: 
kAXErrorActionUnsupported
The specified AXUIElementRef does not support the specified action (you will also receive this error if you pass in the system-wide accessibility object).
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.*/
AXError AXUIElementCopyActionDescription (
    AXUIElementRef element,
    CFStringRef action,
    CFStringRef *description){
//TODO
};  


/*AXValueCreate

extern AXValueRef AXValueCreate (
    AXValueType theType,
    const void *valuePtr);  
Parameters
theType
valuePtr


Discussion 

Encodes a structure pointed to by valuePtr into a CFTypeRef.*/
AXValueRef AXValueCreate (
    AXValueType theType,
    const void *valuePtr){
//TODO
};  



/*AXUIElementSetAttributeValue


Sets the accessibility object's attribute to the specified value. 
extern AXError AXUIElementSetAttributeValue (
    AXUIElementRef element,
    CFStringRef attribute,
    CFTypeRef value);  
Parameters
element
The AXUIElementRef representing the accessibility object.
attribute
The attribute name.
value
The new value for the attribute. 

Return Value

If unsuccessful, AXUIElementSetAttributeValue may return one of the following error codes, among others: 
kAXErrorIllegalArgument
The value is not recognized by the accessible application or one of the other arguments is an illegal value.
kAXErrorAttributeUnsupported
The specified AXUIElementRef does not support the specified attribute.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way.
kAXErrorNotImplemented
The process does not fully support the accessibility API.
Discussion 

You can send and receive many different CFTypeRefs using the accessibility API. These include all CFPropertyListRef types, AXUIElementRef, AXValueRef, AXTextMarkerRef, AXTextMarkerRangeRef, CFNullRef, CFAttributedStringRef, and CRURLRef.*/
AXError AXUIElementSetAttributeValue (
    AXUIElementRef element,
    CFStringRef attribute,
    CFTypeRef value){
//TODO
};  


/*AXUIElementGetPid


Returns the process ID associated with the specified accessibility object.
extern AXError AXUIElementGetPid (
    AXUIElementRef element,
    pid_t *pid);  
Parameters
element
The AXUIElementRef representing an accessibility object.
pid
On return, the process ID associated with the specified accessibility object. 

Return Value

If unsuccessful, AXUIElementGetPid may return one of the following error codes, among others: 
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.*/
AXError AXUIElementGetPid (
    AXUIElementRef element,
    pid_t *pid){
//TODO
};  


/*AXUIElementPerformAction


Requests that the specified accessibility object perform the specified action. 
extern AXError AXUIElementPerformAction (
    AXUIElementRef element,
    CFStringRef action);  
Parameters
element
The AXUIElementRef representing the accessibility object.
action
The action to be performed. 

Return Value

If unsuccessful, AXUIElementPerformAction may return one of the following error codes, among others: 
kAXErrorActionUnsupported
The specified AXUIElementRef does not support the specified action (you will also receive this error if you pass in the system-wide accessibility object).
kAXErrorIllegalArgument
One or more of the arguments is an illegal value.
kAXErrorInvalidUIElement
The AXUIElementRef is invalid.
kAXErrorCannotComplete
The function cannot complete because messaging has failed in some way or the application has not yet responded.
kAXErrorNotImplemented
The process does not fully support the accessibility API.
Discussion 

It is possible to receive the kAXErrorCannotComplete error code from this function because accessible applications often need to perform some sort of modal processing inside their action callbacks and they may not return within the timeout value set by the accessibility API. This does not necessarily mean that the function has failed, however. If appropriate, your assistive application can try to call this function again. Also, you may be able to increase the timeout value (see AXUIElementSetMessagingTimeout).*/
AXError AXUIElementPerformAction (
    AXUIElementRef element,
    CFStringRef action){
//TODO
};  


/*GetProcessForPID

Obtains the process serial number from a Unix PID. 

OSStatus GetProcessForPID(
   pid_t                  pid,
   ProcessSerialNumber *  psn);
Parameters
pid

The Unix process ID (PID).
psn

On return, psn points to the process serial number.
Return Value

A result code. See “Process Manager Result Codes”.
Discussion

Note that this call does not make sense for Classic applications, since they all share a single UNIX process ID.
Availability
Available in Mac OS X version 10.0 and later in ApplicationServices.framework.
Declared In
Processes.h*/
OSStatus GetProcessForPID(
   pid_t                  pid,
   ProcessSerialNumber *  psn){
//TODO
};

/*LaunchApplication

Launches an application.

OSErr LaunchApplication (
   LaunchPBPtr LaunchParams
);
Parameters
LaunchParams

A pointer to a LaunchParamBlockRec specifying information about the application to launch. 
Return Value

A result code. See “Process Manager Result Codes”.
Discussion

The LaunchApplication function launches the application from the specified file and returns the process serial number, preferred partition size, and minimum partition size if the application is successfully launched.

Note that if you launch another application without terminating your application, the launched application is not actually executed until you make a subsequent call to WaitNextEvent or EventAvail.

Set the launchContinue flag in the launchControlFlags field of the launch parameter block if you want your application to continue after the specified application is launched. If you do not set this flag, LaunchApplication terminates your application after launching the specified application, even if the launch fails. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr LaunchApplication (
   LaunchPBPtr LaunchParams){
//TODO
};


/*PasteboardGetItemIdentifier

Obtains the item identifier for an item in a pasteboard.

OSStatus PasteboardGetItemIdentifier (
PasteboardRef inPasteboard,
UInt32 inIndex,
PasteboardItemID *outItem
Parameters
inPasteboard

The pasteboard containing the data. 
inIndex

The one-based index number of the data item whose identifier you want to obtain.
outItem

On return, outItem points to the item identifier for the data item at index inIndex.
Return Value

A result code. 
Discussion

The item index is one-based to match the convention used by the Drag Manager.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardGetItemIdentifier (
PasteboardRef inPasteboard,
UInt32 inIndex,
PasteboardItemID *outItem){};



/*PasteboardCopyItemFlavorData

Obtains data from a pasteboard for the desired flavor.

OSStatus PasteboardCopyItemFlavorData (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef *outData
);
Parameters
inPasteboard

The pasteboard containing the data.
inItem

The identifier for the item whose flavor data you want to obtain. 
inFlavorType

The flavor of the data you want to obtain, specified as a uniform type identifier. 
outData

On return, outData points to the flavor data. You must release this data using CFRelease when you are done using it. 
Return Value

A result code.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardCopyItemFlavorData (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef *outData
){};


/*CopyProcessName

Gets a copy of the name of a process.

OSStatus CopyProcessName (
   const ProcessSerialNumber * PSN,
   CFStringRef * name
);
Parameters
PSN

A pointer to a valid process serial number. See ProcessSerialNumber for more information.
name

A Core Foundation string that contains the name of the specified process. 
Return Value

A result code. See “Process Manager Result Codes”.
Discussion

Because the string returned is a Core Foundation string, it can represent a multilingual name, unlike the processName field value you obtain using GetProcessInformation.
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/

OSStatus CopyProcessName (
   const ProcessSerialNumber * PSN,
   CFStringRef * name
){};

/*SameProcess

Determines whether two process serial numbers specify the same process.

OSErr SameProcess (
   const ProcessSerialNumber * PSN1,
   const ProcessSerialNumber * PSN2,
   Boolean * result
);
Parameters
PSN1

A process serial number. 
PSN2

A process serial number.
result

On return, a pointer to a Boolean value which is TRUE if the process serial numbers passed in PSN1 and PSN2 refer to the same process; otherwise FALSE. 
Return Value

A result code. See “Process Manager Result Codes”.
Discussion

Do not attempt to compare two process serial numbers by any means other than the SameProcess function, because the interpretation of the bits in a process serial number is internal to the Process Manager.

The values of PSN1 and PSN2 must be valid process serial numbers returned from LaunchApplication , GetNextProcess , GetFrontProcess , GetCurrentProcess , or a high-level event. You can also pass a process serial number structure containing the constant kCurrentProcess to refer to the current process. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X version 10.0 and later.
Declared In
Processes.h*/
OSErr SameProcess (
   const ProcessSerialNumber * PSN1,
   const ProcessSerialNumber * PSN2,
   Boolean * result
){};



/*PasteboardGetItemCount

Obtains the number of data items in the specified pasteboard.

OSStatus PasteboardGetItemCount (
   PasteboardRef inPasteboard,
   ItemCount *outItemCount
);
Parameters
inPasteboard

The pasteboard whose items you want to count.
outItemCount

On return, outItemCount points to the number of items in the pasteboard.
Return Value

A result code.
Discussion

You usually call this function before calling PasteboardGetItemIdentifier.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardGetItemCount (
   PasteboardRef inPasteboard,
   ItemCount *outItemCount
){};


/*PasteboardCopyItemFlavors

Obtains an array of flavors for a specified item in a pasteboard. 

OSStatus PasteboardCopyItemFlavors (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFArrayRef *outFlavorTypes
);
Parameters
inPasteboard

The pasteboard containing the data.
inItem

The identifier for the item whose flavors you want to obtain. 
outFlavorTypes

On return, outFlavorTypes points to an array of flavors, specified as uniform type identifiers. You must release this array by calling CFRelease when you are done using it. 
Return Value

A result code. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
OSStatus PasteboardCopyItemFlavors (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFArrayRef *outFlavorTypes
){};


/*GetIconRef

Provides an IconRef for an icon in the desktop database or for a registered icon.

OSErr GetIconRef (
   SInt16 vRefNum,
   OSType creator,
   OSType iconType,
   IconRef * theIconRef
);
Parameters
vRefNum

The volume where Icon Services should start to search for the desired icon. Pass the kOnSystemDisk constant if you are not sure which value to specify in this parameter.
creator

The creator code of the desired icon.
iconType

The type code of the desired icon.
theIconRef

On return, a pointer to the desired icon data.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

Icon Services defines constants for commonly-used system icons. You can pass one of these constants in the iconType parameter if you specify kSystemIconsCreator in the creator parameter. See “Folder Icon Constants” for a list of these constants.

Calling the GetIconRef function increments the reference count of the IconRef.

Remember to call the function ReleaseIconRef when you are done with an IconRef.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr GetIconRef (
   SInt16 vRefNum,
   OSType creator,
   OSType iconType,
   IconRef * theIconRef
){};


/*ReleaseIconRef

Decrements the reference count for an IconRef.

OSErr ReleaseIconRef (
   IconRef theIconRef
);
Parameters
theIconRef

An IconRef whose reference count you wish to decrement.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

When an IconRef’s reference count reaches 0, all memory allocated for the IconRef is marked as disposable. Any subsequent attempt to use the IconRef returns a result code of - 2580 (invalidIconRefErr).
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr ReleaseIconRef (
   IconRef theIconRef
){};

/*PlotIconRefInContext

Plots an IconRef using Quartz.

OSStatus PlotIconRefInContext (
   CGContextRef inContext,
   const CGRect * inRect,
   IconAlignmentType inAlign,
   IconTransformType inTransform,
   const RGBColor * inLabelColor,
   PlotIconRefFlags inFlags,
   IconRef inIconRef
);
Parameters
inContext

The graphics context to use. 
inRect

A pointer to the rectangle to plot the icon in. 
inAlign

The icon alignment. See “Icon Alignment Constants”.
inTransform

The icon transform. See “Icon Transformation Constants”.
inLabelColor

A pointer to the icon label color. 
inFlags

The drawing flags to use; this is usually kPlotIconRefNormalFlags.
inIconRef

The IconRef to plot.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
Icons.h*/

OSStatus PlotIconRefInContext (
   CGContextRef inContext,
   const CGRect * inRect,
   IconAlignmentType inAlign,
   IconTransformType inTransform,
   const RGBColor * inLabelColor,
   PlotIconRefFlags inFlags,
   IconRef inIconRef
){};

/*SetIconFamilyData

Provides new raw icon data for an individual element of an icon family.

OSErr SetIconFamilyData (
   IconFamilyHandle iconFamily,
   OSType iconType,
   Handle h
);
Parameters
iconFamily

A handle to an iconFamily data structure to be used as the target.
iconType

The format of the icon data you provide.You may specify one of the icon types (as defined in IconStorage.h in the CoreServices/OSServices framework) or 'PICT' in this parameter. For a thumbnail icon, for example, you specify kThumbnail32BitData in this parameter. For a thumbnail mask, you specify kThumbnail8BitMask.
h

A handle to the icon data you provide. For a thumbnail icon, the handle contains raw image data in the form of 128x128, four bytes per pixel, RGB data. For a thumbnail mask, the data is in the same format except that it is one byte per pixel.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h 
SetSuiteLabel*/
OSErr SetIconFamilyData (
   IconFamilyHandle iconFamily,
   OSType iconType,
   Handle h
){};



/*NewIconSuite

Gets a handle to an empty icon suite. 

OSErr NewIconSuite (
   IconSuiteRef * theIconSuite
);
Parameters
theIconSuite

On return, a pointer to a handle to a new, empty icon suite. Use the AddIconToSuite function to add handles to icon data.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

When you create an icon suite using this function, it sets the default label for the suite to none. To set a new default label for an icon suite, use the SetSuiteLabel function. NewIconSuite allocates the memory for the icon suite handle. To release the memory occupied by an icon suite, you must use the DisposeIconSuite function. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/
OSErr NewIconSuite (
   IconSuiteRef * theIconSuite
){};


/*AddIconToSuite

Adds an icon to an icon suite.

OSErr AddIconToSuite (
   Handle theIconData,
   IconSuiteRef theSuite,
   ResType theType
);
Parameters
theIconData

A handle to the data for the new icon to be added to the icon suite. You can obtain a handle to icon data using various functions, such as GetIcon or GetResource.

The handle to the icon data is added at the location reserved for icon data of the type specified by theType. If the icon suite already includes a handle to icon data for that type, this function replaces the handle to the old data without disposing of it. In this case you may want to call the GetIconFromSuite function first to obtain the old handle so that you can dispose of it. 

The handles that you add to the suite do not have to be associated with a resource fork. For example, your application might get icon data from the desktop database rather than reading it from a resource, or your application might read icon data from a resource and then detach it.
theSuite

A handle to the icon suite to which to add the icon.
theType

The resource type of the new icon. The resource type should be that of an icon family member.
Return Value

A result code. See “Icon Services and Utilities Result Codes”.
Discussion

This function is most often used to read icons into an empty icon suite created with the NewIconSuite function. 
Special Considerations

This function may move or purge memory blocks in the application heap. For that reason, your application should not call it at interrupt time.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Icons.h*/

OSErr AddIconToSuite (
   Handle theIconData,
   IconSuiteRef theSuite,
   ResType theType
){};


/*PasteboardCreate

Creates a reference to the specified global pasteboard.

OSStatus PasteboardCreate (
CFStringRef inName
PasteboardRef *outPasteboard
);
Parameters
inName

The name of the pasteboard to reference. 
outPasteboard

On return, outPasteboard points to the specified pasteboard. 
Return Value

A result code.
Discussion

If the pasteboard you specify does not yet exist, this function creates it. You can use this function to create your own pasteboards to store and pass data. Pasteboard names should have a reverse DNS-style name to ensure uniqueness. 

You can also specify kPasteboardFind to obtain a reference to the Find pasteboard or kPasteboardClipboard for a reference to the standard clipboard. If you pass kPasteboardUniqueName (= NULL) , the system creates a unique pasteboard for your application.

When you are finished with a pasteboard reference, you can call CFRelease to release it. If you do not release the reference, the pasteboard continues to exist even after your application terminates. A subsequently launched application can then find a previously created pasteboard by name and examine the data within it. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/

OSStatus PasteboardCreate (
CFStringRef inName,
PasteboardRef *outPasteboard
){};


/*PasteboardClear

Clears the contents of the specified pasteboard.

OSStatus PasteboardClear (
PasteboardRef inPasteboard
);
Parameters
inPasteboard

The pasteboard you want to clear.
Return Value

A result code.
Discussion

After calling this function, the application owns the pasteboard and can add data to it. You must call PasteboardClear before modifying a pasteboard. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/

OSStatus PasteboardClear (
PasteboardRef inPasteboard
){};


/*PasteboardPutItemFlavor

Adds flavor data or a promise to the specified pasteboard.

OSStatus PasteboardPutItemFlavor (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef inData,
PasteboardFlavorFlags inFlags
);
Parameters
inPasteboard

The pasteboard to which to add flavor data or a promise.
inItem

The identifier for the item to which to add flavor data or a promise.
inFlavorType

The flavor type of the data or promise you are adding, specified as a uniform type identifier. 
inData

The data to add. If you pass kPasteboardPromisedData (= NULL), the data is promised. 
inFlags

A bit field of flags for the specified flavor.
Return Value

A result code. 
Discussion

If you promise data, you must have implemented a promise keeper callback beforehand to deliver the data when asked for it (see PasteboardPromiseKeeperProcPtr for more details). Typically you store promises instead of the actual data when the data requires a large overhead to generate. 

You can call this function multiple times to add multiple flavors to a given item. You should add the flavors in your application’s order of preference or richness. 
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/

OSStatus PasteboardPutItemFlavor (
PasteboardRef inPasteboard,
PasteboardItemID inItem,
CFStringRef inFlavorType,
CFDataRef inData,
PasteboardFlavorFlags inFlags
){};


/*PasteboardSynchronize

Synchronizes the local pasteboard reference to reflect the contents of the global pasteboard.

PasteboardSyncFlags PasteboardSynchronize (
PasteboardRef inPasteboard
);
Parameters
inPasteboard

The pasteboard you want to synchronize.
Return Value

A flag indicating what synchronization actions occurred.
Discussion

Calling this function compares the local pasteboard reference with its global pasteboard. If the global pasteboard was modified, it updates the local pasteboard reference to reflect this change. You typically call this function whenever your application becomes active, so that its pasteboard information reflects any changes that occurred while it was in the background. This function has low overhead, so you should call it whenever you suspect a global pasteboard may have been changed.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
Pasteboard.h*/
PasteboardSyncFlags PasteboardSynchronize (
PasteboardRef inPasteboard
){};















