#ifndef OPENGL_H
#include <OpenGL/OpenGL.h>
#endif

/*CGLGetCurrentContext

Returns the current rendering context.

CGLContextObj CGLGetCurrentContext(void);
Return Value

The current rendering context. If there is none, returns NULL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetCurrentContext*/
CGLContextObj CGLGetCurrentContext(void){
//TODO
};


/*CGLLockContext

Locks a CGL rendering context.

CGLError CGLLockContext(CGLContextObj ctx)
Parameters
ctx

The CGL context to lock.
Return Value

A result code. See “CGL Result Codes”.
Discussion

The function CGLLockContext blocks the thread it is on until all other threads have unlocked the same context using the function CGLUnlockContext. You can use CGLLockContext recursively. Context-specific CGL calls by themselves do not require locking, but you can guarantee serial processing for a group of calls by surrounding them with CGLLockContext and CGLUnlockContext. Keep in mind that calls from the OpenGL API (the API provided by the Architecture Review Board) require locking.

Applications that use NSOpenGL classes with multithreading can lock contexts using the functions CGLLockContext and CGLUnlockContext. To perform rendering in a thread other than the main one, you can lock the context that you want to access and safely execute OpenGL commands. The locking calls must be placed around all OpenGL calls in all threads.

For more information on multithreading OpenGL applications, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.4 and later.
Declared In
OpenGL.h
See Also
CGLUnlockContext*/
CGLError CGLLockContext(CGLContextObj ctx){
//TODO
};



/*CGLUnlockContext

Unlocks a CGL rendering context.

CGLError CGLUnlockContext(CGLContextObj ctx)
Parameters
ctx

The CGL context to unlock.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
OpenGL.h
See Also
CGLLockContext*/
CGLError CGLUnlockContext(CGLContextObj ctx){
//TODO
};

/*CGLGetParameter

Retrieves the value of a rendering context parameter.

CGLError CGLGetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   long  *params);
Parameters
ctx

A rendering context.
pname

The parameter whose value you want to retrieve. For a list of possible parameters, see Context Parameters.
params

On return, points to the value of the parameter.
Return Value

A result code. See “CGL Result Codes”.
Discussion

Some parameters may need to have a corresponding context option enabled for their value to take effect. You can enable, disable, and test whether an option is enabled with CGLEnable, CGLDisable, and CGLIsEnabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetParameter*/
CGLError CGLGetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   long  *params){};



/*GLUORTHO2D(3G)                                                  GLUORTHO2D(3G)



NAME
       gluOrtho2D - define a 2D orthographic projection matrix


C SPECIFICATION
       void gluOrtho2D( GLdouble left,
                        GLdouble right,
                        GLdouble bottom,
                        GLdouble top )


PARAMETERS
       left, right Specify  the  coordinates  for  the left and right vertical
                   clipping planes.

       bottom, top Specify the coordinates for the bottom and  top  horizontal
                   clipping planes.

DESCRIPTION
       gluOrtho2D sets up a two-dimensional orthographic viewing region.  This
       is equivalent to calling glOrtho with near = -1 and far = 1.

SEE ALSO
       glOrtho, gluPerspective*/
  void gluOrtho2D( GLdouble left,
                        GLdouble right,
                        GLdouble bottom,
                        GLdouble top ){};

/*GLUERRORSTRING(3G)                                          GLUERRORSTRING(3G)



NAME
       gluErrorString - produce an error string from a GL or GLU error code


C SPECIFICATION
       const GLubyte * gluErrorString( GLenum error )


PARAMETERS
       error  Specifies a GL or GLU error code.

DESCRIPTION
       gluErrorString  produces  an  error string from a GL or GLU error code.
       The string is in ISO Latin  1  format.  For  example,  gluErrorString(-gluErrorString(GL_OUT_OF_MEMORY)
       GL_OUT_OF_MEMORY) returns the string out of memory.

       The  standard  GLU error codes are GLU_INVALID_ENUM, GLU_INVALID_VALUE,
       and GLU_OUT_OF_MEMORY.  Certain other GLU functions can return special-specialized
       ized  error codes through callbacks.  See the glGetError reference page
       for the list of GL error codes.

ERRORS
       NULL is returned if error is not a valid GL or GLU error code.

SEE ALSO
       glGetError, gluNurbsCallback, gluQuadricCallback, gluTessCallback



                                                            GLUERRORSTRING(3G)*/
       const GLubyte * gluErrorString( GLenum error ){};


/*GLUPERSPECTIVE(3G)                                          GLUPERSPECTIVE(3G)



NAME
       gluPerspective - set up a perspective projection matrix


C SPECIFICATION
       void gluPerspective( GLdouble fovy,
                            GLdouble aspect,
                            GLdouble zNear,
                            GLdouble zFar )


PARAMETERS
       fovy    Specifies  the field of view angle, in degrees, in the y direc-direction.
               tion.

       aspect  Specifies the aspect ratio that determines the field of view in
               the x direction.  The aspect ratio is the ratio of x (width) to
               y (height).

       zNear   Specifies the distance from the viewer  to  the  near  clipping
               plane (always positive).

       zFar    Specifies  the  distance  from  the  viewer to the far clipping
               plane (always positive).

DESCRIPTION
       gluPerspective specifies a viewing frustum into  the  world  coordinate
       system.   In  general,  the aspect ratio in gluPerspective should match
       the aspect ratio of the associated viewport. For example, aspect =  2.0
       means  the  viewer's angle of view is twice as wide in x as it is in y.
       If the viewport is twice as wide as it is tall, it displays  the  image
       without distortion.

       The  matrix  generated  by  gluPerspective  is multipled by the current
       matrix, just as if glMultMatrix were called with the generated  matrix.
       To  load  the perspective matrix onto the current matrix stack instead,
       precede the call to gluPerspective with a call to glLoadIdentity.

       Given f defined as follows:

                               f  = cotangent(fovy/2)

       The generated matrix is
             f
        ------------       0              0              0
           aspect


            0              f              0              0

                                      zFar+zNear    2*zFar*zNear
            0              0          ----------    -----------------------zNear-zFar
                                      zNear-zFar     zNear-zFar

            0              0              -1             0



NOTES
       Depth buffer precision is affected by the values  specified  for  zNear
       and  zFar.   The greater the ratio of zFar to zNear is, the less effec-effective
       tive the depth buffer will be at distinguishing between  surfaces  that
       are near each other.  If

                                   r = zFar/zNear


       roughly  log2(r)  bits  of  depth buffer precision are lost.  Because r
       approaches infinity as zNear approaches 0, zNear must never be  set  to
       0.

SEE ALSO
       glFrustum, glLoadIdentity, glMultMatrix, gluOrtho2D



                                                            GLUPERSPECTIVE(3G)*/
void gluPerspective( GLdouble fovy,
                              GLdouble aspect,
                            GLdouble zNear,
                            GLdouble zFar ){};






