#import <Cocoa/Cocoa.h>
#import <QuickTime/QuickTime.h>
#import <QTKit/QTKit.h>
//#import <QTKit/QTTime.h>
//#import <QTKit/QTTimeRange.h>
//#import <QTKit/QTMovie.h>

@implementation QTMovie



/*initWithFile:error:

- (id)initWithFile:(NSString *)fileName error:(NSError **)errorPtr
Discussion

Initializes a QTMovie object with the data in the file specified by the name fileName. The fileName is assumed to be a full path name for a file. If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.

Note that alias files should not be passed into this method; the client application is responsible for resolving aliases before handing them to QTKit methods.
Availability
Available in Mac OS X v10.3 and later.*/
- (id)initWithFile:(NSString *)fileName error:(NSError **)errorPtr
 {
}

/*setAttribute:forKey:

- (void)setAttribute:(id)value forKey:(NS String *)attributeKey
Discussion

Set the movie attribute attributeKey to the value specified by the value parameter. A list of supported movie attributes and their acceptable values can be found in the “Constants” section.
Availability
Available in Mac OS X v10.3 and later.*/

- (void) setAttribute: (id)value forKey: (NSString *)attributeKey
 {
//TODO
}

/*quickTimeMovie

- (Movie)quickTimeMovie
Discussion

Returns the QuickTime movie associated with a QTMovie object.
Availability
Available in Mac OS X v10.3 and later.
See Also
– quickTimeMovieController*/
- (Movie)quickTimeMovie{
//TODO
}

/*attributeForKey:

- (id)attributeForKey:(NSString *)attributeKey
Discussion

Returns the current value of the movie attribute attributeKey. A list of supported movie attributes and their acceptable values can be found in the “Constants” section.
Availability
Available in Mac OS X v10.3 and later.*/
- (id)attributeForKey:(NSString *)attributeKey{
//TODO
}

/*play

- (void)play
Discussion

Plays the movie.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)play{
//TODO
}

/*movieFileTypes:

+ (NSArray *)movieFileTypes:(QTMovieTypeOptions)types
Discussion

Returns an array of file types that can be opened as QuickTime movies. Passing zero as the options parameter returns an array of all the common file types that QuickTime can open in place on the current system. This array includes the file type .mov and .mqv, and any files types that can be opened using a movie importer that does not need to write data into a new file while performing the import. This array excludes any file types for still images and any file types that require an aggressive movie importer (for instance, the movie importer for text files). The following values can be used to include some or all of the file types that are normally excluded:enum {
    QTIncludeStillImageTypes  =  1 << 0,
    QTIncludeTranslatableTypes =  1 << 1,
    QTIncludeAggressiveTypes =  1 << 2,
    QTIncludeCommonTypes = 0,
    QTIncludeAllTypes = 0xffff
} QTMovieFileTypeOptions;

Constants	
Description

QTIncludeStillImageTypes	
This value adds to the array all file types for still images that can be opened using a graphics importer.

QTIncludeTranslatableTypes	
This value adds to the array all file types for files that can be opened using a movie importer but for which a new file must be created.

QTIncludeAggressiveTypes	
This value adds to the array all file types for files that can be opened using a movie importer but that are not commonly used in connection with movies (for instance, text or HTML files).

QTIncludeCommonTypes	
This value adds to the array all common file types that QuickTime can open in place on the current system.

QTIncludeAllTypes	
This value adds to the array all file types that QuickTime can open on the current system, using any available movie or graphics importer.

Availability
Available in Mac OS X v10.3 and later.*/
+ (NSArray *)movieFileTypes:(QTMovieFileTypeOptions)types{}


/*movieWithURL:error:

+ (id)movieWithURL:(NSURL *)url error:(NSError **)errorPtr
Discussion

Creates a QTMovie object initialized with the data in the URL specified by url. 

If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.
Availability
Available in Mac OS X v10.3 and later.*/
+ (id)movieWithURL:(NSURL *)url error:(NSError **)errorPtr{}


/*movieAttributes

- (NSDictionary *)movieAttributes
Discussion

Returns a dictionary containing the current values of all defined movie attributes. A list of supported movie attributes and their acceptable values can be found in the “Constants” section.
Availability
Available in Mac OS X v10.3 and later.*/
- (NSDictionary *)movieAttributes{}

/*currentTime

- (QTTime)currentTime
Discussion

Returns the current time of a QTMovie object as a structure of type QTTime.
Availability
Available in Mac OS X v10.3 and later.*/
- (QTTime)currentTime{}


/*setCurrentTime:

- (void)setCurrentTime:(QTTime)time
Discussion

Sets the movie’s current time setting to time. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)setCurrentTime:(QTTime)time{}

/*stepForward

- (void)stepForward
Discussion

Sets the movie forward a single frame.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)stepForward{}


/*stepBackward

- (void)stepBackward
Discussion

Sets the movie backward a single frame.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)stepBackward{}


/*stop

- (void)stop
Discussion

Stops the movie playing.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)stop{}


/*gotoBeginning

- (void)gotoBeginning
Discussion

Repositions the play position to the beginning of the movie. If the movie is playing, the movie continues playing from the new position. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)gotoBeginning{}

/*tracksOfMediaType:

-(NSArray *)tracksOfMediaType:(NSString *)type
Discussion

Returns an array of tracks with the specified media type.
Availability
Available in Mac OS X v10.3 and later.*/
-(NSArray *)tracksOfMediaType:(NSString *)type{}


/*movieWithFile:error:

+ (id)movieWithFile:(NSString *)fileName error:(NSError **)errorPtr
Discussion

Creates a QTMovie object initialized with the data in the file specified by the name fileName. The fileName is assumed to be a full path name for a file. 

If a QTMovie object cannot be created, an NSError object is returned in the location pointed to by errorPtr. Pass NIL if you do not want an NSError object returned.
Availability
Available in Mac OS X v10.3 and later.*/
+ (id)movieWithFile:(NSString *)fileName error:(NSError **)errorPtr{}


/*addImage:forDuration:withAttributes:

- (void)addImage:(NSImage *)image forDuration:(QTTime)duration withAttributes:(NSDictionary *)attributes
Discussion

Adds an image for the specified duration to the receiver, using attributes specified in the attributes dictionary. Keys in the dictionary can be QTAddImageCodecType to select a codec type and QTAddImageCodecQuality to select a quality. Qualities are expected to be specified as NSNumbers, using the codec values like codecNormalQuality. (See ImageCompression.h for the complete list.)
Availability
Available in Mac OS X v10.3 and later.*/
- (void)addImage:(NSImage *)image forDuration:(QTTime)duration withAttributes:(NSDictionary *)attributes{}



/*writeToFile:withAttributes:

-(BOOL)writeToFile:(NSString *)fileName withAttributes:(NSDictionary *)attributes
Discussion

Creates a new movie file of the specified name and having the specified attributes. If the dictionary attributes contains an object whose key is QTMovieFlatten, then the movie is flattened into the specified file. If the dictionary attributes contains an object whose key is QTMovieExport, then the movie is exported into the specified file using a movie exporter whose type is specified by the value of the key QTMovieExportType. The value associated with the QTMovieExportSettings key should be an object of type NSData that contains an atom container of movie export settings. 
Availability
Available in Mac OS X v10.3 and later.
See Also
– movieFormatRepresentation*/
-(BOOL)writeToFile:(NSString *)fileName withAttributes:(NSDictionary *)attributes{}
/*setDelegate:

- (void)setDelegate:(id)delegate
Discussion

Sets the movie’s delegate to delegate. 
Availability
Available in Mac OS X v10.3 and later.*/
- (void)setDelegate:(id)delegate{}



/*updateMovieFile

- (BOOL)updateMovieFile
Discussion

Updates the movie file of a QTMovie. Returns YES if the update succeeds and NO otherwise.
Availability
Available in Mac OS X v10.3 and later.
volume

- (float)volume
Discussion

Returns the movie’s volume as a scalar value of type float. The valid range is 0.0 to 1.0.
Availability
Available in Mac OS X v10.3 and later.*/
- (BOOL)updateMovieFile{}




@end
