#ifndef ATSTYPES_H
#define ATSTYPES_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Deleted Glyph Code

Specifies that a glyph is deleted.

enum {
   kATSDeletedGlyphcode = 0xFFFF
};
Constants
kATSDeletedGlyphcode

Indicates that a glyph is deleted. That is, the glyph is set to no longer appear in a text layout.

Available in Mac OS X v10.2 and later.
Discussion

This constant is used by ATSUI. When a glyph is deleted, ATSUI sets the corresponding ATSGlyphRef to kATSDeletedGlyphcode. For more information, see Inside Mac OS X: ATSUI Reference.*/
enum {
   kATSDeletedGlyphcode = 0xFFFF
};


/*ATSGlyphRef

Represents a glyph reference.

typedef UInt16 ATSGlyphRef;
Discussion

This data type is used in the ATSUI data structure ATSLayoutRecord. For information, see Inside Mac OS X: ATSUI Reference.
Availability
Available in Mac OS X v10.0 and later.*/

typedef UInt16 ATSGlyphRef;

/*FMFont

An opaque data type that specifies a font registered with the font database. 

typedef UInt32 FMFont;
Discussion

You should not modify this value. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FMFont;

/*FMFontFamily

A reference to a collection of fonts with the same design characteristics.

typedef SInt16 FMFontFamily;
Discussion

The font family reference replaces the QuickDraw font ID and can be used with all QuickDraw functions including GetFontName and TextFont. Unlike the QuickDraw font identifier, the font family reference cannot be passed to the Resource Manager to access information from a 'FOND' resource. A font family reference does not imply a script system, nor is the character encoding of a font family determined by an arithmetic mapping of the font family reference. 

The fonts associated with a font family consist of individual outline fonts that may be used with the font access functions of the Font Manager and ATSUI. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FMFontFamily;

/*FMFontStyle

Represents a font style.

typedef SInt16 FMFontStyle;
Discussion

The low 8 bits of a Font Manager font style correspond to a QuickDraw style. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FMFontStyle;


#ifdef __cplusplus
}
#endif

#endif