

#ifndef  ADDRESSBOOKC_H
#define ADDRESSBOOKC_H

#if defined(__cplusplus)
extern "C" {
#endif

#include <CoreFoundation/CoreFoundation.h>
#include <AddressBook/ABTypedefs.h>
#include <AddressBook/ABGlobalsC.h>

/*ABMutableMultiValueRef

A reference to an ABMutableMultiValue object.

typedef struct __ABMultiValue *ABMutableMultiValueRef;
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct __ABMultiValue *ABMutableMultiValueRef;

/*ABRecordRef

A reference to an ABRecord object or any of its derived opaque types.

typedef void *ABRecordRef;
Availability
Available in Mac OS X v10.2 and later.*/
typedef void *ABRecordRef;

//function

/*ABRecordSetValue

Sets the value of a given property for a record.

bool ABRecordSetValue(
ABRecordRef record,
CFStringRef property,
CFTypeRef value
);
Parameters
record

The record you wish to modify. 
property

The property whose value you wish to set. May be a pre-defined or program-defined property. See Common Properties for a list of properties all records have, and specific ABRecord derived opaque types for any additional properties. If NULL, this function raises an exception.
value

The new value for property in record. If NULL or not the correct type, this function raises an exception.
Return Value

If property is a multi-value list property, this method checks to see if the values in the multi-value list are the same type. If the multi-value list contains mixed types, this method returns false. Returns true if successful, false otherwise. 
Availability
Available in Mac OS X v10.2 and later.*/

bool ABRecordSetValue(
ABRecordRef record,
CFStringRef property,
CFTypeRef value
);


#if defined(__cplusplus)
}
#endif

#endif
