#ifndef CFFTPSTREAM_H
#define CFFTPSTREAM_H

#ifndef CFNETWORKDEFS_H
#include <CFNetwork/CFNetworkDefs.h>
#endif

#ifndef  CFSTREAM_H
#include <CoreFoundation/CFStream.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CFStream FTP Resource Constants

FTP resource constants.

const CFStringRef kCFFTPResourceMode;
const CFStringRef kCFFTPResourceName;
const CFStringRef kCFFTPResourceOwner;
const CFStringRef kCFFTPResourceGroup;
const CFStringRef kCFFTPResourceLink;
const CFStringRef kCFFTPResourceSize;
const CFStringRef kCFFTPResourceType;
const CFStringRef kCFFTPResourceModDate;
Constants
kCFFTPResourceMode

CFDictionary key for getting the CFNumber containing the access permissions, defined in sys/types.h, of the FTP resource.

Available in Mac OS X version 10.3 and later.
kCFFTPResourceName

CFDictionary key for getting the CFString containing the name of the FTP resource.

Available in Mac OS X version 10.3 and later.
kCFFTPResourceOwner

CFDictionary key for getting the CFString containing the name of the owner of the FTP resource.

Available in Mac OS X version 10.3 and later.
kCFFTPResourceGroup

CFDictionary key for getting the CFString containing the name of a group that shares the FTP resource.

Available in Mac OS X version 10.3 and later.
kCFFTPResourceLink

CFDictionary key for getting the CFString containing the symbolic link information. If the item is a symbolic link, the CFString contains the path to the item that the link references.

Available in Mac OS X version 10.3 and later.
kCFFTPResourceSize

CFDictionary key for getting the CFNumber containing the size in bytes of the FTP resource.

Available in Mac OS X version 10.3 and later.
kCFFTPResourceType

CFDictionary key for getting the CFNumber containing the type of the FTP resource as defined in sys/dirent.h.

Available in Mac OS X version 10.3 and later.
kCFFTPResourceModDate

CFDictionary key for getting the CFDate containing the last date and time the FTP resource was modified.

Available in Mac OS X version 10.3 and later.
Discussion

The values of FTP resource keys are extracted from a line of the directory list by the CFFTPCreateParsedResourceListing function.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
const CFStringRef kCFFTPResourceMode;
const CFStringRef kCFFTPResourceName;
const CFStringRef kCFFTPResourceOwner;
const CFStringRef kCFFTPResourceGroup;
const CFStringRef kCFFTPResourceLink;
const CFStringRef kCFFTPResourceSize;
const CFStringRef kCFFTPResourceType;
const CFStringRef kCFFTPResourceModDate;

/*CFStream FTP Property Constants

Constants for setting and copying CFStream FTP properties.

const CFStringRef kCFStreamPropertyFTPUserName;
const CFStringRef kCFStreamPropertyFTPPassword;
const CFStringRef kCFStreamPropertyFTPUsePassiveMode;
const CFStringRef kCFStreamPropertyFTPResourceSize;
const CFStringRef kCFStreamPropertyFTPFetchResourceInfo;
const CFStringRef kCFStreamPropertyFTPFileTransferOffset;
const CFStringRef kCFStreamPropertyFTPAttemptPersistentConnection;
const CFStringRef kCFStreamPropertyFTPProxy;
const CFStringRef kCFStreamPropertyFTPProxyHost;
Constants
kCFStreamPropertyFTPUserName

FTP User Name stream property key for set and copy operations. A value of type CFString for storing the login user name. Don’t set this property when anonymous FTP is desired.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPPassword

FTP Password stream property key for set and copy operations. A value of type CFString for storing the login password. Don’t set this property when anonymous FTP is desired.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPUsePassiveMode

FTP Passive Mode stream property key for set and copy operations. Set this property to kCFBooleanTrue to enable passive mode; set this property to kCFBooleanFalse to disable passive mode.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPResourceSize

FTP Resource Size read stream property key copy operations. This property stores a CFNumber of type kCFNumberLongLongType representing the size of a resource in bytes.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPFetchResourceInfo

FTP Fetch Resource Information stream property key for set and copy operations. Set this property to kCFBooleanTrue to require that resource information, such as size, must be provided before download starts; set this property to kCFBooleanFalse to allow downloads to start without resource information. For this version, size is the only resource information.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPFileTransferOffset

FTP File Transfer Offset stream property key for set and copy operations. The value of this property is a CFNumber of type kCFNumberLongLongType representing the file offset at which to start the transfer.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPAttemptPersistentConnection

FTP Attempt Persistent Connection stream property key for set and copy operations. Set this property to kCFBooleanTrue to enable the reuse of existing server connections; set this property to kCFBooleanFalse to not reuse existing server connections. By default, this property is set to kCFBooleanTrue.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPProxy

FTP Proxy stream property key for set and copy operations. The property is a value of type CFDictionary that holds proxy dictionary key-value pairs. The dictionary returned by SystemConfiguration can also be set as the value of this property.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPProxyHost

FTP Proxy Host stream property key or an FTP Proxy dictionary key for set and copy operations. The value of this property is a CFString containing the host name of a proxy server. This property can be set and copied individually or via a CFDictionary. This property is the same as the kSCPropNetProxiesFTPProxy property defined in SCSchemaDefinitions.h.

Available in Mac OS X v10.3 and later.
kCFStreamPropertyFTPProxyPort

FTP Proxy Port stream property key or an FTP Proxy dictionary key for set and copy operations. The value of this property is a CFNumber of type kCFNumberIntType containing the port number of a proxy server. This property can be set and copied individually or via a CFDictionary. This property is the same as the kSCPropNetProxiesFTPPort property defined in SCSchemaDefinitions.h.

Available in Mac OS X v10.3 and later.
Discussion

The CFStream property constants are used to specify the property to set when calling CFReadStreamSetProperty or CFWriteStreamSetProperty and to copy when calling CFReadStreamCopyProperty or CFWriteStreamCopyProperty. They can also be passed to a CFDictionary creator or to an item accessor or mutator.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
const CFStringRef kCFStreamPropertyFTPUserName;
const CFStringRef kCFStreamPropertyFTPPassword;
const CFStringRef kCFStreamPropertyFTPUsePassiveMode;
const CFStringRef kCFStreamPropertyFTPResourceSize;
const CFStringRef kCFStreamPropertyFTPFetchResourceInfo;
const CFStringRef kCFStreamPropertyFTPFileTransferOffset;
const CFStringRef kCFStreamPropertyFTPAttemptPersistentConnection;
const CFStringRef kCFStreamPropertyFTPProxy;
const CFStringRef kCFStreamPropertyFTPProxyHost;


/*CFReadStreamCreateWithFTPURL

Creates an FTP read stream.

CFReadStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
ftpURL

A pointer to a CFURL structure for the URL to be downloaded that can be created by calling any of the CFURLCreate functions, such as CFURLCreateWithString.
Return Value

A new read stream, or NULL if the call failed. Ownership follows the Create Rule.
Discussion

This function creates an FTP read stream for downloading data from an FTP URL. If the ftpURL parameter is created with the user name and password as part of the URL (such as ftp://username:password@ftp.example.com) then the user name and password will automatically be set in the CFReadStream. Otherwise, call CFReadStreamSetProperty to set the steam’s properties, such as kCFStreamPropertyFTPUserName and kCFStreamPropertyFTPPassword to associate a user name and password with the stream that are used to log in when the stream is opened. See "Constants" for a description of all FTP stream properties.

To initiate a connection with the FTP server, call CFReadStreamOpen. To read the FTP stream, call CFReadStreamRead. If the URL refers to a directory, the stream provides the listing results sent by the server. If the URL refers to a file, the stream provides the data in that file.

To close a connection with the FTP server, call CFReadStreamClose.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/

CFReadStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);


/*CFFTPCreateParsedResourceListing

Parses an FTP listing to a dictionary.

CFIndex CFFTPCreateParsedResourceListing (
    CFAllocatorRef alloc,
    const UInt8 *buffer,
    CFIndex bufferLength,
    CFDictionaryRef *parsed
);
Parameters
alloc

The allocator to use to allocate memory for the dictionary. Pass NULL or kCFAllocatorDefault to use the current default allocator.
buffer

A pointer to a buffer holding zero or more lines of resource listing.
bufferLength

The length in bytes of the buffer pointed to by buffer.
parsed

Upon return, contains a dictionary containing the parsed resource information. If parsing fails, a NULL pointer is returned.
Return Value

The number of bytes parsed, 0 if no bytes were available for parsing, or -1 if parsing failed.
Discussion

This function examines the contents of buffer as an FTP directory listing and parses into a CFDictionary the information for a single file or folder. The CFDictionary is returned in the parsed parameter, and the number of bytes used from buffer is returned.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
CFIndex CFFTPCreateParsedResourceListing (
    CFAllocatorRef alloc,
    const UInt8 *buffer,
    CFIndex bufferLength,
    CFDictionaryRef *parsed
);

/*CFWriteStreamCreateWithFTPURL

Creates an FTP write stream.

CFWriteStreamRef CFReadStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
ftpURL

A pointer to a CFURL structure for the URL to be uploaded created by calling any of the CFURLCreate functions, such as CFURLCreateWithString.
Return Value

A new write stream, or NULL if the call failed. Ownership follows the Create Rule.
Discussion

This function creates an FTP write stream for uploading data to an FTP URL. If the ftpURL parameter is created with the user name and password as part of the URL (such as ftp://username:password@ftp.example.com) then the user name and password will automatically be set in the CFWriteStream. Call CFWriteStreamSetProperty to set the steam’s properties, such as kCFStreamPropertyFTPUserName and kCFStreamPropertyFTPPassword to associate a user name and password with the stream that are used to log in when the stream is opened. See "Constants" for a description of all FTP stream properties.

After creating the write stream, you can call CFWriteStreamGetStatus at any time to check the status of the stream.

To initiate a connection with the FTP server, call CFWriteStreamOpen. If the URL specifies a directory, the open is immediately followed by the event kCFStreamEventEndEncountered (and the stream passes to the state kCFStreamStatusAtEnd). Once the stream reaches this state, the directory has been created. Intermediary directories are not created.

To write to the FTP stream, call CFWriteStreamWrite.

To close a connection with the FTP server, call CFWriteStreamClose.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CFNetwork/CFFTPStream.h*/
CFWriteStreamRef CFWriteStreamCreateWithFTPURL (
    CFAllocatorRef alloc,
    CFURLRef ftpURL
);

#ifdef __cplusplus
}
#endif

#endif