#ifndef SOUND_H
#define SOUND_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef DIALOGS_H
#include <HIToolbox/Dialogs.h>
#endif


#include <HYS/CarbonSound/Sound.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CONST
    siAsync                         = 'asyn';       {asynchronous capability}
    siChannelAvailable              = 'chav';       {number of channels available}
    siCompressionAvailable          = 'cmav';       {compression types available}
    siCompressionFactor             = 'cmfa';       {current compression factor}
    siCompressionType               = 'comp';       {compression type}
    siContinuous                    = 'cont';       {continuous recording}
    siDeviceBufferInfo              = 'dbin';       {size of interrupt buffer}
    siDeviceConnected               = 'dcon';       {input device connection status}
    siDeviceIcon                    = 'icon';       {input device icon}
    siDeviceName                    = 'name';       {input device name}
    siLevelMeterOnOff               = 'lmet';       {level meter state}
    siNumberChannels                = 'chan';       {current number of channels}
    siRecordingQuality              = 'qual';       {recording quality}
    siSampleRate                    = 'srat';       {current sample rate}
    siSampleRateAvailable           = 'srav';       {sample rates available}
    siSampleSizeAvailable           = 'ssav';       {sample sizes available}
    siSampleSize                    = 'ssiz';       {current sample size}
    siTwosComplementOnOff           = 'twos';       {two's complement state}

The Sound Input Manager defines several selectors that specifically help it interact with sound input device drivers. Your application should not use any of these selectors, but if you are implementing a sound input device driver, you need to support these selectors. They are:*/
enum{
 //siAsync                         = 'asyn',       /*asynchronous capability*/
//siChannelAvailable              = 'chav',       /*number of channels available*/
   // siCompressionAvailable          = 'cmav',       /*compression types available*/
    //siCompressionFactor             = 'cmfa',       /*current compression factor*/
    //siCompressionType               = 'comp',       /*compression type*/
    //siContinuous                    = 'cont',       /*continuous recording*/
    //siDeviceBufferInfo              = 'dbin',       /*size of interrupt buffer*/
    //siDeviceConnected               = 'dcon',       /*input device connection status*/
    //siDeviceIcon                    = 'icon',       /*input device icon*/
    //siDeviceName                    = 'name',       /*input device name*/
    siLevelMeterOnOff               = 'lmet'      /*level meter state*/
    //siNumberChannels                = 'chan',       /*current number of channels*/
    //siRecordingQuality              = 'qual',       /*recording quality*/
    //siSampleRate                    = 'srat',       /*current sample rate*/
    //siSampleRateAvailable           = 'srav',       /*sample rates available*/
    //siSampleSizeAvailable           = 'ssav',       /*sample sizes available*/
    //siSampleSize                    = 'ssiz',       /*current sample size*/
    //siTwosComplementOnOff           = 'twos'      /*two's complement state*/
};

/*DESCRIPTION

The SPBOpenDevice function attempts to open a sound input device having the name indicated by the deviceName parameter. If SPBOpenDevice succeeds, it returns a device reference number in the inRefNum parameter. The permission parameter indicates whether subsequent operations with that device are to be read/write or read-only. If the device is not already in use, read/write permission is granted; otherwise, only read-only operations are allowed. To make any recording requests or to call the SPBSetDeviceInfo function, read/write permission must be available. Use these constants to request the appropriate permission:
CONST
    siReadPermission            = 0;        {open device for reading}
    siWritePermission           = 1;        {open device for reading/writing}

You can request that the current default sound input device be opened by passing either a zero-length string or a NIL string as the deviceName parameter. If only one sound input device is installed, that device is used. Generally you should open the default device unless you specifically want to use some other device. You can get a list of the available devices by calling the SPBGetIndexedDevice function.*/
enum{
   // siReadPermission            = 0,        //open device for reading
    siWritePermission           = 1        //open device for reading/writing
};

/*Extended Sound Header Record
struct ExtSoundHeader {
   Ptr                  samplePtr;     /if NIL, samples in sampleArea/
   unsigned long        numChannels;   /number of channels in sample/
   Fixed                sampleRate;    /rate of original sample/
   unsigned long        loopStart;     /loop point beginning/
   unsigned long        loopEnd;       /loop point ending/
   unsigned char        encode;        /sample's encoding option/
   unsigned char        baseFrequency; /base frequency of sample/
   unsigned long        numFrames;     /total number of frames/
   extended80           AIFFSampleRate;/rate of original sample/
   Ptr                  markerChunk;   /reserved/
   Ptr                  instrumentChunks;
                                       /pointer to instrument info/
   Ptr                  AESRecording;  /pointer to audio info/
   unsigned short       sampleSize;    /number of bits per sample/
   unsigned short       futureUse1;    /reserved/
   unsigned long        futureUse2;    /reserved/
   unsigned long        futureUse3;    /reserved/
   unsigned long        futureUse4;    /reserved/
   unsigned char        sampleArea[1];
};
typedef struct ExtSoundHeader ExtSoundHeader;
typedef ExtSoundHeader *ExtSoundHeaderPtr;*/
struct ExtSoundHeader {
   Ptr                  samplePtr;     /*if NIL, samples in sampleArea*/
   unsigned long        numChannels;   /*number of channels in sample*/
   Fixed                sampleRate;    /*rate of original sample*/
   unsigned long        loopStart;     /*loop point beginning*/
   unsigned long        loopEnd;       /*loop point ending*/
   unsigned char        encode;        /*sample's encoding option*/
   unsigned char        baseFrequency; /*base frequency of sample*/
   unsigned long        numFrames;     /*total number of frames*/
   extended80           AIFFSampleRate;/*rate of original sample*/
   Ptr                  markerChunk;   /*reserved*/
   Ptr                  instrumentChunks;
                                       /*pointer to instrument info*/
   Ptr                  AESRecording;  /*pointer to audio info*/
   unsigned short       sampleSize;    /*number of bits per sample*/
   unsigned short       futureUse1;    /*reserved*/
   unsigned long        futureUse2;    /*reserved*/
   unsigned long        futureUse3;    /*reserved*/
   unsigned long        futureUse4;    /*reserved*/
   unsigned char        sampleArea[1];
};
typedef struct ExtSoundHeader ExtSoundHeader;
typedef ExtSoundHeader *ExtSoundHeaderPtr;


/*Table 3-3  Supported QuickTime audio formats. Note that not all of these are uncompressed. 
Format	
4-Character code	
Description

kSoundNotCompressed	
'NONE'	
Sound is not compressed

k8BitOffsetBinaryFormat	
'raw '	
Samples are stored uncompressed, in offset-binary format (values range from 0 to 255; 128 is silence). These are stored as 8-bit offset binaries. 

k16BitBigEndianFormat	
'twos'	
Samples are stored uncompressed, in two’s-complement format (sample values range from -128 to 127 for 8-bit audio, and -32768 to 32767 for 1- bit audio; 0 is always silence). These samples are stored in 16-bit big-endian format. 

k16BitLittleEndianFormat	
'sowt'	
16-bit little-endian, twos-complement

kMACE3Compression	
'MAC3 '	
Samples have been compressed using MACE 3:1. (Obsolete.)

kMACE6Compression	
'MAC6 '	
Samples have been compressed using MACE 6:1. (Obsolete.)

kIMACompression	
'ima4 '	
Samples have been compressed using IMA 4:1.

kFloat32Format	
'fl32'	
32-bit floating point

kFloat64Format	
'fl64'	
64-bit floating point

k24BitFormat	
'in24'	
24-bit integer

k32BitFormat	
'in32'	
32-bit integer

kULawCompression	
'ulaw'	
uLaw 2:1

kALawCompression	
'alaw'	
uLaw 2:1

kMicrosoftADPCMFormat	
0x6D730002	
Microsoft ADPCM-ACM code 2

kDVIIntelIMAFormat	
0x6D730011	
DVI/Intel IMAADPCM-ACM code 17

kDVAudioFormat	
'dvca'	
DV Audio

kQDesignCompression	
'QDMC'	
QDesign music

unnamed	
'QDM2'	
QDesign music version 2 (no constant). 

kQUALCOMMCompression	
'Qclp'	
QUALCOMM PureVoice

kMPEGLayer3Format	
0x6D730055	
MPEG layer 3, CBR only (pre- QT4.1)

kFullMPEGLay3Format	
'.mp3'	
MPEG layer 3, CBR & VBR (QT4.1 and later)*/
enum {
kSoundNotCompressed	='NONE'	,
k8BitOffsetBinaryFormat	='raw '	,
k16BitBigEndianFormat	='twos'	,
k16BitLittleEndianFormat	='sowt'	,
//kMACE3Compression	='MAC3 '	,
//kMACE6Compression	='MAC6 '	,
kIMACompression	='ima4 '	,
kFloat32Format	='fl32'	,
kFloat64Format	='fl64'	,
k24BitFormat	='in24'	,
k32BitFormat	='in32'	,
kULawCompression	='ulaw'	,
kALawCompression	='alaw'	,
kMicrosoftADPCMFormat	=0x6D730002	,
kDVIIntelIMAFormat	=0x6D730011	,
kDVAudioFormat	='dvca'	,
kQDesignCompression	='QDMC'	,
kQDesign2Compression=	'QDM2'	,
kQUALCOMMCompression	='Qclp'	,
kMPEGLayer3Format	=0x6D730055	,
kFullMPEGLay3Format	='.mp3'	
};



/*C Summary
Constants
/Gestalt sound attributes selector and response bits/
#define gestaltSoundAttr    'snd '  /sound attributes selector/
enum {
   gestaltStereoCapability    = 0,  /built-in hw can play stereo sounds/
   gestaltStereoMixing        = 1,  /built-in hw mixes stereo to mono/
   gestaltSoundIOMgrPresent   = 3,  /sound input routines available/
   gestaltBuiltInSoundInput   = 4,  /built-in input hw available/
   gestaltHasSoundInputDevice = 5,  /sound input device available/
   gestaltPlayAndRecord       = 6,  /built-in hw can play while recording/
   gestalt16BitSoundIO        = 7,  /built-in hw can handle 16-bit data/
   gestaltStereoInput         = 8,  /built-in hw can record stereo sounds/
   gestaltLineLevelInput      = 9,  /built-in input hw needs line level/
   gestaltSndPlayDoubleBuffer = 10, /play from disk routines available/
   gestaltMultiChannels       = 11, /multiple channels of sound supported/
   gestalt16BitAudioSupport   = 12  /16-bit audio data supported/
};
/channel initialization parameters/
enum {
   initChanLeft            = 0x0002,   /left stereo channel/
   initChanRight           = 0x0003,   /right stereo channel/
   initMono                = 0x0080,   /monophonic channel/
   initStereo              = 0x00C0,   /stereo channel/
   initMACE3               = 0x0300,   /3:1 compression/
   initMACE6               = 0x0400,   /6:1 compression/
   initNoInterp            = 0x0004,   /no linear interpolation/
   initNoDrop              = 0x0008    /no drop-sample conversion/
};
/wave channel initialization parameters/
enum {
   waveInitChannel0        = 0x04,     /wave-table channel 0/
   waveInitChannel1        = 0x05,     /wave-table channel 1/
   waveInitChannel2        = 0x06,     /wave-table channel 2/
   waveInitChannel3        = 0x07,     /wave-table channel 3/
   waveInitChannelMask     = 0x07      /mask for wave-table parameters/
};
/masks for channel attributes/
enum {
   initPanMask             = 0x0003,   /mask for left/right pan values/
   initSRateMask           = 0x0030,   /mask for sample rate values/
   initStereoMask          = 0x00C0,   /mask for mono/stereo values/
   initCompMask            = 0xFF00    /mask for compression IDs/
};
/sound data types/
enum {
   squareWaveSynth         = 1,        /square-wave data/
   waveTableSynth          = 3,        /wave-table data/
   sampledSynth            = 5         /sampled-sound data/
};
/sound command numbers/
enum {
   nullCmd                 = 0,        /do nothing/
   quietCmd                = 3,        /stop a sound that is playing/
   flushCmd                = 4,        /flush a sound channel/
   reInitCmd               = 5,        /reinitialize a sound channel/
   waitCmd                 = 10,       /suspend processing in a channel/
   pauseCmd                = 11,       /pause processing in a channel/
   resumeCmd               = 12,       /resume processing in a channel/
   callBackCmd             = 13,       /execute a callback procedure/
   syncCmd                 = 14,       /synchronize channels/
   availableCmd            = 24,       /see if initialization options /
                                       / are supported/
   versionCmd              = 25,       /determine version/
   totalLoadCmd            = 26,       /report total CPU load/
   loadCmd                 = 27,       /report CPU load for a new channel/
   freqDurationCmd         = 40,       /play a note for a duration/
   restCmd                 = 41,       /rest a channel for a duration/
   freqCmd                 = 42,       /change the pitch of a sound/
   ampCmd                  = 43,       /change the amplitude of a sound/
   timbreCmd               = 44,       /change the timbre of a sound/
   getAmpCmd               = 45,       /get the amplitude of a sound/
   volumeCmd               = 46,       /set volume/
   getVolumeCmd            = 47,       /get volume/
   waveTableCmd            = 60,       /install a wave table as a voice/
   soundCmd                = 80,       /install a sampled sound as a voice/
   bufferCmd               = 81,       /play a sampled sound/
   rateCmd                 = 82,       /set the pitch of a sampled sound/
   getRateCmd              = 85        /get the pitch of a sampled sound/
};
/sampled sound header encoding options/
enum {
   stdSH                   = 0x00,     /standard sound header/
   extSH                   = 0xFF,     /extended sound header/
   cmpSH                   = 0xFE      /compressed sound header/
};
/size of data structures/
enum {
   stdQLength              = 128       /default size of sound channel/
};
/sound resource formats/
enum {
   firstSoundFormat        = 0x0001,   /format 1 'snd ' resource/
   secondSoundFormat       = 0x0002    /format 2 'snd ' resource/
};
/sound command mask/
enum {
   dataOffsetFlag          = 0x8000    /sound command data offset bit/
};
/system beep states/
enum {
   sysBeepDisable          = 0x0000,   /system alert sound disabled/
   sysBeepEnable           = 0x0001    /system alert sound enabled/
};
/values for the unitType field in AudioSelection/
enum {
   unitTypeSeconds         = 0x0000,   /seconds/
   unitTypeNoSelection     = 0xFFFF    /no selection/
};
/double buffer status flags/
enum {
   dbBufferReady           = 0x00000001,  /double buffer is filled/
   dbLastBuffer            = 0x00000004   /last double buffer to play/
};
/values for the compressionID field of CmpSoundHeader/
enum {
   variableCompression     = -2,       /variable-ratio compression/
   fixedCompression        = -1,       /fixed-ratio compression/
   notCompressed           = 0,        /noncompressed samples/
   threeToOne              = 3,        /3:1 compressed samples/
   sixToOne                = 4         /6:1 compressed samples/
};
/values for the packetSize field of CmpSoundHeader/
enum {
   sixToOnePacketSize      = 8,        /packet size in bits for 6:1/
   threeToOnePacketSize    = 16        /packet size in bits for 3:1/
};
/compression names and types/
#define NoneName              "\pnot compressed"
#define ACE2to1Name           "\pACE 2-to-1"
#define ACE8to3Name           "\pACE 8-to-3"
#define MACE3to1Name          "\pMACE 3-to-1"
#define MACE6to1Name          "\pMACE 6-to-1"
#define NoneType              'NONE'
#define ACE2Type              'ACE2'
#define ACE8Type              'ACE8'
#define MACE3Type             'MAC3'
#define MACE6Type             'MAC6'
/IDs for AIFF and AIFF-C files/
#define AIFFID                'AIFF'   /AIFF file/
#define AIFCID                'AIFC'   /AIFF-C file/
/IDs for AIFF and AIFF-C file chunks/
#define FORMID                'FORM'   /ID for Form Chunk/
#define FormatVersionID       'FVER'   /ID for Format Version Chunk/
#define CommonID              'COMM'   /ID for Common Chunk/
#define SoundDataID           'SSND'   /ID for Sound Data Chunk/
#define MarkerID              'MARK'   /ID for Marker Chunk/
#define InstrumentID          'INST'   /ID for Instrument Chunk/
#define MIDIDataID            'MIDI'   /ID for MIDI Data Chunk/
#define AudioRecordingID      'AESD'   /ID for Recording Chunk/
#define ApplicationSpecificID 'APPL'   /ID for Application Chunk/
#define CommentID             'COMT'   /ID for Comment Chunk/
#define NameID                'NAME'   /ID for Name Chunk/
#define AuthorID              'AUTH'   /ID for Author Chunk/
#define CopyrightID           '(c) '   /ID for Copyright Chunk/
#define AnnotationID          'ANNO'   /ID for Annotation Chunk/
/version of AIFC format specification/
#define AIFCVersion1          0xA2805140
                                       /date of version creation/
/MIDI note value for middle C/
enum {
   kMiddleC                = 60
};
/ratio between frequencies of MIDI note values/
#define twelfthRootTwo        1.05946309434
/standard sampling rates/
#define rate44khz          0xAC440000     /44100.00000 in fixed-point/
#define rate22khz          0x56EE8BA3     /22254.54545 in fixed-point/
#define rate22050hz        0x56220000     /22050.00000 in fixed-point/
#define rate11khz          0x2B7745D1     /11127.27273 in fixed-point/
#define rate11025hz        0x2B110000     /11025.00000 in fixed-point/
/constant for synth parameter of SndNewChannel/
enum {
   kUseOptionalOutputDevice      = -1
};
/volumes/
enum {
   kFullVolume                   = 0x0100,
   kNoVolume                     = 0
};
/development stages/
enum {
   developStage         = 0x20,        /prealpha release/
   alphaStage           = 0x40,        /alpha release/
   betaStage            = 0x60,        /beta release/
   finalStage           = 0x80         /final release/
};
/sizes of data buffers/
enum {
   stateBlockSize       = 64,          /size of state block buffer/
   leftOverBlockSize    = 32           /size of leftover block buffer/
};*/

/*Gestalt sound attributes selector and response bits*/
#define gestaltSoundAttr    'snd '  /*sound attributes selector*/
enum {
   gestaltStereoCapability    = 0,  /*built-in hw can play stereo sounds*/
   gestaltStereoMixing        = 1,  /*built-in hw mixes stereo to mono*/
   gestaltSoundIOMgrPresent   = 3,  /*sound input routines available*/
   gestaltBuiltInSoundInput   = 4,  /*built-in input hw available*/
   gestaltHasSoundInputDevice = 5,  /*sound input device available*/
   gestaltPlayAndRecord       = 6,  /*built-in hw can play while recording*/
   gestalt16BitSoundIO        = 7,  /*built-in hw can handle 16-bit data*/
   gestaltStereoInput         = 8,  /*built-in hw can record stereo sounds*/
   gestaltLineLevelInput      = 9,  /*built-in input hw needs line level*/
   gestaltSndPlayDoubleBuffer = 10, /*play from disk routines available*/
   gestaltMultiChannels       = 11, /*multiple channels of sound supported*/
   gestalt16BitAudioSupport   = 12  /*16-bit audio data supported*/
};
/*channel initialization parameters*/
enum {
   initChanLeft            = 0x0002,   /*left stereo channel*/
   initChanRight           = 0x0003,   /*right stereo channel*/
   initMono                = 0x0080,   /*monophonic channel*/
   initStereo              = 0x00C0,   /*stereo channel*/
   initMACE3               = 0x0300,   /*3:1 compression*/
   initMACE6               = 0x0400,   /*6:1 compression*/
   initNoInterp            = 0x0004,   /*no linear interpolation*/
   initNoDrop              = 0x0008    /*no drop-sample conversion*/
};
/*wave channel initialization parameters*/
enum {
   waveInitChannel0        = 0x04,     /*wave-table channel 0*/
   waveInitChannel1        = 0x05,     /*wave-table channel 1*/
   waveInitChannel2        = 0x06,     /*wave-table channel 2*/
   waveInitChannel3        = 0x07,     /*wave-table channel 3*/
   waveInitChannelMask     = 0x07      /*mask for wave-table parameters*/
};
/*masks for channel attributes*/
enum {
   initPanMask             = 0x0003,   /*mask for left/right pan values*/
   initSRateMask           = 0x0030,   /*mask for sample rate values*/
   initStereoMask          = 0x00C0,   /*mask for mono/stereo values*/
   initCompMask            = 0xFF00    /*mask for compression IDs*/
};
/*sound data types*/
enum {
   squareWaveSynth         = 1,        /*square-wave data*/
   waveTableSynth          = 3,        /*wave-table data*/
   sampledSynth            = 5         /*sampled-sound data*/
};
/*sound command numbers*/
enum {
   nullCmd                 = 0,        /*do nothing*/
   quietCmd                = 3,        /*stop a sound that is playing*/
   flushCmd                = 4,        /*flush a sound channel*/
   reInitCmd               = 5,        /*reinitialize a sound channel*/
   waitCmd                 = 10,       /*suspend processing in a channel*/
   pauseCmd                = 11,       /*pause processing in a channel*/
   resumeCmd               = 12,       /*resume processing in a channel*/
   callBackCmd             = 13,       /*execute a callback procedure*/
   syncCmd                 = 14,       /*synchronize channels*/
   availableCmd            = 24,       /*see if initialization options */
                                       /* are supported*/
   versionCmd              = 25,       /*determine version*/
   totalLoadCmd            = 26,       /*report total CPU load*/
   loadCmd                 = 27,       /*report CPU load for a new channel*/
   freqDurationCmd         = 40,       /*play a note for a duration*/
   restCmd                 = 41,       /*rest a channel for a duration*/
   freqCmd                 = 42,       /*change the pitch of a sound*/
   ampCmd                  = 43,       /*change the amplitude of a sound*/
   timbreCmd               = 44,       /*change the timbre of a sound*/
   getAmpCmd               = 45,       /*get the amplitude of a sound*/
   volumeCmd               = 46,       /*set volume*/
   getVolumeCmd            = 47,       /*get volume*/
   waveTableCmd            = 60,       /*install a wave table as a voice*/
   soundCmd                = 80,       /*install a sampled sound as a voice*/
   bufferCmd               = 81,       /*play a sampled sound*/
   rateCmd                 = 82,       /*set the pitch of a sampled sound*/
   getRateCmd              = 85        /*get the pitch of a sampled sound*/
};
/*sampled sound header encoding options*/
enum {
   stdSH                   = 0x00,     /*standard sound header*/
   extSH                   = 0xFF,     /*extended sound header*/
   cmpSH                   = 0xFE      /*compressed sound header*/
};
/*size of data structures*/
enum {
   stdQLength              = 128       /*default size of sound channel*/
};
/*sound resource formats*/
enum {
   firstSoundFormat        = 0x0001,   /*format 1 'snd ' resource*/
   secondSoundFormat       = 0x0002    /*format 2 'snd ' resource*/
};
/*sound command mask*/
enum {
   dataOffsetFlag          = 0x8000    /*sound command data offset bit*/
};
/*system beep states*/
enum {
   sysBeepDisable          = 0x0000,   /*system alert sound disabled*/
   sysBeepEnable           = 0x0001    /*system alert sound enabled*/
};
/*values for the unitType field in AudioSelection*/
enum {
   unitTypeSeconds         = 0x0000,   /*seconds*/
   unitTypeNoSelection     = 0xFFFF    /*no selection*/
};
/*double buffer status flags*/
enum {
   dbBufferReady           = 0x00000001,  /*double buffer is filled*/
   dbLastBuffer            = 0x00000004   /*last double buffer to play*/
};
/*values for the compressionID field of CmpSoundHeader*/
enum {
   variableCompression     = -2,       /*variable-ratio compression*/
   fixedCompression        = -1,       /*fixed-ratio compression*/
   notCompressed           = 0,        /*noncompressed samples*/
   threeToOne              = 3,        /*3:1 compressed samples*/
   sixToOne                = 4         /*6:1 compressed samples*/
};
/*values for the packetSize field of CmpSoundHeader*/
enum {
   sixToOnePacketSize      = 8,        /*packet size in bits for 6:1*/
   threeToOnePacketSize    = 16        /*packet size in bits for 3:1*/
};
/*compression names and types*/
#define NoneName              "\pnot compressed"
#define ACE2to1Name           "\pACE 2-to-1"
#define ACE8to3Name           "\pACE 8-to-3"
#define MACE3to1Name          "\pMACE 3-to-1"
#define MACE6to1Name          "\pMACE 6-to-1"
#define NoneType              'NONE'
#define ACE2Type              'ACE2'
#define ACE8Type              'ACE8'
#define MACE3Type             'MAC3'
#define MACE6Type             'MAC6'
/*IDs for AIFF and AIFF-C files*/
#define AIFFID                'AIFF'   /*AIFF file*/
#define AIFCID                'AIFC'   /*AIFF-C file*/
/*IDs for AIFF and AIFF-C file chunks*/
#define FORMID                'FORM'   /*ID for Form Chunk*/
#define FormatVersionID       'FVER'   /*ID for Format Version Chunk*/
#define CommonID              'COMM'   /*ID for Common Chunk*/
#define SoundDataID           'SSND'   /*ID for Sound Data Chunk*/
#define MarkerID              'MARK'   /*ID for Marker Chunk*/
#define InstrumentID          'INST'   /*ID for Instrument Chunk*/
#define MIDIDataID            'MIDI'   /*ID for MIDI Data Chunk*/
#define AudioRecordingID      'AESD'   /*ID for Recording Chunk*/
#define ApplicationSpecificID 'APPL'   /*ID for Application Chunk*/
#define CommentID             'COMT'   /*ID for Comment Chunk*/
#define NameID                'NAME'   /*ID for Name Chunk*/
#define AuthorID              'AUTH'   /*ID for Author Chunk*/
#define CopyrightID           '(c) '   /*ID for Copyright Chunk*/
#define AnnotationID          'ANNO'   /*ID for Annotation Chunk*/
/*version of AIFC format specification*/
#define AIFCVersion1          0xA2805140
                                       /*date of version creation*/
/*MIDI note value for middle C*/
enum {
   kMiddleC                = 60
};
/*ratio between frequencies of MIDI note values*/
#define twelfthRootTwo        1.05946309434
/*standard sampling rates*/
#define rate44khz          0xAC440000     /*44100.00000 in fixed-point*/
#define rate22khz          0x56EE8BA3     /*22254.54545 in fixed-point*/
#define rate22050hz        0x56220000     /*22050.00000 in fixed-point*/
#define rate11khz          0x2B7745D1     /*11127.27273 in fixed-point*/
#define rate11025hz        0x2B110000     /*11025.00000 in fixed-point*/
/*constant for synth parameter of SndNewChannel*/
enum {
   kUseOptionalOutputDevice      = -1
};
/*volumes*/
//enum {
 //  kFullVolume                   = 0x0100,
  // kNoVolume                     = 0
//};
/*development stages*/
enum {
   developStage         = 0x20,        /*prealpha release*/
   alphaStage           = 0x40,        /*alpha release*/
   betaStage            = 0x60,        /*beta release*/
   finalStage           = 0x80         /*final release*/
};
/*sizes of data buffers*/
enum {
   stateBlockSize       = 64,          /*size of state block buffer*/
   leftOverBlockSize    = 32           /*size of leftover block buffer*/
};





/*Constants
/component types/
#define kSoundComponentType      'sift'   /utility component/
#define kMixerType               'mixr'   /mixer component/
#define kSoundHardwareType       'sdev'   /sound output device component/
#define kSoundCompressor         'scom'   /compression component/
#define kSoundDecompressor       'sdec'   /decompression component/
#define kNoSoundComponentType    ''   /no type/

/subtypes for kSoundComponentType component type/
#define kRate8SubType            'ratb'   /8-bit rate converter/
#define kRate16SubType           'ratw'   /16-bit rate converter/
#define kConverterSubType        'conv'   /sample format converter/
#define kSndSourceSubType        'sour'   /generic source component/

/subtypes for kMixerType component type/
#define kMixer8SubType           'mixb'   /8-bit mixer/
#define kMixer16SubType          'mixw'   /16-bit mixer/

/subtypes for kSoundHardwareType component type/
#define kClassicSubType          'clas'   /Classic hardware/
#define kASCSubType              'asc '   /ASC device/
#define kDSPSubType              'dsp '   /DSP device/

/subtypes for kSoundCompressor and kSoundDecompressor component types/
#define kMace3SubType            'MAC3'   /MACE 3:1/
#define kMace6SubType            'MAC6 '  /MACE 6:1/
#define kCDXA4SubType            'CDX4'   /CD/XA 4:1/
#define kCDXA2SubType            'CDX2'   /CD/XA 2:1/
#define kSoundComponentCodeType  'sift'   /sound component code type/

/first selector that can be delegated up the chain/
#define kDelegatedSoundComponentSelectors       0x0100

/Component Manager selectors for routines/
enum {
   /the following calls cannot be delegated/
   kSoundComponentInitOutputDeviceSelect     = 1,
   kSoundComponentSetSourceSelect,
   kSoundComponentGetSourceSelect,
   kSoundComponentGetSourceDataSelect,
   kSoundComponentSetOutputSelect,
   /the following calls can be delegated/
   kSoundComponentAddSourceSelect = kDelegatedSoundComponentSelectors + 1,
   kSoundComponentRemoveSourceSelect,
   kSoundComponentGetInfoSelect,
   kSoundComponentSetInfoSelect,
   kSoundComponentStartSourceSelect,
   kSoundComponentStopSourceSelect,
   kSoundComponentPauseSourceSelect,
   kSoundComponentPlaySourceBufferSelect
};

/sound component information selectors/
#define siChannelAvailable       'chav'   /number of channels available/
#define siCompressionAvailable   'cmav'   /compression types available/
#define siCompressionFactor      'cmfa'   /current compression factor/
#define siCompressionType        'comp'   /current compression type/
#define siHardwareMute           'hmut'   /current hardware mute state/
#define siHardwareVolume         'hvol'   /current hardware volume/
#define siHardwareVolumeSteps    'hstp'   /number of hardware volume steps/
#define siHeadphoneMute          'pmut'   /current headphone mute state/
#define siHeadphoneVolume        'pvol'   /current headphone volume/
#define siHeadphoneVolumeSteps   'hdst'   /num. of headphone volume steps/
#define siNumberChannels         'chan'   /current number of channels/
#define siQuality                'qual'   /current quality/
#define siRateMultiplier         'rmul'   /current rate multiplier/
#define siSampleRate             'srat'   /current sample rate/
#define siSampleRateAvailable    'srav'   /sample rates available/
#define siSampleSize             'ssiz'   /current sample size/
#define siSampleSizeAvailable    'ssav'   /sample sizes available/
#define siSpeakerMute            'smut'   /current speaker mute/
#define siSpeakerVolume          'svol'   /current speaker volume/
#define siVolume                 'volu'   /current volume setting/

/audio data format types/
#define kOffsetBinary            'raw '
#define kTwosComplement          'twos'
#define kMACE3Compression        'MAC3'
#define kMACE6Compression        'MAC6'

/sound component features flags/
#define k8BitRawIn               (1 << 0)    /data flags/
#define k8BitTwosIn              (1 << 1)
#define k16BitIn                 (1 << 2)
#define kStereoIn                (1 << 3)
#define k8BitRawOut              (1 << 8)
#define k8BitTwosOut             (1 << 9)
#define k16BitOut                (1 << 10)
#define kStereoOut               (1 << 11)

#define kReverse                 (1 << 16)   /action flags/
#define kRateConvert             (1 << 17)
#define kCreateSoundSource       (1 << 18)

#define kHighQuality             (1 << 22)   /performance flags/
#define kRealTime                (1 << 23)

/action flags for SoundComponentPlaySourceBuffer/
#define kSourcePaused            (1 << 0)
#define kPassThrough             (1 << 16)
#define kNoSoundComponentChain   (1 << 17)

/flags for OpenMixerSoundComponent/
#define kNoMixing                (1 << 0)    /don't mix sources/
#define kNoSampleRateConversion  (1 << 1)    /don't convert sample rate/
#define kNoSampleSizeConversion  (1 << 2)    /don't convert sample size/
#define kNoSampleFormatConversion            \
                                 (1 << 3)    /don't convert sample format/
#define kNoChannelConversion     (1 << 4)    /don't convert stereo/mono/
#define kNoDecompression         (1 << 5)    /don't decompress/
#define kNoVolumeConversion      (1 << 6)    /don't apply volume/
#define kNoRealtimeProcessing    (1 << 7)    /don't run at interrupt time/

/quality flags/
#define kBestQuality             (1 << 0)    /use interp. in rate conv./

/volume specifications/
#define kSilenceByte             0x80
#define kSilenceLong             0x80808080
#define kFullVolume              0x0100*/
enum {
kSoundComponentType      ='sift'  , /*utility component*/
kMixerType               ='mixr'   ,/*mixer component*/
kSoundHardwareType =      'sdev' ,  /*sound output device component*/
kSoundCompressor     =    'scom'  , /*compression component*/
kSoundDecompressor   =    'sdec'  , /*decompression component*/
kNoSoundComponentType=    '****'   /*no type*/
};
enum {
/*subtypes for kSoundComponentType component type*/
kRate8SubType      =      'ratb',   /*8-bit rate converter*/
kRate16SubType      =     'ratw',   /*16-bit rate converter*/
kConverterSubType   =     'conv',   /*sample format converter*/
kSndSourceSubType  =      'sour'   /*generic source component*/
};
enum {
/*subtypes for kMixerType component type*/
kMixer8SubType          = 'mixb' ,  /*8-bit mixer*/
kMixer16SubType         = 'mixw'   /*16-bit mixer*/
};
enum {
/*subtypes for kSoundHardwareType component type*/
kClassicSubType        =  'clas',   /*Classic hardware*/
kASCSubType              ='asc '  , /*ASC device*/
kDSPSubType              ='dsp '   /*DSP device*/
};
enum {
/*subtypes for kSoundCompressor and kSoundDecompressor component types*/
kMace3SubType          =  'MAC3'  , /*MACE 3:1*/
kMace6SubType           = 'MAC6 ' ,/*MACE 6:1*/
kCDXA4SubType            ='CDX4'   ,/*CD/XA 4:1*/
kCDXA2SubType            ='CDX2'   /*CD/XA 2:1*/
};

enum {
kSoundComponentCodeType = 'sift'   /*sound component code type*/
};
enum {
/*first selector that can be delegated up the chain*/
kDelegatedSoundComponentSelectors    =   0x0100
};

/*Component Manager selectors for routines*/
enum {
   /*the following calls cannot be delegated*/
   kSoundComponentInitOutputDeviceSelect     = 1,
   kSoundComponentSetSourceSelect,
   kSoundComponentGetSourceSelect,
   kSoundComponentGetSourceDataSelect,
   kSoundComponentSetOutputSelect,
   /*the following calls can be delegated*/
   kSoundComponentAddSourceSelect = kDelegatedSoundComponentSelectors + 1,
   kSoundComponentRemoveSourceSelect,
   kSoundComponentGetInfoSelect,
   kSoundComponentSetInfoSelect,
   kSoundComponentStartSourceSelect,
   kSoundComponentStopSourceSelect,
   kSoundComponentPauseSourceSelect,
   kSoundComponentPlaySourceBufferSelect
};

enum {
/*audio data format types*/
 kOffsetBinary          =  'raw ',
 kTwosComplement   =       'twos',
 kMACE3Compression =       'MAC3',
 kMACE6Compression   =     'MAC6'
};
enum {
/*sound component features flags*/
 k8BitRawIn             =  (1 << 0)   , /*data flags*/
 k8BitTwosIn            =  (1 << 1),
 k16BitIn                 =(1 << 2),
 kStereoIn               = (1 << 3),
 k8BitRawOut             = (1 << 8),
 k8BitTwosOut            = (1 << 9),
 k16BitOut                =(1 << 10),
 kStereoOut              = (1 << 11),

 kReverse              =   (1 << 16)  , /*action flags*/
 kRateConvert         =    (1 << 17),
 kCreateSoundSource     =  (1 << 18),

 kHighQuality        =     (1 << 22)   ,/*performance flags*/
 kRealTime             =   (1 << 23)
};

enum {
/*quality flags*/
 kBestQuality       =      (1 << 0)    /*use interp. in rate conv.*/
};
/*Data Format Flags

You can use constants to set or clear flag bits in the outputFlags parameter passed to the OpenMixerSoundComponent routine. These flags specify the format of the data your sound output device component expects to receive. See [link] for information about the OpenMixerSoundComponent function.

Most of these flags are ignored unless the kNoMixing flag is set, because a sound output device component cannot perform data modifications such as sample rate conversion or sample size conversion unless it is also able to mix sound sources. 
#define kNoMixing                           (1 << 0)        /don't mix sources*
#define kNoSampleRateConversion             (1 << 1)        *don't convert sample rate*
#define kNoSampleSizeConversion             (1 << 2)        /don't convert sample size*
#define kNoSampleFormatConversion                       \
                                            (1 << 3)        /*don't convert sample format*
#define kNoChannelConversion                (1 << 4)        /don't convert stereo/mono*
#define kNoDecompression                    (1 << 5)        /don't decompress*
#define kNoVolumeConversion                 (1 << 6)        /don't apply volume*
#define kNoRealtimeProcessing               (1 << 7)        /don't run at interrupt time*
*/
enum {
kNoMixing                        =   (1 << 0),        /*don't mix sources*/
kNoSampleRateConversion =            (1 << 1),        /*don't convert sample rate*/
kNoSampleSizeConversion   =          (1 << 2) ,       /*don't convert sample size*/
kNoSampleFormatConversion =                   (1 << 3) ,       /*don't convert sample format*/
kNoChannelConversion           =     (1 << 4)      ,  /*don't convert stereo/mono*/
kNoDecompression                  =  (1 << 5)        ,/*don't decompress*/
kNoVolumeConversion                = (1 << 6)       , /*don't apply volume*/
kNoRealtimeProcessing              = (1 << 7)        /*don't run at interrupt time*/
};


/*Constants

This section lists the constants that were added to QuickTime after an early release. Most of the constants are used as flags for QuickTime functions; they allow the programmer to pass numeric data as a meaningful name.#define kFix1 = (0x00010000);             / fixed point value equal to 1.0 
#define gestaltQuickTime 'qtim'            Movie Toolbox availability 
#define MovieFileType 'MooV'                movie file type 
#define VideoMediaType 'vide'             / video media type 
#define SoundMediaType 'soun'             / sound media type 
#define MediaHandlerType 'mhlr'           / media handler type /
#define DataHandlerType 'dhlr'            / data handler type 
#define TextMediaType 'text'              / text media type 
#define GenericMediaType 'gnrc'           / base media handler type 
#define DoTheRightThing = 0L              / indicates default flag settings
                                                 for Movie Toolbox functions /  
/ sound volume values in trackVolume parameter of NewMovieTrack function /
#define kFullVolume         = 0x100       / full, natural volume
                                                 (8.8 format) / 
#define kNoVolume           =   0         / no volume /
/ constants for whichMediaTypes parameter of GetMovieNextInterestingTime
    function /
#define VisualMediaCharacteristic 'eyes'  / visual media /
#define AudioMediaCharacteristic 'ears'   / audio media /
 
enum
{
/ media quality settings in quality parameter of SetMediaQuality function /
    mediaQualityDraft           = 0x0000,    / lowest quality level /
    mediaQualityNormal          = 0x0040,    / acceptable quality level /
    mediaQualityBetter          = 0x0080,    / better quality level /
    mediaQualityBest            = 0x00C0     / best quality level /
};
 
/values for callBackFlags field of QuickTime callback header structure used
    by clock components to communicate scheduling information about a
    callback event to the Movie Toolbox /
enum
{
    qtcbNeedsRateChanges           = 1,    / rate changes /
    qtcbNeedsTimeChanges           = 2,    / time changes /
    qtcbNeedsStartStopChanges      = 4     / time base changes at start &
                                                stop times / 
};
 
/ dialog items to include in dialog box definition for use with
    SFPGetFilePreview function /
enum
{
    sfpItemPreviewAreaUser         = 11,       / user preview area /
    sfpItemPreviewStaticText       = 12,       / static text preview /
    sfpItemPreviewDividerUser      = 13,       / user divider preview /
    sfpItemCreatePreviewButton     = 14,       / create preview button /
    sfpItemShowPreviewButton       = 15        / show preview button /
};
 
enum
{                       
    movieInDataForkResID           = -1        / magic resource ID /
};
 
/ flags for LoadIntoRAM functions /
enum
{
    keepInRam                  = 1<<0,     / load and make so data  
                                                 cannot be purged / 
    unkeepInRam                = 1<<1,     / mark data so it can be purged / 
    flushFromRam               = 1<<2,     / empty handles and purge data
                                                 from memory / 
    loadForwardTrackEdits      = 1<<3,     / load only data around track edits;
                                                 play movie forward / 
    loadBackwardTrackEdits     = 1<<4      / load only data around edits;
                                                 play movie in reverse / 
};
 
/ flag for PasteHandleIntoMovie function /
enum
{
    pasteInParallel = 1         / changes function to take contents and type of
                                     handle and add to movie / 
};
 
/ text description display flags used in TextMediaAddTextSample and
      TextMediaAddTESample /
enum
{
    dfDontDisplay           = 1<<0,   / don't display the text /
    dfDontAutoScale         = 1<<1,   / don't scale text as track
                                           bounds grows or shrinks / 
    dfClipToTextBox         = 1<<2,   / clip update to the text box /
    dfUseMovieBGColor       = 1<<3,   / set text background to movie's
                                           background color / 
    dfShrinkTextBoxToFit    = 1<<4,   / compute minimum box to fit the
                                           sample / 
    dfScrollIn              = 1<<5,   / scroll text in until last of
                                           text is in view / 
    dfScrollOut             = 1<<6    / scroll text out until last of text is
                                           gone (if dfScrollIn is also set, 
                                           scroll in then out) / 
    dfHorizScroll           = 1<<7,   / scroll text horizontally; otherwise,
                                           it's vertical / 
    dfReverseScroll         = 1<<8    / vertically scroll down and horizontally
                                         scroll up; justification-dependent / 
};
 
/ find flags for TextMediaFindNextText function /
    findTextEdgeOK           = 1<<0,     / OK to find text at specified
                                              sample time / 
    findTextCaseSensitive    = 1<<1,     / case-sensitive search /
    findTextReverseSearch    = 1<<2,     / search from sampleTime backward /
    findTextWraparound       = 1<<3,     / wrap search when beginning or end
                                              of movie is reached /  
 
/ return display flags for application-defined text function /
enum
{
    txtProcDefaultDisplay    = 0,        / use the media's default settings /
    txtProcDontDisplay       = 1,        / don't display the text /
    txtProcDoDisplay         = 2         / display the text /
};
 
enum
{
hintsScrubMode               = 1<<0,    / toolbox can display key frames when
                                              movie is repositioned / 
hintsAllowInterlace          = 1<<6,    / use interlace option for compressor
                                              components / 
hintsUseSoundInterp          = 1<<7     / turn on sound interpolation /
};
typedef unsigned long playHintsEnum;*/
enum {
kFullVolume         = 0x100      , /* full, natural volume
                                                 (8.8 format) */ 
 kNoVolume           =   0         /* no volume */
};

/*Action Flags

You can use constants to specify the action flags in the actions parameter of the SoundComponentPlaySourceBuffer function. See [link] for information about this function. 
#define kSourcePaused                       (1 << 0)
#define kPassThrough                        (1 << 16)
#define kNoSoundComponentChain              (1 << 17)
Constant descriptions

kSourcePaused 
If this bit is set, the component chain is configured to play the specified sound but the playback is initially paused. In this case, your SoundComponentStartSource function must be called to begin playback. If this bit is clear, the playback begins immediately once the component chain is set up and configured.

kPassThrough 
If this bit is set, the Sound Manager passes all data through to the sound output device component unmodified. A sound output device component that can handle any sample rate and sound format described in a sound parameter block should set this bit.

kNoSoundComponentChain 
If this bit is set, the Sound Manager does not construct a component chain for processing the sound data.*/
enum {
kSourcePaused =                      (1 << 0),
kPassThrough     =                   (1 << 16),
kNoSoundComponentChain  =            (1 << 17)
};


/*Sound Component Information Selectors

The Sound Manager calls your sound component's SoundComponentGetInfo and SoundComponentSetInfo functions to determine the capabilities of your component and to change those capabilities. It passes those functions a sound component information selector in the function's selector parameter to specify the type of information it wants to get or set. The available sound component information selectors are defined by constants.

Most of these selectors can be passed to both SoundComponentGetInfo and SoundComponentSetInfo . Some of them, however, can be sent to only one or the other. 
#define siChannelAvailable                  'chav'      *number of channels available*
#define siCompressionAvailable              'cmav'      *compression types available*
#define siCompressionFactor                 'cmfa'     *current compression factor*
#define siCompressionType                   'comp'      *current compression type*
#define siHardwareMute                      'hmut'      *current hardware mute state*
#define siHardwareVolume                    'hvol'      *current hardware volume*
#define siHardwareVolumeSteps               'hstp'      /number of hardware volume steps*
#define siHeadphoneMute                     'pmut'      *current headphone mute state*
#define siHeadphoneVolume                   'pvol'      *current headphone volume*
#define siHeadphoneVolumeSteps              'hdst'      *num. of headphone volume steps*
#define siNumberChannels                    'chan'      *current number of channels*
#define siQuality                           'qual'      *current quality*
#define siRateMultiplier                    'rmul'      *current rate multiplier*
#define siSampleRate                        'srat'      *current sample rate*
#define siSampleRateAvailable               'srav'      *sample rates available*
#define siSampleSize                        'ssiz'      *current sample size*
#define siSampleSizeAvailable               'ssav'      *sample sizes available*
#define siSpeakerMute                       'smut'      *current speaker mute*
#define siSpeakerVolume                     'svol'      *current speaker volume
#define siVolume                            'volu'      *current volume setting*
Constant descriptions 

siChannelAvailable 
Get the maximum number of channels this sound component can manage, as well as the channels themselves. The infoPtr parameter points to a record of type SoundInfoList , which contains an integer (the number of available channels) and a handle to an array of integers (which represent the channel numbers themselves).

siCompressionAvailable 
Get the number and list of compression types this sound component can manage. The infoPtr parameter points to a record of type SoundInfoList , which contains the number of compression types, followed by a handle that references a list of compression types, each of type OSType .

siCompressionFactor 
Get information about the current compression type. The infoData parameter points to a compression information record (see [link] ).

siCompressionType 
Get or set the current compression type. The infoPtr parameter points to a buffer of type OSType , which is the compression type. 

siHardwareMute 
Get or set the current mute state of the audio hardware. A value of 0 indicates that the hardware is not muted, and a value of 1 indicates that the hardware is muted. Not all sound components need to support this selector; it's intended for sound output device components whose associated hardware can be muted.

siHardwareVolume 
Get or set the current volume level of all sounds produced on the sound output device. The infoPtr parameter points to a long integer, where the high-order word represents the right volume level and the low-order word represents the left volume level. A volume level is specified by an unsigned 16-bit number: 0x0000 represents silence and 0x0100 represents full volume. (You can use the constant kFullVolume for full volume.) You can specify values larger than 0x0100 to overdrive the volume, although doing so might result in clipping. This selector applies to the volume of the output device, whereas the siVolume selector applies to the volume of a specific sound channel and its component chain. If a sound output device supports more than one output port (for example, both headphones and speakers), the siHardwareVolume selector applies to all those ports.

siHardwareVolumeSteps 
Get the number of audible volume levels supported by the audio hardware. If the device supports a range of volume levels (for example, 0x000 to 0x1000), you should return only the number of levels that are audible. The Sound Manager uses this information to handle the volume slider in the Alert Sounds control panel. 

siHeadphoneMute 
Get or set the current mute state of the headphone. A value of 0 indicates that the headphone is not muted, and a value of 1 indicates that the headphone is muted. Not all sound components need to support this selector; it's intended for sound output device components whose associated headphone can be muted.

siHeadphoneVolume 
Get or set the current volume level of all sounds produced on the headphone. The infoPtr parameter points to a long integer, where the high-order word represents the right volume level and the low-order word represents the left volume level. A volume level is specified by an unsigned 16-bit number: 0x0000 represents silence and 0x0100 represents full volume. (You can use the constant kFullVolume for full volume.) You can specify values larger than 0x0100 to overdrive the volume, although doing so might result in clipping. This selector applies to the volume of the headphones.

siHeadphoneVolumeSteps 
Get the number of audible volume levels supported by the headphones. If the headphones support a range of volume levels (for example, 0x000 to 0x1000), you should return only the number of levels that are audible.

siNumberChannels 
Get or set the current number of audio channels currently being managed by the sound component. The infoPtr parameter points to an integer, which is the number of channels. For example, for stereo sounds, this integer should be 2.

siQuality 
Get or set the current quality setting for the sound component. The  infoPtr parameter points to a 32-bit value, which typically determines how much processing should be applied to the audio data stream.

siRateMultiplier 
Get or set the current rate multiplier for the sound component. The infoPtr parameter points to a buffer of type UnsignedFixed , which is the multiplier to be applied to the playback rate of the sound, independent of the base sample rate of the sound. For example, if the current rate multiplier is 2.0, the sound is played back at twice the speed specified in the sampleRate field of the sound component data record.

siSampleRate 
Get or set the current sample rate of the data being output by the sound component. The infoPtr parameter points to a buffer of type UnsignedFixed , which is the sample rate.

siSampleRateAvailable 
Get the range of sample rates this sound component can handle. The infoPtr parameter points to a record of type SoundInfoList , which is the number of sample rates the component supports, followed by a handle to a list of sample rates, each of type UnsignedFixed . The sample rates can be in the range 0 to 65535.65535. If the number of sample rates is 0, then the first two sample rates in the list define the lowest and highest values in a continuous range of sample rates.

siSampleSize 
Get or set the current sample size of the audio data being output by the sound component. The infoPtr parameter points to an integer, which is the sample size in bits.

siSampleSizeAvailable 
Get the range of sample sizes this sound component can handle. The infoPtr parameter points to a record of type SoundInfoList , which is the number of sample sizes the sound component supports, followed by a handle. The handle references a  list of sample sizes, each of type Integer . Sample sizes are specified in bits.

siSpeakerMute 
Get or set the current mute state of the speakers. A value of 0 indicates that the speakers are not muted, and a value of 1 indicates that the speakers are muted. Not all sound components need to support this selector; it's intended for sound output device components whose associated speakers can be muted.

siSpeakerVolume 
Get or set the current volume level of all sounds produced on the speakers. The infoPtr parameter points to a long integer, where the high-order word represents the right volume level and the low-order word represents the left volume level. A volume level is specified by an unsigned 16-bit number: 0x0000 represents silence and 0x0100 represents full volume. (You can use the constant kFullVolume for full volume.) You can specify values larger than 0x0100 to overdrive the volume, although doing so might result in clipping. This selector applies to the volume of the speakers.

siVolume 
Get or set the current volume level of the sound component. The infoPtr parameter points to a long integer, where the high-order word represents the right volume level and the low-order word represents the left volume level. A volume level is specified by an unsigned 16-bit number: 0x0000 represents silence and 0x0100 represents full volume. (You can use the constant kFullVolume for full volume.) You can specify values larger than 0x0100 to overdrive the volume, although doing so might result in clipping. This selector applies to the volume of a specific sound channel and its component chain, while the siHardwareVolume selector applies to the volume of the output device.*/

enum {
siChannelAvailable           =       'chav',      /*number of channels available*/
siCompressionAvailable     =         'cmav',      /*compression types available*/
siCompressionFactor           =      'cmfa'   ,   /*current compression factor*/
siCompressionType               =    'comp'   ,   /*current compression type*/
siHardwareMute                      ='hmut'      ,/*current hardware mute state*/
siHardwareVolume                   = 'hvol'     , /*current hardware volume*/
siHardwareVolumeSteps           =    'hstp'  ,    /*number of hardware volume steps*/
siHeadphoneMute                     ='pmut'     , /*current headphone mute state*/
siHeadphoneVolume                  = 'pvol'     , /*current headphone volume*/
siHeadphoneVolumeSteps           =   'hdst'  ,    /*num. of headphone volume steps*/
siNumberChannels                    ='chan'    ,  /*current number of channels*/
siQuality                           ='qual'      ,/*current quality*/
siRateMultiplier                   = 'rmul'    ,  /*current rate multiplier*/
siSampleRate                       = 'srat'    ,  /*current sample rate*/
siSampleRateAvailable           =    'srav' ,     /*sample rates available*/
siSampleSize                        ='ssiz'      ,/*current sample size*/
siSampleSizeAvailable            =   'ssav' ,     /*sample sizes available*/
siSpeakerMute                       ='smut'     , /*current speaker mute*/
siSpeakerVolume                    = 'svol'    ,  /*current speaker volume*/
siVolume                            ='volu'      /*current volume setting*/
};

/*#define kFullVolume         = 0x100       /* full, natural volume*/
//enum {
//kFullVolume         = 0x100
//};


/*Sound Parameter Blocks

The Sound Manager passes a component's SoundComponentPlaySourceBuffer function a sound parameter block that describes the source data to be modified or sent to a sound output device. A sound parameter block is defined by the SoundParamBlock data type.
struct SoundParamBlock {
    long                        recordSize;         *size of this record in bytes*
    SoundComponentData          desc;               /*description of sound buffer*
    Fixed                       rateMultiplier;     *rate multiplier*
    short                       leftVolume;         *volume on left channel*
    short                       rightVolume;        *volume on right channel*
    long                        quality;            /quality*
    ComponentInstance           filter;             *filter*
    SoundParamProcPtr           moreRtn;            *routine to call to get more data*
    SoundParamProcPtr           completionRtn;      /buffer complete routine*
    long                        refCon;             /user refcon*
    short                       result;             /result*
};
typedef struct SoundParamBlock SoundParamBlock;
typedef SoundParamBlock *SoundParamBlockPtr;

recordSize 
The length, in bytes, of the sound parameter block.

desc 
A sound component data record that describes the format, size, and location of the sound data. See "Sound Component Data Records" for a description of the sound component data record.

rateMultiplier 
A multiplier to be applied to the playback rate of the sound. This field contains an unsigned fixed-point number. If, for example, this field has the value 2.0, the sound is played back at twice the rate specified in the sampleRate field of the sound component data record contained in the desc field.

leftVolume 
The playback volume for the left channel. You specify a volume with 16-bit value, where 0 (hexadecimal 0x0000) represents no volume and 256 (hexadecimal 0x0100) represents full volume. You can overdrive a channel's volume by passing volume levels greater than 0x0100.

rightVolume 
The playback volume for the right channel. You specify a volume with 16-bit value, where 0 (hexadecimal 0x0000) represents no volume and 256 (hexadecimal 0x0100) represents full volume. You can overdrive a channel's volume by passing volume levels greater than 0x0100.

quality 
The level of quality for the sound. This value usually determines how much processing should be applied during audio data processing (such as rate conversion and decompression) to increase the output quality of the sound.

filter 
Reserved for future use. You should set this field to nil . 

moreRtn 
A pointer to a callback routine that is called to retrieve another buffer of audio data. This field is used internally by the Sound Manager.

completionRtn 
A pointer to a callback routine that is called when the sound has finished playing. This field is used internally by the Sound Manager.

refCon 
A value that is to be passed to the callback routines specified in the moreRtn and completionRtn fields. You can use this field to pass information (for example, the address of a structure) to a callback routine.

result 
The status of the sound that is playing. The value 1 indicates that the sound is currently playing. The value 0 indicates that the sound has finished playing. Any negative value indicates that some error has occurred.*/
struct SoundParamBlock {
    long                        recordSize;         /*size of this record in bytes*/
    SoundComponentData          desc;               /*description of sound buffer*/
    Fixed                       rateMultiplier;     /*rate multiplier*/
    short                       leftVolume;         /*volume on left channel*/
    short                       rightVolume;        /*volume on right channel*/
    long                        quality;            /*quality*/
    ComponentInstance           filter;             /*filter*/
    SoundParamProcPtr           moreRtn;            /*routine to call to get more data*/
    SoundParamProcPtr           completionRtn;      /*buffer complete routine*/
    long                        refCon;             /*user refcon*/
    short                       result;             /*result*/
};
typedef struct SoundParamBlock SoundParamBlock;
typedef SoundParamBlock *SoundParamBlockPtr;

/*ExtendedSoundComponentData

The ExtendedSoundComponentData structure is shown below.
struct ExtendedSoundComponentData {
SoundComponentData  desc;  /description of sound buffer*
        long   recordSize; /size of this record in bytes*
        long   extendedFlags; /flags for extended record*
        long   bufferSize; /size of buffer in bytes*
};
  typedef struct ExtendedSoundComponentData ExtendedSoundComponentData;
  typedef ExtendedSoundComponentData * ExtendedSoundComponentDataPtr; 

Its first element is a classic SoundComponentData allowing a pointer to a SoundComponentData to also serve as a pointer to an ExtendedSoundComponentData. This means that in parts of the component API where a SoundComponentData was passed or retrieved, it is now possible to find an ExtendedSoundComponentData.

To determine if the SoundComponentData is an ExtendedSoundComponentData, you can check the following flag in the flags field of a SoundComponentData:
kExtendedSoundData = (1 << 14) 

If set, you know that the structure consists at least of the fields shown here -- namely, recordSize, extendedFlags and bufferSize. In the future, it is expected that the set of fields will be extended, so it is important to confirm that the fields you want to read are actually present. To that end, you should compare the recordSize field's value to the size of a record containing the fields you need. If the record size is smaller, then you know the fields are missing.

The bufferSize field holds the number of bytes in the buffer. This allows for cases where the number of bytes isn't derivable directly from the number of samples. In the cases where it is derivable, this information is at worst redundant. The extendedFlags holds fields relating to the interpretation of the new fields and to the interpretation of the old fields. The fields defined currently are:
kExtendedSoundSampleCountNotValid = 1L << 0
kExtendedSoundBufferSizeValid     = 1L << 1 

The kExtendedSoundBufferSizeValid flag indicates if the bufferSize field is valid. If not set, then you shouldn't use the bufferSize field's value. In the case of the 4.1 sound media handler, the buffer size is now passed so this flag is set.

The kExtendedSoundSampleCountNotValid is slightly more unusual. This allows a buffer of audio of bufferSize bytes to not declare the number of audio samples that it will generate. Note that if this flag is set, the bufferSize field must be valid and the kExtendedSoundBufferSizeValid flag must be set.

While this ability to not specify the sample count is of little use in the sound media handler case where the sample references already describe the durations of all the samples, it may prove more useful in other cases.

One such case involves sound conversion where the decompressor is asked to generate audio samples until a source buffer is exhausted. Instead of requiring that we know the number of source audio samples before decompression, this allows the client to just feed audio until there is no more. Another case involves playback where durations aren't known. In both cases, it seems advantageous to not have to ask the decompressor to parse all the data just to determine the number of audio samples only to pass that number back to the decompressor so that it can parse and actually decode the data.

From the sound decompressor's point of view, this is the most important new structure and is available from the decompressor's call to its source's SoundComponentGetSourceData call. Keep in mind that the structure returned may not be an ExtendedSoundComponentData, so be careful to check.*/
struct ExtendedSoundComponentData {
SoundComponentData  desc;  /*description of sound buffer*/
        long   recordSize; /*size of this record in bytes*/
        long   extendedFlags; /*flags for extended record*/
        long   bufferSize; /*size of buffer in bytes*/
//hys define
int commonFrameSize;
};
  typedef struct ExtendedSoundComponentData ExtendedSoundComponentData;
  typedef ExtendedSoundComponentData * ExtendedSoundComponentDataPtr; 

/*Compression Information Record
typedef struct {
   long           recordSize;
   OSType         format;
   short          compressionID;
   short          samplesPerPacket;
   short          bytesPerPacket;
   short          bytesPerFrame;
   short          bytesPerSample;
   short          futureUse1;
} CompressionInfo, *CompressionInfoPtr, **CompressionInfoHandle;*/
typedef struct {
   long           recordSize;
   OSType         format;
   short          compressionID;
   short          samplesPerPacket;
   short          bytesPerPacket;
   short          bytesPerFrame;
   short          bytesPerSample;
   short          futureUse1;
} CompressionInfo, *CompressionInfoPtr, **CompressionInfoHandle;

//function

/*Saving and Restoring Sound Component Preferences
pascal OSErr SetSoundPreference
		(OSType type, Str255 name, Handle settings);
pascal OSErr GetSoundPreference
		(OSType type, Str255 name, Handle settings);*/
pascal OSErr SetSoundPreference
		(OSType type, Str255 name, Handle settings);
pascal OSErr GetSoundPreference
		(OSType type, Str255 name, Handle settings);

/*SoundComponentGetSourceData
A utility component must implement the SoundComponentGetSourceData function. A sound output device component calls this function on its source component when it needs more data.

pascal ComponentResult SoundComponentGetSourceData 
                           (ComponentInstance ti, 
                              SoundComponentDataPtr *sourceData);
ti 
A component instance that identifies your sound component. 
sourceData 
On output, a pointer to a sound component data record that specifies the type and location of the data your component has processed. 
DESCRIPTION
Your SoundComponentGetSourceData function is called when the sound component immediately following your sound component in the sound component chain needs more data. Your function should generate a new block of audio data, fill out a sound component data record describing the format and location of that data, and then return the address of that record in the sourceData parameter.

Your SoundComponentGetSourceData function might itself need to get more data from its source component. To do this, call through to the source component's SoundComponentGetSourceData function. If your component cannot generate any more data, it should set the sampleCount field of the sound component data record to 0 and return noErr.

IMPORTANT 
Sound output device components do not need to implement this function, but all utility components must implement it.  
RESULT CODES
Your SoundComponentGetSourceData function should return noErr if successful or an appropriate result code otherwise.*/
pascal ComponentResult SoundComponentGetSourceData 
                           (ComponentInstance ti, 
                              SoundComponentDataPtr *sourceData);


/*SoundConverterBeginConversion
pascal OSErr SoundConverterBeginConversion(SoundConverter sc);

SoundConverterBeginConversion starts a conversion. All state information is reset to default values in preparation for a new input buffer.

This routine can be called at interrupt time.*/
pascal OSErr SoundConverterBeginConversion(SoundConverter sc);

/*SoundConverterGetBufferSizes 
pascal OSErr SoundConverterGetBufferSizes(
                     SoundConverter sc,
                                         unsigned long targetBytes, 
                     unsigned long *inputFrames,
                                         unsigned long *inputBytes, 
                     unsigned long *outputBytes);

SoundConverterGetBufferSizes is used to determine the input and output buffer sizes for a given target size. This is so you can make sure your buffers will fit the conversion parameters established with SoundConverterOpen .

The targetBytes parameter is the approximate number of bytes you would like both your input and output buffers to be. The inputFrames and inputBytes parameters return the actual size you should make your input buffer, in frames and bytes, respectively. The outputBytes parameter returns the size in bytes for your output buffer.

The returned input and output buffer sizes can be larger than your target size settings. This is because they are rounded up depending on the format, but they will be very close to the target settings. Also note that the input and output sizes may be very different, depending on the input and output formats given in SoundConverterOpen . The sizes are calculated assuming you will convert all data in the input buffer to the output buffer.*/
pascal OSErr SoundConverterGetBufferSizes(
                     SoundConverter sc,
                                         unsigned long targetBytes, 
                     unsigned long *inputFrames,
                                         unsigned long *inputBytes, 
                     unsigned long *outputBytes);

/*SoundConverterEndConversion
pascal OSErr SoundConverterEndConversion(
                     SoundConverter sc, 
                     void *outputPtr, 
                     unsigned long *outputFrames, 
                     unsigned long *outputBytes);

SoundConverterEndConversion ends a conversion. Any data remaining in the converters is flushed out and returned here.

This routine can be called at interrupt time.*/
pascal OSErr SoundConverterEndConversion(
                     SoundConverter sc, 
                     void *outputPtr, 
                     unsigned long *outputFrames, 
                     unsigned long *outputBytes);


/*Opening and Closing the Apple Mixer Component
pascal OSErr OpenMixerSoundComponent
		(SoundComponentDataPtr outputDescription, 
		long outputFlags, 
		ComponentInstance *mixerComponent);
pascal OSErr CloseMixerSoundComponent
		(ComponentInstance ci);
Saving and Restoring Sound Component Preferences
pascal OSErr SetSoundPreference
		(OSType type, Str255 name, Handle settings);
pascal OSErr GetSoundPreference
		(OSType type, Str255 name, Handle settings);
Sound Component-Defined Routines
Managing Sound Components
pascal ComponentResult SoundComponentInitOutputDevice
		(ComponentInstance ti, long actions);
pascal ComponentResult SoundComponentSetSource
		(ComponentInstance ti, SoundSource sourceID,
		ComponentInstance source);
pascal ComponentResult SoundComponentGetSource
		(ComponentInstance ti, SoundSource sourceID,
		ComponentInstance *source);
pascal ComponentResult SoundComponentGetSourceData
		(ComponentInstance ti, 
		SoundComponentDataPtr *sourceData);
pascal ComponentResult SoundComponentSetOutput
		(ComponentInstance ti, 
		SoundComponentDataPtr requested, SoundComponentDataPtr *actual);
Creating and Removing Audio Sources
pascal ComponentResult SoundComponentAddSource
		(ComponentInstance ti, SoundSource *sourceID);
pascal ComponentResult SoundComponentRemoveSource
		(ComponentInstance ti, SoundSource sourceID);
Getting and Setting Sound Component Information
pascal ComponentResult SoundComponentGetInfo
		(ComponentInstance ti, SoundSource sourceID,
		OSType selector, void *infoPtr);
pascal ComponentResult SoundComponentSetInfo
		(ComponentInstance ti, SoundSource sourceID,
		OSType selector, void *infoPtr);
Managing Source Data
pascal ComponentResult SoundComponentStartSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentStopSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentPauseSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentPlaySourceBuffer
		(ComponentInstance ti, SoundSource sourceID, SoundParamBlockPtr pb, long actions);*/
pascal OSErr OpenMixerSoundComponent
		(SoundComponentDataPtr outputDescription, 
		long outputFlags, 
		ComponentInstance *mixerComponent);
pascal OSErr CloseMixerSoundComponent
		(ComponentInstance ci);


pascal ComponentResult SoundComponentInitOutputDevice
		(ComponentInstance ti, long actions);
pascal ComponentResult SoundComponentSetSource
		(ComponentInstance ti, SoundSource sourceID,
		ComponentInstance source);
pascal ComponentResult SoundComponentGetSource
		(ComponentInstance ti, SoundSource sourceID,
		ComponentInstance *source);

pascal ComponentResult SoundComponentSetOutput
		(ComponentInstance ti, 
		SoundComponentDataPtr requested, SoundComponentDataPtr *actual);

pascal ComponentResult SoundComponentAddSource
		(ComponentInstance ti, SoundSource *sourceID);
pascal ComponentResult SoundComponentRemoveSource
		(ComponentInstance ti, SoundSource sourceID);

pascal ComponentResult SoundComponentGetInfo
		(ComponentInstance ti, SoundSource sourceID,
		OSType selector, void *infoPtr);
pascal ComponentResult SoundComponentSetInfo
		(ComponentInstance ti, SoundSource sourceID,
		OSType selector, void *infoPtr);

pascal ComponentResult SoundComponentStartSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentStopSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentPauseSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentPlaySourceBuffer
		(ComponentInstance ti, SoundSource sourceID, SoundParamBlockPtr pb, long actions);

/*New Sound Manager APIs 

In addition to two new SoundManagerGetInfo and SoundManagerSetInfo calls, there is a new Sound Converter API in QuickTime 4.1, which is discussed in the next section. Note that this new API is now the recommended way to use the Sound Converter.
SoundManagerGetInfo
pascal OSErr
SoundManagerGetInfo(OSType selector, void* infoPtr); 

This routine retrieves global information about the Sound Manaager.

Defined selectors:
siSupportedExtendedFlags

Retrieves which flags are supported in Extended sound data structures in an unsigned long.

SoundManagerSetInfo
pascal OSErr
SoundManagerSetInfo(OSType selector, void* infoPtr); 

This routine sets global information about the Sound Manager.

Defined selectors: none
SoundConverterFillBuffer

Provides an alternative method for converting data using the Sound Converter, which is both more predictable and more flexible than the SoundConverterConvertBuffer mechanism. The SoundConverterFillBuffer function can return any Sound Manager error.
pascal OSErr    SoundConverterFillBuffer( SoundConverter sc,
                     SoundConverterFillBufferDataUPP  fillBufferDataUPP,
                     void* fillBufferDataRefCon,
                     void* outputBuffer,
                     unsigned long outputBufferByteSize,
                     unsigned long* bytesWritten,
                     unsigned long* framesWritten,
                     unsigned long* outputFlags
                     ) 
sc 
The Sound Converter context to work with (created with SoundConverterOpen).

fillBufferDataUPP

A UPP that points to a routine that can provide data to the Sound Converter.

fillBufferDataRefCon

This value is passed to the SoundConverterFillBufferDataUPP. It can be used for any purpose the client wishes.

outputBuffer

The buffer to write the data into.

outputBufferByteSize

The size of outputBuffer in bytes. No more than this amount will ever be written during a single call to SoundConverterFillBuffer.

bytesWritten

Upon completion, the number of bytes that were written into outBuffer.

framesWritten

Upon completion, the number of sample frames written into outBuffer.

outputFlags 
 

Upon completion, a set of bit flags that indicate the state of the conversion. These are the currently defined flags:

kSoundConverterDidntFillBuffer

Set if the converter didn't completely fill the output buffer.

kSoundConverterHasLeftOverData

Set if the converter still has more data to deliver. This indicates that more calls to SoundConvertFillBuffer should be made to complete the conversion. A caveat: If this flag is not set, it doesn't indicate there is necessarily more data in the pipeline. These are advisor flags only: they don't guarantee any internal data. You need to keep track of your data. 

Working with SoundConverterFillBuffer
Writing the SoundConverterFillBufferData Routine*/
pascal OSErr
SoundManagerGetInfo(OSType selector, void* infoPtr); 
pascal OSErr
SoundManagerSetInfo(OSType selector, void* infoPtr);
pascal OSErr    SoundConverterFillBuffer( SoundConverter sc,
                     SoundConverterFillBufferDataUPP  fillBufferDataUPP,
                     void* fillBufferDataRefCon,
                     void* outputBuffer,
                     unsigned long outputBufferByteSize,
                     unsigned long* bytesWritten,
                     unsigned long* framesWritten,
                     unsigned long* outputFlags
                     );

/*Allocating and Releasing Sound Channels
pascal OSErr SndNewChannel  (SndChannelPtr *chan, short synth, long init,
                             SndCallBackProcPtr userRoutine);
pascal OSErr SndDisposeChannel
                            (SndChannelPtr chan, Boolean quietNow);*/
pascal OSErr SndNewChannel  (SndChannelPtr *chan, short synth, long init,
                             SndCallBackProcPtr userRoutine);
pascal OSErr SndDisposeChannel
                            (SndChannelPtr chan, Boolean quietNow);

/*Controlling Volume Levels
pascal OSErr GetSysBeepVolume
                    (long *level);
pascal OSErr SetSysBeepVolume
                    (long level);
pascal OSErr GetDefaultOutputVolume
                    (long *level);
pascal OSErr SetDefaultOutputVolume
                    (long level);*/
pascal OSErr SetDefaultOutputVolume
                    (long level);

/*ParseSndHeader
pascal OSErr ParseSndHeader(
                     SndListHandle sndHandle,
                                         SoundComponentData *sndInfo, 
                     unsigned long *numFrames,
                                         unsigned long *dataOffset);

The ParseSndHeader routine returns information describing the audio data in the given 'snd ' resource handle. The sndHandle parameter specifies the sound handle to use. The sndInfo parameter is a SoundComponentData structure that returns the following information about the format of the sound in the handle:

flags 
Always returns 0


format 
The sound format (i.e., 'raw', 'twos', 'MAC3', etc.)


numChannels 
The number of channels (i.e., 1 = mono, 2 = stereo)


sampleSize 
The sample size (i.e., 8 = 8-bit, 16 = 16-bit)


sampleRate 
The sampling rate (in samples/second)


sampleCount 
The number of audio samples in the file


buffer 
Always returns 0


reserved 
Always returns 0


The numFrames parameter returns the number of frames of audio data in the handle, and the dataOffset parameter returns the byte offset of the first audio sample in the handle.*/
pascal OSErr ParseSndHeader(
                     SndListHandle sndHandle,
                                         SoundComponentData *sndInfo, 
                     unsigned long *numFrames,
                                         unsigned long *dataOffset);

/*Obtaining Information
pascal NumVersion SndSoundManagerVersion
                            (void);
pascal NumVersion MACEVersion
                            (void);
pascal OSErr SndControl     (short id, SndCommand *cmd);
pascal OSErr SndChannelStatus
                            (SndChannelPtr chan, short theLength,
                             SCStatusPtr theStatus);
pascal OSErr SndManagerStatus
                            (short theLength, SMStatusPtr theStatus);
pascal void SndGetSysBeepState
                            (short *sysBeepState);
pascal OSErr SndSetSysBeepState
                            (short sysBeepState);
pascal OSErr GetSoundHeaderOffset
                            (Handle sndHandle, long *offset);*/
pascal OSErr GetSoundHeaderOffset
                            (Handle sndHandle, long *offset);

/*SndGetInfo and SndSetInfo
extern pascal OSErr SndGetInfo(
                     SndChannelPtr chan, OSType selector, 
                     void *infoPtr);
extern pascal OSErr SndSetInfo(
                     SndChannelPtr chan, OSType selector, 
                     const void *infoPtr);

The two new routines SndGetInfo and SndSetInfo are used to get and set information about the sound environment. Both routines use a selector based interface similar to the SPBGetDeviceInfo and SPBSetDeviceInfo routines found in the Sound Input Manager, and in fact they use the same sound information selectors.

SndGetInfo and SndSetInfo operate on an open Sound Manager channel, and can be used to retrieve and change information about the channel, including hardware settings. These routines should be used instead of attempting to communicate directly with sound components.

These new calls are only available with Sound Manager version 3.1 or later. Check for this by calling SndSoundManagerVersion for the installed version. Note that you can always open a sound channel for the hardware device that you desire by passing kUseOptionalOutputDevice as the synth parameter and the component reference as the init parameter.
OSErr OpenChannel(OSType myType)
{
    ComponentDescription   searching;
    Component              outputDevice;
    OSErr                  err;

    // search for a sound output device component
    searching.componentType = kSoundOutputDeviceType;
    searching.componentSubType = myType;
    searching.componentManufacturer = kAnyComponentManufacturer;
    searching.componentFlags = 0;
    searching.componentFlagsMask = kAnyComponentFlagsMask;
    outputDevice = nil;
    outputDevice = FindNextComponent(outputDevice, &searching);

    if (outputDevice == nil)
        err = cantFindHandler; /component not found*
    else
    {
        gChan = nil;
        err = SndNewChannel(&gChan, kUseOptionalOutputDevice,
                            (long)outputDevice, nil);
    }
    return (err);
}

For example, to determine the current hardware sampling rate of the given sound channel you may use this code:
UnsignedFixed sampleRate;
err = SndGetInfo(gChan, siSampleRate, &sampleRate);
GetSoundOutputInfo() and SetSoundOutputInfo()
pascal OSErr GetSoundOutputInfo(Component outputDevice, OSType selector,
                                void *infoPtr);
pascal OSErr SetSoundOutputInfo(Component outputDevice, OSType selector,
                                const void *infoPtr);

These two routines get and set information about the sound environment: GetSoundOutputInfo and SetSoundOutputInfo . Both routines use a selector based interface similar to the SPBGetDeviceInfo and SPBSetDeviceInfo routines found in the Sound Input Manager, and in fact they use the same sound info selectors.

GetSoundOutputInfo and SetSoundOutputInfo operate directly on a sound output device, and can be used to retrieve and change information about the hardware settings. These routines should be used instead of attempting to communicate directly with sound output components. Setting the output device parameter to nil causes the default output device to be used. These calls are similar to GetSndInfo and SetSndInfo but do not require an opened sound channel. For example, to determine the sampling rate of the sound hardware on the default output device, you could use this code:
OSErr GetCurrentSampleRate(UnsignedFixed *sampleRate)
    {   
OSErr err;
    err = GetSoundOutputInfo(nil, siSampleRate, sampleRate);
return (err);
}*/
extern pascal OSErr SndGetInfo(
                     SndChannelPtr chan, OSType selector, 
                     void *infoPtr);

/*SoundConverterConvertBuffer
pascal OSErr SoundConverterConvertBuffer(
                     SoundConverter sc,
                                         const void *inputPtr, unsigned long inputFrames,
                                         void *outputPtr, unsigned long *outputFrames,
                                         unsigned long *outputBytes);

SoundConverterConvertBuffer converts a buffer of data from the input format to the output format. The inputPtr parameter points to the input data, and inputFrames gives the number of frames in that buffer. The outputPtr parameter specifies where the output data should be placed. The outputFrames and outputBytes parameters return the number of frames and bytes placed in the output buffer respectively.

This routine will consume all the data in the input buffer. Depending on the complexity of the conversion, however, not all the converted data may be put in the output buffer right away. The SoundConverterEndConversion routine is used to flush out all this remaining data before a conversion session is closed.

If you are using this routine in conjunction with SoundConverterGetBufferSizes , it is very important that you do not pass in a value in inputFrames larger than the frames value returned by SoundConverterGetBufferSizes , or you will overflow your output buffer. The SoundConverterConvertBuffer calls converts ALL the input data! This routine can be called at interrupt time.*/
pascal OSErr SoundConverterConvertBuffer(
                     SoundConverter sc,
                                         const void *inputPtr, unsigned long inputFrames,
                                         void *outputPtr, unsigned long *outputFrames,
                                         unsigned long *outputBytes);

/*Sending Commands to a Sound Channel
pascal OSErr SndDoCommand   (SndChannelPtr chan, const SndCommand *cmd,
                             Boolean noWait);
pascal OSErr SndDoImmediate
                            (SndChannelPtr chan, const SndCommand *cmd);*/
pascal OSErr SndDoImmediate
                            (SndChannelPtr chan, const SndCommand *cmd);
pascal OSErr SndDoCommand   (SndChannelPtr chan, const SndCommand *cmd,
                             Boolean noWait);

/*ParseAIFFHeader
pascal OSErr ParseAIFFHeader(
                     short fRefNum, SoundComponentData *sndInfo,
                                         unsigned long *numFrames, 
                     unsigned long *dataOffset);

The ParseAIFFHeader routine returns information describing the audio data in the given AIFF file. The fRefNum parameter specifies the open AIFF file to use. The sndInfo parameter is a SoundComponentData structure that returns the following information about the format of the sound in the AIFF file:

flags 
Always returns 0


format 
The sound format (i.e., 'raw', 'twos', 'MAC3', etc.)


numChannels 
The number of channels (i.e., 1 = mono, 2 = stereo)


sampleSize 
The sample size (i.e., 8 = 8-bit, 16 = 16-bit)


sampleRate 
The sampling rate (in samples/second)


sampleCount 
The number of audio samples in the file


buffer 
Always returns 0


reserved 
Always returns 0


The numFrames parameter returns the number of frames of audio data in the file, and the dataOffset parameter returns the byte offset of the first audio sample in the file.*/
pascal OSErr ParseAIFFHeader(
                     short fRefNum, SoundComponentData *sndInfo,
                                         unsigned long *numFrames, 
                     unsigned long *dataOffset);

/*GetCompressionInfo
pascal OSErr GetCompressionInfo(
                     short compressionID, OSType format,
                                         short numChannels, short sampleSize, CompressionInfoPtr cp);

For a given AIFF file or snd resource, the information contained within it might be used to determine basic characteristics of the sound such as its duration.
duration = numSampleFrames / sampleRate

Note that this is a valid calculation for an uncompressed sound. But this calculation returns an incorrect result for a compressed sound. The problem here is that each sample frame in a compressed sound is composed of one or more packets rather than sample points (see "Sampled-Sound Data" ), and each packet in that compressed sound can itself represent several sample points. We therefore need a way to determine the number of samples in a packet in order to get an accurate calculation.

The compressionID parameter defines the compression algorithm used on the sample. The AIFF-C Extended Common Chunk does not contain a compressionID field. In this case (and when using snd resources where the OSType describing the compression format is known) you should always pass the constant fixedCompression in this parameter and the OSType in the format parameter. The format field will then contain the OSType representing the compression format. If you set the compressionID field in a compressed sound header to any value other than fixedCompression , then the format field is set to zero. The format parameter is the OSType describing the format of the compressed sound data. If you pass the constant fixedCompression in the compressionID parameter you will need to pass a valid compression type here. Some of the valid format types are:
NONE - sound is not compressed
MAC3 - compression format is MACE 3:1
MAC6 - compression format is MACE 6:1
ima4 - compression format is IMA 4:1

There are some snd resources that do not store an OSType in the format field of the compressed sound header describing the compression format. You can still use GetCompressionInfo in this case by passing in the compressionID and passing 0 in the format parameter. The correct OSType will be returned in the format field of the CompressionInfo structure. Using the appropriate fields from an AIFF-C Extended Common Chunk or our snd resource compressed sound header, we can make the call to GetCompressionInfo :*/
pascal OSErr GetCompressionInfo(
                     short compressionID, OSType format,
                                         short numChannels, short sampleSize, CompressionInfoPtr cp);

/*Opening and Closing Sound Input Devices
pascal  OSErr SPBOpenDevice (ConstStr255Param deviceName, short permission,
                             long *inRefNum);
pascal OSErr SPBCloseDevice
                            (long inRefNum);*/
pascal  OSErr SPBOpenDevice (ConstStr255Param deviceName, short permission,
                             long *inRefNum);
pascal OSErr SPBCloseDevice
                            (long inRefNum);

/*Manipulating Device Settings
pascal  OSErr SPBGetDeviceInfo
                         (long inRefNum, OSType infoType, 
                          char *infoData);
pascal  OSErr SPBSetDeviceInfo
                         (long inRefNum, OSType infoType, 
                          char *infoData);*/
pascal  OSErr SPBGetDeviceInfo
                         (long inRefNum, OSType infoType, 
                          char *infoData);
pascal  OSErr SPBSetDeviceInfo
                         (long inRefNum, OSType infoType, 
                          char *infoData);



#ifdef __cplusplus
}
#endif

#endif