#ifndef LISTS_H
#define LISTS_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif



#include <HYS/HIToolbox/Lists.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Selection Flags


enum {
   lOnlyOne = -128,
   lExtendDrag = 64,
   lNoDisjoint = 32,
   lNoExtend = 16,
   lNoRect = 8,
   lUseSense = 4,
   lNoNilHilite = 2
};
Constants
lOnlyOne

Specify this value if you wish to allow only one item to be selected at once.

Available in Mac OS X v10.0 and later.
lExtendDrag

Specify this value if you wish to enable selection of multiple items by dragging without the Shift key.

Available in Mac OS X v10.0 and later.
lNoDisjoint

Specify this value if you wish to prevent discontiguous selections using the Command key.

Available in Mac OS X v10.0 and later.
lNoExtend

Specify this value if you wish to prevent extending Shift key selections. All items are deselected before responding to Shift-click.

Available in Mac OS X v10.0 and later.
lNoRect

Specify this value if you wish to select all items in the cursor’s path during Shift-drag.

Available in Mac OS X v10.0 and later.
lUseSense

Specify this value if you wish to allow the user to deselect one or more items using the Shift key

Available in Mac OS X v10.0 and later.
lNoNilHilite

Specify this value if you wish to disable the highlighting of empty cells.

Available in Mac OS X v10.0 and later.
Discussion

The ListRec structure uses these values in the selFlags field to indicate the List Manager’s default selection algorithm. Use these values additively to select more than one selection option.*/

enum {
   lOnlyOne = -128,
   lExtendDrag = 64,
   lNoDisjoint = 32,
   lNoExtend = 16,
   lNoRect = 8,
   lUseSense = 4,
   lNoNilHilite = 2
};


/*DataPtr


typedef  char * DataPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef  char * DataPtr;

/*DataHandle


typedef  DataPtr * DataHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef  DataPtr * DataHandle;

/*List Definition Constants


enum {
   lInitMsg = 0,
   lDrawMsg = 1,
   lHiliteMsg = 2,
   lCloseMsg = 3
};
Constants
lInitMsg

In response to the lInitMsg message, your list definition function should perform any special initialization needed for a list. For example, the function might set fields of the list record, such as the cellSize and indent fields, to appropriate values. Your list definition function does not necessarily need to do anything in response to the initialization message. If it does nothing, then memory is still allocated for the list, and fields of the list record are set to the same values as they would be set to if the default list definition function were being used.

Available in Mac OS X v10.0 and later.
lDrawMsg

Your list definition function should draw the cell specified by the theCell parameter after receiving an lDrawMsg message. The function must ensure that it does not draw anywhere but within the rectangle specified by the cellRect parameter. If the selected parameter is TRUE, then your list definition function should draw the cell in its highlighted state; otherwise, it should draw the cell without highlighting. When drawing, your list definition function should take care not to permanently change any characteristics of the drawing environment.

Available in Mac OS X v10.0 and later.
lHiliteMsg

Your list definition function should respond to the lHiliteMsg message by reversing the selection status of the cell contained within the rectangle specified by the cellRect parameter. If a cell is highlighted, your list definition function should remove the highlighting; if a cell is not highlighted, your list definition function should highlight it.

Available in Mac OS X v10.0 and later.
lCloseMsg

The List Manager sends your list definition function an lCloseMsg message before it disposes of a list and its data. Your list definition function need only respond to this message if additional memory has been allocated for the list. For example, your list definition function might allocate a relocatable block in response to the lInitMsg message. In this case, your list definition function would need to dispose of this relocatable block in response to the lCloseMsg message. Or, if your list definition function defines cells simply to contain pointers or handles to data stored elsewhere in memory, it would need to dispose of that memory in response to the lCloseMsg message.

Available in Mac OS X v10.0 and later.
Discussion

The List Manager passes these values to your ListDefProcPtr function to identify the operation to be performed.*/

enum {
   lInitMsg = 0,
   lDrawMsg = 1,
   lHiliteMsg = 2,
   lCloseMsg = 3
};


/*ListDefType


typedef UInt32 ListDefType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 ListDefType;

/*Cell


typedef Point Cell;
Discussion

The Cell data type defines a cell record. The functions LGetSelect , LSetSelect , LSetCell , LAddToCell , LClrCell , LGetCellDataLocation , LGetCell , LDraw , LSearch , LNextCell , LRect , and LLastClick use the Cell data type to specify the coordinates of a cell in a list.

Note that column and row numbers are 0-based. Also note that this reference designates cells using the notation (column–1, row–1), so that a cell with coordinates (2,5) is in the third column and sixth row of a list. You specify a cell with coordinates (2,5) by setting the cell’s h field to 2 and its v field to 5. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef Point Cell;


/*ListBounds


typedef Rect ListBounds;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Rect ListBounds;



/*kListDefProcPtr


enum {
   kListDefProcPtr = 0,
   kListDefUserProcType = kListDefProcPtr,
   kListDefStandardTextType = 1,
   kListDefStandardIconType = 2
};
Constants
kListDefProcPtr

Available in Mac OS X v10.0 and later.
kListDefUserProcType

Available in Mac OS X v10.0 and later.
kListDefStandardTextType

Available in Mac OS X v10.0 and later.
kListDefStandardIconType

Available in Mac OS X v10.0 and later.
lDrawingModeOff*/
enum {
   kListDefProcPtr = 0,
   kListDefUserProcType = kListDefProcPtr,
   kListDefStandardTextType = 1,
   kListDefStandardIconType = 2
};

/*ListClickLoopProcPtr

Defines a pointer to a list click loop callback function. Your list click loop callback function overrides the standard click-loop function that is used to select cells and automatically scroll a list.

typedef Boolean (*ListClickLoopProcPtr)
(
);

If you name your function MyListClickLoopProc, you would declare it like this:

Boolean MyListClickLoopProc ();
Parameters
Return Value

A value indicating whether the LClick function should continue tracking the mouse. Your function should return TRUE if you wish LClick to continue to track the mouse, and FALSE if LClick should stop and return immediately. 
Discussion

If your application defines a custom click-loop function, then the LClick function repeatedly calls the function until the user releases the mouse button. A click-loop function may perform any processing desired when it is executed. 

Because no parameters are passed to the click-loop function, your click-loop function probably needs to access a global variable that contains a handle to the list record, which contains information about the location of the cursor and other information potentially of interest to a click-loop function. You might also create a global variable that stores the state of the modifier keys immediately before a call to the LClick function. You would need to set these global variables immediately before calling LClick.

The pointer to your function, which you provide in the list record structure, should be a universal procedure pointer (UPP). The definition of the UPP data type for your list click loop function is as follows:typedef (ListClickLoopProcPtr) ListClickLoopUPP;


Before using your list click loop function, you must first create a new universal procedure pointer to it, using the NewListClickLoopUPP function, as shown here:ListClickLoopUPP MyListClickLoopUPP;
MyListClickLoopUPP = NewListClickLoopUPP(&MyListClickLoopProc)


You then use MyListClickLoopUPP in the lClickLoop field of the ListRec structure for your list. The LClick function calls your list click loop function while the user holds down the mouse button. If you wish to call your own list click loop function, you can use the InvokeListClickLoopUPP function:continueTracking = InvokeListClickLoopUPP(MyListClickLoopUPP);


When you are finished using your list click loop callback function, you should dispose of the universal procedure pointer associated with it, using the DisposeListClickLoopUPP function.DisposeListClickLoopUPP(MyListClickLoopUPP);


A click-loop function does not execute at interrupt time. Instead, it is called directly by the LClick function. Thus, a click-loop function can allocate memory, and it does not need to adjust the value contained in the A5 register. 
Special Considerations

A click-loop function does not execute at interrupt time. Instead, it is called directly by the LClick function. Thus, a click-loop function can allocate memory, and it does not need to adjust the value contained in the A5 register.*/

typedef Boolean (*ListClickLoopProcPtr)
(
);


/*ListClickLoopUPP


typedef ListClickLoopProcPtr ListClickLoopUPP;
Discussion

For more information, see the description of the ListClickLoopUPP () callback function.*/
typedef ListClickLoopProcPtr ListClickLoopUPP;


/*ListRec


struct ListRec {
   Rect rView;
   GrafPtr port;
   Point indent;
   Point cellSize;
   ListBounds visible;
   ControlRef vScroll;
   ControlRef hScroll;
   SInt8 selFlags;
   Boolean lActive;
   SInt8 lReserved;
   SInt8 listFlags;
   long clikTime;
   Point clikLoc;
   Point mouseLoc;
   ListClickLoopUPP lClickLoop;
   Cell lastClick;
   long refCon;
   Handle listDefProc;
   Handle userHandle;
   ListBounds dataBounds;
   DataHandle cells;
   short maxIndex;
   short cellArray[1];
};
typedef struct ListRec ListRec;
typedef ListRec * ListPtr;
typedef ListPtr * ListHandle
Fields
rView

The rectangle in which the list’s visible rectangle is located, in local coordinates of the graphics port specified by the port field. Note that the list’s visible rectangle does not include the area needed for the list’s scroll bars. The width of a vertical scroll bar (which equals the height of a horizontal scroll bar) is 15 pixels.
port

The graphics port of the window containing the list. 
indent

The location, relative to the upper-left corner of a cell, at which drawing should begin. List definition functions should set this field to a value appropriate to the type of data that a cell in a list is to contain.
cellSize

The size in pixels of each cell in the list. When your application creates a list, it can either specify the cell size or let the List Manager calculate the cell size. You should not change the cellSize field directly; if you need to change the cell size after creating a list, use the LCellSize function.
visible

The cells in a list that are visible within the area specified by the rView field. The List Manager sets the left and top fields of visible to the coordinates of the first visible cell; however, the List Manager sets the right and bottom fields so that each is 1 greater than the horizontal and vertical coordinates of the last visible cell. For example, if a list contains 4 columns and 10 rows but only the first 2 columns and the first 5 rows are visible (that is, the last visible cell has coordinates (1,4)), the List Manager sets the visible field to (0,0,2,5). 
vScroll

A control handle for a list’s vertical scroll bar, or NULL if a list does not have a vertical scroll bar. 
hScroll

A control handle for a list’s horizontal scroll bar, or NULL if a list does not have a horizontal scroll bar.
selFlags

Indicates the selection flags for a list. When your application creates a list, the List Manager clears the selFlags field to 0. This defines the List Manager’s default selection algorithm. To change the default behavior for a particular list, set the desired bits in the list’s selFlags field. See “Selection Flags”.
lActive

Indicates whether the list is active (TRUE if active, FALSE if inactive).
lReserved

Reserved.
listFlags

Indicates whether the List Manager should automatically scroll the list if the user clicks the list and then drags the cursor outside the list display rectangle. See “List Flags” for the values used in this field.

By default, the List Manager enables horizontal autoscrolling for a list if the list includes a horizontal scroll bar, and enables vertical autoscrolling for a list if the list includes a vertical scroll bar.
clikTime

The time in ticks of the last click in the list. If your application depends on the value contained in this field, then your application should update the field if the application selects a list item in response to keyboard input.
clikLoc

The location in local coordinates of the last click in the list.
mouseLoc

Indicates the current location of the cursor in local coordinates. This value is continuously updated by the LClick function after the user clicks a list.
lClickLoop

A universal procedure pointer to your click loop callback function, which is repeatedly called by the LClick function, or NULL if the default click-loop function is to be used. 
lastClick

The coordinates of the last cell in the list that was clicked. This may not be the same as the last cell selected if the user selects a range of cells by Shift-dragging or Command-dragging. If your application depends on the value contained in this field, then your application should update the field whenever your application selects a list item in response to keyboard input. 
refCon

4 bytes for use by your application.
listDefProc

A handle to the code for the list definition function that defines how the list is drawn.
userHandle

4 bytes that your application can use as needed. For example, your application might use this field to store a handle to additional storage associated with the list. However, the LDispose function does not automatically release this storage when disposing of the list.
dataBounds

The range of cells in a list. When your application creates a list, it specifies the initial bounds of the list. As your application adds rows and columns, the List Manager updates this field. The List Manager sets the left and top fields of dataBounds to the coordinates of the first cell in the list; the List Manager sets the right and bottom fields so that each is 1 greater than the horizontal and vertical coordinates of the last cell. For example, if a list contains 4 columns and 10 rows (that is, the last cell in the list has coordinates (3,9)), the List Manager sets the dataBounds field to (0,0,4,10).
cells

A handle to a relocatable block used to store cell data. Your application should not change the contents of this relocatable block directly. 
maxIndex

Used internally.
cellArray

Offsets to data that indicate the location of different cells’ data within the data handle specified by the cells parameter. Your application should not access this field directly.
Discussion

Functions in the List Manager interface use the ListHandle datatype to identify a list. The ListHandle type uses a ListRec structure to maintain information about a list. The ListRec data type defines a list record. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ListRec {
   Rect rView;
   GrafPtr port;
   Point indent;
   Point cellSize;
   ListBounds visible;
   ControlRef vScroll;
   ControlRef hScroll;
   SInt8 selFlags;
   Boolean lActive;
   SInt8 lReserved;
   SInt8 listFlags;
   long clikTime;
   Point clikLoc;
   Point mouseLoc;
   ListClickLoopUPP lClickLoop;
   Cell lastClick;
   long refCon;
   Handle listDefProc;
   Handle userHandle;
   ListBounds dataBounds;
   DataHandle cells;
   short maxIndex;
   short cellArray[1];
};
typedef struct ListRec ListRec;
typedef ListRec * ListPtr;
typedef ListPtr * ListHandle;

/*ListDefProcPtr

Defines a pointer to a list definition callback function. Your list definition callback function defines a custom list display.

typedef void (*ListDefProcPtr) (
   SInt16 lMessage,
   Boolean lSelect,
   Rect *lRect,
   Cell lCell,
   SInt16 lDataOffset,
   SInt16 lDataLen,
   ListHandle lHandle
);

If you name your function MyListDefProc, you would declare it like this:

void MyListDefProc (
   SInt16 lMessage,
   Boolean lSelect,
   Rect * lRect,
   Cell lCell,
   SInt16 lDataOffset,
   SInt16 lDataLen,
   ListHandle lHandle
);
Parameters
lMessage

A value that identifies the operation to be performed. See “List Definition Constants”. 
lSelect

Indicates whether the cell specified by the lCell parameter should be highlighted. This parameter is defined only for the lDrawMessage and lHiliteMsg messages. 
lRect

A pointer to the rectangle (in local coordinates of the list’s graphics port) that encloses the specified cell. Although this parameter is defined as a pointer, your list definition function must not change the coordinates of the rectangle. This parameter is defined only for the lDrawMessage and lHiliteMsg messages. 
lCell

The coordinates of the cell to be drawn or highlighted. This parameter is defined only for the lDrawMessage and lHiliteMsg messages. 
lDataOffset

The location of the cell data associated with the specified cell. The location is specified as an offset from the beginning of the relocatable block referenced by the cells field of the list record. This parameter is defined only for the lDrawMessage and lHiliteMsg messages.
lDataLen

The length in bytes of the cell data associated with the specified. This parameter is defined only for the lDrawMessage and lHiliteMsg messages.
lHandle

A handle to the list for which a message is being sent. Your application can access the list’s list record, or it can call List Manager functions to manipulate the list. 
Discussion

Your application can write a list definition function to customize list display. For example, you can write a list definition function to support the display of color icons. A custom list definition function must be compiled as a code resource of type 'LDEF' and added to the resource file of the application that needs to use it. 

The List Manager calls your list definition function whenever an application using the function creates a new list with the LNew function, needs a cell to be drawn, needs a cell’s highlighting state to be reversed, or has called the LDispose function to dispose of a list.

The pointer to your list definition function should be a universal procedure pointer (UPP). The definition of the UPP data type for your definition function is as follows:typedef (ListDefProcPtr) ListDefUPP;


Before using your list definition function, you must first create a new universal procedure pointer to it, using the NewListDefUPP function, as shown here:ListDefUPP MyListDefUPP;
MyListDefUPP = NewListDefUPP(&MyListDefProc)


The List Manager automatically invokes your list definition function when a new list is created. If you wish to call your own list definition callback function, you can use the InvokeListDefUPP function:InvokeListDefUPP(lMessage, lSelect, &lRect, lCell, lDataOffset,                      lDataLen, lHandle, MyListDefUPP)


When you are finished with your list definition function, you should dispose of the universal procedure pointer associated with it, using the DisposeListDefUPP function.DisposeListDefUPP(MyListDefUPP);


Because a list definition function is stored in a code resource, it cannot have its own global variables that it accesses through the A5 register. (Some development systems, however, may allow code resources to access global variables through some other register, such as A4. See your development system’s documentation for more information.) If your list definition function needs access to global data, it might store a handle to such data in the refCon or userHandle fields of the list record; however, applications would not then be able to use these fields for their own purposes. 
Special Considerations

Because a list definition function is stored in a code resource, it cannot have its own global variables that it accesses through the A5 register. (Some development systems, however, may allow code resources to access global variables through some other register, such as A4. See your development system’s documentation for more information.) If your list definition function needs access to global data, it might store a handle to such data in the refCon or userHandle fields of the list record; however, applications would not then be able to use these fields for their own purposes.*/
typedef void (*ListDefProcPtr) (
   SInt16 lMessage,
   Boolean lSelect,
   Rect *lRect,
   Cell lCell,
   SInt16 lDataOffset,
   SInt16 lDataLen,
   ListHandle lHandle
);


/*ListDefUPP


typedef ListDefProcPtr ListDefUPP;
Discussion

For more information, see the description of the ListDefUPP () callback function.*/
typedef ListDefProcPtr ListDefUPP;


/*ListDefSpec


struct ListDefSpec {
   ListDefType defType
   union {
      ListDefUPP userProc;
   } u;
};
typedef struct ListDefSpec ListDefSpec;
typedef ListDefSpec * ListDefSpecPtr;
Fields
defType
ListDefUPP
Availability
Available in Mac OS X v10.0 and later.*/

struct ListDefSpec {
   ListDefType defType;
   union {
      ListDefUPP userProc;
   } u;
};
typedef struct ListDefSpec ListDefSpec;
typedef ListDefSpec * ListDefSpecPtr;



/*ListRef


typedef ListHandle ListRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef ListHandle ListRef;


//functions 

/*LSize

Changes the size of a list.

void LSize (
   short listWidth,
   short listHeight,
   ListHandle lHandle
);
Parameters
listWidth

The new width (in pixels) of the list’s visible rectangle. 
listHeight

The new height (in pixels) of the list’s visible rectangle.
lHandle

The list whose size is being changed. 
Discussion

This function adjusts the lower-right side of the list so that the list’s visible rectangle is the width and height specified by the listWidth and listHeight parameters. 

Because the list’s visible rectangle does not include room for the scroll bars, your application should make listWidth 15 pixels less than the desired width of the list if it contains a vertical scroll bar, and it should make listHeight 15 pixels less than the desired height of the list if it contains a horizontal scroll bar.

The contents of the list and the scroll bars are adjusted and redrawn as necessary. However, this function does not draw a border around the list’s rectangle. Also, it does not erase any portions of the old list that may still be visible. This approach should not be a problem if your application only calls LSize after the user resizes a window containing a list in its lower-right corner.

Usually, you need to call this function only after calling the Window Manager function SizeWindow. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSize (
   short listWidth,
   short listHeight,
   ListHandle lHandle
);

/*LUpdate

Responds to an update event.

void LUpdate (
   RgnHandle theRgn,
   ListHandle lHandle
);
Parameters
theRgn

The visible region of the list’s port after a call to the Window Manager’s BeginUpdate function. 
lHandle

The list to be updated. 
Discussion

This function redraws all visible cells in the list specified by the lHandle parameter that intersect the region specified by the parameter theRgn. It also redraws the scroll bars if they intersect the region.

You should bracket calls to LUpdate by calls to the Window Manager functions BeginUpdate and EndUpdate. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LUpdate (
   RgnHandle theRgn,
   ListHandle lHandle
);

/*LDispose

Disposes of the memory associated with a list.

void LDispose (
   ListHandle lHandle
);
Parameters
lHandle

The list to be disposed of. 
Discussion

This function releases all memory allocated by the List Manager in creating a list. First, it issues a close request to the list definition function and calls the Control Manager function DisposeControl for the list’s scroll bars (if any). The function then uses the Memory Manager to free the memory referenced by the cells field, then disposes of the list record itself.

Because it disposes of data associated with cells in your list, there is no need to clear the data from list cells or to delete individual rows and columns before calling this function.

This function does not dispose of any memory associated with a list that the List Manager has not allocated. In particular, it does not dispose of any memory referenced by the userHandle field of the list record. Your application is responsible for deallocating any memory it has allocated through the userHandle field before calling this function. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Version Notes
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Lists.h*/

void LDispose (
   ListHandle lHandle
);

/*NewListDefUPP

Creates a new universal procedure pointer (UPP) to a list definition callback function.

ListDefUPP NewListDefUPP (
   ListDefProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ListDefUPP data type.
Discussion

See the ListDefProcPtr callback for more information. 
Special Considerations
Version Notes
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Lists.h*/

ListDefUPP NewListDefUPP (
   ListDefProcPtr userRoutine
);

/*CreateCustomList


OSStatus CreateCustomList (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cellSize,
   const ListDefSpec * theSpec,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert,
   ListHandle * outList
);
Parameters
rView
dataBounds
cellSize
theSpec
theWindow
drawIt
hasGrow
scrollHoriz
scrollVert
outList
Return Value

A result code.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

OSStatus CreateCustomList (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cellSize,
   const ListDefSpec * theSpec,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert,
   ListHandle * outList
);


/*LActivate

Activates or deactivates a list.

void LActivate (
   Boolean act,
   ListHandle lHandle
);
Parameters
act

Indicates whether the list should be activated. Specify TRUE to activate the list. Specify FALSE to deactivate the list. 
lHandle

The list to be activated or deactivated. 
Discussion

If a list is being deactivated, this function removes highlighting from selected cells and hides the scroll bars. If a list is being activated, the function highlights selected cells and shows the scroll bars.

This function has no effect on a list’s size box, if one exists. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

void LActivate (
   Boolean act,
   ListHandle lHandle
);

/*GetListViewBounds


Rect * GetListViewBounds (
   ListHandle list,
   Rect * view
);
Parameters
list
view
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

Rect * GetListViewBounds (
   ListHandle list,
   Rect * view
);

/*LClick

Processes a mouse-down event in a list.

Boolean LClick (
   Point pt,
   EventModifiers modifiers,
   ListHandle lHandle
);
Parameters
pt

The location in local coordinates of the mouse-down event. Your application can simply call GlobalToLocal(myEvent.where) and then pass myEvent.where in this parameter.

If the pt parameter specifies a portion of the list’s visible rectangle, then cells are selected with an algorithm that depends on the list’s selection flags and on the modifiers parameter. If the user drags the cursor above or below the list’s visible rectangle and vertical autoscrolling is enabled, then the List Manager vertically autoscrolls the list. If the user drags the cursor to the right or the left of the list’s visible rectangle and horizontal autoscrolling is enabled, then the List Manager horizontally autoscrolls the list.

If the pt parameter specifies a point within the list’s scroll bar, then the List Manager calls the scroll bar’s control definition function to track the cursor and it scrolls the list appropriately.
modifiers

An integer value corresponding to the modifiers field of the event record. 
lHandle

The list in which the mouse-down event occurred. 
Return Value

TRUE if the click was a double-click, or FALSE otherwise. 
Discussion

The LClick function handles all user interaction until the user releases the mouse button. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
Boolean LClick (
   Point pt,
   EventModifiers modifiers,
   ListHandle lHandle
);

/*LAddRow

Adds one or more rows to a list.

short LAddRow (
   short count,
   short rowNum,
   ListHandle lHandle
);
Parameters
count

The number of rows to add. 
rowNum

The row number of the first row to add.
lHandle

The list to add the rows to. 
Return Value

The row number of the first row added, which is equal to the value specified by the rowNum parameter if that value is a valid row number. If the row number specified by rowNum is not already in the list, then new last rows are added. The value returned by this function thus has significance only in this case. 
Discussion

This function inserts rows starting at the row specified by the rowNum parameter. If there is insufficient memory in the heap to add the new rows, the function may fail to add the new rows although it returns a positive function result. Be sure there is enough memory in the heap to allocate the new rows before calling this function.

Rows whose row numbers are initially greater than rowNum have their row numbers increased by count. 

If the automatic drawing mode is enabled and the rows added by this function are visible, then the list (including its scroll bars) is updated. New cells created by a call to this function are initially empty.

You may add rows to a list that does not yet have columns. The dataBounds field of the list record reflects that the list has rows, but you can only access cells when both rows and columns have been added. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

short LAddRow (
   short count,
   short rowNum,
   ListHandle lHandle
);

/*LSetCell

Changes the data contained in a cell.

void LSetCell (
   const void * dataPtr,
   short dataLen,
   Cell theCell,
   ListHandle lHandle
);
Parameters
dataPtr

A pointer to the new data for a cell. 
dataLen

The length in bytes of the new data. 
theCell

The coordinates of the cell to hold the new data. 
lHandle

The list containing the cell given in the theCell parameter. 
Discussion

Any previous cell data in theCell is replaced. If there is insufficient memory in the heap, the function may fail to set the cell’s data. If the cell coordinates specified by the theCell parameter are invalid, the function does nothing.

If the data of a visible cell is changed and the automatic drawing mode is enabled, the function updates the list. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetCell (
   const void * dataPtr,
   short dataLen,
   Cell theCell,
   ListHandle lHandle
);

/*LScroll

Scrolls a list a specified number of rows and columns.

void LScroll (
   short dCols,
   short dRows,
   ListHandle lHandle
);
Parameters
dCols

The number of columns to scroll. Specify a positive number to scroll down (that is, each cell moves up), and a negative number to scroll up. 
dRows

The number of rows to scroll. Specify a positive number to scroll right (that is, each cell moves left), and a negative number to scroll left.
lHandle

The list to be scrolled. 
Discussion

The List Manager will not scroll beyond the data bounds of the list. If the automatic drawing mode is enabled, this function does all necessary updating of the list. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LScroll (
   short dCols,
   short dRows,
   ListHandle lHandle
);

/*LNew

Creates a new list in a window.

ListHandle LNew (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cSize,
   short theProc,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert
);
Parameters
rView

A pointer to the rectangle in which to display the list, in local coordinates of the window specified by the theWindow parameter. This rectangle does not include the area to be taken up by the list’s scroll bars. 
dataBounds

A pointer to the initial data bounds for the list. By setting the left and top fields of this rectangle to (0,0) and the right and bottom fields to (kMyInitialColumns, kMyInitialRows), your application can create a list that has kMyInitialColumns columns and kMyInitialRows rows. 
cSize

The size of each cell in the list. If your application specifies (0,0) and is using the default list definition function, the List Manager sets the v coordinate of this parameter to the sum of the ascent, descent, and leading of the current font, and it sets the h coordinate using the following formula:

cSize.h = (rView.right - rView.left) / (dataBounds.right – dataBounds.left).
theProc

The resource ID of the list definition function to use for the list. To use the default list definition function, which supports the display of unstyled text, specify a resource ID of 0. 
theWindow

A pointer to the window in which to install the list. 
drawIt

Indicates whether the List Manager should initially enable the automatic drawing mode. When the automatic drawing mode is enabled, the List Manager automatically redraws the list whenever a change is made to it. You can later change this setting using the LSetDrawingMode function. Your application should leave the automatic drawing mode disabled only for short periods of time when making changes to a list (by, for example, adding rows and columns). 
hasGrow

Indicates whether the List Manager should leave room for a size box. The List Manager does not actually draw the grow icon. Usually, your application can draw it with the Window Manager’s DrawGrowIcon function.
scrollHoriz

Indicates whether the list should contain a horizontal scroll bar. Specify TRUE if your list requires a horizontal scroll bar; specify FALSE otherwise.
scrollVert

Indicates whether the list should contain a vertical scroll bar. Specify TRUE if your list requires a vertical scroll bar; specify FALSE otherwise.
Return Value

A handle to the newly created list, or if the function cannot allocate the list, NULL. This might happen if there is not enough memory available or if the function cannot load the resource specified by the theProc parameter. If it returns successfully, then all of the fields of the list record referenced by the returned handle are correctly set. See the description of the ListHandle data type.
Discussion

If the list contains a horizontal or vertical scroll bar and the window specified by the parameter theWindow is visible, this function draws the scroll bar for the new list in the window just outside the list’s visible rectangle specified by the rView parameter. This function does not, however, draw a 1-pixel border around the list’s visible rectangle. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
ListHandle LNew (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cSize,
   short theProc,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert
);

/*LSetSelect

Selects or deselects a cell.

void LSetSelect (
   Boolean setIt,
   Cell theCell,
   ListHandle lHandle
);
Parameters
setIt

Indicates whether the function should select or deselect the specified cell. Specify TRUE to select the cell. If the cell is already selected, the function does nothing. Specify FALSE to deselect the cell. If the cell is already deselected, the function does nothing. 
theCell

The cell to be selected or deselected. 
lHandle

The list containing the cell to be selected or deselected. 
Discussion

If a cell’s selection status is changed and the cell is visible, LSetSelect redraws the cell. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetSelect (
   Boolean setIt,
   Cell theCell,
   ListHandle lHandle
);

/*LSetDrawingMode

Changes the automatic drawing mode specified when creating a list. 

void LSetDrawingMode (
   Boolean drawIt,
   ListHandle lHandle
);
Parameters
drawIt

Indicates whether the List Manager should enable the automatic drawing mode. Specify TRUE to enable the automatic drawing mode. Specify FALSE to disable the automatic drawing mode. 
lHandle

The list whose drawing mode is being changed. 
Discussion

Your application can use the LSetDrawingMode function to enable or disable automatic drawing of lists. If your application uses LSetDrawingMode to temporarily disable list drawing, then it must call the LDraw function to draw a cell when its appearance changes, or when new rows or columns are added to the list. .

While the automatic drawing mode is turned off, all cell drawing and highlighting are disabled, and the scroll bar does not function properly. Thus, your application should disable the automatic drawing mode only for short periods of time. After enabling it, your application should ensure that the list is redrawn.

This function is also available as the LDoDraw function. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetDrawingMode (
   Boolean drawIt,
   ListHandle lHandle
);

/*LDelRow

Deletes one or more rows from a list.

void LDelRow (
   short count,
   short rowNum,
   ListHandle lHandle
);
Parameters
count

The number of rows to delete, or 0 to delete all rows. 
rowNum

The row number of the first row to delete.
lHandle

The list from which to delete the rows. 
Discussion

This function deletes rows starting at the row specified by the rowNum parameter. If the row specified by rowNum is invalid, then nothing is done.

Your application can quickly delete all rows from a list (and thus delete all cell data) simply by setting the count parameter to 0. The number of columns is left unchanged. Your application can achieve the same effect by setting the rowNum parameter to (**lHandle).dataBounds.top and setting the count parameter to a value greater than (**lHandle).dataBounds.bottom – (**lHandle).dataBounds.top.

Rows whose row numbers are initially greater than rowNum have their row numbers decreased by count.

If the automatic drawing mode is enabled and one or more of the rows deleted by the function are visible, then the list (including its scroll bars) is updated. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

void LDelRow (
   short count,
   short rowNum,
   ListHandle lHandle
);

/*LGetSelect

Gets information about which cells are selected.

Boolean LGetSelect (
   Boolean next,
   Cell * theCell,
   ListHandle lHandle
);
Parameters
next

Indicates whether the function should check only the cell specified by the parameter theCell, or whether it should try to find the next selected cell. If next is TRUE, then the function searches the list for the first selected cell beginning at the cell specified by theCell. (In particular, it first checks cells in row theCell.v, and then cells in the next row, and so on.) 

If next is FALSE, then the function checks only the cell specified by the parameter theCell.
theCell

On input, a pointer to the first cell whose selection status should be checked. If next is TRUE, then, on return this parameter is a pointer to the next selected cell greater than or equal to the cell specified on input. Otherwise, this parameter remains unchanged. 
lHandle

The list in which the selection is being checked. 
Return Value

TRUE if next is TRUE and the function finds a selected cell, or if next is FALSE and the cell specified by theCell is selected. If this function does not find a selected cell, FALSE. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
Boolean LGetSelect (
   Boolean next,
   Cell * theCell,
   ListHandle lHandle
);

/*LGetCell

Copies a cell’s data.

void LGetCell (
   void * dataPtr,
   short * dataLen,
   Cell theCell,
   ListHandle lHandle
);
Parameters
dataPtr

A pointer to the location to which to copy the cell’s data. 
dataLen

On input, a pointer to the maximum number of bytes to copy. On return, a pointer to the number of bytes actually copied. 
theCell

The cell whose data is to be copied. 
lHandle

The list containing the cell specified by the parameter theCell. 
Discussion

If the cell data is longer than dataLen, only dataLen bytes are copied and the dataLen parameter is unchanged. If the cell data is shorter than dataLen, then the function sets dataLen to the length in bytes of the cell’s data. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LGetCell (
   void * dataPtr,
   short * dataLen,
   Cell theCell,
   ListHandle lHandle
);

/*NewListClickLoopUPP

Creates a new universal procedure pointer (UPP) to a list click loop callback function.

ListClickLoopUPP NewListClickLoopUPP (
   ListClickLoopProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ListClickLoopUPP data type.
Discussion

See the ListClickLoopProcPtr callback for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
ListClickLoopUPP NewListClickLoopUPP (
   ListClickLoopProcPtr userRoutine
);



#ifdef __cplusplus
}
#endif

#endif